/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.biz.agent.DefaultMultiBillWorkAgent;
import com.kingdee.eas.basedata.hraux.DiplomaInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.affair.AffairRegFacadeFactory;
import com.kingdee.eas.hr.affair.AffairTypeEnum;
import com.kingdee.eas.hr.affair.ApproveStateEnum;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.HRAffairState;
import com.kingdee.eas.hr.affair.HireBillEntryInfo;
import com.kingdee.eas.hr.affair.HireBillFactory;
import com.kingdee.eas.hr.affair.HireBillInfo;
import com.kingdee.eas.hr.affair.IAffairRegFacade;
import com.kingdee.eas.hr.affair.IHireBill;
import com.kingdee.eas.hr.affair.client.AbstractHireBillSelfEditUI;
import com.kingdee.eas.hr.affair.client.HRAffairClientUtils;
import com.kingdee.eas.hr.affair.util.AffairUtil;
import com.kingdee.eas.hr.base.TechnicalPostInfo;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.org.client.JobGradePromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class HireBillSelfEditUI
extends AbstractHireBillSelfEditUI {
    private static Logger logger = Logger.getLogger(HireBillSelfEditUI.class);
    private KDNoteHelper appHlp = new KDNoteHelper();
    private String resClass = "com.kingdee.eas.hr.affair.HRAffairResource.";
    public static final String Hire_FILENAME = "/HR/OrgUnit/HireBill";
    private BOSUuid actPersonId;
    private String billId;
    private BOSUuid actEntryId;
    private boolean deleteFlag = false;
    protected BOSUuid entryId = null;

    protected void lockUIForViewStatus() {
        super.lockUIForViewStatus();
        this.dateHireDate.setEnabled(false);
        this.dateEnrollDate.setEnabled(false);
        this.txtRemark.setEditable(false);
        this.txtSumup.setEditable(false);
        this.txtAssessResult.setEnabled(false);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (OprtState.ADDNEW.equals(this.getOprtState()) || this.editData.getId() == null) {
            DefaultMultiBillWorkAgent agent = new DefaultMultiBillWorkAgent();
            agent.markNewBill((IObjectValue)this.editData, this.getUIContext());
        }
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    protected IObjectValue createNewData() {
        HireBillInfo info = new HireBillInfo();
        info.setIsMultiEntry(false);
        info.setApplyDate(DateTimeUtils.truncateDate((Date)new Date()));
        if (this.nowDate != null) {
            info.setApplyDate(this.nowDate);
        }
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return HireBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected void initOrgContextManager() {
    }

    @Override
    protected void registerContextChangeF7(IHRF7CommonRegister register) {
        this.promptOrg.setSelector((KDPromptSelector)new AdminByOrgRangePromptBox((IUIObject)this));
        this.promptOrg.setEditable(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData.getEntries() != null && this.editData.getEntries().size() > 0) {
            HireBillEntryInfo info = this.editData.getEntries().get(0);
            this.dateEnrollDate.setValue((Object)info.getEnrollDate());
            this.txtTryoutMonth.setText(String.valueOf(info.getTryoutMonth()));
            this.dateHireDate.setValue((Object)info.getHireDate());
            if (info.getAssessResult() != null) {
                this.txtAssessResult.setText(info.getAssessResult().setScale(2).toString());
            }
            if (info.getHireSalary() != null) {
                this.txtHireSalary.setText(info.getHireSalary().setScale(2).toString());
            }
            this.txtPosition.setText(info.getPosition());
            this.prmptPosition.setData((Object)info.getEposition());
            this.txtRemark.setText(info.getRemark());
            this.txtSumup.setText(info.getWorkSumup());
            this.promptJobGrade.setValue((Object)info.getJobGrade());
            this.pInfo = info.getPerson();
            this.personId = this.pInfo.getId();
            this.entryId = info.getId();
            this.combGender.setSelectedItem((Object)info.getGender());
            this.pkBirthday.setValue((Object)info.getBirthday());
            this.pkJobStartDate.setValue((Object)info.getJobStartDate());
            this.prmtDegree.setValue((Object)info.getHighestDegree());
            this.prmtTechPost.setValue((Object)info.getHighestTechPost());
            this.txtSpecity.setText(info.getSpecialty());
            this.txtYears.setValue((Object)info.getLenOfActualService());
            this.txtSelf.setText(info.getSelfAppraise());
            this.actEntryId = info.getId();
            this.actPersonId = this.personId;
            if (this.editData.getId() != null) {
                this.billId = this.editData.getId().toString();
            }
        }
    }

    public IObjectPK runSubmit() throws Exception {
        return ((IHireBill)this.getBizInterface()).submit2((CoreBaseInfo)this.editData);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setProposer(this.pInfo);
        this.editData.setIsMultiEntry(false);
        this.editData.setApproveState((ApproveStateEnum)((Object)this.comboSubmitType.getSelectedItem()));
        HireBillEntryInfo info = null;
        if (this.editData.getEntries() != null && this.editData.getEntries().size() > 0) {
            info = this.editData.getEntries().get(0);
        } else {
            info = new HireBillEntryInfo();
            this.editData.getEntries().add(info);
        }
        info.setPerson(this.pInfo);
        info.setNumber(this.txtNumber.getText());
        info.setPosition(this.txtPosition.getText());
        info.setEposition((PositionInfo)this.prmptPosition.getData());
        info.setPhone(this.txtPhone.getText());
        if (this.txtAssessResult.getValue() != null) {
            info.setAssessResult(HRAffairClientUtils.getBigDecimalValueByCell(this.txtAssessResult.getValue()).setScale(2));
        }
        if (this.txtHireSalary.getValue() != null) {
            info.setHireSalary(HRAffairClientUtils.getBigDecimalValueByCell(this.txtHireSalary.getValue()));
        }
        info.setEnrollDate((Date)this.dateEnrollDate.getValue());
        if (this.txtTryoutMonth.getText().trim().length() > 0) {
            info.setTryoutMonth(Integer.valueOf(this.txtTryoutMonth.getText().trim()));
        }
        info.setHireDate((Date)this.dateHireDate.getValue());
        info.setRemark(this.txtRemark.getText());
        info.setWorkSumup(this.txtSumup.getText());
        info.setJobGrade((JobGradeInfo)this.promptJobGrade.getValue());
        if (this.entryId != null) {
            info.setId(this.entryId);
        }
        if (this.combGender.getSelectedItem() != null) {
            info.setGender((Genders)this.combGender.getSelectedItem());
        }
        info.setBirthday((Date)this.pkBirthday.getValue());
        info.setHighestDegree((DiplomaInfo)this.prmtDegree.getData());
        info.setHighestTechPost((TechnicalPostInfo)this.prmtTechPost.getData());
        info.setJobStartDate((Date)this.pkJobStartDate.getValue());
        if (this.txtYears.getIntegerValue() != null) {
            info.setLenOfActualService(this.txtYears.getIntegerValue());
        }
        info.setSpecialty(this.txtSpecity.getText());
        info.setSelfAppraise(this.txtSelf.getText());
        String versionStr = null;
        try {
            versionStr = AffairUtil.getCurrentClientName();
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        if (OprtState.VIEW.equals(this.getOprtState()) && this.editData.getBizState().equals((Object)HRAffairState.COMPLETE)) {
            if (versionStr != null) {
                if (versionStr.equals("hnjt")) {
                    this.btnAffairReg.setVisible(true);
                    this.btnAffairReg.setEnabled(true);
                } else {
                    this.btnAffairReg.setVisible(false);
                    this.btnAffairReg.setEnabled(true);
                }
            } else {
                this.btnAffairReg.setVisible(false);
                this.btnAffairReg.setEnabled(false);
            }
        }
    }

    private void checkIsFormEmp(BOSUuid personId) throws Exception {
        PersonCollection c = PersonFactory.getRemoteInstance().getPersonCollection("select employeeType.id where id = '" + personId + "'");
        if (c.size() > 0 && c.get(0).getEmployeeType().getId().toString().equals("00000000-0000-0000-0000-000000000001A29E85B3")) {
            throw new HRAffairException(HRAffairException.HIRE_EMPLOYEETYPE_NOT_FORMAL);
        }
    }

    private EntityViewInfo getEntityViewInfoByCU(JobGradePromptBox jobGradeF7) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        CtrlUnitInfo ctrlInfo = null;
        HROrgUnitInfo hrOrg = (HROrgUnitInfo)this.prmtHROrg.getValue();
        if (hrOrg != null) {
            if (hrOrg.getCU() == null) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("cu.id"));
                selector.add(new SelectorItemInfo("cu.name"));
                selector.add(new SelectorItemInfo("cu.longNumber"));
                ctrlInfo = HROrgUnitFactory.getRemoteInstance().getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(hrOrg.getId()), selector).getCU();
            } else {
                ctrlInfo = hrOrg.getCU();
            }
        } else {
            ctrlInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        if (ctrlInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("toAdminCU.id", (Object)ctrlInfo.getId().toString()));
            HashSet<CtrlUnitInfo> set = new HashSet<CtrlUnitInfo>();
            set.add(ctrlInfo);
            jobGradeF7.changeContextByCUSet(set);
        }
        filter.getFilterItems().add(new FilterItemInfo("jobGradeModuleState.enable", (Object)"1"));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onLoad() throws Exception {
        if (this.getOprtState() == null || "null".equalsIgnoreCase(this.getOprtState())) {
            this.setOprtState(OprtState.ADDNEW);
            this.getUIContext().put("ID", null);
        }
        JobGradePromptBox jobGradeSel = new JobGradePromptBox((IUIObject)this);
        this.promptJobGrade.setSelector((KDPromptSelector)jobGradeSel);
        this.promptJobGrade.setQueryInfo("com.kingdee.eas.hr.org.app.JobGradeListQuery");
        this.promptJobGrade.setDisplayFormat("$name$");
        this.promptJobGrade.setEditFormat("$grade$");
        this.promptJobGrade.setCommitFormat("$grade$");
        this.kdtEntries.setVisible(false);
        this.lblHireSalary.setVisible(false);
        this.txtAssessResult.setDataType(4);
        this.txtAssessResult.setDataVerifierType(-1);
        this.txtAssessResult.setPrecision(2);
        this.txtAssessResult.setMaximumValue((Comparable)Float.valueOf("9999.99"));
        super.onLoad();
        if (null == this.editData.getId()) {
            this.actionRemove.setEnabled(false);
        }
        this.promptJobGrade.setEntityViewInfo(this.getEntityViewInfoByCU(jobGradeSel));
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.checkIsFormEmp(this.pInfo.getId());
            HRAffairClientUtils.checkIsPersonInProcess(this.editData.getBOSType(), new HireBillEntryInfo().getBOSType(), this.pInfo, "");
            ArrayList data = HRAffairClientUtils.getPersonDatas(this.pInfo.getId().toString());
            ArrayList postAndOrg = HRAffairClientUtils.getPersonPostAndOrgName(this.pInfo.getId().toString());
            ArrayList postOrg = HRAffairClientUtils.getPersonPostAndOrg(this.pInfo.getId().toString());
            if (data != null) {
                if (data.get(1) != null) {
                    this.txtPhone.setText(data.get(1).toString());
                }
                if (data.get(2) != null) {
                    this.dateEnrollDate.setValue(data.get(2));
                } else {
                    this.dateEnrollDate.setValue(null);
                }
                if (data.get(3) != null) {
                    this.txtTryoutMonth.setText(data.get(3).toString());
                }
                if (data.get(2) != null && data.get(3) != null) {
                    this.dateHireDate.setValue((Object)DateTimeUtils.addMonth((Date)((Date)data.get(2)), (int)((Integer)data.get(3))));
                }
                if (data.get(4) != null) {
                    this.pkBirthday.setValue(data.get(4));
                } else {
                    this.pkBirthday.setValue(null);
                }
                if (data.get(5) != null) {
                    this.pkJobStartDate.setValue(data.get(5));
                } else {
                    this.pkJobStartDate.setValue(null);
                }
                if (data.get(6) != null) {
                    this.txtYears.setValue(data.get(6));
                }
                this.combGender.setSelectedItem(data.get(7));
            }
            if (postAndOrg != null) {
                this.txtPosition.setText(postAndOrg.get(0).toString());
            }
            if (postOrg != null) {
                this.prmptPosition.setData(postOrg.get(0));
            }
            ArrayList perInfo = HRAffairClientUtils.getPerson(this.pInfo.getId().toString());
            this.prmtDegree.setValue(perInfo.get(0));
            this.prmtTechPost.setValue(perInfo.get(1));
            ArrayList degreeRelInfo = HRAffairClientUtils.getDegreeRelInfo(this.pInfo.getId().toString());
            if (degreeRelInfo != null) {
                this.txtSpecity.setText((String)degreeRelInfo.get(2));
            }
        }
        PositionInfo position = (PositionInfo)this.prmptPosition.getData();
        try {
            if (position != null && position.getId() == null) {
                // empty if block
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (this.getOprtState() == OprtState.ADDNEW) {
            this.promptJobGrade.setData((Object)HRAffairClientUtils.getJobGradeInfo(this.pInfo.getId().toString()));
        }
        this.kdtEntries.setColumnMoveable(true);
        this.setEnableByClient();
        this.setComboSubmitTypeValueByParam("ZZ001");
    }

    private void setEnableByClient() {
        String clientName = null;
        try {
            clientName = AffairUtil.getCurrentClientName();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if ("hnjt".equals(clientName)) {
            this.txtSelf.setVisible(true);
            this.lblSelf.setVisible(true);
        } else {
            this.txtSelf.setVisible(false);
            this.lblSelf.setVisible(false);
        }
    }

    @Override
    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.txtSumup.getText() == null || this.txtSumup.getText().trim().length() == 0) {
            this.txtSumup.requestFocusInWindow();
            throw new HRAffairException(HRAffairException.HIREBILL_SUMUP_NOT_NULL);
        }
        if (this.dateHireDate.getTimestamp() == null) {
            this.dateHireDate.requestFocusInWindow();
            throw new HRAffairException(HRAffairException.HIRE_DATE_NOT_NULL);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("adminOrg.id"));
        sic.add(new SelectorItemInfo("adminOrg.name"));
        sic.add(new SelectorItemInfo("adminOrg.number"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("hrOrgUnit.name"));
        sic.add(new SelectorItemInfo("hrOrgUnit.number"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("proposer.name"));
        sic.add(new SelectorItemInfo("proposer.id"));
        sic.add(new SelectorItemInfo("proposer.number"));
        sic.add(new SelectorItemInfo("dept"));
        sic.add(new SelectorItemInfo("phone"));
        sic.add(new SelectorItemInfo("applyDate"));
        sic.add(new SelectorItemInfo("isMultiEntry"));
        sic.add(new SelectorItemInfo("bizState"));
        sic.add(new SelectorItemInfo("approveState"));
        sic.add(new SelectorItemInfo("submitState"));
        sic.add(new SelectorItemInfo("entries.person.name"));
        sic.add(new SelectorItemInfo("entries.person.id"));
        sic.add(new SelectorItemInfo("entries.person.number"));
        sic.add(new SelectorItemInfo("entries.number"));
        sic.add(new SelectorItemInfo("entries.dept"));
        sic.add(new SelectorItemInfo("entries.phone"));
        sic.add(new SelectorItemInfo("entries.assessResult"));
        sic.add(new SelectorItemInfo("entries.hireSalary"));
        sic.add(new SelectorItemInfo("entries.enrollDate"));
        sic.add(new SelectorItemInfo("entries.tryoutMonth"));
        sic.add(new SelectorItemInfo("entries.hireDate"));
        sic.add(new SelectorItemInfo("entries.position"));
        sic.add(new SelectorItemInfo("entries.remark"));
        sic.add(new SelectorItemInfo("entries.workSumup"));
        sic.add(new SelectorItemInfo("entries.jobGrade.name"));
        sic.add(new SelectorItemInfo("entries.jobGrade.id"));
        sic.add(new SelectorItemInfo("entries.jobGrade.number"));
        sic.add(new SelectorItemInfo("entries.gender"));
        sic.add(new SelectorItemInfo("entries.birthday"));
        sic.add(new SelectorItemInfo("entries.specialty"));
        sic.add(new SelectorItemInfo("entries.jobStartDate"));
        sic.add(new SelectorItemInfo("entries.lenOfActualService"));
        sic.add(new SelectorItemInfo("entries.highestDegree.id"));
        sic.add(new SelectorItemInfo("entries.highestDegree.number"));
        sic.add(new SelectorItemInfo("entries.highestDegree.name"));
        sic.add(new SelectorItemInfo("entries.highestTechPost.id"));
        sic.add(new SelectorItemInfo("entries.highestTechPost.number"));
        sic.add(new SelectorItemInfo("entries.highestTechPost.name"));
        sic.add(new SelectorItemInfo("entries.selfAppraise"));
        sic.add(new SelectorItemInfo("entries.eposition.id"));
        sic.add(new SelectorItemInfo("entries.eposition.number"));
        sic.add(new SelectorItemInfo("entries.eposition.name"));
        sic.add(new SelectorItemInfo("entries.jobLevel.name"));
        sic.add(new SelectorItemInfo("entries.jobLevel.id"));
        sic.add(new SelectorItemInfo("entries.jobLevel.number"));
        return sic;
    }

    @Override
    protected BOSObjectType getBillBOSType() {
        return new HireBillInfo().getBOSType();
    }

    @Override
    public void actionAffairReg_actionPerformed(ActionEvent e) throws Exception {
        if (this.actPersonId != null && this.actEntryId != null && this.billId != null) {
            DataProvider data = new DataProvider();
            this.appHlp.printPreview(Hire_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "NO_SELECT_ROW")));
        }
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCopySelect.setVisible(false);
        this.promptJobGrade.addPreChangeListener(new PreChangeListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void preChange(PreChangeEvent e) {
                try {
                    JobGradeInfo jobGrade = (JobGradeInfo)e.getData();
                    PositionInfo position = (PositionInfo)HireBillSelfEditUI.this.prmptPosition.getValue();
                    JobLevelInfo jobLevel = AffairUtil.getJobLevelByGradeAndPosition(jobGrade, position);
                    if (!"true".equals(AffairUtil.getParamForClient("AutoGetJob", HireBillSelfEditUI.this.getCurrentHRO()))) return;
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.cboJobLevel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
            }
        });
        this.promptOrg.setEnabled(false);
        this.dateHireDate.setRequired(true);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        if (this.deleteFlag) {
            this.getUIWindow().close();
        }
    }

    @Override
    protected boolean confirmRemove() {
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            this.deleteFlag = true;
            return true;
        }
        this.deleteFlag = false;
        return false;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = (RequestContext)handler.getRequestContext();
        request.put("kdtIsVisible", (Object)this.kdtEntries.isVisible());
        request.put("prmtHROrg", this.prmtHROrg.getValue());
        request.put("nowClientDate", (Object)this.nowDate);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public class DataProvider
    implements BOSQueryDelegate {
        public IRowSet execute(BOSQueryDataSource ds) {
            try {
                if (HireBillSelfEditUI.this.billId != null) {
                    IAffairRegFacade iAffairReg = AffairRegFacadeFactory.getRemoteInstance();
                    if (ds.getID() != null) {
                        if (ds.getID().equals("ds2")) {
                            return iAffairReg.getAffairBillRegByEntry(AffairTypeEnum.HIRE, HireBillSelfEditUI.this.actEntryId, BOSUuid.read((String)HireBillSelfEditUI.this.billId));
                        }
                        if (ds.getID().equals("ds3")) {
                            return iAffairReg.getMultiApproveDecByPerson(AffairTypeEnum.HIRE, HireBillSelfEditUI.this.actPersonId, BOSUuid.read((String)HireBillSelfEditUI.this.billId));
                        }
                    }
                }
            }
            catch (BOSException e) {
                HireBillSelfEditUI.this.handUIException(e);
            }
            catch (EASBizException e) {
                HireBillSelfEditUI.this.handUIException(e);
            }
            return null;
        }
    }
}

