/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.affair.LoanBackDelayBizBillEntryInfo;
import com.kingdee.eas.hr.affair.client.HRAffairBillEditUIBiz;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.emp.IPersonLoan;
import com.kingdee.eas.hr.emp.LoanStrEnum;
import com.kingdee.eas.hr.emp.PersonLoanCollection;
import com.kingdee.eas.hr.emp.PersonLoanFactory;
import com.kingdee.eas.hr.emp.PersonLoanInfo;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class LoanBackDelayBizBillEditUIBiz
extends HRAffairBillEditUIBiz {
    @Override
    protected void initEditor() throws Exception {
        super.initEditor();
    }

    @Override
    public void registerContextChangeF7(IHRF7CommonRegister register) {
        super.registerContextChangeF7(register);
    }

    public void entryEditStopped(KDTEditEvent e) throws Exception {
    }

    public void entryEditStopping(KDTEditEvent e) throws Exception {
    }

    @Override
    protected IObjectValue createNewDetailData(PersonInfo pInfo) {
        LoanBackDelayBizBillEntryInfo info = new LoanBackDelayBizBillEntryInfo();
        info.setPerson(pInfo);
        info.setOldEmpType(pInfo.getEmployeeType());
        info.setEmpType(pInfo.getEmployeeType());
        PersonPositionInfo ppInfo = (PersonPositionInfo)pInfo.get("personPosition");
        if (ppInfo != null) {
            PositionInfo pstInfo = ppInfo.getPrimaryPosition();
            info.setOldJobGrade(ppInfo.getJobGrade());
            info.setOldJobLevel(ppInfo.getJobLevel());
            info.setOldPosition(pstInfo);
            info.setOldAdminOrg(ppInfo.getPersonDep());
            Date d = new Date();
            try {
                d = DateTimeUtils.parseDate((String)DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
            }
            catch (ParseException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            info.setBizDate(d);
        }
        return info;
    }

    public void addLine(boolean isInsert) throws Exception {
        this.addLoanBackDelayPerson(isInsert);
    }

    protected void addLoanBackDelayPerson(boolean isInsert) throws Exception {
        KDBizPromptBox f7 = new KDBizPromptBox();
        f7.setMyCommonUseEnabled(false);
        f7.setQueryInfo("com.kingdee.eas.hr.affair.app.LoanBackPersonsQuery");
        FilterInfo filter = new FilterInfo();
        HROrgUnitInfo hro = (HROrgUnitInfo)this.ctx.getMainOrgContext().get((Object)OrgType.HRO);
        if (hro == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"55_FlucInBizBillEditUIBiz"));
            return;
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrg.id", (Object)hro.getId(), CompareType.EQUALS));
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        f7.setEntityViewInfo(ev);
        f7.setEnabledMultiSelection(true);
        f7.setDataBySelector();
        if (!f7.getSelector().isCanceled()) {
            ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
            StringBuffer personLoanIds = new StringBuffer();
            if (f7.getData() instanceof Object[]) {
                Object[] objs = (Object[])f7.getData();
                for (int i = 0; i < objs.length; ++i) {
                    PersonLoanInfo personLoanInfo = (PersonLoanInfo)objs[i];
                    persons.add(personLoanInfo.getPerson());
                    personLoanIds.append("'").append(personLoanInfo.getId()).append("' ");
                }
            } else {
                PersonLoanInfo personLoanInfo = (PersonLoanInfo)f7.getData();
                persons.add(personLoanInfo.getPerson());
                personLoanIds.append("'").append(personLoanInfo.getId()).append("' ");
            }
            this.addLineByPersonList(persons, true);
            this.afterAddPersonLoan(personLoanIds.toString().trim().replaceAll(" ", ","));
        }
    }

    private void afterAddPersonLoan(String personLoanIds) throws Exception {
        String oql = "select *,outPosition.*,outAdmin.*,outJob.*,outJobLevel.*,outJobGrade.*,inPosition.*,inAdmin.*,inJob.*,inJobLevel.*,inJobGrade.* where state='1' id in (" + personLoanIds + ")";
        IPersonLoan ipersonLoan = PersonLoanFactory.getRemoteInstance();
        PersonLoanCollection col = ipersonLoan.getPersonLoanCollection(oql);
        HashMap<String, PersonLoanInfo> personLoanMap = new HashMap<String, PersonLoanInfo>();
        for (PersonLoanInfo personLoan : col) {
            personLoanMap.put(personLoan.getPerson().getId().toString(), personLoan);
        }
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            PersonInfo person = (PersonInfo)row.getCell("person").getValue();
            PersonLoanInfo personLoan = (PersonLoanInfo)personLoanMap.get(person.getId().toString());
            if (personLoan == null) continue;
            row.getCell("oldPosition").setValue((Object)personLoan.getOutPosition());
            row.getCell("oldAdminOrg").setValue((Object)personLoan.getOutAdmin());
            row.getCell("oldJob").setValue((Object)personLoan.getOutJob());
            row.getCell("oldJobLevel").setValue((Object)personLoan.getOutJobLevel());
            row.getCell("oldJobGrade").setValue((Object)personLoan.getOutJobGrade());
            row.getCell("position").setValue((Object)personLoan.getInPosition());
            row.getCell("adminOrg").setValue((Object)personLoan.getInAdmin());
            row.getCell("owner").setValue((Object)personLoan.getOwner());
            row.getCell("job").setValue((Object)personLoan.getInJob());
            row.getCell("jobLevel").setValue((Object)personLoan.getInJobLevel());
            row.getCell("jobGrade").setValue((Object)personLoan.getInJobGrade());
            row.getCell("loanInDate").setValue((Object)personLoan.getLoanDate());
            row.getCell("loanEndDate").setValue((Object)personLoan.getLoanEndDate());
            if (personLoan.getPositionStr() == LoanStrEnum.BOTH) {
                row.getCell("outPositionStr").setValue((Object)true);
                row.getCell("inPositionStr").setValue((Object)true);
            } else if (personLoan.getPositionStr() == LoanStrEnum.IN) {
                row.getCell("outPositionStr").setValue((Object)false);
                row.getCell("inPositionStr").setValue((Object)true);
            } else if (personLoan.getPositionStr() == LoanStrEnum.OUT) {
                row.getCell("outPositionStr").setValue((Object)true);
                row.getCell("inPositionStr").setValue((Object)false);
            } else if (personLoan.getPositionStr() == LoanStrEnum.BOTHNOT) {
                row.getCell("outPositionStr").setValue((Object)false);
                row.getCell("inPositionStr").setValue((Object)false);
            }
            if (personLoan.getAdminStr() == LoanStrEnum.BOTH) {
                row.getCell("outAdminStr").setValue((Object)true);
                row.getCell("inAdminStr").setValue((Object)true);
                continue;
            }
            if (personLoan.getAdminStr() == LoanStrEnum.IN) {
                row.getCell("outAdminStr").setValue((Object)false);
                row.getCell("inAdminStr").setValue((Object)true);
                continue;
            }
            if (personLoan.getAdminStr() == LoanStrEnum.OUT) {
                row.getCell("outAdminStr").setValue((Object)true);
                row.getCell("inAdminStr").setValue((Object)false);
                continue;
            }
            if (personLoan.getAdminStr() != LoanStrEnum.BOTHNOT) continue;
            row.getCell("outAdminStr").setValue((Object)false);
            row.getCell("inAdminStr").setValue((Object)false);
        }
    }

    @Override
    public boolean isAddPersonByF7() {
        return true;
    }

    @Override
    protected String[] getNotDupColumn() {
        return new String[]{"person"};
    }

    @Override
    protected String[] getNotNullColumn() {
        return new String[]{"newLoanEndDate", "bizDate", "hrBizDefine"};
    }

    protected String getPrintQuery(String dsName) {
        ((Object)((Object)this)).getClass();
        if ("baseInfo".equals(dsName)) {
            return "com.kingdee.eas.hr.affair.app.LoanBackDelayBizBillPrintQuery";
        }
        ((Object)((Object)this)).getClass();
        if ("approveInfo".equals(dsName)) {
            return "com.kingdee.eas.hr.affair.app.LoanBackDelayBizBillApprovePrintQuery";
        }
        return null;
    }

    protected String getPrintPath() {
        return "/HR/AffairBiz/LoanBackDelay";
    }

    @Override
    public void initDataStatus() throws Exception {
        super.initDataStatus();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        HROrgUnitInfo hrOrgInfo = SysContext.getSysContext().getCurrentHRUnit();
        IPermission per = PermissionFactory.getRemoteInstance();
        FieldPermission fields = per.getFieldPermission(BOSObjectType.create((String)"82D0C0C1"), (IObjectPK)new ObjectUuidPK(userInfo.getId()), (IObjectPK)new ObjectUuidPK(hrOrgInfo.getId()));
        IColumn col = this.kdtEntrys.getColumn(this.getJobLevelCol());
        FieldAccessInfo accessInfo = fields.getFieldAccessInfo("entrys.jobLevel");
        if (accessInfo != null && !accessInfo.isEditable() && col != null) {
            col.getStyleAttributes().setBackground(this.CANNOT_INPUT_COLOR);
        }
        col = this.kdtEntrys.getColumn(this.getJobGradeCol());
        accessInfo = fields.getFieldAccessInfo("entrys.jobGrade");
        if (accessInfo != null && !accessInfo.isEditable() && col != null) {
            col.getStyleAttributes().setBackground(this.CANNOT_INPUT_COLOR);
        }
    }

    public void addLineByPersonList(List persons, boolean isInsert) throws Exception {
        super.addLineByPersonList(persons, isInsert);
        String billID = null;
        if (((HRBillBaseInfo)this.ctx.getEditData()).getId() != null) {
            billID = ((HRBillBaseInfo)this.ctx.getEditData()).getId().toString();
        }
        if ((persons = this.getProcessedPersons(persons, billID)) != null) {
            int size = persons.size();
            for (int i = 0; i < size; ++i) {
                this.afterAddPersonLoan(((PersonInfo)persons.get(0)).getId().toString());
            }
        }
    }

    @Override
    protected String getWFUIFuctionName() {
        return "com.kingdee.eas.hr.affair.app.LoanBackDelayBizBillEditUIFunction";
    }
}

