/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.affair.LoanBizBillEntryInfo;
import com.kingdee.eas.hr.affair.client.HRAffairBillEditUIBiz;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.LoanOwnerEnum;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.base.client.util.HRBizDefineClientUtils;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import java.util.List;

public class LoanBizBillEditUIBiz
extends HRAffairBillEditUIBiz {
    HRBizDefineInfo bizDefLong = null;
    HRBizDefineInfo bizDefTemp = null;

    public void entryEditStopped(KDTEditEvent e) throws Exception {
        if (e.getColIndex() >= 0 && e.getRowIndex() >= 0 && this.kdtEntrys.getColumnIndex("owner") == e.getColIndex()) {
            int rowNum = e.getRowIndex();
            IRow curRow = this.kdtEntrys.getRow(rowNum);
            this.fillBizDefineByLoanOwnerEnum(curRow);
        }
    }

    public void entryEditStopping(KDTEditEvent e) throws Exception {
    }

    @Override
    public void registerContextChangeF7(IHRF7CommonRegister register) {
        super.registerContextChangeF7(register);
    }

    @Override
    protected void initEditor() throws Exception {
        super.initEditor();
        if (this.ctx.getUIContext() != null && this.ctx.getUIContext().containsKey("isFromWorkflow")) {
            this.kdtEntrys.getColumn("adminOrg").getStyleAttributes().setLocked(true);
        }
        this.bizDefLong = HRBizDefineClientUtils.getHRBizDefineInfo((String)"DawAAAAqGVjmaL7Z");
        this.bizDefTemp = HRBizDefineClientUtils.getHRBizDefineInfo((String)"DawAAAAqRGPmaL7Z");
    }

    @Override
    protected void kdtEntrys_SelectChanged(KDTSelectEvent e) throws Exception {
        super.kdtEntrys_SelectChanged(e);
        int selCol = e.getSelectBlock().getBeginCol();
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.kdtEntrys);
        for (int i = 0; i < rows.length; ++i) {
            IRow row = this.kdtEntrys.getRow(rows[i]);
            if (this.kdtEntrys.getColumnIndex("adminOrg") != selCol) continue;
            if (this.kdtEntrys.getRow(i).getCell("position").getValue() == null) {
                row.getCell("adminOrg").getStyleAttributes().setLocked(false);
                continue;
            }
            row.getCell("adminOrg").getStyleAttributes().setLocked(true);
        }
    }

    @Override
    protected IObjectValue createNewDetailData(PersonInfo pInfo) {
        LoanBizBillEntryInfo info = new LoanBizBillEntryInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setPerson(pInfo);
        info.setOldEmpType(pInfo.getEmployeeType());
        info.setEmpType(pInfo.getEmployeeType());
        PersonPositionInfo ppInfo = (PersonPositionInfo)pInfo.get("personPosition");
        if (ppInfo != null) {
            PositionInfo pstInfo = ppInfo.getPrimaryPosition();
            info.setOldJobGrade(ppInfo.getJobGrade());
            info.setOldJobLevel(ppInfo.getJobLevel());
            info.setOldPosition(ppInfo.getPrimaryPosition());
            info.setOldAdminOrg(ppInfo.getPersonDep());
            if (ppInfo.getPrimaryPosition() != null) {
                info.setOldJob(pstInfo.getJob());
            }
            info.setOwner(LoanOwnerEnum.OUT);
            info.setOutPositionStr(true);
            info.setOutAdminStr(true);
            info.setInPositionStr(false);
            info.setInAdminStr(false);
        }
        return info;
    }

    @Override
    public boolean isAddPersonByF7() {
        return true;
    }

    @Override
    protected String[] getNotDupColumn() {
        return new String[]{"person"};
    }

    @Override
    protected String[] getNotNullColumn() {
        if (this.ctx.getUIContext() != null && this.ctx.getUIContext().containsKey("isFromWorkflow")) {
            return new String[]{"position", "adminOrg", "bizDate", "loanEndDate"};
        }
        return new String[]{"bizDate", "loanEndDate", "hrBizDefine"};
    }

    protected String getPrintQuery(String dsName) {
        ((Object)((Object)this)).getClass();
        if ("baseInfo".equals(dsName)) {
            return "com.kingdee.eas.hr.affair.app.LoanBizBillPrintQuery";
        }
        ((Object)((Object)this)).getClass();
        if ("approveInfo".equals(dsName)) {
            return "com.kingdee.eas.hr.affair.app.LoanBizBillApprovePrintQuery";
        }
        return null;
    }

    protected String getPrintPath() {
        return "/HR/AffairBiz/LoanBiz";
    }

    @Override
    public void initDataStatus() throws Exception {
        super.initDataStatus();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        HROrgUnitInfo hrOrgInfo = SysContext.getSysContext().getCurrentHRUnit();
        IPermission per = PermissionFactory.getRemoteInstance();
        FieldPermission fields = per.getFieldPermission(BOSObjectType.create((String)"3B5082D7"), (IObjectPK)new ObjectUuidPK(userInfo.getId()), (IObjectPK)new ObjectUuidPK(hrOrgInfo.getId()));
        IColumn col = this.kdtEntrys.getColumn(this.getJobLevelCol());
        FieldAccessInfo accessInfo = fields.getFieldAccessInfo("entrys.jobLevel");
        if (accessInfo != null && !accessInfo.isEditable() && col != null) {
            col.getStyleAttributes().setBackground(this.CANNOT_INPUT_COLOR);
        }
        col = this.kdtEntrys.getColumn(this.getJobGradeCol());
        accessInfo = fields.getFieldAccessInfo("entrys.jobGrade");
        if (accessInfo != null && !accessInfo.isEditable() && col != null) {
            col.getStyleAttributes().setBackground(this.CANNOT_INPUT_COLOR);
        }
    }

    @Override
    protected String getWFUIFuctionName() {
        return "com.kingdee.eas.hr.affair.app.LoanBizBillEditUIFunction";
    }

    @Override
    protected String positionF7IsShowSealup() {
        return "true";
    }

    private void fillBizDefineByLoanOwnerEnum(IRow curRow) {
        LoanOwnerEnum stateEnum = (LoanOwnerEnum)curRow.getCell("owner").getValue();
        if (LoanOwnerEnum.IN.equals((Object)stateEnum)) {
            curRow.getCell("hrBizDefine").setValue((Object)this.bizDefLong);
        } else {
            curRow.getCell("hrBizDefine").setValue((Object)this.bizDefTemp);
        }
    }

    public void addLineByPersonList(List persons, boolean isInsert) throws Exception {
        super.addLineByPersonList(persons, isInsert);
        IRow curRow = null;
        int size = this.kdtEntrys.getRowCount();
        for (int i = 0; i < size; ++i) {
            curRow = this.kdtEntrys.getRow(i);
            this.fillBizDefineByLoanOwnerEnum(curRow);
        }
    }

    @Override
    protected void fillRow(IRow row, Object value, IRow dataRow, int copyCol) throws Exception {
        super.fillRow(row, value, dataRow, copyCol);
        if (copyCol == this.kdtEntrys.getColumn("owner").getColumnIndex()) {
            this.fillBizDefineByLoanOwnerEnum(row);
        }
    }
}

