/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.affair.ResignBackBizBillEntryInfo;
import com.kingdee.eas.hr.affair.client.HRAffairBillEditUIBiz;
import com.kingdee.eas.hr.base.DimissionReasonInfo;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.base.client.f7.EditorCreator;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.PersonWorkExpCurCollection;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;

public class ResignBackBizBillEditUIBiz
extends HRAffairBillEditUIBiz {
    @Override
    public void registerContextChangeF7(IHRF7CommonRegister register) {
        super.registerContextChangeF7(register);
        register.registerAdminByOrgRangePromptBox(new KDBizPromptBox(), this.kdtEntrys.getColumn("intentAdminOrg"));
        register.registerPositionPromptBox2(new KDBizPromptBox(), this.kdtEntrys.getColumn("oldPosition"));
        register.registerPositionPromptBox2(new KDBizPromptBox(), this.kdtEntrys.getColumn("intentPosition"));
    }

    @Override
    protected void initEditor() throws Exception {
        super.initEditor();
        this.kdtEntrys.getColumn("empNumber").getStyleAttributes().setHided(true);
        this.kdtEntrys.getColumn("empNumberTemp").setEditor(EditorCreator.getTextCellEditor((int)80));
    }

    public void entryEditStopping(KDTEditEvent e) throws Exception {
    }

    public void entryEditStopped(KDTEditEvent e) throws Exception {
    }

    @Override
    protected void kdtEntrys_SelectChanged(KDTSelectEvent e) throws Exception {
        super.kdtEntrys_SelectChanged(e);
        int selCol = e.getSelectBlock().getBeginCol();
        if (this.kdtEntrys.getColumnIndex("intentAdminOrg") != selCol) {
            return;
        }
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.kdtEntrys);
        for (int i = 0; i < rows.length; ++i) {
            IRow row = this.kdtEntrys.getRow(rows[i]);
            if (this.kdtEntrys.getRow(i).getCell("intentPosition").getValue() == null) {
                row.getCell("intentAdminOrg").getStyleAttributes().setLocked(false);
                continue;
            }
            row.getCell("intentAdminOrg").getStyleAttributes().setLocked(true);
        }
    }

    @Override
    protected IObjectValue createNewDetailData(PersonInfo pInfo) {
        PositionInfo position;
        ResignBackBizBillEntryInfo info = new ResignBackBizBillEntryInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setPerson(pInfo);
        info.setEmpNumber(pInfo.getNumber());
        PersonPositionInfo ppInfo = (PersonPositionInfo)pInfo.get("personPosition");
        DimissionReasonInfo dimissionReason = (DimissionReasonInfo)pInfo.get("dimissionReason");
        PersonWorkExpCurCollection personWorkExpCur = (PersonWorkExpCurCollection)pInfo.get("personWorkExpCur");
        if (ppInfo != null) {
            info.setOldPosition(ppInfo.getPrimaryPosition());
            info.setOldAdminOrg(ppInfo.getPersonDep());
            info.setEnrollDate(ppInfo.getEnterDate());
            info.setDimissionDate(ppInfo.getLeftDate());
        }
        info.setEmpIdCardNo(pInfo.getIdCardNO());
        if (dimissionReason != null) {
            info.setDimissionReason(dimissionReason);
            info.setDimsReasonType(dimissionReason.getDimissionReasonType());
        }
        if (personWorkExpCur != null && personWorkExpCur.size() > 0 && (position = personWorkExpCur.get(0).getPosition()) != null) {
            info.setOldPosition(position);
            info.setOldAdminOrg(position.getAdminOrgUnit());
            info.setOldPersonRZType(personWorkExpCur.get(0).getPersonRZType());
        }
        try {
            PersonPositionInfo personPositionInfo = HRUtilExtend.getPersonPositionInfoByPersonInfo(null, (PersonInfo)info.getPerson());
            info.setIsEnrollAgainHis(personPositionInfo.isIsEnrollAgain());
            info.setNumberHis(pInfo.getNumber());
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return info;
    }

    @Override
    public boolean isAddPersonByF7() {
        return true;
    }

    @Override
    protected void initEmpF7() {
        super.initEmpF7();
        this.empF7.setUserOrgRangeFilter(false);
        this.empF7.setIsShowAllAdmin(true);
        this.empF7.showNoPositionPerson(true);
        this.empF7.hideAdminTreeTab(true);
    }

    @Override
    protected String[] getNotDupColumn() {
        return new String[]{"person"};
    }

    @Override
    protected String[] getNotNullColumn() {
        if (this.ctx.getUIContext() != null && this.ctx.getUIContext().containsKey("isFromWorkflow")) {
            return new String[]{"empNumberTemp", "empType", "position", "adminOrg", "bizDate"};
        }
        return new String[]{"empNumberTemp", "empType", "position", "bizDate", "hrBizDefine"};
    }

    @Override
    protected String[] showAdminDisplayNameColsInEntrys() {
        return new String[]{"adminOrg", "oldAdminOrg", "intentAdminOrg"};
    }

    @Override
    protected String getJobLevelCol() {
        return null;
    }

    @Override
    protected String getJobCol() {
        return null;
    }

    @Override
    protected void personalCheck(PersonInfo p) throws Exception {
        if (p == null) {
            return;
        }
    }

    protected String getPrintQuery(String dsName) {
        ((Object)((Object)this)).getClass();
        if ("baseInfo".equals(dsName)) {
            return "com.kingdee.eas.hr.affair.app.ResignBackBizBillPrintQuery";
        }
        ((Object)((Object)this)).getClass();
        if ("approveInfo".equals(dsName)) {
            return "com.kingdee.eas.hr.affair.app.ResignBackBizBillApprovePrintQuery";
        }
        return null;
    }

    protected String getPrintPath() {
        return "/HR/AffairBiz/ResignBack";
    }

    @Override
    protected String getWFUIFuctionName() {
        return "com.kingdee.eas.hr.affair.app.ResignBackBizBillEditUIFunction";
    }

    protected boolean checkBeforeAddRow(PersonInfo person, StringBuffer msg) {
        DimissionReasonInfo dimissReason = (DimissionReasonInfo)person.get("dimissionreason");
        if (dimissReason != null && dimissReason.isIsPermission()) {
            msg.append(EASResource.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"0_AffairBizCheckFacadeControllerBean") + person.getNumber() + EASResource.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"10_AffairBizCheckFacadeControllerBean") + person.getName() + EASResource.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"ResignBackBizBillEditUIBiz_1"));
            msg.append("\n");
            ++this.notAddSize;
            return true;
        }
        return false;
    }
}

