/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.client.service.FieldPermissionService;
import com.kingdee.eas.hr.affair.AffairRegFacadeFactory;
import com.kingdee.eas.hr.affair.AffairTypeEnum;
import com.kingdee.eas.hr.affair.ApproveStateEnum;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.HRAffairPersonPreProcessFacadeFactory;
import com.kingdee.eas.hr.affair.HRAffairState;
import com.kingdee.eas.hr.affair.IAffairRegFacade;
import com.kingdee.eas.hr.affair.RetireBillEntryFactory;
import com.kingdee.eas.hr.affair.RetireBillEntryInfo;
import com.kingdee.eas.hr.affair.RetireBillFactory;
import com.kingdee.eas.hr.affair.RetireBillInfo;
import com.kingdee.eas.hr.affair.client.AbstractRetireBillEditUI;
import com.kingdee.eas.hr.affair.client.HRAffairClientUtils;
import com.kingdee.eas.hr.affair.client.OrgFullNameRender;
import com.kingdee.eas.hr.affair.util.AffairUtil;
import com.kingdee.eas.hr.base.EmployeeTypeCollection;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HRBillBaseEntryCollection;
import com.kingdee.eas.hr.base.TechnicalPostInfo;
import com.kingdee.eas.hr.base.batch.BatchProcessedResult;
import com.kingdee.eas.hr.base.client.CustomerSettingsSwitch;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;

public class RetireBillEditUI
extends AbstractRetireBillEditUI {
    protected RetireBillEntryInfo entryInfo = new RetireBillEntryInfo();
    private KDNoteHelper appHlp = new KDNoteHelper();
    private String resClass = "com.kingdee.eas.hr.affair.HRAffairResource.";
    public static final String RETIRE_FILENAME = "/HR/OrgUnit/RetireBill";
    private BOSUuid actPersonId;
    private BOSUuid actEntryId;
    private String billId;
    private EmployeeMultiF7PromptBox f7 = null;

    @Override
    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.prmtHROrg.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource", (String)"HRORG_NOT_NULL"));
            SysUtil.abort();
        }
        super.beforeStoreFields(e);
    }

    @Override
    protected void verifyInput(ActionEvent e) throws Exception {
        String id = "";
        if (this.editData.getId() != null) {
            id = this.editData.getId().toString();
        }
        HRAffairClientUtils.checkIsPersonInProcess(this.kdtEntries, "person", this.editData.getBOSType(), id);
        super.verifyInput(e);
    }

    @Override
    protected ArrayList getNoDupColumns() {
        ArrayList<String> colList = new ArrayList<String>();
        colList.add("person");
        return colList;
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        if (this.getUIContext().get("enterPath") != null) {
            this.btnRemove.setEnabled(false);
        }
        if (OprtState.VIEW.equals(this.oprtState)) {
            this.actionAudit.setEnabled(false);
        }
    }

    @Override
    protected ArrayList getNoNullColumns() {
        ArrayList<String> colList = new ArrayList<String>();
        colList.add("person");
        colList.add("retireDate");
        colList.add("retire");
        colList.add("nominalDept");
        return colList;
    }

    @Override
    protected IObjectValue createNewData() {
        RetireBillInfo info = new RetireBillInfo();
        info.setIsMultiEntry(true);
        info.setApplyDate(DateTimeUtils.truncateDate((Date)new Date()));
        if (this.nowDate != null) {
            info.setApplyDate(this.nowDate);
        }
        return info;
    }

    @Override
    protected void kdtEntries_editStopping(KDTEditEvent e) throws Exception {
        PersonInfo pInfo = null;
        int colIndex = e.getColIndex();
        if (colIndex == this.kdtEntries.getColumn("person").getColumnIndex()) {
            pInfo = (PersonInfo)e.getValue();
            if (pInfo != null && HRAffairClientUtils.isPersonInProcess(this.editData.getBOSType(), this.entryInfo.getBOSType(), pInfo, "")) {
                e.setCancel(true);
                throw new HRAffairException(HRAffairException.PERSON_IS_IN_PROCESS, new Object[]{pInfo.getName(), HRAffairClientUtils.PROMPT_PRESS_ESC});
            }
        } else if (colIndex == this.kdtEntries.getColumn("retireDate").getColumnIndex() && e.getValue() != null && (pInfo = (PersonInfo)this.kdtEntries.getRow(e.getRowIndex()).getCell("person").getValue()) != null && HRAffairClientUtils.isDateBeforeEnrollDate(pInfo.getId().toString(), (Date)e.getValue())) {
            e.setCancel(true);
            throw new HRAffairException(HRAffairException.CAN_NOT_BEFORE_ENROLLDATE, new Object[]{this.kdtEntries.getHeadRow(0).getCell(colIndex).getValue().toString(), ""});
        }
    }

    @Override
    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        PersonInfo pInfo = null;
        int colIndex = e.getColIndex();
        IRow row = this.kdtEntries.getRow(e.getRowIndex());
        if (colIndex == this.kdtEntries.getColumn("person").getColumnIndex()) {
            pInfo = (PersonInfo)e.getValue();
            if (pInfo != null && pInfo.getId() != null) {
                String personId = pInfo.getId().toString();
                pInfo = HRAffairClientUtils.getPersonInfo(personId);
                row.getCell("birthday").setValue((Object)pInfo.getBirthday());
                row.getCell("idCardNO").setValue((Object)pInfo.getIdCardNO());
                row.getCell("phone").setValue((Object)pInfo.getOfficePhone());
                row.getCell("gender").setValue((Object)pInfo.getGender());
                ArrayList degreeRelInfo = HRAffairClientUtils.getDegreeRelInfo(personId);
                if (degreeRelInfo != null) {
                    row.getCell("degree").setValue(degreeRelInfo.get(0));
                    row.getCell("graduateSchool").setValue(degreeRelInfo.get(1));
                    row.getCell("specialty").setValue(degreeRelInfo.get(2));
                }
                PositionMemberInfo postRelInfo = HRAffairClientUtils.getPersonMemberInfo(personId);
                PersonPositionInfo ppInfo = HRAffairClientUtils.getPersonPositionInfo(personId);
                if (ppInfo != null && ppInfo.getEnterDate() != null) {
                    row.getCell("enrollDate").setValue((Object)ppInfo.getEnterDate());
                    row.getCell("serviceYear").setValue((Object)HRAffairClientUtils.getYearDif(ppInfo.getEnterDate(), new Date()));
                }
                if (ppInfo != null && ppInfo.getJobStartDate() != null) {
                    row.getCell("jobStartDate").setValue((Object)ppInfo.getJobStartDate());
                }
                if (postRelInfo != null) {
                    row.getCell("position").setValue((Object)postRelInfo.getPosition().getName());
                    row.getCell("eposition").setValue((Object)postRelInfo.getPosition());
                    row.getCell("dept").setValue((Object)postRelInfo.getPosition().getAdminOrgUnit().getDisplayName());
                    row.getCell("positionDate").setValue((Object)postRelInfo.getBeginDate());
                    TechnicalPostInfo jobTitleInfo = HRAffairClientUtils.getJobTitle(personId);
                    if (jobTitleInfo != null) {
                        row.getCell("jobTitle").setValue((Object)jobTitleInfo.getName());
                    }
                }
            } else if (e.getOldValue() != null) {
                row.getCell("birthday").setValue(null);
                row.getCell("idCardNO").setValue(null);
                row.getCell("phone").setValue(null);
                row.getCell("degree").setValue(null);
                row.getCell("graduateSchool").setValue(null);
                row.getCell("specialty").setValue(null);
                row.getCell("position").setValue(null);
                row.getCell("eposition").setValue(null);
                row.getCell("dept").setValue(null);
                row.getCell("positionDate").setValue(null);
                row.getCell("jobTitle").setValue(null);
                row.getCell("enrollDate").setValue(null);
                row.getCell("serviceYear").setValue(null);
            }
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return RetireBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected void registerContextChangeF7(IHRF7CommonRegister register) {
        super.registerContextChangeF7(register);
        try {
            int param = CustomerSettingsSwitch.getInstance().getFunctionParamValue("RETIRE_BILL");
            KDBizPromptBox prmtAdmin = new KDBizPromptBox();
            if (-1 == param) {
                String returnValue = null;
                returnValue = ParamManager.getParamValueIgnoreGroupControl(null, (String)"RESIGN_FIRE_RETIRE_SHOWADMINORG", null, (boolean)true);
                if (returnValue != null && "false".equalsIgnoreCase(returnValue)) {
                    register.registerAdminByOrgRangePromptBox(prmtAdmin, this.kdtEntries.getColumn("nominalDept"));
                } else {
                    register.registerAllAdminPromptBox(prmtAdmin, this.kdtEntries.getColumn("nominalDept"));
                }
            } else if (0 == param) {
                register.registerAdminByOrgRangePromptBox(prmtAdmin, this.kdtEntries.getColumn("nominalDept"));
                AdminByOrgRangePromptBox selector = (AdminByOrgRangePromptBox)prmtAdmin.getSelector();
                selector.clearHROFilter();
            } else {
                register.registerAllAdminPromptBox(prmtAdmin, this.kdtEntries.getColumn("nominalDept"));
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo != null && chgVo.isDiffrent()) {
            this.kdtEntries.removeRows();
            if (chgVo.getNewOrg() != null && chgVo.getNewOrg() instanceof HROrgUnitInfo) {
                HashSet<String> hroSet = new HashSet<String>();
                hroSet.add(((HROrgUnitInfo)chgVo.getNewOrg()).getId().toString());
                if (this.f7 == null) {
                    this.f7 = new EmployeeMultiF7PromptBox();
                    this.f7.setIsSingleSelect(false);
                    this.f7.setUserOrgRangeFilter(true);
                    this.f7.setEnabledMultiSelection(true);
                }
                this.f7.setHROFilter(hroSet);
            }
        }
    }

    @Override
    protected void setTableCellEditor() throws Exception {
        this.kdtEntries.getColumn("person").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("number").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("gender").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox((ComboBoxModel)HRAffairClientUtils.getGenderModel())));
        this.kdtEntries.getColumn("retireType").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox((ComboBoxModel)HRAffairClientUtils.getRetireTypeModel())));
        EmployeeTypeCollection c = EmployeeTypeFactory.getRemoteInstance().getEmployeeTypeCollection("select * where inService = 3 and isEnabled = 1");
        DefaultComboBoxModel<EmployeeTypeInfo> model = new DefaultComboBoxModel<EmployeeTypeInfo>();
        for (int i = 0; i < c.size(); ++i) {
            model.addElement(c.get(i));
        }
        if (c.size() != 0) {
            model.setSelectedItem(c.get(0));
        }
        this.kdtEntries.getColumn("retire").setEditor(EmployeeClientUtils.getComboBoxCellEditor(model));
        this.kdtEntries.getColumn("retireDate").setEditor(EmployeeClientUtils.getDateCellEditor());
        this.kdtEntries.getColumn("retireDate").getStyleAttributes().setNumberFormat(EmployeeClientUtils.getDateFormatStr());
        this.kdtEntries.getColumn("birthday").setEditor(EmployeeClientUtils.getDateCellEditor());
        this.kdtEntries.getColumn("birthday").getStyleAttributes().setNumberFormat(EmployeeClientUtils.getDateFormatStr());
        this.kdtEntries.getColumn("enrollDate").setEditor(EmployeeClientUtils.getDateCellEditor());
        this.kdtEntries.getColumn("enrollDate").getStyleAttributes().setNumberFormat(EmployeeClientUtils.getDateFormatStr());
        this.kdtEntries.getColumn("positionDate").setEditor(EmployeeClientUtils.getDateCellEditor());
        this.kdtEntries.getColumn("positionDate").getStyleAttributes().setNumberFormat(EmployeeClientUtils.getDateFormatStr());
        this.kdtEntries.getColumn("serviceYear").setEditor(EmployeeClientUtils.getIntCellEditor((Comparable)Integer.getInteger("100")));
        this.kdtEntries.getColumn("serviceYear").getStyleAttributes().setNumberFormat(EmployeeClientUtils.getIntFormatStr());
        this.kdtEntries.getColumn("remark").setEditor(EmployeeClientUtils.getTextAreaCellEditor((int)200));
        this.kdtEntries.getColumn("reason").setEditor(EmployeeClientUtils.getTextAreaCellEditor((int)1000));
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.pInfo = this.editData.getProposer();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setProposer(this.pInfo);
        IObjectCollection c = (IObjectCollection)this.editData.get("entries");
        this.editData.setApproveState((ApproveStateEnum)((Object)this.comboSubmitType.getSelectedItem()));
        if (this.editData.isIsMultiEntry()) {
            this.editData.put("entries", HRAffairClientUtils.getEntriesByKDTable(this.kdtEntries, c));
        }
        String versionStr = null;
        try {
            versionStr = AffairUtil.getCurrentClientName();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (versionStr != null && versionStr.equals("hnjt") && this.editData.getBizState().equals((Object)HRAffairState.COMPLETE) && OprtState.VIEW.equals(this.getOprtState())) {
            this.btnAffairReg.setEnabled(true);
            this.btnAffairReg.setVisible(true);
        }
    }

    @Override
    public void actionAddPerson_actionPerformed(ActionEvent e) throws Exception {
        HRAffairClientUtils.checkIsAudited(this.editData);
        super.actionAddPerson_actionPerformed(e);
        PersonInfo personInfo = null;
        if (this.f7 == null) {
            this.f7 = new EmployeeMultiF7PromptBox();
            this.f7.setIsSingleSelect(false);
            this.f7.setUserOrgRangeFilter(true);
            this.f7.setEnabledMultiSelection(true);
        }
        this.f7.setIsPluralityIsChooseContral(HRParamUtil.getParamOfHR(null, (String)"PLURALITY_IS_CHOOSE", null));
        this.f7.show();
        if (!this.f7.isCanceled()) {
            List processedPerson;
            BatchProcessedResult result;
            ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
            if (this.f7.getData() instanceof Object[]) {
                Object[] obj = (Object[])this.f7.getData();
                if (obj == null || obj.length <= 0) {
                    return;
                }
                int size = obj.length;
                for (int i = 0; i < size; ++i) {
                    persons.add((PersonInfo)obj[i]);
                }
                this.kdtEntries.getSelectManager().select(0, 0);
            }
            if (this.f7.getData() instanceof PersonInfo) {
                persons.add((PersonInfo)this.f7.getData());
            }
            String billId = null;
            if (this.oprtState.equals(OprtState.EDIT)) {
                billId = this.editData.getId() != null ? this.editData.getId().toString() : this.getUIContext().get("ID").toString();
            }
            if ((result = HRAffairPersonPreProcessFacadeFactory.getRemoteInstance().preProcessRetirePerson(persons, billId)) == null) {
                return;
            }
            if (result.isHasValidInfo()) {
                MsgBox.showWarning((Component)((Object)this), (String)result.getInvalidInfo());
            }
            if ((processedPerson = result.getResult()) != null && processedPerson.size() > 0) {
                for (int i = 0; i < processedPerson.size(); ++i) {
                    personInfo = (PersonInfo)processedPerson.get(i);
                    this.fillKdtEntryTable(personInfo);
                }
            }
            if (this.kdtEntries.getRowCount() > 0) {
                this.kdtEntries.getSelectManager().select(0, 0);
            }
        }
    }

    private void fillKdtEntryTable(PersonInfo info) throws Exception {
        if (info == null) {
            return;
        }
        ICell iCell = null;
        IRow iRow = null;
        int length = this.kdtEntries.getRowCount();
        for (int i = 0; i < length; ++i) {
            iCell = this.kdtEntries.getRow(i).getCell("person");
            if (iCell.getValue() == null || !iCell.getValue().toString().equalsIgnoreCase(info.getId().toString())) continue;
            return;
        }
        if (this.oprtState.equals(OprtState.EDIT)) {
            this.billId = this.editData.getId() != null ? this.editData.getId().toString() : this.getUIContext().get("ID").toString();
        }
        if (HRAffairClientUtils.isPersonInCompleteProcess(this.editData.getBOSType(), this.entryInfo.getBOSType(), info, "")) {
            throw new HRAffairException(HRAffairException.PERSON_RETIRE_COMPLETE, new Object[]{info.getName()});
        }
        if (!HRAffairClientUtils.isPersonInProcess(this.editData.getBOSType(), this.entryInfo.getBOSType(), info, "")) {
            iRow = this.kdtEntries.addRow();
            iCell = iRow.getCell("person");
            iCell.setValue((Object)info);
        } else {
            String billNumber = null;
            billNumber = HRAffairClientUtils.getNumberInProcessOfPerson(this.editData.getBOSType(), this.entryInfo.getBOSType(), info, "");
            if (billNumber != null) {
                throw new HRAffairException(HRAffairException.PERSON_IN_NUMBER_PROCESS, new Object[]{info, billNumber});
            }
        }
        if (iCell.getColumnIndex() == this.kdtEntries.getColumn("person").getColumnIndex() && info != null && info.getId() != null) {
            String personId = info.getId().toString();
            info = HRAffairClientUtils.getPersonInfo(personId);
            iRow.getCell("number").setValue((Object)info.getNumber());
            iRow.getCell("birthday").setValue((Object)info.getBirthday());
            iRow.getCell("idCardNO").setValue((Object)info.getIdCardNO());
            iRow.getCell("phone").setValue((Object)info.getOfficePhone());
            iRow.getCell("gender").setValue((Object)info.getGender());
            ArrayList degreeRelInfo = HRAffairClientUtils.getDegreeRelInfo(personId);
            if (degreeRelInfo != null) {
                iRow.getCell("degree").setValue(degreeRelInfo.get(0));
                iRow.getCell("graduateSchool").setValue(degreeRelInfo.get(1));
                iRow.getCell("specialty").setValue(degreeRelInfo.get(2));
            }
            PositionMemberInfo postRelInfo = HRAffairClientUtils.getPersonMemberInfo(personId);
            PersonPositionInfo ppInfo = HRAffairClientUtils.getPersonPositionInfo(personId);
            if (ppInfo != null && ppInfo.getEnterDate() != null) {
                iRow.getCell("enrollDate").setValue((Object)ppInfo.getEnterDate());
                iRow.getCell("serviceYear").setValue((Object)HRAffairClientUtils.getYearDif(ppInfo.getEnterDate(), new Date()));
            }
            if (ppInfo != null && ppInfo.getJobStartDate() != null) {
                iRow.getCell("jobStartDate").setValue((Object)ppInfo.getJobStartDate());
            }
            if (postRelInfo != null) {
                iRow.getCell("position").setValue((Object)postRelInfo.getPosition().getName());
                iRow.getCell("eposition").setValue((Object)postRelInfo.getPosition());
                iRow.getCell("dept").setValue((Object)postRelInfo.getPosition().getAdminOrgUnit().getDisplayName());
                if (iRow.getCell("nominalDept").getValue() == null) {
                    iRow.getCell("nominalDept").setValue((Object)postRelInfo.getPosition().getAdminOrgUnit());
                }
                iRow.getCell("positionDate").setValue((Object)postRelInfo.getBeginDate());
                TechnicalPostInfo jobTitleInfo = HRAffairClientUtils.getJobTitle(personId);
                if (jobTitleInfo != null) {
                    iRow.getCell("jobTitle").setValue((Object)jobTitleInfo.getName());
                }
            }
        }
    }

    @Override
    public void actionDelPerson_actionPerformed(ActionEvent e) throws Exception {
        HRAffairClientUtils.checkIsAudited(this.editData);
        super.actionDelPerson_actionPerformed(e);
        if (this.kdtEntries.getRowCount() <= 0) {
            return;
        }
        int[] selectRows = RetireBillEditUI.getSelectedRows(this.kdtEntries);
        this.kdtEntries.getSelectManager().setSelectMode(10);
        for (int i = selectRows.length - 1; i >= 0; --i) {
            this.kdtEntries.removeRow(selectRows[i]);
        }
        if (this.kdtEntries.getRowCount() >= 0) {
            this.kdtEntries.getSelectManager().select(0, 0);
        }
    }

    public static int[] getSelectedRows(KDTable table) {
        if (table.getSelectManager().size() == 0) {
            return new int[0];
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        int size = table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            IBlock block = KDTBlock.change((KDTable)table, (IBlock)table.getSelectManager().get(i));
            for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                set.add(j);
            }
        }
        int[] rows = new int[set.size()];
        Iterator iter = set.iterator();
        int k = 0;
        while (iter.hasNext()) {
            rows[k++] = (Integer)iter.next();
        }
        return rows;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("adminOrg.id"));
        sic.add(new SelectorItemInfo("adminOrg.name"));
        sic.add(new SelectorItemInfo("adminOrg.displayName"));
        sic.add(new SelectorItemInfo("adminOrg.number"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("hrOrgUnit.name"));
        sic.add(new SelectorItemInfo("hrOrgUnit.number"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("proposer.name"));
        sic.add(new SelectorItemInfo("proposer.id"));
        sic.add(new SelectorItemInfo("proposer.number"));
        sic.add(new SelectorItemInfo("dept"));
        sic.add(new SelectorItemInfo("phone"));
        sic.add(new SelectorItemInfo("applyDate"));
        sic.add(new SelectorItemInfo("isMultiEntry"));
        sic.add(new SelectorItemInfo("bizState"));
        sic.add(new SelectorItemInfo("approveState"));
        sic.add(new SelectorItemInfo("submitState"));
        sic.add(new SelectorItemInfo("entries.person.name"));
        sic.add(new SelectorItemInfo("entries.person.id"));
        sic.add(new SelectorItemInfo("entries.person.number"));
        sic.add(new SelectorItemInfo("entries.gender"));
        sic.add(new SelectorItemInfo("entries.retireDate"));
        sic.add(new SelectorItemInfo("entries.phone"));
        sic.add(new SelectorItemInfo("entries.retireType"));
        sic.add(new SelectorItemInfo("entries.retire.id"));
        sic.add(new SelectorItemInfo("entries.retire.name"));
        sic.add(new SelectorItemInfo("entries.retire.number"));
        sic.add(new SelectorItemInfo("entries.reason"));
        sic.add(new SelectorItemInfo("entries.remark"));
        sic.add(new SelectorItemInfo("entries.dept"));
        sic.add(new SelectorItemInfo("entries.position"));
        sic.add(new SelectorItemInfo("entries.jobTitle"));
        sic.add(new SelectorItemInfo("entries.idCardNO"));
        sic.add(new SelectorItemInfo("entries.birthday"));
        sic.add(new SelectorItemInfo("entries.graduateSchool"));
        sic.add(new SelectorItemInfo("entries.specialty"));
        sic.add(new SelectorItemInfo("entries.degree"));
        sic.add(new SelectorItemInfo("entries.enrollDate"));
        sic.add(new SelectorItemInfo("entries.jobStartDate"));
        sic.add(new SelectorItemInfo("entries.positionDate"));
        sic.add(new SelectorItemInfo("entries.serviceYear"));
        sic.add(new SelectorItemInfo("entries.nominalDept.id"));
        sic.add(new SelectorItemInfo("entries.nominalDept.name"));
        sic.add(new SelectorItemInfo("entries.nominalDept.number"));
        sic.add(new SelectorItemInfo("entries.eposition.id"));
        sic.add(new SelectorItemInfo("entries.eposition.name"));
        sic.add(new SelectorItemInfo("entries.eposition.number"));
        sic.add(new SelectorItemInfo("entries.nominalDept.displayName"));
        return sic;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.btnRowAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        this.btnRowDelete.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
        this.btnCopy.setEnabled(this.btnSubmit.isEnabled());
        this.btnCopy.setVisible(true);
        this.btnCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copytotier"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.kdtEntries.setColumnMoveable(true);
        if (this.kdtEntries.getColumn("idCardNO") != null) {
            this.kdtEntries.getColumn("idCardNO").getStyleAttributes().setNumberFormat("@");
        }
        this.setComboSubmitTypeValueByParam("Ret001");
        this.kdtEntries.getColumn("nominalDept").setRenderer((IBasicRender)new OrgFullNameRender());
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntries.getRowCount() == 0) {
            return;
        }
        KDTSelectBlock sb = null;
        int size = this.kdtEntries.getSelectManager().size();
        if (size > 0) {
            sb = this.kdtEntries.getSelectManager().get(0);
            ICell iCell = null;
            int row = sb.getTop();
            int column = sb.getLeft();
            IColumn iColumn = this.kdtEntries.getColumn(column);
            if (iColumn.getStyleAttributes().isLocked()) {
                return;
            }
            Object value = this.kdtEntries.getCell(row, column).getValue();
            int length = this.kdtEntries.getRowCount();
            for (int i = 0; i < length; ++i) {
                if (i == row || this.kdtEntries.getCell(i, column).getStyleAttributes().isLocked()) continue;
                iCell = this.kdtEntries.getCell(i, column);
                iCell.setValue(value);
            }
        }
    }

    @Override
    public void actionAffairReg_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntries.getRowCount() == 0) {
            return;
        }
        KDTSelectBlock sb = null;
        int size = this.kdtEntries.getSelectManager().size();
        if (this.billId == null) {
            this.billId = this.editData.getId().toString();
        }
        if (size > 0) {
            Object value1;
            sb = this.kdtEntries.getSelectManager().get(0);
            int row = sb.getTop();
            Object value = this.kdtEntries.getCell(row, 1).getValue();
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.number", value));
            filter.getFilterItems().add(new FilterItemInfo("bill.id", (Object)this.billId));
            filter.setMaskString(" #0 and #1 ");
            ev.setFilter(filter);
            HRBillBaseEntryCollection retireCols = RetireBillEntryFactory.getRemoteInstance().getHRBillBaseEntryCollection(ev);
            if (retireCols != null && retireCols.size() > 0) {
                this.actPersonId = ((RetireBillEntryInfo)retireCols.get(0)).getPerson().getId();
            }
            if ((value1 = this.kdtEntries.getCell(row, 22).getValue()) != null) {
                this.actEntryId = BOSUuid.read((String)value1.toString());
            }
        }
        if (this.actPersonId != null && this.actEntryId != null) {
            DataProvider data = new DataProvider();
            this.appHlp.printPreview(RETIRE_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "NO_SELECT_ROW")));
        }
    }

    protected void doFieldPermission() throws Exception {
        super.doFieldPermission();
        FieldPermission fields = this.getOldFieldPermission();
        super.doFieldPermission();
        DataBinder db = this.getMyDataBinder();
        BOSObjectType bizObjectType = this.getBizType();
        IObjectPK userPK = this.getUserPk();
        IObjectPK orgPK = this.getOrgPK(null);
        if (orgPK == null && this.getUIContext().get(this.getMainBizOrgType()) != null) {
            orgPK = new ObjectUuidPK(((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())).getId());
        }
        FieldPermissionService.doFieldPermission((BOSObjectType)bizObjectType, (IObjectPK)userPK, (IObjectPK)orgPK, (DataBinder)db, (FieldPermission)fields);
    }

    private DataBinder getMyDataBinder() {
        DataBinder db = new DataBinder();
        db.registerBinding("entries", RetireBillEntryInfo.class, (Component)this.kdtEntries, "userObject");
        db.registerBinding("proposer", String.class, (Component)this.txtProposer, "text");
        String columnName = null;
        String key = null;
        int size = this.kdtEntries.getColumnCount();
        for (int i = 0; i < size; ++i) {
            columnName = this.kdtEntries.getColumnKey(i);
            key = "oldJob".equals(columnName) ? "oldPosition" : ("newJob".equals(columnName) ? "newPosition" : columnName);
            db.registerBinding("entries." + key, Object.class, (Component)this.kdtEntries, columnName + ".text");
        }
        return db;
    }

    public DataBinder getDataBinder() {
        return this.getMyDataBinder();
    }

    @Override
    public boolean isPrepareActionSubmit() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = new RequestContext();
            OrgUnitInfo initOrg = null;
            if (this.getUIContext() != null && (initOrg = (OrgUnitInfo)this.getUIContext().get(this.getMainOrgType())) != null && initOrg instanceof HROrgUnitInfo) {
                request.put("hr_mainOrgId", (Object)initOrg.getId().toString());
            }
            request.put("nowClientDate", (Object)this.nowDate);
            handler.setRequestContext((Serializable)request);
        }
        return handler;
    }

    public boolean isPrepareActionSave() {
        return true;
    }

    @Override
    public RequestContext prepareActionSubmit(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionSubmit(itemAction);
        request.put("number", (Object)this.txtNumber.getText());
        request.put("actionSubmitSt", (Object)this.actionSubmit.toString());
        return request;
    }

    @Override
    protected String getPrintPath() {
        return RETIRE_FILENAME;
    }

    @Override
    protected String getBaseInfoPrintQuery() {
        return "com.kingdee.eas.hr.affair.app.RetireBaseInfoQuery";
    }

    @Override
    protected String getApproveInfoPrintQuery() {
        return "com.kingdee.eas.hr.affair.app.RetireApproveInfoQuery";
    }

    public class DataProvider
    implements BOSQueryDelegate {
        public IRowSet execute(BOSQueryDataSource ds) {
            try {
                IAffairRegFacade iAffairReg = AffairRegFacadeFactory.getRemoteInstance();
                if (ds.getID() != null) {
                    if (ds.getID().equals("ds8")) {
                        return iAffairReg.getAffairBillRegByEntry(AffairTypeEnum.RETIRE, RetireBillEditUI.this.actEntryId, BOSUuid.read((String)RetireBillEditUI.this.billId));
                    }
                    if (ds.getID().equals("ds9")) {
                        return iAffairReg.getMultiApproveDecByPerson(AffairTypeEnum.RETIRE, RetireBillEditUI.this.actPersonId, BOSUuid.read((String)RetireBillEditUI.this.billId));
                    }
                }
            }
            catch (BOSException e) {
                RetireBillEditUI.this.handUIException(e);
            }
            catch (EASBizException e) {
                RetireBillEditUI.this.handUIException(e);
            }
            return null;
        }
    }
}

