/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.bizmanage;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.HRBizData;
import com.kingdee.eas.hr.base.HRBizDefineFactory;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.shr.base.bizmanage.HRBizDefineTypeEnum;
import com.kingdee.shr.base.bizmanage.PersonChangeMsgFactory;
import com.kingdee.shr.base.bizmanage.PersonChangeMsgInfo;
import com.kingdee.util.StringUtils;

public class PersonBizDataChangeDistributeTool {
    public void writePersonEmpOrgChangeMsgData(Context ctx, HRBizData bizData) throws EASBizException, BOSException {
        String affairEntryId = bizData.getHRAffairActionTransactionLogID();
        String curPersonId = bizData.getNewPosition().getPersonInfo().getId().toString();
        String hrBizDefineId = bizData.getHrbizDefine().getId().toString();
        PersonChangeMsgInfo changeMsgInfo = new PersonChangeMsgInfo();
        changeMsgInfo.setHrBizDefine(hrBizDefineId);
        HRBizDefineInfo bizDefineInfo = HRBizDefineFactory.getLocalInstance(ctx).getHRBizDefineInfo((IObjectPK)new ObjectUuidPK(hrBizDefineId));
        changeMsgInfo.setBizDefineType(HRBizDefineTypeEnum.getEnum((int)bizDefineInfo.getBizDefineType().getValue()));
        changeMsgInfo.setChangeDate(bizData.getStartDate());
        changeMsgInfo.setPerson(curPersonId);
        if (bizData.getActionType() != null) {
            changeMsgInfo.setAffairActionReason(bizData.getActionType().getId().toString());
        }
        this.assembleFlowInPersonChangeMsgInfo(ctx, affairEntryId, changeMsgInfo);
        if (StringUtils.isEmpty((String)changeMsgInfo.getOldEmpOrgRelation()) && StringUtils.isEmpty((String)changeMsgInfo.getNewEmpOrgRelation())) {
            this.assemblePureFlowOutPersonChangeMsgInfo(ctx, bizData, affairEntryId, changeMsgInfo);
        }
        changeMsgInfo.setDealState(false);
        changeMsgInfo.setAffairActionTransId(affairEntryId);
        PersonChangeMsgFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)changeMsgInfo);
    }

    private void assembleFlowInPersonChangeMsgInfo(Context ctx, String affairEntryId, PersonChangeMsgInfo changeMsgInfo) throws BOSException, EASBizException {
        EmpPosOrgRelationCollection empPosColl = this.getEmpPosRelationCollByFlowInAffairID(ctx, affairEntryId);
        EmpPosOrgRelationInfo empPosRelaInfo = null;
        if (empPosColl.size() > 0) {
            empPosRelaInfo = empPosColl.get(0);
        }
        if (empPosRelaInfo != null && empPosRelaInfo.getParent() != null && empPosRelaInfo.getParent().getId() != null) {
            changeMsgInfo.setOldEmpOrgRelation(empPosRelaInfo.getParent().getId().toString());
        }
        if (empPosRelaInfo != null) {
            changeMsgInfo.setNewEmpOrgRelation(empPosRelaInfo.getId().toString());
        }
    }

    private void assemblePureFlowOutPersonChangeMsgInfo(Context ctx, HRBizData bizData, String affairEntryId, PersonChangeMsgInfo changeMsgInfo) throws BOSException, EASBizException {
        EmpPosOrgRelationInfo empPosRelaInfo = null;
        EmpPosOrgRelationCollection empPosColl = this.getEmpPosRelationCollByFlowOoutAffairID(ctx, affairEntryId);
        if (empPosColl.size() > 0) {
            empPosRelaInfo = empPosColl.get(0);
        }
        if (empPosRelaInfo != null) {
            changeMsgInfo.setOldEmpOrgRelation(empPosRelaInfo.getId().toString());
        }
    }

    private EmpPosOrgRelationCollection getEmpPosRelationCollByFlowInAffairID(Context ctx, String affairEntryId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("flowInAffairID", (Object)affairEntryId, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        EmpPosOrgRelationCollection empPosColl = EmpPosOrgRelationFactory.getLocalInstance(ctx).getEmpPosOrgRelationCollection(viewInfo);
        return empPosColl;
    }

    private EmpPosOrgRelationCollection getEmpPosRelationCollByFlowOoutAffairID(Context ctx, String affairEntryId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("flowOutAffairID", (Object)affairEntryId, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        SorterItemCollection sorterItemColl = new SorterItemCollection();
        SorterItemInfo sorterInfo = new SorterItemInfo("assignType");
        sorterInfo.setSortType(SortType.DESCEND);
        viewInfo.setSorter(sorterItemColl);
        EmpPosOrgRelationCollection empPosColl = EmpPosOrgRelationFactory.getLocalInstance(ctx).getEmpPosOrgRelationCollection(viewInfo);
        return empPosColl;
    }
}

