/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.eas.hr.base.client.ChartDragUndoEdit;
import com.kingdee.eas.hr.base.client.ChartRemoveUndoEdit;
import com.kingdee.eas.hr.base.client.Edge;
import com.kingdee.eas.hr.base.client.IOrgChartTreeBuilder;
import com.kingdee.eas.hr.base.client.Node;
import com.kingdee.eas.hr.base.client.SimpleEdgeInfo;
import com.kingdee.eas.hr.base.client.SimpleNodeInfo;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class DesignerPanel
extends JPanel
implements Printable {
    private List selectedNodes = new ArrayList();
    private List selectedEdges = new ArrayList();
    private Point oldPoint;
    private List nodeList = new ArrayList();
    private List edgeList = new ArrayList();
    private IOrgChartTreeBuilder chartBuilder = null;
    private Rectangle selectRect = null;
    private double scale = 1.0;
    private Color edgeColor = Color.BLACK;
    private Color nodeBorderColor = Color.BLACK;
    private Color nodeBackgroundColor = Color.WHITE;
    private Color fontColor = Color.BLACK;
    private Font contentFont = null;
    private HashMap renderMap = new HashMap();
    private Node rootNode = null;
    private UndoManager undoMgr;
    private List undoNodeList = null;
    private List undoEdgeList = null;
    private List oldNodeInfoList = null;
    private List newNodeInfoList = null;
    private List oldEdgeInfoList = null;
    private List newEdgeInfoList = null;
    private boolean isDrag = false;
    private transient PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    public DesignerPanel() {
        this(null, null, null);
    }

    public List getSelectedNodes() {
        return this.selectedNodes;
    }

    public List getSelectedEdges() {
        return this.selectedEdges;
    }

    public DesignerPanel(IOrgChartTreeBuilder chartBuilder) {
        this(chartBuilder.getNodeList(), chartBuilder.getEdgeList(), chartBuilder);
    }

    public DesignerPanel(List nodes, List edges) {
        this(nodes, edges, null);
    }

    public DesignerPanel(List nodes, List edges, IOrgChartTreeBuilder chartBuilder) {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DesignerPanel.this.mousePressedOrg(e);
                DesignerPanel.this.undoDataForMousePressed();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DesignerPanel.this.mouseReleasedOrg(e);
                if (DesignerPanel.this.isDrag) {
                    DesignerPanel.this.undoDataForMouseReleased();
                } else {
                    DesignerPanel.this.undoDataForMousePressed();
                }
                DesignerPanel.this.isDrag = false;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                DesignerPanel.this.mouseDraggedOrg(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                DesignerPanel.this.mouseMovedOrg(e);
            }
        });
        if (nodes != null) {
            this.nodeList = nodes;
        }
        if (edges != null) {
            this.edgeList = edges;
        }
        this.chartBuilder = chartBuilder;
        this.renderMap.put("CHART_RENDER", chartBuilder);
        this.setBackground(Color.WHITE);
        this.updatePreferedSize();
    }

    private void undoDataForMousePressed() {
        int i;
        this.oldNodeInfoList = new ArrayList();
        this.oldEdgeInfoList = new ArrayList();
        this.undoNodeList = new ArrayList();
        int size = this.selectedNodes.size();
        for (i = 0; i < size; ++i) {
            this.undoNodeList.add(this.selectedNodes.get(i));
        }
        this.undoEdgeList = new ArrayList();
        size = this.selectedEdges.size();
        for (i = 0; i < size; ++i) {
            this.undoEdgeList.add(this.selectedEdges.get(i));
        }
        SimpleNodeInfo simpleNode = null;
        Node node = null;
        int size2 = this.undoNodeList.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            node = (Node)this.undoNodeList.get(i2);
            simpleNode = new SimpleNodeInfo();
            simpleNode.setId(node.getId());
            simpleNode.setName(node.getName());
            simpleNode.setX(node.getX());
            simpleNode.setY(node.getY());
            simpleNode.setWidth(node.getWidth());
            simpleNode.setHeight(node.getHeight());
            simpleNode.setBackground(node.getBackground());
            simpleNode.setBorderColor(node.getBorderColor());
            simpleNode.setFontColor(node.getFontColor());
            int length = node.getEdgeList().size();
            for (int t = 0; t < length; ++t) {
                if (this.undoEdgeList.contains(node.getEdgeList().get(t))) continue;
                this.undoEdgeList.add(node.getEdgeList().get(t));
            }
            this.oldNodeInfoList.add(simpleNode);
        }
        SimpleEdgeInfo simpleEdge = null;
        Edge edge = null;
        int size3 = this.undoEdgeList.size();
        for (int i3 = 0; i3 < size3; ++i3) {
            edge = (Edge)this.undoEdgeList.get(i3);
            simpleEdge = new SimpleEdgeInfo();
            simpleEdge.setColor(edge.getColor());
            simpleEdge.setPoints(edge.getPoints());
            this.oldEdgeInfoList.add(simpleEdge);
        }
    }

    private void undoDataForMouseReleased() {
        this.newNodeInfoList = new ArrayList();
        this.newEdgeInfoList = new ArrayList();
        SimpleNodeInfo simpleNode = null;
        Node node = null;
        int size = this.undoNodeList.size();
        for (int i = 0; i < size; ++i) {
            node = (Node)this.undoNodeList.get(i);
            simpleNode = new SimpleNodeInfo();
            simpleNode.setId(node.getId());
            simpleNode.setName(node.getName());
            simpleNode.setX(node.getX());
            simpleNode.setY(node.getY());
            simpleNode.setWidth(node.getWidth());
            simpleNode.setHeight(node.getHeight());
            simpleNode.setBackground(node.getBackground());
            simpleNode.setBorderColor(node.getBorderColor());
            simpleNode.setFontColor(node.getFontColor());
            this.newNodeInfoList.add(simpleNode);
        }
        SimpleEdgeInfo simpleEdge = null;
        Edge edge = null;
        int size2 = this.undoEdgeList.size();
        for (int i = 0; i < size2; ++i) {
            edge = (Edge)this.undoEdgeList.get(i);
            simpleEdge = new SimpleEdgeInfo();
            simpleEdge.setColor(edge.getColor());
            simpleEdge.setPoints(edge.getPoints());
            this.newEdgeInfoList.add(simpleEdge);
        }
        if (this.undoMgr == null) {
            this.undoMgr = new UndoManager();
        }
        ChartDragUndoEdit undoEdit = new ChartDragUndoEdit(this);
        undoEdit.setNodeList(this.undoNodeList);
        undoEdit.setEdgeList(this.undoEdgeList);
        undoEdit.setOldNodeInfoList(this.oldNodeInfoList);
        undoEdit.setNewNodeInfoList(this.newNodeInfoList);
        undoEdit.setOldEdgeInfoList(this.oldEdgeInfoList);
        undoEdit.setNewEdgeInfoList(this.newEdgeInfoList);
        this.undoMgr.addEdit(undoEdit);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(Object oldValue, Object newValue) {
        this.listeners.firePropertyChange("value", oldValue, newValue);
    }

    public void mouseReleasedOrg(MouseEvent e) {
        if (this.selectRect != null) {
            int i;
            int size = this.nodeList.size();
            for (i = 0; i < size; ++i) {
                Node node = (Node)this.nodeList.get(i);
                if (!this.selectRect.contains(node.getRect())) continue;
                node.isSelected = true;
                this.selectedNodes.add(node);
            }
            size = this.edgeList.size();
            for (i = 0; i < size; ++i) {
                Edge edge = (Edge)this.edgeList.get(i);
                if (!edge.isInRect(this.selectRect)) continue;
                edge.isSelected = true;
                this.selectedEdges.add(edge);
            }
            this.selectRect = null;
            this.repaint();
        }
        this.updatePreferedSize();
        this.firePropertyChange(e, this);
    }

    public void updatePreferedSize() {
        int i;
        int maxWidth = 0;
        int maxHeight = 0;
        Node node = null;
        Edge edge = null;
        Point point = null;
        int size = this.nodeList.size();
        for (i = 0; i < size; ++i) {
            node = (Node)this.nodeList.get(i);
            if (node.getX() + node.getWidth() > maxWidth) {
                maxWidth = node.getX() + node.getWidth();
            }
            if (node.getY() + node.getHeight() <= maxHeight) continue;
            maxHeight = node.getY() + node.getHeight();
        }
        size = this.edgeList.size();
        for (i = 0; i < size; ++i) {
            edge = (Edge)this.edgeList.get(i);
            int length = edge.getPoints().size();
            for (int t = 0; t < length; ++t) {
                point = (Point)edge.getPoints().get(t);
                if (point.x > maxWidth) {
                    maxWidth = point.x;
                }
                if (point.y <= maxHeight) continue;
                maxHeight = point.y;
            }
        }
        maxWidth = (int)((double)(maxWidth + 20) * this.scale);
        maxHeight = (int)((double)(maxHeight + 20) * this.scale);
        this.setPreferredSize(new Dimension(maxWidth, maxHeight));
        if (this.getParent() instanceof JViewport) {
            ((JViewport)this.getParent()).setViewSize(new Dimension(maxWidth, maxHeight));
        }
    }

    private void clearSelectedNodeAndEdge() {
        int i;
        int size;
        if (this.selectedNodes.size() > 0) {
            size = this.selectedNodes.size();
            for (i = 0; i < size; ++i) {
                ((Node)this.selectedNodes.get((int)i)).isSelected = false;
            }
        }
        if (this.selectedEdges.size() > 0) {
            size = this.selectedEdges.size();
            for (i = 0; i < size; ++i) {
                ((Edge)this.selectedEdges.get((int)i)).isSelected = false;
            }
        }
    }

    public void mouseMovedOrg(MouseEvent e) {
        Point point = new Point((int)((double)e.getPoint().x / this.scale), (int)((double)e.getPoint().y / this.scale));
        int size = this.nodeList.size();
        for (int i = 0; i < size; ++i) {
            Cursor cursor = ((Node)this.nodeList.get(i)).getMouseCursor(point);
            if (cursor == null) continue;
            if (this.getCursor() != cursor) {
                this.setCursor(cursor);
            }
            return;
        }
        if (this.getCursor() != Cursor.getDefaultCursor()) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mousePressedOrg(MouseEvent e) {
        int i;
        int size;
        Point point = new Point((int)((double)e.getPoint().x / this.scale), (int)((double)e.getPoint().y / this.scale));
        if (this.selectedNodes.size() != 0 && !e.isControlDown()) {
            size = this.selectedNodes.size();
            for (i = 0; i < size; ++i) {
                if (!((Node)this.selectedNodes.get(i)).contains(point)) continue;
                this.oldPoint = point;
                return;
            }
            size = this.selectedNodes.size();
            for (i = 0; i < size; ++i) {
                ((Node)this.selectedNodes.get((int)i)).isSelected = false;
            }
            this.repaint();
            this.selectedNodes.clear();
        }
        size = this.nodeList.size();
        for (i = 0; i < size; ++i) {
            Node node = (Node)this.nodeList.get(i);
            if (!node.contains(point)) continue;
            this.oldPoint = point;
            if (!e.isControlDown()) {
                this.clearSelectedNodeAndEdge();
                this.selectedEdges.clear();
            }
            node.isSelected = true;
            this.selectedNodes.add(node);
            this.repaint();
            return;
        }
        if (this.selectedEdges.size() == 1 && ((Edge)this.selectedEdges.get(0)).contains(this.getGraphics(), point)) {
            this.oldPoint = point;
            ((Edge)this.selectedEdges.get(0)).setSelectPoint(point);
            if (SwingUtilities.isRightMouseButton(e)) {
                ((Edge)this.selectedEdges.get(0)).addPoint(point);
            }
            this.repaint();
            return;
        }
        if (this.selectedEdges.size() < 2) {
            size = this.edgeList.size();
            for (i = 0; i < size; ++i) {
                Edge edge = (Edge)this.edgeList.get(i);
                if (!edge.contains(this.getGraphics(), point)) continue;
                if (!e.isControlDown()) {
                    this.clearSelectedNodeAndEdge();
                    this.selectedNodes.clear();
                }
                this.oldPoint = point;
                edge.isSelected = true;
                edge.setSelectPoint(point);
                if (SwingUtilities.isRightMouseButton(e)) {
                    edge.addPoint(point);
                }
                this.selectedEdges.add(edge);
                this.repaint();
                return;
            }
        }
        if (this.selectedNodes.size() > 0) {
            size = this.selectedNodes.size();
            for (i = 0; i < size; ++i) {
                ((Node)this.selectedNodes.get((int)i)).isSelected = false;
            }
            this.repaint();
        }
        if (this.selectedEdges.size() > 0) {
            size = this.selectedEdges.size();
            for (i = 0; i < size; ++i) {
                ((Edge)this.selectedEdges.get((int)i)).isSelected = false;
            }
            this.repaint();
        }
        this.oldPoint = point;
        this.selectedEdges.clear();
        this.selectedNodes.clear();
    }

    private boolean canDrag(Point offsetPoint) {
        Point point = null;
        Edge edge = null;
        int size = this.selectedEdges.size();
        for (int i = 0; i < size; ++i) {
            edge = (Edge)this.selectedEdges.get(i);
            int length = edge.getPoints().size();
            for (int t = 0; t < length; ++t) {
                point = (Point)edge.getPoints().get(t);
                if (t == 0 || t == length - 1 || point.x + offsetPoint.x >= 0 && point.y + offsetPoint.y >= 0) continue;
                return false;
            }
        }
        Node node = null;
        int size2 = this.selectedNodes.size();
        for (int i = 0; i < size2; ++i) {
            node = (Node)this.selectedNodes.get(i);
            if (node.getX() + offsetPoint.x >= 0 && node.getY() + offsetPoint.y >= 0) continue;
            return false;
        }
        return true;
    }

    private void autoScroll(Point p) {
        Rectangle view = this.getBounds();
        if (this.getParent() instanceof JViewport) {
            view = ((JViewport)this.getParent()).getViewRect();
        }
        if (view.x + view.width - p.x < 20) {
            p.x += 20;
        }
        if (view.y + view.height - p.y < 20) {
            p.y += 20;
        }
        this.scrollRectToVisible(new Rectangle(p.x, p.y, 1, 1));
    }

    public void mouseDraggedOrg(MouseEvent e) {
        int i;
        int size;
        this.autoScroll(e.getPoint());
        Point point = new Point((int)((double)e.getPoint().x / this.scale), (int)((double)e.getPoint().y / this.scale));
        if (this.selectedEdges.size() == 0 && this.selectedNodes.size() == 0) {
            if (point.x < this.oldPoint.x && point.y < this.oldPoint.y) {
                this.selectRect = new Rectangle(point.x, point.y, this.oldPoint.x - point.x, this.oldPoint.y - point.y);
            } else if (point.x < this.oldPoint.x && point.y > this.oldPoint.y) {
                this.selectRect = new Rectangle(point.x, this.oldPoint.y, this.oldPoint.x - point.x, point.y - this.oldPoint.y);
            } else if (point.x > this.oldPoint.x && point.y < this.oldPoint.y) {
                this.selectRect = new Rectangle(this.oldPoint.x, point.y, point.x - this.oldPoint.x, this.oldPoint.y - point.y);
            } else if (point.x > this.oldPoint.x && point.y > this.oldPoint.y) {
                this.selectRect = new Rectangle(this.oldPoint.x, this.oldPoint.y, point.x - this.oldPoint.x, point.y - this.oldPoint.y);
            }
            this.repaint();
            return;
        }
        Point offsetPoint = new Point(point.x - this.oldPoint.x, point.y - this.oldPoint.y);
        if (!this.canDrag(offsetPoint)) {
            return;
        }
        this.isDrag = true;
        if (this.selectedEdges.size() == 1) {
            ((Edge)this.selectedEdges.get(0)).moveSelectPointTo(offsetPoint);
            if (this.selectedNodes.size() == 0) {
                this.oldPoint = point;
            }
        } else {
            size = this.selectedEdges.size();
            for (i = 0; i < size; ++i) {
                ((Edge)this.selectedEdges.get(i)).moveAllPointTo(offsetPoint);
            }
        }
        if (this.selectedNodes.size() == 0 || this.oldPoint == null) {
            this.repaint();
            return;
        }
        size = this.selectedNodes.size();
        for (i = 0; i < size; ++i) {
            Node currentNode = (Node)this.selectedNodes.get(i);
            if (this.getCursor() == Cursor.getDefaultCursor()) {
                currentNode.setX(currentNode.getX() + point.x - this.oldPoint.x);
                currentNode.setY(currentNode.getY() + point.y - this.oldPoint.y);
            } else if (this.getCursor() == Cursor.getPredefinedCursor(6)) {
                currentNode.setX(currentNode.getX() + point.x - this.oldPoint.x);
                currentNode.setY(currentNode.getY() + point.y - this.oldPoint.y);
                currentNode.setWidth(currentNode.getWidth() - (point.x - this.oldPoint.x));
                currentNode.setHeight(currentNode.getHeight() - (point.y - this.oldPoint.y));
            } else if (this.getCursor() == Cursor.getPredefinedCursor(10)) {
                currentNode.setX(currentNode.getX() + point.x - this.oldPoint.x);
                currentNode.setWidth(currentNode.getWidth() - (point.x - this.oldPoint.x));
            } else if (this.getCursor() == Cursor.getPredefinedCursor(4)) {
                currentNode.setX(currentNode.getX() + point.x - this.oldPoint.x);
                currentNode.setWidth(currentNode.getWidth() - (point.x - this.oldPoint.x));
                currentNode.setHeight(currentNode.getHeight() + point.y - this.oldPoint.y);
            } else if (this.getCursor() == Cursor.getPredefinedCursor(8)) {
                currentNode.setY(currentNode.getY() + point.y - this.oldPoint.y);
                currentNode.setHeight(currentNode.getHeight() - (point.y - this.oldPoint.y));
            } else if (this.getCursor() == Cursor.getPredefinedCursor(9)) {
                currentNode.setHeight(currentNode.getHeight() + point.y - this.oldPoint.y);
            } else if (this.getCursor() == Cursor.getPredefinedCursor(7)) {
                currentNode.setY(currentNode.getY() + point.y - this.oldPoint.y);
                currentNode.setWidth(currentNode.getWidth() + point.x - this.oldPoint.x);
                currentNode.setHeight(currentNode.getHeight() - (point.y - this.oldPoint.y));
            } else if (this.getCursor() == Cursor.getPredefinedCursor(11)) {
                currentNode.setWidth(currentNode.getWidth() + point.x - this.oldPoint.x);
            } else if (this.getCursor() == Cursor.getPredefinedCursor(5)) {
                currentNode.setWidth(currentNode.getWidth() + point.x - this.oldPoint.x);
                currentNode.setHeight(currentNode.getHeight() + point.y - this.oldPoint.y);
            }
            currentNode.adjustEdge(point.x - this.oldPoint.x, point.y - this.oldPoint.y);
        }
        this.oldPoint = point;
        this.repaint();
    }

    public void zoomIn() {
        this.scale *= 0.9;
        this.updatePreferedSize();
    }

    public void zoomOut() {
        this.scale *= 1.1;
        this.updatePreferedSize();
    }

    public void resetZoom() {
        this.scale = 1.0;
        this.updatePreferedSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.scale(this.scale, this.scale);
        this.paintGraph(g2d, this.renderMap);
    }

    public void paintGraph(Graphics g, HashMap renderMap) {
        int i;
        int size = this.nodeList.size();
        for (i = 0; i < size; ++i) {
            ((Node)this.nodeList.get(i)).render(g, renderMap);
        }
        size = this.edgeList.size();
        for (i = 0; i < size; ++i) {
            ((Edge)this.edgeList.get(i)).render(g, renderMap);
        }
        if (this.selectRect != null) {
            Color oldColor = g.getColor();
            g.setColor(new Color(204, 157, 96));
            g.drawRect(this.selectRect.x, this.selectRect.y, this.selectRect.width, this.selectRect.height);
            g.setColor(oldColor);
        }
    }

    public void setEdgeColor(Color edgeColor) {
        this.edgeColor = edgeColor;
        int size = this.edgeList.size();
        for (int i = 0; i < size; ++i) {
            ((Edge)this.edgeList.get(i)).setColor(edgeColor);
        }
        this.repaint();
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public HashMap getRenderMap() {
        return this.renderMap;
    }

    public void setNodeBorderColor(Color nodeBorderColor) {
        this.nodeBorderColor = nodeBorderColor;
        int size = this.nodeList.size();
        for (int i = 0; i < size; ++i) {
            ((Node)this.nodeList.get(i)).setBorderColor(nodeBorderColor);
        }
        this.repaint();
    }

    public Color getNodeBorderColor() {
        return this.nodeBorderColor;
    }

    public void setNodeBackgroundColor(Color nodeBackgroundColor) {
        this.nodeBackgroundColor = nodeBackgroundColor;
        int size = this.nodeList.size();
        for (int i = 0; i < size; ++i) {
            ((Node)this.nodeList.get(i)).setBackground(nodeBackgroundColor);
        }
        this.repaint();
    }

    public Color getNodeBackgroundColor() {
        return this.nodeBackgroundColor;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
        int size = this.nodeList.size();
        for (int i = 0; i < size; ++i) {
            ((Node)this.nodeList.get(i)).setFontColor(fontColor);
        }
        this.repaint();
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setContentFont(Font contentFont) {
        this.contentFont = contentFont;
        int size = this.nodeList.size();
        for (int i = 0; i < size; ++i) {
            ((Node)this.nodeList.get(i)).setFont(contentFont);
        }
        this.repaint();
    }

    public Font getContentFont() {
        return this.contentFont;
    }

    public void appendChildNode(ArrayList nodeList, ArrayList edgeList) {
        this.nodeList.addAll(nodeList);
        this.edgeList.addAll(edgeList);
        this.updatePreferedSize();
        this.firePropertyChange(null, this);
    }

    public void removeChildNode(Node parentNode) {
        ArrayList removedNodeList = new ArrayList();
        ArrayList removedEdgeList = new ArrayList();
        this.removeChildNodes(null, parentNode, removedNodeList, removedEdgeList);
        Edge edge = null;
        for (int i = parentNode.getEdgeList().size() - 1; i >= 0; --i) {
            edge = (Edge)parentNode.getEdgeList().get(i);
            if (edge.getSourceNode() != parentNode) continue;
            parentNode.getEdgeList().remove(edge);
        }
        if (this.undoMgr == null) {
            this.undoMgr = new UndoManager();
        }
        ChartRemoveUndoEdit undoEdit = new ChartRemoveUndoEdit(this);
        undoEdit.setRemovedEdgeList(removedEdgeList);
        undoEdit.setRemovedNodeList(removedNodeList);
        this.undoMgr.addEdit(undoEdit);
        this.updatePreferedSize();
        this.firePropertyChange(null, this);
    }

    private void removeChildNodes(Edge parentEdge, Node parentNode, List removedNodeList, List removedEdgeList) {
        List edges = parentNode.getEdgeList();
        Edge edge = null;
        int size = edges.size();
        for (int i = 0; i < size; ++i) {
            edge = (Edge)edges.get(i);
            if (edge.getSourceNode() != parentNode) continue;
            this.removeChildNodes(edge, edge.getTargetNode(), removedNodeList, removedEdgeList);
        }
        parentNode.getEdgeList().remove(parentEdge);
        if (this.selectedEdges.contains(parentEdge)) {
            this.selectedEdges.remove(parentEdge);
        }
        this.edgeList.remove(parentEdge);
        if (parentEdge != null) {
            removedEdgeList.add(parentEdge);
        }
        if (parentEdge != null) {
            if (this.selectedNodes.contains(parentNode)) {
                this.selectedNodes.remove(parentNode);
            }
            this.nodeList.remove(parentNode);
            removedNodeList.add(parentNode);
        }
    }

    public void removeNodes(List nodes) {
        Node node = null;
        List edges = null;
        Edge edge = null;
        ArrayList<Node> removedNodeList = new ArrayList<Node>();
        ArrayList<Edge> removedEdgeList = new ArrayList<Edge>();
        for (int i = nodes.size() - 1; i >= 0; --i) {
            node = (Node)nodes.get(i);
            edges = node.getEdgeList();
            for (int t = edges.size() - 1; t >= 0; --t) {
                edge = (Edge)edges.get(t);
                if (edge.getTargetNode() != node) continue;
                this.edgeList.remove(edge);
                removedEdgeList.add(edge);
                if (!this.selectedEdges.contains(edge)) continue;
                this.selectedEdges.remove(edge);
            }
            this.nodeList.remove(node);
            removedNodeList.add(node);
            if (!this.selectedNodes.contains(node)) continue;
            this.selectedNodes.remove(node);
        }
        if (this.undoMgr == null) {
            this.undoMgr = new UndoManager();
        }
        ChartRemoveUndoEdit undoEdit = new ChartRemoveUndoEdit(this);
        undoEdit.setRemovedEdgeList(removedEdgeList);
        undoEdit.setRemovedNodeList(removedNodeList);
        this.undoMgr.addEdit(undoEdit);
        this.updatePreferedSize();
        this.firePropertyChange(null, this);
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int rows;
        int sr = Toolkit.getDefaultToolkit().getScreenResolution();
        double scale = 72.0 / (double)sr;
        int w = (int)pageFormat.getImageableWidth();
        int h = (int)pageFormat.getImageableHeight();
        Dimension pSize = this.getPreferredSize();
        int cols = (int)Math.max(Math.ceil((double)pSize.width * scale / (double)w), 1.0);
        if (pageIndex < cols * (rows = (int)Math.max(Math.ceil((double)pSize.height * scale / (double)h), 1.0))) {
            RepaintManager currentManager = RepaintManager.currentManager(this);
            currentManager.setDoubleBufferingEnabled(false);
            int dx = pageIndex % cols * w;
            int dy = pageIndex % rows * h;
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            g2d.translate(-dx, -dy);
            g2d.scale(scale, scale);
            this.paint(g2d);
            currentManager.setDoubleBufferingEnabled(true);
            return 0;
        }
        return 1;
    }

    public void setRootNode(Node rootNode) {
        this.rootNode = rootNode;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public List getNodeList() {
        return this.nodeList;
    }

    public List getEdgeList() {
        return this.edgeList;
    }

    public void locateNode(Node node) {
        this.clearSelectedNodeAndEdge();
        this.selectedEdges.clear();
        this.selectedNodes.clear();
        node.isSelected = true;
        this.selectedNodes.add(node);
        Rectangle view = this.getBounds();
        if (this.getParent() instanceof JViewport) {
            view = ((JViewport)this.getParent()).getViewRect();
        }
        if (node.getX() < view.width) {
            this.scrollRectToVisible(new Rectangle(0, node.getY() + view.height / 2, 1, 1));
        } else {
            this.scrollRectToVisible(new Rectangle(node.getX() + view.width / 2, node.getY() + view.height / 2, 1, 1));
        }
        this.repaint();
    }

    public void setChartBuilder(IOrgChartTreeBuilder chartBuilder) {
        this.chartBuilder = chartBuilder;
        this.renderMap.put("CHART_RENDER", chartBuilder);
        this.nodeList = chartBuilder.getNodeList();
        this.edgeList = chartBuilder.getEdgeList();
        if (this.undoMgr != null) {
            this.undoMgr.discardAllEdits();
        }
        this.updatePreferedSize();
        this.firePropertyChange(null, this);
    }

    public void reset(IOrgChartTreeBuilder chartBuilder, List nodeList, List edgeList) {
        this.chartBuilder = chartBuilder;
        this.renderMap.put("CHART_RENDER", chartBuilder);
        this.nodeList = nodeList;
        this.edgeList = edgeList;
        this.updatePreferedSize();
        this.firePropertyChange(null, this);
    }

    public IOrgChartTreeBuilder getTreeBuilder() {
        return this.chartBuilder;
    }

    public void undo() {
        if (this.undoMgr == null) {
            return;
        }
        try {
            this.undoMgr.undo();
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
    }

    public void redo() {
        if (this.undoMgr == null) {
            return;
        }
        try {
            this.undoMgr.redo();
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }
}

