/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.util.StringUtils;
import com.kingdee.eas.hr.base.AffairActionReasonInfo;
import com.kingdee.eas.hr.base.AffairActioniOperateException;
import com.kingdee.eas.hr.base.EmpPosOrgRelationConstraints;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFacadeFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EmpPositionInfo;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.F7ScopeEnum;
import com.kingdee.eas.hr.base.HRBizData;
import com.kingdee.eas.hr.base.HRBizDefineCheckUtil;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.LogActionTypeEnum;
import com.kingdee.eas.hr.base.client.AbstractEmpPosOrgActiveRelationEditUI;
import com.kingdee.eas.hr.base.client.EmpPosOrgActiveRelationListUI;
import com.kingdee.eas.hr.base.client.util.HRBizDefineClientUtils;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class EmpPosOrgActiveRelationEditUI
extends AbstractEmpPosOrgActiveRelationEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EmpPosOrgActiveRelationEditUI.class);
    HRBizData bizData = null;
    EmpPosOrgRelationInfo currentRelation = null;
    PersonInfo personInfo = null;
    HRBizDefineInfo defineInfo = null;

    public void initLayout() {
        super.initLayout();
        this.prmtHrbizDefine.setQueryInfo("com.kingdee.eas.hr.base.app.HRBizDefineF7Query");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String relationID = (String)this.getUIContext().get(EmpPosOrgRelationConstraints.EMPPOSORGRELATIONID);
        if (StringUtils.isEmpty((String)relationID)) {
            throw new AffairActioniOperateException(AffairActioniOperateException.OLDPOSITIONNOTNULL);
        }
        this.currentRelation = EmpPosOrgRelationFacadeFactory.getRemoteInstance().getEmpPosOrgRelationValue(relationID);
        if (!DateTimeUtils.dayEquals((Date)this.currentRelation.getLEFFDT(), (Date)HRUtil.getMaxEndDate())) {
            throw new AffairActioniOperateException(AffairActioniOperateException.OPERATERECORDNOTVALID);
        }
        this.setHrBizDefineFilter();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.beforeStoreFields(e);
        this.storeFields();
        this.bizData.setActionSource(LogActionTypeEnum.employeeModify);
        EmpPosOrgRelationFacadeFactory.getRemoteInstance().operateHRBizDefine(this.bizData);
        this.setSave(true);
        this.refreshParentUI();
        this.getUIWindow().close();
    }

    private void setHrBizDefineFilter() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("assignType", (Object)new Integer(this.currentRelation.getAssignType().getValue())));
        if (this.currentRelation.getPositionstatus() != null) {
            filter.getFilterItems().add(new FilterItemInfo("positionstatus", (Object)new Integer(this.currentRelation.getPositionstatus().getValue())));
        }
        if (this.currentRelation.getLaborRelation() != null && this.currentRelation.getLaborRelation().getLaborRelationState() != null) {
            String filterEmployeeType = "select FBizDefineID from T_HR_HRBizDefEmpType where FEmpTypeID='" + this.currentRelation.getLaborRelation().getLaborRelationState().getId().toString() + "'";
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)filterEmployeeType, CompareType.INNER));
        }
        filter.getFilterItems().add(new FilterItemInfo("isEmpModify", (Object)new Integer(1)));
        viewInfo.setFilter(filter);
        this.prmtHrbizDefine.setEntityViewInfo(viewInfo);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.bizData = new HRBizData();
        EmpPositionInfo oldPositionInfo = new EmpPositionInfo();
        oldPositionInfo.setPersonInfo(this.currentRelation.getPerson());
        oldPositionInfo.setAdminInfo(this.currentRelation.getAdminOrg());
        oldPositionInfo.setPositionInfo(this.currentRelation.getPosition());
        oldPositionInfo.setEmployeeType(this.currentRelation.getLaborRelation().getLaborRelationState());
        this.bizData.setOldPosition(oldPositionInfo);
        EmpPositionInfo newPositionInfo = new EmpPositionInfo();
        newPositionInfo.setPersonInfo(this.currentRelation.getPerson());
        newPositionInfo.setAdminInfo((AdminOrgUnitInfo)this.prmptAdminOrg.getValue());
        newPositionInfo.setPositionInfo((PositionInfo)this.prmptPosition.getValue());
        newPositionInfo.setEmployeeType((EmployeeTypeInfo)this.combEmployeeType.getSelectedItem());
        this.bizData.setNewPosition(newPositionInfo);
        this.bizData.setHrbizDefine((HRBizDefineInfo)this.prmtHrbizDefine.getValue());
        this.bizData.setStartDate((Date)this.pkEffectStartDate.getValue());
        this.bizData.setActionType((AffairActionReasonInfo)this.compActionReason.getSelectedItem());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        PositionPromptBox2 positionF7 = new PositionPromptBox2((IUIObject)this);
        positionF7.setSealUp("true");
        positionF7.setScope(F7ScopeEnum.UserAdminOrgRange, null);
        this.prmptPosition.setSelector((KDPromptSelector)positionF7);
        AdminByOrgRangePromptBox adminF7 = new AdminByOrgRangePromptBox((IUIObject)this);
        adminF7.setIncludeSealUp(false);
        adminF7.setScope(F7ScopeEnum.UserAdminOrgRange, null);
        this.prmptAdminOrg.setSelector((KDPromptSelector)adminF7);
    }

    protected IObjectValue createNewData() {
        return new EmpPosOrgRelationInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EmpPosOrgRelationFactory.getRemoteInstance();
    }

    @Override
    protected void prmptPosition_dataChanged(DataChangeEvent e) throws Exception {
        PositionInfo position = (PositionInfo)e.getNewValue();
        if (position != null) {
            this.prmptAdminOrg.setData((Object)position.getAdminOrgUnit());
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (!DateTimeUtils.dayAfter((Date)DateTimeUtils.truncateDate((Date)((Date)this.pkEffectStartDate.getValue())), (Date)this.currentRelation.getEFFDT())) {
            if (DateTimeUtils.dayEquals((Date)DateTimeUtils.truncateDate((Date)((Date)this.pkEffectStartDate.getValue())), (Date)this.currentRelation.getEFFDT())) {
                if (HRBizDefineCheckUtil.needSourceAdmin(this.defineInfo)) {
                    throw new AffairActioniOperateException(AffairActioniOperateException.EFFECTDATAMUSTAFTERRELATE);
                }
            } else {
                throw new AffairActioniOperateException(AffairActioniOperateException.EFFECTDATAMUSTAFTERRELATE);
            }
        }
        if (this.prmtHrbizDefine.getValue() == null) {
            throw new AffairActioniOperateException(AffairActioniOperateException.HRBIZDEFINE);
        }
        if (HRBizDefineCheckUtil.needTargetEmployeeType(this.defineInfo) && this.combEmployeeType.getSelectedItem() == null) {
            throw new AffairActioniOperateException(AffairActioniOperateException.EMPLOYEETYPENOTNULL);
        }
        if (HRBizDefineCheckUtil.needActionType(this.defineInfo) && this.compActionReason.getSelectedItem() == null) {
            throw new AffairActioniOperateException(AffairActioniOperateException.ACTIONREASONNOTNULL);
        }
        if (HRBizDefineCheckUtil.needTargetPosition(this.defineInfo) && this.prmptPosition.getValue() == null) {
            throw new AffairActioniOperateException(AffairActioniOperateException.TARGETPOSITIONINFONOTNULL);
        }
        if (HRBizDefineCheckUtil.needTargetAdmin(this.defineInfo) && this.prmptAdminOrg.getData() == null) {
            throw new AffairActioniOperateException(AffairActioniOperateException.ADMINORGCANTNULL);
        }
        super.beforeStoreFields(e);
    }

    public boolean isModify() {
        return false;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionCanceled_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    protected void prmtHrbizDefine_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtHrbizDefine_dataChanged(e);
        if (e.getNewValue() != null) {
            this.defineInfo = HRBizDefineClientUtils.getHRBizDefineInfo(((HRBizDefineInfo)e.getNewValue()).getId().toString());
            HRBizDefineClientUtils.setOutEmpTypeEditor(this.defineInfo, this.combEmployeeType);
            HRBizDefineClientUtils.setAffairActionEditor(this.defineInfo, this.compActionReason);
            if (HRBizDefineCheckUtil.needTargetAdmin(this.defineInfo)) {
                this.prmptAdminOrg.setEnabled(true);
            } else {
                this.prmptAdminOrg.setEnabled(false);
            }
            if (HRBizDefineCheckUtil.needTargetPosition(this.defineInfo)) {
                this.prmptPosition.setEnabled(true);
                this.prmptAdminOrg.setEnabled(false);
            } else {
                this.prmptPosition.setEnabled(false);
            }
        } else {
            this.combEmployeeType.removeAllItems();
            this.compActionReason.removeAllItems();
        }
        if (HRBizDefineCheckUtil.needActionType(this.defineInfo)) {
            this.compActionReason.setEnabled(true);
        } else {
            this.compActionReason.setEnabled(false);
            this.setActionReasonNull(this.compActionReason);
        }
        if (HRBizDefineCheckUtil.needTargetEmployeeType(this.defineInfo)) {
            this.combEmployeeType.setEnabled(true);
        } else {
            this.combEmployeeType.setEnabled(false);
            this.setOutEmpTypeEditorOriginEmployeeType(this.combEmployeeType);
        }
    }

    public void setActionReasonNull(KDComboBox combo) {
        combo.removeAllItems();
    }

    public void setOutEmpTypeEditorOriginEmployeeType(KDComboBox combo) {
        combo.removeAllItems();
        DefaultComboBoxModel<EmployeeTypeInfo> model = new DefaultComboBoxModel<EmployeeTypeInfo>();
        model.addElement(this.currentRelation.getLaborRelation().getLaborRelationState());
        combo.setModel(model);
    }

    private void refreshParentUI() {
        EmpPosOrgActiveRelationListUI list = (EmpPosOrgActiveRelationListUI)((Object)this.getUIContext().get("Owner"));
        if (list != null) {
            try {
                list.actionRefresh_actionPerformed(null);
            }
            catch (Exception exc) {
                ExceptionHandler.handle((Throwable)exc);
            }
        }
    }
}

