/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.hr.base.F7ConfigCollection;
import com.kingdee.eas.hr.base.F7ConfigDetailCollection;
import com.kingdee.eas.hr.base.F7ConfigFactory;
import com.kingdee.eas.hr.base.F7ConfigInfo;
import com.kingdee.eas.hr.base.F7Info;
import com.kingdee.eas.hr.base.UIMetadataInfo;
import com.kingdee.eas.hr.base.client.AbstractF7ConfigUI;
import com.kingdee.eas.hr.base.client.UIMetadataPromptBox;
import com.kingdee.eas.hr.base.client.f7.F7Property;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import org.apache.log4j.Logger;

public class F7ConfigUI
extends AbstractF7ConfigUI {
    private static final Logger logger = CoreUIObject.getLogger(F7ConfigUI.class);
    private F7Info f7Data = null;
    private F7Property[] properties = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.f7Data = this.getF7Info();
        this.init();
        this.loadData();
    }

    protected void init() throws Exception {
        this.tblConfig.checkParsed();
        this.tblConfig.getStyleAttributes().setLocked(true);
        this.tblConfig.getSelectManager().setSelectMode(2);
        this.initProperties();
    }

    private void loadData() throws Exception {
        this.txtNumber.setText(this.f7Data.getNumber());
        this.txtName.setText(this.f7Data.getName());
        this.loadConfig();
    }

    private void loadConfig() throws Exception {
        F7ConfigCollection configs = F7ConfigFactory.getRemoteInstance().getF7ConfigCollection("select *,ui.*,detail.* where f7 = '" + this.f7Data.getId() + "' order by ui.id,seq asc");
        this.tblConfig.removeRows();
        if (configs == null || configs.size() <= 0) {
            return;
        }
        IRow row = null;
        int size = configs.size();
        for (int i = 0; i < size; ++i) {
            row = this.tblConfig.addRow();
            this.fillConfigRow(configs.get(i), row);
        }
        if (this.tblConfig.getRowCount() > 0) {
            this.tblConfig.getSelectManager().select(0, 1);
        }
    }

    protected F7ConfigInfo createNewF7ConfigInfo(UIMetadataInfo ui, int seq) {
        F7ConfigInfo config = new F7ConfigInfo();
        config.setUi(ui);
        config.setF7(this.f7Data);
        config.setSeq(seq);
        return config;
    }

    private void fillConfigRow(F7ConfigInfo config, IRow row) {
        row.setUserObject((Object)config);
        row.getCell("id").setValue((Object)config.getId());
        row.getCell("uiName").setValue((Object)config.getUi().getName());
        row.getCell("uiDescription").setValue((Object)config.getUi().getDescription());
        row.getCell("seq").setValue((Object)config.getSeq());
    }

    protected F7Property[] getProperties() {
        if ("com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox".equals(this.f7Data.getNumber())) {
            return new F7Property[]{new F7Property("SCOPE"), new F7Property("DISPLAYFORMART"), new F7Property("EDITFORMAT"), new F7Property("COMMITFORMAT"), new F7Property("EMPLOYEETYPESCOP")};
        }
        return new F7Property[]{new F7Property("SCOPE"), new F7Property("DISPLAYFORMART"), new F7Property("EDITFORMAT"), new F7Property("COMMITFORMAT")};
    }

    private void setProperties(F7ConfigInfo config) {
        if (config == null) {
            return;
        }
        F7ConfigDetailCollection col = config.getDetail();
        IRow row = null;
        F7Property p = null;
        int size = this.tblDetail.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblDetail.getRow(i);
            p = (F7Property)row.getUserObject();
            p.setF7ConfigCol(col);
            row.getCell("value").setValue(p.getValue());
        }
    }

    private void storeProperties(F7ConfigInfo config) {
        IRow row = null;
        F7Property p = null;
        int size = this.tblDetail.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblDetail.getRow(i);
            p = (F7Property)row.getUserObject();
            p.setPropertyValue(row.getCell("value").getValue(), config);
        }
    }

    private void initProperties() {
        this.tblDetail.checkParsed();
        this.tblDetail.removeRows();
        this.properties = this.getProperties();
        if (this.properties != null) {
            IRow row = null;
            F7Property prop = null;
            for (int i = 0; i < this.properties.length; ++i) {
                row = this.tblDetail.addRow();
                prop = this.properties[i];
                row.setUserObject((Object)prop);
                row.getCell("property").setValue((Object)prop.getDisplayName());
                row.getCell("value").setValue(prop.getValue());
                row.getCell("value").setEditor(prop.getEditor());
            }
        }
    }

    protected F7Info getF7Info() {
        F7Info f7Info = new F7Info();
        f7Info.setId(BOSUuid.read((String)this.getUIContext().get("ID").toString()));
        f7Info.setName(this.getUIContext().get("F7Name").toString());
        f7Info.setNumber(this.getUIContext().get("F7Number").toString());
        return f7Info;
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        UIMetadataPromptBox uiF7 = new UIMetadataPromptBox();
        uiF7.show();
        if (!uiF7.isCanceled()) {
            Object data = uiF7.getData();
            IRow row = null;
            F7ConfigInfo config = null;
            UIMetadataInfo ui = null;
            if (data instanceof Object[]) {
                for (int i = 0; i < ((Object[])data).length; ++i) {
                    ui = (UIMetadataInfo)((Object[])data)[i];
                    this.checkExist(ui);
                    config = this.createNewF7ConfigInfo(ui, 0);
                    row = this.tblConfig.addRow();
                    this.fillConfigRow(config, row);
                }
            } else {
                ui = (UIMetadataInfo)data;
                this.checkExist(ui);
                config = this.createNewF7ConfigInfo(ui, 0);
                row = this.tblConfig.addRow();
                this.fillConfigRow(config, row);
            }
            if (row != null) {
                this.tblConfig.getSelectManager().select(row.getRowIndex(), 1);
            }
        }
    }

    private void checkExist(UIMetadataInfo ui) throws Exception {
        if (ui == null) {
            return;
        }
        F7ConfigInfo config = null;
        IRow row = null;
        int size = this.tblConfig.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblConfig.getRow(i);
            config = (F7ConfigInfo)row.getUserObject();
            if (config == null || !config.getUi().getId().equals((Object)ui.getId())) continue;
            MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"30_F7ConfigUI") + ui.getName() + EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"31_F7ConfigUI")));
            SysUtil.abort();
        }
    }

    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblConfig);
        if (selectRows != null && selectRows.length > 0) {
            IRow selectRow = this.tblConfig.getRow(selectRows[0]);
            F7ConfigInfo selectCongig = (F7ConfigInfo)selectRow.getUserObject();
            F7ConfigInfo tmpConfig = null;
            int size = this.tblConfig.getRowCount();
            for (int i = selectRows[0] + 1; i < size; ++i) {
                tmpConfig = (F7ConfigInfo)this.tblConfig.getRow(i).getUserObject();
                if (tmpConfig == null) continue;
                if (!tmpConfig.getUi().getId().equals((Object)selectCongig.getUi().getId())) break;
                tmpConfig.setSeq(tmpConfig.getSeq() - 1);
                this.tblConfig.getRow(i).getCell("seq").setValue((Object)tmpConfig.getSeq());
            }
            this.tblConfig.removeRow(selectRows[0]);
        }
        if (this.tblConfig.getRowCount() > 0) {
            this.tblConfig.getSelectManager().select(0, 1);
        }
    }

    @Override
    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblConfig);
        if (selectRows == null || selectRows.length <= 0) {
            return;
        }
        IRow selectRow = this.tblConfig.getRow(selectRows[0]);
        F7ConfigInfo selectCongig = (F7ConfigInfo)selectRow.getUserObject();
        int seq = selectCongig.getSeq();
        F7ConfigInfo tmpConfig = null;
        int size = this.tblConfig.getRowCount();
        for (int i = selectRows[0] + 1; i < size; ++i) {
            tmpConfig = (F7ConfigInfo)this.tblConfig.getRow(i).getUserObject();
            if (tmpConfig == null) continue;
            if (!tmpConfig.getUi().getId().equals((Object)selectCongig.getUi().getId())) break;
            int tempSeq = tmpConfig.getSeq();
            if (tempSeq <= seq) continue;
            selectCongig = tmpConfig;
            selectRow = this.tblConfig.getRow(i);
        }
        F7ConfigInfo config = this.createNewF7ConfigInfo(selectCongig.getUi(), selectCongig.getSeq() + 1);
        IRow row = this.tblConfig.addRow(selectRow.getRowIndex() + 1);
        this.fillConfigRow(config, row);
        this.tblConfig.getSelectManager().select(selectRow.getRowIndex() + 1, 1);
    }

    @Override
    public void actionUp_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblConfig);
        if (selectRows == null || selectRows.length <= 0) {
            return;
        }
        int currIndex = selectRows[0];
        if (currIndex > 0) {
            this.moveRow(currIndex, currIndex - 1);
        }
    }

    private void moveRow(int from, int to) {
        if (this.tblConfig.canMoveRow(from, to)) {
            IRow fromRow = this.tblConfig.getRow(from);
            IRow toRow = this.tblConfig.getRow(to);
            F7ConfigInfo fromConfig = (F7ConfigInfo)fromRow.getUserObject();
            F7ConfigInfo toConfig = (F7ConfigInfo)toRow.getUserObject();
            if (!fromConfig.getUi().getId().equals((Object)toConfig.getUi().getId())) {
                return;
            }
            int tmpSeq = fromConfig.getSeq();
            fromConfig.setSeq(toConfig.getSeq());
            fromRow.getCell("seq").setValue((Object)toConfig.getSeq());
            toConfig.setSeq(tmpSeq);
            toRow.getCell("seq").setValue((Object)tmpSeq);
            boolean refresh = this.tblConfig.isRefresh();
            this.tblConfig.setRefresh(false);
            this.moveRow(this.tblConfig.getBody().getRows(), from, to);
            this.tblConfig.setRefresh(refresh);
            this.tblConfig.reLayoutAndPaint();
        }
    }

    private void moveRow(List rows, int from, int to) {
        Object fromCell = rows.get(from);
        rows.remove(from);
        rows.add(to, fromCell);
    }

    @Override
    public void actionDown_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblConfig);
        if (selectRows == null || selectRows.length <= 0) {
            return;
        }
        int currIndex = selectRows[0];
        if (currIndex < this.tblConfig.getRowCount() - 1) {
            this.moveRow(currIndex, currIndex + 1);
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.storeData();
    }

    protected void storeData() throws Exception {
        F7ConfigCollection configCol = new F7ConfigCollection();
        F7ConfigInfo configInfo = null;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblConfig);
        if (selectRows != null && selectRows.length > 0) {
            this.storeProperties((F7ConfigInfo)this.tblConfig.getRow(selectRows[0]).getUserObject());
        }
        int size = this.tblConfig.getRowCount();
        for (int i = 0; i < size; ++i) {
            configInfo = (F7ConfigInfo)this.tblConfig.getRow(i).getUserObject();
            configCol.add(configInfo);
        }
        F7ConfigFactory.getRemoteInstance().saveF7Config(this.f7Data.getId().toString(), configCol);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"32_F7ConfigUI"));
        this.loadConfig();
    }

    @Override
    protected void tblConfig_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int pre;
        IRow preRow;
        KDTSelectBlock preBlock = e.getPrevSelectBlock();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblConfig);
        if (preBlock != null && (preRow = this.tblConfig.getRow(pre = preBlock.getTop())) != null) {
            this.storeProperties((F7ConfigInfo)preRow.getUserObject());
        }
        IRow row = this.tblConfig.getRow(selectRows[0]);
        this.setProperties((F7ConfigInfo)row.getUserObject());
    }

    @Override
    protected void tblDetail_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblDetail);
        if (selectRows == null || selectRows.length <= 0) {
            this.txtPropDescription.setUserObject(null);
            return;
        }
        IRow row = this.tblDetail.getRow(selectRows[0]);
        this.txtPropDescription.setSelectedItem((Object)((F7Property)row.getUserObject()).getDescription());
    }
}

