/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.DynQuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.hr.base.CommonFilterGroupInfo;
import com.kingdee.eas.hr.base.CommonFilterQueryFieldInfo;
import com.kingdee.eas.hr.base.CommonFilterSchemeCollection;
import com.kingdee.eas.hr.base.CommonFilterSchemeFactory;
import com.kingdee.eas.hr.base.CommonFilterSchemeInfo;
import com.kingdee.eas.hr.base.ICommonFilterScheme;
import com.kingdee.eas.hr.base.client.AbstractGroupedCommonFilterUI;
import com.kingdee.eas.hr.base.client.CommonFilterUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.StringEnum;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class GroupedCommonFilterUI
extends AbstractGroupedCommonFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(GroupedCommonFilterUI.class);
    private Map groupMap = null;
    private Map fieldMap = null;
    private CommonFilterSchemeInfo schemeInfo = null;
    private Map queryFieldMap = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void onLoad() throws Exception {
        this.kdtTable.checkParsed(true);
        super.onLoad();
        this.initList();
    }

    @Override
    public void clear() {
        super.clear();
        try {
            this.initCommonFilterScheme();
            this.loadGroup();
            this.loadField();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        try {
            this.initCommonFilterScheme();
            this.loadGroup();
            this.loadField();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void changedByDynQuery(IObjectPK oldDynQueryPK, IObjectPK newDynQueryPK) {
        super.changedByDynQuery(oldDynQueryPK, newDynQueryPK);
        try {
            this.initCommonFilterScheme();
            this.loadGroup();
            this.loadField();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initList() throws Exception {
        this.listQueryField.setLayoutOrientation(1);
        this.listQueryField.setFixedCellWidth((this.getCommonQueryPanelWidth() - 235) / 4);
        this.listQueryField.setVisibleRowCount(5);
        this.pnlMain.setDividerLocation(160);
        this.pnlMain.setOneTouchExpandable(false);
        this.kdtTable.getColumn(1).getStyleAttributes().setLocked(true);
    }

    @Override
    protected void cboGroup_actionPerformed(ActionEvent e) throws Exception {
        super.cboGroup_actionPerformed(e);
    }

    @Override
    protected void cboGroup_itemStateChanged(ItemEvent e) throws Exception {
        super.cboGroup_itemStateChanged(e);
        this.loadField();
    }

    @Override
    protected void listQueryField_mouseClicked(MouseEvent e) throws Exception {
        super.listQueryField_mouseClicked(e);
        if (e.getClickCount() == 2) {
            this.insertSelectField(this.getLastInsertedRow());
        }
    }

    @Override
    protected void addRowButton_actionPerformed(ActionEvent e) {
        int rowIndex = this.getLastInsertedRow();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.kdtTable);
        if (row != null) {
            rowIndex = row.getRowIndex() + 1;
        }
        this.insertSelectField(rowIndex);
    }

    @Override
    protected void pnlMain_propertyChange(PropertyChangeEvent e) throws Exception {
        super.pnlMain_propertyChange(e);
        if ("dividerLocation".equals(e.getPropertyName())) {
            Integer divLoca = (Integer)e.getNewValue();
            int maxRows = divLoca / 30;
            this.listQueryField.setVisibleRowCount(maxRows);
        }
    }

    private void insertSelectField(int rowIndex) {
        CommonFilterQueryFieldInfo field = (CommonFilterQueryFieldInfo)this.listQueryField.getSelectedValue();
        if (field != null) {
            if (rowIndex >= this.kdtTable.getRowCount() || this.kdtTable.getRow(rowIndex).getCell(1).getValue() != null) {
                this.addRow(rowIndex);
            }
            DataObject data = (DataObject)this.queryFieldMap.get(field.getNumber());
            KDComboBox cbo = (KDComboBox)this.kdtTable.getRow(rowIndex).getCell(1).getEditor().getComponent();
            cbo.setSelectedItem((Object)data);
            this.kdtTable.getRow(rowIndex).getCell(1).setValue((Object)data);
            this.setCompareCell(rowIndex);
            cbo = (KDComboBox)this.kdtTable.getRow(rowIndex).getCell(2).getEditor().getComponent();
            cbo.setSelectedIndex(1);
            for (int i = 1; i <= cbo.getItemCount(); ++i) {
                StringEnum enums;
                if (cbo.getItemAt(i) == null || !(cbo.getItemAt(i) instanceof StringEnum) || !"=".equals((enums = (StringEnum)cbo.getItemAt(i)).getValue())) continue;
                cbo.setSelectedIndex(i);
            }
            this.kdtTable.getRow(rowIndex).getCell(2).setValue(cbo.getSelectedItem());
            try {
                this.processCompareValueCell(rowIndex);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private int getLastInsertedRow() {
        int rowIndex;
        for (rowIndex = 0; rowIndex < this.kdtTable.getRowCount() && this.kdtTable.getRow(rowIndex).getCell(1).getValue() != null; ++rowIndex) {
        }
        return rowIndex;
    }

    private void initCommonFilterScheme() throws Exception {
        this.initList();
        QueryInfo queryInfo = this.getQueryInfo();
        if (queryInfo == null) {
            throw new RuntimeException("getQueryInfo null!");
        }
        DynQuerySolutionInfo dynQuerySolutionInfo = this.getDynQuerySolutionInfo();
        ICommonFilterScheme ischeme = CommonFilterSchemeFactory.getRemoteInstance();
        StringBuffer oql = new StringBuffer();
        oql.append("select * where query='" + queryInfo.getFullName() + "'");
        oql.append(" and status='1'");
        boolean isDynaSolotionNull = false;
        if (dynQuerySolutionInfo != null && !StringUtils.isEmpty((String)dynQuerySolutionInfo.getNumber())) {
            oql.append(" and dynQuerySolution.id='" + dynQuerySolutionInfo.getId() + "' ");
        } else {
            oql.append(" and dynQuerySolution.id is null");
            isDynaSolotionNull = true;
        }
        oql.append(" order by isSystem");
        CommonFilterSchemeCollection schemeCol = ischeme.getCommonFilterSchemeCollection(oql.toString());
        CommonFilterSchemeInfo info = null;
        for (int i = 0; i < schemeCol.size(); ++i) {
            if (schemeCol.get(i).getDynQuerySolution() == null && isDynaSolotionNull) {
                info = schemeCol.get(i);
                break;
            }
            if (schemeCol.get(i).getDynQuerySolution() == null || isDynaSolotionNull) continue;
            info = schemeCol.get(i);
            break;
        }
        if (info != null) {
            this.schemeInfo = (CommonFilterSchemeInfo)ischeme.getValue((IObjectPK)new ObjectUuidPK(info.getId()), new SelectorItemCollection());
            this.groupMap = (Map)this.schemeInfo.get("groupMap");
            this.fieldMap = (Map)this.schemeInfo.get("fieldMap");
            this.addRowButton.setEnabled(true);
            this.delRowButton.setEnabled(true);
            this.clearButton.setEnabled(true);
        } else {
            this.schemeInfo = null;
            this.groupMap = null;
            this.fieldMap = null;
            this.addRowButton.setEnabled(false);
            this.delRowButton.setEnabled(false);
            this.clearButton.setEnabled(false);
        }
        this.queryFieldMap = CommonFilterUtil.getQueryFilterFieldsMap(queryInfo);
    }

    private void loadGroup() throws Exception {
        this.cboGroup.removeAllItems();
        if (this.groupMap == null) {
            return;
        }
        Map sortMap = CommonFilterUtil.getSortedMap(this.groupMap, "index");
        for (Map.Entry entry : sortMap.entrySet()) {
            this.cboGroup.addItem(entry.getValue());
        }
    }

    private void loadField() throws Exception {
        this.listQueryField.removeAllElements();
        if (this.fieldMap == null) {
            return;
        }
        if (this.cboGroup.getSelectedItem() == null) {
            if (this.cboGroup.getItemCount() > 0) {
                this.cboGroup.setSelectedIndex(0);
            } else {
                return;
            }
        }
        CommonFilterGroupInfo group = (CommonFilterGroupInfo)this.cboGroup.getSelectedItem();
        Map sortMap = CommonFilterUtil.getSortedMap(this.fieldMap, "index");
        for (Map.Entry entry : sortMap.entrySet()) {
            CommonFilterQueryFieldInfo field = (CommonFilterQueryFieldInfo)entry.getValue();
            if (!group.getName().equals(field.getCommonFilterGroup().getName()) || this.queryFieldMap == null || !this.queryFieldMap.containsKey(field.getNumber())) continue;
            DataObject data = (DataObject)this.queryFieldMap.get(field.getNumber());
            field.setName(data.getName());
            this.listQueryField.addElement((Object)field);
        }
    }

    @Override
    public String getPanelName() {
        return this.getUITitle();
    }

    @Override
    protected int getdefaultRows() {
        return 8;
    }
}

