/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.client.GetDataDialog;
import com.kingdee.eas.base.core.client.GetDataTaskAdapter;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.hr.affair.client.HRBizAffairFilterUI;
import com.kingdee.eas.hr.base.client.CustomFilterBuilder;
import com.kingdee.eas.hr.base.client.DataProviderSetting;
import com.kingdee.eas.hr.base.client.HRDefaultNoteDataProvider;
import com.kingdee.eas.hr.base.client.IHRBillListUIBiz;
import com.kingdee.eas.hr.base.client.ListUIBiz;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.HashSet;
import javax.swing.SwingUtilities;

public abstract class HRBillListUIBiz
extends ListUIBiz
implements IHRBillListUIBiz {
    protected final String DS_BASEINFO = "baseInfo";
    protected final String DS_APPROVEINFO = "approveInfo";

    @Override
    public FilterInfo getDefaultFilterForQuery() throws Exception {
        FilterInfo filter = new FilterInfo();
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userId);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)sql.toString(), CompareType.INNER));
        return filter;
    }

    public void batchPrint(final boolean isPrintPreview) throws Exception {
        this.checkSelected();
        GetDataDialog dlg = null;
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        dlg = ownerWindow instanceof Frame ? new GetDataDialog((Frame)ownerWindow) : (ownerWindow instanceof Dialog ? new GetDataDialog((Dialog)ownerWindow) : new GetDataDialog((Frame)null));
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                HRBillListUIBiz.this.execTaodaAction(isPrintPreview);
                return null;
            }
        });
        dlg.show();
    }

    private void execTaodaAction(boolean isPrintPreview) {
        KDNoteHelper noteHelper = new KDNoteHelper();
        DefaultNoteDataProvider dataProvider = this.getDefaultNoteDataProvider();
        dataProvider.setBatchSupported(true);
        dataProvider.setNumberOfEachBatch(100);
        DataProviderSetting.addDataSource(dataProvider, this.getDataProviderSetting());
        if (isPrintPreview) {
            noteHelper.printPreview(this.getPrintPath(), (Object)dataProvider, (Component)SwingUtilities.getWindowAncestor((Component)this.ctx.getUI()));
        } else {
            noteHelper.print(this.getPrintPath(), (Object)dataProvider, (Component)SwingUtilities.getWindowAncestor((Component)this.ctx.getUI()), true);
        }
    }

    private DefaultNoteDataProvider getDefaultNoteDataProvider() {
        return new HRDefaultNoteDataProvider();
    }

    @Override
    public IMultiOrgSupport getMainCustomerQueryPanel() throws Exception {
        return new HRBizAffairFilterUI(this.ctx.getUI());
    }

    protected DataProviderSetting getDataProviderSetting() {
        String dsName = "baseInfo";
        String query = this.getPrintQuery(dsName);
        if (StringUtils.isEmpty((String)query)) {
            return null;
        }
        DataProviderSetting mainDs = new DataProviderSetting(dsName);
        mainDs.setQueryPK((IMetaDataPK)new MetaDataPK(query));
        mainDs.setFilter(new DataProviderSetting.IHRCustomFilter(){

            @Override
            public void build(CustomFilterBuilder builder) {
                builder.setFilter(HRBillListUIBiz.this.getSelectedBillIDFilter("baseInfo"));
            }
        });
        dsName = "approveInfo";
        query = "com.kingdee.eas.hr.base.app.HRMultiApproveAllViewQuery";
        if (!StringUtils.isEmpty((String)query)) {
            DataProviderSetting subDs = new DataProviderSetting(dsName);
            subDs.setQueryPK((IMetaDataPK)new MetaDataPK(query));
            subDs.setForeignKey(this.getPrintQueryBillID(dsName));
            mainDs.append(subDs);
        }
        return mainDs;
    }

    protected String getPrintQuery(String dsName) {
        return null;
    }

    protected String getPrintQueryBillID(String dsName) {
        if (this.DS_BASEINFO.equals(dsName)) {
            return "id";
        }
        if (this.DS_APPROVEINFO.equals(dsName)) {
            return "billId";
        }
        return null;
    }

    private FilterInfo getSelectedBillIDFilter(String dsName) {
        FilterInfo filter = new FilterInfo();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length <= 0) {
            return filter;
        }
        IRow row = null;
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < selectRows.length; ++i) {
            row = this.tblMain.getRow(selectRows[i]);
            set.add(row.getCell(this.getKeyFieldName()).getValue());
        }
        filter.getFilterItems().add(new FilterItemInfo(this.getPrintQueryBillID(dsName), set, CompareType.INCLUDE));
        return filter;
    }

    protected String getPrintPath() {
        return null;
    }

    @Override
    public String getExtendBillName() {
        return null;
    }
}

