/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.base.AffairActionReasonCollection;
import com.kingdee.eas.hr.base.EmployeeTypeCollection;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HRBizDefEmpTypeCollection;
import com.kingdee.eas.hr.base.HRBizDefineCollection;
import com.kingdee.eas.hr.base.HRBizDefineFactory;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.client.f7.EditorCreator;
import com.kingdee.eas.hr.base.client.util.HRBizDefineClientUtils;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class HRBizDefineHandler {
    private String className = null;
    private KDTable kdtEntrys;
    private String bizDefineColumnKey = null;
    private String tarEmpTypeColumnKey = null;
    private HRBizDefineInfo defaultDefineInfo = null;
    private String reasonColumnKey = null;
    private HRBizDefineCollection hrBizDefineColl = null;
    private boolean isAddPersonByF7 = false;

    public HRBizDefineHandler(KDTable kdtEntrys, String uiClassName, String bizDefineColumnKey) {
        this.kdtEntrys = kdtEntrys;
        this.className = uiClassName;
        this.bizDefineColumnKey = bizDefineColumnKey;
        this.kdtEntrys.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                HRBizDefineHandler.this.activeKDCellChanged(e);
            }
        });
        KDTableHelper.updateEnterWithTab((KDTable)kdtEntrys, (boolean)false);
    }

    public void setBizDefineEditor() {
        IColumn iColumn;
        if (StringUtils.isEmpty((String)this.bizDefineColumnKey)) {
            this.bizDefineColumnKey = "hrBizDefine";
        }
        if ((iColumn = this.kdtEntrys.getColumn(this.bizDefineColumnKey)) == null) {
            return;
        }
        this.hrBizDefineColl = this.getHRBizDefineColl();
        if (this.hrBizDefineColl == null) {
            return;
        }
        iColumn.setRequired(true);
        iColumn.getStyleAttributes().setBackground(UIManager.getColor("TextField.requiredBackground"));
        if (this.hrBizDefineColl.size() == 1) {
            iColumn.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)EditorCreator.getComboxEditor(this.hrBizDefineColl.toArray())));
            iColumn.getStyleAttributes().setHided(true);
            this.setOutEmpTypeColumnEditor(this.tarEmpTypeColumnKey, this.hrBizDefineColl.get(0));
            this.setReasonColumnEditor(this.hrBizDefineColl.get(0));
        } else if (!this.isAddPersonByF7) {
            iColumn.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)EditorCreator.getComboxEditor(this.hrBizDefineColl.toArray())));
        } else if (this.hrBizDefineColl.size() == 0) {
            iColumn.setEditor(EditorCreator.getTextNoEditbleCellEditor());
        } else {
            iColumn.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)new KDTextField()));
        }
        if (!this.needShowActionReason() && this.kdtEntrys.getColumn(this.reasonColumnKey) != null) {
            this.kdtEntrys.getColumn(this.reasonColumnKey).getStyleAttributes().setHided(true);
        }
    }

    private void setBizDefineCellEditor(PersonInfo pInfo, int rowIndex) {
        EmployeeTypeInfo empTypeInfo = pInfo.getEmployeeType();
        if (empTypeInfo == null) {
            return;
        }
        this.hrBizDefineColl = this.getHRBizDefineColl();
        if (this.hrBizDefineColl == null || this.hrBizDefineColl.size() <= 1) {
            return;
        }
        ArrayList<HRBizDefineInfo> bizDefineList = new ArrayList<HRBizDefineInfo>();
        HRBizDefEmpTypeCollection bizDefInEmpType = null;
        for (int i = 0; i < this.hrBizDefineColl.size(); ++i) {
            bizDefInEmpType = this.hrBizDefineColl.get(i).getInEmpTypes();
            if (bizDefInEmpType == null || bizDefInEmpType.size() == 0) continue;
            for (int j = 0; j < bizDefInEmpType.size(); ++j) {
                if (!empTypeInfo.equals((Object)bizDefInEmpType.get(j).getEmpType())) continue;
                bizDefineList.add(this.hrBizDefineColl.get(i));
            }
        }
        ICell iCell = this.kdtEntrys.getCell(rowIndex, this.bizDefineColumnKey);
        iCell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)EditorCreator.getComboxEditor(bizDefineList.toArray())));
    }

    public void handlerEmpF7(EmployeeMultiF7PromptBox empF7) {
        if (empF7 != null) {
            HashSet empTypeIdSet = this.getInEmpTypeIdSet();
            empF7.setEmpTypeIDs(empTypeIdSet);
        }
    }

    private void setOutEmpTypeCellEditor(HRBizDefineInfo hrBizDefineInfo, int rowIndex) {
        if (StringUtils.isEmpty((String)this.tarEmpTypeColumnKey) || this.kdtEntrys == null) {
            return;
        }
        ICell iCell = this.kdtEntrys.getCell(rowIndex, this.tarEmpTypeColumnKey);
        if (iCell == null) {
            return;
        }
        EmployeeTypeCollection empTypeColl = HRBizDefineClientUtils.getEmpTypeCollection(hrBizDefineInfo);
        iCell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)EditorCreator.getEmpTypeEditor(empTypeColl)));
    }

    private void setOutEmpTypeColumnEditor(String columnKey, HRBizDefineInfo hrBizDefineInfo) {
        if (StringUtils.isEmpty((String)columnKey) || this.kdtEntrys == null) {
            return;
        }
        IColumn iColumn = this.kdtEntrys.getColumn(columnKey);
        if (iColumn == null) {
            System.out.println(this.className + ":" + columnKey + " not exists;");
            return;
        }
        EmployeeTypeCollection empTypeColl = HRBizDefineClientUtils.getEmpTypeCollection(hrBizDefineInfo);
        if (empTypeColl != null && empTypeColl.size() > 0) {
            iColumn.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)EditorCreator.getEmpTypeEditor(empTypeColl)));
        }
    }

    private void setReasonColumnEditor(HRBizDefineInfo hrBizDefineInfo) {
        if (StringUtils.isEmpty((String)this.reasonColumnKey) || this.kdtEntrys == null) {
            return;
        }
        IColumn iColumn = this.kdtEntrys.getColumn(this.reasonColumnKey);
        if (iColumn == null) {
            System.out.println(this.className + ":" + this.reasonColumnKey + " not exists;");
            return;
        }
        AffairActionReasonCollection reasonColl = HRBizDefineClientUtils.getAffairActionReason(hrBizDefineInfo);
        if (reasonColl != null && reasonColl.size() > 0) {
            iColumn.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)EditorCreator.getComboxEditor(reasonColl.toArray())));
        }
    }

    private void setReasonCellEditor(HRBizDefineInfo hrBizDefineInfo, int rowIndex) {
        if (StringUtils.isEmpty((String)this.reasonColumnKey) || this.kdtEntrys == null) {
            return;
        }
        ICell iCell = this.kdtEntrys.getCell(rowIndex, this.reasonColumnKey);
        if (iCell == null) {
            return;
        }
        AffairActionReasonCollection reasonColl = HRBizDefineClientUtils.getAffairActionReason(hrBizDefineInfo);
        if (reasonColl != null && reasonColl.size() > 0) {
            iCell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)EditorCreator.getComboxEditor(reasonColl.toArray())));
        }
    }

    public HRBizDefineCollection getHRBizDefineColl() {
        if (this.hrBizDefineColl == null) {
            try {
                this.hrBizDefineColl = HRBizDefineFactory.getRemoteInstance().getHRBizDefineCollByUI(this.className);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            for (int i = 0; i < this.hrBizDefineColl.size(); ++i) {
                if (!this.hrBizDefineColl.get(i).isDefault()) continue;
                this.defaultDefineInfo = this.hrBizDefineColl.get(i);
                break;
            }
        }
        return this.hrBizDefineColl;
    }

    public void setDefaultBizDefine(HRAffairBizBillEntryInfo bizBillEntryInfo) {
        this.hrBizDefineColl = this.getHRBizDefineColl();
        if (this.hrBizDefineColl == null) {
            return;
        }
        if (this.hrBizDefineColl.size() != 1 && this.defaultDefineInfo == null) {
            return;
        }
        HRBizDefineInfo defineInfo = null;
        defineInfo = this.defaultDefineInfo != null ? this.defaultDefineInfo : this.hrBizDefineColl.get(0);
        bizBillEntryInfo.setHrBizDefine(defineInfo);
        if (defineInfo.getOutEmpTypes() != null && defineInfo.getOutEmpTypes().size() == 1) {
            bizBillEntryInfo.setEmpType(defineInfo.getOutEmpTypes().get(0).getEmpType());
        }
        if (defineInfo.getActionReasons() != null && defineInfo.getActionReasons().size() == 1) {
            bizBillEntryInfo.setAffairActionReason(defineInfo.getActionReasons().get(0).getActionReason());
        }
    }

    public void propertyChange(KDTPropertyChangeEvent e) {
        if (this.kdtEntrys == null) {
            return;
        }
        if (this.kdtEntrys.getColumn(this.bizDefineColumnKey) == null) {
            return;
        }
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (colIndex != this.kdtEntrys.getColumn(this.bizDefineColumnKey).getColumnIndex()) {
            return;
        }
        ICell iCell = this.kdtEntrys.getCell(rowIndex, colIndex);
        HRBizDefineInfo hrBizDefineInfo = null;
        if (iCell.getValue() != null && iCell.getValue() instanceof HRBizDefineInfo) {
            hrBizDefineInfo = (HRBizDefineInfo)iCell.getValue();
        }
        if (hrBizDefineInfo == null) {
            return;
        }
        if (this.kdtEntrys.getCell(rowIndex, this.tarEmpTypeColumnKey) != null) {
            if (hrBizDefineInfo.getOutEmpTypes() != null && hrBizDefineInfo.getOutEmpTypes().size() == 1) {
                this.kdtEntrys.getCell(rowIndex, this.tarEmpTypeColumnKey).setValue((Object)hrBizDefineInfo.getOutEmpTypes().get(0).getEmpType());
            } else {
                this.kdtEntrys.getCell(rowIndex, this.tarEmpTypeColumnKey).setValue(null);
            }
        }
        if (this.kdtEntrys.getCell(rowIndex, this.reasonColumnKey) != null) {
            if (hrBizDefineInfo.getActionReasons() != null && hrBizDefineInfo.getActionReasons().size() == 1) {
                this.kdtEntrys.getCell(rowIndex, this.reasonColumnKey).setValue((Object)hrBizDefineInfo.getActionReasons().get(0).getActionReason());
            } else {
                this.kdtEntrys.getCell(rowIndex, this.reasonColumnKey).setValue(null);
            }
        }
    }

    private HashSet getInEmpTypeIdSet() {
        this.hrBizDefineColl = this.getHRBizDefineColl();
        if (this.hrBizDefineColl == null) {
            return new HashSet();
        }
        HashSet<String> inEmpTypeIdSet = new HashSet<String>();
        HRBizDefEmpTypeCollection bizDefInEmpType = null;
        EmployeeTypeInfo empTypeInfo = null;
        for (int i = 0; i < this.hrBizDefineColl.size(); ++i) {
            bizDefInEmpType = this.hrBizDefineColl.get(i).getInEmpTypes();
            if (bizDefInEmpType == null || bizDefInEmpType.size() == 0) continue;
            for (int j = 0; j < bizDefInEmpType.size(); ++j) {
                empTypeInfo = bizDefInEmpType.get(j).getEmpType();
                inEmpTypeIdSet.add(empTypeInfo.getId().toString());
            }
        }
        return inEmpTypeIdSet;
    }

    private HashSet getDefaultEmpTypeIdSet() {
        return new HashSet();
    }

    private boolean hasOneBizdefine() {
        this.hrBizDefineColl = this.getHRBizDefineColl();
        return this.hrBizDefineColl != null && this.hrBizDefineColl.size() == 1;
    }

    private boolean needShowActionReason() {
        this.hrBizDefineColl = this.getHRBizDefineColl();
        if (this.hrBizDefineColl == null) {
            return false;
        }
        HRBizDefineInfo hrBizDefineInfo = null;
        for (int i = 0; i < this.hrBizDefineColl.size(); ++i) {
            hrBizDefineInfo = this.hrBizDefineColl.get(i);
            if (hrBizDefineInfo.getActionReasons() == null || hrBizDefineInfo.getActionReasons().size() <= 1) continue;
            return true;
        }
        return false;
    }

    public String getTarEmpTypeColumnKey() {
        return this.tarEmpTypeColumnKey;
    }

    public void setTarEmpTypeColumnKey(String tarEmpTypeColumnKey) {
        this.tarEmpTypeColumnKey = tarEmpTypeColumnKey;
    }

    public void setBizDefineColumnKey(String bizDefineColumnKey) {
        this.bizDefineColumnKey = bizDefineColumnKey;
    }

    public void setReasonColumnKey(String reasonColumnKey) {
        this.reasonColumnKey = reasonColumnKey;
    }

    public void setAddPersonByF7(boolean isAddPersonByF7) {
        this.isAddPersonByF7 = isAddPersonByF7;
    }

    private EmployeeTypeCollection getOutEmpType(HRBizDefineInfo hrBizDefineInfo) {
        this.hrBizDefineColl = this.getHRBizDefineColl();
        if (this.hrBizDefineColl == null || hrBizDefineInfo == null) {
            return null;
        }
        EmployeeTypeCollection empTypeColl = null;
        for (int i = 0; i < this.hrBizDefineColl.size(); ++i) {
            if (!hrBizDefineInfo.getId().toString().equals(this.hrBizDefineColl.get(i).getId().toString())) continue;
            empTypeColl = HRBizDefineClientUtils.getEmpTypeCollection(this.hrBizDefineColl.get(i));
            break;
        }
        return empTypeColl;
    }

    private AffairActionReasonCollection getAffairReason(HRBizDefineInfo hrBizDefineInfo) {
        this.hrBizDefineColl = this.getHRBizDefineColl();
        if (this.hrBizDefineColl == null || hrBizDefineInfo == null) {
            return null;
        }
        AffairActionReasonCollection reasonColl = new AffairActionReasonCollection();
        for (int i = 0; i < this.hrBizDefineColl.size(); ++i) {
            if (!hrBizDefineInfo.getId().toString().equals(this.hrBizDefineColl.get(i).getId().toString())) continue;
            reasonColl = HRBizDefineClientUtils.getAffairActionReason(this.hrBizDefineColl.get(i));
            break;
        }
        return reasonColl;
    }

    private void activeKDCellChanged(KDTActiveCellEvent e) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColumnIndex();
        if (colIndex < 0 || rowIndex < 0) {
            return;
        }
        IRow row = this.kdtEntrys.getRow(rowIndex);
        ICell iCell = row.getCell(colIndex);
        if (iCell.getEditor() != null) {
            // empty if block
        }
        if (colIndex == this.kdtEntrys.getColumnIndex(this.bizDefineColumnKey)) {
            if (row.getCell("person") != null && row.getCell("person").getValue() != null) {
                PersonInfo pInfo = (PersonInfo)row.getCell("person").getValue();
                this.setBizDefineCellEditor(pInfo, rowIndex);
            }
            return;
        }
        if (row.getCell(this.bizDefineColumnKey) == null || row.getCell(this.bizDefineColumnKey).getValue() == null) {
            return;
        }
        HRBizDefineInfo hrBizDefineInfo = (HRBizDefineInfo)row.getCell(this.bizDefineColumnKey).getValue();
        if (colIndex == this.kdtEntrys.getColumnIndex(this.reasonColumnKey)) {
            AffairActionReasonCollection reasonColl = this.getAffairReason(hrBizDefineInfo);
            if (reasonColl != null && reasonColl.size() > 0) {
                iCell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)EditorCreator.getComboxEditor(reasonColl.toArray())));
            } else {
                iCell.setEditor(EditorCreator.getTextNoEditbleCellEditor());
            }
        } else if (colIndex == this.kdtEntrys.getColumnIndex(this.tarEmpTypeColumnKey)) {
            EmployeeTypeCollection empTypeColl = this.getOutEmpType(hrBizDefineInfo);
            if (empTypeColl != null && empTypeColl.size() > 0) {
                iCell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)EditorCreator.getEmpTypeEditor(empTypeColl)));
            } else {
                iCell.setEditor(EditorCreator.getTextNoEditbleCellEditor());
            }
        }
    }
}

