/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.client.HRCoreUIObject;
import com.kingdee.eas.hr.base.client.ICoreUIBiz;
import com.kingdee.eas.hr.base.client.IEditUIBiz;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.base.client.MainOrgInfoForUI;
import com.kingdee.eas.hr.base.client.PlugInUIDecorator;
import com.kingdee.eas.hr.base.client.PlugInUIParam;
import com.kingdee.eas.hr.base.client.VerifierDecorator;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;

public class HREditUIObject
extends HRCoreUIObject {
    protected final String RES = "com.kingdee.eas.hr.base.HRBasedataResource";
    protected String oprtState = null;
    private AbstractObjectValue editData = null;
    private IEditUIBiz editBiz = null;
    private VerifierDecorator verifier = null;
    protected KDBizPromptBox mainOrg = null;
    private OrgType orgType = null;
    private String orgFieldOfValueObject = null;

    public HREditUIObject(CoreUI ui, Map uiContext, PlugInUIDecorator plugIn, PlugInUIParam plugInParam, ICoreUIBiz biz, MainOrgInfoForUI orgInfo, VerifierDecorator verifier) {
        super(ui, uiContext, plugIn, plugInParam, biz);
        if (orgInfo != null) {
            this.mainOrg = orgInfo.getMainOrg();
            this.orgType = orgInfo.getOrgType();
            this.orgFieldOfValueObject = orgInfo.getOrgFieldOfValueObject();
        }
        this.verifier = verifier;
        this.editBiz = (IEditUIBiz)biz;
        this.setOprtSate(ui.getOprtState());
    }

    @Override
    public void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.initBizOrgPreChange();
    }

    protected void initBizOrgPreChange() {
        if (this.mainOrg == null) {
            return;
        }
        this.mainOrg.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                if (OprtState.ADDNEW.equals(HREditUIObject.this.oprtState)) {
                    try {
                        HRInitFactory.getRemoteInstance().isInitFinish((HROrgUnitInfo)e.getData());
                    }
                    catch (Exception ex) {
                        HREditUIObject.this.handUIException(ex);
                        SysUtil.abort();
                    }
                    if (e.getOldData() != null && e.getData() != null && !e.getOldData().equals(e.getData())) {
                        if (0 == MsgBox.showConfirm2((Component)HREditUIObject.this.ui, (String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource", (String)"HRORG_CHANGE_CONFIRM"))) {
                            return;
                        }
                        SysUtil.abort();
                    }
                }
            }
        });
    }

    public void setOprtSate(String oprtState) {
        if (this.plugInParam != null) {
            this.plugInParam.put("oprtState", oprtState);
        }
        if (this.editBiz != null) {
            this.editBiz.setOprtState(oprtState);
        }
        this.oprtState = oprtState;
    }

    public void setDataObject(IObjectValue dataObject) {
        if (this.plugInParam != null) {
            this.plugInParam.put("EDITDATA", dataObject);
        }
        this.editData = (AbstractObjectValue)dataObject;
    }

    public void initDataStatus() {
        try {
            if (this.biz != null) {
                this.editBiz.initDataStatus();
            }
            if (this.plugIn != null) {
                this.plugIn.initDataStatus();
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.mainOrg != null && this.mainOrg.getData() == null) {
            MsgBox.showInfo((Component)this.ui, (String)EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource", (String)"HRORG_NOT_NULL"));
            this.mainOrg.requestFocusInWindow();
            SysUtil.abort();
        }
        if (!this.verifier.verify()) {
            SysUtil.abort();
        }
        if (this.biz != null) {
            this.editBiz.beforeStoreField(e);
        }
        if (this.plugIn != null) {
            this.plugIn.beforeStoreField(e);
        }
    }

    public void registerF7(IHRF7CommonRegister register) {
        if (this.biz != null) {
            this.editBiz.registerContextChangeF7(register);
        }
        if (this.plugIn != null) {
            this.plugIn.registerContextChangeF7(register);
        }
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        try {
            HROrgUnitInfo hrOrg;
            Object newOrg = chgVo.getNewOrg();
            if (newOrg != null && newOrg instanceof HROrgUnitInfo && OprtState.ADDNEW.equals(this.oprtState) && chgVo.getOldOrg() != null && (hrOrg = (HROrgUnitInfo)newOrg).isIsBizUnit() && this.editData != null) {
                this.editData.setSyncOldValue(true);
                this.setInitData(this.editData, hrOrg);
                this.editData.setSyncOldValue(false);
            }
            if (this.biz != null) {
                this.editBiz.afterMainOrgChanged(chgVo);
            }
            if (this.plugIn != null) {
                this.plugIn.afterMainOrgChanged(chgVo);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void handleNewData(CoreBaseInfo info) throws Exception {
        this.initMainOrgF7(info);
        if (this.biz != null) {
            this.editBiz.handleNewData(info);
        }
    }

    protected void setInitData(AbstractObjectValue newData, HROrgUnitInfo hrOrg) throws Exception {
        if (newData == null) {
            return;
        }
        if (hrOrg != null && !StringUtils.isEmpty((String)this.orgFieldOfValueObject)) {
            newData.put(this.orgFieldOfValueObject, (Object)hrOrg);
        }
    }

    protected void initMainOrgF7(CoreBaseInfo info) throws Exception {
        if (info == null) {
            return;
        }
        OrgUnitInfo initOrg = null;
        if (this.uiContext != null) {
            HROrgUnitInfo hrOrg;
            initOrg = (OrgUnitInfo)info.get(this.orgFieldOfValueObject);
            if (initOrg == null) {
                initOrg = (OrgUnitInfo)this.uiContext.get(this.orgType);
            }
            if (initOrg != null && initOrg instanceof HROrgUnitInfo && (hrOrg = (HROrgUnitInfo)initOrg).isIsBizUnit()) {
                info.setSyncOldValue(true);
                this.setInitData((AbstractObjectValue)info, hrOrg);
                info.setSyncOldValue(false);
            }
        }
    }
}

