/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.swing.KDFilterTextField;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.GregorianCalendar;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.text.JTextComponent;

public class KDDateTextField
extends KDTextField {
    KDLabel lab = new KDLabel("/");
    KDFilterTextField month = null;
    KDFilterTextField day = null;

    public KDDateTextField() {
        this.setPreferredSize(new Dimension(60, 19));
        this.setLayout(new BoxLayout((Container)((Object)this), 0));
        this.month = new KDFilterTextField(){

            public void replaceSelection(String content) {
                if (this.getSelectedText() != null) {
                    super.replaceSelection(content);
                    return;
                }
                if ((super.getText() + content).equals("00")) {
                    return;
                }
                if (super.getText().length() > 0) {
                    try {
                        if (this.getCaretPosition() == 1 && Integer.parseInt(super.getText() + content) > 12) {
                            return;
                        }
                        if (this.getCaretPosition() == 0 && Integer.parseInt(content + super.getText()) > 12) {
                            return;
                        }
                    }
                    catch (Exception e) {
                        return;
                    }
                }
                super.replaceSelection(content);
            }

            public void commitEdit() throws ParseException {
            }
        };
        this.month.setFilterType(1);
        this.month.setMaxLength(2);
        this.day = new KDFilterTextField(){

            public void replaceSelection(String content) {
                if (StringUtils.isEmpty((String)KDDateTextField.this.month.getText())) {
                    return;
                }
                if ((super.getText() + content).equals("00")) {
                    return;
                }
                if (this.getSelectedText() != null) {
                    super.replaceSelection(content);
                    return;
                }
                if (super.getText().length() > 0) {
                    try {
                        if (this.getCaretPosition() == 1 && Integer.parseInt(super.getText() + content) > KDDateTextField.this.getLastDay(KDDateTextField.this.month.getText())) {
                            return;
                        }
                        if (this.getCaretPosition() == 0 && Integer.parseInt(content + super.getText()) > KDDateTextField.this.getLastDay(KDDateTextField.this.month.getText())) {
                            return;
                        }
                    }
                    catch (Exception e) {
                        return;
                    }
                }
                super.replaceSelection(content);
            }

            public void commitEdit() throws ParseException {
            }
        };
        this.day.setFilterType(1);
        this.day.setMaxLength(2);
        this.month.setBorder(null);
        this.month.setHorizontalAlignment(4);
        this.add((Component)this.month);
        this.add((Component)this.lab);
        this.day.setBorder(null);
        this.add((Component)this.day);
        this.setFocusable(false);
        LeftRightKeyListener lrKeyl = new LeftRightKeyListener();
        this.month.addKeyListener((KeyListener)lrKeyl);
        this.day.addKeyListener((KeyListener)lrKeyl);
        this.month.addPropertyChangeListener((PropertyChangeListener)new LRTransListener(null, (Component)this.day));
        this.day.addPropertyChangeListener((PropertyChangeListener)new LRTransListener((Component)this.month, null));
    }

    private int getLastDay(String month) {
        if (StringUtils.isEmpty((String)month)) {
            return 28;
        }
        int m = Integer.parseInt(month);
        GregorianCalendar now = new GregorianCalendar(SysContext.getSysContext().getLocale());
        int y = now.get(1);
        if (m == 4 || m == 6 || m == 9 || m == 11) {
            return 30;
        }
        if (m == 2) {
            if (now.isLeapYear(y)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    public void setSeparator(String separator) {
        this.lab.setText(separator);
    }

    public void setRequired(boolean required) {
        super.setRequired(required);
        this.month.setRequired(required);
        this.day.setRequired(required);
    }

    public String getText() {
        if (this.month == null) {
            return null;
        }
        return this.month.getText() + this.lab.getText() + this.day.getText();
    }

    public void setText(String txt) {
        if (this.month == null || this.day == null) {
            return;
        }
        if (StringUtils.isEmpty((String)txt) || txt.indexOf(this.lab.getText()) == -1) {
            this.month.setText("");
            this.day.setText("");
            return;
        }
        String[] str = txt.split(this.lab.getText());
        if (str.length != 2) {
            return;
        }
        this.month.setText(str[0]);
        this.day.setText(str[1]);
    }

    public void setEnabled(boolean isEnabled) {
        if (this.lab == null) {
            return;
        }
        this.lab.setEnabled(isEnabled);
        this.month.setEnabled(isEnabled);
        this.day.setEnabled(isEnabled);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setTitle("KDTextField Demo");
        frame.getContentPane().setLayout(new FlowLayout());
        KDDateTextField tf = new KDDateTextField();
        frame.getContentPane().add((Component)((Object)tf));
        frame.setSize(400, 320);
        frame.setDefaultCloseOperation(3);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        frame.setVisible(true);
        tf.setText("08/25");
    }

    static class LeftRightKeyListener
    extends KeyAdapter {
        public static final String LEFT_TRAN = "LEFT_TRAN";
        public static final String RIGHT_TRAN = "RIGHT_TRAN";

        LeftRightKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 8 || e.getKeyCode() == 127) {
                return;
            }
            JTextComponent txt = (JTextComponent)e.getComponent();
            if (e.getKeyCode() == 37) {
                if (txt.getCaretPosition() == 0) {
                    txt.firePropertyChange(LEFT_TRAN, 0, 1);
                }
            } else if (e.getKeyCode() == 39 || e.getKeyChar() == '/') {
                if (txt.getCaretPosition() == txt.getText().length()) {
                    txt.firePropertyChange(RIGHT_TRAN, 0, 1);
                }
            } else if (txt.getCaretPosition() == 0) {
                if (e.getKeyChar() != '0' && e.getKeyChar() != '1') {
                    txt.firePropertyChange(RIGHT_TRAN, 0, 1);
                }
            } else if (txt.getCaretPosition() == 1) {
                if (txt.getText().equals("0") && e.getKeyChar() == '0') {
                    return;
                }
                if (txt.getText().equals("1") && e.getKeyChar() != '0' && e.getKeyChar() != '1' && e.getKeyChar() != '2') {
                    return;
                }
                txt.firePropertyChange(RIGHT_TRAN, 0, 1);
            }
        }
    }

    static class LRTransListener
    implements PropertyChangeListener {
        private Component leftComponent;
        private Component rightComponent;

        public LRTransListener(Component leftComponent, Component rightComponent) {
            this.leftComponent = leftComponent;
            this.rightComponent = rightComponent;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "LEFT_TRAN") {
                if (this.leftComponent != null) {
                    this.leftComponent.requestFocus();
                }
            } else if (evt.getPropertyName() == "RIGHT_TRAN" && this.rightComponent != null) {
                this.rightComponent.requestFocus();
            }
        }
    }
}

