/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.client.uihelper.UIHelper;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.base.PersonCheckException;
import com.kingdee.eas.hr.base.PersonStatusEnum;
import com.kingdee.eas.hr.base.UserPermSetFactory;
import com.kingdee.eas.hr.base.UserPermSetInfo;
import com.kingdee.eas.hr.base.client.AbstractUserPermSetEditUI;
import com.kingdee.eas.hr.base.client.PositionOfUserPromptBox;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.ComboBoxModel;
import org.apache.log4j.Logger;

public class UserPermSetEditUI
extends AbstractUserPermSetEditUI {
    private static final long serialVersionUID = -3513372111135506246L;
    private static final Logger logger = CoreUIObject.getLogger(UserPermSetEditUI.class);

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData.isIsInherit()) {
            String optState = (String)this.getUIContext().get("parentUIOptStatus");
            if (OprtState.VIEW.equals(optState)) {
                this.prmtinheritPerson.setEnabled(false);
            } else {
                this.prmtinheritPerson.setEnabled(true);
            }
        } else {
            this.prmtinheritPerson.setEnabled(false);
        }
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.getUIContext().put("userPermSet", this.editData);
        }
        this.loadUserInfo();
    }

    private void loadUserInfo() {
        ComboBoxModel comboXModel;
        if (this.editData.getUser() != null && (comboXModel = this.combUser.getModel()) != null && comboXModel.getSize() > 0) {
            int size = comboXModel.getSize();
            for (int i = 0; i < size; ++i) {
                UserInfo userInfo = (UserInfo)comboXModel.getElementAt(i);
                if (!HRUtilExtend.isObjectEquelsByPkValue((CoreBaseInfo)userInfo, (CoreBaseInfo)this.editData.getUser())) continue;
                this.combUser.setSelectedIndex(i);
                break;
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        PositionOfUserPromptBox prmptBox = new PositionOfUserPromptBox((IUIObject)this, this.getUIContext());
        this.prmtinheritPerson.setSelector((KDPromptSelector)prmptBox);
        this.initCombUser();
        this.setButtonStatusByOptState();
    }

    private void setButtonStatusByOptState() {
        String optState = (String)this.getUIContext().get("parentUIOptStatus");
        if (OprtState.VIEW.equals(optState)) {
            this.btnSubmit.setEnabled(false);
            this.combUser.setEnabled(false);
            this.radDoneNothing.setEnabled(false);
            this.radClear.setEnabled(false);
            this.radGetDefault.setEnabled(false);
            this.radInherit.setEnabled(false);
            this.prmtinheritPerson.setEditable(false);
        }
    }

    private void initCombUser() {
        HRAffairBizBillEntryInfo entryInfo = (HRAffairBizBillEntryInfo)this.getUIContext().get("affairEntry");
        PersonInfo person = entryInfo.getPerson();
        try {
            UserCollection userColl = UserPermSetFactory.getRemoteInstance().getPersonOfUserCollection(person);
            UIHelper.initComboBoxModel((KDComboBox)this.combUser, (Iterator)userColl.iterator());
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.radInherit.isSelected() && this.prmtinheritPerson.getData() == null) {
            this.prmtinheritPerson.requestFocusInWindow();
            throw new PersonCheckException(PersonCheckException.NEEDSELECTINHERITUSER);
        }
    }

    @Override
    protected void radDoneNothing_actionPerformed(ActionEvent e) throws Exception {
        this.clearInheritPerson();
    }

    private void clearInheritPerson() {
        this.prmtinheritPerson.setEnabled(false);
        this.prmtinheritPerson.setData(null);
        this.prmtinheritUser.setData(null);
        this.prmtinheritPerson.setRequired(false);
    }

    @Override
    protected void radClear_actionPerformed(ActionEvent e) throws Exception {
        this.clearInheritPerson();
    }

    @Override
    protected void radInherit_actionPerformed(ActionEvent e) throws Exception {
        this.prmtinheritPerson.setEnabled(true);
        this.prmtinheritPerson.setRequired(true);
    }

    @Override
    protected void radGetDefault_actionPerformed(ActionEvent e) throws Exception {
        this.clearInheritPerson();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return UserPermSetFactory.getRemoteInstance();
    }

    @Override
    protected void prmtinheritPerson_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() != null) {
            PersonStatusEnum personStatus;
            PersonInfo personInfo = (PersonInfo)e.getNewValue();
            UserInfo inheritUser = (UserInfo)personInfo.get("InheritUserInfo");
            if (inheritUser != null) {
                this.editData.setInheritUser(inheritUser);
            }
            if ((personStatus = (PersonStatusEnum)((Object)personInfo.get("PersonStatus"))) != null) {
                this.editData.setPersonStatus(personStatus);
            }
            this.prmtinheritUser.setData(personInfo.get("InheritUserInfo"));
        }
    }

    @Override
    protected IObjectValue createNewData() {
        UserPermSetInfo userPermSetInfo = new UserPermSetInfo();
        userPermSetInfo.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        userPermSetInfo.setId(BOSUuid.create((BOSObjectType)userPermSetInfo.getBOSType()));
        HRAffairBizBillEntryInfo entryInfo = (HRAffairBizBillEntryInfo)this.getUIContext().get("affairEntry");
        userPermSetInfo.setAffairEntryID(entryInfo.getId().toString());
        userPermSetInfo.setAdminOrgUnit(entryInfo.getAdminOrg());
        userPermSetInfo.setPosition(entryInfo.getPosition());
        userPermSetInfo.setPerson(entryInfo.getPerson());
        if (entryInfo.getPerson() != null) {
            userPermSetInfo.setPersonNum(entryInfo.getPerson().getNumber());
            userPermSetInfo.setPersonName(entryInfo.getPerson().getName());
        } else if (entryInfo instanceof EmpEnrollBizBillEntryInfo) {
            EmpEnrollBizBillEntryInfo entry = (EmpEnrollBizBillEntryInfo)entryInfo;
            userPermSetInfo.setPersonNum(entry.getEmpNumber());
            userPermSetInfo.setPersonName(entry.getEmpName());
        }
        if (this.combUser.getModel().getSize() > 0) {
            this.combUser.setSelectedIndex(0);
            userPermSetInfo.setUser((UserInfo)this.combUser.getSelectedItem());
        }
        this.getUIContext().put("userPermSet", userPermSetInfo);
        return userPermSetInfo;
    }
}

