/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client.util;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.CellType;

public class ExcelFormatToXML {
    public String workBookFootXML() {
        StringBuffer workBookFootXML = new StringBuffer();
        workBookFootXML.append("  </Workbook> ");
        return workBookFootXML.toString();
    }

    public String workBookHeadXML() {
        StringBuffer workBookHeadXML = new StringBuffer();
        workBookHeadXML.append("<?xml version=\"1.0\" encoding=\"GBK\" ?> ").append(" <?mso-application progid=\"Excel.Sheet\"?> ").append("<Workbook xmlns=\"urn:schemas-microsoft-com:office:spreadsheet\" ").append(" xmlns:o=\"urn:schemas-microsoft-com:office:office\" ").append("xmlns:x=\"urn:schemas-microsoft-com:office:excel\" ").append("xmlns:ss=\"urn:schemas-microsoft-com:office:spreadsheet\" ").append("xmlns:html=\"http://www.w3.org/TR/REC-html40\">").append("<DocumentProperties xmlns=\"urn:schemas-microsoft-com:office:office\"> ").append("<Version>11.9999</Version> ").append("</DocumentProperties> ").append("<ExcelWorkbook xmlns=\"urn:schemas-microsoft-com:office:excel\"> ").append(" <WindowHeight>10005</WindowHeight> ").append("<WindowWidth>10005</WindowWidth> ").append(" <WindowTopX>120</WindowTopX> ").append(" <WindowTopY>135</WindowTopY> ").append(" <ActiveSheet>0</ActiveSheet> ").append("<ProtectStructure>False</ProtectStructure> ").append("<ProtectWindows>False</ProtectWindows> ").append("</ExcelWorkbook> ").append("<Styles> ").append("<Style ss:ID=\"Default\" ss:Name=\"Normal\"> ").append("<Alignment ss:Vertical=\"Center\"/> ").append("<Borders/> ").append(" <Font ss:FontName=\"Arial\" x:CharSet=\"120\" ss:Size=\"9\"/> ").append("<Interior/> ").append("<NumberFormat/> ").append("  <Protection/> ").append(" </Style> ").append("<Style ss:ID=\"s23\"> ").append("<Font ss:FontName=\"Arial\" x:CharSet=\"120\" ss:Size=\"9\" ss:Color=\"#000000\" ").append("  ss:Bold=\"0\"/> ").append(" <Interior ss:Color=\"#CECFFF\" ss:Pattern=\"Solid\"/> ").append(" </Style> ").append(" </Styles> ");
        return workBookHeadXML.toString();
    }

    public String sheetToXML(HSSFSheet sht) {
        StringBuffer sheetXML = new StringBuffer();
        int rowCount = sht.getPhysicalNumberOfRows();
        sheetXML.append("<Worksheet ss:Name=\"").append(sht.getSheetName()).append("\">");
        sheetXML.append("<Table ss:ExpandedColumnCount=\"").append(sht.getRow(0).getPhysicalNumberOfCells()).append("\"").append(" ss:ExpandedRowCount=\"").append(rowCount).append("\"").append("  x:FullColumns=\"1\"").append(" x:FullRows=\"1\"").append(" ss:DefaultColumnWidth=\"80\"").append(" ss:DefaultRowHeight=\"19\">");
        for (int i = 0; i < rowCount; ++i) {
            sheetXML.append(this.rowToXML(sht.getRow(i), i == 0));
        }
        sheetXML.append("</Table>");
        sheetXML.append("<WorksheetOptions xmlns=\"urn:schemas-microsoft-com:office:excel\"> ");
        sheetXML.append("<Unsynced/> ");
        sheetXML.append("<ProtectObjects>False</ProtectObjects> ");
        sheetXML.append("<ProtectScenarios>False</ProtectScenarios> ");
        sheetXML.append(" </WorksheetOptions> ");
        sheetXML.append("</Worksheet>");
        return sheetXML.toString();
    }

    public String rowToXML(HSSFRow row, boolean isHead) {
        StringBuffer rowXML = new StringBuffer();
        int colCount = row.getPhysicalNumberOfCells();
        rowXML.append("<Row>");
        for (int i = 0; i < colCount; ++i) {
            rowXML.append(this.cellToXML(row.getCell((int)((short)i)), isHead));
        }
        rowXML.append("</Row>");
        return rowXML.toString();
    }

    public String cellToXML(HSSFCell cell, boolean isHead) {
        StringBuffer cellXML = new StringBuffer();
        if (isHead) {
            cellXML.append("<Cell ss:StyleID=\"s23\">");
        } else {
            cellXML.append("<Cell>");
        }
        cellXML.append("<Data ss:Type=\"");
        if (cell.getCellType() == CellType.STRING) {
            cellXML.append("String");
            cellXML.append("\">");
            cellXML.append(cell.getStringCellValue());
        } else if (cell.getCellType() == CellType.NUMERIC) {
            cellXML.append("Number");
            cellXML.append("\">");
            cellXML.append(cell.getNumericCellValue());
        } else {
            cellXML.append("String");
            cellXML.append("\">");
            cellXML.append(cell.getStringCellValue());
        }
        cellXML.append("</Data>");
        cellXML.append("</Cell>");
        return cellXML.toString();
    }
}

