/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.framework.ejb.HistoryEntityParam;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.hraux.PersonRZTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.eip.sso.ltpa.ConfigurationError;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.affair.GetEmpNumTableFactory;
import com.kingdee.eas.hr.affair.GetEmpNumTableInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillInfo;
import com.kingdee.eas.hr.affair.HRAffairBizCollection;
import com.kingdee.eas.hr.affair.HRAffairBizFactory;
import com.kingdee.eas.hr.affair.HRAffairBizInfo;
import com.kingdee.eas.hr.affair.IHRAffairBizBill;
import com.kingdee.eas.hr.affair.ResignBizBillEntryInfo;
import com.kingdee.eas.hr.base.BaseBizException;
import com.kingdee.eas.hr.base.CheckStateEnum;
import com.kingdee.eas.hr.base.EmpInfoMultiPageInfo;
import com.kingdee.eas.hr.base.EmpPosOrgDateInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFacadeFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.GlobalRoamingExtendCollection;
import com.kingdee.eas.hr.base.GlobalRoamingExtendFactory;
import com.kingdee.eas.hr.base.HRBaseException;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.hr.base.batch.BatchProcessedResult;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.emp.EmpInnerWorkExpFactory;
import com.kingdee.eas.hr.emp.EmpInnerWorkExpInfo;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.EmployeeTypeEnum;
import com.kingdee.eas.hr.emp.IEmpInnerWorkExp;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.IPersonPositionExtend;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionExtendCollection;
import com.kingdee.eas.hr.emp.PersonPositionExtendFactory;
import com.kingdee.eas.hr.emp.PersonPositionExtendInfo;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.PersonWorkExpCurCollection;
import com.kingdee.eas.hr.emp.PersonWorkExpCurFactory;
import com.kingdee.eas.hr.emp.PersonWorkExpCurInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.osf.service.ServiceLocator;
import com.kingdee.shr.preentry.PreEntryCollection;
import com.kingdee.shr.preentry.PreEntryFactory;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class HRUtilExtend {
    public static PersonPositionInfo getPersonPositionInfoByPersonInfo(Context ctx, PersonInfo personInfo) throws BOSException {
        PersonPositionInfo ppInfo = null;
        if (personInfo != null) {
            IPersonPosition ipp = null;
            ipp = ctx == null ? PersonPositionFactory.getRemoteInstance() : PersonPositionFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personInfo.getId()));
            viewInfo.setFilter(filterInfo);
            PersonPositionCollection ppColl = ipp.getPersonPositionCollection(viewInfo);
            if (ppColl.size() > 0) {
                ppInfo = ppColl.get(0);
            }
        }
        return ppInfo;
    }

    public static PersonPositionExtendInfo getPersonPositionExtendInfoByPersonInfo(Context ctx, PersonInfo personInfo) throws BOSException {
        PersonPositionExtendInfo ppInfo = null;
        if (personInfo != null) {
            IPersonPositionExtend ipp = null;
            ipp = ctx == null ? PersonPositionExtendFactory.getRemoteInstance() : PersonPositionExtendFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personInfo.getId()));
            viewInfo.setFilter(filterInfo);
            PersonPositionExtendCollection ppColl = ipp.getPersonPositionExtendCollection(viewInfo);
            if (ppColl.size() > 0) {
                ppInfo = ppColl.get(0);
            }
        }
        return ppInfo;
    }

    public static PositionMemberInfo getPMInfo(PersonInfo person, PositionInfo position) {
        if (position == null || position.getId() == null || person == null || person.getId() == null) {
            return null;
        }
        String oql = "select id,isPrimary,checkLen,checkOverTime,personnelNumber,checkState,isCheck,beginDate,checkState ";
        oql = oql + " where person.id='" + person.getId() + "' and position.id='" + position.getId() + "'";
        PositionMemberCollection pmCol = null;
        try {
            pmCol = PositionMemberFactory.getRemoteInstance().getPositionMemberCollection(oql);
            if (pmCol != null && pmCol.size() == 1) {
                return pmCol.get(0);
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static PositionMemberCollection getPMInfoColl(Context ctx, Set personIdSet) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)true));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("isPrimary"));
        selectors.add(new SelectorItemInfo("checkLen"));
        selectors.add(new SelectorItemInfo("checkOverTime"));
        selectors.add(new SelectorItemInfo("personnelNumber"));
        selectors.add(new SelectorItemInfo("isCheck"));
        selectors.add(new SelectorItemInfo("beginDate"));
        selectors.add(new SelectorItemInfo("checkState"));
        selectors.add(new SelectorItemInfo("beginDate"));
        selectors.add(new SelectorItemInfo("isPrimary"));
        selectors.add(new SelectorItemInfo("position.id"));
        selectors.add(new SelectorItemInfo("position.adminOrgUnit.id"));
        viewInfo.setSelector(selectors);
        viewInfo.setFilter(filter);
        return PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(viewInfo);
    }

    public static PersonInfo getPersonInfoByNumber(Context ctx, String personNumber) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)personNumber));
        view.setFilter(filterInfo);
        PersonCollection pcoll = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(view);
        if (pcoll.size() > 0) {
            return pcoll.get(0);
        }
        return null;
    }

    public static boolean isObjectEquelsByPkValue(CoreBaseInfo ainfo, CoreBaseInfo binfo) {
        if (ainfo != null && ainfo.getId() != null && binfo != null && binfo.getId() != null) {
            return ainfo.getId().equals((Object)binfo.getId());
        }
        return ainfo == binfo;
    }

    public static boolean isObjectEquelsByNumberValue(DataBaseInfo ainfo, DataBaseInfo binfo) {
        if (ainfo != null && ainfo.getNumber() != null && binfo != null && binfo.getNumber() != null) {
            return ainfo.getNumber().equals(binfo.getNumber());
        }
        return ainfo == binfo;
    }

    public static EmpInnerWorkExpInfo buildEmpInnerWorkExpInfo(Context ctx, EmpPosOrgRelationInfo info) throws BOSException {
        EmpInnerWorkExpInfo workExpInfo = new EmpInnerWorkExpInfo();
        workExpInfo.setAdminOrgUnit(info.getAdminOrg());
        workExpInfo.setPosition(info.getPosition());
        workExpInfo.setPerson(info.getPerson());
        workExpInfo.setEffectStartDate(info.getEFFDT());
        workExpInfo.setEffectEndDate(info.getLEFFDT());
        workExpInfo.setEmployeeType(info.getLaborRelation().getLaborRelationState());
        workExpInfo.setIsPartTime(info.getAssignType().getValue() == 0);
        workExpInfo.setEmpPosRela(info);
        HRUtilExtend.setEmpInnerWorExpTxtField(ctx, info, workExpInfo);
        return workExpInfo;
    }

    private static void setEmpInnerWorExpTxtField(Context ctx, EmpPosOrgRelationInfo info, EmpInnerWorkExpInfo workExpInfo) throws BOSException {
        FilterInfo filter;
        EntityViewInfo viewInfo;
        if (info.getAdminOrg() != null && !StringUtils.isEmpty((String)info.getAdminOrg().getName())) {
            workExpInfo.setAdminOrgName(info.getAdminOrg().getName());
        } else if (info.getAdminOrg() != null && info.getAdminOrg().getId() != null) {
            viewInfo = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getAdminOrg().getId().toString()));
            viewInfo.setFilter(filter);
            AdminOrgUnitCollection adminOrgColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(viewInfo);
            if (adminOrgColl.size() > 0) {
                workExpInfo.setAdminOrgName(adminOrgColl.get(0).getName());
            }
        }
        if (info.getPosition() != null && info.getPosition().getId() != null) {
            viewInfo = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getPosition().getId().toString()));
            viewInfo.setFilter(filter);
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("id"));
            selectors.add(new SelectorItemInfo("name"));
            selectors.add(new SelectorItemInfo("job.id"));
            selectors.add(new SelectorItemInfo("job.name"));
            viewInfo.setSelector(selectors);
            PositionCollection posColl = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection(viewInfo);
            if (posColl.size() > 0) {
                workExpInfo.setPositionName(posColl.get(0).getName());
                if (posColl.get(0).getJob() != null) {
                    workExpInfo.setJobGradeName(posColl.get(0).getJob().getName());
                }
            }
        }
    }

    public static void doWithEmpInnerWorkExpInfo(Context ctx, EmpPosOrgDateInfo info, int checkLen, Date checkOverTime, CheckStateEnum checkState, String personnelNumber, PersonRZTypeInfo rzType, String[] selectors) throws EASBizException, BOSException {
        EmpPosOrgRelationInfo empPosInfo = EmpPosOrgRelationFacadeFactory.getLocalInstance(ctx).getEmpPosOrgRelationByPositionAndDate(info.getPersonID(), info.getPositionID(), info.getAdminOrgID(), info.getEffectStartDate());
        if (empPosInfo != null) {
            IEmpInnerWorkExp iEmpInnerWorkExp = EmpInnerWorkExpFactory.getLocalInstance((Context)ctx);
            EmpInnerWorkExpInfo expInfo = iEmpInnerWorkExp.getEmpInnerWorkExpInfoByRela(empPosInfo);
            if (expInfo != null) {
                SelectorItemCollection selector = new SelectorItemCollection();
                for (int i = 0; i < selectors.length; ++i) {
                    selector.add(new SelectorItemInfo(selectors[i]));
                }
                expInfo.setCheckLen(checkLen);
                expInfo.setCheckOverTime(checkOverTime);
                expInfo.setCheckState(checkState);
                expInfo.setPersonnelNumber(personnelNumber);
                expInfo.setPersonRZType(rzType);
                iEmpInnerWorkExp.updatePartial((EmpInfoMultiPageInfo)expInfo, selector);
            } else {
                expInfo = HRUtilExtend.buildEmpInnerWorkExpInfo(ctx, empPosInfo);
                expInfo.setCheckLen(checkLen);
                expInfo.setCheckOverTime(checkOverTime);
                expInfo.setCheckState(checkState);
                expInfo.setPersonnelNumber(personnelNumber);
                expInfo.setPersonRZType(rzType);
                iEmpInnerWorkExp.addnew((EmpInfoMultiPageInfo)expInfo);
            }
        }
    }

    public static void updateEmpInnerWorkExpInfo(Context ctx, EmpPosOrgDateInfo info, EmpInnerWorkExpInfo expValInfo, String[] selectors) throws EASBizException, BOSException {
        IEmpInnerWorkExp iEmpInnerWorkExp;
        EmpInnerWorkExpInfo expInfo;
        EmpPosOrgRelationInfo empPosInfo = EmpPosOrgRelationFacadeFactory.getLocalInstance(ctx).getEmpPosOrgRelationByPositionAndDate(info.getPersonID(), info.getPositionID(), info.getAdminOrgID(), info.getEffectStartDate());
        if (empPosInfo != null && (expInfo = (iEmpInnerWorkExp = EmpInnerWorkExpFactory.getLocalInstance((Context)ctx)).getEmpInnerWorkExpInfoByRela(empPosInfo)) != null) {
            expValInfo.setId(expInfo.getId());
            SelectorItemCollection selector = new SelectorItemCollection();
            for (int i = 0; i < selectors.length; ++i) {
                selector.add(new SelectorItemInfo(selectors[i]));
            }
            iEmpInnerWorkExp.updatePartial((EmpInfoMultiPageInfo)expValInfo, selector);
        }
    }

    public static void setMaxDateTimeNull(IRowSet rowSet) {
        java.sql.Date effectEndDate = null;
        Date maxDate = HRUtil.getMaxEndDate();
        try {
            while (rowSet.next()) {
                effectEndDate = rowSet.getDate("effectEndDate");
                if (effectEndDate == null || !DateTimeUtils.dayEquals((Date)effectEndDate, (Date)maxDate)) continue;
                rowSet.updateDate("effectEndDate", null);
            }
            rowSet.beforeFirst();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static String getURL(Context ctx) {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        String username = user.getNumber();
        String dataCenter = ctx.getAIS();
        String fileName = System.getProperty("EAS_INSTANCE_CONFIG_PATH").trim() + "/portalConfig/LtpaToken.properties";
        String password = LtpaTokenManager.generate((String)username, (String)fileName).toString();
        Properties properties = new Properties();
        InputStream is = null;
        try {
            is = new FileInputStream(SHRCheck.checkFilePath((String)(System.getProperty("eas.properties.dir").trim() + "/eas_httpd.conf")));
            properties.load(is);
        }
        catch (IOException ioe) {
            throw new ConfigurationError("eas_httpd.conf not found");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String proxyPassReverse = properties.getProperty("ProxyPassReverse");
        String domian = proxyPassReverse.substring(proxyPassReverse.indexOf("http"));
        String url = domian + "easportal/index2sso.jsp?username=" + username + "&password=" + password + "&dataCenter=" + dataCenter;
        return url;
    }

    @Deprecated
    public static HROrgUnitInfo getAdminOrgOfHRO(Context ctx, AdminOrgUnitInfo adminOrg) throws BOSException {
        HROrgUnitInfo hro = null;
        if (adminOrg != null) {
            MetaDataPK metaPK = MetaDataPK.create((String)"com.kingdee.eas.hr.org.app.AdminOrgGetHROQuery");
            IQueryExecutor queryExecutor = null;
            queryExecutor = ctx != null ? QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metaPK) : QueryExecutorFactory.getRemoteInstance((IMetaDataPK)metaPK);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)adminOrg.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("typeRelation.id", (Object)"00000000-0000-0000-0000-0000000000100FE9F8B5"));
            viewInfo.setFilter(filter);
            queryExecutor.setObjectView(viewInfo);
            IRowSet rs = queryExecutor.executeQuery();
            try {
                while (rs.next()) {
                    hro = new HROrgUnitInfo();
                    String toUnitID = rs.getString("toUnit.id");
                    String ctrlUnitID = rs.getString("ctrlUnit.id");
                    CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
                    ctrlUnitInfo.setId(BOSUuid.read((String)ctrlUnitID));
                    hro.setId(BOSUuid.read((String)toUnitID));
                    hro.setCU(ctrlUnitInfo);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return hro;
    }

    public static String format(Date date, String pattern) {
        return HRUtilExtend.format(date, pattern, Locale.getDefault());
    }

    public static String format(Date date, String pattern, Locale locale) {
        SimpleDateFormat df = new SimpleDateFormat(pattern, locale);
        String d = null;
        try {
            d = df.format(date);
        }
        catch (Exception e) {
            d = HRUtilExtend.format(new Date(), pattern);
        }
        return d;
    }

    public static HROrgUnitInfo getPersonOfHrOrgUnitInfo(Context ctx, String personId) throws BOSException {
        HROrgUnitInfo hroInfo = null;
        if (StringUtils.isEmpty((String)personId)) {
            hroInfo = ctx == null ? SysContext.getSysContext().getCurrentHRUnit() : ContextUtil.getCurrentHRUnit((Context)ctx);
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append("select FToUnitID from T_ORG_UnitRelation where FFromUnitID in (").append("select FPersonDep from T_HR_PersonPosition where fPersonID='").append(personId).append("')");
            IRowSet rs = null;
            if (ctx == null) {
                ISQLExecutor iSQLE = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
                rs = iSQLE.executeSQL();
            } else {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            }
            try {
                if (rs.next()) {
                    hroInfo = new HROrgUnitInfo();
                    hroInfo.setId(BOSUuid.read((String)rs.getString("FToUnitID")));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return hroInfo;
    }

    public static EmployeeTypeInfo getEmployeTypeInInfo(Context ctx, String personId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t.Fid,t.fnumber,t.FinService from t_bd_person p inner join ").append("T_HR_BDEmployeeType t on p.FEmployeeTypeID=t.fid where p.FID='").append(personId).append("'");
        EmployeeTypeInfo empType = new EmployeeTypeInfo();
        try {
            IRowSet rs = null;
            if (ctx != null) {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            } else {
                ISQLExecutor iSql = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
                rs = iSql.executeSQL();
            }
            while (rs.next()) {
                int inService = rs.getInt("FinService");
                empType.setId(BOSUuid.read((String)rs.getString("fid")));
                empType.setInService(EmployeeTypeEnum.getEnum((int)inService));
                empType.setNumber(rs.getString("fnumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return empType;
    }

    public static PersonWorkExpCurInfo getLastPersonWorkExpCurInfo(Context ctx, String personId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)true));
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("endDate"));
        PersonWorkExpCurCollection coll = PersonWorkExpCurFactory.getLocalInstance((Context)ctx).getPersonWorkExpCurCollection(view);
        PersonWorkExpCurInfo curInfo = null;
        if (coll.size() > 0) {
            curInfo = coll.get(0);
        }
        return curInfo;
    }

    public static boolean isUseSHRPersonPlan(Context ctx) throws EASBizException, BOSException {
        boolean isUseSHR = com.kingdee.eas.base.core.hr.util.HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_USE_SHR_PersonPlan", null);
        return isUseSHR;
    }

    public static Timestamp getCurTimestamp() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    public static Date getCurDateWithTruncated() {
        return DateTimeUtils.truncateDate((Date)new Date());
    }

    public static String getCurrentDate() {
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "{ts'" + sFormat.format(HRUtilExtend.getCurDateWithTruncated().getTime()) + "'}";
    }

    public static Date stringToDate(String s) {
        Date d = null;
        if (EmptyUtil.isEmpty((String)s)) {
            d = DateUtil.getDayBegin();
        } else {
            try {
                d = Constants.FORMAT_DAY.parse(s);
            }
            catch (ParseException e) {
                try {
                    d = BOSLocaleUtil.getDateFormat().parse(s);
                }
                catch (ParseException e1) {
                    d = DateUtil.getDayBegin();
                }
            }
        }
        return d;
    }

    public static String getStrFromList(List list) {
        StringBuffer sb = new StringBuffer();
        if (list == null || list.size() == 0) {
            return "('')";
        }
        sb.append("(");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (size == 1) {
                sb.append("'");
                sb.append((String)list.get(i));
                sb.append("')");
                continue;
            }
            if (i != size - 1) {
                sb.append("'");
                sb.append((String)list.get(i));
                sb.append("', ");
                continue;
            }
            sb.append("'");
            sb.append((String)list.get(i));
            sb.append("')");
        }
        return sb.toString();
    }

    public static String getStrFromArray(String[] strs) {
        StringBuffer sb = new StringBuffer();
        if (strs == null || strs.length == 0) {
            return "('')";
        }
        sb.append("(");
        int size = strs.length;
        for (int i = 0; i < size; ++i) {
            if (size == 1) {
                sb.append("'");
                sb.append(strs[i]);
                sb.append("')");
                continue;
            }
            if (i != size - 1) {
                sb.append("'");
                sb.append(strs[i]);
                sb.append("', ");
                continue;
            }
            sb.append("'");
            sb.append(strs[i]);
            sb.append("')");
        }
        return sb.toString();
    }

    public static String getDateStringWithoutMininute(Date date) {
        return DateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
    }

    public static String getDateStringWithoutMininuteTs(Date date) {
        String dateString = HRUtilExtend.getDateStringWithoutMininute(date);
        return " {ts'" + dateString + "'} ";
    }

    public static String getDateStringWithMinute(Date date) {
        return DateTimeUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String getDateStringWithMinuteTs(Date date) {
        return " {ts'" + HRUtilExtend.getDateStringWithMinute(date) + "'} ";
    }

    public static String replaceNotNull(String chars, String oldChars, String newChars) {
        StringBuffer str = new StringBuffer(chars);
        int begin = chars.indexOf(oldChars);
        if (begin < 0) {
            return str.toString();
        }
        int end = begin + oldChars.length();
        str.replace(begin, end, newChars);
        return str.toString();
    }

    public static String replace(String chars, String oldChars, String newChars) {
        if (oldChars == null) {
            return null;
        }
        StringBuffer str = new StringBuffer(chars);
        int begin = chars.indexOf(oldChars);
        if (begin < 0) {
            return str.toString();
        }
        int end = begin + oldChars.length();
        str.replace(begin, end, newChars);
        return str.toString();
    }

    @Deprecated
    public static void fillJobGradeInfoForAffairBizBillEntryInfo(HRAffairBizBillEntryInfo everyEntryInfo, String isUpdateJobgrade) throws BOSException, EASBizException {
        PositionInfo position = (PositionInfo)PositionFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(everyEntryInfo.getPosition().getId().toString()));
        if ("true".equals(isUpdateJobgrade) && position.getLowJobGrade() != null) {
            everyEntryInfo.setJobGrade(position.getLowJobGrade());
        } else {
            String oql = "select jobGrade where person.id='" + everyEntryInfo.getPerson().getId() + "'";
            IPersonPosition iPersonPosition = PersonPositionFactory.getRemoteInstance();
            if (iPersonPosition.exists(oql)) {
                PersonPositionInfo ppInfo = iPersonPosition.getPersonPositionInfo(oql);
                everyEntryInfo.setJobGrade(ppInfo.getJobGrade());
            }
        }
    }

    public static void verifyCellPhoneNumber(Context ctx, String cellPhoneNumber) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)cellPhoneNumber)) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("verifierType", "isCellPhone");
        params.put("verifyContent", cellPhoneNumber);
        IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "commonVerifierService");
        Map res = (Map)imsf.process(ctx, params);
        boolean result = (Boolean)res.get("result");
        if (!result) {
            throw new HRCommonException(HRCommonException.ERROR_CELLPHONENUMBER);
        }
    }

    public static void checkMobileDuplicateInPerson(Context ctx, String telNum, String excludePersonId) throws BOSException, EmployeeException {
        if (StringUtils.isEmpty((String)telNum)) {
            return;
        }
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer oql = new StringBuffer();
        oql.append("select person.fname_" + l + " as name from t_bd_person person");
        oql.append(" left join  T_HR_PersonContactMethod pcm on pcm.fpersonid = person.fid");
        oql.append(" left join  T_HR_EmpLaborRelation erb on erb.fpersonid = person.fid");
        oql.append(" left join  T_HR_BDEmployeeType ept on ept.fid = erb.FLaborRelationStateID");
        oql.append(" where ept.FIsInCount=1 and pcm.fmobile ='").append(telNum).append("'");
        if (!StringUtils.isEmpty((String)excludePersonId)) {
            oql.append(" and person.fid<>'").append(excludePersonId).append("'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        String expNameIfno = "";
        boolean j = false;
        try {
            while (rs.next()) {
                String personName = rs.getString("name");
                if (!j) {
                    expNameIfno = personName;
                    continue;
                }
                expNameIfno = expNameIfno + "," + personName;
            }
            if (!StringUtils.isEmpty((String)expNameIfno)) {
                Object[] params = new String[]{expNameIfno};
                throw new EmployeeException(EmployeeException.PERSON_MOBILE_ISDUPLICATE, params);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public static void checkMobileDuplicateInPerson2(Context ctx, String empName, String empNumber, String telNum, String excludePersonId) throws BOSException, EmployeeException {
        if (StringUtils.isEmpty((String)telNum)) {
            return;
        }
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer oql = new StringBuffer();
        oql.append("select person.fname_" + l + " as name from t_bd_person person");
        oql.append(" left join  T_HR_PersonContactMethod pcm on pcm.fpersonid = person.fid");
        oql.append(" left join  T_HR_EmpLaborRelation erb on erb.fpersonid = person.fid");
        oql.append(" left join  T_HR_BDEmployeeType ept on ept.fid = erb.FLaborRelationStateID");
        oql.append(" where ept.FIsInCount=1 and pcm.fmobile ='").append(telNum).append("'");
        if (!StringUtils.isEmpty((String)excludePersonId)) {
            oql.append(" and person.fid<>'").append(excludePersonId).append("'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        String expNameIfno = "";
        boolean j = false;
        try {
            while (rs.next()) {
                String personName = rs.getString("name");
                if (!j) {
                    expNameIfno = personName;
                    continue;
                }
                expNameIfno = expNameIfno + "," + personName;
            }
            if (!StringUtils.isEmpty((String)expNameIfno)) {
                Object[] params = new String[]{empName, empNumber, expNameIfno};
                throw new EmployeeException(EmployeeException.PERSON_MOBILE_ISDUPLICATE2, params);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public static void checkMobileDuplicateInEnBillBiz(Context ctx, String telNum, String excludeBillId) throws BOSException, EmployeeException {
        if (StringUtils.isEmpty((String)telNum)) {
            return;
        }
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer oql = new StringBuffer();
        oql.append(" select  fempnumber,fempName_" + l + " ,bill.fnumber as number   from T_HR_EmpEnrollBizBillEntry entry ");
        oql.append(" left join T_HR_EmpEnrollBizBill bill on entry.fbillid=bill.fid ");
        oql.append(" where ");
        oql.append("   (");
        oql.append(" bill.fbillstate = ");
        oql.append(0);
        oql.append(" or bill.fbillstate = ");
        oql.append(1);
        oql.append(" or bill.fbillstate = ");
        oql.append(2);
        oql.append(" or (bill.fbillstate = ");
        oql.append(3);
        oql.append(" and entry.fbizDate > ");
        oql.append(HRUtilExtend.getDateStringWithoutMininuteTs(cal.getTime()));
        oql.append(" )) and entry.ftelnum='");
        oql.append(telNum).append("'");
        if (!StringUtils.isEmpty((String)excludeBillId)) {
            oql.append(" and bill.fid<>'").append(excludeBillId).append("'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        String expNameIfno = "";
        boolean j = false;
        try {
            while (rs.next()) {
                String personName = rs.getString("number");
                if (!j) {
                    expNameIfno = personName;
                    continue;
                }
                expNameIfno = expNameIfno + "," + personName;
            }
            if (!StringUtils.isEmpty((String)expNameIfno)) {
                Object[] params = new String[]{expNameIfno};
                throw new EmployeeException(EmployeeException.PERSON_MOBILE_ISDUPLICATE_INPROC, params);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public static void checkEmailDuplicateInPerson(Context ctx, String email, String excludePersonId) throws BOSException, EmployeeException {
        if (StringUtils.isEmpty((String)email)) {
            return;
        }
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer oql = new StringBuffer();
        oql.append("select person.fname_" + l + " as name from t_bd_person person");
        oql.append(" left join  T_HR_PersonContactMethod pcm on pcm.fpersonid = person.fid");
        oql.append(" left join  T_HR_EmpLaborRelation erb on erb.fpersonid = person.fid");
        oql.append(" left join  T_HR_BDEmployeeType ept on ept.fid = erb.FLaborRelationStateID");
        oql.append(" where ept.FIsInCount=1 and pcm.femail ='").append(email).append("'");
        if (!StringUtils.isEmpty((String)excludePersonId)) {
            oql.append(" and person.fid<>'").append(excludePersonId).append("'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        String expNameIfno = "";
        int j = 0;
        try {
            while (rs.next()) {
                String personName = rs.getString("name");
                if (j == 0) {
                    expNameIfno = personName;
                    ++j;
                    continue;
                }
                expNameIfno = expNameIfno + "," + personName;
            }
            if (!StringUtils.isEmpty((String)expNameIfno)) {
                Object[] params = new String[]{expNameIfno};
                throw new EmployeeException(EmployeeException.PERSON_EMAIL_ISDUPLICATE, params);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public static void checkEmailDuplicateInEnBillBiz(Context ctx, String email, String excludeBillId) throws BOSException, EmployeeException {
        if (StringUtils.isEmpty((String)email)) {
            return;
        }
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer oql = new StringBuffer();
        oql.append(" select  fempnumber,fempName_" + l + " ,bill.fnumber as number   from T_HR_EmpEnrollBizBillEntry entry ");
        oql.append(" left join T_HR_EmpEnrollBizBill bill on entry.fbillid=bill.fid ");
        oql.append(" where ");
        oql.append("   (");
        oql.append(" bill.fbillstate = ");
        oql.append(0);
        oql.append(" or bill.fbillstate = ");
        oql.append(1);
        oql.append(" or bill.fbillstate = ");
        oql.append(2);
        oql.append(" or (bill.fbillstate = ");
        oql.append(3);
        oql.append(" and entry.fbizDate > ");
        oql.append(HRUtilExtend.getDateStringWithoutMininuteTs(cal.getTime()));
        oql.append(" )) and entry.femail='");
        oql.append(email).append("'");
        if (!StringUtils.isEmpty((String)excludeBillId)) {
            oql.append(" and bill.fid<>'").append(excludeBillId).append("'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        String expNameIfno = "";
        int j = 0;
        try {
            while (rs.next()) {
                String personName = rs.getString("number");
                if (j == 0) {
                    expNameIfno = personName;
                    ++j;
                    continue;
                }
                expNameIfno = expNameIfno + "," + personName;
            }
            if (!StringUtils.isEmpty((String)expNameIfno)) {
                Object[] params = new String[]{expNameIfno};
                throw new EmployeeException(EmployeeException.PERSON_EMAIL_ISDUPLICATE_INPROC, params);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public static void checkIdCardDuplicateInEnBillBiz(Context ctx, String idCardNo, String excludeBillId) throws BOSException, EmployeeException {
        if (StringUtils.isEmpty((String)idCardNo)) {
            return;
        }
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer oql = new StringBuffer();
        oql.append(" select  fempnumber,fempName_" + l + " ,bill.fnumber as number   from T_HR_EmpEnrollBizBillEntry entry ");
        oql.append(" left join T_HR_EmpEnrollBizBill bill on entry.fbillid=bill.fid ");
        oql.append(" where ");
        oql.append("   (");
        oql.append(" bill.fbillstate = ");
        oql.append(0);
        oql.append(" or bill.fbillstate = ");
        oql.append(1);
        oql.append(" or bill.fbillstate = ");
        oql.append(2);
        oql.append(" or (bill.fbillstate = ");
        oql.append(3);
        oql.append(" and entry.fbizDate > ");
        oql.append(HRUtilExtend.getDateStringWithoutMininuteTs(cal.getTime()));
        oql.append(" )) and entry.fIDCardNo='");
        oql.append(idCardNo).append("'");
        if (!StringUtils.isEmpty((String)excludeBillId)) {
            oql.append(" and bill.fid<>'").append(excludeBillId).append("'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        String expNameIfno = "";
        int j = 0;
        try {
            while (rs.next()) {
                String personName = rs.getString("number");
                if (j == 0) {
                    expNameIfno = personName;
                    ++j;
                    continue;
                }
                expNameIfno = expNameIfno + "," + personName;
            }
            if (!StringUtils.isEmpty((String)expNameIfno)) {
                Object[] params = new String[]{expNameIfno};
                throw new EmployeeException(EmployeeException.PERSON_IDCARDNO_ISDUPLICATE_INPROC, params);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public static void checkPassportNoDuplicateInEnBillBiz(Context ctx, String passportNo, String excludeBillId) throws BOSException, EmployeeException {
        if (StringUtils.isEmpty((String)passportNo)) {
            return;
        }
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer oql = new StringBuffer();
        oql.append(" select  fempnumber,fempName_" + l + " ,bill.fnumber as number   from T_HR_EmpEnrollBizBillEntry entry ");
        oql.append(" left join T_HR_EmpEnrollBizBill bill on entry.fbillid=bill.fid ");
        oql.append(" where ");
        oql.append("   (");
        oql.append(" bill.fbillstate = ");
        oql.append(0);
        oql.append(" or bill.fbillstate = ");
        oql.append(1);
        oql.append(" or bill.fbillstate = ");
        oql.append(2);
        oql.append(" or (bill.fbillstate = ");
        oql.append(3);
        oql.append(" and entry.fbizDate > ");
        oql.append(HRUtilExtend.getDateStringWithoutMininuteTs(cal.getTime()));
        oql.append(" )) and entry.fpassportNo='");
        oql.append(passportNo).append("'");
        if (!StringUtils.isEmpty((String)excludeBillId)) {
            oql.append(" and bill.fid<>'").append(excludeBillId).append("'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        String expNameIfno = "";
        int j = 0;
        try {
            while (rs.next()) {
                String personName = rs.getString("number");
                if (j == 0) {
                    expNameIfno = personName;
                    ++j;
                    continue;
                }
                expNameIfno = expNameIfno + "," + personName;
            }
            if (!StringUtils.isEmpty((String)expNameIfno)) {
                Object[] params = new String[]{expNameIfno};
                throw new EmployeeException(EmployeeException.PERSON_PASSPORTNO_ISDUPLICATE_INPROC, params);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public static void checkGlobalRoamingExists(Context ctx, String globalRoaming) throws BOSException, EmployeeException {
        if (StringUtils.isEmpty((String)globalRoaming)) {
            return;
        }
        GlobalRoamingExtendCollection globalRoamings = GlobalRoamingExtendFactory.getLocalInstance(ctx).getGlobalRoamingExtendCollection("select  id from  where areaCode = '" + globalRoaming + "'");
        if (globalRoamings == null || globalRoamings.isEmpty()) {
            throw new EmployeeException(EmployeeException.GLOBAL_ROAMING_EXISTS);
        }
    }

    public static void checkAccountNumDuplicateInEnBillBiz(Context ctx, String accountNum, String excludeBillId) throws BOSException, EmployeeException {
        if (StringUtils.isEmpty((String)accountNum)) {
            return;
        }
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer oql = new StringBuffer();
        oql.append(" select  fempnumber,fempName,bill.fnumber as number   from T_HR_EmpEnrollBizBillEntry entry ");
        oql.append(" left join T_HR_EmpEnrollBizBill bill on entry.fbillid=bill.fid ");
        oql.append(" where ");
        oql.append("   (");
        oql.append(" bill.fbillstate = ");
        oql.append(0);
        oql.append(" or bill.fbillstate = ");
        oql.append(1);
        oql.append(" or bill.fbillstate = ");
        oql.append(2);
        oql.append(" or (bill.fbillstate = ");
        oql.append(3);
        oql.append(" and entry.fbizDate > ");
        oql.append(HRUtilExtend.getDateStringWithoutMininuteTs(cal.getTime()));
        oql.append(" )) and entry.faccountNum='");
        oql.append(accountNum).append("'");
        if (!StringUtils.isEmpty((String)excludeBillId)) {
            oql.append(" and bill.fid<>'").append(excludeBillId).append("'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        String expNameIfno = "";
        int j = 0;
        try {
            while (rs.next()) {
                String personName = rs.getString("number");
                if (j == 0) {
                    expNameIfno = personName;
                    ++j;
                    continue;
                }
                expNameIfno = expNameIfno + "," + personName;
            }
            if (!StringUtils.isEmpty((String)expNameIfno)) {
                Object[] params = new String[]{expNameIfno};
                throw new EmployeeException(EmployeeException.EMP_ACCOUNTNUM_ISDUP_INPROC, params);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public static void verifyMail(Context ctx, String mail) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)mail)) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("verifierType", "isEmail");
        params.put("verifyContent", mail);
        IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "commonVerifierService");
        Map res = (Map)imsf.process(ctx, params);
        boolean result = (Boolean)res.get("result");
        if (!result) {
            throw new HRCommonException(HRCommonException.ERROR_MAIL);
        }
    }

    public static AdminOrgUnitInfo getCuByOrg(Context ctx, AdminOrgUnitInfo admin) throws EASBizException, BOSException {
        AdminOrgUnitInfo adminOrign = admin;
        admin = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(admin.getId().toString().trim()));
        while (!admin.isIsCU()) {
            admin = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(admin.getParent().getId().toString().trim()));
            if (admin != null) continue;
            throw new BOSException((Throwable)((Object)new BaseBizException(BaseBizException.THIS_POSI_PARENT_ORG_IS_NULL, new Object[]{adminOrign.getName()})));
        }
        return admin;
    }

    public static String getNumberByCu(Context ctx, AdminOrgUnitInfo admin, Boolean read) throws BOSException, EASBizException {
        AdminOrgUnitInfo ctrlUnitAdmin = HRUtilExtend.getCuByOrg(ctx, admin);
        CtrlUnitInfo ctrlUnitInfo = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(ctrlUnitAdmin.getId().toString()));
        PersonInfo person = new PersonInfo();
        HashMap<String, PersonInfo> param = new HashMap<String, PersonInfo>();
        PersonPositionInfo ppinfo = new PersonPositionInfo();
        ppinfo.setPerson(person);
        ppinfo.setPersonDep(admin);
        person.setCU(ctrlUnitInfo);
        person.put("personposition", (Object)ppinfo);
        param.put("pinfo", person);
        OSFAppUtil.callService((Context)ctx, (String)"getPersonCodingRuleStr", param);
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String mainOrgID = ctrlUnitAdmin.getId().toString();
        if (iCodingRuleManager.isExist((IObjectValue)person, mainOrgID)) {
            if (read.booleanValue()) {
                return iCodingRuleManager.readNumber((IObjectValue)person, mainOrgID);
            }
            CodingRuleInfo codingRuleInfo = HRUtilExtend.getCodingRuleByCu(ctx, ctrlUnitAdmin, Boolean.TRUE);
            String number = iCodingRuleManager.getNumber((IObjectValue)person, mainOrgID);
            GetEmpNumTableInfo empNuminfo = new GetEmpNumTableInfo();
            empNuminfo.setCacheNumber(number);
            empNuminfo.setNumberCU(ctrlUnitInfo.getId().toString());
            empNuminfo.setCodeRuleId(codingRuleInfo.getId().toString());
            empNuminfo.setIsSetNumUsed(Boolean.FALSE.booleanValue());
            GetEmpNumTableFactory.getLocalInstance((Context)ctx).addnew(empNuminfo);
            return number;
        }
        return null;
    }

    public static CodingRuleInfo getCodingRuleByCu(Context ctx, AdminOrgUnitInfo admin, Boolean read) throws BOSException, EASBizException {
        String mainOrgId;
        PersonInfo personInfo = new PersonInfo();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)personInfo, mainOrgId = HRUtilExtend.getCuByOrg(ctx, admin).getId().toString())) {
            return iCodingRuleManager.getCodingRule((IObjectValue)personInfo, mainOrgId);
        }
        return null;
    }

    public static String setPersonNumber(Context ctx, PersonInfo pInfo, AdminOrgUnitInfo admin) throws BOSException, EASBizException {
        try {
            HashMap<String, PersonInfo> param = new HashMap<String, PersonInfo>();
            PersonPositionInfo ppinfo = new PersonPositionInfo();
            ppinfo.setPerson(pInfo);
            ppinfo.setPersonDep(admin);
            pInfo.put("personposition", (Object)ppinfo);
            CtrlUnitInfo personCU = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(HRUtilExtend.getCuByOrg(ctx, admin).getId().toString()));
            pInfo.setCU(personCU);
            param.put("pinfo", pInfo);
            OSFAppUtil.callService((Context)ctx, (String)"getPersonCodingRuleStr", param);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IPerson iperons = PersonFactory.getLocalInstance((Context)ctx);
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String strCu = HRUtilExtend.getCuByOrg(ctx, admin).getId().toString();
        String number = null;
        if (iCodingRuleManager.isExist((IObjectValue)pInfo, strCu)) {
            CodingRuleInfo codingRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)pInfo, strCu);
            number = iCodingRuleManager.getNumber((IObjectValue)pInfo, strCu);
            if (codingRuleInfo.isIsModifiable() && pInfo.get("true") == null) {
                GetEmpNumTableInfo empNuminfo = new GetEmpNumTableInfo();
                empNuminfo.setCacheNumber(number);
                empNuminfo.setNumberCU(strCu);
                empNuminfo.setCodeRuleId(codingRuleInfo.getId().toString());
                empNuminfo.setIsSetNumUsed(Boolean.TRUE.booleanValue());
                GetEmpNumTableFactory.getLocalInstance((Context)ctx).addnew(empNuminfo);
                number = null;
            }
            if (number != null) {
                int numCount = 0;
                Date curDate = DateTimeUtils.truncateDate((Date)new Date());
                String strCurDate = HRUtilExtend.getDateStringWithoutMininuteTs(curDate);
                IRowSet resultSet = null;
                String sqlBill = "select billentry.fid from t_Hr_Empenrollbizbillentry billentry left join t_Hr_Empenrollbizbill bill on billentry.fbillid=bill.fid where (bill.fbillState in(0,1,2) or (bill.fbillState=3 and billentry.fbizdate>=" + strCurDate + "  )) and billentry.fempnumber=";
                while (numCount != 1) {
                    String oql2 = "select id where number='" + number + "'";
                    for (numCount = 1; iperons.exists(oql2) && numCount < 5000; ++numCount) {
                        number = iCodingRuleManager.getNumber((IObjectValue)pInfo, strCu);
                        oql2 = "select id where number='" + number + "'";
                    }
                    String sql2 = sqlBill + "'" + number + "'";
                    resultSet = DbUtil.executeQuery((Context)ctx, (String)sql2);
                    try {
                        for (numCount = 1; resultSet.next() && numCount < 5000; ++numCount) {
                            number = iCodingRuleManager.getNumber((IObjectValue)pInfo, strCu);
                            sql2 = sqlBill + "'" + number + "'";
                            resultSet = DbUtil.executeQuery((Context)ctx, (String)sql2);
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException(e.getMessage(), (Throwable)e);
                    }
                }
                pInfo.setNumber(number);
                GetEmpNumTableInfo empNuminfo = new GetEmpNumTableInfo();
                empNuminfo.setCacheNumber(number);
                empNuminfo.setNumberCU(strCu);
                empNuminfo.setCodeRuleId(codingRuleInfo.getId().toString());
                empNuminfo.setIsSetNumUsed(Boolean.TRUE.booleanValue());
                GetEmpNumTableFactory.getLocalInstance((Context)ctx).addnew(empNuminfo);
            }
        }
        return number;
    }

    public static Date getMinEFFDTOfPerson(String personId, Context ctx) throws BOSException {
        String sql = "select min(feffdt) from t_bd_personhis where FHistoryRelateID='" + personId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        Date effdt = null;
        try {
            if (rs.next()) {
                effdt = DateTimeUtils.truncateDate((Date)rs.getDate(1));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return effdt;
    }

    public static AdminOrgUnitInfo getCompany(Context ctx, AdminOrgUnitInfo curUnitInfo) throws BOSException, EASBizException {
        AdminOrgUnitInfo company;
        block8: {
            if (curUnitInfo == null) {
                return null;
            }
            company = null;
            if (curUnitInfo.getCompany() != null) {
                return curUnitInfo.getCompany();
            }
            try {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("*"));
                selector.add(new SelectorItemInfo("company.*"));
                selector.add(new SelectorItemInfo("unitLayerType.*"));
                curUnitInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(curUnitInfo.getId().toString()), selector);
                company = curUnitInfo.getCompany();
                if (company != null || curUnitInfo.getUnitLayerType() == null || curUnitInfo.getUnitLayerType().getAdminAffiliationType() == null) break block8;
                String typeId = curUnitInfo.getUnitLayerType().getAdminAffiliationType().getId().toString();
                if ("US3TP3eIJgbgU0A+qMDqhoRbQ4A=".equals(typeId)) {
                    company = curUnitInfo;
                    break block8;
                }
                if ("US3TP3eJJgbgU0A+qMDqhoRbQ4A=".equals(typeId)) {
                    company = curUnitInfo;
                    break block8;
                }
                if (!"US3TP3eKJgbgU0A+qMDqhoRbQ4A=".equals(typeId)) break block8;
                AdminOrgUnitCollection adminOrgColl = HRUtilExtend.getAllAdminOrgUnitCollection(ctx, curUnitInfo);
                int num = adminOrgColl.size();
                for (int j = 0; j < num; ++j) {
                    if (adminOrgColl.get(j).getCompany() == null) continue;
                    company = adminOrgColl.get(j).getCompany();
                    break;
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
                throw e;
            }
        }
        if (company == null) {
            Object[] params = new Object[]{curUnitInfo.getName()};
            throw new HRCommonException(HRCommonException.COMPANY_NULL, params);
        }
        return company;
    }

    public static String getCompanyIdByAdminOrgId(Context ctx, String adminOrgId) throws EASBizException, BOSException {
        AdminOrgUnitInfo adminOrg = new AdminOrgUnitInfo();
        adminOrg.setId(BOSUuid.read((String)adminOrgId));
        AdminOrgUnitInfo company = HRUtilExtend.getCompany(ctx, adminOrg);
        return company.getId().toString();
    }

    public static AdminOrgUnitCollection getAllAdminOrgUnitCollection(Context ctx, AdminOrgUnitInfo newOrgInfo) throws BOSException {
        String longNumber = newOrgInfo.getLongNumber();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Set<String> longNumSet = HRUtilExtend.getParentLongNumber(longNumber);
        filter.getFilterItems().add(new FilterItemInfo("longNumber", longNumSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        SorterItemCollection sorterColl = new SorterItemCollection();
        SorterItemInfo sorter = new SorterItemInfo("longNumber");
        sorter.setSortType(SortType.DESCEND);
        sorterColl.add(sorter);
        viewInfo.setSorter(sorterColl);
        IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitCollection adminOrgColl = iAdminOrgUnit.getAdminOrgUnitCollection(viewInfo);
        return adminOrgColl;
    }

    private static Set<String> getParentLongNumber(String longNumber) {
        String[] numArray = longNumber.split("!");
        HashSet<String> longNumSet = new HashSet<String>();
        for (int i = 0; i < numArray.length; ++i) {
            StringBuffer numBuf = new StringBuffer();
            for (int j = 0; j <= i; ++j) {
                if (j == 0) {
                    numBuf.append(numArray[j]);
                    continue;
                }
                numBuf.append("!").append(numArray[j]);
            }
            longNumSet.add(numBuf.toString());
        }
        return longNumSet;
    }

    public static UserInfo getCurrentUserInfo(Context ctx) throws BOSException {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    public static String getBooleanToString(Boolean value) {
        String str = null;
        if (value == null) {
            str = "";
        } else if (value.booleanValue()) {
            str = EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label105");
        } else if (!value.booleanValue()) {
            str = EASResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label106");
        }
        return str;
    }

    public static String resignAssignCheck(Context ctx, String personId, String billId) throws BOSException {
        String msg = null;
        if (personId == null) {
            return msg;
        }
        try {
            Object[] paraObj = null;
            PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
            String l = LocaleUtils.getShortCode((Context)ctx);
            String sql = "select FPERSONEMPID, FSUBJECT_" + l + " ,FPERSONEMPNAME_" + l + " from T_WFR_ASSIGN_VIEW where (FSTATE = 1 or FSTATE = 2 or FSTATE = 32) and FPERSONEMPID = ? ";
            if (StringUtils.isEmpty((String)billId)) {
                paraObj = new Object[]{personId};
            } else {
                sql = sql + " and FBIZOBJID <> ? ";
                paraObj = new Object[]{personId, billId};
            }
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])paraObj);
            StringBuffer sb = new StringBuffer();
            if (rowSet.size() > 0) {
                sb.append(MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label143", (Context)ctx) + " \r\n<br>", personInfo.getNumber(), personInfo.getName()));
            }
            while (rowSet.next()) {
                sb.append(rowSet.getString("FSUBJECT_" + l + "")).append("\r\n<br>");
            }
            if (rowSet.size() > 0) {
                msg = sb.toString();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return msg;
    }

    public static boolean isPositionCanDuplicate(Context ctx) {
        boolean flag = false;
        try {
            String canDuplicateValue = ParamManager.getParamValue((Context)ctx, null, (String)"IS_Position_Can_Duplicate");
            if ("true".equals(canDuplicateValue)) {
                flag = true;
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static int getDbType(Context ctx) throws BOSException {
        Connection conn = null;
        int type = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            type = KSqlUtil.getDbType((Connection)conn);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return type;
    }

    public static void assableCell(CoreBaseInfo info, String mobileField) throws EASBizException {
        String nCell;
        String globalRoaming = info.get("globalRoaming") != null ? info.get("globalRoaming").toString() : "";
        String string = nCell = info.get("nCell") != null ? info.get("nCell").toString() : "";
        if (info.containsKey("globalRoaming") && info.containsKey("nCell")) {
            if (!StringUtils.isEmpty((String)globalRoaming) && !StringUtils.isEmpty((String)nCell)) {
                if (StringUtils.equals((String)globalRoaming.trim(), (String)"+86")) {
                    info.put(mobileField, (Object)nCell.trim());
                } else {
                    info.put(mobileField, (Object)(globalRoaming.trim() + "-" + nCell.trim()));
                }
            } else {
                if (StringUtils.isEmpty((String)globalRoaming) && !StringUtils.isEmpty((String)nCell)) {
                    throw new HRCommonException(HRCommonException.GLOBALROAMING_NULL);
                }
                info.put(mobileField, null);
                info.put("globalRoaming", null);
                info.put("nCell", null);
            }
        }
    }

    public static String getGlobalCell(String globalRoaming, String nCell) {
        String tel = "";
        tel = !StringUtils.isEmpty((String)globalRoaming) && !StringUtils.isEmpty((String)nCell) ? (StringUtils.equals((String)globalRoaming.trim(), (String)"+86") ? nCell.trim() : globalRoaming.trim() + "-" + nCell.trim()) : "";
        return tel;
    }

    public static void isBOSUuid(String id) throws BOSException {
        try {
            BOSUuid.read((String)id);
        }
        catch (UuidException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static String readNumberByCu(Context ctx, PersonInfo person, AdminOrgUnitInfo admin, String strCu, Boolean read) throws BOSException, EASBizException {
        HashMap<String, PersonInfo> param = new HashMap<String, PersonInfo>();
        PersonPositionInfo ppinfo = new PersonPositionInfo();
        ppinfo.setPerson(person);
        ppinfo.setPersonDep(admin);
        person.setCU(CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(strCu)));
        person.put("personposition", (Object)ppinfo);
        param.put("pinfo", person);
        OSFAppUtil.callService((Context)ctx, (String)"getPersonCodingRuleStr", param);
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)person, strCu)) {
            if (read.booleanValue()) {
                return iCodingRuleManager.readNumber((IObjectValue)person, strCu);
            }
            return iCodingRuleManager.getNumber((IObjectValue)person, strCu);
        }
        return null;
    }

    @Deprecated
    public static String XSSSafeCheck(String string) {
        String format = MessageFormat.format("{0}", string);
        return format;
    }

    public static String formatPrivText(String text, int pre, int suf, String pattern) {
        if (StringUtils.isEmpty((String)text)) {
            return "[null]";
        }
        String result = null;
        try {
            String preString = text.substring(0, pre);
            String sufString = text.substring(text.length() - suf, text.length());
            if (pattern == null) {
                pattern = "{0}****{1}";
            }
            result = MessageFormat.format(pattern, preString, sufString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "****";
        }
        return result;
    }

    public static boolean isCodeAddView(Context ctx, AdminOrgUnitInfo admin) throws BOSException, EASBizException {
        Boolean isAddView = false;
        CodingRuleInfo codingRuleInfo = HRUtilExtend.getCodingRuleByCu(ctx, admin, Boolean.TRUE);
        if (codingRuleInfo != null) {
            isAddView = codingRuleInfo.isIsAddView();
        }
        return isAddView;
    }

    public static PersonInfo getPersonByIdNum(Context ctx, PersonInfo person, AdminOrgUnitInfo admin) throws BOSException, EASBizException {
        AdminOrgUnitInfo ctrlUnitAdmin = HRUtilExtend.getCuByOrg(ctx, admin);
        CtrlUnitInfo ctrlUnitInfo = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(ctrlUnitAdmin.getId().toString()));
        HashMap<String, PersonInfo> param = new HashMap<String, PersonInfo>();
        PersonPositionInfo ppinfo = new PersonPositionInfo();
        ppinfo.setPerson(person);
        ppinfo.setPersonDep(admin);
        person.setCU(ctrlUnitInfo);
        person.put("personposition", (Object)ppinfo);
        param.put("pinfo", person);
        OSFAppUtil.callService((Context)ctx, (String)"getPersonCodingRuleStr", param);
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        return person;
    }

    public static Date getPlanFormalDate(Date enterDate, int probation) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(enterDate);
        cal.add(2, probation);
        return cal.getTime();
    }

    public static Object getHistoryObject(Context ctx, String objectId, Date historyDate) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)objectId)) {
            return null;
        }
        BOSObjectType bosObjectType = BOSUuid.getBOSObjectType((String)objectId, (boolean)false);
        HistoryEntityParam param = HistoryUtil.getHistoryEntityParam((Context)ctx, (BOSObjectType)bosObjectType);
        if (!param.isNeedHistory()) {
            return null;
        }
        if (historyDate == null) {
            historyDate = new Date();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.EFFDT, (Object)historyDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.LEFFDT, (Object)historyDate, CompareType.GREATER_EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        ICoreBase iCoreBase = BaseMetaDataUtil.getBizInterface((Context)ctx, (BOSObjectType)bosObjectType);
        ObjectUuidPK pk = new ObjectUuidPK(objectId);
        List historys = iCoreBase.getAllHisVersionReturnCurrentPaging((IObjectPK)pk, view, 0, 10);
        return historys.isEmpty() ? null : historys.get(0);
    }

    public static String checkHireOrFlucBillExist(Context ctx, String personId, String billId, ResignBizBillEntryInfo resignEntryInfo) throws BOSException, EASBizException {
        String msg = null;
        if (personId == null) {
            return msg;
        }
        String currDate = HRUtilExtend.getCurrentDate();
        StringBuffer oql = new StringBuffer("select person.id,person.name,person.number,billBOSType,billID,entryBizDate ");
        oql.append("where person.id = '");
        oql.append(personId);
        oql.append("' ");
        if (!StringUtils.isEmpty((String)billId)) {
            oql.append(" and billID <> '");
            oql.append(billId);
            oql.append("' ");
        }
        oql.append(" and (");
        oql.append(" billState = ");
        oql.append(0);
        oql.append(" or billState = ");
        oql.append(1);
        oql.append(" or billState = ");
        oql.append(2);
        oql.append(" or (billState = ");
        oql.append(3);
        oql.append(" and entryBizDate > ");
        oql.append(currDate);
        oql.append(" ))");
        HRAffairBizCollection col = HRAffairBizFactory.getLocalInstance((Context)ctx).getHRAffairBizCollection(oql.toString());
        if (col != null && col.size() > 0) {
            BatchProcessedResult result = new BatchProcessedResult();
            String personNumber = null;
            String personName = null;
            String billName = null;
            HRAffairBizInfo bizInfo = null;
            String bosType = null;
            String exsitBillId = null;
            Date bizDate = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                PersonInfo person;
                bizInfo = col.get(i);
                personNumber = bizInfo.getPerson().getNumber();
                personName = bizInfo.getPerson().getName();
                bosType = bizInfo.getBillBOSType();
                billName = loader.getEntity(BOSObjectType.create((String)bosType)).getAlias();
                exsitBillId = bizInfo.getBillID().toString();
                bizDate = bizInfo.getEntryBizDate();
                String entityName = loader.getEntity(BOSObjectType.create((String)bosType)).getFullName();
                IHRAffairBizBill IHRAffairBizBill2 = (IHRAffairBizBill)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
                HRAffairBizBillInfo billInfo = IHRAffairBizBill2.getHRAffairBizBillInfo((IObjectPK)new ObjectUuidPK(exsitBillId));
                if (!bosType.equals("B65CCEF1") && !bosType.equals("C0DAD00D") || (person = resignEntryInfo.getPerson()) == null || person.getId() == null || !person.getId().toString().equals(bizInfo.getPerson().getId().toString()) || !DateTimeUtils.dayAfter((Date)HRUtilExtend.getEffectDate((HRBillBaseEntryInfo)resignEntryInfo), (Date)bizInfo.getEntryBizDate())) continue;
                String message = SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"label30", (Context)ctx);
                Object[] params = new Object[]{personNumber, personName, DateTimeUtils.format((Date)bizDate, (String)"yyyy-MM-dd"), billName};
                message = MessageFormat.format(message, params);
                return message;
            }
        }
        return null;
    }

    public static Date getEffectDate(HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        if (null != entry.getDate("leftCompanyDate") && null != entry.getDate("bizDate") && DateTimeUtils.dayEquals((Date)entry.getDate("bizDate"), (Date)entry.getDate("leftCompanyDate")) && !entry.getBoolean("isSameDatePersonChange")) {
            return DateTimeUtils.truncateDate((Date)HRUtil.getAftereDate(entry.getDate("bizDate")));
        }
        Date effectDate = entry.getDate("bizDate");
        if (effectDate != null) {
            effectDate = DateTimeUtils.truncateDate((Date)effectDate);
        }
        return effectDate;
    }

    public static String checkResignExist(Context ctx, String personId, String billId, HRAffairBizBillEntryInfo hrAffairEntryInfo) throws BOSException, EASBizException {
        String msg = null;
        if (personId == null) {
            return msg;
        }
        String currDate = HRUtilExtend.getCurrentDate();
        StringBuffer oql = new StringBuffer("select person.id,person.name,person.number,billBOSType,billID,entryBizDate ");
        oql.append("where person.id = '");
        oql.append(personId);
        oql.append("' ");
        if (!StringUtils.isEmpty((String)billId)) {
            oql.append(" and billID <> '");
            oql.append(billId);
            oql.append("' ");
        }
        oql.append(" and (");
        oql.append(" billState = ");
        oql.append(0);
        oql.append(" or billState = ");
        oql.append(1);
        oql.append(" or billState = ");
        oql.append(2);
        oql.append(" or (billState = ");
        oql.append(3);
        oql.append(" and entryBizDate > ");
        oql.append(currDate);
        oql.append(" ))");
        HRAffairBizCollection col = HRAffairBizFactory.getLocalInstance((Context)ctx).getHRAffairBizCollection(oql.toString());
        if (col != null && col.size() > 0) {
            BatchProcessedResult result = new BatchProcessedResult();
            String personNumber = null;
            String personName = null;
            String billName = null;
            HRAffairBizInfo bizInfo = null;
            String bosType = null;
            String exsitBillId = null;
            Date bizDate = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                PersonInfo person;
                bizInfo = col.get(i);
                personNumber = bizInfo.getPerson().getNumber();
                personName = bizInfo.getPerson().getName();
                bosType = bizInfo.getBillBOSType();
                billName = loader.getEntity(BOSObjectType.create((String)bosType)).getAlias();
                exsitBillId = bizInfo.getBillID().toString();
                bizDate = bizInfo.getEntryBizDate();
                String entityName = loader.getEntity(BOSObjectType.create((String)bosType)).getFullName();
                IHRAffairBizBill IHRAffairBizBill2 = (IHRAffairBizBill)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
                HRAffairBizBillInfo billInfo = IHRAffairBizBill2.getHRAffairBizBillInfo((IObjectPK)new ObjectUuidPK(exsitBillId));
                if (!"CC58A617".equals(bosType) || (person = hrAffairEntryInfo.getPerson()) == null || person.getId() == null || !person.getId().toString().equals(bizInfo.getPerson().getId().toString()) || !DateTimeUtils.dayBefore((Date)HRUtilExtend.getEffectDate((HRBillBaseEntryInfo)hrAffairEntryInfo), (Date)bizInfo.getEntryBizDate())) continue;
                String message = SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"label31", (Context)ctx);
                Object[] params = new Object[4];
                params[0] = personNumber;
                params[1] = personName;
                message = MessageFormat.format(message, params);
                return message;
            }
        }
        return null;
    }

    public static String getIdsSql(String ids) {
        String[] idarrs = ids.split(",");
        StringBuffer idsSql = new StringBuffer();
        boolean isfirst = true;
        idsSql.append("(");
        for (int i = 0; i < idarrs.length; ++i) {
            if (StringUtils.isEmpty((String)idarrs[i])) continue;
            if (!isfirst) {
                idsSql.append(",");
            }
            isfirst = false;
            idsSql.append("'");
            idsSql.append(idarrs[i]);
            idsSql.append("'");
        }
        idsSql.append(")");
        return idsSql.toString();
    }

    public static void addNotCheckBosType(Context ctx, StringBuffer oql) throws EASBizException, BOSException {
        boolean flag = HRParamUtil.getParamOfHR(ctx, "IS_PLURALITY_CHECKOTHERBILL", null);
        if (!flag) {
            oql.append(" and billBOSType <> 'B3F8AB50' ");
        }
        oql.append(" and billBOSType <> '6422D4A6' ");
    }

    public static void checkMobileDuplicateInPreEntry(Context ctx, String telNum, String preEntryID) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)telNum)) {
            String errorMessage = "";
            String idFilter = "";
            if (!StringUtils.isEmpty((String)preEntryID)) {
                idFilter = " and id <> '" + preEntryID + "'";
            }
            StringBuilder oql = new StringBuilder("where (cellPhone = '").append(telNum).append("') and ").append(" ((isSSC=0 and (isGenerateEntryBill<>1 or billState<>").append(3).append(") and billState<>").append(4).append(" and checkInState not in ('1','2')) or (isSSC=1 and isLatest=1))").append(idFilter);
            PreEntryCollection preEntrycoll = PreEntryFactory.getLocalInstance((Context)ctx).getPreEntryCollection(oql.toString());
            if (preEntrycoll.size() > 0) {
                errorMessage = !StringUtils.isEmpty((String)preEntrycoll.get(0).getNumber()) ? (preEntrycoll.get(0).isIsSSC() ? MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.HrEmpBizResource", (String)"tel_repeat_reg", (Context)ctx), preEntrycoll.get(0).getNumber()) : MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.HrEmpBizResource", (String)"tel_repeat_bill", (Context)ctx), preEntrycoll.get(0).getNumber())) : MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.HrEmpBizResource", (String)"tel_repeat_person", (Context)ctx), preEntrycoll.get(0).getName());
            }
            if (!StringUtils.isEmpty((String)errorMessage)) {
                throw new HRBaseException(HRBaseException.PERSONPLANISOVER, new Object[]{errorMessage});
            }
        }
    }
}

