/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.alibaba.fastjson.JSON;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.shr.base.syssetting.MSFConfigFactory;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HrJobUtil {
    private static final Logger logger = LoggerFactory.getLogger(HrJobUtil.class);

    public static void checkJobInfo(Context ctx, String billId) throws EASBizException {
        HrJobUtil.checkSSCJobInfo(ctx, billId);
        HrJobUtil.checkCoActivityJobInfo(ctx, billId);
    }

    public static void checkSSCJobInfo(Context ctx, String billId) throws EASBizException {
        String osfName = "getJobInfoByBillIdService";
        StringBuffer oql = new StringBuffer();
        oql.append("where serviceName = '");
        oql.append(osfName);
        oql.append("' and state = '");
        oql.append("1'");
        try {
            JsonArray dataArray;
            CoreBaseCollection resultCol = MSFConfigFactory.getLocalInstance((Context)ctx).getCollection(oql.toString());
            if (resultCol.size() < 1) {
                logger.error("com.kingdee.eas.hr.base.util.HrJobUtil.checkSSCJobInfo osf is not exist!");
                return;
            }
            HashMap<String, String> serviceParam = new HashMap<String, String>();
            serviceParam.put("billId", billId);
            serviceParam.put("type", "1");
            serviceParam.put("selector", null);
            JsonObject result = (JsonObject)MSFServiceFacadeFactory.getLocalInstance((Context)ctx).processService(osfName, serviceParam);
            if (result.get("dataType") != null && "JsonArray".equals(result.get("dataType").getAsString()) && (dataArray = result.get("data").getAsJsonArray()).size() > 0) {
                throw new HRCommonException(HRCommonException.DEALING_JOB);
            }
            return;
        }
        catch (BOSException e) {
            logger.error("com.kingdee.shr.affair.web.util.CheckBizBillUtil.checkJobInfo error1!!", (Throwable)e);
            return;
        }
    }

    public static void checkCoActivityJobInfo(Context ctx, String billId) throws EASBizException {
        String osfName = "getCoActivityJobByBillService";
        StringBuffer oql = new StringBuffer();
        oql.append("where serviceName = '");
        oql.append(osfName);
        oql.append("' and state = '");
        oql.append("1'");
        try {
            CoreBaseCollection resultCol = MSFConfigFactory.getLocalInstance((Context)ctx).getCollection(oql.toString());
            logger.debug(" ===== checkCoActivityJobInfo resultCol.size : " + resultCol.size());
            if (resultCol.size() < 1) {
                logger.error("com.kingdee.eas.hr.base.util.HrJobUtil.checkCoActivityJobInfo osf is not exist!");
                return;
            }
            HashMap<String, String> serviceParam = new HashMap<String, String>();
            serviceParam.put("billId", billId);
            serviceParam.put("type", "3");
            List result = (List)MSFServiceFacadeFactory.getLocalInstance((Context)ctx).processService(osfName, serviceParam);
            logger.debug(" ===== checkCoActivityJobInfo result : " + JSON.toJSONString((Object)result));
            if (null != result && result.size() > 0) {
                for (int i = 0; i < result.size(); ++i) {
                    if (null == ((Map)result.get(i)).get("jobPoolingType") || !"2".equals(((Map)result.get(i)).get("jobPoolingType").toString()) && !"1".equals(((Map)result.get(i)).get("jobPoolingType").toString())) continue;
                    throw new HRCommonException(HRCommonException.DEALING_JOB);
                }
            }
            return;
        }
        catch (BOSException e) {
            logger.error("com.kingdee.shr.affair.web.util.CheckBizBillUtil.checkJobInfo error1!!", (Throwable)e);
            return;
        }
    }

    public static boolean checkHRBillCanEdit(Context ctx, String billId) throws BOSException, EASBizException {
        try {
            Class<?> tClass = Class.forName("com.kingdee.shr.shareservice.ActivityProcessExecuteFacadeFactory");
            Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
            Object object = tMethod.invoke(null, ctx);
            Method tMethodService = object.getClass().getMethod("checkCanEdit", String.class);
            return (Boolean)tMethodService.invoke(object, billId);
        }
        catch (ClassNotFoundException e) {
            logger.error("com.kingdee.eas.hr.base.util.HrJobUtil.checkHRBillCanEdit \u5904\u7406\u5f02\u5e38, ClassNotFoundException!" + e.getMessage() + "\n billId:" + billId, (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error("com.kingdee.eas.hr.base.util.HrJobUtil.checkHRBillCanEdit \u5904\u7406\u5f02\u5e38, NoSuchMethodException!" + e.getMessage() + "\n billId:" + billId, (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SecurityException e) {
            logger.error("com.kingdee.eas.hr.base.util.HrJobUtil.checkHRBillCanEdit \u5904\u7406\u5f02\u5e38, SecurityException!" + e.getMessage() + "\n billId:" + billId, (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error("com.kingdee.eas.hr.base.util.HrJobUtil.checkHRBillCanEdit \u5904\u7406\u5f02\u5e38, IllegalAccessException!" + e.getMessage() + "\n billId:" + billId, (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error("com.kingdee.eas.hr.base.util.HrJobUtil.checkHRBillCanEdit \u5904\u7406\u5f02\u5e38, IllegalArgumentException!" + e.getMessage() + "\n billId:" + billId, (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error("com.kingdee.eas.hr.base.util.HrJobUtil.checkHRBillCanEdit \u5904\u7406\u5f02\u5e38, InvocationTargetException!" + e.getMessage() + "\n billId:" + billId, (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }
}

