/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IOrgRangeIncludeSubOrg;
import com.kingdee.eas.base.permission.IOrgRangeSolution;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.IUserRoleOrgManager;
import com.kingdee.eas.base.permission.OrgRangeHelper;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgCollection;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgFactory;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeParam;
import com.kingdee.eas.base.permission.OrgRangeSolutionFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserRoleOrgCollection;
import com.kingdee.eas.base.permission.UserRoleOrgInfo;
import com.kingdee.eas.base.permission.UserRoleOrgManagerFactory;
import com.kingdee.eas.base.uiframe.MenuCacheFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.util.StringCollUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;

public class HrUserPermTranserHelper {
    private static final String rangeBosType = new OrgRangeInfo().getBOSType().toString();
    public static final String ROLE_MANAGER_NUMBER = "0000";
    public static final String ROLE_EMPLOYEE_NUMBER = "0006";

    public static void clearOrgAndPermOfUser(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        HrUserPermTranserHelper.deleteAllTypeOrgRange(ctx, userInfo);
        HrUserPermTranserHelper.deleteUserPermByUser(ctx, userInfo);
        HrUserPermTranserHelper.deleteUserRolePermByUser(ctx, userInfo);
        MenuCacheFactory.getLocalInstance((Context)ctx).updateMenuCacheByUserID(userInfo.getId().toString());
    }

    public static void setDefaultOrgPermByUser(Context ctx, UserInfo userInfo) throws BOSException {
    }

    public static void setBizOrgOfUser(Context ctx, AdminOrgUnitInfo adminOrg, UserInfo userInfo) throws BOSException, EASBizException {
        HROrgUnitInfo hro = HRUtilExtend.getAdminOrgOfHRO(ctx, adminOrg);
        if (hro != null) {
            IUser iUser = UserFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("defOrgUnit"));
            selector.add(new SelectorItemInfo("CU"));
            FullOrgUnitInfo fullOrg = new FullOrgUnitInfo();
            fullOrg.setId(hro.getId());
            userInfo.setDefOrgUnit(fullOrg);
            userInfo.setCU(hro.getCU());
            iUser.updatePartial((CoreBaseInfo)userInfo, selector);
        }
    }

    public static void addDefaultRole(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        String orgId = userInfo.getDefOrgUnit().getId().toString();
        RoleInfo roleInfo = new RoleInfo();
        String sql = "select id where number = '0006'";
        RoleCollection roleColl = RoleFactory.getLocalInstance((Context)ctx).getRoleCollection(sql);
        if (roleColl != null && roleColl.size() > 0) {
            roleInfo = roleColl.get(0);
            IUserRoleOrgManager iUserRoleOrgManager = UserRoleOrgManagerFactory.getLocalInstance((Context)ctx);
            UserRoleOrgInfo userRoleOrgInfo = new UserRoleOrgInfo();
            FullOrgUnitInfo fullOrgInfo = new FullOrgUnitInfo();
            fullOrgInfo.setId(BOSUuid.read((String)orgId));
            userRoleOrgInfo.setUser(userInfo);
            userRoleOrgInfo.setRole(roleInfo);
            userRoleOrgInfo.setOrg(fullOrgInfo);
            UserRoleOrgCollection userRoleOrgs = new UserRoleOrgCollection();
            userRoleOrgs.add(userRoleOrgInfo);
        }
    }

    public static void addOrgRangeOfNewUser(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        if (userInfo.getCU() == null) {
            return;
        }
        String orgId = userInfo.getCU().getId().toString();
        ArrayList<String> orgIdCol = new ArrayList<String>();
        orgIdCol.add(orgId);
        IOrgRangeIncludeSubOrg iOrgRange = OrgRangeIncludeSubOrgFactory.getLocalInstance((Context)ctx);
        OrgRangeParam orgRangeParam = new OrgRangeParam((IObjectPK)userPK, OrgRangeType.BIZ_ORG_TYPE, null, orgIdCol, null);
        iOrgRange.saveOrgRange(orgRangeParam);
        if (userInfo.isBizAdmin()) {
            OrgRangeParam manageOrgRangeParam = new OrgRangeParam((IObjectPK)userPK, OrgRangeType.MANAGE_ORG_TYPE, null, orgIdCol, null);
            iOrgRange.saveOrgRange(manageOrgRangeParam);
        }
        if (userInfo.getPerson() != null) {
            HrUserPermTranserHelper.addAdminOrgRangeForPerson(ctx, userInfo);
        }
    }

    public static void addAdminOrgRangeForPerson(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        IOrgRangeIncludeSubOrg iOrgRange = OrgRangeIncludeSubOrgFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitCollection orgCol = OrgRangeHelper.getAllAdminOrgUnit((Context)ctx, (BOSUuid)userInfo.getPerson().getId());
        ArrayList<String> adminOrgIds = new ArrayList<String>();
        for (int i = 0; i < orgCol.size(); ++i) {
            adminOrgIds.add(orgCol.get(i).getId().toString());
        }
        OrgRangeParam adminOrgRangeParam = new OrgRangeParam((IObjectPK)userPK, OrgRangeType.ADMIN_ORG_TYPE, null, adminOrgIds, null);
        iOrgRange.saveOrgRange(adminOrgRangeParam);
    }

    public static void correctOrgSolution(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        ArrayList<String> orgList = new ArrayList<String>();
        if (userInfo.getOrgRange() != null) {
            int size = userInfo.getOrgRange().size();
            for (int i = 0; i < size; ++i) {
                OrgRangeInfo orgRangeInfo = userInfo.getOrgRange().get(i);
                orgList.add(orgRangeInfo.getOrg().getId().toString());
            }
        }
        if (!orgList.isEmpty()) {
            IOrgRangeSolution iOrgRangeSolution = OrgRangeSolutionFactory.getLocalInstance((Context)ctx);
            ArrayList<String> userIdStrList = new ArrayList<String>();
            userIdStrList.add(userInfo.getId().toString());
            iOrgRangeSolution.correctOrgRange(userIdStrList, orgList);
        }
    }

    public static void deleteAllTypeOrgRange(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        OrgRangeParam orgRangeParam = new OrgRangeParam((IObjectPK)userPK, OrgRangeType.ADMIN_ORG_TYPE, null, null, null, true);
        IOrgRangeIncludeSubOrg iOrgRange = OrgRangeIncludeSubOrgFactory.getLocalInstance((Context)ctx);
        iOrgRange.saveOrgRange(orgRangeParam);
        orgRangeParam = new OrgRangeParam((IObjectPK)userPK, OrgRangeType.BIZ_ORG_TYPE, null, null, null, true);
        iOrgRange.saveOrgRange(orgRangeParam);
        orgRangeParam = new OrgRangeParam((IObjectPK)userPK, OrgRangeType.MANAGE_ORG_TYPE, null, null, null, true);
        iOrgRange.saveOrgRange(orgRangeParam);
        orgRangeParam = new OrgRangeParam((IObjectPK)userPK, OrgRangeType.UNION_ORG_TYPE, null, null, null, true);
        iOrgRange.saveOrgRange(orgRangeParam);
    }

    public static void addBizOrg(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        String userId = userInfo.getId().toString();
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        ArrayList<String> coll = new ArrayList<String>();
        String orgId = userInfo.getDefOrgUnit().getId().toString();
        coll.add(orgId);
        IOrgRangeIncludeSubOrg iOrgRange = OrgRangeIncludeSubOrgFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        EntityViewInfo view = new EntityViewInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("org", (Object)orgId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)OrgRangeType.BIZ_ORG_TYPE, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("user", (Object)userId, CompareType.EQUALS));
        view.setFilter(filterInfo);
        OrgRangeIncludeSubOrgCollection collection = iOrgRange.getOrgRangeIncludeSubOrgCollection(view);
        if (collection.size() < 1) {
            OrgRangeParam orgRangeParam = new OrgRangeParam((IObjectPK)userPK, OrgRangeType.BIZ_ORG_TYPE, null, coll, null, false);
            iOrgRange.saveOrgRange(orgRangeParam);
        }
    }

    public static void deleteUserOrgRangeByUser(Context ctx, UserInfo userInfo, OrgRangeType type) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_PM_OrgRange where FUserID = '").append(userInfo.getId()).append("' and FType=").append(type.getValue());
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public static void deleteUserSubOrgRangeByUser(Context ctx, UserInfo userInfo, OrgRangeType type) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from t_pm_orgrangeincludesuborg where fuserid='").append(userInfo.getId()).append("' and FType = ").append(type.getValue());
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public static void deleteUserPermByUser(Context ctx, UserInfo userInfo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_PM_UserOrgPerm where FOwner='").append(userInfo.getId()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public static void deleteUserRolePermByUser(Context ctx, UserInfo userInfo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_PM_UserRoleOrg where FUserID='").append(userInfo.getId()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public static void sysManagerRole(Context ctx, Set<String> positionIdSet) throws BOSException {
        String positionIdStr = StringCollUtil.convertSetToString(positionIdSet);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String currentDateStr = format.format(new Date());
        RoleInfo roleInfo = new RoleInfo();
        roleInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-00000000000013B6732A"));
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct range.fuserid ,range.forgid ").append("from T_HR_EmpOrgRelation e").append(" inner join t_org_position p1 on p1.fid = e.fpositionid ").append(" inner join t_pm_user u on u.fpersonid = e.fpersonid ").append(" inner join t_pm_orgrange range on range.fuserid = u.fid ").append(" where e.FEFFDT<=to_date('").append(currentDateStr).append("')").append(" and e.FLEFFDT>to_date('").append(currentDateStr).append("')").append(" and p1.fid in ").append(positionIdStr).append(" and p1.fisrespposition = 1").append(" and range.ftype=10 ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HrUserPermTranserHelper.addUserRole(ctx, rs, roleInfo);
        StringBuffer personInSql = new StringBuffer();
        personInSql.append("select e.fpersonid from T_HR_EmpOrgRelation e").append(" inner join t_org_position p on p.fid = e.fpositionid ").append(" where e.FEFFDT<=to_date('").append(currentDateStr).append("')").append(" and e.FLEFFDT>to_date('").append(currentDateStr).append("')").append(" and p.fid in ").append(positionIdStr);
        StringBuffer personNotInSql = new StringBuffer();
        personNotInSql.append("select e.fpersonid from T_HR_EmpOrgRelation e").append(" inner join t_org_position p on p.fid = e.fpositionid ").append(" where e.FEFFDT<=to_date('").append(currentDateStr).append("')").append(" and e.FLEFFDT>to_date('").append(currentDateStr).append("')").append(" and p.fisrespposition = 1 ");
        sql = new StringBuffer();
        sql.append("select r.fuserid ,r.forgid ").append("from t_pm_user u").append(" inner join t_pm_orgrange r on r.fuserid = u.fid ").append(" inner join t_pm_userroleorg uro on uro.fuserid = u.fid").append(" where r.ftype=10 ").append(" and u.fpersonid in (").append(personInSql).append(")").append(" and u.fpersonid not in (").append(personNotInSql).append(")").append(" and uro.froleid ='").append(roleInfo.getId()).append("'");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HrUserPermTranserHelper.removeUserRole(ctx, rs, roleInfo);
    }

    public static void sysLeaderRole(Context ctx, Set<String> personIdSet) throws BOSException {
        String personIdStr = StringCollUtil.convertSetToString(personIdSet);
        RoleInfo roleInfo = new RoleInfo();
        roleInfo.setId(BOSUuid.read((String)"vqoC6sk6Svmijjatmt+tSBO2cyo="));
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct range.fuserid ,range.forgid ").append("from t_hr_personposition p").append(" inner join t_pm_user u on u.fpersonid = p.fpersonid ").append(" inner join t_pm_orgrange range on range.fuserid = u.fid ").append(" where p.fpersonid in ").append(personIdStr).append(" and p.fisleader=1 ").append(" and range.ftype=10 ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HrUserPermTranserHelper.addUserRole(ctx, rs, roleInfo);
        sql = new StringBuffer();
        sql.append("select r.fuserid ,r.forgid ").append("from t_pm_user u").append(" inner join t_hr_personposition p on u.fpersonid = p.fpersonid ").append(" inner join t_pm_orgrange r on r.fuserid = u.fid ").append(" inner join t_pm_userroleorg uro on uro.fuserid = u.fid").append(" where r.ftype=10 ").append(" and u.fpersonid in ").append(personIdStr).append(" and p.fisleader=0").append(" and uro.froleid ='vqoC6sk6Svmijjatmt+tSBO2cyo='");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HrUserPermTranserHelper.removeUserRole(ctx, rs, roleInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addUserRole(Context ctx, IRowSet rs, RoleInfo roleInfo) throws BOSException {
        IUserRoleOrgManager iUserRoleOrgManager = UserRoleOrgManagerFactory.getLocalInstance((Context)ctx);
        UserRoleOrgCollection userRoleOrgs = new UserRoleOrgCollection();
        UserRoleOrgInfo userRoleOrgInfo = null;
        FullOrgUnitInfo fullOrgInfo = null;
        UserInfo userInfo = null;
        try {
            while (rs.next()) {
                userRoleOrgInfo = new UserRoleOrgInfo();
                fullOrgInfo = new FullOrgUnitInfo();
                fullOrgInfo.setId(BOSUuid.read((String)rs.getString("forgid")));
                userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)rs.getString("fuserid")));
                userRoleOrgInfo.setRole(roleInfo);
                userRoleOrgInfo.setOrg(fullOrgInfo);
                userRoleOrgInfo.setUser(userInfo);
                userRoleOrgs.add(userRoleOrgInfo);
            }
            if (userRoleOrgs.size() <= 0) return;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void removeUserRole(Context ctx, IRowSet rs, RoleInfo roleInfo) throws BOSException {
        UserRoleOrgCollection delUserRoleOrgs = new UserRoleOrgCollection();
        IUserRoleOrgManager iUserRoleOrgManager = UserRoleOrgManagerFactory.getLocalInstance((Context)ctx);
        UserRoleOrgInfo userRoleOrgInfo = null;
        FullOrgUnitInfo fullOrgInfo = null;
        UserInfo userInfo = null;
        try {
            while (rs.next()) {
                userRoleOrgInfo = new UserRoleOrgInfo();
                fullOrgInfo = new FullOrgUnitInfo();
                fullOrgInfo.setId(BOSUuid.read((String)rs.getString("forgid")));
                userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)rs.getString("fuserid")));
                userRoleOrgInfo.setRole(roleInfo);
                userRoleOrgInfo.setOrg(fullOrgInfo);
                userRoleOrgInfo.setUser(userInfo);
                delUserRoleOrgs.add(userRoleOrgInfo);
            }
            if (delUserRoleOrgs.size() <= 0) return;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void synUserDefOrgUnit(Context ctx, String personId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("adminOrg.id"));
        EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
        EmpPosOrgRelationInfo empOrgInfo = helper.getAppointDateActiveMainlinePerson(ctx, personId, new Date(), sic);
        HrUserPermTranserHelper.synUserDefOrgUnit(ctx, empOrgInfo.getPerson().getId().toString(), null, empOrgInfo.getAdminOrg().getId().toString());
    }

    public static void synUserDefOrgUnit(Context ctx, String personId, String oldAdminId, String newAdminId) throws BOSException, EASBizException {
        if (newAdminId == null) {
            return;
        }
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        UserCollection userC = iUser.getUserCollection("where person.id='" + personId + "' and isDelete=0 and isForbidden=0");
        if (userC.size() <= 0) {
            return;
        }
        UserInfo userInfo = userC.get(0);
        HROrgUnitInfo oldHR = HrUserPermTranserHelper.getHROrgByAdminID(ctx, oldAdminId);
        String oldHROrgId = null;
        oldHROrgId = oldHR == null ? (userInfo.getDefOrgUnit() != null ? userInfo.getDefOrgUnit().getId().toString() : "00000000-0000-0000-0000-000000000000CCE7AED4") : oldHR.getId().toString();
        HROrgUnitInfo newHR = HrUserPermTranserHelper.getHROrgByAdminID(ctx, newAdminId);
        if (newHR == null) {
            return;
        }
        String newHROrgId = newHR.getId().toString();
        if (newHROrgId.equals(oldHROrgId)) {
            return;
        }
        FullOrgUnitInfo defOrgInfo = new FullOrgUnitInfo();
        defOrgInfo.setId(newHR.getId());
        userInfo.setCU(newHR.getCU());
        userInfo.setDefOrgUnit(defOrgInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("defOrgUnit"));
        selector.add(new SelectorItemInfo("CU"));
        iUser.updatePartial((CoreBaseInfo)userInfo, selector);
        HrUserPermTranserHelper.deleteUserOrgRangeByUser(ctx, userInfo, OrgRangeType.BIZ_ORG_TYPE);
        HrUserPermTranserHelper.addBizOrg(ctx, userInfo);
    }

    private static HROrgUnitInfo getHROrgByAdminID(Context ctx, String adminOrgId) throws BOSException {
        if (adminOrgId == null) {
            return null;
        }
        AdminOrgUnitInfo adminOrg = new AdminOrgUnitInfo();
        adminOrg.setId(BOSUuid.read((String)adminOrgId));
        return HRUtilExtend.getAdminOrgOfHRO(ctx, adminOrg);
    }
}

