/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.ep.CoreBillBaseCustomInfo;
import com.kingdee.eas.ep.DataBaseCustomInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.BaseItemCustomInfo;
import com.kingdee.shr.base.syssetting.app.util.MetaDataUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class SHRDataTypeUtils {
    private static Logger logger = Logger.getLogger(SHRDataTypeUtils.class);

    public static void convertRowSet2CoreBaseInfo(Context ctx, IRowSet rs, CoreBaseInfo info, SelectorItemCollection selectorColl) throws SQLException, BOSException {
        SHRDataTypeUtils.convertRowSet2CoreBaseInfo(ctx, rs, info, null, selectorColl);
    }

    public static void convertRowSet2CoreBaseInfo(Context ctx, IRowSet rs, CoreBaseInfo info, String entityName, SelectorItemCollection selectorColl) throws SQLException, BOSException {
        EntityObjectInfo entityObjectInfo = null;
        if (StringUtils.isEmpty((String)entityName)) {
            entityObjectInfo = MetaDataUtil.getEntityObjectInfo((Context)ctx, (BOSObjectType)info.getBOSType());
            entityName = entityObjectInfo.getRealFullName();
        } else {
            entityObjectInfo = MetaDataUtil.getEntityObjectByEntityName((Context)ctx, (String)entityName);
        }
        String propRSName = null;
        String propName = null;
        SelectorItemInfo selectorItem = null;
        block0: for (int i = 0; i < selectorColl.size(); ++i) {
            selectorItem = selectorColl.get(i);
            propRSName = selectorItem.getAliasName();
            propName = selectorColl.get(i).getPropertyName();
            if (StringUtils.isEmpty((String)propRSName)) {
                propRSName = propName;
            }
            if (StringUtils.isEmpty((String)propRSName)) continue;
            String tempEntityName = entityName;
            EntityObjectInfo tempEntityInfo = entityObjectInfo;
            CoreBaseInfo tempInfo = info;
            String[] names = propName.split("\\.");
            for (int j = 0; j < names.length; ++j) {
                if (j == names.length - 1) {
                    DataType dataType = null;
                    PropertyInfo propertyInfo = entityObjectInfo.getPropertyByName(names[j]);
                    if (propertyInfo instanceof OwnPropertyInfo) {
                        OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)propertyInfo;
                        dataType = ownPropertyInfo.getDataType();
                    }
                    if (DataType.BOOLEAN == dataType) {
                        boolean objToBoolean = TypeConversionUtils.objToBoolean((Object)rs.getObject(propRSName));
                        tempInfo.put(names[j], (Object)objToBoolean);
                        continue block0;
                    }
                    tempInfo.put(names[j], rs.getObject(propRSName));
                    continue block0;
                }
                PropertyInfo propertyInfo = tempEntityInfo.getPropertyByName(names[j]);
                tempEntityName = SHRDataTypeUtils.getEntityNameByPropertyInfo(tempEntityName, propertyInfo);
                tempEntityInfo = MetaDataUtil.getEntityObjectByEntityName((Context)ctx, (String)tempEntityName);
                if (tempInfo.get(names[j]) == null) {
                    CoreBaseInfo obj = SHRDataTypeUtils.createInfo(ctx, tempEntityName, tempEntityInfo);
                    tempInfo.put(names[j], (Object)obj);
                }
                tempInfo = (CoreBaseInfo)tempInfo.get(names[j]);
            }
        }
    }

    public static String getEntityNameByPropertyInfo(String entityName, PropertyInfo propertyInfo) {
        String subEntityName = null;
        if (propertyInfo instanceof LinkPropertyInfo && ((LinkPropertyInfo)propertyInfo).getRelationship() != null && ((LinkPropertyInfo)propertyInfo).getRelationship().getSupplierObject() != null) {
            subEntityName = ((LinkPropertyInfo)propertyInfo).getRelationship().getSupplierObject().getFullName();
            if (entityName.equals(subEntityName)) {
                subEntityName = ((LinkPropertyInfo)propertyInfo).getRelationship().getClientObject().getFullName();
            } else {
                logger.info((Object)("property " + propertyInfo.getName() + " cannot find relationship or relationship's supplierObject"));
            }
        }
        return subEntityName;
    }

    public static CoreBaseInfo createInfo(Context ctx, String entityFullName) throws BOSException {
        return SHRDataTypeUtils.createInfo(ctx, entityFullName);
    }

    public static CoreBaseInfo createInfo(Context ctx, EntityObjectInfo entityInfo) throws BOSException {
        return SHRDataTypeUtils.createInfo(ctx, entityInfo);
    }

    public static CoreBaseInfo createInfo(Context ctx, String entityFullName, EntityObjectInfo entityInfo) throws BOSException {
        if (entityFullName == null && entityInfo == null) {
            return null;
        }
        String entityName = entityFullName;
        if (entityName == null && entityInfo != null) {
            entityName = entityInfo.getRealFullName();
        }
        MetaDataPK metaDataPK = MetaDataPK.create((String)entityName);
        EntityObjectInfo eoInfo = entityInfo;
        if (eoInfo == null) {
            eoInfo = null == ctx ? MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)metaDataPK) : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)metaDataPK);
        }
        String valueClassName = eoInfo.getObjectValueClass();
        CoreBaseInfo info = null;
        try {
            Class<?> c = Class.forName(valueClassName);
            Constructor<?> cst = c.getConstructor(new Class[0]);
            info = (CoreBaseInfo)cst.newInstance(new Object[0]);
            if (info instanceof DataBaseCustomInfo) {
                ((DataBaseCustomInfo)info).setBOSType(eoInfo.getType());
            } else if (info instanceof BaseItemCustomInfo) {
                ((BaseItemCustomInfo)info).setBOSType(eoInfo.getType());
            } else if (info instanceof CoreBillBaseCustomInfo) {
                ((CoreBillBaseCustomInfo)info).setBOSType(eoInfo.getType());
            } else if (eoInfo.isDynamic() && info instanceof ICommonBOSType) {
                ICommonBOSType commonObject = (ICommonBOSType)info;
                commonObject.setBOSType(eoInfo.getType());
                commonObject.setPK((IMetaDataPK)metaDataPK);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return info;
    }
}

