/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.benefit.AccountCollection;
import com.kingdee.eas.hr.benefit.AccountFactory;
import com.kingdee.eas.hr.benefit.AccountTypeCollection;
import com.kingdee.eas.hr.benefit.AccountTypeFactory;
import com.kingdee.eas.hr.benefit.AccountTypeInfo;
import com.kingdee.eas.hr.benefit.BenefitException;
import com.kingdee.eas.hr.benefit.BenefitImportDataException;
import com.kingdee.eas.hr.benefit.EmpAccountManagerException;
import com.kingdee.eas.hr.benefit.EmpManagerFacadeFactory;
import com.kingdee.eas.hr.benefit.IAccount;
import com.kingdee.eas.hr.benefit.IAccountType;
import com.kingdee.eas.hr.benefit.IEmpManagerFacade;
import com.kingdee.eas.hr.benefit.client.AbstractAccountQueryListUI;
import com.kingdee.eas.hr.benefit.client.AccountAdjustQueryUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AccountQueryListUI
extends AbstractAccountQueryListUI {
    private static final long serialVersionUID = 1L;
    private CmpPeriodInfo curPeriod = null;
    private boolean isFirst = false;
    private boolean isFirst1 = false;
    private boolean isShowErr = true;
    private String hrOrgID = null;
    private CmpPeriodInfo beginPeriod;
    private CmpPeriodInfo endPeriod;
    private String accountId;
    private ArrayList periodList;
    private HashMap accItemInputIdRowMap;
    private int initColSize;
    private static final String ACCOUNT_ITEM_INPUT_ID = "accountItemInput.id";
    private Color comColor = Color.ORANGE;

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddNew.setEnabled(false);
        this.btnAddNew.setVisible(false);
        this.btnView.setEnabled(false);
        this.btnView.setVisible(false);
        this.btnQuery.setEnabled(false);
        this.btnQuery.setVisible(false);
        this.btnEdit.setEnabled(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setEnabled(false);
        this.btnRemove.setVisible(false);
        this.btnRefresh.setEnabled(false);
        this.btnRefresh.setVisible(false);
        this.btnLocate.setEnabled(false);
        this.btnLocate.setVisible(false);
        this.menuView.setVisible(false);
        this.menuItemAddNew.setVisible(false);
    }

    public void onLoad() throws Exception {
        if (SysContext.getSysContext().getCurrentHRUnit() == null) {
            throw new BenefitImportDataException(BenefitImportDataException.HRORG_NULL);
        }
        this.hrOrgID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        if (!BenefitUtils.hasInitPeriod()) {
            throw new BenefitException(BenefitException.NO_BENEFIT_PERIOD);
        }
        IEmpManagerFacade iemf = EmpManagerFacadeFactory.getRemoteInstance();
        if (!iemf.hasUpdatePeriodData()) {
            throw new EmpAccountManagerException(EmpAccountManagerException.NOTUPDATE);
        }
        this.isFirst = true;
        this.isFirst1 = true;
        this.accountId = this.getAccountId();
        super.onLoad();
        this.loadComboAccountType();
        if (this.comboAccountType.getSelectedItem() != null) {
            String atID = ((AccountTypeInfo)this.comboAccountType.getSelectedItem()).getId().toString();
            this.curPeriod = BenefitUtils.getCurPeriodByAccountAndAccType(null, this.accountId, atID);
        }
        this.setUIParam();
        this.initF7(this.prmpFrom);
        this.initF7(this.prmpTo);
        this.setTableState();
        this.tblMain.checkParsed(true);
        this.tblMain.getMergeManager().setMergeMode(3);
        if (this.accountId != null && this.beginPeriod != null && this.endPeriod != null) {
            this.loadTblItem(this.accountId);
        } else {
            this.tblMain.removeRows(false);
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.loadTblItem(this.accountId);
    }

    private void loadComboAccountType() throws BOSException {
        IAccountType iat = AccountTypeFactory.getRemoteInstance();
        AccountTypeCollection atInfos = null;
        atInfos = iat.getAccountTypeCollection("select where id in (select faccounttypeid from t_hr_accountdetail where faccountid = '" + this.accountId + "')");
        for (int i = 0; i < atInfos.size(); ++i) {
            this.comboAccountType.addItem((Object)atInfos.get(i));
        }
    }

    public String getCurrPerson() throws Exception {
        String person = null;
        if (SysContext.getSysContext().getCurrentUserInfo() != null) {
            if (SysContext.getSysContext().getCurrentUserInfo().getPerson() != null) {
                person = SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString();
            } else {
                throw new BenefitException(BenefitException.NOT_ACCOUNT);
            }
        }
        return person;
    }

    private void initF7(KDBizPromptBox box) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)this.curPeriod.getBeginDate(), CompareType.LESS));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        box.setHasCUDefaultFilter(false);
        box.setQueryInfo("com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery");
        box.setDisplayFormat("$name$");
        box.setEditFormat("$number$");
        box.setCommitFormat("$number$");
        box.setEntityViewInfo(evi);
        box.setEditable(true);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    private void setUIParam() throws Exception {
        this.accountId = this.getAccountId();
        CmpPeriodInfo cmpInfo = HRUtils.getCmpPeriodInfoByConstantClient(null, (CmpPeriodInfo)this.curPeriod, (int)-1);
        this.prmpTo.setValue((Object)cmpInfo);
        this.prmpFrom.setValue((Object)cmpInfo);
        this.endPeriod = cmpInfo;
        this.beginPeriod = cmpInfo;
    }

    private String getAccountId() throws Exception {
        String personID = this.getCurrPerson();
        IAccount iAccount = AccountFactory.getRemoteInstance();
        AccountCollection accColl = iAccount.getAccountCollection("select * where person.id ='" + personID + "' and hrOrgUnit.id = '" + this.hrOrgID + "'");
        if (accColl.size() <= 0) {
            if (this.isShowErr) {
                this.isShowErr = false;
                throw new BenefitException(BenefitException.NOT_ACCOUNT);
            }
            SysUtil.abort();
        }
        return accColl.get(0).getId().toString();
    }

    private void setAccItemInputIdRowMap() {
        int count = this.tblMain.getRowCount();
        this.accItemInputIdRowMap = new HashMap();
        IRow row = null;
        for (int i = 0; i < count; ++i) {
            row = this.tblMain.getRow(i);
            this.accItemInputIdRowMap.put(row.getCell(ACCOUNT_ITEM_INPUT_ID).getValue(), i);
        }
    }

    private void setPeriodListBy(CmpPeriodInfo beginPeriod, CmpPeriodInfo endPeriod) throws Exception {
        this.periodList = new ArrayList();
        if (beginPeriod != null && endPeriod != null) {
            if (!endPeriod.getId().toString().equals(beginPeriod.getId().toString())) {
                CmpPeriodInfo nextPeriod = beginPeriod;
                CmpPeriodInfo tmp = null;
                while (!nextPeriod.getId().toString().equals(endPeriod.getId().toString())) {
                    this.periodList.add(nextPeriod);
                    tmp = HRUtils.getNextCmpPeriodInfoClient((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)nextPeriod.getId().toString())));
                    if (tmp == null) break;
                    nextPeriod = tmp;
                }
            }
            this.periodList.add(endPeriod);
        }
    }

    private void initPeriodColumn() {
        IColumn col = null;
        CmpPeriodInfo info = null;
        int size = this.periodList.size();
        for (int i = 0; i < size; ++i) {
            info = (CmpPeriodInfo)this.periodList.get(i);
            col = this.tblMain.addColumn();
            col.getStyleAttributes().setNumberFormat("#,##0.00");
            col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            col.setKey(info.getId().toString());
            col.setUserObject((Object)info.getName());
        }
        int colCount = this.tblMain.getColumnCount();
        if (colCount > this.initColSize) {
            IRow row = this.tblMain.getHeadRow(0);
            for (int i = this.initColSize; i < colCount; ++i) {
                row.getCell(i).setValue(this.tblMain.getColumn(i).getUserObject());
            }
        }
    }

    private void loadDatas(IRowSet rows) throws Exception {
        boolean extCom = false;
        String cmpPeriodId = null;
        BigDecimal value = null;
        String accountItemInputId = null;
        IRow row = null;
        ICell cell = null;
        int index = -1;
        while (rows.next()) {
            extCom = rows.getBoolean("existsComplementary");
            value = rows.getBigDecimal("fvalue");
            accountItemInputId = rows.getString(ACCOUNT_ITEM_INPUT_ID);
            cmpPeriodId = rows.getString("cmpPeriod.id");
            if (this.accItemInputIdRowMap.get(accountItemInputId) == null) continue;
            index = (Integer)this.accItemInputIdRowMap.get(accountItemInputId);
            row = this.tblMain.getRow(index);
            cell = row.getCell(cmpPeriodId);
            cell.setValue((Object)value);
            if (!extCom) continue;
            cell.setUserObject((Object)Boolean.TRUE);
            cell.getStyleAttributes().setBackground(this.comColor);
        }
    }

    private IRowSet getDataRow(String accountId, String atID) throws Exception {
        IQueryExecutor iq = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.benefit.app.AccountDataQuery"));
        FilterInfo filter = new FilterInfo();
        CmpPeriodInfo info = null;
        int size = this.periodList.size();
        for (int i = 0; i < size; ++i) {
            info = (CmpPeriodInfo)this.periodList.get(i);
            filter.getFilterItems().add(new FilterItemInfo("cmpPeriod.id", (Object)info.getId().toString()));
        }
        int count = filter.getFilterItems().size();
        StringBuffer sb = null;
        if (count >= 2) {
            sb = new StringBuffer();
            for (int i = 0; i < count; ++i) {
                if (i == 0) {
                    sb.append("#");
                } else {
                    sb.append(" or #");
                }
                sb.append(i);
            }
            filter.setMaskString(sb.toString());
        } else {
            filter.setMaskString("#0");
        }
        filter.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountId));
        filter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)atID));
        int sum = filter.getFilterItems().size();
        sb = new StringBuffer();
        sb.append("#");
        sb.append(sum - 2);
        sb.append(" and #");
        sb.append(sum - 1);
        filter.setMaskString("(" + filter.getMaskString() + ") and " + sb.toString());
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        iq.setObjectView(evi);
        return iq.executeQuery();
    }

    private void setTableState() {
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(1);
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"id", "account.id", "benefitItem.number", "benefit.number", ACCOUNT_ITEM_INPUT_ID, "accountType.id", "benefitItem.id", "benefit.id", "accountType.number", "accountType.name", "accounts", "benefit.name", "benefitItem.name"};
    }

    private void loadTableData(String accountId, CmpPeriodInfo beginPeriod, CmpPeriodInfo endPeriod, String atID) throws Exception {
        this.tblMain.getMergeManager().setMergeMode(3);
        this.setPeriodListBy(beginPeriod, endPeriod);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountId));
        filter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)atID));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("benefitItem.isDisplay", (Object)1));
        filter.setMaskString("#0 and #1 and #2 and #3");
        this.mainQuery = new EntityViewInfo();
        this.mainQuery.setFilter(filter);
        this.tblMain.refresh();
        this.initColSize = this.tblMain.getColumnCount();
        this.setAccItemInputIdRowMap();
        this.initPeriodColumn();
        this.loadDatas(this.getDataRow(accountId, atID));
    }

    private void showDialog(String accountTypeName, String periodId, String accountItemInputId) throws Exception {
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"accountTypeName", (Object)accountTypeName);
        ctx.put((Object)"periodId", (Object)periodId);
        ctx.put((Object)"accountItemInputId", (Object)accountItemInputId);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AccountAdjustQueryUI.class.getName(), (Map)ctx, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int colIndex;
        int rowIndex;
        ICell cell;
        if (e.getClickCount() == 2 && e.getType() == 1 && (cell = this.tblMain.getCell(rowIndex = this.tblMain.getSelectManager().get().getTop(), colIndex = this.tblMain.getSelectManager().get().getLeft())).getUserObject() != null) {
            String accountTypeName = (String)this.tblMain.getRow(rowIndex).getCell("accountType.name").getValue();
            String periodId = this.tblMain.getColumnKey(colIndex);
            String accountItemInputId = (String)this.tblMain.getRow(rowIndex).getCell(ACCOUNT_ITEM_INPUT_ID).getValue();
            this.showDialog(accountTypeName, periodId, accountItemInputId);
        }
    }

    protected void prmpFrom_dataChanged(DataChangeEvent e) throws Exception {
        CmpPeriodInfo end = (CmpPeriodInfo)this.prmpTo.getValue();
        CmpPeriodInfo start = (CmpPeriodInfo)e.getNewValue();
        this.checkValidator(end, start);
        this.setPeriodListBy(start, end);
        this.initPeriodColumn();
        if (!this.isFirst) {
            this.loadTblItem(this.accountId);
        }
        this.isFirst = false;
    }

    private void checkValidator(CmpPeriodInfo end, CmpPeriodInfo start) throws BenefitException {
        if (end != null && start != null && DateTimeUtils.dayBefore((Date)end.getBeginDate(), (Date)start.getEndDate()) && !DateTimeUtils.dayEquals((Date)end.getBeginDate(), (Date)start.getBeginDate())) {
            throw new BenefitException(BenefitException.START_END_INVALID);
        }
    }

    protected void prmpTo_dataChanged(DataChangeEvent e) throws Exception {
        CmpPeriodInfo start = (CmpPeriodInfo)this.prmpFrom.getValue();
        CmpPeriodInfo end = (CmpPeriodInfo)e.getNewValue();
        this.checkValidator(end, start);
        this.setPeriodListBy(start, end);
        this.initPeriodColumn();
        if (!this.isFirst1) {
            this.loadTblItem(this.accountId);
        }
        this.isFirst1 = false;
    }

    protected void comboAccountType_itemStateChanged(ItemEvent e) throws Exception {
        String atID = ((AccountTypeInfo)this.comboAccountType.getSelectedItem()).getId().toString();
        this.accountId = this.getAccountId();
        this.curPeriod = BenefitUtils.getCurPeriodByAccountAndAccType(null, this.accountId, atID);
        CmpPeriodInfo cmpInfo = HRUtils.getCmpPeriodInfoByConstantClient(null, (CmpPeriodInfo)this.curPeriod, (int)-1);
        this.prmpTo.setValue(null);
        this.prmpFrom.setValue(null);
        this.endPeriod = cmpInfo;
        this.beginPeriod = cmpInfo;
        this.initF7(this.prmpFrom);
        this.initF7(this.prmpTo);
        if (!this.isFirst1) {
            this.loadTblItem(this.accountId);
        }
        this.isFirst1 = false;
        this.tblMain.removeRows(false);
        this.setPeriodListBy(this.beginPeriod, this.endPeriod);
        this.initPeriodColumn();
    }

    protected void loadTblItem(String accountID) throws Exception {
        this.setTableState();
        int count = this.tblMain.getColumnCount() - 13;
        for (int i = 0; i < count; ++i) {
            this.tblMain.removeColumn(this.tblMain.getColumnCount() - 1);
        }
        if (this.prmpFrom.getValue() != null && this.prmpTo.getValue() != null) {
            String atID = ((AccountTypeInfo)this.comboAccountType.getSelectedItem()).getId().toString();
            this.loadTableData(accountID, (CmpPeriodInfo)this.prmpFrom.getValue(), (CmpPeriodInfo)this.prmpTo.getValue(), atID);
        }
    }

    public boolean isPrepareInit() {
        return false;
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = (RequestContext)handler.getRequestContext();
        request.put("isShowErr", (Object)this.isShowErr);
        handler.setRequestContext((Serializable)request);
        return handler;
    }
}

