/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.benefit.AccountDetailFactory;
import com.kingdee.eas.hr.benefit.AccountItemInputFactory;
import com.kingdee.eas.hr.benefit.AccountTypeFactory;
import com.kingdee.eas.hr.benefit.AccountTypeInfo;
import com.kingdee.eas.hr.benefit.BenefitCollection;
import com.kingdee.eas.hr.benefit.BenefitException;
import com.kingdee.eas.hr.benefit.BenefitInfo;
import com.kingdee.eas.hr.benefit.BenefitPropEnum;
import com.kingdee.eas.hr.benefit.IAccountDetail;
import com.kingdee.eas.hr.benefit.IAccountItemInput;
import com.kingdee.eas.hr.benefit.IAccountType;
import com.kingdee.eas.hr.benefit.client.AbstractAccountTypeEditUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.DefaultListModel;

public class AccountTypeEditUI
extends AbstractAccountTypeEditUI {
    private static final long serialVersionUID = 1L;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initEdit();
        this.setRemoveButtonEnable();
    }

    private void setRemoveButtonEnable() throws BOSException, EASBizException {
        IAccountType iat = AccountTypeFactory.getRemoteInstance();
        boolean isInner = false;
        boolean hasUsed = false;
        if (this.editData != null && this.editData.getId() != null) {
            String ID = this.editData.getId().toString();
            hasUsed = iat.accountTypehasUsed(ID);
            if (10 == this.editData.getIsInner().getValue()) {
                isInner = true;
            }
            if (isInner || hasUsed) {
                this.actionRemove.setEnabled(false);
            } else {
                this.actionRemove.setEnabled(true);
            }
        }
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.setRemoveButtonEnable();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.setRemoveButtonEnable();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.setRemoveButtonEnable();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.setRemoveButtonEnable();
    }

    private void initKDList(String acTypeID) throws BOSException, EASBizException {
        int i;
        BenefitCollection coll = null;
        DefaultListModel<BenefitInfo> model = new DefaultListModel<BenefitInfo>();
        DefaultListModel<BenefitInfo> model1 = new DefaultListModel<BenefitInfo>();
        coll = BenefitUtils.getBenefitColl(acTypeID);
        int size = coll.size();
        for (i = 0; i < size; ++i) {
            model.addElement(coll.get(i));
        }
        coll = BenefitUtils.getNullBenefitColl();
        size = coll.size();
        for (i = 0; i < size; ++i) {
            model1.addElement(coll.get(i));
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.listAll.setModel(model1);
            this.setWidgetEnable();
        } else {
            this.listAll.setModel(model1);
            this.listChoose.setModel(model);
            this.setWidgetUnEnable();
            if (this.getOprtState().equals(OprtState.EDIT)) {
                this.setWidgetEnable();
            }
        }
    }

    private void setWidgetEnable() {
        this.listAll.setEnabled(true);
        this.listChoose.setEnabled(true);
        this.btnRight.setEnabled(true);
        this.btnLeft.setEnabled(true);
    }

    private void setWidgetUnEnable() {
        this.listAll.setEnabled(false);
        this.listChoose.setEnabled(false);
        this.btnRight.setEnabled(false);
        this.btnLeft.setEnabled(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.actionCancel.setVisible(false);
        this.actionCancel.setEnabled(false);
        this.actionCancelCancel.setVisible(false);
        this.actionCancelCancel.setEnabled(false);
        this.actionSave.setVisible(false);
        this.actionSave.setEnabled(false);
        this.actionCopy.setVisible(false);
        this.actionCopy.setEnabled(false);
    }

    public void loadFields() {
        super.loadFields();
        try {
            this.initEdit();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void initEdit() throws BOSException, EASBizException {
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.initKDList(null);
        } else {
            this.txtNumber.setEnabled(false);
            this.initKDList(this.editData.getId().toString());
        }
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void btnRight_actionPerformed(ActionEvent e) throws Exception {
        Object[] items = this.listAll.getSelectedValues();
        int[] rightIndics = this.listAll.getSelectedIndices();
        if (items == null || items.length == 0) {
            return;
        }
        int size = items.length;
        for (int i = 0; i < size; ++i) {
            this.listChoose.addElement(items[i]);
        }
        int[] indices = this.listAll.getSelectedIndices();
        for (int i = indices.length - 1; i >= 0; --i) {
            this.listAll.removeElementAt(indices[i]);
        }
        this.setSelectItem(this.listAll, rightIndics[0]);
    }

    private void setSelectItem(KDList list, int beginIndex) {
        if (list.getElementCount() > 0 && list.getElementCount() > beginIndex) {
            list.setSelectedIndex(beginIndex);
        } else if (list.getElementCount() > 0 && list.getElementCount() <= beginIndex) {
            list.setSelectedIndex(beginIndex - 1);
        }
    }

    private void checkUsed() throws BOSException, EASBizException {
        if (this.editData != null && this.editData.getId() != null) {
            String accTypeID = this.editData.getId().toString();
            IAccountDetail iad = AccountDetailFactory.getRemoteInstance();
            IAccountItemInput iFac = AccountItemInputFactory.getRemoteInstance();
            Object[] items = this.listChoose.getSelectedValues();
            HashSet<String> set = new HashSet<String>();
            if (items != null && items.length > 0) {
                for (int i = 0; i < items.length; ++i) {
                    set.add(((BenefitInfo)items[i]).getId().toString());
                }
            }
            if (iFac.exists("select id where item.benefit.id in " + BenefitUtils.getStrFromSet(set)) && iad.exists("select * where AccountType.id ='" + accTypeID + "'")) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitRuleResource.ACCTYPE_USED"));
                SysUtil.abort();
            }
        }
    }

    protected void btnLeft_actionPerformed(ActionEvent e) throws Exception {
        this.checkUsed();
        Object[] items = this.listChoose.getSelectedValues();
        int[] leftIndics = this.listChoose.getSelectedIndices();
        if (items == null || items.length == 0) {
            return;
        }
        int size = items.length;
        for (int i = 0; i < size; ++i) {
            this.listAll.addElement(items[i]);
        }
        int[] indices = this.listChoose.getSelectedIndices();
        for (int i = indices.length - 1; i >= 0; --i) {
            this.listChoose.removeElementAt(indices[i]);
        }
        this.setSelectItem(this.listChoose, leftIndics[0]);
    }

    protected void listAll_mouseClicked(MouseEvent e) throws Exception {
        super.listAll_mouseClicked(e);
        if (e.getClickCount() == 2) {
            Object[] items = this.listAll.getSelectedValues();
            int[] leftIndics = this.listAll.getSelectedIndices();
            if (items == null || items.length == 0) {
                return;
            }
            int size = items.length;
            for (int i = 0; i < size; ++i) {
                this.listChoose.addElement(items[i]);
            }
            int[] indices = this.listAll.getSelectedIndices();
            for (int i = indices.length - 1; i >= 0; --i) {
                this.listAll.removeElementAt(indices[i]);
            }
            this.setSelectItem(this.listAll, leftIndics[0]);
        }
    }

    protected void listChoose_mouseClicked(MouseEvent e) throws Exception {
        super.listChoose_mouseClicked(e);
        if (e.getClickCount() == 2) {
            this.checkUsed();
            Object[] items = this.listChoose.getSelectedValues();
            int[] rightIndics = this.listChoose.getSelectedIndices();
            if (items == null || items.length == 0) {
                return;
            }
            int size = items.length;
            for (int i = 0; i < size; ++i) {
                this.listAll.addElement(items[i]);
            }
            int[] indices = this.listChoose.getSelectedIndices();
            for (int i = indices.length - 1; i >= 0; --i) {
                this.listChoose.removeElementAt(indices[i]);
            }
            this.setSelectItem(this.listChoose, rightIndics[0]);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkInput();
        this.editData.put("ids", this.getChooseIds());
        this.editData.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        if (this.txtIsInner.getUserObject() != null) {
            if (((BenefitPropEnum)((Object)this.txtIsInner.getUserObject())).getValue() != 10) {
                this.editData.setIsInner(BenefitPropEnum.UNINNER);
            }
        } else {
            this.editData.setIsInner(BenefitPropEnum.UNINNER);
        }
        super.actionSubmit_actionPerformed(e);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.listChoose.removeAllElements();
        }
    }

    private void checkInput() throws BenefitException {
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            throw new BenefitException(BenefitException.AT_NUM_NOTNULL);
        }
        if (this.listChoose.getElementCount() <= 0) {
            throw new BenefitException(BenefitException.NO_BENEFIT);
        }
        LanguageInfo lang = new LanguageInfo(SysContext.getSysContext().getLocale());
        if (StringUtils.isEmpty((String)((String)this.txtName.getItemBy(lang).getData()))) {
            throw new BenefitException(BenefitException.AT_NAME_NOTNULL);
        }
    }

    private ArrayList getChooseIds() {
        ArrayList<String> list = new ArrayList<String>();
        BenefitInfo beInfo = null;
        int size = this.listChoose.getElementCount();
        for (int i = 0; i < size; ++i) {
            beInfo = (BenefitInfo)this.listChoose.getElement(i);
            list.add(beInfo.getId().toString());
        }
        return list;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.txtNumber.setEnabled(true);
        this.listChoose.removeAllElements();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.setWidgetEnable();
        super.actionEdit_actionPerformed(e);
        this.txtNumber.setEnabled(false);
        this.setRemoveButtonEnable();
    }

    protected String getEditUIName() {
        return AccountTypeEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AccountTypeFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        AccountTypeInfo objectValue = new AccountTypeInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }
}

