/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.benefit.AccountDetailFactory;
import com.kingdee.eas.hr.benefit.AccountTypeFactory;
import com.kingdee.eas.hr.benefit.AccountTypeInfo;
import com.kingdee.eas.hr.benefit.FluctuationPersonFactory;
import com.kingdee.eas.hr.benefit.IAccountDetail;
import com.kingdee.eas.hr.benefit.IFluctuationPerson;
import com.kingdee.eas.hr.benefit.PayTypeEnum;
import com.kingdee.eas.hr.benefit.client.AbstractHROFluctuationPersonListUI;
import com.kingdee.eas.hr.benefit.client.HROFluctuationPersonFilterUI;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.rec.util.DateUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class HROFluctuationPersonListUI
extends AbstractHROFluctuationPersonListUI {
    private boolean useNewBill = false;
    private boolean isFirstDefaultQuery = true;
    private CommonQueryDialog commonQueryDialog = null;
    private String periodID = null;
    private String accountTypeID = null;

    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnStop.setEnabled(true);
        this.btnSeal.setEnabled(true);
        this.btnStop.setIcon(EASResource.getIcon((String)"imgTbtn_stopturnin"));
        this.btnSeal.setIcon(EASResource.getIcon((String)"imgTbtn_sealup"));
    }

    public void onLoad() throws Exception {
        IFluctuationPerson ifp = FluctuationPersonFactory.getRemoteInstance();
        this.useNewBill = ifp.useNewBill();
        if (!this.useNewBill) {
            this.mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.benefit.app", "OldHROFluctuationPersonQuery");
        }
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.txtAccounType.setEnabled(false);
        this.txtPeriod.setEnabled(false);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int index = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(index);
        Object objValue = row.getCell("accountDetail.payState").getValue();
        String stateValue = objValue.toString();
        if (PayTypeEnum.NORMALPAY.getAlias().equals(stateValue)) {
            this.btnStop.setEnabled(true);
            this.btnSeal.setEnabled(true);
        }
        if (PayTypeEnum.STOPPAY.getAlias().equals(stateValue)) {
            this.btnStop.setEnabled(false);
            this.btnSeal.setEnabled(true);
        }
        if (PayTypeEnum.SEALPAY.getAlias().equals(stateValue)) {
            this.btnStop.setEnabled(false);
            this.btnSeal.setEnabled(false);
        }
    }

    public void actionStop_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int index = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (index != -1) {
            IAccountDetail iad = AccountDetailFactory.getRemoteInstance();
            IRow row = this.tblMain.getRow(index);
            String accDetailID = row.getCell("accountDetail.ID").getValue().toString();
            iad.makeStop(accDetailID);
            row.getCell("accountDetail.payState").setValue((Object)PayTypeEnum.STOPPAY.getAlias());
        }
    }

    public void actionSeal_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int index = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (index != -1) {
            IAccountDetail iad = AccountDetailFactory.getRemoteInstance();
            IRow row = this.tblMain.getRow(index);
            String accDetailID = row.getCell("accountDetail.ID").getValue().toString();
            iad.makeSeal(accDetailID);
            row.getCell("accountDetail.payState").setValue((Object)PayTypeEnum.SEALPAY.getAlias());
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.accountTypeID = null;
        this.periodID = null;
        this.loadFilterUI();
        if (!StringUtils.isEmpty((String)this.accountTypeID)) {
            AccountTypeInfo atInfo = AccountTypeFactory.getRemoteInstance().getAccountTypeInfo((IObjectPK)new ObjectStringPK(this.accountTypeID));
            this.txtAccounType.setText(atInfo.getName());
        }
        if (!StringUtils.isEmpty((String)this.periodID)) {
            CmpPeriodInfo cpInfo = CmpPeriodFactory.getRemoteInstance().getCmpPeriodInfo((IObjectPK)new ObjectStringPK(this.periodID));
            this.txtPeriod.setText(cpInfo.getNumber());
        }
    }

    protected void loadFilterUI() throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = HROFluctuationPersonListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            CustomerParams cp = null;
            if (solution.getQueryPanelInfo().get(0) != null) {
                cp = CustomerParams.getCustomerParams2((String)solution.getQueryPanelInfo().get(0).getCustomerParams());
            }
            if (solution.getQueryPanelInfo().get(1) != null && cp == null) {
                cp = CustomerParams.getCustomerParams2((String)solution.getQueryPanelInfo().get(1).getCustomerParams());
            }
            if (cp != null) {
                FilterInfo info;
                if (this.mainQuery == null) {
                    this.mainQuery = new EntityViewInfo();
                }
                if ((info = this.mainQuery.getFilter()) == null) {
                    info = new FilterInfo();
                }
                info.mergeFilter(this.getCustomFilter(cp), "and");
                FilterInfo infoTmp = null;
                if (solution.getQueryPanelInfo().get(0).getPanelClassName().equals("com.kingdee.eas.base.commonquery.client.CommonFilterPanel")) {
                    EntityViewInfo evi = new EntityViewInfo();
                    evi = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
                    infoTmp = evi.getFilter();
                } else if (solution.getQueryPanelInfo().get(1).getPanelClassName().equals("com.kingdee.eas.base.commonquery.client.CommonFilterPanel")) {
                    EntityViewInfo evi = new EntityViewInfo();
                    evi = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
                    infoTmp = evi.getFilter();
                }
                if (infoTmp != null) {
                    info.mergeFilter(infoTmp, "and");
                }
                this.mainQuery.setFilter(info);
                this.tblMain.removeRows();
                this.fillBenefitDataToTable();
            } else {
                this.showQueryDialog();
            }
            this.isFirstDefaultQuery = false;
        } else {
            this.showQueryDialog();
        }
    }

    private void showQueryDialog() throws Exception {
        HROFluctuationPersonFilterUI filterUI = new HROFluctuationPersonFilterUI();
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.commonQueryDialog.setWidth(400);
            this.commonQueryDialog.setHeight(350);
            this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
            this.commonQueryDialog.setShowFilter(true);
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setShowToolbar(true);
            this.commonQueryDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitResource.HR_FLUC_PERSON_FILTER_TITLE"));
            this.commonQueryDialog.addUserPanel((KDPanel)filterUI);
        }
        if (this.commonQueryDialog.show()) {
            CustomerParams cp = ((HROFluctuationPersonFilterUI)this.commonQueryDialog.getUserPanel(0)).getCustomerParams();
            this.mainQuery = this.commonQueryDialog.getEntityViewInfoResult();
            FilterInfo info = this.mainQuery.getFilter();
            if (info == null) {
                info = new FilterInfo();
            }
            info.mergeFilter(this.getCustomFilter(cp), "and");
            this.mainQuery.setFilter(info);
            this.tblMain.removeRows();
            this.fillBenefitDataToTable();
        } else {
            SysUtil.abort();
        }
    }

    private FilterInfo getCustomFilter(CustomerParams cp) {
        if (cp.getCustomerParam("Period") != null) {
            String period;
            this.periodID = period = cp.getCustomerParam("Period");
        }
        FilterInfo info = new FilterInfo();
        if (cp.getCustomerParam("AccountType") != null) {
            String accType;
            this.accountTypeID = accType = cp.getCustomerParam("AccountType");
            info.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)accType, CompareType.EQUALS));
        }
        info.getFilterItems().add(new FilterItemInfo("affairBD.effectDate", (Object)DateUtil.getCurrentDate(), CompareType.LESS_EQUALS));
        return info;
    }

    private void fillBenefitDataToTable() throws BOSException, EASBizException {
        int baseColumn;
        List personList = this.getPersonIDList();
        IFluctuationPerson ifp = FluctuationPersonFactory.getRemoteInstance();
        HashMap dataMap = ifp.getHRFlucPersonData(personList, this.periodID, this.accountTypeID);
        KDTMergeManager mm = this.tblMain.getHeadMergeManager();
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        int col = baseColumn = 7;
        for (int size = this.tblMain.getColumnCount(); col < size; --size) {
            this.tblMain.removeColumn(size - 1);
        }
        List benefitList = (List)dataMap.get("benefitList");
        List itemList = (List)dataMap.get("itemList");
        IColumn iCol = null;
        String benefitID = null;
        String benefitName = null;
        String itemNumber = null;
        String itemName = null;
        String[] beneTmp = null;
        String[] itemTmp = null;
        String key = null;
        int bSize = benefitList.size();
        int iSize = itemList.size();
        for (int i = 0; i < bSize; ++i) {
            if (StringUtils.isEmpty((String)((String)benefitList.get(i)))) continue;
            beneTmp = benefitList.get(i).toString().split("@");
            benefitID = beneTmp[0];
            benefitName = beneTmp[1];
            for (int j = 0; j < iSize; ++j) {
                if (StringUtils.isEmpty((String)((String)itemList.get(j)))) continue;
                itemTmp = itemList.get(j).toString().split("@");
                itemNumber = itemTmp[0];
                itemName = itemTmp[1];
                iCol = this.tblMain.addColumn();
                iCol.getStyleAttributes().setLocked(true);
                iCol.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                iCol.getStyleAttributes().setNumberFormat("0.00");
                key = benefitID + itemNumber;
                iCol.setKey(key);
                this.tblMain.getHeadRow(0).getCell(key).setValue((Object)benefitName);
                this.tblMain.getHeadRow(1).getCell(key).setValue((Object)itemName);
            }
            mm.mergeBlock(0, baseColumn + i * iSize, 0, baseColumn + (i + 1) * iSize - 1, 4);
        }
        String personID = null;
        IRow row = null;
        HashMap data = (HashMap)dataMap.get("data");
        HashMap perMap = null;
        HashMap valueMap = null;
        int tSize = this.tblMain.getRowCount3();
        for (int i = 0; i < tSize; ++i) {
            row = this.tblMain.getRow(i);
            personID = row.getCell("id").getValue().toString();
            if (!data.containsKey(personID)) continue;
            perMap = (HashMap)data.get(personID);
            for (int m = 0; m < bSize; ++m) {
                if (StringUtils.isEmpty((String)((String)benefitList.get(m)))) continue;
                beneTmp = benefitList.get(m).toString().split("@");
                benefitID = beneTmp[0];
                valueMap = (HashMap)perMap.get(benefitID);
                for (int n = 0; n < iSize; ++n) {
                    if (StringUtils.isEmpty((String)((String)itemList.get(n)))) continue;
                    itemTmp = itemList.get(n).toString().split("@");
                    itemNumber = itemTmp[0];
                    if (valueMap == null) continue;
                    row.getCell(benefitID + itemNumber).setValue((Object)((BigDecimal)valueMap.get(itemNumber)));
                }
            }
        }
    }

    private List getPersonIDList() {
        ArrayList<String> personList = new ArrayList<String>();
        IRow row = null;
        String perID = null;
        int size = this.tblMain.getRowCount3();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            perID = row.getCell("id").getValue().toString();
            personList.add(perID);
        }
        return personList;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (this.mainQuery != null) {
            int start = (Integer)e.getParam1();
            int length = (Integer)e.getParam2() - start + 1;
            try {
                IQueryExecutor exec = this.getQueryExecutor(this.mainQueryPK, this.mainQuery);
                exec.option().isAutoTranslateEnum = true;
                IRowSet rowSet = exec.executeQuery(start, length);
                e.setRowSet(rowSet);
                this.onGetRowSet(rowSet);
            }
            catch (Exception ee) {
                this.handUIException(ee);
            }
        }
    }
}

