/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.benefit.BenefitRuleFacadeFactory;
import com.kingdee.eas.hr.benefit.IBenefitRuleFacade;
import com.kingdee.eas.hr.benefit.client.AbstractPersonSchemeSettingUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class PersonSchemeSettingUI
extends AbstractPersonSchemeSettingUI {
    private static Logger logger = Logger.getLogger(PersonSchemeSettingUI.class);
    private static final long serialVersionUID = 1L;
    private String cmpSchemeF7URL = "com.kingdee.eas.hr.compensation.app.F7CmpSchemeQuery";
    public final String NUMBER = "number";
    public final String NAME = "name";
    public final String GENDER = "gender";
    public final String IDCARDNO = "idCardNO";
    public final String ADMIN = "admin.name";
    public final String POSITION = "position.name";
    public final String ID = "id";
    private List delPersonList = new ArrayList();
    private String benefitRuleID = null;

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.setButtonDefaultStyl(this.btnAddNew);
        this.setButtonDefaultStyl(this.btnDelete);
        this.setCmpSchemeEditor();
        this.benefitRuleID = (String)this.getUIContext().get("tmpBeneRuleID");
    }

    private void setCmpSchemeEditor() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isDelete", (Object)Boolean.FALSE));
        filterInfo.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filterInfo.setMaskString("#0 and #1 and #2");
        FilterInfo adminRangeFilter = HRSchemeUtils.getAdminRangeFilter(null, (String)"adminUser.id");
        if (adminRangeFilter != null) {
            try {
                filterInfo.mergeFilter(adminRangeFilter, "and");
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.bizComScheme.setQueryInfo(this.cmpSchemeF7URL);
        this.bizComScheme.setEditFormat("$name$");
        this.bizComScheme.setDisplayFormat("$name$");
        this.bizComScheme.setCommitFormat("number");
        this.bizComScheme.setEditable(false);
        this.bizComScheme.setHasCUDefaultFilter(false);
        this.bizComScheme.setEntityViewInfo(evi);
    }

    protected void bizComScheme_dataChanged(DataChangeEvent e) throws Exception {
        if (this.bizComScheme.getData() == null) {
            this.tblMain.removeRows();
        } else {
            String schemeID = ((CmpSchemeInfo)this.bizComScheme.getData()).getId().toString();
            this.tblMain.removeRows();
            this.tblMain.checkParsed();
            String benefitRuleID = this.getUIContext().get("tmpBeneRuleID").toString();
            IBenefitRuleFacade iBenefitRuleFacade = BenefitRuleFacadeFactory.getRemoteInstance();
            IRowSet rows = iBenefitRuleFacade.getPersonByCmpScheme(schemeID, benefitRuleID);
            IRow iRow1 = null;
            try {
                while (rows.next()) {
                    iRow1 = this.tblMain.addRow();
                    iRow1.getCell("id").setValue((Object)rows.getString("id"));
                    iRow1.getCell("number").setValue((Object)rows.getString("number"));
                    iRow1.getCell("name").setValue((Object)rows.getString("name"));
                    iRow1.getCell("gender").setValue((Object)Genders.getEnum((int)rows.getInt("gender")));
                    iRow1.getCell("idCardNO").setValue((Object)rows.getString("idCardNO"));
                    iRow1.getCell("admin.name").setValue((Object)rows.getString("admin.name"));
                    iRow1.getCell("position.name").setValue((Object)rows.getString("position.name"));
                }
            }
            catch (SQLException e1) {
                this.handleException(e1);
            }
        }
    }

    protected void btnSave_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> personList = new ArrayList<String>();
        int rowCount = this.tblMain.getRowCount3();
        String personID = null;
        IRow row = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            personID = row.getCell("id").getValue().toString();
            personList.add(personID);
        }
        if (this.bizComScheme.getData() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitRuleResource.SCHEME_NOT_NULL"));
            SysUtil.abort();
        }
        if (personList.size() == 0 && this.delPersonList.size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitRuleResource.ADD_PERSON"));
            SysUtil.abort();
        }
        String schemeID = ((CmpSchemeInfo)this.bizComScheme.getData()).getId().toString();
        IBenefitRuleFacade iBenefitRuleFacade = BenefitRuleFacadeFactory.getRemoteInstance();
        iBenefitRuleFacade.savePersonSchemeRel(schemeID, this.benefitRuleID, personList, this.delPersonList);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.BenefitResource.SAVE_OK"));
    }

    protected void btnAddNew_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.btnAddNew_actionPerformed(e);
        this.promptBox.setQueryInfo("com.kingdee.eas.hr.benefit.app.PersonScheme1Query");
        this.promptBox.setEnabledMultiSelection(true);
        this.promptBox.setRefresh(true);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("benefitRule.id", (Object)this.benefitRuleID));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpScheme.id", null, CompareType.IS));
        viewInfo.setFilter(filterInfo);
        this.promptBox.setEntityViewInfo(viewInfo);
        this.promptBox.setDataBySelector();
        Object data = this.promptBox.getData();
        Object[] datas = (Object[])data;
        PersonInfo info = null;
        String personID = null;
        ArrayList<String> personIDList = new ArrayList<String>();
        int size = datas.length;
        for (int i2 = 0; i2 < size; ++i2) {
            info = (PersonInfo)datas[i2];
            if (info == null) {
                return;
            }
            personID = info.getId().toString();
            personIDList.add(personID);
        }
        HashMap map = new HashMap();
        IBenefitRuleFacade ibrf = BenefitRuleFacadeFactory.getRemoteInstance();
        map = ibrf.getPersonAdminPositionInfo(personIDList);
        HashMap<String, String> tableMap = new HashMap<String, String>();
        for (i = 0; i < this.tblMain.getRowCount(); ++i) {
            tableMap.put(this.tblMain.getRow(i).getCell("id").getValue().toString(), "true");
        }
        int size2 = datas.length;
        for (i = 0; i < size2; ++i) {
            info = (PersonInfo)datas[i];
            if (info == null) {
                return;
            }
            if (tableMap.containsKey(info.getId().toString())) continue;
            IRow row = this.tblMain.addRow();
            row.getCell("id").setValue((Object)info.getId());
            row.getCell("number").setValue((Object)info.getNumber());
            row.getCell("name").setValue((Object)info.getName());
            row.getCell("gender").setValue((Object)info.getGender());
            row.getCell("idCardNO").setValue((Object)info.getIdCardNO());
            if (map.get(personID) == null) {
                IBenefitRuleFacade iBenefitRuleFacade = BenefitRuleFacadeFactory.getRemoteInstance();
                HashMap noPositionMap = iBenefitRuleFacade.getAdminPersonNoPosition(personID);
                if (!noPositionMap.containsKey(personID)) continue;
                List list = (List)noPositionMap.get(personID);
                row.getCell("admin.name").setValue(list.get(0));
                continue;
            }
            String[] tmp = map.get(personID).toString().split("@");
            row.getCell("admin.name").setValue((Object)tmp[0]);
            if (tmp[1] == null || tmp[1].equals("null")) {
                row.getCell("position.name").setValue(null);
                continue;
            }
            row.getCell("position.name").setValue((Object)tmp[1]);
        }
    }

    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        int[] activeIndex = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int size = activeIndex.length;
        String personID = null;
        for (int i = 0; i < size; ++i) {
            int row = activeIndex[i];
            if (row == -1) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
                SysUtil.abort();
            }
            if (this.tblMain.getCell(row, "id").getValue() == null) continue;
            personID = this.tblMain.getCell(row, "id").getValue().toString();
            this.delPersonList.add(personID);
        }
        BenefitUtils.deleteBlock(this.tblMain);
    }
}

