/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.benefit.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.benefit.client.AbstractSocialInsAnnuityReportFilterUI;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.benefit.util.CommonQueryUtil;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class SocialInsAnnuityReportFilterUI
extends AbstractSocialInsAnnuityReportFilterUI {
    private static final long serialVersionUID = 1L;
    private boolean isUseAdminFlag = true;

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
        this.setPanelName(EASResource.getString((String)"com.kingdee.eas.hr.benefit.AccountManagerResource.SEARCH"));
        this.kdSocialInsPanel.setBorder((Border)new TitledBorder(BorderFactory.createLineBorder(new Color(192, 192, 192), 0), ""));
    }

    private void initAllEditor() throws Exception {
        BenefitUtils.setAdminOrgF7(this.kdbAdminUnit);
        this.kdbCmpPeriod.setEnabled(true);
        this.kdbEndPeriod.setEnabled(true);
        BenefitUtils.initPeriodEditor(this.kdbCmpPeriod);
        BenefitUtils.initPeriodEditor(this.kdbEndPeriod);
    }

    public void getPanelSql(HashMap paramMap) throws EASBizException, BOSException {
        HashSet adminSet = new HashSet();
        AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)this.kdbAdminUnit.getData();
        String adminID = adminOrgUnitInfo.getId().toString();
        if (this.chkIncludeSubOrgUnit.isSelected()) {
            adminSet = BenefitUtils.getUserRangeAdminOrg(null, adminID, true);
        } else {
            adminSet.add(adminID);
        }
        paramMap.put("adminOrgUnit", adminSet);
        CmpPeriodInfo periodInfo = (CmpPeriodInfo)this.kdbCmpPeriod.getData();
        CmpPeriodInfo endPeriodInfo = (CmpPeriodInfo)this.kdbEndPeriod.getData();
        HashSet periodSet = BenefitUtils.getCmpPeridSet(periodInfo, endPeriodInfo);
        paramMap.put("period", periodSet);
    }

    public void clear() {
        super.clear();
        this.kdbAdminUnit.setEnabled(true);
        this.kdbAdminUnit.setData(null);
        this.kdbCmpPeriod.setData(null);
        this.kdbEndPeriod.setData(null);
        this.chkIncludeSubOrgUnit.setSelected(false);
    }

    public boolean verify() {
        boolean flagOfDate;
        if (this.kdbAdminUnit.getData() == null && this.isUseAdminFlag) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.AccountManagerResource.ADMINORG_NOT_NULL"));
            this.kdbAdminUnit.requestFocusInWindow();
            return false;
        }
        if (this.kdbCmpPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.client.FormDetailResource.MUST_BEGINPERIOD"));
            this.kdbCmpPeriod.requestFocusInWindow();
            return false;
        }
        if (this.kdbEndPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.benefit.client.FormDetailResource.MUST_ENDPERIOD"));
            this.kdbEndPeriod.requestFocusInWindow();
            return false;
        }
        CmpPeriodInfo cmpPeriodInfoBegin = (CmpPeriodInfo)this.kdbCmpPeriod.getData();
        CmpPeriodInfo cmpPeriodInfoEnd = (CmpPeriodInfo)this.kdbEndPeriod.getData();
        if (!cmpPeriodInfoBegin.getId().toString().equals(cmpPeriodInfoEnd.getId().toString()) && !(flagOfDate = DateTimeUtils.dayAfter((Date)cmpPeriodInfoEnd.getBeginDate(), (Date)cmpPeriodInfoBegin.getEndDate()))) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpAdjustiveSchResource.BEGINDATE_AFTER_ENDDATE"));
            this.kdbCmpPeriod.requestFocusInWindow();
            return false;
        }
        return true;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        CommonQueryUtil.getAdminFromQueryPanel(cp, this.kdbAdminUnit);
        cp.addCustomerParam("chkIncludeSubOrgUnit", Boolean.valueOf(this.chkIncludeSubOrgUnit.isSelected()).toString());
        CommonQueryUtil.getCmpFromQueryPanel("cmpPeriod.id", cp, this.kdbCmpPeriod);
        CommonQueryUtil.getCmpFromQueryPanel("endPeriod", cp, this.kdbEndPeriod);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        CommonQueryUtil.setAdminFromQueryPanel(cp, this.kdbAdminUnit);
        if (cp.getCustomerParam("chkIncludeSubOrgUnit") != null) {
            this.chkIncludeSubOrgUnit.setSelected(Boolean.valueOf(cp.getCustomerParam("chkIncludeSubOrgUnit")).booleanValue());
        }
        CommonQueryUtil.setCmpFromQueryPanel("cmpPeriod.id", cp, this.kdbCmpPeriod);
        CommonQueryUtil.setCmpFromQueryPanel("endPeriod", cp, this.kdbEndPeriod);
    }
}

