/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.IServiceLocator;
import com.kingdee.bos.bsf.service.ServiceLocator;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.base.DynamicTableInfo;
import com.kingdee.eas.hr.compensation.BudgetCompensationFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpItemPrecisionTypeEnum;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.IBudgetCompensationFacade;
import com.kingdee.eas.hr.compensation.client.AbstractBudgetCompensationUI;
import com.kingdee.eas.hr.compensation.client.BudgetCompensationCompFilterUI;
import com.kingdee.eas.hr.compensation.util.CompTableStyleUtil;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRDynamicTableUtils;
import com.kingdee.eas.hr.compensation.util.HRReportUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.ma.nbudget.IBgApi;
import com.kingdee.eas.ma.nbudget.IBgDataApiInfo;
import com.kingdee.eas.ma.nbudget.IBgFormApiInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BudgetCompensationUI
extends AbstractBudgetCompensationUI {
    private static final Logger logger = CoreUIObject.getLogger(BudgetCompensationUI.class);
    private BudgetCompensationCompFilterUI filterUI = new BudgetCompensationCompFilterUI();
    private String cureQueryName = "";
    private DynamicTableInfo infoDynamicTable = new DynamicTableInfo();
    private static final String COST_ID_CATA = "COST_ID_CATA";
    private static final String BG_SCHEME_PERIOD = "BG_SCHEME_PERIOD";
    private static final String resClass = "com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.";
    private DataBaseInfo bgPeriodinfos;
    private CmpPeriodInfo[] cmpPeriodInfos;
    private Map items;
    private IBudgetCompensationFacade bgcFacade = null;
    private IBgFormApiInfo bgFormInfo;
    private List bgList = null;
    private CommonQueryDialog commonQueryDialog = new CommonQueryDialog();
    private QuerySolutionInfo solutionInfo = null;
    private boolean isFirstDefaultQuery = true;
    private EntityViewInfo infoEntityView = new EntityViewInfo();
    private Set selectedCmpScheme = null;
    private CoreBaseCollection bgDataCols = null;
    private List cmpList = null;
    private Map map = null;

    public BudgetCompensationUI() throws Exception {
        HRSchemeUtils.checkInit();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.getBizfacadeInterface();
        this.showFilterDialog();
        this.doQueryDialog();
        this.tHelper.getDisabledTables().add(this.tblMain);
        this.tblMain.getHeadStyleAttributes().setWrapText(true);
        this.tblMain.getHeadRow(0).setHeight(CompTableStyleUtil.getTblHeadHeight());
    }

    private IBudgetCompensationFacade getBizfacadeInterface() throws BOSException {
        if (this.bgcFacade == null) {
            this.bgcFacade = BudgetCompensationFacadeFactory.getRemoteInstance();
        }
        return this.bgcFacade;
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnCaculate.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
        this.btnCaculate.setEnabled(true);
        this.menuItemCalculate.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
        this.menuItemCalculate.setEnabled(true);
    }

    private void createTblMain() throws Exception {
        this.tblMain.setRefresh(true);
        this.infoDynamicTable.setCountHeadLine(3);
        List lstColumn = this.getTblMainColumn();
        DynamicTableInfo.ColumnInfo[] infosColumn = new DynamicTableInfo.ColumnInfo[lstColumn.size()];
        int size = lstColumn.size();
        for (int i = 0; i < size; ++i) {
            infosColumn[i] = (DynamicTableInfo.ColumnInfo)lstColumn.get(i);
        }
        this.infoDynamicTable.setInfosColumn(infosColumn);
        HRDynamicTableUtils.createTableHead((KDTable)this.tblMain, (DynamicTableInfo)this.infoDynamicTable);
        this.setHeadMerge();
        this.tblMain.setColumnMoveable(false);
        this.tblMain.setRefresh(true);
        this.tblMain.repaint();
    }

    private List getTblMainColumn() {
        ArrayList<DynamicTableInfo.ColumnInfo> lstColumn = new ArrayList<DynamicTableInfo.ColumnInfo>();
        DynamicTableInfo.ColumnInfo infoColumn = null;
        infoColumn = new DynamicTableInfo.ColumnInfo();
        infoColumn.setHide(false);
        infoColumn.setReadOnly(true);
        infoColumn.setLocked(true);
        infoColumn.setColor(HRReportUtils.NORMAL_COLOR);
        infoColumn.setColumnType(30);
        infoColumn.setKey(COST_ID_CATA);
        infoColumn.setColumnNumber(COST_ID_CATA);
        infoColumn.setColumnName(COST_ID_CATA);
        infoColumn.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[0].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.COST_ID_CATA"));
        infoColumn.getInfosHead()[0].setHeadValue(COST_ID_CATA);
        lstColumn.add(infoColumn);
        for (int i = 0; i < this.cmpPeriodInfos.length + 3; ++i) {
            infoColumn = new DynamicTableInfo.ColumnInfo();
            infoColumn.setAlignHor(Styles.HorizontalAlignment.RIGHT);
            infoColumn.setHide(false);
            infoColumn.setReadOnly(true);
            infoColumn.setLocked(true);
            infoColumn.setColor(HRReportUtils.NORMAL_COLOR);
            infoColumn.setColumnType(30);
            infoColumn.setKey(BG_SCHEME_PERIOD);
            infoColumn.setColumnNumber(BG_SCHEME_PERIOD);
            infoColumn.setColumnName(BG_SCHEME_PERIOD);
            infoColumn.setInfosHead(new DynamicTableInfo.HeadInfo[3]);
            infoColumn.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
            infoColumn.getInfosHead()[0].setHeadName(this.bgPeriodinfos.getName());
            infoColumn.getInfosHead()[0].setHeadValue(this.bgPeriodinfos.getName());
            if (i == 0) {
                infoColumn.setColumnNumber("BG_VALUE");
                infoColumn.setColumnName("BG_VALUE");
                infoColumn.setKey("BG_VALUE");
                infoColumn.setColor(HRReportUtils.NORMAL_COLOR);
                infoColumn.getInfosHead()[1] = new DynamicTableInfo.HeadInfo();
                infoColumn.getInfosHead()[1].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.BG_VALUE"));
                infoColumn.getInfosHead()[1].setHeadValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.BG_VALUE"));
                infoColumn.setColumnNumber("BG_VALUE");
                infoColumn.setColumnName("BG_VALUE");
                infoColumn.setKey("BG_VALUE");
                infoColumn.setColor(HRReportUtils.NORMAL_COLOR);
                infoColumn.getInfosHead()[2] = new DynamicTableInfo.HeadInfo();
                infoColumn.getInfosHead()[2].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.BG_VALUE"));
                infoColumn.getInfosHead()[2].setHeadValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.BG_VALUE"));
            } else if (i == this.cmpPeriodInfos.length + 3 - 1) {
                infoColumn.setColumnNumber("DIFFERENCY_PEN");
                infoColumn.setColumnName("DIFFERENCY_PEN");
                infoColumn.setKey("DIFFERENCY_PEN");
                infoColumn.setColor(HRReportUtils.NORMAL_COLOR);
                infoColumn.getInfosHead()[1] = new DynamicTableInfo.HeadInfo();
                infoColumn.getInfosHead()[1].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.DIFFERENCY_PEN"));
                infoColumn.getInfosHead()[1].setHeadValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.DIFFERENCY_PEN"));
                infoColumn.setColumnNumber("DIFFERENCY_PEN");
                infoColumn.setColumnName("DIFFERENCY_PEN");
                infoColumn.setKey("DIFFERENCY_PEN");
                infoColumn.setColor(HRReportUtils.NORMAL_COLOR);
                infoColumn.getInfosHead()[2] = new DynamicTableInfo.HeadInfo();
                infoColumn.getInfosHead()[2].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.DIFFERENCY_PEN"));
                infoColumn.getInfosHead()[2].setHeadValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.DIFFERENCY_PEN"));
            } else {
                infoColumn.setColumnNumber("ACTUAL_VALUE");
                infoColumn.setColumnName("ACTUAL_VALUE");
                infoColumn.setKey("ACTUAL_VALUE");
                infoColumn.setColor(HRReportUtils.NORMAL_COLOR);
                infoColumn.getInfosHead()[1] = new DynamicTableInfo.HeadInfo();
                infoColumn.getInfosHead()[1].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.ACTUAL_VALUE"));
                infoColumn.getInfosHead()[1].setHeadValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.ACTUAL_VALUE"));
                if (i == this.cmpPeriodInfos.length + 3 - 2) {
                    infoColumn.setColumnNumber("TOTAL");
                    infoColumn.setColumnName("TOTAL");
                    infoColumn.setKey("TOTAL");
                    infoColumn.setColor(HRReportUtils.NORMAL_COLOR);
                    infoColumn.getInfosHead()[2] = new DynamicTableInfo.HeadInfo();
                    infoColumn.getInfosHead()[2].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.TOTAL"));
                    infoColumn.getInfosHead()[2].setHeadValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.TOTAL"));
                } else {
                    infoColumn.setColumnNumber(this.cmpPeriodInfos[i - 1].getNumber());
                    infoColumn.setColumnName(this.cmpPeriodInfos[i - 1].getNumber());
                    infoColumn.setKey(this.cmpPeriodInfos[i - 1].getNumber());
                    infoColumn.setColor(HRReportUtils.NORMAL_COLOR);
                    infoColumn.getInfosHead()[2] = new DynamicTableInfo.HeadInfo();
                    infoColumn.getInfosHead()[2].setHeadName(this.cmpPeriodInfos[i - 1].getName());
                    infoColumn.getInfosHead()[2].setHeadValue(this.cmpPeriodInfos[i - 1].getName());
                }
            }
            lstColumn.add(infoColumn);
        }
        return lstColumn;
    }

    protected void doQueryDialog() throws Exception {
        this.bgPeriodinfos = this.filterUI.getBgPeriodInfo();
        this.cmpPeriodInfos = this.filterUI.getCmpPeriodInfos();
        this.items = this.filterUI.getItems();
        this.bgFormInfo = this.filterUI.getBgFormInfo();
        this.selectedCmpScheme = this.filterUI.getCmpScheme();
        this.bgDataCols = this.getBgDataCols(this.bgFormInfo.getId(), this.bgPeriodinfos.getId());
        this.getCmpItemList();
        this.createTblMain();
        this.fillTblData();
    }

    private void setHeadMerge() throws Exception {
        int sizeOfTableColumn = this.tblMain.getColumnCount();
        KDTMergeManager mm = this.tblMain.getHeadMergeManager();
        mm.mergeBlock(0, 0, 2, 0, 4);
        mm.mergeBlock(0, 1, 0, sizeOfTableColumn - 1, 4);
        mm.mergeBlock(1, 2, 1, this.cmpPeriodInfos.length + 2, 4);
    }

    private void fillTblData() throws Exception {
        CmpSchemeInfo[] cmpScheme = new CmpSchemeInfo[this.selectedCmpScheme.size()];
        Iterator its = this.selectedCmpScheme.iterator();
        int len = 0;
        while (its.hasNext()) {
            cmpScheme[len] = (CmpSchemeInfo)its.next();
            ++len;
        }
        List cmpList = this.getCmpList();
        Iterator it = null;
        if (this.bgDataCols != null && this.bgDataCols.size() > 0) {
            this.tblMain.removeRows();
            IRow row = null;
            if (cmpList.size() > 0) {
                it = cmpList.iterator();
                while (it.hasNext()) {
                    row = this.tblMain.addRow();
                    CmpItemInfo c = (CmpItemInfo)it.next();
                    row.getCell(COST_ID_CATA).setValue((Object)c);
                }
            }
        }
    }

    private List getCmpItemList() throws Exception {
        ArrayList<CmpItemInfo> cmpList = new ArrayList<CmpItemInfo>();
        ArrayList<DataBaseInfo> bgList = new ArrayList<DataBaseInfo>();
        DataBaseInfo bgItemInfo = null;
        CmpItemInfo cmpItemInfo2 = null;
        Set set = null;
        Iterator it = null;
        if (this.items != null) {
            set = this.items.keySet();
            for (CmpItemInfo cmpItemInfo2 : set) {
                cmpList.add(cmpItemInfo2);
                bgItemInfo = (DataBaseInfo)this.items.get(bgItemInfo);
                bgList.add(bgItemInfo);
            }
        }
        this.bgList = bgList;
        this.cmpList = cmpList;
        return cmpList;
    }

    public List getBgItemList() throws Exception {
        return this.bgList;
    }

    public List getCmpList() throws Exception {
        return this.cmpList;
    }

    public Map getMap() throws EASBizException, BOSException {
        if (this.selectedCmpScheme == null || this.selectedCmpScheme.size() == 0) {
            return new HashMap();
        }
        CmpSchemeInfo[] cmpScheme = new CmpSchemeInfo[this.selectedCmpScheme.size()];
        Iterator its = this.selectedCmpScheme.iterator();
        int len = 0;
        while (its.hasNext()) {
            cmpScheme[len] = (CmpSchemeInfo)its.next();
            ++len;
        }
        this.map = this.bgcFacade.getCmpSchemeData(cmpScheme, this.cmpPeriodInfos, this.cmpList);
        return this.map;
    }

    private int getTheIndexOfBgItemInArgs(DataBaseInfo bgItem, CoreBaseInfo[] bgDataInfos) {
        int index = -1;
        if (bgDataInfos != null) {
            for (int i = 0; i < bgDataInfos.length; ++i) {
                if (((IBgDataApiInfo)bgDataInfos[i]).getFormula().toString().indexOf(bgItem.getNumber()) <= -1) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    protected void showFilterDialog() throws Exception {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.CmpSchemeQuery");
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = HRSchemeUtils.getQueryInfo((IMetaDataPK)queryPK).getFullName();
        this.commonQueryDialog.setWidth(550);
        this.commonQueryDialog.setHeight(520);
        if (this.getUIWindow() == null) {
            this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            this.commonQueryDialog.setOwner((Component)((Object)this));
        }
        this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.commonQueryDialog.setQueryObjectPK((IMetaDataPK)queryPK);
        this.commonQueryDialog.setShowFilter(false);
        this.commonQueryDialog.setShowSorter(false);
        this.commonQueryDialog.setShowToolbar(true);
        this.commonQueryDialog.setEntityViewInfo(this.infoEntityView);
        this.commonQueryDialog.setQueryObjectPK((IMetaDataPK)queryPK);
        this.filterUI.setPanelName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.FILTER_CONDITION"));
        this.commonQueryDialog.addUserPanel((KDPanel)this.filterUI);
        this.commonQueryDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.BUDGETCOMPENSATION_FILTER"));
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            this.infoEntityView = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
            if (this.infoEntityView == null) {
                this.infoEntityView = new EntityViewInfo();
            }
            this.solutionInfo = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            if (CompUtils.isNullWhere((QuerySolutionInfo)this.solutionInfo) && this.solutionInfo.getQueryPanelInfo().get(0) != null && this.solutionInfo.getQueryPanelInfo().get(0).getCustomerParams() != null) {
                this.infoEntityView = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
                CustomerParams cp = CustomerParams.getCustomerParams2((String)this.solutionInfo.getQueryPanelInfo().get(0).getCustomerParams());
                this.filterUI.setCustomerParams(cp);
                this.commonQueryDialog.setEntityViewInfo(this.infoEntityView);
                this.doQueryDialog();
            } else {
                this.isFirstDefaultQuery = false;
                if (this.commonQueryDialog.show()) {
                    this.solutionInfo = this.commonQueryDialog.getCurrentSolutionInfo();
                    this.doQueryDialog();
                } else {
                    SysUtil.abort();
                }
            }
        } else {
            this.isFirstDefaultQuery = false;
            if (this.commonQueryDialog.show()) {
                this.solutionInfo = this.commonQueryDialog.getCurrentSolutionInfo();
                this.doQueryDialog();
            } else {
                SysUtil.abort();
            }
        }
    }

    private CoreBaseCollection getBgDataCols(BOSUuid bgFormId, BOSUuid bgPeriodId) throws Exception {
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgFormId", (Object)bgFormId));
        filter.getFilterItems().add(new FilterItemInfo("bgPeriod", (Object)bgPeriodId));
        filter.setMaskString("#0 and #1");
        ev.setFilter(filter);
        IServiceLocator service = ServiceLocator.getInstance();
        IBgApi bgApi = (IBgApi)service.lookupService("MA.BD.BgApi");
        CoreBaseCollection c = bgApi.getBgDataRemoteInstance().getCollection(ev);
        return c;
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    public void actionPrintView_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintView_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (this.commonQueryDialog.show()) {
            this.solutionInfo = this.commonQueryDialog.getCurrentSolutionInfo();
            this.doQueryDialog();
        }
        this.tblMain.getHeadRow(0).setHeight(CompTableStyleUtil.getTblHeadHeight());
        this.tblMain.reLayoutAndPaint();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.doQueryDialog();
    }

    public void actionCaculate_actionPerformed(ActionEvent e) throws Exception {
        super.actionCaculate_actionPerformed(e);
        int rowCount = this.tblMain.getRowCount();
        IRow row = null;
        CmpItemInfo cmpItem = null;
        CmpItemInfo itemPrecisionInfo = null;
        DataBaseInfo bgItem = null;
        String cmpItemNumber = null;
        String cmpPeriodNumber = null;
        this.map = this.getMap();
        CoreBaseInfo[] bgDataInfos = new CoreBaseInfo[this.bgDataCols.size()];
        if (this.bgDataCols.size() > 0) {
            for (int i = 0; i < bgDataInfos.length; ++i) {
                bgDataInfos[i] = this.bgDataCols.get(i);
            }
            BigDecimal bgValue = new BigDecimal("0.00");
            for (int i = 0; i < rowCount; ++i) {
                row = this.tblMain.getRow(i);
                cmpItem = (CmpItemInfo)row.getCell(COST_ID_CATA).getValue();
                itemPrecisionInfo = (CmpItemInfo)HRCmpItemUtils.getCmpItemInfoByNumber(null, (String[])new String[]{cmpItem.getNumber()}).get(cmpItem.getNumber());
                bgItem = (DataBaseInfo)this.items.get(cmpItem);
                int index = this.getTheIndexOfBgItemInArgs(bgItem, bgDataInfos);
                bgValue = ((IBgDataApiInfo)bgDataInfos[index]).getBgValue();
                row.getCell("BG_VALUE").setValue((Object)bgValue.setScale(2, 4).toString());
                cmpItemNumber = cmpItem.getNumber();
                BigDecimal totalValue = new BigDecimal("0.00");
                BigDecimal itemValue = null;
                for (int j = 0; j < this.cmpPeriodInfos.length; ++j) {
                    cmpPeriodNumber = this.cmpPeriodInfos[j].getNumber();
                    row.getCell(cmpPeriodNumber).getStyleAttributes().setNumberFormat(HRCmpItemUtils.getColumnFormatStr((int)itemPrecisionInfo.getDecDigital()));
                    if (this.map.containsKey(cmpItemNumber + "@" + cmpPeriodNumber)) {
                        itemValue = (BigDecimal)this.map.get(cmpItemNumber + "@" + cmpPeriodNumber);
                        row.getCell(cmpPeriodNumber).setValue((Object)HRCmpItemUtils.convertPrecisionForBigDecimal((BigDecimal)itemValue, (int)itemPrecisionInfo.getDecDigital(), (CmpItemPrecisionTypeEnum)itemPrecisionInfo.getPrecisionType()));
                        totalValue = totalValue.add((BigDecimal)this.map.get(cmpItemNumber + "@" + cmpPeriodNumber));
                        continue;
                    }
                    itemValue = new BigDecimal("0");
                    row.getCell(cmpPeriodNumber).setValue((Object)HRCmpItemUtils.convertPrecisionForBigDecimal((BigDecimal)itemValue, (int)itemPrecisionInfo.getDecDigital(), (CmpItemPrecisionTypeEnum)itemPrecisionInfo.getPrecisionType()));
                }
                row.getCell("TOTAL").getStyleAttributes().setNumberFormat(HRCmpItemUtils.getColumnFormatStr((int)itemPrecisionInfo.getDecDigital()));
                row.getCell("TOTAL").setValue((Object)HRCmpItemUtils.convertPrecisionForBigDecimal((BigDecimal)totalValue, (int)itemPrecisionInfo.getDecDigital(), (CmpItemPrecisionTypeEnum)itemPrecisionInfo.getPrecisionType()));
                if (bgValue.doubleValue() != 0.0) {
                    BigDecimal diffValue = totalValue.add(bgValue.negate()).divide(bgValue, 4);
                    row.getCell("DIFFERENCY_PEN").setValue((Object)diffValue);
                    continue;
                }
                row.getCell("DIFFERENCY_PEN").setValue((Object)bgValue);
            }
        }
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected KDTable getTableForOA() {
        return this.tblMain;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.COMPENSATION;
    }

    public QuerySolutionInfo getQuerySolutionInfo() {
        return this.solutionInfo;
    }
}

