/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.IServiceLocator;
import com.kingdee.bos.bsf.service.ServiceLocator;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.compensation.CmpBudgetFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpReportException;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ICmpBudgetFacade;
import com.kingdee.eas.hr.compensation.client.AbstractCmpBudgetCompareChartFilterUI;
import com.kingdee.eas.hr.compensation.client.HRF7CmpSchemePromptBox;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.ma.budget.client.BgCostCenterOrgViewF7;
import com.kingdee.eas.ma.nbudget.IBgApi;
import com.kingdee.eas.ma.nbudget.IBgFormApiInfo;
import com.kingdee.eas.ma.nbudget.IBgPeriodApiInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.event.ItemEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CmpBudgetCompareChartFilterUI
extends AbstractCmpBudgetCompareChartFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CmpBudgetCompareChartFilterUI.class);
    private String resClass = "com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.";
    private ICmpBudgetFacade bgcFacade = null;
    private IBgFormApiInfo bgFormInfo = null;
    protected String cmpPeriodF7URL = "com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery";
    private List hroIdList = new ArrayList();
    private List orgList = new ArrayList();
    private boolean clearFlag = false;
    private String rootHroId = null;
    private boolean hasMainDim = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
        this.initBgPeriod();
    }

    private void initAllEditor() throws Exception {
        BgCostCenterOrgViewF7 orgView = new BgCostCenterOrgViewF7((IUIObject)this);
        orgView.setTitle(EASResource.getString((String)(this.resClass + "orgUnitTitle")));
        orgView.setMultiSelect(false);
        orgView.setReturnSuperior(true);
        this.prmtCostCenter.setDisplayFormat("$name$");
        if (this.ui != null) {
            orgView.setUIActionPK((IMetaDataPK)new MetaDataPK(this.ui.getClass().getName()), (IMetaDataPK)new MetaDataPK("ActionOnLoad"));
        }
        this.prmtCostCenter.setSelector((KDPromptSelector)orgView);
        this.prmtCostCenter.setRequired(true);
        this.prmtCostCenter.setEditable(false);
        this.prmtCostCenter.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                CmpBudgetCompareChartFilterUI.this.setBgHroInfo();
                if (CmpBudgetCompareChartFilterUI.this.hroIdList != null && CmpBudgetCompareChartFilterUI.this.hroIdList.size() > 0) {
                    CmpBudgetCompareChartFilterUI.this.changedBgScheme(eventObj.getNewValue());
                    CmpBudgetCompareChartFilterUI.this.setCmpSchemeInfo();
                }
            }
        });
        this.prmtCmpScheme.setEnabled(false);
    }

    private void setCmpSchemeInfo() {
        this.prmtCmpScheme.setData(null);
        ArrayList<HROrgUnitInfo> hroFilterList = new ArrayList<HROrgUnitInfo>();
        int n = this.hroIdList.size();
        for (int i = 0; i < n; ++i) {
            String hroId = (String)this.hroIdList.get(i);
            HROrgUnitInfo hrOrg = new HROrgUnitInfo();
            hrOrg.setId(BOSUuid.read((String)hroId));
            hroFilterList.add(hrOrg);
        }
        HRF7CmpSchemePromptBox f7PromptBox = new HRF7CmpSchemePromptBox((IUIObject)this);
        f7PromptBox.setHROFilter(hroFilterList);
        this.prmtCmpScheme.setSelector((KDPromptSelector)f7PromptBox);
        this.prmtCmpScheme.setEditable(false);
        this.prmtCmpScheme.setEditFormat("$name$");
        this.prmtCmpScheme.setDisplayFormat("$name$");
        this.prmtCmpScheme.setHasCUDefaultFilter(false);
        this.prmtCmpScheme.setEnabledMultiSelection(true);
        this.prmtCmpScheme.setEnabled(true);
    }

    protected void initBgPeriod() throws Exception {
        IServiceLocator service = ServiceLocator.getInstance();
        IBgApi bgApi = (IBgApi)service.lookupService("MA.BD.BgApi");
        KDPromptSelector bgPeriodDialog = bgApi.getBgPeriodDialog((CoreUIObject)this);
        this.prmtBgPeriodBegin.setSelector(bgPeriodDialog);
        this.prmtBgPeriodEnd.setSelector(bgPeriodDialog);
        this.prmtBgPeriodBegin.setEditable(false);
        this.prmtBgPeriodEnd.setEditable(false);
    }

    private void setBgHroInfo() {
        try {
            this.hroIdList = this.getHROrgListInfo();
            if (this.hroIdList != null && this.hroIdList.size() == 0 && !this.clearFlag) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"180_CmpBudgetCompareChartFilterUI"));
            } else if (this.hroIdList != null && this.hroIdList.size() > 0) {
                this.rootHroId = (String)this.hroIdList.get(0);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public boolean verify() {
        if (this.prmtCostCenter.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"181_CmpBudgetCompareChartFilterUI"));
            return false;
        }
        if (this.boxBgScheme.getSelectedIndex() < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "SELECT_BGSCHEME")));
            return false;
        }
        if (this.boxData.getSelectedItem() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "SELECT_BGFORM")));
            return false;
        }
        if (this.prmtBgPeriodBegin.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"182_CmpBudgetCompareChartFilterUI"));
            return false;
        }
        if (this.prmtBgPeriodEnd.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"183_CmpBudgetCompareChartFilterUI"));
            return false;
        }
        if (this.prmtBgPeriodBegin.getData() != null && this.prmtBgPeriodEnd.getData() != null) {
            IBgPeriodApiInfo _begin = null;
            IBgPeriodApiInfo _end = null;
            _begin = (IBgPeriodApiInfo)this.prmtBgPeriodBegin.getData();
            _end = (IBgPeriodApiInfo)this.prmtBgPeriodEnd.getData();
            if (_begin.getPeriodTypeEnum().getValue() != _end.getPeriodTypeEnum().getValue()) {
                MsgBox.showWarning((String)EASResource.getString((String)(this.resClass + "selectBgPeriodNoAccord")));
                return false;
            }
        }
        if (this.boxBgItem.getSelectedItem() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"184_CmpBudgetCompareChartFilterUI"));
            return false;
        }
        if (this.prmtCmpScheme.getData() == null || ((Object[])this.prmtCmpScheme.getData())[0] == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "SELECT_CMPSCHEME")));
            return false;
        }
        if (!this.hasMainDim) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"185_CmpBudgetCompareChartFilterUI"));
            return false;
        }
        return true;
    }

    private void changedBgScheme(Object object) {
        if (object == null) {
            return;
        }
        try {
            this.boxBgScheme.removeAllItems();
            OrgUnitInfo orgUnit = (OrgUnitInfo)object;
            String objectId = "'" + orgUnit.getId().toString() + "'";
            if (!StringUtils.isEmpty((String)objectId)) {
                ICmpBudgetFacade bgcFacade = this.getBizfacadeInterface();
                IObjectCollection bgSchemeCols = bgcFacade.getBgScheme(objectId);
                Vector bgSchemeVector = new Vector();
                if (bgSchemeCols.size() > 0) {
                    Iterator it = bgSchemeCols.iterator();
                    bgSchemeVector.clear();
                    while (it.hasNext()) {
                        bgSchemeVector.add(it.next());
                    }
                }
                this.boxBgScheme.setEnabled(true);
                this.boxBgScheme.addItems(bgSchemeVector);
                this.boxBgScheme.setSelectedIndex(-1);
            } else {
                this.boxBgScheme.addItem(null);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private List getHROrgListInfo() throws BOSException, SQLException {
        ArrayList<String> hrolist = new ArrayList<String>();
        Object obj = this.prmtCostCenter.getData();
        if (this.prmtCostCenter.getData() != null) {
            OrgUnitInfo orgUnit = (OrgUnitInfo)obj;
            ArrayList<String> list = new ArrayList<String>();
            list.add(orgUnit.getId().toString());
            String orgIds = HRSchemeUtils.getStrFromList(list);
            StringBuffer sql = new StringBuffer();
            sql.append("select distinct o.FToUnitID from T_ORG_UnitRelation o where o.fFromUnitID in (");
            sql.append(" select r.fToUnitID from T_ORG_UnitRelation r");
            sql.append(" where r.FTypeRelationID='00000000-0000-0000-0000-0000000000150FE9F8B5'");
            sql.append(" and r.fFromUnitID in ").append(orgIds).append(") and ");
            sql.append(" o.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5'");
            sql.append(" union ");
            sql.append("select distinct o.FToUnitID from T_ORG_UnitRelation o where o.fFromUnitID in ");
            sql.append(orgIds).append(" and ");
            sql.append(" o.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5'");
            ISQLExecutor iSQLExec = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
            IRowSet rs = iSQLExec.executeSQL();
            while (rs.next()) {
                String orgId = rs.getString("FToUnitID");
                hrolist.add(orgId);
            }
        }
        return hrolist;
    }

    public void clear() {
        super.clear();
        this.clearFlag = true;
        this.prmtCostCenter.setData(null);
        this.clearFlag = false;
        this.prmtCmpScheme.setData(null);
        this.prmtBgPeriodBegin.setData(null);
        this.prmtBgPeriodEnd.setData(null);
        this.boxBgScheme.setSelectedItem(null);
        this.boxData.setSelectedItem(null);
        this.boxBgItem.removeAllItems();
        this.boxBgItem.setSelectedIndex(-1);
        this.boxData.setEnabled(false);
    }

    protected void boxBgScheme_itemStateChanged(ItemEvent e) throws Exception {
        super.boxBgScheme_itemStateChanged(e);
        this.boxData.setEnabled(true);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (this.boxBgScheme.getSelectedIndex() > -1) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)((CoreBaseInfo)this.boxBgScheme.getSelectedItem()).getId(), CompareType.EQUALS));
            ev.setFilter(filterInfo);
            IServiceLocator service = ServiceLocator.getInstance();
            IBgApi bgApi = (IBgApi)service.lookupService("MA.BD.BgApi");
            CoreBaseCollection bgc = bgApi.getBgFormRemoteInstance().getCollection(ev);
            Vector bgFormVector = new Vector();
            if (bgc.size() > 0) {
                Iterator it = bgc.iterator();
                bgFormVector.clear();
                while (it.hasNext()) {
                    bgFormVector.add(it.next());
                }
            }
            this.boxData.removeAllItems();
            this.boxData.addItems(bgFormVector);
        }
        this.boxData.setSelectedIndex(-1);
    }

    protected void boxData_itemStateChanged(ItemEvent e) throws Exception {
        super.boxData_itemStateChanged(e);
        if (this.boxData.getSelectedIndex() > -1) {
            ICmpBudgetFacade facade = CmpBudgetFacadeFactory.getRemoteInstance();
            HashMap<String, List> bgParams = new HashMap<String, List>();
            bgParams.put("orgList", this.getOrgList());
            bgParams.put("bgFormInfo", (List)this.getBgFormInfo());
            bgParams.put("bgSchemeInfo", (List)this.getBgSchemeInfo());
            bgParams.put("hroIdList", this.hroIdList);
            Map mapInfo = facade.getCmpInfo(bgParams);
            this.prmtCmpScheme.setEnabled(true);
            List itemList = (List)mapInfo.get("itemList");
            List mainDim = (List)mapInfo.get("mainDim");
            this.initCmpItemCombox(itemList);
            this.hasMainDim = mainDim != null && mainDim.size() > 0;
        }
    }

    private void initCmpItemCombox(List itemList) {
        this.boxBgItem.removeAllItems();
        Vector bgItemVector = new Vector();
        if (itemList != null) {
            bgItemVector.addAll(itemList);
        }
        this.boxBgItem.addItems(bgItemVector);
    }

    public CustomerParams getCustomerParams() {
        IBgPeriodApiInfo period;
        CustomerParams cp = new CustomerParams();
        OrgUnitInfo costCenterInfo = (OrgUnitInfo)this.prmtCostCenter.getData();
        cp.addCustomerParam("prmtCostCenter", costCenterInfo.getId().toString());
        if (this.boxBgScheme.getSelectedIndex() > -1 && this.boxBgScheme.getSelectedItem() != null) {
            cp.addCustomerParam("bgScheme", ((CoreBaseInfo)this.boxBgScheme.getSelectedItem()).getId().toString());
        }
        if (this.boxData.getSelectedIndex() > -1 && this.boxData.getSelectedItem() != null) {
            cp.addCustomerParam("bgForm", ((IBgFormApiInfo)this.boxData.getSelectedItem()).getId().toString());
        }
        if (this.prmtBgPeriodBegin.getData() != null) {
            period = (IBgPeriodApiInfo)this.prmtBgPeriodBegin.getData();
            cp.addCustomerParam("BgPeriodBegin", period.getId().toString());
        }
        if (this.prmtBgPeriodEnd.getData() != null) {
            period = (IBgPeriodApiInfo)this.prmtBgPeriodEnd.getData();
            cp.addCustomerParam("BgPeriodEnd", period.getId().toString());
        }
        if (this.boxBgItem.getSelectedIndex() > -1 && this.boxBgItem.getSelectedItem() != null) {
            cp.addCustomerParam("boxBgItem", ((CmpItemInfo)this.boxBgItem.getSelectedItem()).getId().toString());
        }
        if (this.prmtCmpScheme.getData() != null) {
            CmpSchemeInfo[] info = this.getCmpSchemeInfoArrayByObject((Object[])this.prmtCmpScheme.getData());
            CmpSchemeInfo infoTem = null;
            StringBuffer cmpSchemeStr = new StringBuffer();
            int size = info.length;
            for (int i = 0; i < size; ++i) {
                infoTem = info[i];
                if (i == 0) {
                    cmpSchemeStr.append(infoTem.getId().toString());
                    continue;
                }
                cmpSchemeStr.append("~" + infoTem.getId().toString());
            }
            cp.addCustomerParam("prmtCmpScheme", cmpSchemeStr.toString());
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        int i;
        this.clear();
        super.setCustomerParams(cp);
        if (cp == null) {
            return;
        }
        ObjectUuidPK pkTemp = null;
        if (cp.getCustomerParam("prmtCostCenter") != null) {
            pkTemp = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("prmtCostCenter")));
            try {
                CostCenterOrgUnitInfo unit = (CostCenterOrgUnitInfo)CostCenterOrgUnitFactory.getRemoteInstance().getValue((IObjectPK)pkTemp);
                this.prmtCostCenter.setData((Object)unit);
                this.hroIdList = this.getHROrgListInfo();
                this.setBgHroInfo();
                if (this.hroIdList != null && this.hroIdList.size() > 0) {
                    this.changedBgScheme(unit);
                    this.setCmpSchemeInfo();
                    this.rootHroId = this.getRootHroId();
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        IServiceLocator service = ServiceLocator.getInstance();
        IBgApi bgApi = (IBgApi)service.lookupService("MA.BD.BgApi");
        if (cp.getCustomerParam("bgScheme") != null) {
            try {
                CoreBaseInfo bgSchemeInfo = bgApi.getBgSchemeRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("bgScheme"))));
                int bgSchemeCount = this.boxBgScheme.getItemCount();
                int selectedIndex = -1;
                for (i = 0; i < bgSchemeCount; ++i) {
                    if (this.boxBgScheme.getItemAt(i) == null || !(this.boxBgScheme.getItemAt(i) instanceof CoreBaseInfo) || !((CoreBaseInfo)this.boxBgScheme.getItemAt(i)).getId().toString().equals(bgSchemeInfo.getId().toString())) continue;
                    selectedIndex = i;
                }
                this.boxBgScheme.setSelectedIndex(selectedIndex);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (cp.getCustomerParam("bgForm") != null) {
            try {
                this.bgFormInfo = (IBgFormApiInfo)bgApi.getBgFormRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("bgForm"))));
                int bgFormCount = this.boxData.getItemCount();
                int selectedIndex = -1;
                for (int i2 = 0; i2 < bgFormCount; ++i2) {
                    if (this.boxData.getItemAt(i2) == null || !(this.boxData.getItemAt(i2) instanceof IBgFormApiInfo) || !((IBgFormApiInfo)this.boxData.getItemAt(i2)).getId().toString().equals(this.bgFormInfo.getId().toString())) continue;
                    selectedIndex = i2;
                }
                this.boxData.setSelectedIndex(selectedIndex);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (cp.getCustomerParam("BgPeriodBegin") != null) {
            String periodId = cp.getCustomerParam("BgPeriodBegin");
            try {
                CoreBaseInfo period = bgApi.getBgPeriodRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(periodId));
                this.prmtBgPeriodBegin.setData((Object)period);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (cp.getCustomerParam("BgPeriodEnd") != null) {
            String periodId = cp.getCustomerParam("BgPeriodEnd");
            try {
                CoreBaseInfo period = bgApi.getBgPeriodRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(periodId));
                this.prmtBgPeriodEnd.setData((Object)period);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (cp.getCustomerParam("prmtCmpScheme") != null) {
            Set cmpSchemeIdSet = this.formatSetCmpSchemeId(cp.getCustomerParam("prmtCmpScheme"));
            try {
                this.loadCmpScheme(cmpSchemeIdSet);
            }
            catch (CmpReportException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (cp.getCustomerParam("boxBgItem") != null) {
            String bgItemId = cp.getCustomerParam("boxBgItem");
            int bgFormCount = this.boxBgItem.getItemCount();
            int selectedIndex = -1;
            for (i = 0; i < bgFormCount; ++i) {
                CmpItemInfo curItem;
                if (this.boxBgItem.getItemAt(i) == null || !bgItemId.equals((curItem = (CmpItemInfo)this.boxBgItem.getItemAt(i)).getId().toString())) continue;
                selectedIndex = i;
                break;
            }
            this.boxBgItem.setSelectedIndex(selectedIndex);
        }
    }

    private void loadCmpScheme(Set cmpSchemeIdSet) throws CmpReportException {
        CmpSchemeCollection cmpColl = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)cmpSchemeIdSet, CompareType.INCLUDE));
        FilterInfo adminRangeFilter = HRSchemeUtils.getAdminRangeFilter(null, (String)"");
        if (adminRangeFilter != null) {
            try {
                fi.mergeFilter(adminRangeFilter, "and");
            }
            catch (BOSException e) {
                super.handUIException((Throwable)e);
            }
        }
        viewInfo.setFilter(fi);
        try {
            cmpColl = CmpSchemeFactory.getRemoteInstance().getSchemeCollNoDataPermission(viewInfo);
            CmpSchemeInfo[] cmpSchemeArr = new CmpSchemeInfo[cmpColl.size()];
            int size = cmpColl.size();
            for (int i = 0; i < size; ++i) {
                cmpSchemeArr[i] = cmpColl.get(i);
            }
            this.prmtCmpScheme.setData((Object)cmpSchemeArr);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (cmpColl == null || cmpColl.size() != cmpSchemeIdSet.size()) {
            SysUtil.abort();
        }
    }

    private Set formatSetCmpSchemeId(String cmpSchemeStr) {
        String[] idArr = cmpSchemeStr.split("~");
        HashSet<String> set = new HashSet<String>();
        int size = idArr.length;
        for (int i = 0; i < size; ++i) {
            set.add(idArr[i]);
        }
        return set;
    }

    protected CmpSchemeInfo[] getCmpSchemeInfoArrayByObject(Object[] objA) {
        if (objA == null || objA.length == 0) {
            return null;
        }
        CmpSchemeInfo[] info = new CmpSchemeInfo[objA.length];
        int size = objA.length;
        for (int i = 0; i < size; ++i) {
            info[i] = (CmpSchemeInfo)objA[i];
        }
        return info;
    }

    public Set getCmpScheme() {
        HashSet<CmpSchemeInfo> schemeList = new HashSet<CmpSchemeInfo>();
        if (this.prmtCmpScheme.getData() != null) {
            CmpSchemeInfo[] info = this.getCmpSchemeInfoArrayByObject((Object[])this.prmtCmpScheme.getData());
            CmpSchemeInfo infoTem2 = null;
            if (info == null) {
                return schemeList;
            }
            for (CmpSchemeInfo infoTem2 : info) {
                schemeList.add(infoTem2);
            }
        }
        return schemeList;
    }

    public List getCmpItemList() {
        ArrayList<CmpItemInfo> itemList = new ArrayList<CmpItemInfo>();
        CmpItemInfo item = (CmpItemInfo)this.boxBgItem.getSelectedItem();
        itemList.add(item);
        return itemList;
    }

    protected String getHROrgUnitIDByUserPermssion() throws Exception {
        List orgList = HRSchemeUtils.getHROrgUnitOfUserPermission(null);
        return HRUtils.getParentOrgId(null, (List)orgList, (int)1);
    }

    public List getOrgList() {
        Object orgUnit = this.prmtCostCenter.getData();
        this.orgList.clear();
        if (orgUnit != null) {
            this.orgList.add(orgUnit);
        }
        return this.orgList;
    }

    private ICmpBudgetFacade getBizfacadeInterface() throws BOSException {
        if (this.bgcFacade == null) {
            this.bgcFacade = CmpBudgetFacadeFactory.getRemoteInstance();
        }
        return this.bgcFacade;
    }

    public IBgFormApiInfo getBgFormInfo() {
        if (this.boxData.getSelectedItem() != null) {
            this.bgFormInfo = (IBgFormApiInfo)this.boxData.getSelectedItem();
        }
        return this.bgFormInfo;
    }

    public CoreBaseInfo getBgSchemeInfo() {
        CoreBaseInfo bgSchemeInfo = null;
        if (this.boxBgScheme.getSelectedItem() != null) {
            bgSchemeInfo = (CoreBaseInfo)this.boxBgScheme.getSelectedItem();
        }
        return bgSchemeInfo;
    }

    public IBgPeriodApiInfo getBeginBgPeriod() {
        IBgPeriodApiInfo period = (IBgPeriodApiInfo)this.prmtBgPeriodBegin.getData();
        return period;
    }

    public IBgPeriodApiInfo getEndBgPeriod() {
        IBgPeriodApiInfo period = (IBgPeriodApiInfo)this.prmtBgPeriodEnd.getData();
        return period;
    }

    public String getRootHroId() throws BOSException, SQLException {
        return this.rootHroId;
    }

    public IObjectCollection getBgPeriodInfo() throws EASBizException, BOSException {
        IBgPeriodApiInfo beginperiod = this.getBeginBgPeriod();
        IBgPeriodApiInfo endperiod = this.getEndBgPeriod();
        IServiceLocator service = ServiceLocator.getInstance();
        IBgApi bgApi = (IBgApi)service.lookupService("MA.BD.BgApi");
        IObjectCollection bgPeriodCol = bgApi.getPeriodColInfo(beginperiod.getPeriodTypeEnum().getValue(), beginperiod.getBeginDate(), endperiod.getEndDate());
        return bgPeriodCol;
    }
}

