/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bsf.IServiceLocator;
import com.kingdee.bos.bsf.service.ServiceLocator;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.compensation.BgDimItemInfo;
import com.kingdee.eas.hr.compensation.CmpBudgetFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ICmpBudgetFacade;
import com.kingdee.eas.hr.compensation.client.AbstractCmpBudgetReportFilterUI;
import com.kingdee.eas.hr.compensation.util.HRReportUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.ma.budget.client.BgCostCenterOrgViewF7;
import com.kingdee.eas.ma.nbudget.BgDimPromptBox;
import com.kingdee.eas.ma.nbudget.IBgApi;
import com.kingdee.eas.ma.nbudget.IBgFormApiInfo;
import com.kingdee.eas.ma.nbudget.IBgPeriodApiInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import org.apache.log4j.Logger;

public class CmpBudgetReportFilterUI
extends AbstractCmpBudgetReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CmpBudgetReportFilterUI.class);
    private String resClass = "com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.";
    private ICmpBudgetFacade bgcFacade = null;
    private boolean isFirst = true;
    private boolean isDataFirst = true;
    private CmpPeriodInfo[] cpis = null;
    private IBgFormApiInfo bgFormInfo = null;
    private Set cmpScheme = new HashSet();
    private List hroIdList = new ArrayList();
    private List orgList = new ArrayList();
    private String rootHroId = null;
    private boolean clearFlag = false;
    private IServiceLocator service = ServiceLocator.getInstance();

    public void onLoad() throws Exception {
        super.onLoad();
        this.initWidget();
        this.initBgContainer();
        this.initBgPeriod();
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void initBgPeriod() throws Exception {
        IBgApi iBgApi = (IBgApi)this.service.lookupService("MA.BD.BgApi");
        KDPromptSelector bgPeriodDialog = iBgApi.getBgPeriodDialog((CoreUIObject)this);
        this.prmtBgPeriodBegin.setSelector(bgPeriodDialog);
        this.prmtBgPeriodEnd.setSelector(bgPeriodDialog);
        this.prmtBgPeriodBegin.setEditable(false);
        this.prmtBgPeriodEnd.setEditable(false);
    }

    private ICmpBudgetFacade getBizfacadeInterface() throws BOSException {
        if (this.bgcFacade == null) {
            this.bgcFacade = CmpBudgetFacadeFactory.getRemoteInstance();
        }
        return this.bgcFacade;
    }

    public void clear() {
        super.clear();
        this.clearFlag = true;
        this.prmtOrgUnit.setData(null);
        this.clearFlag = false;
        this.boxBgScheme.removeAllItems();
        this.boxBgScheme.setSelectedIndex(-1);
        this.boxBgScheme.setEnabled(false);
        this.boxData.removeAllItems();
        this.boxData.setEnabled(false);
        this.boxData.setSelectedIndex(-1);
        this.boxMainDim.removeAllItems();
        this.boxMainDim.setSelectedIndex(-1);
        this.boxDimItem.setData(null);
        this.prmtBgPeriodBegin.setData(null);
        this.prmtBgPeriodEnd.setData(null);
        this.listCmpSchemeAll.removeAllElements();
        this.listCmpItemAll.removeAllElements();
        this.boxDimItem.setEnabled(false);
        this.clearCmpInfo();
    }

    public void commonClear() {
        this.boxMainDim.removeAllItems();
        this.boxMainDim.setSelectedIndex(-1);
        this.boxDimItem.setData(null);
        this.prmtBgPeriodBegin.setData(null);
        this.prmtBgPeriodEnd.setData(null);
        this.listCmpSchemeAll.removeAllElements();
        this.listCmpItemAll.removeAllElements();
        this.clearCmpInfo();
    }

    private void clearCmpInfo() {
        this.listCmpSchemSelected.removeAllElements();
        this.listCmpItemSelected.removeAllElements();
    }

    public CustomerParams getCustomerParams() {
        IBgPeriodApiInfo period;
        int i;
        Object[] ogs;
        CustomerParams cp = new CustomerParams();
        Object value = this.prmtOrgUnit.getValue();
        if (value != null && value instanceof Object[] && (ogs = (Object[])value).length > 0 && ogs[0] != null) {
            StringBuffer orgUnits = new StringBuffer();
            for (i = 0; i < ogs.length - 1; ++i) {
                orgUnits.append(((OrgUnitInfo)ogs[i]).getId().toString());
                orgUnits.append("\u2014\u2014");
            }
            orgUnits.append(((OrgUnitInfo)ogs[i]).getId().toString());
            cp.addCustomerParam("prmtOrgUnit", orgUnits.toString());
        }
        if (this.boxBgScheme.getSelectedIndex() > -1 && this.boxBgScheme.getSelectedItem() != null) {
            cp.addCustomerParam("bgScheme", ((CoreBaseInfo)this.boxBgScheme.getSelectedItem()).getId().toString());
        }
        if (this.boxData.getSelectedIndex() > -1 && this.boxData.getSelectedItem() != null) {
            cp.addCustomerParam("bgForm", ((CoreBaseInfo)this.boxData.getSelectedItem()).getId().toString());
        }
        if (this.boxMainDim.getSelectedIndex() > -1 && this.boxMainDim.getSelectedItem() != null) {
            cp.addCustomerParam("mainDim", ((BgDimItemInfo)this.boxMainDim.getSelectedItem()).getBosType());
        }
        if (this.boxDimItem.getData() != null) {
            List dimItemList = this.getDimList();
            StringBuffer dimNumBuf = new StringBuffer();
            int n = dimItemList.size();
            for (i = 0; i < n; ++i) {
                String bgItemNum = (String)dimItemList.get(i);
                if (i == 0) {
                    dimNumBuf.append(bgItemNum);
                    continue;
                }
                dimNumBuf.append("\u2014\u2014").append(bgItemNum);
            }
            cp.addCustomerParam("dimItem", dimNumBuf.toString());
        }
        if (this.prmtBgPeriodBegin.getData() != null) {
            period = (IBgPeriodApiInfo)this.prmtBgPeriodBegin.getData();
            cp.addCustomerParam("BgPeriodBegin", period.getId().toString());
        }
        if (this.prmtBgPeriodEnd.getData() != null) {
            period = (IBgPeriodApiInfo)this.prmtBgPeriodEnd.getData();
            cp.addCustomerParam("BgPeriodEnd", period.getId().toString());
        }
        String lstSchemeIds = null;
        lstSchemeIds = HRUtils.getListSchemeIDs((Set)this.getIdSetSelectItemElement(this.listCmpSchemeAll));
        if (lstSchemeIds != null && lstSchemeIds.length() > 0) {
            cp.addCustomerParam("listCmpSchemeAll", lstSchemeIds);
        }
        if ((lstSchemeIds = HRUtils.getListSchemeIDs((Set)this.getIdSetSelectItemElement(this.listCmpSchemSelected))) != null && lstSchemeIds.length() > 0) {
            cp.addCustomerParam("listCmpSchemSelected", lstSchemeIds);
        }
        String lstCmpItemIds = null;
        lstCmpItemIds = HRUtils.getListSchemeIDs((Set)this.getIdSetSelectItemElement(this.listCmpItemAll));
        if (lstCmpItemIds != null && lstCmpItemIds.length() > 0) {
            cp.addCustomerParam("listCmpItemAll", lstCmpItemIds);
        }
        if ((lstCmpItemIds = HRUtils.getListSchemeIDs((Set)this.getIdSetSelectItemElement(this.listCmpItemSelected))) != null && lstCmpItemIds.length() > 0) {
            cp.addCustomerParam("listCmpItemSelected", lstCmpItemIds);
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        this.clear();
        super.setCustomerParams(cp);
        if (cp == null) {
            return;
        }
        String value = cp.getCustomerParam("prmtOrgUnit");
        if (value != null) {
            EntityViewInfo evi = new EntityViewInfo();
            String[] org = StringUtils.split((String)value, (String)"\u2014\u2014");
            try {
                ICostCenterOrgUnit iOrgUnit = CostCenterOrgUnitFactory.getRemoteInstance();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", new LinkedHashSet<String>(Arrays.asList(org)), CompareType.INCLUDE));
                evi.setFilter(fi);
                OrgUnitCollection col = iOrgUnit.getOrgUnitCollection(evi);
                this.prmtOrgUnit.setValue((Object)col.toArray());
                this.hroIdList = this.getHROrgListInfo();
                this.rootHroId = this.getRootHroId();
                this.changedBgScheme(col.toArray());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        IServiceLocator service = ServiceLocator.getInstance();
        IBgApi bgApi = (IBgApi)service.lookupService("MA.BD.BgApi");
        if (cp.getCustomerParam("bgScheme") != null) {
            try {
                DataBaseInfo bgSchemeInfo = bgApi.getBgSchemeRemoteInstance().getDataBaseInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("bgScheme"))));
                int bgSchemeCount = this.boxBgScheme.getItemCount();
                int selectedIndex = -1;
                for (int i = 0; i < bgSchemeCount; ++i) {
                    if (this.boxBgScheme.getItemAt(i) == null || !(this.boxBgScheme.getItemAt(i) instanceof CoreBaseInfo) || !((CoreBaseInfo)this.boxBgScheme.getItemAt(i)).getId().toString().equals(bgSchemeInfo.getId().toString())) continue;
                    selectedIndex = i;
                }
                this.boxBgScheme.setSelectedIndex(selectedIndex);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (cp.getCustomerParam("bgForm") != null) {
            try {
                this.bgFormInfo = (IBgFormApiInfo)bgApi.getBgFormRemoteInstance().getObjectBaseInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("bgForm"))));
                int bgFormCount = this.boxData.getItemCount();
                int selectedIndex = -1;
                for (int i = 0; i < bgFormCount; ++i) {
                    if (this.boxData.getItemAt(i) == null || !(this.boxData.getItemAt(i) instanceof CoreBaseInfo) || !((CoreBaseInfo)this.boxData.getItemAt(i)).getId().toString().equals(this.bgFormInfo.getId().toString())) continue;
                    selectedIndex = i;
                }
                this.boxData.setSelectedIndex(selectedIndex);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (cp.getCustomerParam("mainDim") != null) {
            String mainDimBosType = cp.getCustomerParam("mainDim");
            ComboBoxModel boxModel = this.boxMainDim.getModel();
            int size = boxModel.getSize();
            for (int i = 0; i < size; ++i) {
                BgDimItemInfo dtInfo = (BgDimItemInfo)boxModel.getElementAt(i);
                if (!mainDimBosType.equals(dtInfo.getBosType())) continue;
                this.boxMainDim.setSelectedIndex(i);
            }
            if (this.boxMainDim.getSelectedIndex() == -1) {
                this.boxDimItem.setEnabled(false);
            }
        } else {
            this.boxDimItem.setEnabled(false);
        }
        if (cp.getCustomerParam("dimItem") != null) {
            String dimItemStr = cp.getCustomerParam("dimItem");
            String[] dimItems = StringUtils.split((String)dimItemStr, (String)"\u2014\u2014");
            List<String> dimItemList = Arrays.asList(dimItems);
            StringBuffer oql = new StringBuffer();
            oql.append("select * where number in ").append(HRSchemeUtils.getStrFromList(dimItemList));
            try {
                CoreBaseCollection coll = bgApi.getBgItemRemoteInstance().getCollection(oql.toString());
                if (coll != null && coll.size() > 0) {
                    CoreBaseInfo[] bgItems = new CoreBaseInfo[coll.size()];
                    int n = coll.size();
                    for (int i = 0; i < n; ++i) {
                        bgItems[i] = coll.get(i);
                    }
                    this.boxDimItem.setData((Object)bgItems);
                } else {
                    this.boxDimItem.setData(null);
                }
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (cp.getCustomerParam("BgPeriodBegin") != null) {
            String periodId = cp.getCustomerParam("BgPeriodBegin");
            try {
                CoreBaseInfo period = bgApi.getBgPeriodRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(periodId));
                this.prmtBgPeriodBegin.setData((Object)period);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (cp.getCustomerParam("BgPeriodEnd") != null) {
            String periodId = cp.getCustomerParam("BgPeriodEnd");
            try {
                CoreBaseInfo period = bgApi.getBgPeriodRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(periodId));
                this.prmtBgPeriodEnd.setData((Object)period);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (cp.getCustomerParam("listCmpSchemeAll") != null) {
            Object[] cmpSchemeInfos = HRUtils.getCmpSchemeInfosFromCustomerParam((String)cp.getCustomerParam("listCmpSchemeAll"));
            this.fillListData(this.listCmpSchemeAll, cmpSchemeInfos);
        } else {
            this.listCmpSchemeAll.removeAllElements();
        }
        if (cp.getCustomerParam("listCmpSchemSelected") != null) {
            Object[] cmpSchemeInfos = HRUtils.getCmpSchemeInfosFromCustomerParam((String)cp.getCustomerParam("listCmpSchemSelected"));
            if (cmpSchemeInfos != null) {
                for (int i = 0; i < cmpSchemeInfos.length; ++i) {
                    this.cmpScheme.add(cmpSchemeInfos[i]);
                }
            }
            this.fillListData(this.listCmpSchemSelected, cmpSchemeInfos);
        }
        if (cp.getCustomerParam("listCmpItemAll") != null) {
            Object[] cmpItemInfos = HRUtils.getCmpItemInfosFromCustomerParam((String)cp.getCustomerParam("listCmpItemAll"));
            this.fillListData(this.listCmpItemAll, cmpItemInfos);
        } else {
            this.listCmpItemAll.removeAllElements();
        }
        if (cp.getCustomerParam("listCmpItemSelected") != null) {
            Object[] cmpItemInfos = HRUtils.getCmpItemInfosFromCustomerParam((String)cp.getCustomerParam("listCmpItemSelected"));
            this.fillListData(this.listCmpItemSelected, cmpItemInfos);
        }
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", null, CompareType.NOTEQUALS));
        return filter;
    }

    public boolean verify() {
        boolean verf = true;
        if (this.prmtOrgUnit.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"181_CmpBudgetCompareChartFilterUI"));
            return false;
        }
        if (this.boxBgScheme.getSelectedIndex() < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "SELECT_BGSCHEME")));
            return false;
        }
        if (this.boxData.getSelectedIndex() < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "SELECT_BGFORM")));
            return false;
        }
        if (this.prmtBgPeriodBegin.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"182_CmpBudgetCompareChartFilterUI"));
            return false;
        }
        if (this.prmtBgPeriodEnd.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"183_CmpBudgetCompareChartFilterUI"));
            return false;
        }
        if (this.prmtBgPeriodBegin.getData() != null && this.prmtBgPeriodEnd.getData() != null) {
            IBgPeriodApiInfo _begin = null;
            IBgPeriodApiInfo _end = null;
            _begin = (IBgPeriodApiInfo)this.prmtBgPeriodBegin.getData();
            _end = (IBgPeriodApiInfo)this.prmtBgPeriodEnd.getData();
            if (_begin.getPeriodTypeEnum().getValue() != _end.getPeriodTypeEnum().getValue()) {
                MsgBox.showWarning((String)EASResource.getString((String)(this.resClass + "selectBgPeriodNoAccord")));
                return false;
            }
        }
        if (this.boxMainDim.getSelectedItem() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"191_CmpBudgetReportFilterUI"));
            return false;
        }
        if (this.listCmpSchemSelected.getElementCount() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "SELECT_CMPSCHEME")));
            return false;
        }
        if (this.listCmpItemSelected.getSelectedIndex() == -1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"192_CmpBudgetReportFilterUI"));
            return false;
        }
        if (!verf) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "SELECT_CMPITEM")));
        }
        return verf;
    }

    private void initWorkButton() throws Exception {
        this.btnMoveTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnMovePre.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveNext.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.btnAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.itemMoveTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.itemMovePre.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.itemMoveNext.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.itemMoveBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.itemAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.itemRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.itemAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.itemLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
    }

    private void initBgContainer() throws BOSException {
        this.boxBgScheme.setRequired(true);
        this.boxData.setRequired(true);
        this.setEnableListButton(true);
        BgCostCenterOrgViewF7 orgView = new BgCostCenterOrgViewF7((IUIObject)this);
        orgView.setTitle(EASResource.getString((String)(this.resClass + "orgUnitTitle")));
        orgView.setReturnSuperior(false);
        orgView.setMultiSelect(true);
        this.prmtOrgUnit.setDisplayFormat("$name$");
        this.prmtOrgUnit.setEditable(false);
        if (this.ui != null) {
            orgView.setUIActionPK((IMetaDataPK)new MetaDataPK(this.ui.getClass().getName()), (IMetaDataPK)new MetaDataPK("ActionOnLoad"));
        }
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgView);
        this.prmtOrgUnit.setRequired(true);
        this.prmtOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                CmpBudgetReportFilterUI.this.getBgHroInfo();
                CmpBudgetReportFilterUI.this.changedBgScheme(eventObj.getNewValue());
            }
        });
        this.boxMainDim.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent arg0) {
                CmpBudgetReportFilterUI.this.boxDimItem.setData(null);
                if (CmpBudgetReportFilterUI.this.bgFormInfo != null) {
                    String orgUnitID = CmpBudgetReportFilterUI.this.bgFormInfo.getOrgUnit().getId().toString();
                    String bosType = null;
                    if (CmpBudgetReportFilterUI.this.boxMainDim.getSelectedItem() != null) {
                        bosType = ((BgDimItemInfo)CmpBudgetReportFilterUI.this.boxMainDim.getSelectedItem()).getBosType();
                        BgDimPromptBox bg = new BgDimPromptBox(orgUnitID, bosType, true);
                        CmpBudgetReportFilterUI.this.boxDimItem.setSelector((KDPromptSelector)bg);
                        CmpBudgetReportFilterUI.this.boxDimItem.setEnabledMultiSelection(true);
                        CmpBudgetReportFilterUI.this.boxDimItem.setDisplayFormat("$name$");
                        CmpBudgetReportFilterUI.this.boxDimItem.setEnabled(true);
                        CmpBudgetReportFilterUI.this.boxDimItem.setEditable(false);
                    }
                }
            }
        });
    }

    private void changedBgScheme(Object object) {
        if (object == null) {
            return;
        }
        try {
            this.boxBgScheme.removeAllItems();
            if (object instanceof CostCenterOrgUnitInfo && ((CostCenterOrgUnitInfo)object).getId() != null) {
                IObjectCollection bgSchemeCols = this.getBizfacadeInterface().getBgScheme("'" + ((CostCenterOrgUnitInfo)object).getId() + "'");
                Vector bgSchemeVector = new Vector();
                if (bgSchemeCols != null && bgSchemeCols.size() > 0) {
                    Iterator it = bgSchemeCols.iterator();
                    bgSchemeVector.clear();
                    while (it.hasNext()) {
                        bgSchemeVector.add(it.next());
                    }
                }
                this.boxBgScheme.setEnabled(true);
                this.boxBgScheme.addItems(bgSchemeVector);
                this.boxBgScheme.setSelectedIndex(-1);
                this.boxData.removeAllItems();
            }
            if (object instanceof Object[]) {
                Object[] objArray = (Object[])object;
                OrgUnitInfo[] orgUnits = new OrgUnitInfo[objArray.length];
                int n = objArray.length;
                for (int i = 0; i < n; ++i) {
                    orgUnits[i] = (OrgUnitInfo)objArray[i];
                }
                StringBuffer objectIds = new StringBuffer();
                int n2 = orgUnits.length;
                for (int i = 0; i < n2; ++i) {
                    if (i == 0) {
                        objectIds.append("'").append(orgUnits[i].getId().toString()).append("'");
                        continue;
                    }
                    objectIds.append(",").append("'").append(orgUnits[i].getId().toString()).append("'");
                }
                if (!StringUtils.isEmpty((String)objectIds.toString())) {
                    ICmpBudgetFacade bgcFacade = this.getBizfacadeInterface();
                    IObjectCollection bgSchemeCols = bgcFacade.getBgScheme(objectIds.toString());
                    Vector bgSchemeVector = new Vector();
                    if (bgSchemeCols != null && bgSchemeCols.size() > 0) {
                        Iterator it = bgSchemeCols.iterator();
                        bgSchemeVector.clear();
                        while (it.hasNext()) {
                            bgSchemeVector.add(it.next());
                        }
                    }
                    this.boxBgScheme.setEnabled(true);
                    this.boxBgScheme.addItems(bgSchemeVector);
                    this.boxBgScheme.setSelectedIndex(-1);
                    this.boxData.removeAllItems();
                } else {
                    this.boxBgScheme.addItem(null);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void setEnableListButton(boolean isEnable) {
        this.btnMoveTop.setEnabled(isEnable);
        this.btnMovePre.setEnabled(isEnable);
        this.btnMoveNext.setEnabled(isEnable);
        this.btnMoveBottom.setEnabled(isEnable);
        this.btnAllRight.setEnabled(isEnable);
        this.btnRight.setEnabled(isEnable);
        this.btnAllLeft.setEnabled(isEnable);
        this.btnLeft.setEnabled(isEnable);
        this.itemMoveTop.setEnabled(isEnable);
        this.itemMovePre.setEnabled(isEnable);
        this.itemMoveNext.setEnabled(isEnable);
        this.itemMoveBottom.setEnabled(isEnable);
        this.itemAllRight.setEnabled(isEnable);
        this.itemRight.setEnabled(isEnable);
        this.itemAllLeft.setEnabled(isEnable);
        this.itemLeft.setEnabled(isEnable);
    }

    private void initWidget() throws Exception {
        this.initWorkButton();
        this.boxData.setSelectedIndex(-1);
        this.boxBgScheme.setEnabled(false);
        this.boxData.setEnabled(false);
        this.boxDimItem.setEnabled(false);
    }

    protected void boxBgScheme_itemStateChanged(ItemEvent e) throws Exception {
        super.boxBgScheme_itemStateChanged(e);
        this.boxData.setEnabled(true);
        this.boxData.removeAllItems();
        this.commonClear();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (this.boxBgScheme.getSelectedIndex() > -1 && !this.isFirst) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)((CoreBaseInfo)this.boxBgScheme.getSelectedItem()).getId(), CompareType.EQUALS));
            ev.setFilter(filterInfo);
            IServiceLocator service = ServiceLocator.getInstance();
            IBgApi bgApi = (IBgApi)service.lookupService("MA.BD.BgApi");
            CoreBaseCollection bgc = bgApi.getBgFormRemoteInstance().getCollection(ev);
            Vector bgFormVector = new Vector();
            if (bgc.size() > 0) {
                Iterator it = bgc.iterator();
                bgFormVector.clear();
                while (it.hasNext()) {
                    bgFormVector.add(it.next());
                }
            }
            this.boxData.removeAllItems();
            this.boxData.addItems(bgFormVector);
        }
        this.boxData.setSelectedIndex(-1);
        this.isFirst = false;
    }

    protected void boxData_itemStateChanged(ItemEvent e) throws Exception {
        super.boxData_itemStateChanged(e);
        this.commonClear();
        if (this.boxData.getSelectedIndex() > -1 && !this.isDataFirst) {
            ICmpBudgetFacade facade = CmpBudgetFacadeFactory.getRemoteInstance();
            HashMap<String, List> bgParams = new HashMap<String, List>();
            bgParams.put("orgList", this.getOrgList());
            bgParams.put("bgFormInfo", (List)this.getBgFormInfo());
            bgParams.put("bgSchemeInfo", (List)this.getBgSchemeInfo());
            bgParams.put("hroIdList", this.hroIdList);
            if (this.hroIdList != null && this.hroIdList.size() > 0) {
                Map mapInfo = facade.getCmpInfo(bgParams);
                List schmList = (List)mapInfo.get("schmList");
                this.initListCmpSchemeAll(schmList);
                List itemList = (List)mapInfo.get("itemList");
                this.initListCmpItemAll(itemList);
                List mainDim = (List)mapInfo.get("mainDim");
                this.rootHroId = (String)mapInfo.get("rootHroId");
                if (mainDim == null || mainDim == null || mainDim.size() == 0) {
                    // empty if block
                }
                this.initListMainDim(mainDim);
            }
        }
        this.isDataFirst = false;
    }

    private void initListCmpSchemeAll(List cmpSchemeList) throws Exception {
        if (cmpSchemeList != null && cmpSchemeList.size() > 0) {
            this.listCmpSchemeAll.removeAllElements();
            int size = cmpSchemeList.size();
            for (int i = 0; i < size; ++i) {
                this.listCmpSchemeAll.addElement(cmpSchemeList.get(i));
            }
            this.listCmpSchemeAll.setSelectedIndex(0);
        }
    }

    private void initListCmpItemAll(List cmpItemList) throws Exception {
        if (cmpItemList != null && cmpItemList.size() > 0) {
            this.listCmpItemAll.removeAllElements();
            int size = cmpItemList.size();
            for (int i = 0; i < size; ++i) {
                this.listCmpItemAll.addElement(cmpItemList.get(i));
            }
            this.listCmpItemAll.setSelectedIndex(0);
        }
    }

    private void initListMainDim(List mainDim) throws Exception {
        this.boxMainDim.removeAllItems();
        this.boxDimItem.setEnabled(false);
        if (mainDim != null && mainDim.size() > 0) {
            mainDim = HRReportUtils.getDataBaseByBosType((List)mainDim);
            Vector mainDimVector = new Vector();
            mainDimVector.addAll(mainDim);
            this.boxMainDim.addItems(mainDimVector);
            if (mainDimVector.size() > 0) {
                this.boxMainDim.setSelectedIndex(0);
            } else {
                this.boxMainDim.setSelectedIndex(-1);
            }
        }
    }

    public void actionAllLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionAllLeft_actionPerformed(e);
        int count = this.listCmpSchemSelected.getElementCount();
        if (count > 0) {
            CmpSchemeInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpSchemeInfo)this.listCmpSchemSelected.getElement(0);
                this.listCmpSchemeAll.addElement((Object)info);
                this.listCmpSchemSelected.removeElement((Object)info);
            }
            this.listCmpSchemeAll.setSelectedIndex(0);
        }
    }

    public void actionAllRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionAllRight_actionPerformed(e);
        int count = this.listCmpSchemeAll.getElementCount();
        if (count > 0) {
            CmpSchemeInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpSchemeInfo)this.listCmpSchemeAll.getElement(0);
                this.listCmpSchemSelected.addElement((Object)info);
                this.listCmpSchemeAll.removeElement((Object)info);
            }
            this.listCmpSchemSelected.setSelectedIndex(0);
        }
    }

    public void actionLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionLeft_actionPerformed(e);
        if (this.listCmpSchemSelected.getElementCount() <= 0) {
            return;
        }
        int index = this.listCmpSchemSelected.getSelectedIndex();
        if (index >= 0) {
            CmpSchemeInfo info = (CmpSchemeInfo)this.listCmpSchemSelected.getElement(index);
            this.listCmpSchemSelected.removeElement((Object)info);
            this.listCmpSchemeAll.addElement((Object)info);
            this.listCmpSchemeAll.setSelectedValue((Object)info, true);
            if (this.listCmpSchemSelected.getElementCount() > 0) {
                this.listCmpSchemSelected.setSelectedIndex(index - 1);
            }
        }
    }

    public void actionRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionRight_actionPerformed(e);
        if (this.listCmpSchemeAll.getElementCount() <= 0) {
            return;
        }
        int index = this.listCmpSchemeAll.getSelectedIndex();
        if (index >= 0) {
            CmpSchemeInfo info = (CmpSchemeInfo)this.listCmpSchemeAll.getElement(index);
            int indexSelect = this.listCmpSchemSelected.getSelectedIndex() + 1;
            this.listCmpSchemSelected.insertElement((Object)info, indexSelect);
            this.listCmpSchemeAll.removeElement((Object)info);
            if (index - 1 > 0) {
                this.listCmpSchemeAll.setSelectedIndex(index - 1);
            } else if (this.listCmpSchemeAll.getElementCount() > 0) {
                this.listCmpSchemeAll.setSelectedIndex(0);
            }
            this.listCmpSchemSelected.setSelectedValue((Object)info, true);
        }
    }

    public void actionMoveTop_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveTop_actionPerformed(e);
        int index = this.listCmpSchemSelected.getSelectedIndex();
        if (index > 0) {
            CmpSchemeInfo info = (CmpSchemeInfo)this.listCmpSchemSelected.getElement(index);
            this.listCmpSchemSelected.removeElementAt(index);
            this.listCmpSchemSelected.insertElement((Object)info, 0);
            this.listCmpSchemSelected.setSelectedIndex(0);
        }
    }

    public void actionMovePre_actionPerformed(ActionEvent e) throws Exception {
        super.actionMovePre_actionPerformed(e);
        int index = this.listCmpSchemSelected.getSelectedIndex();
        if (index > 0) {
            CmpSchemeInfo info = (CmpSchemeInfo)this.listCmpSchemSelected.getElement(index);
            this.listCmpSchemSelected.removeElementAt(index);
            this.listCmpSchemSelected.insertElement((Object)info, index - 1);
            this.listCmpSchemSelected.setSelectedIndex(index - 1);
        }
    }

    public void actionMoveNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveNext_actionPerformed(e);
        int index = this.listCmpSchemSelected.getSelectedIndex();
        int count = this.listCmpSchemSelected.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpSchemeInfo info = (CmpSchemeInfo)this.listCmpSchemSelected.getElement(index);
            this.listCmpSchemSelected.removeElementAt(index);
            this.listCmpSchemSelected.insertElement((Object)info, index + 1);
            this.listCmpSchemSelected.setSelectedIndex(index + 1);
        }
    }

    public void actionMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveBottom_actionPerformed(e);
        int index = this.listCmpSchemSelected.getSelectedIndex();
        int count = this.listCmpSchemSelected.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpSchemeInfo info = (CmpSchemeInfo)this.listCmpSchemSelected.getElement(index);
            this.listCmpSchemSelected.removeElementAt(index);
            this.listCmpSchemSelected.insertElement((Object)info, count - 1);
            this.listCmpSchemSelected.setSelectedIndex(count - 1);
        }
    }

    public void actionItemAllLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionAllLeft_actionPerformed(e);
        int count = this.listCmpItemSelected.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.listCmpItemSelected.getElement(0);
                this.listCmpItemAll.addElement((Object)info);
                this.listCmpItemSelected.removeElement((Object)info);
            }
            this.listCmpItemAll.setSelectedIndex(0);
        }
    }

    public void actionItemAllRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionAllRight_actionPerformed(e);
        int count = this.listCmpItemAll.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.listCmpItemAll.getElement(0);
                this.listCmpItemSelected.addElement((Object)info);
                this.listCmpItemAll.removeElement((Object)info);
            }
            this.listCmpItemSelected.setSelectedIndex(0);
        }
    }

    public void actionItemLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionLeft_actionPerformed(e);
        if (this.listCmpItemSelected.getElementCount() <= 0) {
            return;
        }
        int index = this.listCmpItemSelected.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.listCmpItemSelected.getElement(index);
            this.listCmpItemSelected.removeElement((Object)info);
            this.listCmpItemAll.addElement((Object)info);
            this.listCmpItemAll.setSelectedValue((Object)info, true);
            if (this.listCmpItemSelected.getElementCount() > 0) {
                this.listCmpItemSelected.setSelectedIndex(index - 1);
            }
        }
    }

    public void actionItemRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionRight_actionPerformed(e);
        if (this.listCmpItemAll.getElementCount() <= 0) {
            return;
        }
        int index = this.listCmpItemAll.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.listCmpItemAll.getElement(index);
            int indexSelect = this.listCmpItemSelected.getSelectedIndex() + 1;
            this.listCmpItemSelected.insertElement((Object)info, indexSelect);
            this.listCmpItemAll.removeElement((Object)info);
            if (index - 1 > 0) {
                this.listCmpSchemeAll.setSelectedIndex(index - 1);
            } else if (this.listCmpItemAll.getElementCount() > 0) {
                this.listCmpItemAll.setSelectedIndex(0);
            }
            this.listCmpItemSelected.setSelectedValue((Object)info, true);
        }
    }

    public void actionItemMoveTop_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveTop_actionPerformed(e);
        int index = this.listCmpItemSelected.getSelectedIndex();
        if (index > 0) {
            CmpItemInfo info = (CmpItemInfo)this.listCmpItemSelected.getElement(index);
            this.listCmpItemSelected.removeElementAt(index);
            this.listCmpItemSelected.insertElement((Object)info, 0);
            this.listCmpItemSelected.setSelectedIndex(0);
        }
    }

    public void actionItemMovePre_actionPerformed(ActionEvent e) throws Exception {
        super.actionMovePre_actionPerformed(e);
        int index = this.listCmpItemSelected.getSelectedIndex();
        if (index > 0) {
            CmpItemInfo info = (CmpItemInfo)this.listCmpItemSelected.getElement(index);
            this.listCmpItemSelected.removeElementAt(index);
            this.listCmpItemSelected.insertElement((Object)info, index - 1);
            this.listCmpItemSelected.setSelectedIndex(index - 1);
        }
    }

    public void actionItemMoveNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveNext_actionPerformed(e);
        int index = this.listCmpItemSelected.getSelectedIndex();
        int count = this.listCmpItemSelected.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpItemInfo info = (CmpItemInfo)this.listCmpItemSelected.getElement(index);
            this.listCmpItemSelected.removeElementAt(index);
            this.listCmpItemSelected.insertElement((Object)info, index + 1);
            this.listCmpItemSelected.setSelectedIndex(index + 1);
        }
    }

    public void actionItemMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveBottom_actionPerformed(e);
        int index = this.listCmpItemSelected.getSelectedIndex();
        int count = this.listCmpItemSelected.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpItemInfo info = (CmpItemInfo)this.listCmpItemSelected.getElement(index);
            this.listCmpItemSelected.removeElementAt(index);
            this.listCmpItemSelected.insertElement((Object)info, count - 1);
            this.listCmpItemSelected.setSelectedIndex(count - 1);
        }
    }

    private Set getSetSelectItemElement(KDList kdList) {
        HashSet<DataBaseInfo> set = new HashSet<DataBaseInfo>();
        if (this.listCmpSchemSelected.getElementCount() > 0) {
            for (int i = 0; i < kdList.getElementCount(); ++i) {
                set.add((DataBaseInfo)kdList.getElement(i));
            }
        }
        return set;
    }

    private Set getIdSetSelectItemElement(KDList kdList) {
        Set set = this.getSetSelectItemElement(kdList);
        Iterator it = set.iterator();
        HashSet<String> idSet = new HashSet<String>();
        DataBaseInfo objInfo = null;
        while (it.hasNext()) {
            objInfo = (DataBaseInfo)it.next();
            if (objInfo == null || objInfo.getId() == null) continue;
            idSet.add(objInfo.getId().toString());
        }
        return idSet;
    }

    private void fillListData(KDList kdList, Object[] ObjectInfos) {
        if (ObjectInfos != null && ObjectInfos.length > 0) {
            kdList.removeAllElements();
            for (int i = 0; i < ObjectInfos.length; ++i) {
                kdList.addElement(ObjectInfos[i]);
            }
            if (ObjectInfos.length > 0) {
                kdList.setSelectedIndex(0);
            }
        }
    }

    public IObjectCollection getBgPeriodInfo() throws EASBizException, BOSException {
        IBgPeriodApiInfo beginperiod = this.getBeginBgPeriod();
        IBgPeriodApiInfo endperiod = this.getEndBgPeriod();
        IBgApi bgApi = (IBgApi)this.service.lookupService("MA.BD.BgApi");
        IObjectCollection bgPeriodCol = bgApi.getPeriodColInfo(beginperiod.getPeriodTypeEnum().getValue(), beginperiod.getBeginDate(), endperiod.getEndDate());
        return bgPeriodCol;
    }

    public CmpPeriodInfo[] getCmpPeriodInfos() {
        Arrays.sort(this.cpis, new CmpPeriodSort());
        return this.cpis;
    }

    public Set getCmpScheme() {
        if (this.getSetSelectItemElement(this.listCmpSchemSelected) != null && this.getSetSelectItemElement(this.listCmpSchemSelected).size() > 0) {
            Set set = new HashSet();
            if (this.getSetSelectItemElement(this.listCmpSchemSelected) != null) {
                set = this.getSetSelectItemElement(this.listCmpSchemSelected);
            }
            this.cmpScheme = set;
        }
        return this.cmpScheme;
    }

    public List getCmpItemList() {
        ArrayList<CmpItemInfo> itemList = new ArrayList<CmpItemInfo>();
        int count = this.listCmpItemSelected.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.listCmpItemSelected.getElement(i);
                itemList.add(info);
            }
        }
        return itemList;
    }

    private void getBgHroInfo() {
        try {
            this.hroIdList = this.getHROrgListInfo();
            if (this.hroIdList != null && this.hroIdList.size() == 0 && !this.clearFlag) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"180_CmpBudgetCompareChartFilterUI"));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private List getHROrgListInfo() throws BOSException, SQLException {
        ArrayList<String> hrolist = new ArrayList<String>();
        Object obj = this.prmtOrgUnit.getData();
        if (this.prmtOrgUnit.getData() != null) {
            if (obj instanceof CostCenterOrgUnitInfo) {
                StringBuffer sql = new StringBuffer();
                sql.append("select distinct o.FToUnitID from T_ORG_UnitRelation o where o.fFromUnitID in (");
                sql.append(" select r.fToUnitID from T_ORG_UnitRelation r");
                sql.append(" where r.FTypeRelationID='00000000-0000-0000-0000-0000000000150FE9F8B5'");
                sql.append(" and r.fFromUnitID = '").append(((CostCenterOrgUnitInfo)obj).getId().toString()).append("') and ");
                sql.append(" o.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5'");
                sql.append(" union ");
                sql.append("select distinct o.FToUnitID from T_ORG_UnitRelation o where o.fFromUnitID = '");
                sql.append(((CostCenterOrgUnitInfo)obj).getId().toString()).append("' and ");
                sql.append(" o.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5'");
                sql.append(" union ");
                sql.append(" select distinct o.FToUnitID from T_ORG_UnitRelation o where o.fFromUnitID in (");
                sql.append(" select r.FFromUnitID from T_ORG_UnitRelation r");
                sql.append(" where r.FTypeRelationID='00000000-0000-0000-0000-0000000000410FE9F8B5'");
                sql.append(" and r.FToUnitID ='").append(((CostCenterOrgUnitInfo)obj).getId().toString()).append("') and ");
                sql.append(" o.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5'");
                ISQLExecutor iSQLExec = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
                IRowSet rs = iSQLExec.executeSQL();
                while (rs.next()) {
                    String orgId = rs.getString("FToUnitID");
                    hrolist.add(orgId);
                }
            }
            if (obj instanceof Object[]) {
                Object[] objArray = (Object[])obj;
                OrgUnitInfo[] orgUnits = new OrgUnitInfo[objArray.length];
                int n = objArray.length;
                for (int i = 0; i < n; ++i) {
                    orgUnits[i] = (OrgUnitInfo)objArray[i];
                }
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < orgUnits.length; ++i) {
                    list.add(orgUnits[i].getId().toString());
                }
                String orgIds = HRSchemeUtils.getStrFromList(list);
                StringBuffer sql = new StringBuffer();
                sql.append("select distinct o.FToUnitID from T_ORG_UnitRelation o where o.fFromUnitID in (");
                sql.append(" select r.fToUnitID from T_ORG_UnitRelation r");
                sql.append(" where r.FTypeRelationID='00000000-0000-0000-0000-0000000000150FE9F8B5'");
                sql.append(" and r.fFromUnitID in ").append(orgIds).append(") and ");
                sql.append(" o.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5'");
                sql.append(" union ");
                sql.append("select distinct o.FToUnitID from T_ORG_UnitRelation o where o.fFromUnitID in ");
                sql.append(orgIds).append(" and ");
                sql.append(" o.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5'");
                sql.append(" union ");
                sql.append(" select distinct o.FToUnitID from T_ORG_UnitRelation o where o.fFromUnitID in (");
                sql.append(" select r.FFromUnitID from T_ORG_UnitRelation r");
                sql.append(" where r.FTypeRelationID='00000000-0000-0000-0000-0000000000410FE9F8B5'");
                sql.append(" and r.FToUnitID in ").append(orgIds).append(") and ");
                sql.append(" o.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5'");
                ISQLExecutor iSQLExec = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
                IRowSet rs = iSQLExec.executeSQL();
                while (rs.next()) {
                    String orgId = rs.getString("FToUnitID");
                    hrolist.add(orgId);
                }
            }
        }
        return hrolist;
    }

    public CoreBaseInfo getBgSchemeInfo() {
        CoreBaseInfo bgSchemeInfo = null;
        if (this.boxBgScheme.getSelectedItem() != null) {
            bgSchemeInfo = (CoreBaseInfo)this.boxBgScheme.getSelectedItem();
        }
        return bgSchemeInfo;
    }

    public IBgFormApiInfo getBgFormInfo() {
        if (this.boxData.getSelectedItem() != null) {
            this.bgFormInfo = (IBgFormApiInfo)this.boxData.getSelectedItem();
        }
        return this.bgFormInfo;
    }

    public List getOrgList() {
        Object object = this.prmtOrgUnit.getData();
        if (object instanceof CostCenterOrgUnitInfo) {
            this.orgList = new ArrayList();
            this.orgList.add(object);
        }
        if (object instanceof Object[]) {
            Object[] values = (Object[])object;
            this.orgList.clear();
            if (values.length > 0) {
                for (int i = 0; i < values.length; ++i) {
                    this.orgList.add(values[i]);
                }
            }
        }
        return this.orgList;
    }

    public IBgPeriodApiInfo getBeginBgPeriod() {
        IBgPeriodApiInfo period = (IBgPeriodApiInfo)this.prmtBgPeriodBegin.getData();
        return period;
    }

    public IBgPeriodApiInfo getEndBgPeriod() {
        IBgPeriodApiInfo period = (IBgPeriodApiInfo)this.prmtBgPeriodEnd.getData();
        return period;
    }

    public String getMainDimBosType() {
        String bosType = null;
        Object obj = this.boxMainDim.getSelectedItem();
        if (obj != null) {
            String tmpStr;
            BgDimItemInfo data = (BgDimItemInfo)obj;
            bosType = tmpStr = data.getBosType();
        }
        return bosType;
    }

    public List getDimList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.boxDimItem.getData() != null) {
            Object[] obj = (Object[])this.boxDimItem.getData();
            int n = obj.length;
            for (int i = 0; i < n; ++i) {
                DataBaseInfo bg = (DataBaseInfo)obj[i];
                if (bg == null) continue;
                list.add(bg.getNumber());
            }
        }
        return list;
    }

    protected void listCmpSchemeAll_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.actionRight_actionPerformed(null);
        }
    }

    protected void listCmpSchemSelected_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.actionLeft_actionPerformed(null);
        }
    }

    protected void listCmpItemAll_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.actionItemRight_actionPerformed(null);
        }
    }

    protected void listCmpItemSelected_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.actionItemLeft_actionPerformed(null);
        }
    }

    public String getRootHroId() throws BOSException, SQLException {
        if (this.rootHroId == null) {
            List orgList = this.getOrgList();
            ArrayList<String> orgIdList = new ArrayList<String>();
            int n = orgList.size();
            for (int i = 0; i < n; ++i) {
                OrgUnitInfo org = (OrgUnitInfo)orgList.get(i);
                orgIdList.add(org.getId().toString());
            }
            this.rootHroId = HRReportUtils.getRootHRUnitID(null, orgIdList);
        }
        return this.rootHroId;
    }

    public void setRootHroId(String rootHroId) {
        this.rootHroId = rootHroId;
    }

    class CmpPeriodSort
    implements Comparator {
        CmpPeriodSort() {
        }

        public int compare(Object o1, Object o2) {
            if (o2 instanceof CmpPeriodInfo && o1 instanceof CmpPeriodInfo) {
                return ((CmpPeriodInfo)o1).getName().compareTo(((CmpPeriodInfo)o2).getName());
            }
            return -1;
        }
    }
}

