/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.base.DynamicTableInfo;
import com.kingdee.eas.hr.compensation.BudgetCompensationFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpBudgetFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpItemPrecisionTypeEnum;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.IBudgetCompensationFacade;
import com.kingdee.eas.hr.compensation.client.AbstractCmpBudgetReportUI;
import com.kingdee.eas.hr.compensation.client.BudgetCompensationUI;
import com.kingdee.eas.hr.compensation.client.CmpBudgetReportFilterUI;
import com.kingdee.eas.hr.compensation.util.CompTableStyleUtil;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRBudgetUtils;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRDynamicTableUtils;
import com.kingdee.eas.hr.compensation.util.HRReportUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.ma.nbudget.BudgetData;
import com.kingdee.eas.ma.nbudget.IBgFormApiInfo;
import com.kingdee.eas.ma.nbudget.IBgPeriodApiInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CmpBudgetReportUI
extends AbstractCmpBudgetReportUI {
    private static final Logger logger = CoreUIObject.getLogger(BudgetCompensationUI.class);
    private CmpBudgetReportFilterUI filterUI = new CmpBudgetReportFilterUI();
    private DynamicTableInfo infoDynamicTable = new DynamicTableInfo();
    private static final String COST_CENTER_ID = "orgUnitId";
    private static final String COST_CENTER_NAME = "orgUnitName";
    private static final String COST_ID_CATA = "COST_ID_CATA";
    private static final String BG_VALUE = "BG_VALUE";
    private static final String DIFFERENCY_VAL = "DIFFERENCY_VAL";
    private static final String DIFFERENCY_PEN = "DIFFERENCY_PEN";
    private static final String BG_SCHEME_PERIOD = "BG_SCHEME_PERIOD";
    private static final String ACTUAL_VALUE = "ACTUAL_VALUE";
    private static final String TOTAL = "TOTAL";
    private static final String resClass = "com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.";
    private CmpPeriodInfo[] cmpPeriodInfos;
    private IBudgetCompensationFacade bgcFacade = null;
    private CommonQueryDialog commonQueryDialog = new CommonQueryDialog();
    private QuerySolutionInfo solutionInfo = null;
    private boolean isFirstDefaultQuery = true;
    private EntityViewInfo infoEntityView = new EntityViewInfo();
    private Set selectedCmpScheme = null;
    private List cmpList = null;
    private Map map = null;
    private List bgDataList = null;
    private HashMap cmpParams = new HashMap();
    private Map periodMap = new HashMap();
    private boolean isFromBugetAlert = false;

    public CmpBudgetReportUI() throws Exception {
        HRSchemeUtils.checkInit();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().containsKey("isFromBugetAlert") && this.getUIContext().get("isFromBugetAlert").toString().equals("1")) {
            this.isFromBugetAlert = true;
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"194_CmpBudgetReportUI"));
        }
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.getBizfacadeInterface();
        this.showFilterDialog();
        this.doQueryDialog();
        this.tHelper.getDisabledTables().add(this.tblMain);
        HRUtils.removeLintMenu((KDTable)this.tblMain, (KDTMenuManager)this.getMenuManager(this.tblMain));
    }

    private IBudgetCompensationFacade getBizfacadeInterface() throws BOSException {
        if (this.bgcFacade == null) {
            this.bgcFacade = BudgetCompensationFacadeFactory.getRemoteInstance();
        }
        return this.bgcFacade;
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemQuery.setEnabled(true);
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnCaculate.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
        this.btnCaculate.setEnabled(true);
        this.menuItemCalculate.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
        this.menuItemCalculate.setEnabled(true);
    }

    private void createTblMain() throws Exception {
        this.tblMain.setRefresh(true);
        this.infoDynamicTable.setCountHeadLine(3);
        List lstColumn = this.getTblMainColumn();
        DynamicTableInfo.ColumnInfo[] infosColumn = new DynamicTableInfo.ColumnInfo[lstColumn.size()];
        int size = lstColumn.size();
        for (int i = 0; i < size; ++i) {
            infosColumn[i] = (DynamicTableInfo.ColumnInfo)lstColumn.get(i);
        }
        this.infoDynamicTable.setInfosColumn(infosColumn);
        HRDynamicTableUtils.createTableHead((KDTable)this.tblMain, (DynamicTableInfo)this.infoDynamicTable);
        this.setHeadMerge();
        this.tblMain.setColumnMoveable(false);
        this.tblMain.setRefresh(true);
        this.tblMain.repaint();
    }

    private List getTblMainColumn() {
        ArrayList<DynamicTableInfo.ColumnInfo> lstColumn = new ArrayList<DynamicTableInfo.ColumnInfo>();
        DynamicTableInfo.ColumnInfo infoColumn = null;
        infoColumn = new DynamicTableInfo.ColumnInfo();
        infoColumn.setHide(true);
        infoColumn.setReadOnly(true);
        infoColumn.setLocked(true);
        infoColumn.setColor(HRReportUtils.NORMAL_COLOR);
        infoColumn.setColumnType(30);
        infoColumn.setKey(COST_CENTER_ID);
        infoColumn.setColumnNumber(COST_CENTER_ID);
        infoColumn.setColumnName(COST_CENTER_ID);
        infoColumn.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[0].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"195_CmpBudgetReportUI"));
        infoColumn.getInfosHead()[0].setHeadValue(COST_CENTER_ID);
        lstColumn.add(infoColumn);
        infoColumn = new DynamicTableInfo.ColumnInfo();
        infoColumn.setHide(false);
        infoColumn.setReadOnly(true);
        infoColumn.setLocked(true);
        infoColumn.setColor(HRReportUtils.NORMAL_COLOR);
        infoColumn.setColumnType(30);
        infoColumn.setKey(COST_CENTER_NAME);
        infoColumn.setColumnNumber(COST_CENTER_NAME);
        infoColumn.setColumnName(COST_CENTER_NAME);
        infoColumn.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[0].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"195_CmpBudgetReportUI"));
        infoColumn.getInfosHead()[0].setHeadValue(COST_CENTER_NAME);
        lstColumn.add(infoColumn);
        infoColumn = new DynamicTableInfo.ColumnInfo();
        infoColumn.setHide(false);
        infoColumn.setReadOnly(true);
        infoColumn.setLocked(true);
        infoColumn.setColor(HRReportUtils.NORMAL_COLOR);
        infoColumn.setColumnType(30);
        infoColumn.setKey(COST_ID_CATA);
        infoColumn.setColumnNumber(COST_ID_CATA);
        infoColumn.setColumnName(COST_ID_CATA);
        infoColumn.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
        infoColumn.getInfosHead()[0].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.COST_ID_CATA"));
        infoColumn.getInfosHead()[0].setHeadValue(COST_ID_CATA);
        lstColumn.add(infoColumn);
        List periodColumn = this.getPeriodHeadColumn();
        lstColumn.addAll(periodColumn);
        return lstColumn;
    }

    protected void doQueryDialog() throws Exception {
        String hroRootId;
        IBgPeriodApiInfo bgEndPeriod;
        this.selectedCmpScheme = this.filterUI.getCmpScheme();
        this.cmpList = this.filterUI.getCmpItemList();
        IBgPeriodApiInfo bgBeginPeriod = this.filterUI.getBeginBgPeriod();
        List periodList = HRBudgetUtils.getCmpPeriodInfo(null, bgBeginPeriod, bgEndPeriod = this.filterUI.getEndBgPeriod(), hroRootId = this.filterUI.getRootHroId());
        if (periodList != null) {
            this.cmpPeriodInfos = periodList.toArray(new CmpPeriodInfo[0]);
        }
        this.cmpParams.put("hroRootId", hroRootId);
        this.cmpParams.put("cmpSchemes", this.selectedCmpScheme);
        this.cmpParams.put("bgBeginPeriod", bgBeginPeriod);
        this.cmpParams.put("bgEndPeriod", bgEndPeriod);
        List orgIdList = this.filterUI.getOrgList();
        this.cmpParams.put("orgList", orgIdList);
        List itemList = this.filterUI.getCmpItemList();
        this.cmpParams.put("itemList", itemList);
        this.cmpParams.put("mainDimType", this.filterUI.getMainDimBosType());
        this.cmpParams.put("mainDimList", this.filterUI.getDimList());
        this.cmpParams.put("isFromBugetAlert", this.isFromBugetAlert);
        Map dgDataMap = this.getBgDataByCondition();
        this.bgDataList = (List)dgDataMap.get("dataList");
        this.periodMap = (Map)dgDataMap.get("periodMap");
        this.createTblMain();
        this.fillTblData();
        this.setDimInfoValue();
    }

    private Map getBgDataByCondition() throws EASBizException, BOSException {
        String schemeId = this.filterUI.getBgSchemeInfo().getId().toString();
        this.cmpParams.put("schemeId", schemeId);
        String bgformId = this.filterUI.getBgFormInfo().getId().toString();
        this.cmpParams.put("bgformId", bgformId);
        IObjectCollection bgPeriods = this.filterUI.getBgPeriodInfo();
        this.cmpParams.put("bgPeriodCollection", bgPeriods);
        Map dataMap = CmpBudgetFacadeFactory.getRemoteInstance().getBgDataByCondition(this.cmpParams);
        return dataMap;
    }

    private void setHeadMerge() throws Exception {
        KDTMergeManager mm = this.tblMain.getHeadMergeManager();
        mm.mergeBlock(0, 1, 2, 1, 4);
        mm.mergeBlock(0, 2, 2, 2, 4);
        this.setHeadMergeByPeriod(mm);
    }

    private void setHeadMergeByPeriod(KDTMergeManager mm) throws Exception {
        Iterator bgIterator = this.periodMap.keySet().iterator();
        IBgPeriodApiInfo bgPeriod2 = null;
        int bgPeriodMergeBegin = 0;
        bgPeriodMergeBegin += 3;
        while (bgIterator.hasNext()) {
            bgPeriod2 = (IBgPeriodApiInfo)bgIterator.next();
            List cmpPeriodList = (List)this.periodMap.get(bgPeriod2);
            int mergeSize = bgPeriodMergeBegin + cmpPeriodList.size() + 3;
            mm.mergeBlock(0, bgPeriodMergeBegin, 0, mergeSize, 4);
            bgPeriodMergeBegin = mergeSize + 1;
        }
        int bgActColumnMergeBegin = 0;
        bgActColumnMergeBegin += 4;
        for (IBgPeriodApiInfo bgPeriod2 : this.periodMap.keySet()) {
            List cmpPeriodList = (List)this.periodMap.get(bgPeriod2);
            int mergeSize = bgActColumnMergeBegin + cmpPeriodList.size();
            mm.mergeBlock(1, bgActColumnMergeBegin, 1, mergeSize, 4);
            bgActColumnMergeBegin = mergeSize + 4;
        }
    }

    private void fillTblData() throws Exception {
        CmpSchemeInfo[] cmpScheme = new CmpSchemeInfo[this.selectedCmpScheme.size()];
        Iterator its = this.selectedCmpScheme.iterator();
        int len = 0;
        while (its.hasNext()) {
            cmpScheme[len] = (CmpSchemeInfo)its.next();
            ++len;
        }
        List cmpList = this.getCmpList();
        Iterator it = null;
        if (this.bgDataList != null && this.bgDataList.size() > 0) {
            this.tblMain.removeRows();
            List orgList = this.filterUI.getOrgList();
            IRow row = null;
            if (cmpList.size() > 0) {
                for (CmpItemInfo c : cmpList) {
                    int n = orgList.size();
                    for (int i = 0; i < n; ++i) {
                        OrgUnitInfo org = (OrgUnitInfo)orgList.get(i);
                        row = this.tblMain.addRow();
                        row.getCell(COST_CENTER_NAME).setValue((Object)org.getName());
                        row.getCell(COST_ID_CATA).setValue((Object)c);
                        row.getCell(COST_CENTER_ID).setValue((Object)org.getId().toString());
                    }
                }
            }
        }
    }

    public List getCmpList() throws Exception {
        return this.cmpList;
    }

    public Map getMap() throws EASBizException, BOSException {
        CmpSchemeInfo[] cmpScheme = new CmpSchemeInfo[this.selectedCmpScheme.size()];
        Iterator its = this.selectedCmpScheme.iterator();
        int len = 0;
        while (its.hasNext()) {
            cmpScheme[len] = (CmpSchemeInfo)its.next();
            ++len;
        }
        this.map = this.bgcFacade.getCmpSchemeData(cmpScheme, this.cmpPeriodInfos, this.cmpList);
        return this.map;
    }

    protected void showFilterDialog() throws Exception {
        MetaDataPK queryPK = null;
        queryPK = this.isFromBugetAlert ? new MetaDataPK("com.kingdee.eas.base.message.MsgQuery") : new MetaDataPK("com.kingdee.eas.hr.compensation.app.CmpSchemeQuery");
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = HRSchemeUtils.getQueryInfo((IMetaDataPK)queryPK).getFullName();
        this.commonQueryDialog.setWidth(550);
        this.commonQueryDialog.setHeight(520);
        if (this.getUIWindow() == null) {
            this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            this.commonQueryDialog.setOwner((Component)((Object)this));
        }
        this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.commonQueryDialog.setQueryObjectPK((IMetaDataPK)queryPK);
        this.commonQueryDialog.setShowFilter(false);
        this.commonQueryDialog.setShowSorter(false);
        this.commonQueryDialog.setShowToolbar(true);
        this.commonQueryDialog.setEntityViewInfo(this.infoEntityView);
        this.commonQueryDialog.setQueryObjectPK((IMetaDataPK)queryPK);
        this.filterUI.setPanelName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.FILTER_CONDITION"));
        this.commonQueryDialog.addUserPanel((KDPanel)this.filterUI);
        this.commonQueryDialog.setMaxReturnCountVisible(false);
        if (!this.isFromBugetAlert) {
            this.commonQueryDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.BUDGETCOMPENSATION_FILTER"));
        } else {
            this.commonQueryDialog.setTitle(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"196_CmpBudgetReportUI"));
        }
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            this.infoEntityView = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
            if (this.infoEntityView == null) {
                this.infoEntityView = new EntityViewInfo();
            }
            this.solutionInfo = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            if (CompUtils.isNullWhere((QuerySolutionInfo)this.solutionInfo) && this.solutionInfo.getQueryPanelInfo().get(0) != null && this.solutionInfo.getQueryPanelInfo().get(0).getCustomerParams() != null) {
                this.infoEntityView = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
                CustomerParams cp = CustomerParams.getCustomerParams2((String)this.solutionInfo.getQueryPanelInfo().get(0).getCustomerParams());
                this.filterUI.setCustomerParams(cp);
                this.commonQueryDialog.setEntityViewInfo(this.infoEntityView);
                CoreBaseInfo scheme = this.filterUI.getBgSchemeInfo();
                IBgFormApiInfo bgform = this.filterUI.getBgFormInfo();
                List orgIdList = this.filterUI.getOrgList();
                if (scheme == null || bgform == null || orgIdList != null && orgIdList.size() == 0) {
                    this.isFirstDefaultQuery = false;
                    if (this.commonQueryDialog.show()) {
                        this.solutionInfo = this.commonQueryDialog.getCurrentSolutionInfo();
                        this.doQueryDialog();
                    } else {
                        SysUtil.abort();
                    }
                } else {
                    this.isFirstDefaultQuery = false;
                    this.doQueryDialog();
                }
            } else {
                this.isFirstDefaultQuery = false;
                if (this.commonQueryDialog.show()) {
                    this.solutionInfo = this.commonQueryDialog.getCurrentSolutionInfo();
                    this.doQueryDialog();
                } else {
                    SysUtil.abort();
                }
            }
        } else {
            this.isFirstDefaultQuery = false;
            if (this.commonQueryDialog.show()) {
                this.solutionInfo = this.commonQueryDialog.getCurrentSolutionInfo();
                this.doQueryDialog();
            } else {
                SysUtil.abort();
            }
        }
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    public void actionPrintView_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintView_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (this.commonQueryDialog.show()) {
            this.solutionInfo = this.commonQueryDialog.getCurrentSolutionInfo();
            this.doQueryDialog();
        }
        this.tblMain.getHeadRow(0).setHeight(CompTableStyleUtil.getTblHeadHeight());
        this.tblMain.reLayoutAndPaint();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.doQueryDialog();
    }

    public void actionCaculate_actionPerformed(ActionEvent e) throws Exception {
        super.actionCaculate_actionPerformed(e);
        int rowCount = this.tblMain.getRowCount();
        IRow row = null;
        CmpItemInfo cmpItem = null;
        CmpItemInfo itemPrecisionInfo = null;
        String cmpItemNumber = null;
        this.map = CmpBudgetFacadeFactory.getRemoteInstance().getCmpSchemeData(this.cmpParams);
        BigDecimal bgValue = null;
        BigDecimal percentVal = new BigDecimal("100.00");
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            String curCostCenterId = (String)row.getCell(COST_CENTER_ID).getValue();
            for (int k = 0; k < this.bgDataList.size(); ++k) {
                BudgetData budgetData = (BudgetData)this.bgDataList.get(k);
                cmpItem = (CmpItemInfo)row.getCell(COST_ID_CATA).getValue();
                String curItem = budgetData.getSarlaryNum();
                String bgPeriodId = budgetData.getPeriodId();
                if (!curCostCenterId.equals(budgetData.getOrgUnitId()) || !curItem.equals(cmpItem.getNumber())) continue;
                itemPrecisionInfo = (CmpItemInfo)HRCmpItemUtils.getCmpItemInfoByNumber(null, (String[])new String[]{cmpItem.getNumber()}).get(cmpItem.getNumber());
                cmpItemNumber = cmpItem.getNumber();
                bgValue = budgetData.getBgValue();
                row.getCell(bgPeriodId + BG_VALUE).setValue((Object)bgValue.setScale(2, 4).toString());
                List cmpPeriodList = this.getPeriodListOfBgPeriod(bgPeriodId);
                HashMap dataMap = (HashMap)this.map.get(curCostCenterId);
                if (dataMap == null) continue;
                BigDecimal totalValue = new BigDecimal("0.00");
                int m = cmpPeriodList.size();
                for (int j = 0; j < m; ++j) {
                    CmpPeriodInfo curP = (CmpPeriodInfo)cmpPeriodList.get(j);
                    String cmpPeriodNum = curP.getNumber();
                    BigDecimal curVal = (BigDecimal)dataMap.get(cmpItemNumber + "@" + cmpPeriodNum);
                    if (curVal != null) {
                        row.getCell(cmpPeriodNum).setValue((Object)HRCmpItemUtils.convertPrecisionForBigDecimal((BigDecimal)curVal, (int)itemPrecisionInfo.getDecDigital(), (CmpItemPrecisionTypeEnum)itemPrecisionInfo.getPrecisionType()));
                        totalValue = totalValue.add(curVal);
                        continue;
                    }
                    curVal = new BigDecimal("0");
                    row.getCell(cmpPeriodNum).setValue((Object)HRCmpItemUtils.convertPrecisionForBigDecimal((BigDecimal)curVal, (int)itemPrecisionInfo.getDecDigital(), (CmpItemPrecisionTypeEnum)itemPrecisionInfo.getPrecisionType()));
                }
                row.getCell(bgPeriodId + TOTAL).getStyleAttributes().setNumberFormat(HRCmpItemUtils.getColumnFormatStr((int)itemPrecisionInfo.getDecDigital()));
                row.getCell(bgPeriodId + TOTAL).setValue((Object)HRCmpItemUtils.convertPrecisionForBigDecimal((BigDecimal)totalValue, (int)itemPrecisionInfo.getDecDigital(), (CmpItemPrecisionTypeEnum)itemPrecisionInfo.getPrecisionType()));
                row.getCell(bgPeriodId + DIFFERENCY_VAL).getStyleAttributes().setNumberFormat(HRCmpItemUtils.getColumnFormatStr((int)itemPrecisionInfo.getDecDigital()));
                row.getCell(bgPeriodId + DIFFERENCY_VAL).setValue((Object)HRCmpItemUtils.convertPrecisionForBigDecimal((BigDecimal)totalValue.add(bgValue.negate()), (int)itemPrecisionInfo.getDecDigital(), (CmpItemPrecisionTypeEnum)itemPrecisionInfo.getPrecisionType()));
                if (bgValue.doubleValue() != 0.0) {
                    BigDecimal diffValue = totalValue.add(bgValue.negate()).divide(bgValue, 4).multiply(percentVal);
                    diffValue = HRCmpItemUtils.convertPrecisionForBigDecimal((BigDecimal)diffValue, (int)2, (CmpItemPrecisionTypeEnum)CmpItemPrecisionTypeEnum.JINWEI);
                    row.getCell(bgPeriodId + DIFFERENCY_PEN).setValue((Object)(diffValue + "%"));
                    continue;
                }
                row.getCell(bgPeriodId + DIFFERENCY_PEN).setValue((Object)(bgValue + "%"));
            }
        }
    }

    private List getPeriodListOfBgPeriod(String bgPeriodId) {
        Iterator periodIt = this.periodMap.keySet().iterator();
        List cmpPeriodList = new ArrayList();
        while (periodIt.hasNext()) {
            IBgPeriodApiInfo curBgPeriod = (IBgPeriodApiInfo)periodIt.next();
            String curBgPeriodId = curBgPeriod.getId().toString();
            if (!bgPeriodId.equals(curBgPeriodId)) continue;
            cmpPeriodList = (List)this.periodMap.get(curBgPeriod);
        }
        return cmpPeriodList;
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected KDTable getTableForOA() {
        return this.tblMain;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.COMPENSATION;
    }

    public QuerySolutionInfo getQuerySolutionInfo() {
        return this.solutionInfo;
    }

    private List getPeriodHeadColumn() {
        ArrayList columnList = new ArrayList();
        Iterator bgIterator = this.periodMap.keySet().iterator();
        IBgPeriodApiInfo bgPeriod = null;
        while (bgIterator.hasNext()) {
            bgPeriod = (IBgPeriodApiInfo)bgIterator.next();
            List cmpPeriodList = (List)this.periodMap.get(bgPeriod);
            columnList.addAll(this.getPeriodHeadByBgPeriodColumn(bgPeriod, cmpPeriodList));
        }
        return columnList;
    }

    private List getPeriodHeadByBgPeriodColumn(IBgPeriodApiInfo bgPeriod, List cmpPeriodList) {
        ArrayList<DynamicTableInfo.ColumnInfo> lstColumn = new ArrayList<DynamicTableInfo.ColumnInfo>();
        DynamicTableInfo.ColumnInfo infoColumn = null;
        for (int i = 0; i < cmpPeriodList.size() + 4; ++i) {
            infoColumn = new DynamicTableInfo.ColumnInfo();
            infoColumn.setAlignHor(Styles.HorizontalAlignment.RIGHT);
            infoColumn.setHide(false);
            infoColumn.setReadOnly(true);
            infoColumn.setLocked(true);
            infoColumn.setColor(HRReportUtils.NORMAL_COLOR);
            infoColumn.setColumnType(30);
            infoColumn.setKey(BG_SCHEME_PERIOD);
            infoColumn.setColumnNumber(BG_SCHEME_PERIOD);
            infoColumn.setColumnName(BG_SCHEME_PERIOD);
            infoColumn.setInfosHead(new DynamicTableInfo.HeadInfo[3]);
            infoColumn.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
            infoColumn.getInfosHead()[0].setHeadName(bgPeriod.getName());
            infoColumn.getInfosHead()[0].setHeadValue(bgPeriod.getName());
            String bgPeriodId = bgPeriod.getId().toString();
            if (i == 0) {
                infoColumn.setColumnNumber(bgPeriodId + BG_VALUE);
                infoColumn.setColumnName(bgPeriodId + BG_VALUE);
                infoColumn.setKey(bgPeriodId + BG_VALUE);
                infoColumn.setColor(HRReportUtils.NORMAL_COLOR);
                infoColumn.getInfosHead()[1] = new DynamicTableInfo.HeadInfo();
                infoColumn.getInfosHead()[1].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.BG_VALUE"));
                infoColumn.getInfosHead()[1].setHeadValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.BG_VALUE"));
                infoColumn.setColumnNumber(bgPeriodId + BG_VALUE);
                infoColumn.setColumnName(bgPeriodId + BG_VALUE);
                infoColumn.setKey(bgPeriodId + BG_VALUE);
                infoColumn.setColor(HRReportUtils.NORMAL_COLOR);
                infoColumn.getInfosHead()[2] = new DynamicTableInfo.HeadInfo();
                infoColumn.getInfosHead()[2].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.BG_VALUE"));
                infoColumn.getInfosHead()[2].setHeadValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.BG_VALUE"));
            } else if (i == cmpPeriodList.size() + 4 - 1) {
                infoColumn.setColumnNumber(bgPeriodId + DIFFERENCY_PEN);
                infoColumn.setColumnName(bgPeriodId + DIFFERENCY_PEN);
                infoColumn.setKey(bgPeriodId + DIFFERENCY_PEN);
                infoColumn.setColor(HRReportUtils.NORMAL_COLOR);
                infoColumn.getInfosHead()[1] = new DynamicTableInfo.HeadInfo();
                infoColumn.getInfosHead()[1].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.DIFFERENCY_PEN"));
                infoColumn.getInfosHead()[1].setHeadValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.DIFFERENCY_PEN"));
                infoColumn.setColumnNumber(bgPeriodId + DIFFERENCY_PEN);
                infoColumn.setColumnName(bgPeriodId + DIFFERENCY_PEN);
                infoColumn.setKey(bgPeriodId + DIFFERENCY_PEN);
                infoColumn.setColor(HRReportUtils.NORMAL_COLOR);
                infoColumn.getInfosHead()[2] = new DynamicTableInfo.HeadInfo();
                infoColumn.getInfosHead()[2].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.DIFFERENCY_PEN"));
                infoColumn.getInfosHead()[2].setHeadValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.DIFFERENCY_PEN"));
            } else if (i == cmpPeriodList.size() + 4 - 2) {
                infoColumn.setColumnNumber(bgPeriodId + DIFFERENCY_VAL);
                infoColumn.setColumnName(bgPeriodId + DIFFERENCY_VAL);
                infoColumn.setKey(bgPeriodId + DIFFERENCY_VAL);
                infoColumn.setColor(HRReportUtils.NORMAL_COLOR);
                infoColumn.getInfosHead()[1] = new DynamicTableInfo.HeadInfo();
                infoColumn.getInfosHead()[1].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"172_CmpAdjusctiveReportListUI"));
                infoColumn.getInfosHead()[1].setHeadValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"172_CmpAdjusctiveReportListUI"));
                infoColumn.setColumnNumber(bgPeriodId + DIFFERENCY_VAL);
                infoColumn.setColumnName(bgPeriodId + DIFFERENCY_VAL);
                infoColumn.setKey(bgPeriodId + DIFFERENCY_VAL);
                infoColumn.setColor(HRReportUtils.NORMAL_COLOR);
                infoColumn.getInfosHead()[2] = new DynamicTableInfo.HeadInfo();
                infoColumn.getInfosHead()[2].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"172_CmpAdjusctiveReportListUI"));
                infoColumn.getInfosHead()[2].setHeadValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"172_CmpAdjusctiveReportListUI"));
            } else {
                infoColumn.setColumnNumber(bgPeriodId + ACTUAL_VALUE);
                infoColumn.setColumnName(bgPeriodId + ACTUAL_VALUE);
                infoColumn.setKey(bgPeriodId + ACTUAL_VALUE);
                infoColumn.setColor(HRReportUtils.NORMAL_COLOR);
                infoColumn.getInfosHead()[1] = new DynamicTableInfo.HeadInfo();
                infoColumn.getInfosHead()[1].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.ACTUAL_VALUE"));
                infoColumn.getInfosHead()[1].setHeadValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.ACTUAL_VALUE"));
                if (i == cmpPeriodList.size() + 4 - 3) {
                    infoColumn.setColumnNumber(bgPeriodId + TOTAL);
                    infoColumn.setColumnName(bgPeriodId + TOTAL);
                    infoColumn.setKey(bgPeriodId + TOTAL);
                    infoColumn.setColor(HRReportUtils.NORMAL_COLOR);
                    infoColumn.getInfosHead()[2] = new DynamicTableInfo.HeadInfo();
                    infoColumn.getInfosHead()[2].setHeadName(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.TOTAL"));
                    infoColumn.getInfosHead()[2].setHeadValue(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.BudgetCompensationResource.TOTAL"));
                } else {
                    CmpPeriodInfo periodInfo = (CmpPeriodInfo)cmpPeriodList.get(i - 1);
                    infoColumn.setColumnNumber(periodInfo.getNumber());
                    infoColumn.setColumnName(periodInfo.getNumber());
                    infoColumn.setKey(periodInfo.getNumber());
                    infoColumn.setColor(HRReportUtils.NORMAL_COLOR);
                    infoColumn.getInfosHead()[2] = new DynamicTableInfo.HeadInfo();
                    infoColumn.getInfosHead()[2].setHeadName(periodInfo.getName());
                    infoColumn.getInfosHead()[2].setHeadValue(periodInfo.getName());
                }
            }
            lstColumn.add(infoColumn);
        }
        return lstColumn;
    }

    private void setDimInfoValue() {
        String mainDimText = "";
        if (this.filterUI.boxMainDim.getSelectedItem() != null) {
            mainDimText = this.filterUI.boxMainDim.getSelectedItem().toString();
        }
        this.txtMainDim.setText(mainDimText);
        this.txtMainDim.setEditable(false);
        StringBuffer itemNames = new StringBuffer();
        if (this.filterUI.boxDimItem.getData() != null) {
            Object[] bgItems = (Object[])this.filterUI.boxDimItem.getData();
            int n = bgItems.length;
            for (int i = 0; i < n; ++i) {
                DataBaseInfo bgItem = (DataBaseInfo)bgItems[i];
                if (bgItem == null) continue;
                if (i != n - 1) {
                    itemNames.append(bgItem.getName());
                    itemNames.append(";");
                    continue;
                }
                itemNames.append(bgItem.getName());
            }
        }
        this.txtItemValue.setText(itemNames.toString());
        this.txtItemValue.setEditable(false);
    }

    protected void checkTableCommonMenu(KDTable table) {
        KDTMenuManager tm = this.getMenuManager(table);
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        for (int i = 0; i < pop.getComponentCount(); ++i) {
            if (!"menuItemPaste".equalsIgnoreCase(pop.getComponent(i).getName())) continue;
            pop.getComponent(i).setVisible(false);
        }
    }
}

