/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.hr.compensation.client.BOCSalaryReportUtil;
import com.kingdee.eas.util.client.EASResource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BOCEmpSalaryStatReportHelper {
    private KDTable table = null;
    private int START_COL_INDEX = 4;
    private HashMap mapPersonInfo = null;
    private HashMap mapPersonPosIndex = null;

    public BOCEmpSalaryStatReportHelper(KDTable table) {
        this.table = table;
    }

    public void reFillTableData() {
        if (this.table.getRowCount() == 0) {
            return;
        }
        this.getPersonInfoFromTable();
        HashMap mapData = this.regroupData();
        if (mapData.size() == 0) {
            return;
        }
        this.table.removeRows();
        this.fillPersonInfoToTable();
        this.fillSalaryDataToTable(mapData);
    }

    private void sumCol() {
        int rowCount = this.table.getRowCount();
        int colCount = this.table.getColumnCount();
        IRow row = this.table.addRow();
        row.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"147_BOCEmpSalaryStatReportHelper"));
        double sum = 0.0;
        for (int j = this.START_COL_INDEX; j < colCount; ++j) {
            sum = 0.0;
            for (int i = 0; i < rowCount; ++i) {
                sum += this.getCellValue(i, j);
            }
            row.getCell(j).setValue((Object)new Double(sum));
        }
    }

    private HashMap regroupData() {
        int rowCount = this.table.getRowCount();
        int colCount = this.table.getColumnCount();
        HashMap<String, double[]> map = new HashMap<String, double[]>(512);
        double[] rowData = null;
        IRow row = null;
        String key = null;
        for (int i = 0; i < rowCount - 1; ++i) {
            row = this.table.getRow(i);
            key = row.getCell("FPER002").getValue().toString();
            rowData = map.containsKey(key) ? (double[])map.get(key) : new double[colCount];
            for (int j = this.START_COL_INDEX; j < colCount; ++j) {
                int n = j;
                rowData[n] = rowData[n] + this.getCellValue(i, j);
            }
            map.put(key, rowData);
        }
        return map;
    }

    private double getCellValue(int row, int col) {
        return BOCSalaryReportUtil.getCellValue(this.table, row, col);
    }

    private void fillSalaryDataToTable(HashMap mapData) {
        Iterator itor = mapData.entrySet().iterator();
        String key = null;
        double[] rowData = null;
        IRow row = null;
        int colCount = this.table.getColumnCount();
        Map.Entry entry = null;
        while (itor.hasNext()) {
            entry = itor.next();
            key = (String)entry.getKey();
            rowData = (double[])entry.getValue();
            int rowIndex = (Integer)this.mapPersonPosIndex.get(key);
            row = this.table.getRow(rowIndex);
            for (int j = this.START_COL_INDEX; j < colCount; ++j) {
                row.getCell(j).setValue((Object)new Double(rowData[j]));
            }
        }
    }

    private void fillPersonInfoToTable() {
        String key2 = null;
        SimplePersonInfo info = null;
        IRow row = null;
        int index = 0;
        this.mapPersonPosIndex = new HashMap(512);
        for (String key2 : this.mapPersonInfo.keySet()) {
            info = (SimplePersonInfo)this.mapPersonInfo.get(key2);
            row = this.table.addRow();
            row.getCell("FPER001").setValue((Object)info.personName);
            row.getCell("FPER023").setValue((Object)info.personICNo);
            row.getCell("FPER002").setValue((Object)key2);
            row.getCell("FPER005").setValue((Object)info.deptName);
            this.mapPersonPosIndex.put(key2, index++);
        }
    }

    private void getPersonInfoFromTable() {
        this.mapPersonInfo = new HashMap(512);
        int rowCount = this.table.getRowCount();
        String key = null;
        SimplePersonInfo info = null;
        IRow row = null;
        for (int i = 0; i < rowCount - 1; ++i) {
            row = this.table.getRow(i);
            key = row.getCell("FPER002").getValue().toString();
            if (this.mapPersonInfo.containsKey(key)) continue;
            info = new SimplePersonInfo();
            info.number = key;
            info.personName = this.getCellStringValue(row, "FPER001");
            info.personICNo = this.getCellStringValue(row, "FPER023");
            info.deptName = this.getCellStringValue(row, "FPER005");
            this.mapPersonInfo.put(key, info);
        }
    }

    private String getCellStringValue(IRow row, String colName) {
        Object obj = row.getCell(colName).getValue();
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    static class SimplePersonInfo {
        public String personName;
        public String personICNo;
        public String number;
        public String deptName;

        public String toString() {
            return this.number;
        }
    }
}

