/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.eas.hr.compensation.BaseSelectItemException;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.OperatorEnum;
import com.kingdee.eas.hr.compensation.client.AbstractBaseSelectItemUI;
import com.kingdee.eas.hr.compensation.client.BaseSelectItemData;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;

public class BaseSelectItemUI
extends AbstractBaseSelectItemUI {
    protected KDSelectListModel allItemListModel = null;
    protected KDSelectListModel selectItemListModel = null;
    protected int[] selectLeftListIndexs = new int[0];
    protected int[] selectRightListIndexs = new int[0];
    public boolean isChanged = false;

    public BaseSelectItemUI() throws Exception {
        this.init();
    }

    private void init() throws Exception {
        this.btnMoveAllRight.setText(null);
        this.btnMoveAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnMoveRight.setText(null);
        this.btnMoveRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnMoveLeft.setText(null);
        this.btnMoveLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnMoveAllLeft.setText(null);
        this.btnMoveAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnMoveTop.setText(null);
        this.btnMoveTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnUpgrade.setText(null);
        this.btnUpgrade.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnDegrade.setText(null);
        this.btnDegrade.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveBottom.setText(null);
        this.btnMoveBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.allItemListModel = new KDSelectListModel();
        this.selectItemListModel = new KDSelectListModel();
        this.allItemList.setModel((ListModel)this.allItemListModel);
        this.selectItemList.setModel((ListModel)this.selectItemListModel);
        this.allItemList.setSelectionMode(0);
        this.selectItemList.setSelectionMode(0);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public KDSelectListModel getAllItemListModel() {
        return this.allItemListModel;
    }

    public KDSelectListModel getSelectItemListModel() {
        return this.selectItemListModel;
    }

    public List getAllSelectItems() {
        ArrayList<Object> lstObjs = new ArrayList<Object>();
        int count = this.getSelectItemListModel().size();
        for (int i = 0; i < count; ++i) {
            BaseSelectItemData item = (BaseSelectItemData)this.getSelectItemListModel().getElementAt(i);
            lstObjs.add(item.getDataObject());
        }
        return lstObjs;
    }

    public List getNewSelectItems() {
        ArrayList<Object> lstObjs = new ArrayList<Object>();
        int count = this.getSelectItemListModel().size();
        for (int i = 0; i < count; ++i) {
            BaseSelectItemData item = (BaseSelectItemData)this.getSelectItemListModel().getElementAt(i);
            if (item.getOperator() != OperatorEnum.ADDNEW) continue;
            lstObjs.add(item.getDataObject());
        }
        return lstObjs;
    }

    public List getDeleteItems() {
        ArrayList<Object> lstObjs = new ArrayList<Object>();
        int count = this.getAllItemListModel().size();
        for (int i = 0; i < count; ++i) {
            BaseSelectItemData item = (BaseSelectItemData)this.getAllItemListModel().getElementAt(i);
            if (item.getOperator() != OperatorEnum.DELETE) continue;
            lstObjs.add(item.getDataObject());
        }
        return lstObjs;
    }

    public int[] getSelectLeftListIndexs() {
        return this.selectLeftListIndexs;
    }

    public int[] getSelectRightListIndexs() {
        return this.selectRightListIndexs;
    }

    public void setSelectLeftListIndexs(int[] is) {
        this.selectLeftListIndexs = is;
    }

    public void setSelectRightListIndexs(int[] is) {
        this.selectRightListIndexs = is;
    }

    protected void switchLeftToRightState(BaseSelectItemData item) {
        if (item.getOperator() == OperatorEnum.NONE) {
            item.setOperator(OperatorEnum.ADDNEW);
        } else if (item.getOperator() == OperatorEnum.DELETE) {
            item.setOperator(OperatorEnum.NONE);
        }
    }

    protected void switchRightToLeftState(BaseSelectItemData item) {
        if (item.getOperator() == OperatorEnum.NONE) {
            item.setOperator(OperatorEnum.DELETE);
        } else if (item.getOperator() == OperatorEnum.ADDNEW) {
            item.setOperator(OperatorEnum.NONE);
        }
    }

    protected boolean canMoveSEQ(int[] selectIndexs) {
        if (selectIndexs == null || selectIndexs.length == 0) {
            this.handleException((Exception)((Object)new BaseSelectItemException(BaseSelectItemException.MISS_SELECT_SEQITEM)));
            return false;
        }
        if (selectIndexs.length > 1) {
            this.handleException((Exception)((Object)new BaseSelectItemException(BaseSelectItemException.SELECT_MULTI_SEQITEM)));
            return false;
        }
        return true;
    }

    @Override
    protected void btnMoveTop_actionPerformed(ActionEvent e) throws Exception {
        int index;
        super.btnMoveTop_actionPerformed(e);
        int[] selectIndexs = this.getSelectRightListIndexs();
        if (this.canMoveSEQ(selectIndexs) && (index = selectIndexs[0]) > 0) {
            BaseSelectItemData item = (BaseSelectItemData)this.getSelectItemListModel().getElementAt(index);
            this.getSelectItemListModel().removeElement(item);
            this.getSelectItemListModel().add(0, item);
            this.selectItemList.setSelectedIndex(0);
            this.isChanged = true;
        }
    }

    @Override
    protected void btnUpgrade_actionPerformed(ActionEvent e) throws Exception {
        int index;
        super.btnUpgrade_actionPerformed(e);
        int[] selectIndexs = this.getSelectRightListIndexs();
        if (this.canMoveSEQ(selectIndexs) && (index = selectIndexs[0]) > 0) {
            BaseSelectItemData item = (BaseSelectItemData)this.getSelectItemListModel().getElementAt(index);
            this.getSelectItemListModel().removeElement(item);
            this.getSelectItemListModel().add(index - 1, item);
            this.selectItemList.setSelectedIndex(index - 1);
            this.isChanged = true;
        }
    }

    @Override
    protected void btnDegrade_actionPerformed(ActionEvent e) throws Exception {
        int index;
        super.btnDegrade_actionPerformed(e);
        int[] selectIndexs = this.getSelectRightListIndexs();
        if (this.canMoveSEQ(selectIndexs) && (index = selectIndexs[0]) >= 0 && index + 1 < this.getSelectItemListModel().size()) {
            BaseSelectItemData item = (BaseSelectItemData)this.getSelectItemListModel().getElementAt(index);
            this.getSelectItemListModel().removeElement(item);
            this.getSelectItemListModel().add(index + 1, item);
            this.selectItemList.setSelectedIndex(index + 1);
            this.isChanged = true;
        }
    }

    @Override
    protected void btnMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        super.btnMoveBottom_actionPerformed(e);
        int[] selectIndexs = this.getSelectRightListIndexs();
        if (this.canMoveSEQ(selectIndexs)) {
            int index = selectIndexs[0];
            int size = this.getSelectItemListModel().size();
            if (index >= 0 && index + 1 < size) {
                BaseSelectItemData item = (BaseSelectItemData)this.getSelectItemListModel().getElementAt(index);
                this.getSelectItemListModel().removeElement(item);
                this.getSelectItemListModel().add(size - 1, item);
                this.selectItemList.setSelectedIndex(size - 1);
                this.isChanged = true;
            }
        }
    }

    @Override
    protected void btnMoveLeft_actionPerformed(ActionEvent e) throws Exception {
        super.btnMoveLeft_actionPerformed(e);
        int[] selectIndexs = this.getSelectLeftListIndexs();
        BaseSelectItemData[] selectItems = this.getAllItemListModel().getSelectItems(selectIndexs);
        if (selectItems == null) {
            this.handleException((Exception)((Object)new BaseSelectItemException(BaseSelectItemException.SELECT_LEFT_ITEMS)));
        } else {
            for (int i = 0; i < selectItems.length; ++i) {
                BaseSelectItemData item = selectItems[i];
                this.switchLeftToRightState(item);
            }
            this.getAllItemListModel().removeItems(selectIndexs);
            this.getSelectItemListModel().appendItems(selectItems);
            this.setSelectLeftListIndexs(new int[0]);
            this.allItemList.setSelectedIndex(-1);
            this.isChanged = true;
        }
    }

    @Override
    protected void btnMoveAllLeft_actionPerformed(ActionEvent e) throws Exception {
        super.btnMoveAllLeft_actionPerformed(e);
        for (int i = 0; i < this.getAllItemListModel().size(); ++i) {
            BaseSelectItemData item = (BaseSelectItemData)this.getAllItemListModel().getElementAt(i);
            this.switchLeftToRightState(item);
            this.getSelectItemListModel().addElement(item);
            this.isChanged = true;
        }
        this.getAllItemListModel().clear();
        this.setSelectLeftListIndexs(new int[0]);
        this.allItemList.setSelectedIndex(-1);
    }

    @Override
    protected void btnMoveAllRight_actionPerformed(ActionEvent e) throws Exception {
        super.btnMoveAllRight_actionPerformed(e);
        for (int i = 0; i < this.getSelectItemListModel().size(); ++i) {
            BaseSelectItemData item = (BaseSelectItemData)this.getSelectItemListModel().getElementAt(i);
            this.switchRightToLeftState(item);
            this.getAllItemListModel().addElement(item);
            this.isChanged = true;
        }
        this.getSelectItemListModel().clear();
        this.setSelectRightListIndexs(new int[0]);
        this.selectItemList.setSelectedIndex(-1);
    }

    @Override
    protected void btnMoveRight_actionPerformed(ActionEvent e) throws Exception {
        super.btnMoveRight_actionPerformed(e);
        int[] selectIndexs = this.getSelectRightListIndexs();
        BaseSelectItemData[] selectItems = this.getSelectItemListModel().getSelectItems(selectIndexs);
        if (selectItems == null) {
            this.handleException((Exception)((Object)new BaseSelectItemException(BaseSelectItemException.SELECT_RIGHT_ITEMS)));
        } else {
            for (int i = 0; i < selectItems.length; ++i) {
                BaseSelectItemData item = selectItems[i];
                this.switchRightToLeftState(item);
                this.isChanged = true;
            }
            this.selectItemListModel.removeItems(selectIndexs);
            this.getAllItemListModel().appendItems(selectItems);
            this.setSelectRightListIndexs(new int[0]);
            this.selectItemList.setSelectedIndex(-1);
        }
    }

    @Override
    protected void allItemList_mouseClicked(MouseEvent e) throws Exception {
        super.allItemList_mouseClicked(e);
        if (e.getClickCount() == 2 && this.btnMoveAllLeft.isEnabled()) {
            int index = this.allItemList.locationToIndex(e.getPoint());
            if (index < 0) {
                return;
            }
            BaseSelectItemData item = (BaseSelectItemData)this.getAllItemListModel().getElementAt(index);
            this.switchLeftToRightState(item);
            this.isChanged = true;
            this.getAllItemListModel().removeElement(item);
            this.getSelectItemListModel().addElement(item);
        }
    }

    @Override
    protected void allItemList_valueChanged(ListSelectionEvent e) throws Exception {
        super.allItemList_valueChanged(e);
        int[] selectIndex = this.allItemList.getSelectedIndices();
        if (selectIndex == null) {
            selectIndex = new int[]{};
        }
        this.setSelectLeftListIndexs(selectIndex);
    }

    @Override
    protected void selectItemList_mouseClicked(MouseEvent e) throws Exception {
        super.selectItemList_mouseClicked(e);
        if (e.getClickCount() == 2 && this.btnMoveAllLeft.isEnabled()) {
            int index = this.selectItemList.locationToIndex(e.getPoint());
            if (index < 0) {
                return;
            }
            BaseSelectItemData item = (BaseSelectItemData)this.getSelectItemListModel().getElementAt(index);
            this.switchRightToLeftState(item);
            this.getSelectItemListModel().removeElement(item);
            this.getAllItemListModel().addElement(item);
            this.isChanged = true;
        }
    }

    @Override
    protected void selectItemList_valueChanged(ListSelectionEvent e) throws Exception {
        super.selectItemList_valueChanged(e);
        int[] selectIndex = this.selectItemList.getSelectedIndices();
        if (selectIndex == null) {
            selectIndex = new int[]{};
        }
        this.setSelectRightListIndexs(selectIndex);
    }

    static class KDSelectListModel
    extends DefaultListModel {
        public KDSelectListModel() {
        }

        public KDSelectListModel(Vector lstData) {
            this.setListData(lstData, true);
        }

        public void setListData(Vector lstData, boolean isClearOld) {
            if (isClearOld) {
                this.clear();
            }
            for (Object obj : lstData) {
                BaseSelectItemData itemData = new BaseSelectItemData(obj);
                this.addElement(itemData);
            }
        }

        public void mutexModel(KDSelectListModel mutexModel) {
            for (int i = this.getSize() - 1; i >= 0; --i) {
                BaseSelectItemData obj = (BaseSelectItemData)this.getElementAt(i);
                if (!mutexModel.isContainsItem(obj)) continue;
                this.removeElement(obj);
            }
        }

        protected boolean isContainsItem(BaseSelectItemData obj) {
            CmpItemInfo judgeItem = (CmpItemInfo)obj.getDataObject();
            String judgeId = judgeItem.getId().toString();
            for (int i = 0; i < this.size(); ++i) {
                BaseSelectItemData itemData = (BaseSelectItemData)this.get(i);
                CmpItemInfo cmpItem = (CmpItemInfo)itemData.getDataObject();
                if (!judgeId.equals(cmpItem.getId().toString())) continue;
                return true;
            }
            return false;
        }

        public void appendModel(KDSelectListModel model) {
            for (int i = 0; i < model.size(); ++i) {
                this.addElement(model.get(i));
            }
        }

        public BaseSelectItemData[] getSelectItems(int[] indexs) {
            if (indexs == null || indexs.length == 0) {
                return null;
            }
            BaseSelectItemData[] items = new BaseSelectItemData[indexs.length];
            for (int i = 0; i < indexs.length; ++i) {
                items[i] = (BaseSelectItemData)this.get(indexs[i]);
            }
            return items;
        }

        public void appendItems(BaseSelectItemData[] items) {
            if (items == null) {
                return;
            }
            for (int i = 0; i < items.length; ++i) {
                this.addElement(items[i]);
            }
        }

        public void removeItems(int[] indexs) {
            if (indexs == null || indexs.length == 0) {
                return;
            }
            for (int i = indexs.length - 1; i >= 0; --i) {
                this.removeElementAt(indexs[i]);
            }
        }

        public void add(int index, BaseSelectItemData element) {
            super.add(index, element);
        }

        public void addElement(BaseSelectItemData obj) {
            super.addElement(obj);
        }

        public void setElementAt(BaseSelectItemData obj, int index) {
            super.setElementAt(obj, index);
        }
    }
}

