/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.compensation.AuditTypeEnum;
import com.kingdee.eas.hr.compensation.BillStateEnum;
import com.kingdee.eas.hr.compensation.BranchCompBillFactory;
import com.kingdee.eas.hr.compensation.BranchCompBillInfo;
import com.kingdee.eas.hr.compensation.client.AbstractBranchCompBillListUI;
import com.kingdee.eas.hr.compensation.client.BranchCompBillEditUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class BranchCompBillListUI
extends AbstractBranchCompBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(BranchCompBillListUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return BranchCompBillEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BranchCompBillFactory.getRemoteInstance();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue().toString();
        if (id != null) {
            BranchCompBillFactory.getRemoteInstance().auditPass(BOSUuid.read((String)id));
        }
        this.refreshList();
    }

    public void onLoad() throws Exception {
        HRSchemeUtils.checkInit();
        super.onLoad();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.MenuItemAttachment.setVisible(false);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        IRow row = this.tblMain.getRow(block.getTop());
        if (row != null) {
            if (row.getCell("billState").getValue().toString().equals(BillStateEnum.auditing.getAlias()) && row.getCell("auditType").getValue().toString().equals(AuditTypeEnum.directAudit.getAlias())) {
                this.actionAudit.setEnabled(true);
            } else {
                this.actionAudit.setEnabled(false);
            }
            if (row.getCell("billState").getValue().toString().equals(BillStateEnum.auditing.getAlias()) || row.getCell("billState").getValue().toString().equals(BillStateEnum.audited.getAlias())) {
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
            } else {
                this.actionEdit.setEnabled(true);
                this.actionRemove.setEnabled(true);
            }
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue().toString();
        BranchCompBillInfo info = BranchCompBillFactory.getRemoteInstance().getBranchCompBillInfo((IObjectPK)new ObjectStringPK(id));
        if (info.getBillState().equals((Object)BillStateEnum.temp) || info.getBillState().equals((Object)BillStateEnum.unAudited)) {
            super.actionEdit_actionPerformed(e);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue().toString();
        BranchCompBillInfo info = BranchCompBillFactory.getRemoteInstance().getBranchCompBillInfo((IObjectPK)new ObjectStringPK(id));
        if (info.getBillState().equals((Object)BillStateEnum.temp)) {
            super.actionRemove_actionPerformed(e);
            CodingRuleInfo codeRule = CodingRuleManagerFactory.getRemoteInstance().getCodingRule((IObjectValue)info, HRSchemeUtils.getCurrentCUID());
            if (codeRule != null && (codeRule.isIsaddnewbreak() || CodingRuleManagerFactory.getRemoteInstance().isUseIntermitNumber((IObjectValue)info, HRSchemeUtils.getCurrentCUID()))) {
                CodingRuleManagerFactory.getRemoteInstance().recycleNumber((IObjectValue)info, HRSchemeUtils.getCurrentCUID(), info.getNumber());
            }
        }
    }

    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("handler.name"));
        return sic;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.HRO;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", null));
        filterInfo.setMaskString("#0 or #1");
        return filterInfo;
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue().toString();
        BranchCompBillInfo info = BranchCompBillFactory.getRemoteInstance().getBranchCompBillInfo((IObjectPK)new ObjectStringPK(id));
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        String boID = this.getSelectedKeyValue();
        this.checkSelected();
        if (boID == null) {
            return;
        }
        AttachmentUIContextInfo attachmentInfo = new AttachmentUIContextInfo();
        attachmentInfo.setBoID(boID);
        attachmentInfo.setCode("");
        if (info.getBillState().equals((Object)BillStateEnum.audited)) {
            attachmentInfo.setEdit(false);
        } else {
            attachmentInfo.setEdit(true);
        }
        attachmentInfo.setListener(this.createAttatchListener("HEAD"));
        acm.showAttachmentListUIByBoID((Object)this, attachmentInfo);
    }
}

