/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeItemInfo;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.client.AbstractCmpCheckEditFilterPanelUI;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.compensation.util.PersonInfoUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CmpCheckEditFilterPanelUI
extends AbstractCmpCheckEditFilterPanelUI {
    private static final Logger logger = CoreUIObject.getLogger(CmpCheckEditFilterPanelUI.class);
    protected String resClass = "com.kingdee.eas.hr.compensation.client.PeriodEndInputResource.";
    protected List lstSelectItemData = new ArrayList();
    protected String strCmpSchemeID = null;

    public CmpCheckEditFilterPanelUI() throws Exception {
    }

    public CmpCheckEditFilterPanelUI(String schemeId) throws Exception {
        this.strCmpSchemeID = schemeId;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void initLayout() {
        super.initLayout();
        CompUtils.initF7SelectorNoHR(this, this.prmtAdminOrgUnit);
    }

    public void clear() {
        this.prmtAdminOrgUnit.setData(null);
        this.lstSelectItem.removeAllElements();
        this.lstAllItem.removeAllElements();
        this.unCheckedPerson.setSelected(false);
        try {
            this.fillAllItemList(this.getSchemeItemBySchemeId(), null);
            this.actionAllRight_actionPerformed(null);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.fillAllItemList(this.getSchemeItemBySchemeId(), this.lstSelectItemData);
        this.initWorkButton();
    }

    public FilterInfo getFilterInfo() {
        FilterInfo temp = new FilterInfo();
        int level = 0;
        if (this.chkInclude.isSelected()) {
            level = 99;
        }
        try {
            temp = PersonInfoUtils.addQuerySubDeptCondition(new EntityViewInfo(), (AdminOrgUnitInfo)this.prmtAdminOrgUnit.getData(), this.chkInclude.isSelected(), level).getFilter();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
            ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e);
        }
        return temp;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtAdminOrgUnit.getData() != null) {
            cp.addCustomerParam("adminOrgUnitId", ((AdminOrgUnitInfo)this.prmtAdminOrgUnit.getData()).getId().toString());
        }
        cp.addCustomerParam("isInclude", String.valueOf(this.chkInclude.isSelected()));
        cp.addCustomerParam("unCheckedPerson", String.valueOf(this.unCheckedPerson.isSelected()));
        cp.putBoolean("zeroItemDisplayNull", this.chkZeroItemDisplayNull.isSelected());
        int count = this.lstSelectItem.getElementCount();
        if (this.lstSelectItem.getElementCount() == 0) {
            return cp;
        }
        cp.putInt("SelectCount", count);
        CmpItemInfo cmpItemInfo = null;
        for (int i = 0; i < count; ++i) {
            cmpItemInfo = (CmpItemInfo)this.lstSelectItem.getElement(i);
            cp.addCustomerParam("SelectCount" + i, cmpItemInfo.getNumber());
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        ObjectUuidPK pk = null;
        if (cp.getCustomerParam("adminOrgUnitId") != null) {
            pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("adminOrgUnitId")));
            try {
                AdminOrgUnitInfo info = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)pk);
                this.prmtAdminOrgUnit.setData((Object)info);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage());
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        } else {
            this.prmtAdminOrgUnit.setData(null);
        }
        if (cp.getCustomerParam("isInclude") != null) {
            this.chkInclude.setSelected(Boolean.valueOf(cp.getCustomerParam("isInclude")).booleanValue());
        } else {
            this.chkInclude.setSelected(false);
        }
        if (cp.getCustomerParam("unCheckedPerson") != null) {
            this.unCheckedPerson.setSelected(Boolean.valueOf(cp.getCustomerParam("unCheckedPerson")).booleanValue());
        } else {
            this.unCheckedPerson.setSelected(false);
        }
        try {
            if (cp.getInt("SelectCount") != 0) {
                this.fillSelectList(cp, this.getSchemeItemBySchemeId());
            } else {
                this.lstSelectItem.removeAllElements();
                this.fillAllItemList(this.getSchemeItemBySchemeId(), null);
                this.actionAllRight_actionPerformed(null);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        this.chkZeroItemDisplayNull.setSelected(cp.getBoolean("zeroItemDisplayNull"));
    }

    private void fillSelectList(CustomerParams params, CmpSchemeItemCollection itemCollection) throws Exception {
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
        if (params == null) {
            return;
        }
        CmpItemInfo cmpItemInfo = null;
        Map defaultSelectMap = this.getDefaultSelectMap(params);
        Iterator itemIterator = itemCollection.iterator();
        if (itemCollection.size() <= 0) {
            return;
        }
        CmpSchemeItemInfo schemeItemInfo = null;
        HashMap<Integer, CmpItemInfo> tempMap = new HashMap<Integer, CmpItemInfo>();
        while (itemIterator.hasNext()) {
            schemeItemInfo = (CmpSchemeItemInfo)itemIterator.next();
            cmpItemInfo = new CmpItemInfo();
            cmpItemInfo.setId(BOSUuid.read((String)schemeItemInfo.getCmpItem().getId().toString()));
            cmpItemInfo.setNumber(schemeItemInfo.getCmpItem().getNumber());
            cmpItemInfo.setName(schemeItemInfo.getCmpItem().getName());
            cmpItemInfo.setDataType(ItemDataTypeEnum.getEnum(schemeItemInfo.getCmpItem().getType().toString()));
            cmpItemInfo.setDecDigital(schemeItemInfo.getCmpItem().getDecDigital());
            if (defaultSelectMap.containsKey(cmpItemInfo.getNumber())) {
                Integer index = (Integer)defaultSelectMap.get(cmpItemInfo.getNumber());
                tempMap.put(index, cmpItemInfo);
                continue;
            }
            this.lstAllItem.addElement((Object)cmpItemInfo);
        }
        ArrayList keyList = new ArrayList(tempMap.keySet());
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size(); ++i) {
            this.lstSelectItem.addElement(tempMap.get(keyList.get(i)));
        }
    }

    private Map getDefaultSelectMap(CustomerParams params) throws Exception {
        HashMap<String, Integer> defaultSelectMap = new HashMap<String, Integer>();
        if (params == null || params.getInt("SelectCount") == 0) {
            defaultSelectMap.put("FPER001", 0);
            defaultSelectMap.put("FPER002", 1);
            defaultSelectMap.put("FPER005", 2);
            defaultSelectMap.put("FPER004", 3);
            defaultSelectMap.put("FPER006", 4);
            defaultSelectMap.put("FPER017", 5);
            return defaultSelectMap;
        }
        int selectCount = params.getInt("SelectCount");
        for (int i = 0; i < selectCount; ++i) {
            defaultSelectMap.put(params.getCustomerParam("SelectCount" + i), i);
        }
        return defaultSelectMap;
    }

    private CmpSchemeItemCollection getSchemeItemBySchemeId() throws EASBizException, BOSException {
        String oql = "select *,cmpItem.* where isDelete=0 and cmpScheme='" + this.strCmpSchemeID + "' order by sortOrder";
        String cmpItemids = HRUtils.getCmpItemIds(null);
        oql = cmpItemids != null ? "select *,cmpItem.* where isDelete=0 and cmpScheme='" + this.strCmpSchemeID + "' and cmpItem.id in (" + cmpItemids + ") order by sortOrder" : "select *,cmpItem.* where isDelete=0 and cmpScheme='" + this.strCmpSchemeID + "' order by sortOrder";
        CmpSchemeItemCollection itemCollection = CmpSchemeItemFactory.getRemoteInstance().getCmpSchemeItemCollection(oql);
        return itemCollection;
    }

    protected void fillAllItemList(CmpSchemeItemCollection itemCollection, List lstSelectItemData) {
        this.lstAllItem.removeAllElements();
        Iterator itemIterator = itemCollection.iterator();
        if (itemCollection.size() <= 0) {
            return;
        }
        CmpSchemeItemInfo schemeItemInfo = null;
        while (itemIterator.hasNext()) {
            schemeItemInfo = (CmpSchemeItemInfo)itemIterator.next();
            if (lstSelectItemData == null) {
                this.lstAllItem.addElement((Object)schemeItemInfo.getCmpItem());
                continue;
            }
            boolean blIsExist = false;
            int size = lstSelectItemData.size();
            for (int i = 0; i < size; ++i) {
                if (!((CmpItemInfo)lstSelectItemData.get(i)).equals(schemeItemInfo.getCmpItem())) continue;
                blIsExist = true;
                break;
            }
            if (blIsExist) continue;
            this.lstAllItem.addElement((Object)schemeItemInfo.getCmpItem());
        }
        this.lstAllItem.setSelectedIndex(0);
    }

    protected void initWorkButton() {
        this.btnMoveTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnMovePre.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveNext.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.btnAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
    }

    public List getLstSelectItemData() {
        this.lstSelectItemData.clear();
        int n = this.lstSelectItem.getElementCount();
        for (int i = 0; i < n; ++i) {
            this.lstSelectItemData.add(this.lstSelectItem.getElement(i));
        }
        return this.lstSelectItemData;
    }

    @Override
    public void actionLeft_actionPerformed(ActionEvent e) throws Exception {
        if (this.lstSelectItem.getElementCount() <= 0) {
            return;
        }
        int index = this.lstSelectItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            if ("FPER001".equalsIgnoreCase(info.getNumber())) {
                return;
            }
            this.lstSelectItem.removeElement((Object)info);
            this.lstAllItem.addElement((Object)info);
            if (this.lstSelectItem.getElementCount() > 0) {
                if (index == this.lstSelectItem.getElementCount()) {
                    this.lstSelectItem.setSelectedIndex(index - 1);
                } else {
                    this.lstSelectItem.setSelectedIndex(index);
                }
            }
        }
    }

    @Override
    public void actionAllLeft_actionPerformed(ActionEvent e) throws Exception {
        int count = this.lstSelectItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            int seq = 0;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstSelectItem.getElement(seq);
                if ("FPER001".equalsIgnoreCase(info.getNumber())) {
                    ++seq;
                    continue;
                }
                this.lstAllItem.addElement((Object)info);
                this.lstSelectItem.removeElement((Object)info);
            }
            this.lstAllItem.setSelectedIndex(0);
        }
    }

    @Override
    public void actionAllRight_actionPerformed(ActionEvent e) throws Exception {
        int count = this.lstAllItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstAllItem.getElement(0);
                this.lstSelectItem.addElement((Object)info);
                this.lstAllItem.removeElement((Object)info);
            }
            this.lstSelectItem.setSelectedIndex(0);
        }
    }

    @Override
    public void actionRight_actionPerformed(ActionEvent e) throws Exception {
        if (this.lstAllItem.getElementCount() <= 0) {
            return;
        }
        int index = this.lstAllItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstAllItem.getElement(index);
            int indexSelect = this.lstSelectItem.getSelectedIndex() + 1;
            this.lstSelectItem.insertElement((Object)info, indexSelect);
            this.lstAllItem.removeElement((Object)info);
            if (index - 1 > 0) {
                this.lstAllItem.setSelectedIndex(index - 1);
            } else if (this.lstAllItem.getElementCount() > 0) {
                this.lstAllItem.setSelectedIndex(0);
            }
            this.lstSelectItem.setSelectedValue((Object)info, true);
        }
    }

    @Override
    public void actionMoveTop_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstSelectItem.getSelectedIndex();
        if (index > 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, 0);
            this.lstSelectItem.setSelectedIndex(0);
        }
    }

    @Override
    public void actionMovePre_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstSelectItem.getSelectedIndex();
        if (index > 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, index - 1);
            this.lstSelectItem.setSelectedIndex(index - 1);
        }
    }

    @Override
    public void actionMoveNext_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstSelectItem.getSelectedIndex();
        int count = this.lstSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, index + 1);
            this.lstSelectItem.setSelectedIndex(index + 1);
        }
    }

    @Override
    public void actionMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstSelectItem.getSelectedIndex();
        int count = this.lstSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, count - 1);
            this.lstSelectItem.setSelectedIndex(count - 1);
        }
    }

    protected void initListener() {
        super.initListener();
        this.lstAllItem.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (e.getClickCount() > 1) {
                        CmpCheckEditFilterPanelUI.this.actionRight_actionPerformed(null);
                    }
                }
                catch (Exception exc) {
                    CmpCheckEditFilterPanelUI.this.handUIException(exc);
                }
            }
        });
        this.lstSelectItem.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (e.getClickCount() > 1) {
                        CmpCheckEditFilterPanelUI.this.actionLeft_actionPerformed(null);
                    }
                }
                catch (Exception exc) {
                    CmpCheckEditFilterPanelUI.this.handUIException(exc);
                }
            }
        });
    }
}

