/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.BaseCommonQueryClientException;
import com.kingdee.eas.base.commonquery.BooleanEnum;
import com.kingdee.eas.base.commonquery.CompareSignDateEnum;
import com.kingdee.eas.base.commonquery.CompareSignEnum;
import com.kingdee.eas.base.commonquery.CompareSignIntEnum;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.client.CmpItemFilterInfo;
import com.kingdee.eas.hr.compensation.client.CmpItemFilterUI;
import com.kingdee.eas.hr.compensation.client.CmpItemQueryInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class CmpItemFilterUtil {
    private static Logger logger = Logger.getLogger(CmpItemFilterUtil.class);
    private static String time = " 00:00:00";
    private static String timeEnd = " 23:59:59";

    protected static DataObject getRefMetaData(CmpItemQueryInfo queryInfo, String queryFieldName) {
        if (StringUtils.isEmpty((String)queryFieldName) || queryInfo == null) {
            return null;
        }
        CmpItemFilterInfo item = queryInfo.getCmpItem(queryFieldName);
        com.kingdee.eas.base.commonquery.DataObject do1 = CmpItemFilterUtil.getDataTypeInfo(item);
        return CmpItemFilterUtil.toClientDataObject(do1);
    }

    public static com.kingdee.eas.base.commonquery.DataObject getDataTypeInfo(CmpItemFilterInfo item) {
        com.kingdee.eas.base.commonquery.DataObject dataObject = null;
        if (item != null) {
            dataObject = new com.kingdee.eas.base.commonquery.DataObject();
            dataObject.setName(item.getType().getName());
            dataObject.setValue(null);
        }
        return dataObject;
    }

    public static FilterInfo toVerifyFilter(CmpItemQueryInfo queryInfo, FilterInfo filterInfo) {
        FilterInfo filtertemp = new FilterInfo();
        boolean flag = false;
        StringBuffer compareValue = new StringBuffer();
        String propertyname = null;
        CompareType compare = null;
        if (filterInfo != null) {
            int filterSize;
            FilterItemCollection fcol = filterInfo.getFilterItems();
            if (filterInfo.getMaskString() != null && filterInfo.getMaskString().indexOf("and") < 0 && filterInfo.getMaskString().indexOf("AND") < 0 && (filterSize = fcol.size()) >= 2) {
                propertyname = fcol.get(0).getPropertyName();
                compare = fcol.get(0).getCompareType();
                for (int i = 0; i < filterSize; ++i) {
                    FilterItemInfo item = fcol.get(i);
                    if (item.getPropertyName().equals(propertyname) && item.getCompareType() == compare) {
                        String dataType;
                        DataObject dataObj = CmpItemFilterUtil.getRefMetaData(queryInfo, item.getPropertyName());
                        String string = dataType = dataObj == null ? "" : dataObj.getName();
                        if (!DataType.STRING.getName().equalsIgnoreCase(dataType)) {
                            flag = false;
                            break;
                        }
                        flag = true;
                        compareValue.append(item.getCompareValue().toString());
                        if (i == filterSize - 1) continue;
                        compareValue.append(",");
                        continue;
                    }
                    flag = false;
                    break;
                }
            }
        }
        if (flag) {
            FilterItemInfo filterItemInfo = new FilterItemInfo(propertyname, (Object)compareValue.toString(), compare);
            filtertemp.getFilterItems().add(filterItemInfo);
            return filtertemp;
        }
        return filterInfo;
    }

    public static DataObject getCompareValueObject(CmpItemQueryInfo queryInfo, String value) throws BaseCommonQueryClientException {
        if (queryInfo == null || StringUtils.isEmpty((String)value)) {
            return null;
        }
        DataObject dataObject = null;
        CmpItemFilterInfo item = queryInfo.getCmpItem(value);
        if (item != null) {
            dataObject = new DataObject();
            dataObject.setName(item.getAlias());
            dataObject.setValue(item.getName());
        }
        return dataObject;
    }

    public static String getQueryFieldAlias(String selectedName, CmpItemQueryInfo queryInfo) {
        String name = null;
        if (queryInfo == null || StringUtils.isEmpty((String)selectedName)) {
            return null;
        }
        CmpItemFilterInfo item = queryInfo.getCmpItem(selectedName);
        if (item != null) {
            name = item.getAlias();
        }
        return name;
    }

    private static DataObject toClientDataObject(com.kingdee.eas.base.commonquery.DataObject do1) {
        if (do1 == null) {
            return null;
        }
        DataObject dataObject = new DataObject();
        dataObject.setColLength(do1.getColLength());
        dataObject.setExtendValue(do1.getExtendValue());
        dataObject.setName(do1.getName());
        dataObject.setValue(do1.getValue());
        return dataObject;
    }

    protected static Date getDate(Date date, String type) {
        return CmpItemFilterUtil.getDate(date, type, null);
    }

    protected static Date getDate(Date date, String type, CompareSignDateEnum sign) {
        return QueryUtils.getDate((Date)date, (String)type, (CompareSignDateEnum)sign);
    }

    protected static boolean isIncludeCompare(CompareSignEnum compareSignEnum) {
        if (compareSignEnum != null) {
            if (compareSignEnum.equals((Object)CompareSignEnum.INCLUDESIGN)) {
                return true;
            }
            if (compareSignEnum.equals((Object)CompareSignEnum.NOTINCLUDESIGN)) {
                return true;
            }
        }
        return false;
    }

    protected static KDComboBox setEnumComboBoxField(KDTable table, int rowIndex, int colIndex, String enumClassName, String fieldValue) {
        ArrayList list = EnumUtils.getEnumList((String)enumClassName);
        if (CompareSignIntEnum.class.getName().equals(enumClassName)) {
            ArrayList process = new ArrayList();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                if (CompareSignIntEnum.NULLSIGN.equals(list.get(i)) || CompareSignIntEnum.NOTNULLSIGN.equals(list.get(i))) continue;
                process.add(list.get(i));
            }
            list = process;
        }
        Object[] array = list.toArray();
        Object[] temp = CmpItemFilterUtil.addObjectToArray(array, "");
        KDComboBox comboBox = CmpItemFilterUtil.setComboBoxField(table, rowIndex, colIndex, temp);
        comboBox.setMaximumRowCount(10);
        int count = comboBox.getItemCount();
        int selectedIndex = 0;
        for (int i = 0; i < count; ++i) {
            Object obj = comboBox.getItemAt(i);
            Object value = null;
            if (obj == null || !(obj instanceof Enum)) continue;
            Enum enum1 = (Enum)obj;
            value = CmpItemFilterUtil.getEnumValue((Enum)obj);
            if (!value.toString().equalsIgnoreCase(fieldValue)) continue;
            selectedIndex = i;
            break;
        }
        comboBox.setSelectedIndex(selectedIndex);
        comboBox.setSelectedItem(temp[selectedIndex]);
        table.getRow(rowIndex).getCell(colIndex).setValue(comboBox.getItemAt(selectedIndex));
        return comboBox;
    }

    protected static KDComboBox setComboBoxField(KDTable kdTable, int rowIndex, int colIndex, Object[] objs) {
        KDComboBox kdComboBox = new KDComboBox(objs);
        kdComboBox.setMaximumRowCount(10);
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JComboBox)kdComboBox);
        kdTable.getRow(rowIndex).getCell(colIndex).setEditor((ICellEditor)kdtDefaultCellEditor);
        return kdComboBox;
    }

    protected static Object[] addObjectToArray(Object[] objects, Object insertObject) {
        Object[] DEFAULT_OBJECTs = new Object[]{insertObject};
        if (objects == null) {
            return DEFAULT_OBJECTs;
        }
        int length = objects.length;
        if (length == 0) {
            return DEFAULT_OBJECTs;
        }
        Object[] results = new Object[length + 1];
        results[0] = DEFAULT_OBJECTs[0];
        for (int i = 1; i <= length; ++i) {
            results[i] = objects[i - 1];
        }
        return results;
    }

    public static Object getEnumValue(Enum enumValue) {
        Object value = null;
        if (enumValue instanceof BooleanEnum) {
            value = ((IntEnum)enumValue).getValue();
        } else if (enumValue instanceof IntEnum) {
            value = ((IntEnum)enumValue).getValue();
        } else if (enumValue instanceof FloatEnum) {
            value = String.valueOf(((FloatEnum)enumValue).getValue());
        } else if (enumValue instanceof DoubleEnum) {
            value = String.valueOf(((DoubleEnum)enumValue).getValue());
        } else if (enumValue instanceof LongEnum) {
            value = String.valueOf(((LongEnum)enumValue).getValue());
        } else if (enumValue instanceof StringEnum) {
            value = ((StringEnum)enumValue).getValue();
        }
        return value;
    }

    protected static void setDateCtrlField(KDTable kdTable, int rowIndex, int colIndex, Date initDate) {
        KDDatePicker datePicker = new KDDatePicker();
        if (initDate instanceof Timestamp) {
            datePicker.setTimeEnabled(true);
        } else if (initDate instanceof Time) {
            datePicker.setTimeEnabled(true);
        }
        datePicker.setValue((Object)initDate);
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor(datePicker);
        kdTable.getRow(rowIndex).getCell(colIndex).setEditor((ICellEditor)kdtDefaultCellEditor);
    }

    protected static boolean isString(CmpItemQueryInfo queryInfo, String queryFieldName) {
        if (queryInfo == null || StringUtils.isEmpty((String)queryFieldName)) {
            return false;
        }
        Object dataObject = null;
        CmpItemFilterInfo item = queryInfo.getCmpItem(queryFieldName);
        if (item != null) {
            return DataType.STRING.equals((Object)item.getType());
        }
        return false;
    }

    protected static Vector processStringValue(String str) {
        Vector<String> vect = new Vector<String>();
        if (str.indexOf(",") > 0) {
            StringTokenizer tokenizer = new StringTokenizer(str, ",");
            while (tokenizer.hasMoreTokens()) {
                String temp = tokenizer.nextToken().trim();
                vect.add(temp);
            }
        } else if (str.indexOf(";") > 0) {
            StringTokenizer tokenizer = new StringTokenizer(str, ";");
            while (tokenizer.hasMoreTokens()) {
                String temp = tokenizer.nextToken().trim();
                vect.add(temp);
            }
        } else {
            vect.add(str);
        }
        return vect;
    }

    protected static Set processIncludeValue(String str) {
        HashSet<String> value = new HashSet<String>();
        if (str.indexOf(";") > 0) {
            StringTokenizer tokenizer = new StringTokenizer(str, ";");
            while (tokenizer.hasMoreTokens()) {
                String temp = tokenizer.nextToken();
                value.add(temp);
            }
        } else {
            value.add(str);
        }
        return value;
    }

    protected static DataObject[] getConditionArray(CmpItemQueryInfo queryInfo) {
        if (queryInfo == null) {
            return null;
        }
        List conditions = queryInfo.getItems();
        if (conditions == null) {
            return null;
        }
        DataObject[] dataObjects = null;
        int size = conditions.size();
        dataObjects = new DataObject[size];
        CmpItemFilterInfo fieldInfo = null;
        for (int i = 0; i < size; ++i) {
            dataObjects[i] = new DataObject();
            fieldInfo = (CmpItemFilterInfo)conditions.get(i);
            dataObjects[i].setName(fieldInfo.getAlias());
            dataObjects[i].setValue(fieldInfo.getName());
        }
        return dataObjects;
    }

    public static CmpItemQueryInfo getQueryInfoByCmpItemInfo(CmpItemInfo[] itemInfos) {
        if (itemInfos == null || itemInfos.length <= 0) {
            return null;
        }
        return CmpItemFilterUtil.addCmpItemInfo(null, itemInfos);
    }

    public static DataType getDataType(ItemDataTypeEnum type) {
        if (type == null) {
            return null;
        }
        if (ItemDataTypeEnum.DATE.equals((Object)type)) {
            return DataType.DATE;
        }
        if (ItemDataTypeEnum.CURRENCY.equals((Object)type)) {
            return DataType.DECIMAL;
        }
        if (ItemDataTypeEnum.FLOAT.equals((Object)type)) {
            return DataType.FLOAT;
        }
        if (ItemDataTypeEnum.INT.equals((Object)type)) {
            return DataType.INTEGER;
        }
        if (ItemDataTypeEnum.LOGIC.equals((Object)type)) {
            return DataType.BOOLEAN;
        }
        if (ItemDataTypeEnum.STRING.equals((Object)type)) {
            return DataType.STRING;
        }
        return null;
    }

    public static CmpItemQueryInfo addCmpItemInfo(CmpItemQueryInfo queryInfo, CmpItemInfo[] itemInfos) {
        if (itemInfos == null || itemInfos.length <= 0) {
            return queryInfo;
        }
        if (queryInfo == null) {
            queryInfo = new CmpItemQueryInfo();
        }
        CmpItemFilterInfo cmpFilter = null;
        for (int i = 0; i < itemInfos.length; ++i) {
            cmpFilter = new CmpItemFilterInfo();
            cmpFilter.setName(itemInfos[i].getNumber());
            cmpFilter.setAlias(itemInfos[i].getName());
            cmpFilter.setType(CmpItemFilterUtil.getDataType(itemInfos[i].getDataType()));
            queryInfo.addCmpItem(cmpFilter.getName(), cmpFilter);
        }
        return queryInfo;
    }

    public static void setCmpItemFilterUIQueryInfo(CmpItemFilterUI cmpItemFilterUI, boolean isClear, boolean isNew, KDList items) {
        CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(cmpItemFilterUI, isClear, isNew, CmpItemFilterUtil.getCmpItems(items));
    }

    public static void setCmpItemFilterUIQueryInfo(CmpItemFilterUI cmpItemFilterUI, boolean isClear, boolean isNew, CmpItemInfo[] items) {
        if (cmpItemFilterUI == null) {
            return;
        }
        CmpItemQueryInfo queryInfo = null;
        if (isNew) {
            queryInfo = CmpItemFilterUtil.getQueryInfoByCmpItemInfo(CmpItemFilterUtil.getCmpItems(items));
            if (queryInfo == null) {
                queryInfo = new CmpItemQueryInfo();
            }
        } else {
            queryInfo = cmpItemFilterUI.getQueryInfo();
            queryInfo = CmpItemFilterUtil.addCmpItemInfo(queryInfo, CmpItemFilterUtil.getCmpItems(items));
        }
        cmpItemFilterUI.setQueryInfo(queryInfo);
        if (isClear) {
            cmpItemFilterUI.clear();
        }
    }

    public static CmpItemInfo[] getCmpItems(CmpItemInfo[] items) {
        if (items == null || items.length <= 0) {
            return null;
        }
        ArrayList<CmpItemInfo> listSalItem = null;
        CmpItemInfo itemInfo2 = null;
        for (CmpItemInfo itemInfo2 : items) {
            if (itemInfo2 == null || itemInfo2.getNumber().startsWith("FPER")) continue;
            if (listSalItem == null) {
                listSalItem = new ArrayList<CmpItemInfo>();
            }
            listSalItem.add(itemInfo2);
        }
        if (listSalItem != null) {
            CmpItemInfo[] itemss = new CmpItemInfo[listSalItem.size()];
            int size = listSalItem.size();
            for (int i = 0; i < size; ++i) {
                itemss[i] = (CmpItemInfo)listSalItem.get(i);
            }
            return itemss;
        }
        return null;
    }

    public static CmpItemInfo[] getCmpItems(KDList selectItems) {
        if (selectItems == null || selectItems.getElementCount() <= 0) {
            return null;
        }
        int count = selectItems.getElementCount();
        CmpItemInfo[] items = new CmpItemInfo[count];
        for (int i = 0; i < count; ++i) {
            items[i] = (CmpItemInfo)selectItems.getElement(i);
        }
        return items;
    }

    protected static String getTimeFormatForTable(String dateType) {
        String format = "%{" + CmpItemFilterUtil.getTimeFormat(dateType) + "}t";
        return format;
    }

    protected static String getTimeFormat(String dateType) {
        return QueryUtils.getTimeFormat((String)dateType);
    }

    public static FilterInfo getYesterdayFilterInfo(FilterInfo newFilterInfo, String name, CmpItemQueryInfo queryInfo) {
        return CmpItemFilterUtil.getYesterdayFilterInfo(null, newFilterInfo, name, queryInfo);
    }

    public static FilterInfo getYesterdayFilterInfo(Context ctx, FilterInfo newFilterInfo, String name, CmpItemQueryInfo queryInfo) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Calendar worldTour = Calendar.getInstance();
        worldTour.add(5, -1);
        Date d = worldTour.getTime();
        worldTour.setTime(d);
        String yesterday = df.format(d);
        yesterday = yesterday + time;
        try {
            Date dateBreakStart = df.parse(yesterday);
            String dateType = CmpItemFilterUtil.getRefMetaData(queryInfo, name).getName();
            dateBreakStart = QueryUtils.getDate((Date)dateBreakStart, (String)dateType);
            FilterItemInfo filterItemInfo1 = new FilterItemInfo(name, (Object)dateBreakStart, CompareType.getEnum((String)">="));
            newFilterInfo.getFilterItems().add(filterItemInfo1);
        }
        catch (ParseException e) {
            logger.error((Object)"parser error", (Throwable)e);
        }
        worldTour = Calendar.getInstance();
        worldTour.add(5, 0);
        d = worldTour.getTime();
        worldTour.setTime(d);
        String today = df.format(d);
        today = today + time;
        try {
            Date dateDayEnd = df.parse(today);
            String dateType = CmpItemFilterUtil.getRefMetaData(queryInfo, name).getName();
            dateDayEnd = QueryUtils.getDate((Date)dateDayEnd, (String)dateType);
            FilterItemInfo filterItemInfo2 = new FilterItemInfo(name, (Object)dateDayEnd, CompareType.getEnum((String)"<"));
            newFilterInfo.getFilterItems().add(filterItemInfo2);
        }
        catch (ParseException e1) {
            logger.error((Object)"parser error", (Throwable)e1);
        }
        return newFilterInfo;
    }

    protected static boolean isBoolean(CmpItemQueryInfo queryInfo, String queryFieldName) {
        DataObject dateType = CmpItemFilterUtil.getRefMetaData(queryInfo, queryFieldName);
        return dateType != null && dateType.getName().equals(DataType.BOOLEAN.getName());
    }

    public static FilterInfo getTodayFilterInfo(Context ctx, FilterInfo newFilterInfo, String name, CmpItemQueryInfo queryInfo) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Calendar worldTour = Calendar.getInstance();
        worldTour.add(5, 0);
        Date d = worldTour.getTime();
        worldTour.setTime(d);
        String today = df.format(d);
        today = today + time;
        try {
            Date dateBreakStart = df.parse(today);
            String dateType = CmpItemFilterUtil.getRefMetaData(queryInfo, name).getName();
            dateBreakStart = QueryUtils.getDate((Date)dateBreakStart, (String)dateType);
            FilterItemInfo filterItemInfo1 = new FilterItemInfo(name, (Object)dateBreakStart, CompareType.getEnum((String)">="));
            newFilterInfo.getFilterItems().add(filterItemInfo1);
        }
        catch (ParseException e) {
            logger.error((Object)"parser error", (Throwable)e);
        }
        worldTour = Calendar.getInstance();
        worldTour.add(5, 1);
        d = worldTour.getTime();
        worldTour.setTime(d);
        String tomorrow = df.format(d);
        tomorrow = tomorrow + time;
        try {
            Date dateDayEnd = df.parse(tomorrow);
            String dateType = CmpItemFilterUtil.getRefMetaData(queryInfo, name).getName();
            dateDayEnd = QueryUtils.getDate((Date)dateDayEnd, (String)dateType);
            FilterItemInfo filterItemInfo2 = new FilterItemInfo(name, (Object)dateDayEnd, CompareType.getEnum((String)"<"));
            newFilterInfo.getFilterItems().add(filterItemInfo2);
        }
        catch (ParseException e1) {
            logger.error((Object)"parser error", (Throwable)e1);
        }
        return newFilterInfo;
    }

    public static FilterInfo getTomorrowFilterInfo(Context ctx, FilterInfo newFilterInfo, String conditionName, CmpItemQueryInfo queryInfo) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Calendar worldTour = Calendar.getInstance();
        worldTour.add(5, 1);
        Date d = worldTour.getTime();
        worldTour.setTime(d);
        String tomorrow = df.format(d);
        tomorrow = tomorrow + time;
        try {
            Date dateBreakStart = df.parse(tomorrow);
            String dateType = CmpItemFilterUtil.getRefMetaData(queryInfo, conditionName).getName();
            dateBreakStart = QueryUtils.getDate((Date)dateBreakStart, (String)dateType);
            FilterItemInfo filterItemInfo1 = new FilterItemInfo(conditionName, (Object)dateBreakStart, CompareType.getEnum((String)">="));
            newFilterInfo.getFilterItems().add(filterItemInfo1);
        }
        catch (ParseException e) {
            logger.error((Object)"parser error", (Throwable)e);
        }
        worldTour = Calendar.getInstance();
        worldTour.add(5, 2);
        d = worldTour.getTime();
        worldTour.setTime(d);
        String tomorrowtomorrow = df.format(d);
        tomorrowtomorrow = tomorrowtomorrow + time;
        try {
            Date dateDayEnd = df.parse(tomorrowtomorrow);
            String dateType = CmpItemFilterUtil.getRefMetaData(queryInfo, conditionName).getName();
            dateDayEnd = QueryUtils.getDate((Date)dateDayEnd, (String)dateType);
            FilterItemInfo filterItemInfo2 = new FilterItemInfo(conditionName, (Object)dateDayEnd, CompareType.getEnum((String)"<"));
            newFilterInfo.getFilterItems().add(filterItemInfo2);
        }
        catch (ParseException e1) {
            logger.error((Object)"parser error", (Throwable)e1);
        }
        return newFilterInfo;
    }

    public static FilterInfo getLastWeekFilterInfo(Context ctx, FilterInfo newFilterInfo, String conditionName, CmpItemQueryInfo queryInfo) {
        Calendar lastWeek = Calendar.getInstance();
        lastWeek.add(11, -168);
        Date d = lastWeek.getTime();
        lastWeek = Calendar.getInstance();
        lastWeek.setTime(d);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        lastWeek.set(7, 1);
        Date lastWeekSunday = lastWeek.getTime();
        String lastWeekSundayStr = df.format(lastWeekSunday);
        String compareValue1 = lastWeekSundayStr + time;
        try {
            Date dateBreakStart = df.parse(compareValue1);
            String dateType = CmpItemFilterUtil.getRefMetaData(queryInfo, conditionName).getName();
            dateBreakStart = QueryUtils.getDate((Date)dateBreakStart, (String)dateType);
            FilterItemInfo filterItemInfo1 = new FilterItemInfo(conditionName, (Object)dateBreakStart, CompareType.getEnum((String)">="));
            newFilterInfo.getFilterItems().add(filterItemInfo1);
        }
        catch (ParseException e) {
            logger.error((Object)"parser error", (Throwable)e);
        }
        lastWeek.set(7, 7);
        Date lastWeekSaturday = lastWeek.getTime();
        String lastWeekSaturdayStr = df.format(lastWeekSaturday);
        String compareValue2 = lastWeekSaturdayStr + timeEnd;
        try {
            Date dateDayEnd = df.parse(compareValue2);
            String dateType = CmpItemFilterUtil.getRefMetaData(queryInfo, conditionName).getName();
            dateDayEnd = QueryUtils.getDate((Date)dateDayEnd, (String)dateType);
            FilterItemInfo filterItemInfo2 = new FilterItemInfo(conditionName, (Object)dateDayEnd, CompareType.getEnum((String)"<="));
            newFilterInfo.getFilterItems().add(filterItemInfo2);
        }
        catch (ParseException e1) {
            logger.error((Object)"parser error", (Throwable)e1);
        }
        return newFilterInfo;
    }

    public static FilterInfo getThisWeekFilterInfo(Context ctx, FilterInfo newFilterInfo, String conditionName, CmpItemQueryInfo queryInfo) {
        Calendar lastWeek = Calendar.getInstance();
        lastWeek.add(11, 0);
        Date d = lastWeek.getTime();
        lastWeek = Calendar.getInstance();
        lastWeek.setTime(d);
        String dateFormatStr = CtrlFormatUtilities.getDateFormatString();
        SimpleDateFormat df = new SimpleDateFormat(dateFormatStr);
        lastWeek.set(7, 1);
        Date lastWeekSunday = lastWeek.getTime();
        String lastWeekSundayStr = df.format(lastWeekSunday);
        String compareValue1 = lastWeekSundayStr + time;
        try {
            Date dateBreakStart = df.parse(compareValue1);
            String dateType = CmpItemFilterUtil.getRefMetaData(queryInfo, conditionName).getName();
            dateBreakStart = QueryUtils.getDate((Date)dateBreakStart, (String)dateType);
            FilterItemInfo filterItemInfo1 = new FilterItemInfo(conditionName, (Object)dateBreakStart, CompareType.getEnum((String)">="));
            newFilterInfo.getFilterItems().add(filterItemInfo1);
        }
        catch (ParseException e) {
            logger.error((Object)"parser error", (Throwable)e);
        }
        lastWeek.set(7, 7);
        Date lastWeekSaturday = lastWeek.getTime();
        String lastWeekSaturdayStr = df.format(lastWeekSaturday);
        String compareValue2 = lastWeekSaturdayStr + timeEnd;
        try {
            Date dateDayEnd = df.parse(compareValue2);
            String dateType = CmpItemFilterUtil.getRefMetaData(queryInfo, conditionName).getName();
            dateDayEnd = QueryUtils.getDate((Date)dateDayEnd, (String)dateType);
            FilterItemInfo filterItemInfo2 = new FilterItemInfo(conditionName, (Object)dateDayEnd, CompareType.getEnum((String)"<="));
            newFilterInfo.getFilterItems().add(filterItemInfo2);
        }
        catch (ParseException e1) {
            logger.error((Object)"parser error", (Throwable)e1);
        }
        return newFilterInfo;
    }

    public static FilterInfo getNextWeekFilterInfo(Context ctx, FilterInfo newFilterInfo, String conditionName, CmpItemQueryInfo queryInfo) {
        Calendar lastWeek = Calendar.getInstance();
        lastWeek.add(11, 168);
        Date d = lastWeek.getTime();
        lastWeek = Calendar.getInstance();
        lastWeek.setTime(d);
        String dateFormatStr = CtrlFormatUtilities.getDateFormatString();
        SimpleDateFormat df = new SimpleDateFormat(dateFormatStr);
        lastWeek.set(7, 1);
        Date lastWeekSunday = lastWeek.getTime();
        String lastWeekSundayStr = df.format(lastWeekSunday);
        String compareValue1 = lastWeekSundayStr + time;
        try {
            Date dateBreakStart = df.parse(compareValue1);
            String dateType = CmpItemFilterUtil.getRefMetaData(queryInfo, conditionName).getName();
            dateBreakStart = QueryUtils.getDate((Date)dateBreakStart, (String)dateType);
            FilterItemInfo filterItemInfo1 = new FilterItemInfo(conditionName, (Object)dateBreakStart, CompareType.getEnum((String)">="));
            newFilterInfo.getFilterItems().add(filterItemInfo1);
        }
        catch (ParseException e) {
            logger.error((Object)"parser error", (Throwable)e);
        }
        lastWeek.set(7, 7);
        Date lastWeekSaturday = lastWeek.getTime();
        String lastWeekSaturdayStr = df.format(lastWeekSaturday);
        String compareValue2 = lastWeekSaturdayStr + timeEnd;
        try {
            Date dateDayEnd = df.parse(compareValue2);
            String dateType = CmpItemFilterUtil.getRefMetaData(queryInfo, conditionName).getName();
            dateDayEnd = QueryUtils.getDate((Date)dateDayEnd, (String)dateType);
            FilterItemInfo filterItemInfo2 = new FilterItemInfo(conditionName, (Object)dateDayEnd, CompareType.getEnum((String)"<="));
            newFilterInfo.getFilterItems().add(filterItemInfo2);
        }
        catch (ParseException e1) {
            logger.error((Object)"parser error", (Throwable)e1);
        }
        return newFilterInfo;
    }

    public static FilterInfo getLastMonthFilterInfo(Context ctx, FilterInfo newFilterInfo, String conditionName, CmpItemQueryInfo queryInfo) {
        String dateFormatStr = CtrlFormatUtilities.getDateFormatString();
        SimpleDateFormat df = new SimpleDateFormat(dateFormatStr);
        Calendar lastmonth = Calendar.getInstance();
        lastmonth.add(2, -1);
        Date d = lastmonth.getTime();
        lastmonth = Calendar.getInstance();
        lastmonth.setTime(d);
        Date lastMonthStart = lastmonth.getTime();
        String lastMonthStartStr = df.format(lastMonthStart);
        String compareValue1 = lastMonthStartStr.substring(0, lastMonthStartStr.indexOf("-", 6) + 1) + "01 00:00:00";
        try {
            Date dateBreakStart = df.parse(compareValue1);
            String dateType = CmpItemFilterUtil.getRefMetaData(queryInfo, conditionName).getName();
            dateBreakStart = QueryUtils.getDate((Date)dateBreakStart, (String)dateType);
            FilterItemInfo filterItemInfo1 = new FilterItemInfo(conditionName, (Object)dateBreakStart, CompareType.getEnum((String)">="));
            newFilterInfo.getFilterItems().add(filterItemInfo1);
        }
        catch (ParseException e) {
            logger.error((Object)"parser error", (Throwable)e);
        }
        Calendar thismonth = Calendar.getInstance();
        thismonth.add(2, 0);
        d = thismonth.getTime();
        thismonth = Calendar.getInstance();
        thismonth.setTime(d);
        Date thisMonthStart = thismonth.getTime();
        String thisMonthStartStr = df.format(thisMonthStart);
        String compareValue2 = thisMonthStartStr.substring(0, thisMonthStartStr.indexOf("-", 6) + 1) + "01 00:00:00";
        try {
            Date dateDayEnd = df.parse(compareValue2);
            String dateType = CmpItemFilterUtil.getRefMetaData(queryInfo, conditionName).getName();
            dateDayEnd = QueryUtils.getDate((Date)dateDayEnd, (String)dateType);
            FilterItemInfo filterItemInfo2 = new FilterItemInfo(conditionName, (Object)dateDayEnd, CompareType.getEnum((String)"<"));
            newFilterInfo.getFilterItems().add(filterItemInfo2);
        }
        catch (ParseException e1) {
            logger.error((Object)"parser error", (Throwable)e1);
        }
        return newFilterInfo;
    }

    public static FilterInfo getThisMonthFilterInfo(Context ctx, FilterInfo newFilterInfo, String conditionName, CmpItemQueryInfo queryInfo) {
        String dateFormatStr = CtrlFormatUtilities.getDateFormatString();
        SimpleDateFormat df = new SimpleDateFormat(dateFormatStr);
        Calendar thismonth = Calendar.getInstance();
        thismonth.add(2, 0);
        Date d = thismonth.getTime();
        thismonth = Calendar.getInstance();
        thismonth.setTime(d);
        Date thisMonthStart = thismonth.getTime();
        String thisMonthStartStr = df.format(thisMonthStart);
        String compareValue1 = thisMonthStartStr.substring(0, thisMonthStartStr.indexOf("-", 6) + 1) + "01 00:00:00";
        try {
            Date dateBreakStart = df.parse(compareValue1);
            String dateType = CmpItemFilterUtil.getRefMetaData(queryInfo, conditionName).getName();
            dateBreakStart = QueryUtils.getDate((Date)dateBreakStart, (String)dateType);
            FilterItemInfo filterItemInfo1 = new FilterItemInfo(conditionName, (Object)dateBreakStart, CompareType.getEnum((String)">="));
            newFilterInfo.getFilterItems().add(filterItemInfo1);
        }
        catch (ParseException e) {
            logger.error((Object)"parser error", (Throwable)e);
        }
        Calendar nextmonth = Calendar.getInstance();
        nextmonth.add(2, 1);
        d = nextmonth.getTime();
        nextmonth = Calendar.getInstance();
        nextmonth.setTime(d);
        Date nextMonthStart = nextmonth.getTime();
        String nextMonthStartStr = df.format(nextMonthStart);
        String compareValue2 = nextMonthStartStr.substring(0, nextMonthStartStr.indexOf("-", 6) + 1) + "01 00:00:00";
        try {
            Date dateDayEnd = df.parse(compareValue2);
            String dateType = CmpItemFilterUtil.getRefMetaData(queryInfo, conditionName).getName();
            dateDayEnd = QueryUtils.getDate((Date)dateDayEnd, (String)dateType);
            FilterItemInfo filterItemInfo2 = new FilterItemInfo(conditionName, (Object)dateDayEnd, CompareType.getEnum((String)"<"));
            newFilterInfo.getFilterItems().add(filterItemInfo2);
        }
        catch (ParseException e1) {
            logger.error((Object)"parser error", (Throwable)e1);
        }
        return newFilterInfo;
    }

    public static FilterInfo getNextMonthFilterInfo(Context ctx, FilterInfo newFilterInfo, String conditionName, CmpItemQueryInfo queryInfo) {
        String dateFormatStr = CtrlFormatUtilities.getDateFormatString();
        SimpleDateFormat df = new SimpleDateFormat(dateFormatStr);
        Calendar nextMonth = Calendar.getInstance();
        nextMonth.add(2, 1);
        Date d = nextMonth.getTime();
        nextMonth = Calendar.getInstance();
        nextMonth.setTime(d);
        Date nextMonthStart = nextMonth.getTime();
        String nextMonthStartStr = df.format(nextMonthStart);
        String compareValue1 = nextMonthStartStr.substring(0, nextMonthStartStr.indexOf("-", 6) + 1) + "01 00:00:00";
        try {
            Date dateBreakStart = df.parse(compareValue1);
            String dateType = CmpItemFilterUtil.getRefMetaData(queryInfo, conditionName).getName();
            dateBreakStart = QueryUtils.getDate((Date)dateBreakStart, (String)dateType);
            FilterItemInfo filterItemInfo1 = new FilterItemInfo(conditionName, (Object)dateBreakStart, CompareType.getEnum((String)">="));
            newFilterInfo.getFilterItems().add(filterItemInfo1);
        }
        catch (ParseException e) {
            logger.error((Object)"parser error", (Throwable)e);
        }
        Calendar nextNextMonth = Calendar.getInstance();
        nextNextMonth.add(2, 2);
        d = nextNextMonth.getTime();
        nextNextMonth = Calendar.getInstance();
        nextNextMonth.setTime(d);
        Date nextNextMonthStart = nextNextMonth.getTime();
        String nextNextMonthStartStr = df.format(nextNextMonthStart);
        String compareValue2 = nextNextMonthStartStr.substring(0, nextMonthStartStr.indexOf("-", 6) + 1) + "01 00:00:00";
        try {
            Date dateDayEnd = df.parse(compareValue2);
            String dateType = CmpItemFilterUtil.getRefMetaData(queryInfo, conditionName).getName();
            dateDayEnd = QueryUtils.getDate((Date)dateDayEnd, (String)dateType);
            FilterItemInfo filterItemInfo2 = new FilterItemInfo(conditionName, (Object)dateDayEnd, CompareType.getEnum((String)"<"));
            newFilterInfo.getFilterItems().add(filterItemInfo2);
        }
        catch (ParseException e1) {
            logger.error((Object)"parser error", (Throwable)e1);
        }
        return newFilterInfo;
    }

    public static FilterInfo getBeforetoDayFilterInfo(Context ctx, FilterInfo newFilterInfo, String conditionName, CmpItemQueryInfo queryInfo) {
        String dateFormatStr = CtrlFormatUtilities.getDateFormatString();
        SimpleDateFormat df = new SimpleDateFormat(dateFormatStr);
        Calendar worldTour = Calendar.getInstance();
        worldTour.add(5, 0);
        Date d = worldTour.getTime();
        worldTour.setTime(d);
        String today = df.format(d);
        today = today + " 00:00:00";
        try {
            Date dateBreakStart = df.parse(today);
            String dateType = CmpItemFilterUtil.getRefMetaData(queryInfo, conditionName).getName();
            dateBreakStart = QueryUtils.getDate((Date)dateBreakStart, (String)dateType);
            FilterItemInfo filterItemInfo = new FilterItemInfo(conditionName, (Object)dateBreakStart, CompareType.getEnum((String)"<"));
            newFilterInfo.getFilterItems().add(filterItemInfo);
        }
        catch (ParseException e) {
            logger.error((Object)"parser error", (Throwable)e);
        }
        return newFilterInfo;
    }

    public static FilterInfo getAftertoDayFilterInfo(Context ctx, FilterInfo newFilterInfo, String conditionName, CmpItemQueryInfo queryInfo) {
        String dateFormatStr = CtrlFormatUtilities.getDateFormatString();
        SimpleDateFormat df = new SimpleDateFormat(dateFormatStr);
        Calendar worldTour = Calendar.getInstance();
        worldTour.add(5, 0);
        Date d = worldTour.getTime();
        worldTour.setTime(d);
        String today = df.format(d);
        today = today + " 00:00:00";
        try {
            Date dateBreakStart = df.parse(today);
            String dateType = CmpItemFilterUtil.getRefMetaData(queryInfo, conditionName).getName();
            dateBreakStart = QueryUtils.getDate((Date)dateBreakStart, (String)dateType);
            FilterItemInfo filterItemInfo = new FilterItemInfo(conditionName, (Object)dateBreakStart, CompareType.getEnum((String)">"));
            newFilterInfo.getFilterItems().add(filterItemInfo);
        }
        catch (ParseException e) {
            logger.error((Object)"parser error", (Throwable)e);
        }
        return newFilterInfo;
    }
}

