/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.compensation.CmpItemCatalogInfo;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpReportFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.client.AbstractEmpSumReportFilterUI;
import com.kingdee.eas.hr.compensation.client.HRF7CmpSchemePromptBox;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRCommonQueryUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class EmpSumReportFilterUI
extends AbstractEmpSumReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(EmpSumReportFilterUI.class);
    private CmpItemCollection colCmpItem = null;
    private CmpItemCollection colNecessaryCmpItem = new CmpItemCollection();
    private String cmpItemFilter = "";
    private boolean isLoaded = true;
    private final String RADIOBTN = "radiobtn";
    private AdminOrgUnitCollection colDept = null;
    private int level = 0;
    private boolean selectBankFlag = false;
    private boolean permissionInfoShowFlag = false;
    private HROrgUnitInfo hrOrgUnitInfo = null;

    public String getCmpItemFilter() {
        return this.cmpItemFilter;
    }

    public void setCmpItemFilter(String cmpItemFilter) {
        this.cmpItemFilter = cmpItemFilter;
    }

    public EmpSumReportFilterUI() throws Exception {
        this.initUI();
    }

    public EmpSumReportFilterUI(int displaySAL000) throws Exception {
        this.displaySAL000 = displaySAL000;
        this.initUI();
    }

    public EmpSumReportFilterUI(boolean permissionInfoShowFlag) throws Exception {
        this.initUI();
        this.permissionInfoShowFlag = permissionInfoShowFlag;
    }

    private HROrgUnitInfo getHROrgUnit() {
        if (this.hrOrgUnitInfo == null) {
            this.hrOrgUnitInfo = HRSchemeUtils.getClientHROrgUnitInfo();
        }
        return this.hrOrgUnitInfo;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void clear() {
        super.clear();
        this.rootHroId = null;
        this.hroList = new ArrayList();
        if (this.btnSingleOrg.isSelected()) {
            this.setAdminPrmtState(true);
        } else {
            this.setAdminPrmtState(false);
        }
        this.cmbItemCatalog.removeAllItems();
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
        this.prmtSingleAdminOrg.setData(null);
        this.cmbLevel.removeAllItems();
        this.chkHasSubAdminOrg.setSelected(false);
        this.cmbSumChild.removeAllItems();
        this.chkShowLongName.setSelected(false);
        this.chkSumChild.setSelected(false);
        this.chkPrintOrg.setSelected(false);
        this.chkAdminSub.setSelected(false);
        this.lstAllItem.removeAllElements();
        this.lstSelectItem.removeAllElements();
        this.lstSelectItemNotSort.removeAllElements();
        this.lstSelectItemNotSortData = new ArrayList();
        this.lstSelectItemData = new ArrayList();
        this.lstAllSelectItemData = null;
        this.enableTime.setSelected(false);
        this.fromTime.setText(null);
        this.toTime.setText(null);
        this.fromTime.setEditable(false);
        this.toTime.setEditable(false);
        this.btnSingleOrg.setSelected(true);
        this.radiobtn0.setSelected(true);
        this.chkCollectItemEndFlag.setSelected(false);
        try {
            this.setPeriodAndSchemeF7(this.rootHroId, this.hroList);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.cmbLevel.setEnabled(this.chkHasSubAdminOrg.isSelected());
        this.cmbSumChild.setEnabled(this.chkSumChild.isSelected());
        this.setOrgCommentEnabled();
    }

    @Override
    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        boolean controlInt = false;
        cp.addCustomerParam("selectListItem", HRCommonQueryUtils.getSelectedItemIDS(this.lstSelectItemData));
        cp.addCustomerParam("lstSelectItemNotSort", HRCommonQueryUtils.getSelectedItemIDS(this.lstSelectItemNotSortData));
        cp.addCustomerParam("chkCollectItemEndFlag", String.valueOf(this.chkCollectItemEndFlag.isSelected()));
        if (this.btnSingleOrg.isSelected()) {
            if (this.prmtSingleAdminOrg.getData() != null) {
                cp.addCustomerParam("prmtSingleAdminOrg", ((AdminOrgUnitInfo)this.prmtSingleAdminOrg.getData()).getId().toString());
            }
            cp.putBoolean("chkHasSubAdminOrg", this.chkHasSubAdminOrg.isSelected());
            if (this.cmbLevel.getSelectedItem() != null) {
                String selectItemLevel = this.cmbLevel.getSelectedItem().toString();
                cp.addCustomerParam("selectItemLevel", selectItemLevel);
            }
            cp.putBoolean("IsSumChild", this.chkSumChild.isSelected());
            Integer iSumChildLevel = 0;
            if (this.cmbSumChild.getSelectedItem() != null) {
                iSumChildLevel = (Integer)this.cmbSumChild.getSelectedItem();
            }
            cp.putInt("SumChildLevel", iSumChildLevel.intValue());
        } else {
            Object[] ogs;
            Object value = this.prmtAdminUnitOrg.getValue();
            if (value != null && value instanceof Object[] && (ogs = (Object[])value).length > 0 && ogs[0] != null) {
                int i;
                StringBuffer orgUnits = new StringBuffer();
                for (i = 0; i < ogs.length - 1; ++i) {
                    orgUnits.append(((AdminOrgUnitInfo)ogs[i]).getId().toString());
                    orgUnits.append("\u2014\u2014");
                }
                orgUnits.append(((AdminOrgUnitInfo)ogs[i]).getId().toString());
                cp.addCustomerParam("adminOrgUnitMul", orgUnits.toString());
            }
            cp.addCustomerParam("chkAdminSub", String.valueOf(this.chkAdminSub.isSelected()));
        }
        cp.putBoolean("IsShowLongName", this.chkShowLongName.isSelected());
        cp.putBoolean("isShowSealUp", this.chkShowSealUp.isSelected());
        cp.putBoolean("ISMultiDeptSelect", this.btnMulOrg.isSelected());
        cp.putBoolean("ISPrintByOrg", this.chkPrintOrg.isSelected());
        cp.putBoolean("enableTime", this.enableTime.isSelected());
        cp.addCustomerParam("fromTime", this.fromTime.getText());
        cp.addCustomerParam("toTime", this.toTime.getText());
        cp.addCustomerParam("CmpItemFilter", this.getCmpItemFilterUI().getCondition().toString());
        if (this.radiobtn0.isSelected()) {
            cp.addCustomerParam("radiobtn", "radiobtn0");
        } else if (this.radiobtn1.isSelected()) {
            cp.addCustomerParam("radiobtn", "radiobtn1");
        } else if (this.radiobtn2.isSelected()) {
            cp.addCustomerParam("radiobtn", "radiobtn2");
            cp.addCustomerParam("level", this.levelComboBox.getSelectedItem().toString());
        }
        return cp;
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        this.isLoaded = false;
        if (cp == null) {
            return;
        }
        try {
            if (cp.getCustomerParam("prmtCmpSch") != null) {
                cp.addCustomerParam("prmtCmpScheme", cp.getCustomerParam("prmtCmpSch"));
            }
            super.setCustomerParams(cp);
        }
        catch (Exception e) {
            this.isLoaded = true;
            return;
        }
        if (cp.getCustomerParam("radiobtn") == null || cp.getCustomerParam("radiobtn").equals("radiobtn0")) {
            this.radiobtn0.setSelected(true);
        } else if (cp.getCustomerParam("radiobtn").equals("radiobtn1")) {
            this.radiobtn1.setSelected(true);
        } else if (cp.getCustomerParam("radiobtn").equals("radiobtn2")) {
            this.radiobtn2.setSelected(true);
            String level = cp.getCustomerParam("level");
            this.levelComboBox.setSelectedIndex(Integer.parseInt(level) - 1);
        }
        try {
            AdminOrgUnitInfo infoDept = this.f7Info.getAdminInfo();
            if (infoDept != null) {
                int oldLevel;
                this.prmtSingleAdminOrg.setData((Object)infoDept);
                this.cmbLevel.removeAllItems();
                this.cmbSumChild.removeAllItems();
                int level = this.f7Info.getLevel();
                HRCommonQueryUtils.initComBox(this.cmbLevel, level);
                HRCommonQueryUtils.initComBox(this.cmbSumChild, level);
                if (level > 0) {
                    this.chkHasSubAdminOrg.setEnabled(true);
                    this.cmbLevel.setEnabled(true);
                    this.chkSumChild.setEnabled(true);
                    this.cmbSumChild.setEnabled(true);
                }
                if (cp.getCustomerParam("selectItemLevel") != null && this.cmbLevel.getItemCount() > 0) {
                    oldLevel = Integer.valueOf(cp.getCustomerParam("selectItemLevel"));
                    if (oldLevel > level && level >= 2) {
                        this.cmbLevel.setSelectedIndex(1);
                    } else if (oldLevel > level && level < 2) {
                        this.cmbLevel.setSelectedIndex(0);
                    } else {
                        this.cmbLevel.setSelectedIndex(oldLevel - 1);
                    }
                }
                if (cp.getCustomerParam("SumChildLevel") != null && this.cmbSumChild.getItemCount() > 0) {
                    oldLevel = Integer.valueOf(cp.getCustomerParam("SumChildLevel"));
                    if (oldLevel > level && level >= 2) {
                        this.cmbSumChild.setSelectedIndex(1);
                    } else if (oldLevel > level && level < 2) {
                        this.cmbSumChild.setSelectedIndex(0);
                    } else {
                        this.cmbSumChild.setSelectedIndex(oldLevel - 1);
                    }
                }
            }
            this.chkCollectItemEndFlag.setSelected(cp.getBoolean("chkCollectItemEndFlag"));
            this.chkAdminSub.setSelected(cp.getBoolean("chkAdminSub"));
            this.chkHasSubAdminOrg.setSelected(cp.getBoolean("chkHasSubAdminOrg"));
            this.chkSumChild.setSelected(cp.getBoolean("IsSumChild"));
            this.cmbLevel.setEnabled(this.chkHasSubAdminOrg.isSelected());
            this.cmbSumChild.setEnabled(this.chkSumChild.isSelected());
            AdminOrgUnitCollection col = this.f7Info.getAdminColl();
            if (col != null && col.size() > 0) {
                this.btnSingleOrg.setSelected(false);
                this.btnMulOrg.setSelected(true);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (cp.getCustomerParam("enableTime") != null) {
            this.enableTime.setSelected(cp.getBoolean("enableTime"));
            if (this.enableTime.isSelected()) {
                this.fromTime.setEditable(true);
                this.toTime.setEditable(true);
            }
        }
        this.fromTime.setText(cp.getCustomerParam("fromTime"));
        this.toTime.setText(cp.getCustomerParam("toTime"));
        this.btnMulOrg.setSelected(cp.getBoolean("ISMultiDeptSelect"));
        this.btnSingleOrg.setSelected(!cp.getBoolean("ISMultiDeptSelect"));
        this.chkShowLongName.setSelected(cp.getBoolean("IsShowLongName"));
        this.chkShowSealUp.setSelected(cp.getBoolean("isShowSealUp"));
        this.chkPrintOrg.setSelected(cp.getBoolean("ISPrintByOrg"));
        this.enableTime.setSelected(cp.getBoolean("enableTime"));
        this.fromTime.setText(cp.getCustomerParam("fromTime"));
        this.toTime.setText(cp.getCustomerParam("toTime"));
        this.setCmpItemFilter(cp.getCustomerParam("CmpItemFilter"));
        this.empReloadAllListByItemCatalog();
        this.isLoaded = true;
        try {
            if (this.btnMulOrg.isSelected()) {
                this.setCurrentHRO((Object[])this.prmtAdminUnitOrg.getData());
            } else {
                this.setCurrentHRO();
            }
            this.setOrgCommentEnabled();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnMoveTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnMovePre.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveNext.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.btnAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
    }

    @Override
    protected void initAllEditor() throws Exception {
        super.initAllEditor();
        CompUtils.initF7SelectorNoHR((CustomerQueryPanel)this, this.prmtSingleAdminOrg);
        this.prmtSingleAdminOrg.setEditable(false);
        this.prmtSingleAdminOrg.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                try {
                    Object[] objs = new Object[]{EmpSumReportFilterUI.this.prmtSingleAdminOrg.getData()};
                    EmpSumReportFilterUI.this.setCurrentHRO(objs);
                }
                catch (Exception e) {
                    EmpSumReportFilterUI.this.handUIException(e);
                }
            }
        });
        CompUtils.initF7ForMutilSelectOrg(this.prmtAdminUnitOrg, false);
        this.prmtAdminUnitOrg.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                try {
                    Object[] objs = new Object[]{EmpSumReportFilterUI.this.prmtAdminUnitOrg.getData()};
                    if (objs != null) {
                        objs = (Object[])objs[0];
                    }
                    EmpSumReportFilterUI.this.setCurrentHRO(objs);
                }
                catch (Exception e) {
                    EmpSumReportFilterUI.this.handUIException(e);
                }
            }
        });
    }

    @Override
    protected void chkShowSealUp_itemStateChanged(ItemEvent e) throws Exception {
        super.chkShowSealUp_itemStateChanged(e);
        CompUtils.initF7SelectorNoHR(this.prmtSingleAdminOrg, this.chkShowSealUp.isSelected());
    }

    @Override
    protected void setCurrentHRO() throws Exception {
        if (!this.isLoaded) {
            return;
        }
        String newRootHroId = "";
        if (this.btnSingleOrg.isSelected()) {
            if (this.prmtSingleAdminOrg.getData() == null) {
                return;
            }
            AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)this.prmtSingleAdminOrg.getData();
            Integer level = 0;
            if (this.chkHasSubAdminOrg.isSelected() && this.cmbLevel.getSelectedItem() != null) {
                Object obj = this.cmbLevel.getSelectedItem();
                level = (Integer)obj;
            }
            ArrayList newHroList = this.getSelectHROS(adminInfo, level);
            newRootHroId = this.getRootHROID(newHroList);
            this.setPeriodAndSchemeF7(newRootHroId, newHroList);
        }
    }

    @Override
    protected void setPeriodAndSchemeF7(String newRootHroId, ArrayList newHroList) throws Exception {
        EntityViewInfo eviCmpPeriod = new EntityViewInfo();
        FilterInfo filterInfoCmpPeriod = new FilterInfo();
        filterInfoCmpPeriod.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)newRootHroId));
        eviCmpPeriod.setFilter(filterInfoCmpPeriod);
        this.prmtCmpPeriod.setEntityViewInfo(eviCmpPeriod);
        if (this.rootHroId != null && !this.rootHroId.equals(newRootHroId)) {
            this.prmtCmpPeriod.setValue(null);
        }
        HRF7CmpSchemePromptBox f7PromptBox = new HRF7CmpSchemePromptBox((IUIObject)this);
        f7PromptBox.setIsSingleSelect(false);
        f7PromptBox.setIsShowDelete(this.chkShowDelete.isSelected());
        f7PromptBox.setHROFilter(newHroList);
        this.prmtCmpScheme.setDefaultF7UIName(HRF7CmpSchemePromptBox.class.getName());
        this.prmtCmpScheme.setSelector((KDPromptSelector)f7PromptBox);
        this.rootHroId = newRootHroId;
        this.hroList = newHroList;
        if (this.prmtCmpScheme.getData() == null) {
            return;
        }
        Object[] objs = (Object[])this.prmtCmpScheme.getData();
        boolean flag = true;
        CmpSchemeInfo csInfo = null;
        HROrgUnitInfo hroInfo = null;
        int size = objs.length;
        for (int i = 0; i < size; ++i) {
            if (!(objs[i] instanceof CmpSchemeInfo)) continue;
            csInfo = (CmpSchemeInfo)objs[i];
            flag = true;
            for (int t = 0; t < this.hroList.size(); ++t) {
                hroInfo = (HROrgUnitInfo)this.hroList.get(t);
                if (!csInfo.getHrOrgUnit().getId().toString().equals(hroInfo.getId().toString())) continue;
                flag = false;
            }
            if (flag) break;
        }
        if (flag) {
            this.prmtCmpScheme.setValue(null);
            this.lstSelectItem.removeAllElements();
            this.lstSelectItemNotSort.removeAllElements();
            this.lstAllItem.removeAllElements();
        }
    }

    private ArrayList getSelectHROS(AdminOrgUnitInfo adminInfo, Integer level) throws Exception {
        ArrayList<HROrgUnitInfo> hros = new ArrayList<HROrgUnitInfo>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT T_ORG_HRO.FID,T_ORG_HRO.FLongNumber ");
        sql.append("FROM T_ORG_UnitRelation ");
        sql.append("INNER JOIN T_ORG_HRO ");
        sql.append("ON T_ORG_UnitRelation.FToUnitID = T_ORG_HRO.FID ");
        sql.append("INNER JOIN T_ORG_Admin ");
        sql.append("ON T_ORG_UnitRelation.FFromUnitID = T_ORG_Admin.FID ");
        sql.append("WHERE T_ORG_UnitRelation.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5' ");
        sql.append("AND (T_ORG_Admin.FID='");
        sql.append(adminInfo.getId());
        sql.append("' OR T_ORG_Admin.FLongNumber LIKE '");
        sql.append(adminInfo.getLongNumber());
        sql.append("!%') AND T_ORG_Admin.FLevel <= ");
        sql.append(adminInfo.getLevel());
        sql.append("+");
        sql.append(level);
        sql.append(" and T_ORG_Admin.FID in ( select forgid from T_PM_OrgRange where FUserID = '");
        sql.append(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        sql.append("' and ftype = 20 ) ");
        sql.append(" ORDER BY T_ORG_HRO.FLongNumber");
        ISQLExecutor iSQL = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rows = iSQL.executeSQL();
        HROrgUnitInfo hroInfo = null;
        while (rows.next()) {
            hroInfo = new HROrgUnitInfo();
            hroInfo.setId(BOSUuid.read((String)rows.getString(1)));
            hroInfo.setLongNumber(rows.getString(2));
            hros.add(hroInfo);
        }
        return hros;
    }

    protected void setCurrentHRO(Object[] objs) throws Exception {
        if (!this.isLoaded) {
            return;
        }
        if (objs == null) {
            return;
        }
        if (objs[0] == null) {
            return;
        }
        String newRootHroId = "";
        ArrayList<Object> adminList = new ArrayList<Object>();
        int size = objs.length;
        for (int i = 0; i < size; ++i) {
            if (!(objs[i] instanceof AdminOrgUnitInfo)) continue;
            adminList.add(objs[i]);
        }
        ArrayList newHroList = this.getSelectHROS(adminList);
        newRootHroId = this.getRootHROID(newHroList);
        this.setPeriodAndSchemeF7(newRootHroId, newHroList);
    }

    private void initComBox(int level, KDComboBox cmbControl) {
        for (int i = 1; i <= level; ++i) {
            cmbControl.addItem((Object)i);
        }
        if (level >= 1) {
            cmbControl.setSelectedIndex(0);
        }
    }

    private int getAdminOrgLevelCount(AdminOrgUnitInfo info) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)info.getLongNumber()));
        fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(info.getLongNumber() + "!%"), CompareType.LIKE));
        fi.setMaskString("(#0 or #1)");
        viewInfo.setFilter(fi);
        SorterItemInfo sortInfo = new SorterItemInfo("level");
        sortInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sortInfo);
        IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getRemoteInstance();
        AdminOrgUnitCollection coll = iAdmin.getAdminOrgUnitCollection(viewInfo);
        if (coll != null) {
            int size = coll.size();
            if (size <= 1) {
                return 0;
            }
            if (size > 1) {
                return coll.get(size - 1).getLevel() - coll.get(0).getLevel();
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AdminOrgUnitCollection getDeptCol(boolean isShowSealUp) {
        try {
            if (this.btnSingleOrg.isSelected()) {
                AdminOrgUnitInfo infoDept = this.getAdminOrgUnitInfo();
                if (infoDept == null) return new AdminOrgUnitCollection();
                if (this.chkHasSubAdminOrg.isSelected()) {
                    this.level = infoDept.getLevel();
                    if (this.cmbLevel.getSelectedIndex() != -1) {
                        this.level = (Integer)this.cmbLevel.getSelectedItem();
                    }
                    this.colDept = HRUtils.getSubDeptCollectionNew(infoDept, this.level, isShowSealUp);
                    return this.colDept;
                } else {
                    this.colDept = new AdminOrgUnitCollection();
                    this.colDept.add(infoDept);
                }
                return this.colDept;
            } else {
                this.colDept = new AdminOrgUnitCollection();
                Object[] value = (Object[])this.prmtAdminUnitOrg.getData();
                HashSet<String> set = new HashSet<String>();
                if (value != null && value.length > 0) {
                    for (int i = 0; i < value.length; ++i) {
                        set.add(((AdminOrgUnitInfo)value[i]).getId().toString());
                    }
                }
                if (set.size() <= 0) return this.colDept;
                IAdminOrgUnit adminOrgUnit = AdminOrgUnitFactory.getRemoteInstance();
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
                String adminSql = HRSchemeUtils.getAdminByUserRange(null);
                FilterItemInfo item = new FilterItemInfo("id", (Object)adminSql, CompareType.INNER);
                fi.getFilterItems().add(item);
                evi.setFilter(fi);
                AdminOrgUnitCollection col = adminOrgUnit.getAdminOrgUnitCollection(evi);
                if (isShowSealUp) {
                    this.colDept.addCollection(col);
                    return this.colDept;
                } else {
                    AdminOrgUnitInfo infoTmp = null;
                    int size = col.size();
                    for (int i = 0; i < size; ++i) {
                        infoTmp = col.get(i);
                        if (infoTmp.isIsSealUp()) continue;
                        this.colDept.add(infoTmp);
                    }
                }
            }
            return this.colDept;
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return this.colDept;
    }

    @Override
    public HashMap getCustomFilterMap() {
        HashMap map = super.getCustomFilterMap();
        AdminOrgUnitInfo unitInfo = this.getAdminOrgUnitInfo();
        map.put("AdminOrgUnitInfo", unitInfo);
        map.put("CmpSchemeInfos", this.getCmpSchemeColl());
        map.put("CmpPeriodInfo", (CmpPeriodInfo)this.prmtCmpPeriod.getData());
        map.put("IsShowLongName", true);
        map.put("isShowSealUp", this.chkShowSealUp.isSelected());
        map.put("IsIncludeChild", this.chkHasSubAdminOrg.isSelected());
        map.put("IncludeChildLevel", this.cmbLevel.getSelectedIndex() + 1);
        map.put("IsSumChild", this.chkSumChild.isSelected());
        map.put("SumChildLevel", this.cmbSumChild.getSelectedIndex() + 1);
        map.put("AdminOrgUnitColl", this.getDeptCol(this.chkShowSealUp.isSelected()));
        map.put("IsAdminSubSum", this.chkAdminSub.isSelected());
        map.put("AllSelectItem", this.getAllSelectItem());
        map.put("AllPublicItem", this.lstSelectItemData);
        map.put("AllPrivateItem", this.lstSelectItemNotSortData);
        map.put("IsSingleDept", this.btnSingleOrg.isSelected());
        map.put("enableTime", this.enableTime.isSelected());
        map.put("fromTime", this.fromTime.getIntegerValue());
        map.put("toTime", this.toTime.getIntegerValue());
        map.put("cmpItemCustFilter", this.getCmpItemFilter());
        map.put("ISPrintByOrg", this.chkPrintOrg.isSelected());
        map.put("chkCollectItemEndFlag", this.chkCollectItemEndFlag.isSelected());
        if (this.getCmpItemFilterUI() != null) {
            map.put("cmpItemCustFilter", this.getCmpItemFilterUI().getCondition().toString());
        }
        return map;
    }

    private void empReloadAllListByItemCatalog() {
        try {
            this.lstAllSelectItemData = this.getAllSelectItem();
            this.onLoadAllList();
            this.lstAllItem.requestFocus();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void initUI() throws Exception {
        this.btnSingleOrg.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (EmpSumReportFilterUI.this.btnSingleOrg.isSelected()) {
                    EmpSumReportFilterUI.this.setAdminPrmtState(true);
                } else {
                    EmpSumReportFilterUI.this.setAdminPrmtState(false);
                    EmpSumReportFilterUI.this.adminInfo = null;
                }
            }
        });
        this.btnSingleOrg.setSelected(true);
        this.prmtSingleAdminOrg.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                try {
                    EmpSumReportFilterUI.this.cmbLevel.removeAllItems();
                    EmpSumReportFilterUI.this.cmbSumChild.removeAllItems();
                    if (EmpSumReportFilterUI.this.prmtSingleAdminOrg.getData() == null) {
                        return;
                    }
                    int level = EmpSumReportFilterUI.this.getAdminOrgLevelCount((AdminOrgUnitInfo)EmpSumReportFilterUI.this.prmtSingleAdminOrg.getData());
                    if (level > 0) {
                        EmpSumReportFilterUI.this.chkHasSubAdminOrg.setSelected(false);
                        EmpSumReportFilterUI.this.chkHasSubAdminOrg.setEnabled(true);
                        EmpSumReportFilterUI.this.cmbLevel.setEnabled(true);
                        EmpSumReportFilterUI.this.chkSumChild.setSelected(false);
                        EmpSumReportFilterUI.this.chkSumChild.setEnabled(true);
                        EmpSumReportFilterUI.this.cmbSumChild.setEnabled(true);
                        EmpSumReportFilterUI.this.chkPrintOrg.setSelected(false);
                        EmpSumReportFilterUI.this.chkPrintOrg.setEnabled(true);
                    } else {
                        EmpSumReportFilterUI.this.chkHasSubAdminOrg.setSelected(false);
                        EmpSumReportFilterUI.this.chkHasSubAdminOrg.setEnabled(false);
                        EmpSumReportFilterUI.this.cmbLevel.setEnabled(false);
                        EmpSumReportFilterUI.this.chkSumChild.setSelected(false);
                        EmpSumReportFilterUI.this.chkSumChild.setEnabled(false);
                        EmpSumReportFilterUI.this.cmbSumChild.setEnabled(false);
                        EmpSumReportFilterUI.this.chkPrintOrg.setSelected(false);
                        EmpSumReportFilterUI.this.chkPrintOrg.setEnabled(false);
                    }
                    EmpSumReportFilterUI.this.initComBox(level, EmpSumReportFilterUI.this.cmbLevel);
                    EmpSumReportFilterUI.this.initComBox(level, EmpSumReportFilterUI.this.cmbSumChild);
                }
                catch (Exception e) {
                    EmpSumReportFilterUI.this.handUIException(e);
                }
            }
        });
        this.lstSelectItemNotSort.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                EmpSumReportFilterUI.this.lstSelectItem.setSelectedIndex(-1);
            }
        });
        this.lstSelectItem.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                EmpSumReportFilterUI.this.lstSelectItemNotSort.setSelectedIndex(-1);
            }
        });
        this.cmbLevel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    EmpSumReportFilterUI.this.cmbLevel_itemStateChanged(e);
                }
                catch (Exception exc) {
                    EmpSumReportFilterUI.this.handUIException(exc);
                }
            }
        });
    }

    private void setAdminPrmtState(boolean isSingleSelect) {
        this.prmtAdminUnitOrg.setEnabled(!isSingleSelect);
        this.chkAdminSub.setEnabled(!isSingleSelect);
        this.prmtSingleAdminOrg.setEnabled(isSingleSelect);
        this.chkHasSubAdminOrg.setEnabled(isSingleSelect);
        this.cmbLevel.setEnabled(isSingleSelect);
        this.chkSumChild.setEnabled(isSingleSelect);
        this.cmbSumChild.setEnabled(isSingleSelect);
        if (isSingleSelect) {
            this.prmtAdminUnitOrg.setData(null);
            this.chkAdminSub.setSelected(false);
        } else {
            this.prmtSingleAdminOrg.setData(null);
            this.chkHasSubAdminOrg.setSelected(false);
            this.cmbLevel.setSelectedItem(null);
            this.chkSumChild.setSelected(false);
            this.cmbSumChild.setSelectedItem(null);
            this.chkPrintOrg.setSelected(false);
            this.chkPrintOrg.setEnabled(true);
        }
    }

    private void onLoadAllList() throws BOSException {
        CmpItemCatalogInfo infoCmpItemCatalog = (CmpItemCatalogInfo)this.cmbItemCatalog.getSelectedItem();
        if (infoCmpItemCatalog == null || this.colCmpItem == null) {
            return;
        }
        this.lstAllSelectItemData = this.getAllSelectItem();
        this.lstAllItem.removeAllElements();
        Iterator itrCmpItem = this.colCmpItem.iterator();
        CmpItemInfo infoCmpItem = null;
        CmpItemCatalogInfo infoTemp = null;
        while (itrCmpItem.hasNext()) {
            infoCmpItem = (CmpItemInfo)itrCmpItem.next();
            infoTemp = infoCmpItem.getCmpItemCatalog();
            if (infoTemp == null || !infoTemp.getNumber().equals(infoCmpItemCatalog.getNumber())) continue;
            boolean isSame = false;
            CmpItemInfo infoTempCmpItem = null;
            int count = this.lstAllSelectItemData.size();
            for (int i = 0; i < count; ++i) {
                infoTempCmpItem = (CmpItemInfo)this.lstAllSelectItemData.get(i);
                if (infoTempCmpItem == null || infoTempCmpItem.getId() == null) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"237_CmpReportFilterBaseUI"));
                    return;
                }
                if (!infoTempCmpItem.getNumber().equals(infoCmpItem.getNumber())) continue;
                isSame = true;
            }
            if (isSame) continue;
            this.lstAllItem.addElement((Object)infoCmpItem);
        }
        if (this.lstAllItem.getElementCount() > 0) {
            this.lstAllItem.setSelectedIndex(0);
        }
    }

    @Override
    public void onLoad() throws Exception {
        if (this.btnSingleOrg.isSelected()) {
            this.setAdminPrmtState(true);
        } else {
            this.setAdminPrmtState(false);
        }
        super.onLoad();
        this.initAllEditor();
        this.lstAllItem.setSelectionMode(0);
        this.lstSelectItem.setSelectionMode(0);
        this.lstSelectItemNotSort.setSelectionMode(0);
    }

    @Override
    protected boolean isNecessaryCmpItem(CmpItemInfo info) {
        return HRSchemeUtils.isNecessaryEmpSumReoportItem(info);
    }

    public boolean getSelectBankFlag() {
        return this.selectBankFlag;
    }

    @Override
    public boolean verify() {
        int i;
        if (this.prmtCmpPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_CMPPER")));
            this.prmtCmpPeriod.requestFocusInWindow();
            return false;
        }
        if (this.btnSingleOrg.isSelected() && this.prmtSingleAdminOrg.getData() == null || this.btnMulOrg.isSelected() && this.prmtAdminUnitOrg.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_ADMIN")));
            this.prmtSingleAdminOrg.requestFocusInWindow();
            return false;
        }
        if (this.enableTime.isSelected()) {
            int toTime;
            int fromTime;
            if (StringUtils.isEmpty((String)this.fromTime.getText()) && StringUtils.isEmpty((String)this.toTime.getText())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"368_EmpSumReportFilterUI"));
                this.fromTime.requestFocusInWindow();
                return false;
            }
            if (!StringUtils.isEmpty((String)this.fromTime.getText()) && (fromTime = this.fromTime.getNumberValue().intValue()) < 1) {
                MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "FROMTIME_NEED_GREATER_THAN_ZERO")));
                this.fromTime.requestFocusInWindow();
                return false;
            }
            if (!StringUtils.isEmpty((String)this.toTime.getText()) && (toTime = this.toTime.getNumberValue().intValue()) < 1) {
                MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "TOTIME_NEED_GREATER_THAN_ZERO")));
                this.toTime.requestFocusInWindow();
                return false;
            }
            if (!StringUtils.isEmpty((String)this.toTime.getText()) && !StringUtils.isEmpty((String)this.fromTime.getText())) {
                toTime = this.toTime.getNumberValue().intValue();
                int fromTime2 = this.fromTime.getNumberValue().intValue();
                if (fromTime2 > toTime) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"369_EmpSumReportFilterUI"));
                    this.fromTime.requestFocusInWindow();
                    return false;
                }
            }
        }
        if (this.chkSumChild.isSelected() && !this.chkHasSubAdminOrg.isSelected()) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_GREATERTHANSUBLEVEL")));
            this.chkSumChild.requestFocusInWindow();
            return false;
        }
        int iLevel = 0;
        if (this.cmbLevel.getSelectedIndex() != -1) {
            iLevel = (Integer)this.cmbLevel.getSelectedItem();
        }
        int iSumChildLevel = 0;
        if (this.cmbLevel.getSelectedIndex() != -1) {
            iSumChildLevel = (Integer)this.cmbSumChild.getSelectedItem();
        }
        if (this.chkSumChild.isSelected() && iSumChildLevel > iLevel) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_GREATERTHANSUBLEVEL")));
            this.cmbSumChild.requestFocusInWindow();
            return false;
        }
        Object scheme = this.prmtCmpScheme.getData();
        if (scheme == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"263_CmpSummaryReportFilterUI"));
            this.prmtCmpScheme.requestFocusInWindow();
            return false;
        }
        this.lstSelectItemData = new ArrayList();
        int size = this.lstSelectItem.getElementCount();
        for (i = 0; i < size; ++i) {
            this.lstSelectItemData.add(this.lstSelectItem.getElement(i));
        }
        this.lstSelectItemNotSortData = new ArrayList();
        size = this.lstSelectItemNotSort.getElementCount();
        for (i = 0; i < size; ++i) {
            this.lstSelectItemNotSortData.add(this.lstSelectItemNotSort.getElement(i));
        }
        return true;
    }

    public CmpPeriodInfo getCmpPeriodInfo() {
        CmpPeriodInfo cmpPeriodInfo = new CmpPeriodInfo();
        if (this.prmtCmpPeriod.getData() != null) {
            cmpPeriodInfo = (CmpPeriodInfo)this.prmtCmpPeriod.getData();
        }
        return cmpPeriodInfo;
    }

    public HashMap getAllSchemeItems() {
        HashMap allMap = new HashMap();
        CmpSchemeInfo[] info = this.getCmpSchemeInfoArrayByObject((Object[])this.prmtCmpScheme.getData());
        if (info == null || info.length <= 0) {
            return allMap;
        }
        ArrayList<String> lstSchemeIds = new ArrayList<String>();
        int size = info.length;
        for (int i = 0; i < size; ++i) {
            lstSchemeIds.add(info[i].getId().toString());
        }
        ArrayList<String> privateItems = null;
        if (this.lstSelectItemNotSortData != null && this.lstSelectItemNotSortData.size() > 0) {
            privateItems = new ArrayList<String>();
            int size2 = this.lstSelectItemNotSortData.size();
            for (int i = 0; i < size2; ++i) {
                privateItems.add(((CmpItemInfo)this.lstSelectItemNotSortData.get(i)).getNumber());
            }
            try {
                boolean notIncDelItem = this.chkIncDelItem.isSelected();
                allMap = CmpReportFacadeFactory.getRemoteInstance().getPrivateItemsByScheme(lstSchemeIds, privateItems, notIncDelItem);
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (this.lstSelectItemData != null && this.lstSelectItemData.size() > 0) {
            ArrayList<CmpItemInfo> personItemList = new ArrayList<CmpItemInfo>();
            ArrayList<CmpItemInfo> combinItemList = new ArrayList<CmpItemInfo>();
            CmpItemInfo cmpItemInfo = null;
            for (int i = 0; i < this.lstSelectItemData.size(); ++i) {
                cmpItemInfo = (CmpItemInfo)this.lstSelectItemData.get(i);
                if (cmpItemInfo.getNumber().startsWith("FPER")) {
                    personItemList.add(cmpItemInfo);
                    continue;
                }
                combinItemList.add(cmpItemInfo);
            }
            allMap.put("publicItem", combinItemList);
            allMap.put("PersonItem", personItemList);
        }
        return allMap;
    }

    public List getCmpSchemeIDs() {
        CmpSchemeInfo[] schemes = this.getCmpSchemeColl();
        ArrayList<String> schemeIDs = new ArrayList<String>();
        if (schemes == null) {
            return schemeIDs;
        }
        for (int i = 0; i < schemes.length; ++i) {
            schemeIDs.add(schemes[i].getId().toString());
        }
        return schemeIDs;
    }

    @Override
    protected void enableTime_stateChanged(ChangeEvent e) throws Exception {
        boolean isSelected = this.enableTime.isSelected();
        if (isSelected) {
            this.fromTime.setNumberValue(null);
            this.toTime.setNumberValue(null);
            this.fromTime.setEditable(true);
            this.toTime.setEditable(true);
        } else {
            this.fromTime.setNumberValue(null);
            this.toTime.setNumberValue(null);
            this.fromTime.setEditable(false);
            this.toTime.setEditable(false);
        }
    }

    @Override
    protected void chkHasSubAdminOrg_stateChanged(ChangeEvent e) throws Exception {
        this.cmbLevel.setEnabled(this.chkHasSubAdminOrg.isSelected());
        this.setCurrentHRO();
    }

    protected void cmbLevel_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            this.setCurrentHRO();
        }
    }

    @Override
    protected void chkSumChild_stateChanged(ChangeEvent e) throws Exception {
        this.cmbSumChild.setEnabled(this.chkSumChild.isSelected());
    }

    @Override
    protected void btnSingleOrg_actionPerformed(ActionEvent e) throws Exception {
        this.setOrgCommentEnabled();
        super.btnSingleOrg_actionPerformed(e);
    }

    @Override
    protected void btnMulOrg_actionPerformed(ActionEvent e) throws Exception {
        this.setOrgCommentEnabled();
        this.adminInfo = null;
        super.btnMulOrg_actionPerformed(e);
    }

    private void setOrgCommentEnabled() {
        boolean isRdOrgMultSelected = this.btnMulOrg.isSelected();
        if (this.radiobtn1.isSelected() && isRdOrgMultSelected) {
            this.radiobtn1.setSelected(false);
            this.radiobtn0.setSelected(true);
        }
        this.radiobtn1.setEnabled(!isRdOrgMultSelected);
    }

    public List getSelectedCmpItem() throws Exception {
        return this.lstSelectItemData;
    }

    public List getSelectedPriItem() throws Exception {
        return this.lstSelectItemNotSortData;
    }

    @Override
    protected Map getF7ParamMap(CustomerParams cp) {
        Map paramMap = super.getF7ParamMap(cp);
        String value = cp.getCustomerParam("prmtSingleAdminOrg");
        if (!StringUtils.isEmpty((String)value)) {
            paramMap.put("cmpreport_admin_single", value);
        }
        return paramMap;
    }

    protected boolean isNeedParentGetF7Info() {
        return false;
    }

    @Override
    protected AdminOrgUnitInfo getAdminOrgUnitInfo() {
        this.adminInfo = (AdminOrgUnitInfo)this.prmtSingleAdminOrg.getData();
        try {
            if (this.btnSingleOrg.isSelected() && this.adminInfo != null) {
                this.adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.adminInfo.getId()));
            }
        }
        catch (EASBizException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        catch (BOSException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        return this.adminInfo;
    }
}

