/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.client.EmployeeTypePromptBox;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpReportFacadeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ICmpItem;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.ICmpSchemeItem;
import com.kingdee.eas.hr.compensation.client.AbstractEmployeeToTalFilter;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class EmployeeToTalFilter
extends AbstractEmployeeToTalFilter {
    private static final Logger logger = CoreUIObject.getLogger(EmployeeToTalFilter.class);
    private String cmpSchemeF7URL = "com.kingdee.eas.hr.compensation.app.F7CmpSchemeQuery";
    private String colCmpSchemeF7URL = "com.kingdee.eas.hr.compensation.app.F7ColCmpSchemeQuery";
    private String cmpPeriodF7URL = "com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery";
    private String empSumResource = "com.kingdee.eas.hr.compensation.client.EmpSumReportResource.";
    private ICmpScheme iCmpSchemeIts = null;
    private ICmpSchemeItem iCmpSchemeItemIts = null;
    private ICmpItem iCmpItemIts = null;
    protected boolean isShowDelete = false;
    private boolean cmpSchcolInitStateFlag = false;
    private boolean cmpSchInitStateFlag = true;
    private HROrgUnitInfo hrOrgUnitInfo = null;
    private static final String SEPATATE = "~";

    private HROrgUnitInfo getHROrgUnit() {
        if (this.hrOrgUnitInfo == null) {
            this.hrOrgUnitInfo = HRSchemeUtils.getClientHROrgUnitInfo();
        }
        return this.hrOrgUnitInfo;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void clear() {
        super.clear();
        if (this.prmtBeginCmpPeriod.getData() != null) {
            this.prmtBeginCmpPeriod.setData(null);
        }
        if (this.prmtEndCmpPeriod.getData() != null) {
            this.prmtEndCmpPeriod.setData(null);
        }
        if (this.prmtCmpScheme.getData() != null) {
            this.prmtCmpScheme.setData(null);
        }
        this.prmtDepartment.setData(null);
        this.prmtEmployeeType.setData(null);
        this.txtPersonName.setText(null);
        this.txtPersonNumber.setText(null);
        this.cbContainChildren.setSelected(true);
        this.chkShowDelete.setSelected(false);
        this.chkIsShowDetail.setSelected(false);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.prmtBeginCmpPeriod.getData() != null) {
            cp.addCustomerParam("prmtBeginCmpPeriod", ((CmpPeriodInfo)this.prmtBeginCmpPeriod.getData()).getId().toString());
        }
        if (this.prmtEndCmpPeriod.getData() != null) {
            cp.addCustomerParam("prmtEndCmpPeriod", ((CmpPeriodInfo)this.prmtEndCmpPeriod.getData()).getId().toString());
        }
        if (this.prmtCmpScheme.getData() != null) {
            CmpSchemeInfo[] info = this.getCmpSchemeInfoArrayByObject((Object[])this.prmtCmpScheme.getData());
            CmpSchemeInfo infoTem = null;
            StringBuffer cmpSchemeStr = new StringBuffer();
            int size = info.length;
            for (int i = 0; i < size; ++i) {
                infoTem = info[i];
                if (i == 0) {
                    cmpSchemeStr.append(infoTem.getId().toString());
                    continue;
                }
                cmpSchemeStr.append(SEPATATE + infoTem.getId().toString());
            }
            cp.addCustomerParam("prmtCmpScheme", cmpSchemeStr.toString());
        }
        Object obj = null;
        obj = this.prmtDepartment.getData();
        if (obj != null && obj instanceof AdminOrgUnitInfo) {
            cp.addCustomerParam("prmtDepartment", ((AdminOrgUnitInfo)obj).getId().toString());
        }
        if ((obj = this.prmtEmployeeType.getData()) != null && obj instanceof Object[]) {
            Object[] employeeTypes = (Object[])obj;
            EmployeeTypeInfo info = null;
            StringBuffer types = new StringBuffer();
            int size = employeeTypes.length;
            for (int i = 0; i < size; ++i) {
                info = (EmployeeTypeInfo)employeeTypes[i];
                if (i != 0) {
                    types.append(SEPATATE);
                }
                types.append(info.getId().toString());
            }
            if (types.length() > 0) {
                cp.addCustomerParam("prmtEmployeeType", types.toString());
            }
        }
        if (!StringUtils.isEmpty((String)((String)(obj = this.txtPersonName.getText())))) {
            cp.addCustomerParam("txtPersonName", obj.toString());
        }
        if (!StringUtils.isEmpty((String)((String)(obj = this.txtPersonNumber.getText())))) {
            cp.addCustomerParam("txtPersonNumber", obj.toString());
        }
        cp.putBoolean("cbContainChildren", this.cbContainChildren.isSelected());
        cp.putBoolean("chkIsShowDetail", this.chkIsShowDetail.isSelected());
        cp.putBoolean("chkShowDelete", this.chkShowDelete.isSelected());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        String cmpSchemeIdStr;
        if (cp == null) {
            return;
        }
        this.clear();
        ObjectUuidPK pkTemp = new ObjectUuidPK();
        if (cp.getCustomerParam("prmtBeginCmpPeriod") != null) {
            pkTemp = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("prmtBeginCmpPeriod")));
            try {
                this.prmtBeginCmpPeriod.setData((Object)((CmpPeriodInfo)CmpPeriodFactory.getRemoteInstance().getValue((IObjectPK)pkTemp)));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (cp.getCustomerParam("prmtEndCmpPeriod") != null) {
            pkTemp = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("prmtEndCmpPeriod")));
            try {
                this.prmtEndCmpPeriod.setData((Object)((CmpPeriodInfo)CmpPeriodFactory.getRemoteInstance().getValue((IObjectPK)pkTemp)));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (cp.getCustomerParam("prmtCmpScheme") != null) {
            cmpSchemeIdStr = this.formatCmpSchemeId(cp.getCustomerParam("prmtCmpScheme"));
            this.loadCmpScheme(cmpSchemeIdStr);
        } else if (cp.getCustomerParam("CmpScheme") != null) {
            cmpSchemeIdStr = this.formatCmpSchemeId(cp.getCustomerParam("CmpScheme"));
            this.loadCmpScheme(cmpSchemeIdStr);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        if (!StringUtils.isEmpty((String)cp.getCustomerParam("prmtEmployeeType"))) {
            String[] types = StringUtils.split((String)cp.getCustomerParam("prmtEmployeeType"), (String)SEPATATE);
            if (types.length > 0) {
                EmployeeTypeInfo[] data = new EmployeeTypeInfo[types.length];
                int size = types.length;
                for (int i = 0; i < size; ++i) {
                    pkTemp = new ObjectUuidPK(BOSUuid.read((String)types[i]));
                    try {
                        data[i] = EmployeeTypeFactory.getRemoteInstance().getEmployeeTypeInfo((IObjectPK)pkTemp, selector);
                        continue;
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                }
                this.prmtEmployeeType.setData((Object)data);
            }
        }
        selector.add("longNumber");
        if (!StringUtils.isEmpty((String)cp.getCustomerParam("prmtDepartment"))) {
            pkTemp = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("prmtDepartment")));
            try {
                this.prmtDepartment.setData((Object)AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)pkTemp, selector));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (!StringUtils.isEmpty((String)cp.getCustomerParam("txtPersonNumber"))) {
            this.txtPersonNumber.setText(cp.getCustomerParam("txtPersonNumber"));
        }
        if (!StringUtils.isEmpty((String)cp.getCustomerParam("txtPersonName"))) {
            this.txtPersonName.setText(cp.getCustomerParam("txtPersonName"));
        }
        this.cbContainChildren.setSelected(cp.getBoolean("cbContainChildren"));
        this.chkIsShowDetail.setSelected(cp.getBoolean("chkIsShowDetail"));
        this.chkShowDelete.setSelected(cp.getBoolean("chkShowDelete"));
    }

    public List getInfoCmpSchemeList() {
        CmpSchemeInfo[] info = this.getCmpSchemeInfoArrayByObject((Object[])this.prmtCmpScheme.getData());
        ArrayList<CmpSchemeInfo> alCmpScheme = new ArrayList<CmpSchemeInfo>();
        int size = info.length;
        for (int i = 0; i < size; ++i) {
            alCmpScheme.add(info[i]);
        }
        return alCmpScheme;
    }

    public List getAllSchemePerItems() {
        CmpSchemeInfo[] info = this.getCmpSchemeInfoArrayByObject((Object[])this.prmtCmpScheme.getData());
        if (info.length <= 0) {
            return new ArrayList();
        }
        ArrayList<String> lstSchemeIds = new ArrayList<String>();
        int size = info.length;
        for (int i = 0; i < size; ++i) {
            lstSchemeIds.add(info[i].getId().toString());
        }
        List lst = new ArrayList();
        try {
            lst = CmpReportFacadeFactory.getRemoteInstance().getAllPerItemsBySchemes(lstSchemeIds);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
            ExceptionHandler.handle((Throwable)e);
        }
        return lst;
    }

    public HashMap getAllSchemeItems() {
        HashMap allMap = new HashMap();
        CmpSchemeInfo[] info = this.getCmpSchemeInfoArrayByObject((Object[])this.prmtCmpScheme.getData());
        if (info.length <= 0) {
            return allMap;
        }
        ArrayList<String> lstSchemeIds = new ArrayList<String>();
        int size = info.length;
        for (int i = 0; i < size; ++i) {
            lstSchemeIds.add(info[i].getId().toString());
        }
        try {
            boolean displayDetail = this.chkIsShowDetail.isSelected();
            allMap = displayDetail ? CmpReportFacadeFactory.getRemoteInstance().getAllItemsByScheme(lstSchemeIds, false, true) : CmpReportFacadeFactory.getRemoteInstance().getAllItemsByScheme(lstSchemeIds, true, true);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return allMap;
    }

    private String getCmpSchemeIdFilter(String filedName, CmpSchemeInfo[] infoArr) {
        if (filedName == null || infoArr.length < 1) {
            return "";
        }
        CmpSchemeInfo cmpScheme = null;
        StringBuffer filter = new StringBuffer();
        filter.append(filedName);
        filter.append(" in ( ");
        int size = infoArr.length;
        for (int i = 0; i < size; ++i) {
            cmpScheme = infoArr[i];
            if (i == 0) {
                filter.append("'" + cmpScheme.getId().toString() + "'");
                continue;
            }
            filter.append(",'" + cmpScheme.getId().toString() + "'");
        }
        filter.append(" )");
        return filter.toString();
    }

    private void loadCmpScheme(String cmpSchemeIdStr) {
        try {
            CmpSchemeCollection cmpColl = CmpSchemeFactory.getRemoteInstance().getCmpSchemeCollection("select id,name,number,cmpPeriod.id,cmpPeriod.begindate,cmpPeriod.enddate  where id in (" + cmpSchemeIdStr + ")");
            CmpSchemeInfo[] cmpSchemeArr = new CmpSchemeInfo[cmpColl.size()];
            int size = cmpColl.size();
            for (int i = 0; i < size; ++i) {
                cmpSchemeArr[i] = cmpColl.get(i);
            }
            this.prmtCmpScheme.setData((Object)cmpSchemeArr);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private String formatCmpSchemeId(String cmpSchemeStr) {
        StringBuffer str = new StringBuffer();
        String[] idArr = cmpSchemeStr.split(SEPATATE);
        int size = idArr.length;
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                str.append("'" + idArr[i] + "'");
                continue;
            }
            str.append(",'" + idArr[i] + "'");
        }
        return str.toString();
    }

    private CmpSchemeInfo[] getCmpSchemeInfoArrayByObject(Object[] objA) {
        if (objA == null) {
            return new CmpSchemeInfo[0];
        }
        CmpSchemeInfo[] info = new CmpSchemeInfo[objA.length];
        int size = objA.length;
        for (int i = 0; i < size; ++i) {
            info[i] = (CmpSchemeInfo)objA[i];
        }
        return info;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void initAllEditor() throws ParserException {
        this.prmtCmpScheme.setQueryInfo(this.cmpSchemeF7URL);
        this.prmtCmpScheme.setEnabledMultiSelection(true);
        this.prmtCmpScheme.setEditable(false);
        this.prmtCmpScheme.setEditFormat("$name$");
        this.prmtCmpScheme.setDisplayFormat("$name$");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfoCmpSch = new FilterInfo();
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.getHROrgUnit().getId().toString()));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("enable", (Object)3));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("isDelete", (Object)"0"));
        filterInfoCmpSch.setMaskString("#0 and (#1 or #2) and #3");
        this.prmtCmpScheme.setHasCUDefaultFilter(false);
        evi.setFilter(filterInfoCmpSch);
        this.prmtCmpScheme.setEntityViewInfo(evi);
        this.prmtCmpScheme.setEnabled(this.cmpSchInitStateFlag);
        if (this.chkShowDelete.isSelected()) {
            this.changeShowDelete();
        }
        this.prmtBeginCmpPeriod.setQueryInfo(this.cmpPeriodF7URL);
        this.prmtBeginCmpPeriod.setEditable(false);
        this.prmtBeginCmpPeriod.setEditFormat("$name$");
        this.prmtBeginCmpPeriod.setDisplayFormat("$name$");
        this.prmtBeginCmpPeriod.setHasCUDefaultFilter(false);
        EntityViewInfo eviCmpPeriod = new EntityViewInfo();
        FilterInfo filterInfoCmpPeriod = new FilterInfo();
        filterInfoCmpPeriod.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.getHROrgUnit().getId().toString()));
        eviCmpPeriod.setFilter(filterInfoCmpPeriod);
        this.prmtBeginCmpPeriod.setEntityViewInfo(eviCmpPeriod);
        this.prmtEndCmpPeriod.setQueryInfo(this.cmpPeriodF7URL);
        this.prmtEndCmpPeriod.setEditable(false);
        this.prmtEndCmpPeriod.setEditFormat("$name$");
        this.prmtEndCmpPeriod.setDisplayFormat("$name$");
        this.prmtEndCmpPeriod.setHasCUDefaultFilter(false);
        this.prmtEndCmpPeriod.setEntityViewInfo(eviCmpPeriod);
        CompUtils.initF7SelectorNoHR(this, this.prmtDepartment);
        this.prmtEmployeeType.setSelector((KDPromptSelector)new EmployeeTypePromptBox((IUIObject)this));
        this.prmtEmployeeType.setEditable(false);
        this.prmtEmployeeType.setEditFormat("$number$");
        this.prmtEmployeeType.setDisplayFormat("$name$");
        this.prmtEmployeeType.setEnabledMultiSelection(true);
        this.chkShowDelete.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EmployeeToTalFilter.this.isShowDelete = EmployeeToTalFilter.this.chkShowDelete.isSelected();
                EmployeeToTalFilter.this.changeShowDelete();
            }
        });
    }

    @Override
    protected void chkShowDelete_stateChanged(ChangeEvent e) throws Exception {
        super.chkShowDelete_stateChanged(e);
    }

    public void onLoad() throws Exception {
        this.initAllEditor();
        super.onLoad();
    }

    public boolean verify() {
        boolean flagOfDate;
        if (this.prmtBeginCmpPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_CMPPER")));
            return false;
        }
        if (this.prmtEndCmpPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_CMPPER")));
            return false;
        }
        if (this.prmtCmpScheme.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"363_EmployeeToTalFilter"));
            return false;
        }
        CmpPeriodInfo cmpPeriodInfoBegin = (CmpPeriodInfo)this.prmtBeginCmpPeriod.getData();
        CmpPeriodInfo cmpPeriodInfoEnd = (CmpPeriodInfo)this.prmtEndCmpPeriod.getData();
        if (!cmpPeriodInfoBegin.getId().toString().equals(cmpPeriodInfoEnd.getId().toString()) && !(flagOfDate = DateTimeUtils.dayAfter((Date)cmpPeriodInfoEnd.getBeginDate(), (Date)cmpPeriodInfoBegin.getEndDate()))) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpAdjustiveSchResource.BEGINDATE_AFTER_ENDDATE"));
            this.prmtBeginCmpPeriod.requestFocusInWindow();
            return false;
        }
        return true;
    }

    public CmpSchemeInfo getCmpSchemeInfo() {
        CmpSchemeInfo cmpSchemeInfo = new CmpSchemeInfo();
        if (this.prmtCmpScheme.getData() != null) {
            cmpSchemeInfo = (CmpSchemeInfo)this.prmtCmpScheme.getData();
        }
        return cmpSchemeInfo;
    }

    public CmpPeriodInfo getCmpBeginPeriodInfo() {
        CmpPeriodInfo cmpPeriodInfo = new CmpPeriodInfo();
        if (this.prmtBeginCmpPeriod.getData() != null) {
            cmpPeriodInfo = (CmpPeriodInfo)this.prmtBeginCmpPeriod.getData();
        }
        return cmpPeriodInfo;
    }

    private void changeShowDelete() {
        try {
            EntityViewInfo evi = new EntityViewInfo();
            if (!this.isShowDelete) {
                evi = new EntityViewInfo();
                FilterInfo filterInfoCmpSch = new FilterInfo();
                filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.getHROrgUnit().getId().toString()));
                filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
                filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("enable", (Object)3));
                filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("isDelete", (Object)"0"));
                filterInfoCmpSch.setMaskString("#0 and (#1 or #2) and #3");
                evi.setFilter(filterInfoCmpSch);
            } else {
                FilterInfo filterInfoCmpSch = new FilterInfo();
                filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.getHROrgUnit().getId().toString()));
                filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
                filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("enable", (Object)3));
                filterInfoCmpSch.setMaskString("#0 and (#1 or #2)");
                evi.setFilter(filterInfoCmpSch);
            }
            this.prmtCmpScheme.setEntityViewInfo(evi);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e);
        }
    }

    public CmpPeriodInfo getCmpEndPeriodInfo() {
        CmpPeriodInfo cmpPeriodInfo = new CmpPeriodInfo();
        if (this.prmtEndCmpPeriod.getData() != null) {
            cmpPeriodInfo = (CmpPeriodInfo)this.prmtEndCmpPeriod.getData();
        }
        return cmpPeriodInfo;
    }

    public CmpPeriodCollection getCmpPeriodCollection() throws Exception {
        CmpPeriodCollection col = null;
        Date beginDate = ((CmpPeriodInfo)this.prmtBeginCmpPeriod.getData()).getBeginDate();
        Date endDate = ((CmpPeriodInfo)this.prmtEndCmpPeriod.getData()).getEndDate();
        ICmpPeriod iCmpPeriod = CmpPeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo infoFilter = new FilterInfo();
        infoFilter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)beginDate, CompareType.GREATER_EQUALS));
        infoFilter.getFilterItems().add(new FilterItemInfo("endDate", (Object)endDate, CompareType.LESS_EQUALS));
        infoFilter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.getHROrgUnit().getId().toString()));
        infoFilter.setMaskString("#0 and #1 and #2");
        evi.setFilter(infoFilter);
        evi.getSorter().add(new SorterItemInfo("beginDate"));
        col = iCmpPeriod.getCmpPeriodCollection(evi);
        return col;
    }
}

