/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.compensation.CommonPermissionFacadeFactory;
import com.kingdee.eas.hr.compensation.CompenException;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeCollection;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeFactory;
import com.kingdee.eas.hr.compensation.IFixedCmpScheme;
import com.kingdee.eas.hr.compensation.StateEnum;
import com.kingdee.eas.hr.compensation.client.AbstractFixedSchemeListUI;
import com.kingdee.eas.hr.compensation.client.FixSchemeInitUI;
import com.kingdee.eas.hr.compensation.client.FixedCmpSchemeListUI;
import com.kingdee.eas.hr.compensation.util.CmpDateUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRTableTools;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FixedSchemeListUI
extends AbstractFixedSchemeListUI {
    private static final Logger logger = CoreUIObject.getLogger(FixedSchemeListUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnUnenable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            return;
        }
        int indexRow = e.getRowIndex();
        BizEnumValueDTO state = (BizEnumValueDTO)HRTableTools.getTableSelectCellValue(this.tblMain, "enable", indexRow);
        if (state != null && state.getInt("value") == 1) {
            this.btnEnableFixScheme.setEnabled(true);
            this.btnCancel.setEnabled(true);
            this.btnCancelCancel.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            if (this.actionEdit.isEnabled()) {
                this.btnEnable.setEnabled(false);
                this.btnUnenable.setEnabled(true);
            }
        } else {
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(true);
            this.btnRemove.setEnabled(true);
            this.menuItemRemove.setEnabled(true);
            if (this.actionEdit.isEnabled()) {
                this.btnEnable.setEnabled(true);
                this.btnUnenable.setEnabled(false);
            }
        }
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkMaintainDataPermission();
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        HRSchemeUtils.checkInit();
        ((IFixedCmpScheme)this.getBizInterface()).upgradeFixedSchemeData();
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(2);
        if (this.actionEdit.isEnabled()) {
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            if (selectRows.length > 0) {
                BizEnumValueDTO state = (BizEnumValueDTO)HRTableTools.getTableSelectCellValue(this.tblMain, "enable", selectRows[0]);
                if (state.getInt("value") == 0 || state.getInt("value") == 3) {
                    this.btnEnable.setEnabled(true);
                    this.btnUnenable.setEnabled(false);
                } else {
                    this.btnEnable.setEnabled(false);
                    this.btnUnenable.setEnabled(true);
                }
            }
        } else {
            this.btnEnable.setEnabled(false);
            this.btnUnenable.setEnabled(false);
        }
        CmpDateUtils.setColumnDateFormat(this.tblMain, new String[]{"createTime", "enableDate", "disableDate"});
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.refresh(null);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        int result = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"389_FixedSchemeListUI"));
        if (result != 0) {
            return;
        }
        String id = this.getSelectedKeyValue();
        ((IFixedCmpScheme)this.getBizInterface()).updateEnableState(id, StateEnum.ENABLE);
        this.refresh(null);
    }

    public void actionQueryScheme_actionPerformed(ActionEvent e) throws Exception {
        super.actionQueryScheme_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FixedCmpSchemeFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return FixSchemeInitUI.class.getName();
    }

    @Override
    public void actionStartupFixScheme_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            BizEnumValueDTO salarState;
            BizEnumValueDTO state = (BizEnumValueDTO)HRTableTools.getTableSelectCellValue(this.tblMain, "enable", selectRows[0]);
            if (state != null && state.getInt("value") == 0) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"640_FixedSchemeListUI"));
                SysUtil.abort();
            }
            if ((salarState = (BizEnumValueDTO)HRTableTools.getTableSelectCellValue(this.tblMain, "salariatScheme.state", selectRows[0])) != null && salarState.getInt("value") == 3) {
                String schemeName = (String)HRTableTools.getTableSelectCellValue(this.tblMain, "salariatScheme.name", selectRows[0]);
                String msgBoxForbid1 = EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.FixedCmpSchemeResource", (String)"MsgBoxForbid1");
                String msgBoxForbid2 = EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.FixedCmpSchemeResource", (String)"MsgBoxForbid2");
                int choose = MsgBox.showConfirm3((String)(msgBoxForbid1 + schemeName + msgBoxForbid2));
                if (choose != 0) {
                    SysUtil.abort();
                }
            }
        }
        String id = this.getSelectedKeyValue();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id.toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(FixedCmpSchemeListUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    protected void cancel() throws Exception {
        String id = this.getSelectedKeyValue();
        ((IFixedCmpScheme)this.getBizInterface()).updateEnableState(id, StateEnum.DISABLE);
    }

    protected void cancelCancel() throws Exception {
        super.cancelCancel();
    }

    protected EntityViewInfo getDefaultEntityViewInfo() {
        return super.getDefaultEntityViewInfo();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        String hrorgID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrorgID));
        return filterInfo;
    }

    protected boolean confirmRemove() {
        BizEnumValueDTO state;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int indexRow = -1;
        if (selectRows.length > 0) {
            indexRow = selectRows[0];
        }
        if ((state = (BizEnumValueDTO)HRTableTools.getTableSelectCellValue(this.tblMain, "enable", indexRow)) != null && state.getInt("value") == 1) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"390_FixedSchemeListUI"));
            return false;
        }
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"391_FixedSchemeListUI")));
    }

    private void checkMaintainDataPermission() throws Exception {
        String id = this.getSelectedKeyValue();
        HROrgUnitInfo hro = SysContext.getSysContext().getCurrentHRUnit();
        if (!StringUtils.isEmpty((String)id) && hro != null) {
            HashSet<String> hroSet = new HashSet<String>();
            hroSet.add(hro.getId().toString());
            EntityViewInfo view = CommonPermissionFacadeFactory.getRemoteInstance().getHRsDataPermission(hroSet, "hrOrgUnit.id", "fixedCmpScheme_edit");
            FixedCmpSchemeCollection coll = FixedCmpSchemeFactory.getRemoteInstance().getFixedCmpSchemeCollection(view);
            boolean flag = false;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                if (!coll.get(i).getId().toString().equals(id)) continue;
                flag = true;
                break;
            }
            if (!flag) {
                Object[] param = new String[]{hro.getName(), ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.ServerResource", (String)"fixedCmpScheme_edit", (Locale)SysContext.getSysContext().getLocale())};
                throw new CompenException(CompenException.DATAPERMISSION_EXCEPTION, param);
            }
        }
    }

    @Override
    protected void btnEnable_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            if (this.tblMain.getRowCount() > 1) {
                if (MsgBox.isYes((int)MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"398_FixSchemeInitUI")))) {
                    String id = this.getSelectedKeyValue();
                    FixedCmpSchemeFactory.getRemoteInstance().updateEnableState(id, StateEnum.ENABLE);
                    this.actionRefresh_actionPerformed(e);
                }
            } else {
                String id = this.getSelectedKeyValue();
                FixedCmpSchemeFactory.getRemoteInstance().updateEnableState(id, StateEnum.ENABLE);
                this.actionRefresh_actionPerformed(e);
            }
        }
    }

    @Override
    protected void btnUnenable_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            String id = this.getSelectedKeyValue();
            FixedCmpSchemeFactory.getRemoteInstance().updateEnableState(id, StateEnum.DISABLE);
            this.actionRefresh_actionPerformed(e);
        }
    }
}

