/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.AdminByCurrentHROF7WithOrgRangeFilter;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.compensation.client.AbstractSHRcmpTotalReportFilterUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class SHRcmpTotalReportFilterUI
extends AbstractSHRcmpTotalReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(SHRcmpTotalReportFilterUI.class);
    private String resourceURL = "com.kingdee.eas.hr.compensation.client.SHRcmpResource.";
    private String cmpPeriodF7URL = "com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery";
    final String cp_btnCmpPersonSelect = "btnCmpPersonSelect";
    final String cp_btnCmpAdminSelect = "btnCmpAdminSelect";
    final String cp_btnCampanyWithDeptSelect = "btnCampanyWithDeptSelect";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
    }

    public boolean verify() {
        boolean flagOfDate;
        if (this.prmtBeginCmpPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resourceURL + "MUST_CMPBEGINPER")));
            this.prmtBeginCmpPeriod.requestFocusInWindow();
            return false;
        }
        if (this.btnCmpPersonSelect.isSelected()) {
            if (this.prmtCmpPerson.getData() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)(this.resourceURL + "MUST_CMPPERSON")));
                this.prmtCmpPerson.requestFocusInWindow();
                return false;
            }
        } else if (this.btnCmpAdminSelect.isSelected() && this.prmtAdminUnitOrg.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resourceURL + "MUST_CMPADMINORG")));
            this.prmtAdminUnitOrg.requestFocusInWindow();
            return false;
        }
        if (this.prmtEndCmpPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resourceURL + "MUST_CMENDPER")));
            this.prmtEndCmpPeriod.requestFocusInWindow();
            return false;
        }
        CmpPeriodInfo cmpPeriodInfoBegin = (CmpPeriodInfo)this.prmtBeginCmpPeriod.getData();
        CmpPeriodInfo cmpPeriodInfoEnd = (CmpPeriodInfo)this.prmtEndCmpPeriod.getData();
        if (!cmpPeriodInfoBegin.getId().toString().equals(cmpPeriodInfoEnd.getId().toString()) && !(flagOfDate = DateTimeUtils.dayAfter((Date)cmpPeriodInfoEnd.getBeginDate(), (Date)cmpPeriodInfoBegin.getEndDate()))) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpAdjustiveSchResource.BEGINDATE_AFTER_ENDDATE"));
            this.prmtBeginCmpPeriod.requestFocusInWindow();
            return false;
        }
        return true;
    }

    @Override
    protected void btnCmpAdminSelect_stateChanged(ChangeEvent e) throws Exception {
        super.btnCmpAdminSelect_stateChanged(e);
        if (this.btnCmpAdminSelect.isSelected()) {
            this.prmtAdminUnitOrg.setEnabled(true);
            this.prmtCmpPerson.setEnabled(false);
            this.prmtEndCmpPeriod.setEnabled(true);
        }
    }

    @Override
    protected void btnCmpPersonSelect_stateChanged(ChangeEvent e) throws Exception {
        super.btnCmpPersonSelect_stateChanged(e);
        if (this.btnCmpPersonSelect.isSelected()) {
            this.prmtCmpPerson.setEnabled(true);
            this.prmtAdminUnitOrg.setEnabled(false);
            this.prmtEndCmpPeriod.setEnabled(true);
        }
    }

    @Override
    protected void btnCampanyWithDept_stateChanged(ChangeEvent e) throws Exception {
        super.btnCampanyWithDept_stateChanged(e);
        if (this.btnCampanyWithDept.isSelected()) {
            this.prmtCmpPerson.setEnabled(false);
            this.prmtAdminUnitOrg.setEnabled(false);
            this.prmtEndCmpPeriod.setEnabled(true);
        }
    }

    private void initAllEditor() throws ParserException {
        HROrgUnitInfo hrOrgUnitInfo = HRSchemeUtils.getClientHROrgUnitInfo();
        EntityViewInfo eviCmpPeriod = new EntityViewInfo();
        FilterInfo filterInfoCmpPeriod = new FilterInfo();
        filterInfoCmpPeriod.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrOrgUnitInfo.getId().toString()));
        eviCmpPeriod.setFilter(filterInfoCmpPeriod);
        this.prmtBeginCmpPeriod.setQueryInfo(this.cmpPeriodF7URL);
        this.prmtBeginCmpPeriod.setEditable(false);
        this.prmtBeginCmpPeriod.setEditFormat("$name$");
        this.prmtBeginCmpPeriod.setDisplayFormat("$name$");
        this.prmtBeginCmpPeriod.setEntityViewInfo(eviCmpPeriod);
        this.prmtEndCmpPeriod.setQueryInfo(this.cmpPeriodF7URL);
        this.prmtEndCmpPeriod.setEditable(false);
        this.prmtEndCmpPeriod.setEditFormat("$name$");
        this.prmtEndCmpPeriod.setDisplayFormat("$name$");
        this.prmtEndCmpPeriod.setEntityViewInfo(eviCmpPeriod);
        EmployeeMultiF7PromptBox pmt = new EmployeeMultiF7PromptBox();
        pmt.setModal(true);
        pmt.showOnlyPayPerson(true);
        pmt.setIsSingleSelect(true);
        pmt.showNoPositionPerson(true);
        this.prmtCmpPerson.setSelector((KDPromptSelector)pmt);
        this.prmtCmpPerson.setDisplayFormat("$name$");
        this.prmtCmpPerson.setEditable(false);
        AdminByCurrentHROF7WithOrgRangeFilter adminF7 = new AdminByCurrentHROF7WithOrgRangeFilter();
        adminF7.setMultiSelect(false);
        this.prmtAdminUnitOrg.setSelector((KDPromptSelector)adminF7);
        this.prmtAdminUnitOrg.setDisplayFormat("$name$");
        this.prmtAdminUnitOrg.setEditable(false);
        this.prmtAdminUnitOrg.setEnabled(false);
    }

    public void clear() {
        super.clear();
        if (this.prmtBeginCmpPeriod.getData() != null) {
            this.prmtBeginCmpPeriod.setData(null);
        }
        if (this.prmtEndCmpPeriod.getData() != null) {
            this.prmtEndCmpPeriod.setData(null);
        }
        if (this.prmtAdminUnitOrg.getData() != null) {
            this.prmtAdminUnitOrg.setData(null);
        }
        if (this.prmtCmpPerson.getData() != null) {
            this.prmtCmpPerson.setData(null);
        }
        this.btnCmpPersonSelect.setSelected(true);
        this.btnCmpAdminSelect.setSelected(false);
    }

    private List getPeriodList(CmpPeriodInfo beginPeriodInfo, CmpPeriodInfo endPeriodInfo) throws BOSException {
        String beginDate = beginPeriodInfo.getBeginDate().toString();
        String endDate = endPeriodInfo.getEndDate().toString();
        HROrgUnitInfo hrOrgUnitInfo = HRSchemeUtils.getClientHROrgUnitInfo();
        String oql = "SELECT * WHERE beginDate >='" + beginDate + "' AND endDate <='" + endDate + "' AND hrOrgUnit.id='" + hrOrgUnitInfo.getId().toString() + "' ORDER BY beginDate";
        ICmpPeriod iCmpPeriod = CmpPeriodFactory.getRemoteInstance();
        CmpPeriodCollection cmpPeriodColl = iCmpPeriod.getCmpPeriodCollection(oql);
        int size = cmpPeriodColl.size();
        ArrayList<CmpPeriodInfo> periodList = new ArrayList<CmpPeriodInfo>();
        for (int i = 0; i < size; ++i) {
            CmpPeriodInfo cmpPeriodTmp = cmpPeriodColl.get(i);
            periodList.add(cmpPeriodTmp);
        }
        return periodList;
    }

    public HashMap getFilterParam() throws BOSException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        CmpPeriodInfo beginPeriodInfo = (CmpPeriodInfo)this.prmtBeginCmpPeriod.getData();
        CmpPeriodInfo endPeriodInfo = (CmpPeriodInfo)this.prmtEndCmpPeriod.getData();
        if (this.btnCmpAdminSelect.isSelected()) {
            AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)this.prmtAdminUnitOrg.getData();
            paramMap.put("periodList", this.getPeriodList(beginPeriodInfo, endPeriodInfo));
            paramMap.put("operationkey", "departmentFlag");
            paramMap.put("adminInfo", adminOrgUnitInfo);
        } else if (this.btnCmpPersonSelect.isSelected()) {
            PersonInfo personInfo = (PersonInfo)this.prmtCmpPerson.getData();
            paramMap.put("periodList", this.getPeriodList(beginPeriodInfo, endPeriodInfo));
            paramMap.put("operationkey", "personalFlag");
            paramMap.put("personalInfo", personInfo);
        } else if (this.btnCampanyWithDept.isSelected()) {
            paramMap.put("periodList", this.getPeriodList(beginPeriodInfo, endPeriodInfo));
            paramMap.put("operationkey", "companyFlag");
        }
        return paramMap;
    }

    public CustomerParams getCustomerParams() {
        PersonInfo personInfo;
        AdminOrgUnitInfo adminOrgUnitInfo;
        CustomerParams cp = new CustomerParams();
        CmpPeriodInfo cmpPeriodInfoTem = (CmpPeriodInfo)this.prmtBeginCmpPeriod.getData();
        if (cmpPeriodInfoTem != null) {
            cp.addCustomerParam("beginPeriod", cmpPeriodInfoTem.getId().toString());
        }
        if ((cmpPeriodInfoTem = (CmpPeriodInfo)this.prmtEndCmpPeriod.getData()) != null) {
            cp.addCustomerParam("endPeriod", cmpPeriodInfoTem.getId().toString());
        }
        if ((adminOrgUnitInfo = (AdminOrgUnitInfo)this.prmtAdminUnitOrg.getData()) != null) {
            cp.addCustomerParam("adminInfo", adminOrgUnitInfo.getId().toString());
        }
        if ((personInfo = (PersonInfo)this.prmtCmpPerson.getData()) != null) {
            cp.addCustomerParam("personalInfo", personInfo.getId().toString());
        }
        cp.putBoolean("btnCmpPersonSelect", this.btnCmpPersonSelect.isSelected());
        cp.putBoolean("btnCmpAdminSelect", this.btnCmpAdminSelect.isSelected());
        cp.putBoolean("btnCampanyWithDeptSelect", this.btnCampanyWithDept.isSelected());
        return cp;
    }

    public void setCustomerParams(CustomerParams param) {
        if (param == null) {
            return;
        }
        String temV = null;
        temV = param.getCustomerParam("beginPeriod");
        if (temV != null) {
            try {
                this.prmtBeginCmpPeriod.setValue((Object)CmpPeriodFactory.getRemoteInstance().getCmpPeriodInfo((IObjectPK)new ObjectUuidPK(temV)));
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if ((temV = param.getCustomerParam("endPeriod")) != null) {
            try {
                this.prmtEndCmpPeriod.setValue((Object)CmpPeriodFactory.getRemoteInstance().getCmpPeriodInfo((IObjectPK)new ObjectUuidPK(temV)));
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if ((temV = param.getCustomerParam("adminInfo")) != null) {
            try {
                this.prmtAdminUnitOrg.setValue((Object)AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(temV)));
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if ((temV = param.getCustomerParam("personalInfo")) != null) {
            try {
                this.prmtCmpPerson.setValue((Object)PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(temV)));
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        this.btnCmpPersonSelect.setSelected(param.getBoolean(this.cp_btnCmpPersonSelect));
        this.btnCmpAdminSelect.setSelected(param.getBoolean(this.cp_btnCmpAdminSelect));
        this.btnCampanyWithDept.setSelected(param.getBoolean(this.cp_btnCampanyWithDeptSelect));
    }
}

