/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.base.DynamicTableInfo;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemException;
import com.kingdee.eas.hr.compensation.ISalariatScheme;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.ItemObjectTypeEnum;
import com.kingdee.eas.hr.compensation.SalariatException;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsCollection;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsInfo;
import com.kingdee.eas.hr.compensation.SalariatSchemeFacadeFactory;
import com.kingdee.eas.hr.compensation.SalariatSchemeFactory;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.StateEnum;
import com.kingdee.eas.hr.compensation.client.AbstractSalariatPointTableUI;
import com.kingdee.eas.hr.compensation.client.ImportDateSalariatPointTableUI;
import com.kingdee.eas.hr.compensation.client.SalariatPointPromptBox;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRDynamicTableUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;

public class SalariatPointTableUI
extends AbstractSalariatPointTableUI {
    private static BigDecimal ZERO = new BigDecimal(0.0).setScale(2);
    private String schemeID = null;
    private SalariatSchemeInfo schemeInfo = null;
    private SalariatHiberPropsCollection pointList = null;
    private List columnNames = null;
    private List columnTypes = null;
    private boolean isChanged = false;
    private KDTSortManager sm = null;
    private boolean isEditStopped = false;
    private DynamicTableInfo.ColumnInfo[] infosColumn = null;
    private CmpItemCollection cmpItemColls = null;

    public SalariatPointTableUI() throws Exception {
        this.kdMainTbl.getStyleAttributes().setNumberFormat("%r{0.00}f");
        this.kdMainTbl.addKDTEditListener((KDTEditListener)new CellEditAdapter());
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        ArrayList valueMapList = new ArrayList();
        HashMap valueMap = null;
        IRow row = null;
        ICell cell = null;
        int rowCount = this.kdMainTbl.getRowCount();
        int columnCount = this.kdMainTbl.getColumnCount();
        Object cellObj = null;
        HashSet<String> pointids = new HashSet<String>();
        for (int i = 0; i < rowCount; ++i) {
            row = this.kdMainTbl.getRow(i);
            valueMap = new HashMap();
            for (int j = 0; j < columnCount; ++j) {
                cell = row.getCell(j);
                cellObj = cell.getValue();
                if (cellObj != null && cellObj instanceof SalariatHiberPropsInfo) {
                    pointids.add(((SalariatHiberPropsInfo)cellObj).getId().toString());
                } else if (cellObj != null && (this.infosColumn[j].getColumnType() == 60 || this.infosColumn[j].getColumnType() == 50)) {
                    cellObj = HRCmpItemUtils.convertPrecisionForBigDecimal((BigDecimal)cellObj, this.infosColumn[j].getScale(), this.infosColumn[j].getPrecisionType());
                }
                valueMap.put(this.columnNames.get(j), cellObj);
            }
            valueMapList.add(valueMap);
        }
        if (pointids.size() > 0 && pointids.size() < rowCount) {
            super.handUIException((Throwable)((Object)new CmpItemException(CmpItemException.CMPITEM_NOT_ADDSAMEROW)));
            SysUtil.abort();
        }
        try {
            ObjectUuidPK schemePK = new ObjectUuidPK(BOSUuid.read((String)this.schemeID));
            IObjectPK logPK = LogUtil.beginLog(null, (String)"", (BOSObjectType)this.schemeInfo.getBOSType(), (IObjectPK)schemePK, (String)this.schemeInfo.getName(), (String)"salaritsch_point_update");
            SalariatSchemeFacadeFactory.getRemoteInstance().saveListPointData(this.schemeInfo.getPointTableName(), this.columnNames, this.columnTypes, valueMapList, null);
            LogUtil.afterLog(null, (IObjectPK)logPK);
            MsgBox.showInfo((String)HRUtils.getSalariatResourceStr("SAVE_SUCCESS"));
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public boolean verifyDataNew() throws Exception {
        int rowCount = this.kdMainTbl.getRowCount();
        IRow row = null;
        ICell cell = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.kdMainTbl.getRow(i);
            cell = row.getCell("FPointID");
            if (cell.getValue() != null) continue;
            MsgBox.showError((String)MessageFormat.format(HRUtils.getSalariatResourceStr("MISS_ROWSET_POINT"), i + 1));
            this.kdMainTbl.getSelectManager().removeAll(false);
            this.kdMainTbl.getEditManager().editCellAt(row.getRowIndex(), 0);
            return false;
        }
        return true;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnAddNewLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnRemoveLine.setText(null);
        this.btnInsertLine.setText(null);
        this.btnAddNewLine.setText(null);
        this.ctnMain.addButton((JButton)this.btnAddNewLine);
        this.ctnMain.addButton((JButton)this.btnInsertLine);
        this.ctnMain.addButton((JButton)this.btnRemoveLine);
    }

    private void setOperateState(boolean state) {
        if (state) {
            this.btnAddNewLine.setEnabled(true);
            this.btnInsertLine.setEnabled(true);
            this.btnRemoveLine.setEnabled(true);
            this.btnSave.setEnabled(true);
            this.btnImport.setEnabled(true);
        } else {
            this.btnAddNewLine.setEnabled(false);
            this.btnInsertLine.setEnabled(false);
            this.btnRemoveLine.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnImport.setEnabled(false);
        }
    }

    public void onLoad() throws Exception {
        CmpItemCollection cmpItems;
        super.onLoad();
        this.columnNames = new ArrayList();
        this.columnTypes = new ArrayList();
        this.columnNames.add("FPointID");
        this.columnTypes.add(ItemObjectTypeEnum.BIZOBJECT);
        this.schemeID = (String)this.getUIContext().get("ID");
        ISalariatScheme iBiz = SalariatSchemeFactory.getRemoteInstance();
        ObjectUuidPK schemePK = new ObjectUuidPK(BOSUuid.read((String)this.schemeID));
        this.schemeInfo = (SalariatSchemeInfo)iBiz.getValue((IObjectPK)schemePK);
        boolean state = false;
        if (StateEnum.ENABLE.equals((Object)this.schemeInfo.getState())) {
            state = true;
        }
        this.setOperateState(state);
        this.pointList = HRUtils.getPointItemsByScheme(this.schemeID);
        this.cmpItemColls = cmpItems = HRUtils.getCmpItemsByScheme(this.schemeID);
        DynamicTableInfo dynTableInfo = new DynamicTableInfo();
        dynTableInfo.setName(this.schemeInfo.getGradeTableName());
        int countColumn = cmpItems.size() + 1;
        this.infosColumn = new DynamicTableInfo.ColumnInfo[countColumn];
        DynamicTableInfo.ColumnInfo pointColumnInfo = new DynamicTableInfo.ColumnInfo();
        pointColumnInfo.setHide(false);
        pointColumnInfo.setReadOnly(false);
        pointColumnInfo.setKey("FPointID");
        pointColumnInfo.setColumnNumber("FPointID");
        pointColumnInfo.setColumnName("FPointID");
        pointColumnInfo.setColumnType(30);
        pointColumnInfo.setObjectType(ItemObjectTypeEnum.BIZOBJECT);
        pointColumnInfo.setDefaultObj("com.kingdee.eas.hr.compensation.client.SalariatPointPromptBox");
        pointColumnInfo.setDefaultF7UI("com.kingdee.eas.hr.compensation.client.SalariatPointPromptBox");
        pointColumnInfo.setCellEditorByObjtype();
        pointColumnInfo.getInfosHead()[0] = new DynamicTableInfo.HeadInfo();
        pointColumnInfo.getInfosHead()[0].setHeadName(HRUtils.getSalariatResourceStr("POINT"));
        this.infosColumn[0] = pointColumnInfo;
        int j = 1;
        int i = 0;
        while (i < cmpItems.size()) {
            this.infosColumn[j] = new DynamicTableInfo.ColumnInfo(cmpItems.get(i));
            this.columnNames.add(cmpItems.get(i).getNumber());
            this.columnTypes.add(cmpItems.get(i).getDataType());
            ++i;
            ++j;
        }
        dynTableInfo.setInfosColumn(this.infosColumn);
        HRDynamicTableUtils.createTableHead(this.kdMainTbl, dynTableInfo);
        this.loadTableData();
        this.kdMainTbl.getSelectManager().setSelectMode(1);
        if (this.kdMainTbl.getRowCount() > 0) {
            this.kdMainTbl.getSelectManager().select(0, 0, 0, 0);
        }
        HRUtils.removeLintMenu(this.kdMainTbl, this.getMenuManager(this.kdMainTbl));
        this.kdMainTbl.getStyleAttributes().setLocked(!state);
        this.kdMainTbl.getSelectManager().setSelectMode(15);
    }

    private void loadTableData() throws Exception {
        int i;
        if (this.schemeInfo.getPointTableName() == null || this.schemeInfo.getPointTableName().equals("")) {
            return;
        }
        IRowSet rs = SalariatSchemeFacadeFactory.getRemoteInstance().getListPointData(this.schemeInfo.getPointTableName());
        if (rs == null) {
            return;
        }
        this.kdMainTbl.removeRows();
        int coumnCount = this.kdMainTbl.getColumnCount();
        IRow row = null;
        ICell cell = null;
        boolean hasOldData = false;
        HashMap<String, String> map = new HashMap<String, String>();
        while (rs.next()) {
            hasOldData = true;
            row = this.kdMainTbl.addRow();
            for (i = 0; i < coumnCount; ++i) {
                cell = row.getCell(i);
                String columnName = (String)this.columnNames.get(i);
                Object columnType = this.columnTypes.get(i);
                if (columnType.equals((Object)ItemObjectTypeEnum.BIZOBJECT)) {
                    String objID = rs.getString(columnName);
                    SalariatHiberPropsInfo info = this.getPointInfoByID(objID);
                    cell.setValue((Object)info);
                    map.put(objID, "true");
                    continue;
                }
                if (columnType.equals((Object)ItemObjectTypeEnum.ENUM)) continue;
                if (columnType.equals((Object)ItemDataTypeEnum.STRING)) {
                    String strValue = rs.getString(columnName);
                    cell.setValue((Object)strValue);
                    continue;
                }
                if (columnType.equals((Object)ItemDataTypeEnum.FLOAT) || columnType.equals((Object)ItemDataTypeEnum.CURRENCY)) {
                    BigDecimal value = rs.getBigDecimal(columnName);
                    cell.setValue((Object)value);
                    continue;
                }
                if (!columnType.equals((Object)ItemDataTypeEnum.INT)) continue;
                int intValue = rs.getInt(columnName);
                cell.setValue((Object)intValue);
            }
        }
        if (!hasOldData) {
            for (i = 0; i < this.pointList.size(); ++i) {
                row = this.kdMainTbl.addRow();
                this.setInitRowValue(row);
                cell = row.getCell(0);
                cell.setValue((Object)this.pointList.get(i));
            }
        } else {
            for (i = 0; i < this.pointList.size(); ++i) {
                SalariatHiberPropsInfo info = this.pointList.get(i);
                if (map.containsKey(info.getId().toString())) continue;
                row = this.kdMainTbl.addRow();
                this.setInitRowValue(row);
                cell = row.getCell(0);
                cell.setValue((Object)this.pointList.get(i));
            }
        }
        HRSchemeUtils.enableTableHeadSortNotNeedSortManager(this.kdMainTbl, 0, this.kdMainTbl.getRowCount() - 1, this.getKDSortManger());
    }

    private KDTSortManager getKDSortManger() {
        if (this.sm == null) {
            this.sm = new KDTSortManager(this.kdMainTbl);
        }
        return this.sm;
    }

    private SalariatHiberPropsInfo getPointInfoByID(String id) {
        SalariatHiberPropsInfo info = null;
        for (int i = 0; i < this.pointList.size(); ++i) {
            if (!id.equals(this.pointList.get(i).getId().toString())) continue;
            info = this.pointList.get(i);
            return info;
        }
        return info;
    }

    private void setInitRowValue(IRow row) {
        for (int i = 1; i < this.kdMainTbl.getColumnCount(); ++i) {
            ICell cell = row.getCell(i);
            cell.setValue((Object)ZERO);
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        CmpItemCollection cmpItems1 = HRUtils.getCmpItemsBySchem(null, this.schemeID);
        CmpItemCollection cmpItess2 = HRUtils.getCmpItemCollection();
        if (cmpItess2.size() == 0) {
            throw new CmpItemException(CmpItemException.CMPITEM_FILLDEDUCTFILLPAY_DATAPERMISSION, new Object[]{cmpItems1.get(0).getNumber()});
        }
        if (cmpItems1.size() > 0) {
            int j = cmpItems1.size();
            for (int i = 0; i < j; ++i) {
                if (cmpItess2.contains(cmpItems1.get(i))) continue;
                throw new CmpItemException(CmpItemException.CMPITEM_FILLDEDUCTFILLPAY_DATAPERMISSION, new Object[]{cmpItems1.get(i).getNumber()});
            }
        }
        if (!this.verifyDataNew()) {
            return;
        }
        this.storeFields();
        this.loadTableData();
        this.isChanged = false;
    }

    @Override
    public void actionAddnew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddnew_actionPerformed(e);
        IRow row = this.kdMainTbl.addRow();
        this.setInitRowValue(row);
        this.isChanged = true;
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelete_actionPerformed(e);
        int activeIndex = this.kdMainTbl.getSelectManager().getActiveRowIndex();
        if (activeIndex == -1) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.MISS_SELECT_ROW)));
            return;
        }
        this.kdMainTbl.removeRow(activeIndex);
        this.isChanged = true;
        HRSchemeUtils.enableTableHeadSortNotNeedSortManager(this.kdMainTbl, 0, this.kdMainTbl.getRowCount() - 1, this.getKDSortManger());
        if (this.kdMainTbl.getRowCount() <= 1) {
            this.getKDSortManger().setSortAuto(true);
            this.getKDSortManger().clearGroup();
            if (this.kdMainTbl.getRowCount() > 0) {
                this.getKDSortManger().addGroup(0, 0);
            }
        }
    }

    @Override
    public void actionInsert_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsert_actionPerformed(e);
        int activeIndex = this.kdMainTbl.getSelectManager().getActiveRowIndex();
        if (activeIndex == -1) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.MISS_SELECT_ROW)));
            return;
        }
        IRow row = this.kdMainTbl.addRow(activeIndex);
        this.setInitRowValue(row);
        this.isChanged = true;
    }

    protected boolean checkBeforeWindowClosing() {
        try {
            if (!HRUtils.isPermissionByKey("salariatPointTab_maintain")) {
                this.isChanged = false;
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (!this.isChanged) {
            return super.checkBeforeWindowClosing();
        }
        int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
        if (result == 0) {
            try {
                if (!this.isEditStopped) {
                    this.kdMainTbl.getEditManager().stopEditing();
                }
                this.actionSave_actionPerformed(new ActionEvent(this.btnSave, 0, "Click SaveButton"));
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else {
            return result != 2;
        }
        return super.checkBeforeWindowClosing();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.COMPENSATION;
    }

    protected KDTable getTableForOA() {
        return this.kdMainTbl;
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        if (this.cmpItemColls == null || this.cmpItemColls.size() < 1) {
            return;
        }
        UIContext context = new UIContext((Object)this);
        ArrayList<DatataskParameter> importParam = new ArrayList<DatataskParameter>();
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.hr.compensation.SalariatPointTableUI";
        param.alias = EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.ImportDateEndDataResource", (String)"SALTABLE");
        importParam.add(param);
        context.put((Object)"params", importParam);
        context.put((Object)"mode", (Object)0);
        LinkedHashMap<String, String> colKeyName = new LinkedHashMap<String, String>();
        colKeyName.put("FPointID", HRUtils.getSalariatResourceStr("POINT"));
        int size = this.cmpItemColls.size();
        for (int i = 0; i < size; ++i) {
            colKeyName.put(this.cmpItemColls.get(i).getNumber(), this.cmpItemColls.get(i).getName());
        }
        context.put((Object)"colKeyName", colKeyName);
        context.put((Object)"Owner", (Object)this);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow curDialog = uiFactory.create(ImportDateSalariatPointTableUI.class.getName(), (Map)context, null, OprtState.ADDNEW);
        curDialog.show();
    }

    public KDTable getTable() {
        return this.kdMainTbl;
    }

    class CellEditAdapter
    extends KDTEditAdapter {
        CellEditAdapter() {
        }

        public void editStarting(KDTEditEvent e) {
            ICellEditor editor;
            Component component;
            super.editStarting(e);
            KDTable table = (KDTable)e.getSource();
            int colIndex = e.getColIndex();
            IColumn column = table.getColumn(colIndex);
            if (column.getKey() == null) {
                return;
            }
            if (column.getKey().equals("FPointID") && (component = (editor = table.getEditManager().getEditor()).getComponent()) instanceof KDBizPromptBox) {
                KDBizPromptBox kdBiz = (KDBizPromptBox)component;
                SalariatPointPromptBox pointPromtBox = (SalariatPointPromptBox)kdBiz.getSelector();
                pointPromtBox.putParameter("schemeID", SalariatPointTableUI.this.schemeID);
                pointPromtBox.putParameter((Object)"Owner", SalariatPointTableUI.this.getUIContext().get("Owner"));
            }
            SalariatPointTableUI.this.isEditStopped = false;
            SalariatPointTableUI.this.isChanged = true;
        }

        public void editStopped(KDTEditEvent evt) {
            super.editStopped(evt);
            KDTable table = (KDTable)evt.getSource();
            int colIndex = evt.getColIndex();
            Object newValue = evt.getValue();
            if (newValue == null) {
                return;
            }
            IColumn column = table.getColumn(colIndex);
            if (column.getKey() == null) {
                return;
            }
            if (column.getKey().equals("FPointID")) {
                SalariatPointTableUI.this.isEditStopped = true;
            }
        }

        public void editValueChanged(KDTEditEvent e) {
            super.editValueChanged(e);
            SalariatPointTableUI.this.isChanged = true;
        }
    }
}

