/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.hr.compensation.CmpItemCatalogCollection;
import com.kingdee.eas.hr.compensation.CmpItemCatalogFactory;
import com.kingdee.eas.hr.compensation.CmpItemCatalogInfo;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.SalaraitCmpItemPropsCollection;
import com.kingdee.eas.hr.compensation.SalaraitCmpItemPropsInfo;
import com.kingdee.eas.hr.compensation.SalariatException;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.client.AbstractSalariatSchCmpItemPropsUI;
import com.kingdee.eas.hr.compensation.client.BaseSelectItemData;
import com.kingdee.eas.hr.compensation.client.BaseSelectItemUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ListModel;
import org.apache.log4j.Logger;

public class SalariatSchCmpItemPropsUI
extends AbstractSalariatSchCmpItemPropsUI {
    private static Logger logger = Logger.getLogger(SalariatSchCmpItemPropsUI.class);
    public static final String RESOURCE_PATH = "com.kingdee.eas.hr.compensation.client.SalariatResource";
    private static String PERSONSATALOB_NUMBER = "FPER";
    private SalariatSchemeInfo schmInfo = null;
    private SalaraitCmpItemPropsCollection itemsCollection = null;
    private CmpItemCatalogCollection cmpItemCatalogCollection = null;
    private HashMap allItemMap = new HashMap();
    private HashMap selectItemMap = new HashMap();
    private BOSUuid oldCatalogID = null;
    private boolean isSelectChange = false;
    private int currSelectIndex = -1;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.kdComboCatalog.setSelectedIndex(-1);
        this.kdComboCatalog.setSelectedIndex(this.currSelectIndex);
        this.itemsCollection = new SalaraitCmpItemPropsCollection();
        int count = this.getSelectItemsModel().size();
        SalaraitCmpItemPropsInfo salCmpItem = null;
        CmpItemInfo cmpItem = null;
        for (int i = 0; i < count; ++i) {
            BaseSelectItemData item = (BaseSelectItemData)this.getSelectItemsModel().getElementAt(i);
            cmpItem = (CmpItemInfo)item.getDataObject();
            salCmpItem = new SalaraitCmpItemPropsInfo();
            salCmpItem.setItem(cmpItem);
            salCmpItem.setSeq(i);
            this.itemsCollection.add(salCmpItem);
        }
    }

    public boolean verifyDataNew() throws Exception {
        this.kdComboCatalog.setSelectedIndex(-1);
        this.kdComboCatalog.setSelectedIndex(this.currSelectIndex);
        if (this.getSelectItemsModel().size() == 0) {
            this.handleException((Exception)((Object)new SalariatException(SalariatException.NULL_CMPITEMS)));
            return false;
        }
        return true;
    }

    public SalaraitCmpItemPropsCollection getItemsCollection() {
        if (this.itemsCollection == null) {
            this.itemsCollection = new SalaraitCmpItemPropsCollection();
        }
        return this.itemsCollection;
    }

    public SalariatSchemeInfo getSchmInfo() {
        return this.schmInfo;
    }

    public void setSchmInfo(SalariatSchemeInfo info) {
        this.schmInfo = info;
    }

    public String getStr(String n) {
        return EASResource.getString((String)RESOURCE_PATH, (String)n);
    }

    private void setControlState() {
        if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState())) {
            this.allItemList.setEnabled(true);
            this.selectItemList.setEnabled(true);
            this.btnMoveAllLeft.setEnabled(true);
            this.btnMoveAllRight.setEnabled(true);
            this.btnMoveBottom.setEnabled(true);
            this.btnMoveLeft.setEnabled(true);
            this.btnMoveRight.setEnabled(true);
            this.btnMoveTop.setEnabled(true);
            this.btnUpgrade.setEnabled(true);
            this.btnDegrade.setEnabled(true);
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.allItemList.setEnabled(false);
            this.selectItemList.setEnabled(false);
            this.btnMoveAllLeft.setEnabled(false);
            this.btnMoveAllRight.setEnabled(false);
            this.btnMoveBottom.setEnabled(false);
            this.btnMoveLeft.setEnabled(false);
            this.btnMoveRight.setEnabled(false);
            this.btnMoveTop.setEnabled(false);
            this.btnUpgrade.setEnabled(false);
            this.btnDegrade.setEnabled(false);
        }
    }

    private void initOperateState() {
        this.kdComboCatalog.removeAllItems();
        this.selectItemMap.clear();
        this.selectItemListModel.removeAllElements();
        this.allItemMap.clear();
        this.allItemListModel.removeAllElements();
        this.oldCatalogID = null;
        this.isSelectChange = false;
        this.currSelectIndex = -1;
    }

    public void onLoad() throws Exception {
        this.initOperateState();
        this.constructSelectCmpItemsMap();
        this.constructAllCmpItemsMap();
        this.cmpItemCatalogCollection = this.getCmpSchmItemCatalogData();
        this.fillCmpItemCatalogData(this.cmpItemCatalogCollection);
        this.setControlState();
        this.kdComboCatalog.setEnabled(false);
    }

    private CmpItemCatalogCollection getCmpSchmItemCatalogData() throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)PERSONSATALOB_NUMBER, CompareType.NOTEQUALS));
        evi.setFilter(filterInfo);
        return CmpItemCatalogFactory.getRemoteInstance().getCmpItemCatalogCollection(evi);
    }

    private void fillCmpItemCatalogData(CmpItemCatalogCollection cmpItemCatalogCollection) {
        if (cmpItemCatalogCollection == null || cmpItemCatalogCollection.size() <= 0) {
            return;
        }
        this.kdComboCatalog.removeAllItems();
        this.kdComboCatalog.addItem((Object)this.getAllLabelCatalog());
    }

    private CmpItemCatalogInfo getAllLabelCatalog() {
        CmpItemCatalogInfo cataInfo = new CmpItemCatalogInfo();
        cataInfo.setName(this.getStr("ALL_CATALOG"));
        return cataInfo;
    }

    private BaseSelectItemUI.KDSelectListModel getAllItemsModel() {
        BaseSelectItemUI.KDSelectListModel allItemModel = new BaseSelectItemUI.KDSelectListModel();
        Iterator keyItor = this.allItemMap.keySet().iterator();
        while (keyItor.hasNext()) {
            BaseSelectItemUI.KDSelectListModel model = (BaseSelectItemUI.KDSelectListModel)this.allItemMap.get(keyItor.next());
            allItemModel.appendModel(model);
        }
        return allItemModel;
    }

    private BaseSelectItemUI.KDSelectListModel getAllCatalogItemsModel(String catalogID) {
        if (catalogID == null) {
            return null;
        }
        return (BaseSelectItemUI.KDSelectListModel)this.allItemMap.get(catalogID);
    }

    private BaseSelectItemUI.KDSelectListModel getSelectItemsModel() {
        BaseSelectItemUI.KDSelectListModel selectItemModel = new BaseSelectItemUI.KDSelectListModel();
        Iterator keyItor = this.selectItemMap.keySet().iterator();
        while (keyItor.hasNext()) {
            BaseSelectItemUI.KDSelectListModel model = (BaseSelectItemUI.KDSelectListModel)this.selectItemMap.get(keyItor.next());
            selectItemModel.appendModel(model);
        }
        return selectItemModel;
    }

    private BaseSelectItemUI.KDSelectListModel getSelectCatalogItemsModel(String catalogID) {
        if (catalogID == null) {
            return null;
        }
        return (BaseSelectItemUI.KDSelectListModel)this.selectItemMap.get(catalogID);
    }

    private void constructAllCmpItemsMap() throws Exception {
        MetaDataPK queryAllPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.CmpItemQuery");
        IQueryExecutor execAll = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryAllPK);
        EntityViewInfo entityViewAll = new EntityViewInfo();
        FilterInfo filterInfoItemAll = new FilterInfo();
        filterInfoItemAll.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filterInfoItemAll.getFilterItems().add(new FilterItemInfo("dataType", (Object)60));
        filterInfoItemAll.getFilterItems().add(new FilterItemInfo("type", (Object)10));
        filterInfoItemAll.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
        filterInfoItemAll.getFilterItems().add(new FilterItemInfo("cmpItemCatalog.number", (Object)PERSONSATALOB_NUMBER, CompareType.NOTEQUALS));
        filterInfoItemAll.setMaskString("#0 AND #1 AND #2 AND #3 AND #4 ");
        entityViewAll.setFilter(filterInfoItemAll);
        SorterItemCollection sortCollection = entityViewAll.getSorter();
        sortCollection.add(new SorterItemInfo("cmpItemCatalog.number"));
        execAll.setObjectView(entityViewAll);
        IRowSet rowSet = null;
        try {
            rowSet = execAll.executeQuery();
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
        }
        String catalogID = "";
        BaseSelectItemUI.KDSelectListModel mapListModel = null;
        if (rowSet != null) {
            while (rowSet.next()) {
                CmpItemInfo cmpItem = new CmpItemInfo();
                String id = rowSet.getString("id");
                cmpItem.setId(BOSUuid.read((String)id));
                cmpItem.setNumber(rowSet.getString("number"));
                cmpItem.setName(rowSet.getString("name"));
                catalogID = rowSet.getString("cmpItemCatalog.id");
                CmpItemCatalogInfo catalogInfo = new CmpItemCatalogInfo();
                catalogInfo.setId(BOSUuid.read((String)catalogID));
                cmpItem.setCmpItemCatalog(catalogInfo);
                if (HRSchemeUtils.isNecessaryRemoveCmpItem(cmpItem)) continue;
                if (this.allItemMap.get(catalogID) == null) {
                    mapListModel = new BaseSelectItemUI.KDSelectListModel();
                    this.allItemMap.put(catalogID, mapListModel);
                } else {
                    mapListModel = (BaseSelectItemUI.KDSelectListModel)this.allItemMap.get(catalogID);
                }
                BaseSelectItemData selectItem = new BaseSelectItemData(cmpItem);
                mapListModel.addElement(selectItem);
            }
        }
    }

    private void constructSelectCmpItemsMap() throws Exception {
        if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) {
            if (this.getSchmInfo() == null) {
                this.handleException((Exception)((Object)new SalariatException(SalariatException.MISS_SCHEMEINFO)));
                return;
            }
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.SalSchCmpItemsQuery");
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
            EntityViewInfo entityView = new EntityViewInfo();
            FilterInfo filterInfoItem = new FilterInfo();
            filterInfoItem.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)this.getSchmInfo().getId().toString()));
            String cmpItemids = HRUtils.getCmpItemIds(null);
            if (cmpItemids != null && cmpItemids.length() > 0) {
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("item.id", (Object)cmpItemids, CompareType.INNER));
                filterInfoItem.mergeFilter(fi, "and");
            }
            entityView.setFilter(filterInfoItem);
            exec.setObjectView(entityView);
            IRowSet selectItemRowSet = exec.executeQuery();
            String catalogID = "";
            BaseSelectItemUI.KDSelectListModel mapListModel = null;
            while (selectItemRowSet.next()) {
                CmpItemInfo cmpItem = new CmpItemInfo();
                cmpItem.setId(BOSUuid.read((String)selectItemRowSet.getString("item.id")));
                cmpItem.setNumber(selectItemRowSet.getString("item.number"));
                cmpItem.setName(selectItemRowSet.getString("item.name"));
                catalogID = selectItemRowSet.getString("cmpItemCatalog.id");
                CmpItemCatalogInfo catalogInfo = new CmpItemCatalogInfo();
                catalogInfo.setId(BOSUuid.read((String)catalogID));
                cmpItem.setCmpItemCatalog(catalogInfo);
                if (this.selectItemMap.get(catalogID) == null) {
                    mapListModel = new BaseSelectItemUI.KDSelectListModel();
                    this.selectItemMap.put(catalogID, mapListModel);
                } else {
                    mapListModel = (BaseSelectItemUI.KDSelectListModel)this.selectItemMap.get(catalogID);
                }
                BaseSelectItemData selectItem = new BaseSelectItemData(cmpItem);
                mapListModel.addElement(selectItem);
            }
        }
    }

    public void disableEdit() {
        this.allItemList.setEnabled(false);
        this.selectItemList.setEnabled(false);
        this.btnMoveAllLeft.setEnabled(false);
        this.btnMoveAllRight.setEnabled(false);
        this.btnMoveBottom.setEnabled(false);
        this.btnMoveLeft.setEnabled(false);
        this.btnMoveRight.setEnabled(false);
        this.btnMoveTop.setEnabled(false);
        this.btnUpgrade.setEnabled(false);
        this.btnDegrade.setEnabled(false);
    }

    private void reconstructMapByModel() {
        String catalogID;
        CmpItemCatalogInfo catalogInfo;
        CmpItemInfo cmpItem;
        BaseSelectItemData listItem;
        int i;
        this.allItemMap = new HashMap(this.allItemListModel.size());
        BaseSelectItemUI.KDSelectListModel mapListModel = null;
        for (i = 0; i < this.allItemListModel.size(); ++i) {
            listItem = (BaseSelectItemData)this.allItemListModel.get(i);
            cmpItem = (CmpItemInfo)listItem.getDataObject();
            catalogInfo = cmpItem.getCmpItemCatalog();
            catalogID = catalogInfo.getId().toString();
            if (this.allItemMap.get(catalogID) == null) {
                mapListModel = new BaseSelectItemUI.KDSelectListModel();
                this.allItemMap.put(catalogID, mapListModel);
            } else {
                mapListModel = (BaseSelectItemUI.KDSelectListModel)this.allItemMap.get(catalogID);
            }
            mapListModel.addElement(listItem);
        }
        this.selectItemMap = new HashMap(this.selectItemListModel.size());
        for (i = 0; i < this.selectItemListModel.size(); ++i) {
            listItem = (BaseSelectItemData)this.selectItemListModel.get(i);
            cmpItem = (CmpItemInfo)listItem.getDataObject();
            catalogInfo = cmpItem.getCmpItemCatalog();
            catalogID = catalogInfo.getId().toString();
            if (this.selectItemMap.get(catalogID) == null) {
                mapListModel = new BaseSelectItemUI.KDSelectListModel();
                this.selectItemMap.put(catalogID, mapListModel);
            } else {
                mapListModel = (BaseSelectItemUI.KDSelectListModel)this.selectItemMap.get(catalogID);
            }
            mapListModel.addElement(listItem);
        }
    }

    @Override
    protected void kdComboCatalog_itemStateChanged(ItemEvent e) throws Exception {
        super.kdComboCatalog_itemStateChanged(e);
        int state = e.getStateChange();
        if (state == 1) {
            if (this.kdComboCatalog.getSelectedIndex() < 0) {
                return;
            }
            this.currSelectIndex = this.kdComboCatalog.getSelectedIndex();
            CmpItemCatalogInfo catalogItem = (CmpItemCatalogInfo)this.kdComboCatalog.getSelectedItem();
            BOSUuid id = catalogItem.getId();
            if (this.isSelectChange) {
                if (this.oldCatalogID != null) {
                    this.allItemMap.put(this.oldCatalogID.toString(), this.allItemListModel);
                    this.selectItemMap.put(this.oldCatalogID.toString(), this.selectItemListModel);
                } else {
                    this.reconstructMapByModel();
                }
            } else {
                this.isSelectChange = true;
            }
            this.oldCatalogID = id;
            BaseSelectItemUI.KDSelectListModel selectLeftModel = null;
            BaseSelectItemUI.KDSelectListModel selectRightModel = null;
            if (id == null) {
                selectRightModel = this.getSelectItemsModel();
                selectLeftModel = this.getAllItemsModel();
            } else {
                selectRightModel = this.getSelectCatalogItemsModel(id.toString());
                selectLeftModel = this.getAllCatalogItemsModel(id.toString());
            }
            if (selectLeftModel != null && selectRightModel != null) {
                selectLeftModel.mutexModel(selectRightModel);
            }
            if (selectLeftModel == null) {
                selectLeftModel = new BaseSelectItemUI.KDSelectListModel();
            }
            this.allItemListModel = selectLeftModel;
            this.allItemList.setModel((ListModel)this.allItemListModel);
            if (selectRightModel == null) {
                selectRightModel = new BaseSelectItemUI.KDSelectListModel();
            }
            this.selectItemListModel = selectRightModel;
            this.selectItemList.setModel((ListModel)this.selectItemListModel);
        }
    }
}

