/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.compensation.CmpItemCatalogCollection;
import com.kingdee.eas.hr.compensation.CmpItemCatalogFactory;
import com.kingdee.eas.hr.compensation.CmpItemCatalogInfo;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeItemInfo;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.ICmpSchemeItem;
import com.kingdee.eas.hr.compensation.client.AbstractSalarySlipFilterUI;
import com.kingdee.eas.hr.compensation.client.CmpItemFilterUI;
import com.kingdee.eas.hr.compensation.client.CmpItemFilterUtil;
import com.kingdee.eas.hr.compensation.client.CmpItemUtil;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRCommonQueryUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.perf.client.FilterUIUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class SalarySlipFilterUI
extends AbstractSalarySlipFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(SalarySlipFilterUI.class);
    private String cmpSchemeF7URL = "com.kingdee.eas.hr.compensation.app.F7CmpSchemeQuery";
    private String cmpPeriodF7URL = "com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery";
    private String empSumResource = "com.kingdee.eas.hr.compensation.client.EmpSumReportResource.";
    private ICmpScheme iCmpSchemeIts = null;
    private ICmpSchemeItem iCmpSchemeItemIts = null;
    protected boolean isShowDelete = false;
    private boolean cmpSchInitStateFlag = true;
    private HROrgUnitInfo hrOrgUnitInfo = null;
    protected CmpItemCollection colCmpItem = null;
    private final String CMBCATALOG_CP = "cmbCatalog";
    private final String ALLLISTITEM_CP = "allListItem";
    private final String LSTSELECTITEM_CP = "lstSelectItem";
    protected CmpItemCollection colNecessaryCmpItem = new CmpItemCollection();
    protected CmpItemFilterUI cmpItemFilterUI = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private HROrgUnitInfo getHROrgUnit() {
        if (this.hrOrgUnitInfo == null) {
            this.hrOrgUnitInfo = HRSchemeUtils.getClientHROrgUnitInfo();
        }
        return this.hrOrgUnitInfo;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnMoveTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnMovePre.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveNext.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.btnAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
    }

    protected void fillCmpItemCatalogData() throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        evi.setFilter(filterInfo);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("longnumber"));
        evi.setSorter(sort);
        CmpItemCatalogCollection colCmpItemCatalog = CmpItemCatalogFactory.getRemoteInstance().getCmpItemCatalogCollection(evi);
        if (colCmpItemCatalog == null || colCmpItemCatalog.size() <= 0) {
            return;
        }
        Iterator itr = colCmpItemCatalog.iterator();
        CmpItemCatalogInfo cmpItemCatalogInfo = null;
        this.cmbItemCatalog.removeAllItems();
        while (itr.hasNext()) {
            cmpItemCatalogInfo = (CmpItemCatalogInfo)itr.next();
            this.cmbItemCatalog.addItem((Object)cmpItemCatalogInfo);
        }
    }

    protected void initListener() {
        super.initListener();
        this.cmbItemCatalog.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                int state = ie.getStateChange();
                if (state == 1) {
                    try {
                        SalarySlipFilterUI.this.onLoadAllList();
                        SalarySlipFilterUI.this.lstAllItem.requestFocus();
                    }
                    catch (BOSException e) {
                        SalarySlipFilterUI.this.handUIException(e);
                    }
                }
            }
        });
        this.prmtCmpScheme.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                try {
                    Object obj = SalarySlipFilterUI.this.prmtCmpScheme.getData();
                    SalarySlipFilterUI.this.lstAllItem.removeAllElements();
                    SalarySlipFilterUI.this.lstSelectItem.removeAllElements();
                    if (obj == null) {
                        SalarySlipFilterUI.this.cmbItemCatalog.removeAllItems();
                        return;
                    }
                    SalarySlipFilterUI.this.getCmpItemCollection((CmpSchemeInfo)obj);
                    SalarySlipFilterUI.this.fillCmpItemCatalogData();
                    CmpPeriodInfo periodInfo = (CmpPeriodInfo)SalarySlipFilterUI.this.prmtBeginCmpPeriod.getData();
                    SalarySlipFilterUI.this.initComboBoxTime(periodInfo);
                }
                catch (Exception exc) {
                    SalarySlipFilterUI.this.handUIException(exc);
                }
            }
        });
        this.prmtBeginCmpPeriod.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                CmpPeriodInfo periodInfo = (CmpPeriodInfo)SalarySlipFilterUI.this.prmtBeginCmpPeriod.getData();
                try {
                    SalarySlipFilterUI.this.initComboBoxTime(periodInfo);
                }
                catch (Exception exc) {
                    SalarySlipFilterUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void initComboBoxTime(CmpPeriodInfo periodInfo) throws Exception {
        CmpSchemeInfo cmpSchemeInfo = (CmpSchemeInfo)this.prmtCmpScheme.getData();
        this.cmbTime.removeAllItems();
        int maxTime = 1;
        if (cmpSchemeInfo != null && periodInfo != null) {
            try {
                String schemeID = cmpSchemeInfo.getId().toString();
                maxTime = CmpSchemeFactory.getRemoteInstance().getMaxTimeFromScheme(schemeID, periodInfo.getId().toString());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        if (maxTime == 0) {
            maxTime = 1;
        }
        DefaultComboBoxModel<Integer> model = new DefaultComboBoxModel<Integer>();
        for (int i = 1; i <= maxTime; ++i) {
            model.addElement(i);
        }
        this.cmbTime.setModel(model);
        this.cmbTime.setSelectedIndex(0);
    }

    protected void onLoadAllList() throws BOSException {
        CmpItemCatalogInfo infoCmpItemCatalog = (CmpItemCatalogInfo)this.cmbItemCatalog.getSelectedItem();
        if (infoCmpItemCatalog == null || this.colCmpItem == null) {
            return;
        }
        this.lstAllItem.removeAllElements();
        Iterator itrCmpItem = this.colCmpItem.iterator();
        CmpItemInfo infoCmpItem = null;
        CmpItemCatalogInfo infoTemp = null;
        while (itrCmpItem.hasNext()) {
            infoCmpItem = (CmpItemInfo)itrCmpItem.next();
            infoTemp = infoCmpItem.getCmpItemCatalog();
            if (infoTemp == null || !infoTemp.getId().toString().equals(infoCmpItemCatalog.getId().toString())) continue;
            boolean isSame = false;
            CmpItemInfo infoTempCmpItem = null;
            int count = this.lstSelectItem.getElementCount();
            for (int i = 0; i < count; ++i) {
                infoTempCmpItem = (CmpItemInfo)this.lstSelectItem.getElement(i);
                if (!infoTempCmpItem.getId().toString().equals(infoCmpItem.getId().toString())) continue;
                isSame = true;
            }
            if (isSame) continue;
            this.lstAllItem.addElement((Object)infoCmpItem);
        }
        if (this.lstAllItem.getElementCount() > 0) {
            this.lstAllItem.setSelectedIndex(0);
        }
        CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.getCmpItemFilterItem(this.lstSelectItem));
    }

    protected CmpItemCollection getCmpItemCollection(CmpSchemeInfo cmpSchemeInfo) throws Exception {
        CmpItemCollection cmpItemColl;
        this.colCmpItem = cmpItemColl = CmpItemUtil.getCmpItemOfSchemeBySchme(cmpSchemeInfo);
        this.getColNecessaryCmpItem();
        return cmpItemColl;
    }

    public void getColNecessaryCmpItem() {
        if (this.colCmpItem == null) {
            return;
        }
        this.colNecessaryCmpItem = new CmpItemCollection();
        Iterator itr = this.colCmpItem.iterator();
        CmpItemInfo info = null;
        while (itr.hasNext()) {
            info = (CmpItemInfo)itr.next();
            if (!this.isNecessaryCmpItem(info)) continue;
            this.colNecessaryCmpItem.add(info);
        }
        this.initLstSelectItem();
    }

    protected void initLstSelectItem() {
        Iterator itr = this.colNecessaryCmpItem.iterator();
        CmpItemInfo infoCmpItem = null;
        CmpSchemeItemInfo info = null;
        while (itr.hasNext()) {
            infoCmpItem = (CmpItemInfo)itr.next();
            info = new CmpSchemeItemInfo();
            info.setCmpItem(infoCmpItem);
            this.lstSelectItem.addElement((Object)infoCmpItem);
        }
    }

    protected boolean isNecessaryCmpItem(CmpItemInfo info) {
        String number = info.getNumber();
        return number.equalsIgnoreCase("FPER001") || number.equalsIgnoreCase("FPER002");
    }

    private CmpItemCollection getCmpItemOfSchemeBySchme(CmpSchemeInfo cmpSchemeInfo) throws Exception {
        ICmpSchemeItem iCmpSchemeItem = CmpSchemeItemFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)cmpSchemeInfo.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.enable", (Object)0, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isDelete", (Object)0));
        filterInfo.setMaskString("#0 and #1 and #2 and #3");
        evi.setFilter(filterInfo);
        SorterItemInfo sorterOrderItem = new SorterItemInfo("sortOrder");
        sorterOrderItem.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterOrderItem);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("cmpItem.id"));
        sic.add(new SelectorItemInfo("cmpItem.number"));
        sic.add(new SelectorItemInfo("cmpItem.name"));
        sic.add(new SelectorItemInfo("cmpItem.dataType"));
        sic.add(new SelectorItemInfo("cmpItem.decDigital"));
        sic.add(new SelectorItemInfo("cmpItem.cmpItemCatalog.number"));
        sic.add(new SelectorItemInfo("cmpItem.hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("cmpScheme.id"));
        CmpSchemeItemCollection cmpSchemeItemColl = iCmpSchemeItem.getCmpSchemeItemCollection(evi);
        CmpItemCollection cmpItemColl = new CmpItemCollection();
        CmpSchemeItemInfo cmpSchemeItemTemp = null;
        int j = cmpSchemeItemColl.size();
        for (int i = 0; i < j; ++i) {
            cmpSchemeItemTemp = cmpSchemeItemColl.get(i);
            cmpItemColl.add(cmpSchemeItemTemp.getCmpItem());
        }
        return cmpItemColl;
    }

    protected ICmpSchemeItem getSchemeItemBizInteface() throws BOSException {
        if (this.iCmpSchemeIts == null) {
            return CmpSchemeItemFactory.getRemoteInstance();
        }
        return this.iCmpSchemeItemIts;
    }

    private void initAllEditor() throws ParserException, BOSException {
        this.prmtCmpScheme.setQueryInfo(this.cmpSchemeF7URL);
        this.prmtCmpScheme.setEditable(false);
        this.prmtCmpScheme.setEditFormat("$name$");
        this.prmtCmpScheme.setDisplayFormat("$name$");
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("cmpPeriod.*"));
        this.prmtCmpScheme.setSelectorCollection(sic);
        FilterInfo filterInfoCmpSch = new FilterInfo();
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.getHROrgUnit().getId().toString()));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("enable", (Object)3));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("isDelete", (Object)"0"));
        filterInfoCmpSch.setMaskString("#0 and (#1 or #2) and #3");
        FilterInfo adminRangeFilter = HRSchemeUtils.getAdminRangeFilter(null, "adminUser.id");
        if (adminRangeFilter != null) {
            filterInfoCmpSch.mergeFilter(adminRangeFilter, "and");
        }
        evi.setFilter(filterInfoCmpSch);
        this.prmtCmpScheme.setEntityViewInfo(evi);
        this.prmtCmpScheme.setEnabled(this.cmpSchInitStateFlag);
        this.prmtBeginCmpPeriod.setQueryInfo(this.cmpPeriodF7URL);
        this.prmtBeginCmpPeriod.setEditable(false);
        this.prmtBeginCmpPeriod.setEditFormat("$name$");
        this.prmtBeginCmpPeriod.setDisplayFormat("$name$");
        EntityViewInfo eviCmpPeriod = new EntityViewInfo();
        FilterInfo filterInfoCmpPeriod = new FilterInfo();
        filterInfoCmpPeriod.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.getHROrgUnit().getId().toString()));
        eviCmpPeriod.setFilter(filterInfoCmpPeriod);
        this.prmtBeginCmpPeriod.setEntityViewInfo(eviCmpPeriod);
        this.prmtEndCmpPeriod.setQueryInfo(this.cmpPeriodF7URL);
        this.prmtEndCmpPeriod.setEditable(false);
        this.prmtEndCmpPeriod.setEditFormat("$name$");
        this.prmtEndCmpPeriod.setDisplayFormat("$name$");
        this.prmtEndCmpPeriod.setEntityViewInfo(eviCmpPeriod);
        CompUtils.initF7SelectorNoHR(this, this.prmtAdminOrgUnit);
        this.prmtAdminOrgUnit.setEditable(false);
        CompUtils.initF7ForMutilSelectOrg(this.prmtAdminMulOrgUnit, false);
        this.btnSingleOrg.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (SalarySlipFilterUI.this.btnSingleOrg.isSelected()) {
                    SalarySlipFilterUI.this.setAdminPrmtState(true);
                    SalarySlipFilterUI.this.prmtAdminMulOrgUnit.setData(null);
                    SalarySlipFilterUI.this.chkIncludeSubDept.setEnabled(true);
                } else {
                    SalarySlipFilterUI.this.setAdminPrmtState(false);
                    SalarySlipFilterUI.this.prmtAdminOrgUnit.setData(null);
                    SalarySlipFilterUI.this.chkIncludeSubDept.setEnabled(false);
                    SalarySlipFilterUI.this.chkIncludeSubDept.setSelected(false);
                }
            }
        });
        this.btnSingleOrg.setSelected(true);
    }

    private void setAdminPrmtState(boolean isSingleSelect) {
        this.prmtAdminOrgUnit.setEnabled(isSingleSelect);
        this.prmtAdminMulOrgUnit.setEnabled(!isSingleSelect);
    }

    public FilterInfo getFilterInfoFromUI() throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        boolean isShowSealUp = this.chkShowSealUp.isSelected();
        if (this.btnSingleOrg.isSelected() && this.prmtAdminOrgUnit.getData() != null) {
            AdminOrgUnitInfo adminOrgUnit = (AdminOrgUnitInfo)this.prmtAdminOrgUnit.getData();
            if (this.chkIncludeSubDept.isSelected()) {
                filterInfo.getFilterItems().add(new FilterItemInfo("attachDept.longNumber", (Object)(adminOrgUnit.getLongNumber() + "!%"), CompareType.LIKE));
                filterInfo.getFilterItems().add(new FilterItemInfo("attachDept.longNumber", (Object)adminOrgUnit.getLongNumber(), CompareType.LIKE));
                if (!isShowSealUp) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("attachDept.isSealUp", (Object)0));
                    filterInfo.setMaskString("(#0 or #1) and #2");
                } else {
                    filterInfo.setMaskString("#0 or #1");
                }
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("attachDept.longNumber", (Object)adminOrgUnit.getLongNumber()));
                if (!isShowSealUp) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("attachDept.isSealUp", (Object)0));
                }
            }
        } else if (this.btnMulOrg.isSelected() && this.prmtAdminMulOrgUnit.getData() != null) {
            Object[] obj;
            HashSet<String> set = new HashSet<String>();
            Object object = this.prmtAdminMulOrgUnit.getData();
            AdminOrgUnitInfo adminInfo = null;
            AdminOrgUnitInfo newAdminInfo = null;
            IAdminOrgUnit iadmin = AdminOrgUnitFactory.getRemoteInstance();
            if (object instanceof DataBaseInfo) {
                obj = this.prmtAdminMulOrgUnit.getData();
                set.add(((AdminOrgUnitInfo)obj).getLongNumber());
            }
            if (object instanceof Object[]) {
                obj = (Object[])this.prmtAdminMulOrgUnit.getData();
                int length = obj.length;
                for (int i = 0; i < length; ++i) {
                    adminInfo = (AdminOrgUnitInfo)obj[i];
                    if (isShowSealUp) {
                        set.add(adminInfo.getId().toString());
                        continue;
                    }
                    newAdminInfo = iadmin.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminInfo.getId().toString()));
                    if (newAdminInfo.isIsSealUp()) continue;
                    set.add(adminInfo.getId().toString());
                }
                if (set.size() == 0) {
                    set.add("''");
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("attachDept.id", set, CompareType.INCLUDE));
            }
        } else if (!isShowSealUp) {
            filterInfo.getFilterItems().add(new FilterItemInfo("attachDept.isSealUp", (Object)0));
        }
        return filterInfo;
    }

    public CmpSchemeInfo getSelectedCmpScheme() {
        CmpSchemeInfo cmpSchemeInfo = null;
        cmpSchemeInfo = this.prmtCmpScheme.getData() != null ? (CmpSchemeInfo)this.prmtCmpScheme.getData() : null;
        return cmpSchemeInfo;
    }

    public List getListSelectItem() {
        ArrayList<CmpItemInfo> listSelectList = new ArrayList<CmpItemInfo>();
        int countListSelectItem = this.lstSelectItem.getElementCount();
        if (countListSelectItem > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < countListSelectItem; ++i) {
                info = (CmpItemInfo)this.lstSelectItem.getElement(i);
                listSelectList.add(i, info);
            }
        }
        return listSelectList;
    }

    public CmpPeriodInfo getSelectedBeginCmpPeriod() {
        CmpPeriodInfo cmpPeriodInfo = null;
        cmpPeriodInfo = this.prmtBeginCmpPeriod.getData() != null ? (CmpPeriodInfo)this.prmtBeginCmpPeriod.getData() : null;
        return cmpPeriodInfo;
    }

    public boolean getPrintByOrg() {
        return this.chkPrintByOrg.isSelected();
    }

    public boolean getShowAll() {
        return this.chkShowALL.isSelected();
    }

    public Integer getCmpBeginTimes() {
        if (this.cmbTime.getSelectedItem() != null) {
            return (Integer)this.cmbTime.getSelectedItem();
        }
        return 1;
    }

    public CmpPeriodInfo getSelectedEndCmpPeriod() {
        CmpPeriodInfo cmpPeriodInfo = null;
        if (this.prmtBeginCmpPeriod.getData() != null) {
            cmpPeriodInfo = (CmpPeriodInfo)this.prmtBeginCmpPeriod.getData();
        }
        return cmpPeriodInfo;
    }

    public CustomerParams getCustomerParams() {
        FilterInfo filter;
        CustomerParams cp = new CustomerParams();
        if (this.prmtBeginCmpPeriod.getData() != null) {
            cp.addCustomerParam("prmtBeginCmpPeriod", ((CmpPeriodInfo)this.prmtBeginCmpPeriod.getData()).getId().toString());
        }
        if (this.prmtCmpScheme.getData() != null) {
            cp.addCustomerParam("prmtCmpScheme", ((CmpSchemeInfo)this.prmtCmpScheme.getData()).getId().toString());
        }
        if (this.btnSingleOrg.isSelected() && this.prmtAdminOrgUnit.getData() != null) {
            cp.addCustomerParam("prmtAdminOrgUnit", ((AdminOrgUnitInfo)this.prmtAdminOrgUnit.getData()).getId().toString());
        }
        if (this.btnMulOrg.isSelected() && this.prmtAdminMulOrgUnit.getData() != null) {
            FilterUIUtil.saveData((CustomerParams)cp, (Component)this.prmtAdminMulOrgUnit);
        }
        cp.putBoolean("btnMulOrg", this.btnMulOrg.isSelected());
        cp.putBoolean("isSub", this.chkIncludeSubDept.isSelected());
        cp.putBoolean("chkShowALL", this.chkShowALL.isSelected());
        cp.putBoolean("chkZeroItemDisplayNull", this.chkZeroItemDisplayNull.isSelected());
        cp.addCustomerParam(this.CMBCATALOG_CP, this.cmpItemCataLogStr());
        cp.addCustomerParam(this.ALLLISTITEM_CP, this.allListStr());
        cp.addCustomerParam(this.LSTSELECTITEM_CP, this.selectListStr());
        cp.putBoolean("ISPrintByOrg", this.chkPrintByOrg.isSelected());
        cp.putBoolean("chkShowSealUp", this.chkShowSealUp.isSelected());
        if (this.cmbTime.getSelectedItem() != null) {
            cp.addCustomerParam("cmbTime", ((Integer)this.cmbTime.getSelectedItem()).toString());
        }
        if (this.cmpItemFilterUI != null && (filter = this.cmpItemFilterUI.getCondition()) != null) {
            cp.addCustomerParam("CmpItemFilter", filter.toString());
        }
        return cp;
    }

    private String cmpItemCataLogStr() {
        int controlInt = 0;
        StringBuffer cmbStrArrayStr = new StringBuffer();
        int cmbSize = this.cmbItemCatalog.getItemCount();
        controlInt = cmbSize - 1;
        for (int i = 0; i < cmbSize; ++i) {
            CmpItemCatalogInfo cmpcatalogInfo = (CmpItemCatalogInfo)this.cmbItemCatalog.getItemAt(i);
            cmbStrArrayStr.append(cmpcatalogInfo.getId().toString());
            if (i == controlInt) continue;
            cmbStrArrayStr.append("~");
        }
        return cmbStrArrayStr.toString();
    }

    private String allListStr() {
        StringBuffer allListArray = new StringBuffer();
        int allListItemSize = this.lstAllItem.getElementCount();
        int controlInt = allListItemSize - 1;
        for (int i = 0; i < allListItemSize; ++i) {
            CmpItemInfo cmpItemInfo = (CmpItemInfo)this.lstAllItem.getElement(i);
            allListArray.append(cmpItemInfo.getId().toString());
            if (i == controlInt) continue;
            allListArray.append("~");
        }
        return allListArray.toString();
    }

    private String selectListStr() {
        ArrayList<Object> lstSelectItemData = new ArrayList<Object>();
        int size = this.lstSelectItem.getElementCount();
        for (int i = 0; i < size; ++i) {
            lstSelectItemData.add(this.lstSelectItem.getElement(i));
        }
        return HRCommonQueryUtils.getSelectedItemIDS(lstSelectItemData);
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        this.clear();
        try {
            String filterStr;
            ObjectUuidPK pkTemp = new ObjectUuidPK();
            if (cp.getCustomerParam("prmtBeginCmpPeriod") != null) {
                pkTemp = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("prmtBeginCmpPeriod")));
                this.prmtBeginCmpPeriod.setData((Object)((CmpPeriodInfo)CmpPeriodFactory.getRemoteInstance().getValue((IObjectPK)pkTemp)));
            }
            if (cp.getCustomerParam("prmtCmpScheme") != null) {
                pkTemp = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("prmtCmpScheme")));
                try {
                    this.prmtCmpScheme.setData((Object)((CmpSchemeInfo)CmpSchemeFactory.getRemoteInstance().getValue((IObjectPK)pkTemp)));
                }
                catch (Exception e) {
                    this.prmtCmpScheme.setData(null);
                    SysUtil.abort();
                }
            }
            if (cp.getCustomerParam("prmtAdminOrgUnit") != null) {
                this.btnSingleOrg.setSelected(true);
                pkTemp = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("prmtAdminOrgUnit")));
                this.prmtAdminOrgUnit.setData((Object)((AdminOrgUnitInfo)AdminOrgUnitFactory.getRemoteInstance().getValue((IObjectPK)pkTemp)));
            }
            this.btnMulOrg.setSelected(cp.getBoolean("btnMulOrg"));
            this.chkIncludeSubDept.setSelected(cp.getBoolean("isSub"));
            this.chkPrintByOrg.setSelected(cp.getBoolean("ISPrintByOrg"));
            this.chkShowALL.setSelected(cp.getBoolean("chkShowALL"));
            this.chkShowSealUp.setSelected(cp.getBoolean("chkShowSealUp"));
            this.chkZeroItemDisplayNull.setSelected(cp.getBoolean("chkZeroItemDisplayNull"));
            String catalogStr = cp.getCustomerParam(this.CMBCATALOG_CP);
            this.setCmpItemCataLog(catalogStr);
            String allListStr = cp.getCustomerParam(this.ALLLISTITEM_CP);
            this.setAllItem(allListStr);
            String ids = cp.getCustomerParam(this.LSTSELECTITEM_CP);
            this.setLstSelectItem(ids);
            this.initComboBoxTime((CmpPeriodInfo)this.prmtBeginCmpPeriod.getData());
            if (cp.getCustomerParam("cmbTime") != null) {
                int selectTimes = Integer.valueOf(cp.getCustomerParam("cmbTime"));
                this.cmbTime.setSelectedIndex(selectTimes - 1);
            }
            CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.getCmpItemFilterItem(this.lstSelectItem));
            if (this.cmpItemFilterUI != null && !StringUtils.isEmpty((String)(filterStr = cp.getCustomerParam("CmpItemFilter")))) {
                this.cmpItemFilterUI.loadFilterInfo(new FilterInfo(filterStr));
            }
            if (cp.getCustomerParam("multi" + this.prmtAdminMulOrgUnit.getName()) != null) {
                this.btnMulOrg.setSelected(true);
                FilterUIUtil.retriveData((CustomerParams)cp, (Component)this.prmtAdminMulOrgUnit);
            }
        }
        catch (Exception e) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"236_CmpReportFilterBaseUI"));
            SysUtil.abort();
        }
    }

    private void setCmpItemCataLog(String catalogStr) {
        this.cmbItemCatalog.removeAllItems();
        if (catalogStr == null || "".equals(catalogStr)) {
            return;
        }
        String[] catalogArray = catalogStr.split("~");
        int arrayInt = catalogArray.length;
        HashSet<String> keySet = new HashSet<String>();
        for (int i = 0; i < arrayInt; ++i) {
            keySet.add(catalogArray[i]);
        }
        EntityViewInfo entityViewInfoTmp = new EntityViewInfo();
        FilterInfo fitlerInfoTmp = new FilterInfo();
        fitlerInfoTmp.getFilterItems().add(new FilterItemInfo("id", keySet, CompareType.INCLUDE));
        entityViewInfoTmp.setFilter(fitlerInfoTmp);
        try {
            CmpItemCatalogCollection catalogColl = CmpItemCatalogFactory.getRemoteInstance().getCmpItemCatalogCollection(entityViewInfoTmp);
            int catalogSize = catalogColl.size();
            for (int i = 0; i < catalogSize; ++i) {
                CmpItemCatalogInfo cmpItemCatalogInfo = catalogColl.get(i);
                this.cmbItemCatalog.addItem((Object)cmpItemCatalogInfo);
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void setAllItem(String allListStr) {
        this.lstAllItem.removeAllElements();
        if (allListStr == null || "".equals(allListStr)) {
            try {
                this.fillCmpItemCatalogData();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            return;
        }
        String[] allListStrArray = allListStr.split("~");
        int arrayInt = allListStrArray.length;
        HashSet<String> keySet = new HashSet<String>();
        for (int i = 0; i < arrayInt; ++i) {
            keySet.add(allListStrArray[i]);
        }
        EntityViewInfo entityViewInfoTmp = new EntityViewInfo();
        FilterInfo fitlerInfoTmp = new FilterInfo();
        fitlerInfoTmp.getFilterItems().add(new FilterItemInfo("id", keySet, CompareType.INCLUDE));
        entityViewInfoTmp.setFilter(fitlerInfoTmp);
        try {
            CmpItemCollection cmpItemColl = CmpItemFactory.getRemoteInstance().getCmpItemCollection(entityViewInfoTmp);
            int catalogSize = cmpItemColl.size();
            for (int i = 0; i < catalogSize; ++i) {
                CmpItemInfo cmpItemInfo = cmpItemColl.get(i);
                this.lstAllItem.addElement((Object)cmpItemInfo);
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void setLstSelectItem(String ids) {
        if (ids != null && !"".equals(ids)) {
            try {
                List lstSelectItemData = HRCommonQueryUtils.getSelectedItemList(ids, "~");
                HRCommonQueryUtils.fillSelectItemList(lstSelectItemData, this.lstSelectItem, this.lstAllItem);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        try {
            this.onLoadAllList();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public void clear() {
        super.clear();
        this.btnSingleOrg.setSelected(true);
        this.prmtAdminOrgUnit.setData(null);
        this.prmtAdminMulOrgUnit.setData(null);
        this.prmtAdminMulOrgUnit.setEnabled(false);
        this.prmtCmpScheme.setData(null);
        this.prmtBeginCmpPeriod.setData(null);
        this.chkIncludeSubDept.setSelected(false);
        this.chkPrintByOrg.setSelected(false);
        this.chkShowALL.setSelected(false);
        this.cmbTime.removeAllItems();
        this.chkShowSealUp.setSelected(false);
        this.chkZeroItemDisplayNull.setSelected(false);
        CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.getCmpItemFilterItem(this.lstSelectItem));
    }

    public boolean verify() {
        if (this.prmtBeginCmpPeriod.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_CMPPER")));
            return false;
        }
        if (this.prmtCmpScheme.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_CMPSCH")));
            return false;
        }
        if (this.lstSelectItem.getElementCount() < 1) {
            MsgBox.showInfo((String)EASResource.getString((String)(this.empSumResource + "MUST_SELECTCMPITEM")));
            return false;
        }
        return true;
    }

    @Override
    protected void chkShowSealUp_itemStateChanged(ItemEvent e) throws Exception {
        CompUtils.initF7SelectorNoHR(this.prmtAdminOrgUnit, this.chkShowSealUp.isSelected());
        AdminByOrgRangePromptBox f7 = new AdminByOrgRangePromptBox();
        f7.setIsSingleSelect(false);
        f7.showChkSealUp(true);
        if (!this.chkShowSealUp.isSelected()) {
            f7.setIncludeSealUp("false");
        } else {
            f7.setIncludeSealUp(null);
        }
        this.prmtAdminMulOrgUnit.setSelector((KDPromptSelector)f7);
        this.prmtAdminMulOrgUnit.setDisplayFormat("$name$");
        this.prmtAdminMulOrgUnit.setEditFormat("$number$");
        this.prmtAdminMulOrgUnit.setCommitFormat("$number$");
        this.prmtAdminMulOrgUnit.setEnabledMultiSelection(true);
        this.prmtAdminMulOrgUnit.setEditable(false);
    }

    @Override
    public void actionRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionRight_actionPerformed(e);
        this.leftToRight();
    }

    @Override
    public void actionAllRight_actionPerformed(ActionEvent e) throws Exception {
        super.actionAllRight_actionPerformed(e);
        this.allLeftToRightItem();
    }

    protected void allLeftToRightItem() {
        int count = this.lstAllItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            int indexSelect = this.lstSelectItem.getSelectedIndex() + 1;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstAllItem.getElement(0);
                this.lstSelectItem.insertElement((Object)info, indexSelect);
                this.lstAllItem.removeElement((Object)info);
                ++indexSelect;
            }
            this.lstSelectItem.setSelectedIndex(0);
        }
        CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.getCmpItemFilterItem(this.lstSelectItem));
    }

    protected void leftToRight() {
        int index = this.lstAllItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstAllItem.getElement(index);
            int indexSelect = this.lstSelectItem.getSelectedIndex() + 1;
            this.lstSelectItem.insertElement((Object)info, indexSelect);
            this.lstAllItem.removeElement((Object)info);
            if (index - 1 > 0) {
                this.lstAllItem.setSelectedIndex(index - 1);
            } else if (this.lstAllItem.getElementCount() > 0) {
                this.lstAllItem.setSelectedIndex(0);
            }
            this.lstSelectItem.setSelectedValue((Object)info, true);
        }
        CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.getCmpItemFilterItem(this.lstSelectItem));
    }

    @Override
    public void actionLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionLeft_actionPerformed(e);
        this.rightToLeft();
    }

    @Override
    public void actionAllLeft_actionPerformed(ActionEvent e) throws Exception {
        super.actionAllLeft_actionPerformed(e);
        this.allRightToLeftItem();
    }

    @Override
    protected void lstAllItem_mouseClicked(MouseEvent e) throws Exception {
        super.lstAllItem_mouseClicked(e);
        if (e.getClickCount() == 2) {
            this.leftToRight();
        }
    }

    @Override
    protected void lstSelectItem_mouseClicked(MouseEvent e) throws Exception {
        super.lstSelectItem_mouseClicked(e);
        if (e.getClickCount() == 2) {
            this.rightToLeft();
        }
    }

    protected void allRightToLeftItem() {
        int count = this.lstSelectItem.getElementCount();
        if (count > 0) {
            CmpItemInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (CmpItemInfo)this.lstSelectItem.getElement(0);
                if (!this.isNecessaryCmpItem(info)) {
                    CmpItemCatalogInfo cmpItemCatalogInfo = (CmpItemCatalogInfo)this.cmbItemCatalog.getSelectedItem();
                    CmpItemCatalogInfo infoCmpItemCatalog = (CmpItemCatalogInfo)this.cmbItemCatalog.getSelectedItem();
                    CmpItemCatalogInfo infoTemp = info.getCmpItemCatalog();
                    if (infoCmpItemCatalog != null && infoTemp.getId().toString().equals(infoCmpItemCatalog.getId().toString())) {
                        this.lstAllItem.addElement((Object)info);
                    }
                }
                this.lstSelectItem.removeElement((Object)info);
            }
            this.initLstSelectItem();
            if (this.lstAllItem.getElementCount() > 0) {
                this.lstAllItem.setSelectedIndex(0);
            }
        }
        CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.getCmpItemFilterItem(this.lstSelectItem));
    }

    protected void rightToLeft() {
        int index = this.lstSelectItem.getSelectedIndex();
        if (index >= 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            if (this.isNecessaryCmpItem(info)) {
                return;
            }
            this.lstSelectItem.removeElement((Object)info);
            if (this.lstSelectItem.getElementCount() > 0) {
                this.lstSelectItem.setSelectedIndex(index - 1);
            }
            CmpItemCatalogInfo infoCmpItemCatalog = (CmpItemCatalogInfo)this.cmbItemCatalog.getSelectedItem();
            CmpItemCatalogInfo infoTemp = info.getCmpItemCatalog();
            if (infoCmpItemCatalog != null && infoTemp.getId().toString().equals(infoCmpItemCatalog.getId().toString())) {
                this.lstAllItem.addElement((Object)info);
                this.lstAllItem.setSelectedIndex(this.lstAllItem.getElementCount() - 1);
            }
        }
        CmpItemFilterUtil.setCmpItemFilterUIQueryInfo(this.cmpItemFilterUI, true, true, this.getCmpItemFilterItem(this.lstSelectItem));
    }

    @Override
    public void actionMoveTop_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveTop_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        if (index > 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, 0);
            this.lstSelectItem.setSelectedIndex(0);
        }
    }

    @Override
    public void actionMovePre_actionPerformed(ActionEvent e) throws Exception {
        super.actionMovePre_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        if (index > 0) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, index - 1);
            this.lstSelectItem.setSelectedIndex(index - 1);
        }
    }

    @Override
    public void actionMoveNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveNext_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        int count = this.lstSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, index + 1);
            this.lstSelectItem.setSelectedIndex(index + 1);
        }
    }

    @Override
    public void actionMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveBottom_actionPerformed(e);
        int index = this.lstSelectItem.getSelectedIndex();
        int count = this.lstSelectItem.getElementCount();
        if (index >= 0 && count != index + 1) {
            CmpItemInfo info = (CmpItemInfo)this.lstSelectItem.getElement(index);
            this.lstSelectItem.removeElementAt(index);
            this.lstSelectItem.insertElement((Object)info, count - 1);
            this.lstSelectItem.setSelectedIndex(count - 1);
        }
    }

    public String getAdminName() throws Exception {
        boolean isShowSealUp = this.chkShowSealUp.isSelected();
        if (this.prmtAdminOrgUnit.getData() != null) {
            AdminOrgUnitInfo adminOrgUnit;
            if (isShowSealUp) {
                AdminOrgUnitInfo adminOrgUnit2 = (AdminOrgUnitInfo)this.prmtAdminOrgUnit.getData();
                return adminOrgUnit2.getName();
            }
            IAdminOrgUnit iadmin = AdminOrgUnitFactory.getRemoteInstance();
            AdminOrgUnitInfo newAdminInfo = iadmin.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK((adminOrgUnit = (AdminOrgUnitInfo)this.prmtAdminOrgUnit.getData()).getId().toString()));
            if (!newAdminInfo.isIsSealUp()) {
                return adminOrgUnit.getName();
            }
            return null;
        }
        return null;
    }

    public String getMulAdminName() throws Exception {
        if (this.prmtAdminMulOrgUnit.getData() != null) {
            boolean isShowSealUp = this.chkShowSealUp.isSelected();
            Object[] adminOrgUnit = (Object[])this.prmtAdminMulOrgUnit.getData();
            StringBuffer buffer = new StringBuffer();
            AdminOrgUnitInfo adminInfo = null;
            AdminOrgUnitInfo newAdminInfo = null;
            IAdminOrgUnit iadmin = AdminOrgUnitFactory.getRemoteInstance();
            for (int i = 0; i < adminOrgUnit.length; ++i) {
                adminInfo = (AdminOrgUnitInfo)adminOrgUnit[i];
                if (isShowSealUp) {
                    buffer.append(adminInfo.getName()).append(";");
                    continue;
                }
                newAdminInfo = iadmin.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminInfo.getId().toString()));
                if (newAdminInfo.isIsSealUp()) continue;
                buffer.append(adminInfo.getName()).append(";");
            }
            if (buffer.length() > 0) {
                return buffer.deleteCharAt(buffer.length() - 1).toString();
            }
            return null;
        }
        return null;
    }

    public CmpItemFilterUI getCmpItemFilterUI() {
        return this.cmpItemFilterUI;
    }

    public void setCmpItemFilterUI(CmpItemFilterUI cmpItemFilterUI) {
        this.cmpItemFilterUI = cmpItemFilterUI;
    }

    private KDList getCmpItemFilterItem(KDList items) {
        KDList kdList = new KDList();
        CmpItemInfo info = null;
        int size = this.lstSelectItem.getElementCount();
        for (int i = 0; i < size; ++i) {
            info = (CmpItemInfo)this.lstSelectItem.getElement(i);
            if ("FSAL000".equals(info.getNumber())) continue;
            kdList.addElement((Object)info);
        }
        return kdList;
    }

    public boolean isZeroItemValueNull() {
        return this.chkZeroItemDisplayNull.isSelected();
    }
}

