/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTTransferAction;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.compensation.ITaxRateList;
import com.kingdee.eas.hr.compensation.ITaxScheme;
import com.kingdee.eas.hr.compensation.TaxRateException;
import com.kingdee.eas.hr.compensation.TaxRateListCollection;
import com.kingdee.eas.hr.compensation.TaxRateListFactory;
import com.kingdee.eas.hr.compensation.TaxRateListInfo;
import com.kingdee.eas.hr.compensation.TaxSchemeException;
import com.kingdee.eas.hr.compensation.TaxSchemeFactory;
import com.kingdee.eas.hr.compensation.client.AbstractTaxRateListEditUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class TaxRateListEditUI
extends AbstractTaxRateListEditUI {
    private static Logger logger = Logger.getLogger(TaxRateListEditUI.class);
    private static final Color FIXCOLUMNCOLOR = new Color(236, 236, 232);
    public static final Color REQUIREDBACKGROUND = UIManager.getColor("TextField.requiredBackground");
    private static final int FIELDOFBEGINPOINT = 1;
    private static final int FIELDOFENDPOINT = 2;
    private static final int FExcludeBeginPoint = 3;
    private static final int FExcludeEndPoint = 4;
    private static final int FIELDOFTAXRATE = 5;
    private static final int FIELDOFSUB = 6;
    private static final int FIELDOFID = 0;
    private static final BigDecimal STRATPOINT = new BigDecimal("0.00");
    private KDFormattedTextField beginEditor = null;
    private KDFormattedTextField endEditor = null;
    private KDFormattedTextField taxEditor = null;
    private KDFormattedTextField subEditor = null;
    private TaxRateListCollection taxCollection = null;
    private IRow curRow = null;
    private BigDecimal nextBeginPoint = null;
    private BigDecimal nextExclude_BeginPoint = null;
    private ITaxRateList iTaxRate = null;
    private static final String COL_BEGINPOINT = "beginPoint";
    private boolean changed = false;
    private int currTableCount = 0;

    public TaxRateListEditUI() throws Exception {
        HRSchemeUtils.checkInit();
        this.initKDTable();
    }

    private void initTitle() {
        String NowUsePeriod = this.GetNowUsePeriod();
        if ("200803".equals(NowUsePeriod)) {
            this.menuItemUp.setText(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.TaxedRateEditUIResource.UP"));
        } else if ("201109".equals(NowUsePeriod)) {
            this.menuItemUp.setText(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.TaxedRateEditUIResource.BACK"));
        }
    }

    private String GetNowUsePeriod() {
        try {
            ITaxRateList taxRateFac = TaxRateListFactory.getRemoteInstance();
            String oql = "select * where enabled = 1";
            TaxRateListCollection taxRateCol = taxRateFac.getTaxRateListCollection(oql);
            if (taxRateCol != null && taxRateCol.size() > 0) {
                return taxRateCol.get(0).getString("usePeriod");
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return "";
    }

    @Override
    public void loadFields() {
        TaxRateListInfo info;
        super.loadFields();
        try {
            String oql = "select * where enabled = 1 order by beginPoint";
            this.taxCollection = this.getBizInterface().getTaxRateListCollection(oql);
            info = null;
            if (this.taxCollection.get(0).getExcludeBeginPoint() == null && this.taxCollection.size() >= 10) {
                info = this.getTaxCollection().get(0);
                info.setExcludeBeginPoint(new BigDecimal("0.00"));
                info.setExcludeEndPoint(new BigDecimal("475.00"));
                info = this.getTaxCollection().get(1);
                info.setExcludeBeginPoint(new BigDecimal("475.00"));
                info.setExcludeEndPoint(new BigDecimal("1825.00"));
                info = this.getTaxCollection().get(2);
                info.setExcludeBeginPoint(new BigDecimal("1825.00"));
                info.setExcludeEndPoint(new BigDecimal("4375.00"));
                info = this.getTaxCollection().get(3);
                info.setExcludeBeginPoint(new BigDecimal("4375.00"));
                info.setExcludeEndPoint(new BigDecimal("16375.00"));
                info = this.getTaxCollection().get(4);
                info.setExcludeBeginPoint(new BigDecimal("16375.00"));
                info.setExcludeEndPoint(new BigDecimal("31375.00"));
                info = this.getTaxCollection().get(5);
                info.setExcludeBeginPoint(new BigDecimal("31375.00"));
                info.setExcludeEndPoint(new BigDecimal("45375.00"));
                info = this.getTaxCollection().get(6);
                info.setExcludeBeginPoint(new BigDecimal("45375.00"));
                info.setExcludeEndPoint(new BigDecimal("58375.00"));
                info = this.getTaxCollection().get(7);
                info.setExcludeBeginPoint(new BigDecimal("58375.00"));
                info.setExcludeEndPoint(new BigDecimal("70375.00"));
                info = this.getTaxCollection().get(8);
                info.setExcludeBeginPoint(new BigDecimal("70375.00"));
                info.setExcludeEndPoint(new BigDecimal("999999.00"));
                info = this.getTaxCollection().get(9);
                info.setExcludeBeginPoint(new BigDecimal("999999.00"));
                info.setExcludeEndPoint(new BigDecimal("1999999.00"));
                this.submit();
                this.taxCollection = this.getBizInterface().getTaxRateListCollection(oql);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.kDTable.removeRows();
        for (int i = 0; i < this.getTaxCollection().size(); ++i) {
            info = this.getTaxCollection().get(i);
            this.fieldsLoadLine(info);
        }
        if (this.kDTable.getRowCount() > 0) {
            IRow row = this.kDTable.getRow(this.kDTable.getRowCount() - 1);
            this.setNextBeginPoint((BigDecimal)row.getCell(2).getValue());
            this.setNextExclude_BeginPoint((BigDecimal)row.getCell(4).getValue());
        }
        this.currTableCount = this.kDTable.getRowCount();
    }

    private void fieldsLoadLine(TaxRateListInfo info) {
        this.setCurRow(this.kDTable.addRow());
        this.getCurRow().getCell(0).setValue((Object)info.getId());
        if (info.getBeginPoint() != null) {
            this.getCurRow().getCell(1).setValue((Object)info.getBeginPoint());
        }
        if (info.getEndPoint() != null) {
            this.getCurRow().getCell(2).setValue((Object)info.getEndPoint());
        }
        if (info.getExcludeBeginPoint() != null) {
            this.getCurRow().getCell(3).setValue((Object)info.getExcludeBeginPoint());
        }
        if (info.getExcludeEndPoint() != null) {
            this.getCurRow().getCell(4).setValue((Object)info.getExcludeEndPoint());
        }
        if (info.getTaxRate() != null) {
            BigDecimal bgRate = info.getTaxRate().divide(new BigDecimal("100"), 4, 1);
            this.getCurRow().getCell(5).setValue((Object)bgRate);
        }
        if (info.getFastSub() != null) {
            this.getCurRow().getCell(6).setValue((Object)info.getFastSub());
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.kDTable.getEditManager().stopEditing();
        this.taxCollection.clear();
        for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
            IRow row = this.kDTable.getRow(i);
            try {
                this.fieldsStoreLine(row, i);
                continue;
            }
            catch (TaxRateException e1) {
                this.handUIException((Throwable)((Object)e1));
                return;
            }
        }
        try {
            this.submit();
            this.showInfoInStateBar(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.TaxedRateEditUIResource.SUCCED"));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.taxCollection.clear();
        this.loadFields();
        this.changed = false;
    }

    private void check() throws TaxRateException {
        super.storeFields();
        this.kDTable.getEditManager().stopEditing();
        this.taxCollection.clear();
        for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
            IRow row = this.kDTable.getRow(i);
            this.fieldsStoreLine(row, i);
        }
    }

    private void submit() throws Exception {
        this.getBizInterface().delete("deleteAll");
        for (int i = 0; i < this.taxCollection.size(); ++i) {
            TaxRateListInfo info = this.taxCollection.get(i);
            this.getBizInterface().addnew(info);
        }
        this.taxCollection.clear();
    }

    private void fieldsStoreLine(IRow row, int rowInd) throws TaxRateException {
        TaxRateListInfo newInfo = (TaxRateListInfo)this.createNewData();
        Object obj = null;
        obj = row.getCell(1).getValue();
        if (obj == null) {
            this.kDTable.getEditManager().editCellAt(rowInd, 1);
            throw new TaxRateException(TaxRateException.BEGINPOINT_EXEC);
        }
        newInfo.setBeginPoint((BigDecimal)obj);
        obj = row.getCell(2).getValue();
        if (obj == null) {
            this.kDTable.getEditManager().editCellAt(rowInd, 2);
            throw new TaxRateException(TaxRateException.ENDPOINT_EXEC);
        }
        newInfo.setEndPoint((BigDecimal)obj);
        obj = row.getCell(3).getValue();
        if (obj == null) {
            this.kDTable.getEditManager().editCellAt(rowInd, 3);
            throw new TaxRateException(TaxRateException.EXCLUDE_BEGINPOINT_EXEC);
        }
        newInfo.setExcludeBeginPoint((BigDecimal)obj);
        obj = row.getCell(4).getValue();
        if (obj == null) {
            this.kDTable.getEditManager().editCellAt(rowInd, 4);
            throw new TaxRateException(TaxRateException.EXCLUDE_ENDPOINT_EXEC);
        }
        newInfo.setExcludeEndPoint((BigDecimal)obj);
        if (newInfo.getExcludeBeginPoint().subtract(newInfo.getExcludeEndPoint()).compareTo(new BigDecimal("0")) == 0) {
            this.kDTable.getEditManager().editCellAt(rowInd, 4);
            throw new TaxRateException(TaxRateException.EXCLUDE_BEGVAL_EQUAL_ENDVAL);
        }
        if (newInfo.getBeginPoint().subtract(newInfo.getEndPoint()).compareTo(new BigDecimal("0")) == 0) {
            this.kDTable.getEditManager().editCellAt(rowInd, 2);
            throw new TaxRateException(TaxRateException.BEGVAL_EQUAL_ENDVAL);
        }
        obj = row.getCell(5).getValue();
        if (obj == null) {
            this.kDTable.getEditManager().editCellAt(rowInd, 5);
            throw new TaxRateException(TaxRateException.TAXRATE_EXEC);
        }
        BigDecimal taxRateTax = (BigDecimal)obj;
        newInfo.setTaxRate(taxRateTax.multiply(new BigDecimal("100")));
        obj = row.getCell(6).getValue();
        if (obj == null) {
            this.kDTable.getEditManager().editCellAt(rowInd, 6);
            throw new TaxRateException(TaxRateException.SUB_EXEC);
        }
        newInfo.setFastSub((BigDecimal)obj);
        newInfo.setEnabled(true);
        newInfo.setUsePeriod(this.GetNowUsePeriod());
        this.taxCollection.add(newInfo);
    }

    protected IObjectValue createNewData() {
        return new TaxRateListInfo();
    }

    protected ITaxRateList getInterface() throws Exception {
        return TaxRateListFactory.getRemoteInstance();
    }

    private KDFormattedTextField getBeginEditor() {
        if (this.beginEditor == null) {
            this.beginEditor = new KDFormattedTextField(1);
            this.beginEditor.setPrecision(2);
            this.beginEditor.setPercentDisplay(false);
            this.beginEditor.setMaximumValue((Comparable)new BigDecimal("100000000000"));
        }
        return this.beginEditor;
    }

    private KDFormattedTextField getEndEditor() {
        if (this.endEditor == null) {
            this.endEditor = new KDFormattedTextField(1);
            this.endEditor.setPrecision(2);
            this.endEditor.setPercentDisplay(false);
            this.endEditor.setMaximumValue((Comparable)new BigDecimal("100000000000"));
        }
        return this.endEditor;
    }

    private KDFormattedTextField getSubEditor() {
        if (this.subEditor == null) {
            this.subEditor = new KDFormattedTextField(1);
            this.subEditor.setPrecision(2);
            this.subEditor.setPercentDisplay(false);
            this.subEditor.setMaximumValue((Comparable)new BigDecimal("100000000000"));
        }
        return this.subEditor;
    }

    private KDFormattedTextField getTaxEditor() {
        if (this.taxEditor == null) {
            this.taxEditor = new KDFormattedTextField(1);
            this.taxEditor.setPrecision(4);
            this.taxEditor.setMaximumValue((Comparable)new BigDecimal("1"));
        }
        return this.taxEditor;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTitle();
        this.loadFields();
        ((KDTTransferAction)this.kDTable.getActionMap().get("Paste")).setPasteMode(2);
    }

    protected KDTable getTableForCommon() {
        return this.kDTable;
    }

    protected KDTable getTableForPrintSetting() {
        return this.kDTable;
    }

    private void initKDTable() {
        this.kDTable.checkParsed();
        this.enableExportExcel(this.kDTable);
        this.ctnMain.setVisibleOfExpandButton(false);
        this.kDTable.addKDTEditListener((KDTEditListener)new LineEditAdapter());
        this.kDTable.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int selectRowIndex = e.getSelectBlock().getBeginRow();
                if (selectRowIndex < 0) {
                    return;
                }
                TaxRateListEditUI.this.setCurRow(TaxRateListEditUI.this.kDTable.getRow(selectRowIndex));
            }
        });
        this.kDTable.getSelectManager().setSelectMode(1);
        this.kDTable.getColumn(1).getStyleAttributes().setLocked(true);
        this.kDTable.getColumn(1).getStyleAttributes().setBackground(FIXCOLUMNCOLOR);
        this.kDTable.getColumn(3).getStyleAttributes().setLocked(true);
        this.kDTable.getColumn(3).getStyleAttributes().setBackground(FIXCOLUMNCOLOR);
        KDTDefaultCellEditor editor1 = new KDTDefaultCellEditor((JTextField)this.getBeginEditor());
        KDTDefaultCellEditor editor2 = new KDTDefaultCellEditor((JTextField)this.getEndEditor());
        KDTDefaultCellEditor editor3 = new KDTDefaultCellEditor((JTextField)this.getSubEditor());
        KDTDefaultCellEditor editor4 = new KDTDefaultCellEditor((JTextField)this.getTaxEditor());
        this.kDTable.getColumn(1).setEditor((ICellEditor)editor1);
        this.kDTable.getColumn(1).getStyleAttributes().setNumberFormat("0.00");
        this.kDTable.getColumn(2).setEditor((ICellEditor)editor2);
        this.kDTable.getColumn(2).getStyleAttributes().setNumberFormat("0.00");
        this.kDTable.getColumn(3).setEditor((ICellEditor)editor1);
        this.kDTable.getColumn(3).getStyleAttributes().setNumberFormat("0.00");
        this.kDTable.getColumn(4).setEditor((ICellEditor)editor2);
        this.kDTable.getColumn(4).getStyleAttributes().setNumberFormat("0.00");
        this.kDTable.getColumn(6).setEditor((ICellEditor)editor3);
        this.kDTable.getColumn(6).getStyleAttributes().setNumberFormat("0.00");
        this.kDTable.getColumn(6).getStyleAttributes().setBackground(REQUIREDBACKGROUND);
        this.kDTable.getColumn(5).setEditor((ICellEditor)editor4);
        this.kDTable.getColumn(5).getStyleAttributes().setNumberFormat("0.00%");
        this.kDTable.getColumn(5).getStyleAttributes().setBackground(REQUIREDBACKGROUND);
        HRUtils.setFocusDir(this.kDTable, 0);
    }

    private void initEditData() throws Exception {
        this.setTaxCollection(this.getInterface().getTaxRateListCollection());
    }

    private TaxRateListCollection getTaxCollection() {
        if (this.taxCollection == null) {
            this.taxCollection = new TaxRateListCollection();
        }
        return this.taxCollection;
    }

    private void setTaxCollection(TaxRateListCollection taxCollection) {
        this.taxCollection = taxCollection;
    }

    protected ITaxRateList getBizInterface() throws Exception {
        if (this.iTaxRate == null) {
            try {
                this.iTaxRate = TaxRateListFactory.getRemoteInstance();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        return this.iTaxRate;
    }

    private IRow getCurRow() {
        return this.curRow;
    }

    private void setCurRow(IRow curRow) {
        this.curRow = curRow;
        if (curRow == null) {
            return;
        }
    }

    private BigDecimal getNextBeginPoint() {
        if (this.nextBeginPoint == null) {
            this.nextBeginPoint = STRATPOINT;
        }
        return this.nextBeginPoint;
    }

    private void setNextBeginPoint(BigDecimal nextBeginPoint) {
        this.nextBeginPoint = nextBeginPoint;
    }

    private BigDecimal getNextExclude_BeginPoint() {
        if (this.nextExclude_BeginPoint == null) {
            this.nextExclude_BeginPoint = STRATPOINT;
        }
        return this.nextExclude_BeginPoint;
    }

    private void setNextExclude_BeginPoint(BigDecimal nextExclude_BeginPoint) {
        this.nextExclude_BeginPoint = nextExclude_BeginPoint;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.kDWBInsert.setEnabled(true);
        this.setButtonDefaultStyl(this.kDWBPrintView);
        this.setButtonDefaultStyl(this.kDWBPrint);
        this.setButtonDefaultStyl(this.kDWBSave);
        this.kDWBDel.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.kDWBInsert.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.kDWBAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.kDWBSave.setText(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.TaxedRateEditUIResource.BTNSAVE"));
        this.kDWBSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.kDWBPrint.setText(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.TaxedRateEditUIResource.BTNPNT"));
        this.kDWBPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.kDWBPrintView.setText(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.TaxedRateEditUIResource.BTNPNTVIEW"));
        this.kDWBPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.kDWBAddNew.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.TaxRateLisResource.ADDNEW"));
        this.kDWBDel.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.TaxRateLisResource.DELETE"));
        this.kDWBInsert.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.TaxRateLisResource.INSERT"));
        this.ctnMain.addButton((JButton)this.kDWBAddNew);
        this.ctnMain.addButton((JButton)this.kDWBInsert);
        this.ctnMain.addButton((JButton)this.kDWBDel);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable);
        this.kDTable.getPrintManager().print();
    }

    @Override
    public void actionPrintView_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kDTable);
        this.kDTable.getPrintManager().printPreview();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.storeFields();
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        int rowCount = this.kDTable.getRowCount();
        BigDecimal nextBeginPoint = null;
        BigDecimal nextExclude_BeginPoint = null;
        if (rowCount <= 0) {
            nextBeginPoint = STRATPOINT;
            nextExclude_BeginPoint = STRATPOINT;
        } else {
            IRow endRow = this.kDTable.getRow(rowCount - 1);
            nextBeginPoint = (BigDecimal)endRow.getCell(2).getValue();
            nextExclude_BeginPoint = (BigDecimal)endRow.getCell(4).getValue();
        }
        this.setNextBeginPoint(nextBeginPoint);
        this.setNextExclude_BeginPoint(nextExclude_BeginPoint);
        IRow currRow = this.kDTable.addRow();
        currRow.getCell(5).getStyleAttributes().setBackground(REQUIREDBACKGROUND);
        currRow.getCell(6).getStyleAttributes().setBackground(REQUIREDBACKGROUND);
        this.setCurRow(currRow);
        this.getCurRow().getCell(1).setValue((Object)this.getNextBeginPoint());
        this.getCurRow().getCell(2).setValue((Object)this.getNextBeginPoint());
        this.getCurRow().getCell(3).setValue((Object)this.getNextExclude_BeginPoint());
        this.getCurRow().getCell(4).setValue((Object)this.getNextExclude_BeginPoint());
    }

    private void showInfoInStateBar(String message) {
        this.setMessageText(message);
        this.showMessage();
    }

    private boolean isRefedTaxShc() throws EASBizException, BOSException {
        ITaxScheme iTaxScheme = TaxSchemeFactory.getRemoteInstance();
        return iTaxScheme.isRefBasicTaxTableIF();
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelete_actionPerformed(e);
        int rowCount = this.kDTable.getRowCount();
        if (rowCount == 0) {
            return;
        }
        int curRowIndex = this.getCurRow().getRowIndex();
        if (this.getCurRow().getCell(0).getValue() != null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.TaxRateLisResource.NOT_DEL"));
            SysUtil.abort();
        }
        if (this.getCurRow() == null) {
            return;
        }
        int nextSelectRowIndex = curRowIndex;
        if (curRowIndex == 0 && rowCount == 1) {
            nextSelectRowIndex = -1;
        }
        if (curRowIndex == 0 && rowCount > 1) {
            IRow nextRow = this.kDTable.getRow(curRowIndex + 1);
            nextRow.getCell(1).setValue((Object)new BigDecimal("0.00"));
            nextRow.getCell(3).setValue((Object)new BigDecimal("0.00"));
            nextSelectRowIndex = 0;
        }
        if (curRowIndex == rowCount - 1 && rowCount > 1) {
            nextSelectRowIndex = curRowIndex - 1;
        }
        if (curRowIndex > 0 && curRowIndex < rowCount - 1) {
            IRow topRow = this.kDTable.getRow(curRowIndex - 1);
            IRow nextRow = this.kDTable.getRow(this.getCurRow().getRowIndex() + 1);
            BigDecimal topEndPoint = (BigDecimal)topRow.getCell(2).getValue();
            nextRow.getCell(1).setValue((Object)topEndPoint.setScale(2));
            BigDecimal topExclude_EndPoint = (BigDecimal)topRow.getCell(4).getValue();
            nextRow.getCell(3).setValue((Object)topExclude_EndPoint.setScale(2));
            nextSelectRowIndex = curRowIndex;
        }
        if (nextSelectRowIndex == -1) {
            this.setNextBeginPoint(STRATPOINT);
            this.setNextExclude_BeginPoint(STRATPOINT);
            this.setCurRow(null);
        } else {
            IRow newSelectRow = this.kDTable.getRow(nextSelectRowIndex);
            this.setCurRow(newSelectRow);
            this.setNextBeginPoint((BigDecimal)newSelectRow.getCell(2).getValue());
            this.setNextExclude_BeginPoint((BigDecimal)newSelectRow.getCell(4).getValue());
        }
        this.kDTable.removeRow(curRowIndex);
        this.kDTable.getSelectManager().removeAll(false);
        this.kDTable.getSelectManager().select(nextSelectRowIndex, 1);
    }

    @Override
    public void actionInsert_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsert_actionPerformed(e);
        IRow row = this.getCurRow();
        if (row == null) {
            this.handUIException((Throwable)((Object)new TaxSchemeException(TaxSchemeException.MISSROW)));
            return;
        }
        BigDecimal rowBegin = (BigDecimal)row.getCell(1).getValue();
        BigDecimal rowExclude_Begin = (BigDecimal)row.getCell(3).getValue();
        this.setCurRow(this.kDTable.addRow(row.getRowIndex()));
        this.getCurRow().getCell(1).setValue((Object)new BigDecimal(rowBegin.toString()));
        this.getCurRow().getCell(2).setValue((Object)new BigDecimal(rowBegin.toString()));
        this.setNextBeginPoint((BigDecimal)this.getCurRow().getCell(2).getValue());
        if (rowExclude_Begin != null) {
            this.getCurRow().getCell(3).setValue((Object)new BigDecimal(rowExclude_Begin.toString()));
            this.getCurRow().getCell(4).setValue((Object)new BigDecimal(rowExclude_Begin.toString()));
        }
        this.setNextExclude_BeginPoint((BigDecimal)this.getCurRow().getCell(4).getValue());
    }

    public boolean checkBeforeWindowClosing() {
        try {
            if (!HRUtils.isPermissionByKey("hrtaxList_maintain")) {
                this.changed = false;
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (this.changed) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                try {
                    this.check();
                    this.submit();
                    this.taxCollection.clear();
                    this.loadFields();
                    this.showInfoInStateBar(EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.TaxSchemeResource.SAVE_SUCCEED"));
                }
                catch (TaxRateException ee) {
                    this.handUIException((Throwable)((Object)ee));
                    SysUtil.abort();
                }
                catch (Exception exc) {
                    this.handUIException(exc);
                }
            } else if (result == 2) {
                SysUtil.abort();
            }
            this.changed = false;
        }
        return super.checkBeforeWindowClosing();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.COMPENSATION;
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        this.kDTable.getEditHelper().paste(2);
    }

    @Override
    public void actionUpdateTaxList_actionPerformed(ActionEvent e) throws Exception {
        String txt = this.menuItemUp.getText();
        String message = "";
        String up = EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.TaxedRateEditUIResource.UP");
        String back = EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.TaxedRateEditUIResource.BACK");
        if (txt == up || txt.equals(up)) {
            TaxRateListFactory.getRemoteInstance().updateTaxList("201109");
            message = EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.TaxedRateEditUIResource.UPSUCCED");
        } else if (txt == back || txt.equals(back)) {
            TaxRateListFactory.getRemoteInstance().updateTaxList("200803");
            message = EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.TaxedRateEditUIResource.BACKSUCCED");
        } else {
            return;
        }
        this.kDTable.removeRows();
        this.initTitle();
        this.loadFields();
        MsgBox.showInfo((String)message);
    }

    class LineEditAdapter
    extends KDTEditAdapter {
        private Object oldValue;

        LineEditAdapter() {
        }

        public void editStarted(KDTEditEvent evt) {
            super.editStarted(evt);
            KDTable table = (KDTable)evt.getSource();
            this.oldValue = table.getRow(evt.getRowIndex()).getCell(evt.getColIndex()).getValue();
        }

        public void editStopped(KDTEditEvent evt) {
            BigDecimal beginPoint;
            BigDecimal oldEndPoint;
            BigDecimal newEndPoint;
            ICell cell;
            super.editStopped(evt);
            if (!TaxRateListEditUI.this.changed) {
                Object obj;
                Object objOld = evt.getOldValue();
                if (objOld != (obj = evt.getValue())) {
                    TaxRateListEditUI.this.changed = true;
                }
                if (objOld instanceof String) {
                    if (objOld != null && obj != null && obj.toString().equals(objOld.toString())) {
                        TaxRateListEditUI.this.changed = false;
                    }
                } else if (objOld instanceof BigDecimal && objOld != null && obj != null && ((BigDecimal)obj).setScale(2, 4).doubleValue() == ((BigDecimal)objOld).setScale(2, 4).doubleValue()) {
                    TaxRateListEditUI.this.changed = false;
                }
            }
            KDTable table = (KDTable)evt.getSource();
            int rowIndex = evt.getRowIndex();
            int colIndex = evt.getColIndex();
            Object newValue = evt.getValue();
            IRow row = table.getRow(rowIndex);
            TaxRateListEditUI.this.setCurRow(row);
            if (evt.getColIndex() == 2) {
                cell = row.getCell(colIndex);
                newEndPoint = (BigDecimal)newValue;
                oldEndPoint = (BigDecimal)this.oldValue;
                if (!HRUtils.isEqual(newEndPoint, oldEndPoint)) {
                    beginPoint = (BigDecimal)row.getCell(1).getValue();
                    if (beginPoint == null) {
                        return;
                    }
                    if (rowIndex == TaxRateListEditUI.this.kDTable.getRowCount() - 1) {
                        if (beginPoint.compareTo(newEndPoint) > 0) {
                            TaxRateListEditUI.this.handUIException((Throwable)((Object)new TaxSchemeException(TaxSchemeException.UIEXC1)));
                            cell.setValue((Object)oldEndPoint);
                            return;
                        }
                        cell.setValue((Object)newEndPoint);
                        TaxRateListEditUI.this.setNextBeginPoint(newEndPoint);
                        return;
                    }
                    if (rowIndex < TaxRateListEditUI.this.kDTable.getRowCount() - 1) {
                        IRow nextRow = TaxRateListEditUI.this.kDTable.getRow(rowIndex + 1);
                        BigDecimal nextEndPoint = (BigDecimal)nextRow.getCell(2).getValue();
                        if (beginPoint.compareTo(newEndPoint) > 0) {
                            TaxRateListEditUI.this.handUIException((Throwable)((Object)new TaxSchemeException(TaxSchemeException.UIEXC1)));
                            cell.setValue((Object)oldEndPoint);
                            return;
                        }
                        if (nextEndPoint.compareTo(newEndPoint) < 0) {
                            TaxRateListEditUI.this.handUIException((Throwable)((Object)new TaxSchemeException(TaxSchemeException.ENDPOINTEXC)));
                            cell.setValue((Object)oldEndPoint);
                            return;
                        }
                        cell.setValue((Object)newEndPoint);
                        TaxRateListEditUI.this.setNextBeginPoint(newEndPoint);
                        nextRow.getCell(1).setValue((Object)newEndPoint);
                        return;
                    }
                }
            }
            if (evt.getColIndex() == 4) {
                cell = row.getCell(colIndex);
                newEndPoint = (BigDecimal)newValue;
                oldEndPoint = (BigDecimal)this.oldValue;
                if (!HRUtils.isEqual(newEndPoint, oldEndPoint)) {
                    beginPoint = (BigDecimal)row.getCell(3).getValue();
                    if (beginPoint == null) {
                        return;
                    }
                    if (rowIndex == TaxRateListEditUI.this.kDTable.getRowCount() - 1) {
                        if (beginPoint.compareTo(newEndPoint) > 0) {
                            TaxRateListEditUI.this.handUIException((Throwable)((Object)new TaxSchemeException(TaxSchemeException.UIEXC1)));
                            cell.setValue((Object)oldEndPoint);
                            return;
                        }
                        cell.setValue((Object)newEndPoint);
                        TaxRateListEditUI.this.setNextExclude_BeginPoint(newEndPoint);
                        return;
                    }
                    if (rowIndex < TaxRateListEditUI.this.kDTable.getRowCount() - 1) {
                        IRow nextRow = TaxRateListEditUI.this.kDTable.getRow(rowIndex + 1);
                        BigDecimal nextEndPoint = (BigDecimal)nextRow.getCell(4).getValue();
                        if (beginPoint != null && beginPoint.compareTo(newEndPoint) > 0) {
                            TaxRateListEditUI.this.handUIException((Throwable)((Object)new TaxSchemeException(TaxSchemeException.UIEXC1)));
                            cell.setValue((Object)oldEndPoint);
                            return;
                        }
                        if (nextEndPoint != null && nextEndPoint.compareTo(newEndPoint) < 0) {
                            TaxRateListEditUI.this.handUIException((Throwable)((Object)new TaxSchemeException(TaxSchemeException.ENDPOINTEXC)));
                            cell.setValue((Object)oldEndPoint);
                            return;
                        }
                        cell.setValue((Object)newEndPoint);
                        TaxRateListEditUI.this.setNextExclude_BeginPoint(newEndPoint);
                        nextRow.getCell(3).setValue((Object)newEndPoint);
                        if (rowIndex == 0) {
                            row.getCell(3).setValue((Object)STRATPOINT);
                        }
                        return;
                    }
                }
            }
        }
    }
}

