/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.compensation.DeptSchemeEntryFactory;
import com.kingdee.eas.hr.compensation.ITeamGroup;
import com.kingdee.eas.hr.compensation.TeamGroupFactory;
import com.kingdee.eas.hr.compensation.TeamGroupInfo;
import com.kingdee.eas.hr.compensation.TeamGroupStateEnum;
import com.kingdee.eas.hr.compensation.client.AbstractTeamGroupListUI;
import com.kingdee.eas.hr.compensation.client.TeamGroupEditUI;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRTableTools;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class TeamGroupListUI
extends AbstractTeamGroupListUI {
    private static final Logger logger = CoreUIObject.getLogger(TeamGroupListUI.class);

    public TeamGroupListUI() throws Exception {
        HRSchemeUtils.checkInit();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        IObjectPK logPK = LogUtil.beginLog(null, (String)"", (BOSObjectType)new TeamGroupInfo().getBOSType(), null, (String)this.getTeamName(), (String)"TeamGroup_view");
        super.actionView_actionPerformed(e);
        LogUtil.afterLog(null, (IObjectPK)logPK);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        try {
            LinkedHashSet<String> idSet = new LinkedHashSet<String>();
            while (rowSet.next()) {
                idSet.add(rowSet.getString("id"));
            }
            rowSet.beforeFirst();
            Map map = ((ITeamGroup)this.getBizInterface()).getPrimaryPersonNames(idSet);
            while (rowSet.next()) {
                rowSet.updateString("primaryPerson", (String)map.get(rowSet.getString("id")));
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            this.abort(ex);
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String key = this.getSelectedKeyValue();
        if (this.isReferenceByDeptScheme(key)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"628_TeamGroupListUI"));
            SysUtil.abort();
        }
        super.actionCancel_actionPerformed(e);
    }

    protected void cancel() throws Exception {
        String key = this.getSelectedKeyValue();
        ITeamGroup teamGroup = TeamGroupFactory.getRemoteInstance();
        IObjectPK logPK = LogUtil.beginLog(null, (String)"", (BOSObjectType)new TeamGroupInfo().getBOSType(), null, (String)this.getTeamName(), (String)"TeamGroup_disable");
        teamGroup.updateState((IObjectPK)new ObjectUuidPK(key), TeamGroupStateEnum.DISABLE);
        LogUtil.afterLog(null, (IObjectPK)logPK);
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"629_TeamGroupListUI"));
        this.showMessage();
        this.refresh(null);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String key = this.getSelectedKeyValue();
        ITeamGroup teamGroup = TeamGroupFactory.getRemoteInstance();
        IObjectPK logPK = LogUtil.beginLog(null, (String)"", (BOSObjectType)new TeamGroupInfo().getBOSType(), null, (String)this.getTeamName(), (String)"TeamGroup_enable");
        teamGroup.updateState((IObjectPK)new ObjectUuidPK(key), TeamGroupStateEnum.ENABLE);
        LogUtil.afterLog(null, (IObjectPK)logPK);
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"630_TeamGroupListUI"));
        this.showMessage();
        this.refresh(e);
    }

    private String getTeamName() {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int selectIndex = -1;
        if (selectRows.length > 0) {
            selectIndex = selectRows[0];
        }
        String teamName = this.tblMain.getRow(selectIndex).getCell("name").getValue().toString();
        return teamName;
    }

    public void actionQueryScheme_actionPerformed(ActionEvent e) throws Exception {
        super.actionQueryScheme_actionPerformed(e);
    }

    protected String getEditUIName() {
        return TeamGroupEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TeamGroupFactory.getRemoteInstance();
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    int indexRow = e.getSelectBlock().getTop();
                    TeamGroupListUI.this.doButtonState(indexRow);
                }
                catch (Exception exc) {
                    TeamGroupListUI.this.handUIException(exc);
                }
            }
        });
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0);
            this.doButtonState(0);
        }
    }

    private void doButtonState(int indexRow) {
        BizEnumValueDTO state = (BizEnumValueDTO)HRTableTools.getTableSelectCellValue(this.tblMain, "state", indexRow);
        if (state != null && state.getInt("value") == TeamGroupStateEnum.ENABLE.getValue()) {
            this.actionEdit.setEnabled(true);
            this.actionCancelCancel.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionCancel.setEnabled(true);
        } else if (state != null && state.getInt("value") == TeamGroupStateEnum.DISABLE.getValue()) {
            this.actionEdit.setEnabled(false);
            this.actionCancelCancel.setEnabled(true);
            this.actionRemove.setEnabled(true);
            this.actionCancel.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
            this.actionCancelCancel.setEnabled(true);
            this.actionRemove.setEnabled(true);
            this.actionCancel.setEnabled(true);
        }
    }

    private boolean isReferenceByDeptScheme(String teamKey) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append(" select count(distinct entries.fteamgroupid) as count").append(" from t_hr_deptschemeentry as entries ").append(" inner join t_hr_deptscheme as dept on entries.fdeptschemeid = dept.fid ").append(" inner join t_hr_teamgroup as team on team.fid = entries.fteamgroupid ").append(" where dept.fenable = 1 ").append(" and team.fid= ? ");
        Object[] params = new Object[]{teamKey};
        IRowSet iRowSet = DeptSchemeEntryFactory.getRemoteInstance().getPersonNotInSchemeInDept(sql.toString(), params);
        if (iRowSet.size() > 0) {
            while (iRowSet.next()) {
                if (iRowSet.getInt("count") <= 0) continue;
                return true;
            }
        }
        return false;
    }
}

