/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.formulateutil;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.kscript.dom.expr.BinaryOpExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.stmt.CodeStmt;
import com.kingdee.bos.kscript.dom.stmt.ElseIfItem;
import com.kingdee.bos.kscript.dom.stmt.ExprStmt;
import com.kingdee.bos.kscript.dom.stmt.IfStmt;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlJoinedTableSource;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlTableSource;
import com.kingdee.bos.sql.dom.SqlTableSourceBase;
import com.kingdee.bos.sql.dom.SqlUpdate;
import com.kingdee.bos.sql.dom.SqlUpdateItem;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlExistsExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlInSubQueryExpr;
import com.kingdee.bos.sql.dom.stmt.SqlUpdateStmt;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.SelectParser;
import com.kingdee.bos.sql.parser.SqlExprParser;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CompenItemFormuleException;
import com.kingdee.eas.hr.compensation.EmpCmpSchmFacadeException;
import com.kingdee.eas.hr.compensation.EmpCompenseException;
import com.kingdee.eas.hr.compensation.formulateutil.ExprTrans;
import com.kingdee.eas.hr.compensation.formulateutil.FormulaTranslatorUtil;
import com.kingdee.eas.hr.compensation.formulateutil.ScriptStmtTransform;
import com.kingdee.eas.hr.compensation.util.PersonInfoUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IfStmtTranslator
extends ScriptStmtTransform {
    Map mapAllPersonItemSelectItems = null;
    Map mapFuncMap = null;
    SqlSelect subQuerySelect = null;

    @Override
    public List scriptStmtToSQLStmt(Context ctx, CodeStmt stmt, IObjectPK schPK) throws EASBizException, BOSException {
        ArrayList<SqlUpdateStmt> updStmtList = new ArrayList<SqlUpdateStmt>();
        StringBuffer perItemList = new StringBuffer("");
        try {
            this.mapFuncMap = (Map)ctx.get((Object)"Formula_TEMP_TABLE_FuncColumn");
            Map perItemMap = FormulaTranslatorUtil.getPerItemsDesc(ctx, schPK);
            if (perItemMap != null && !perItemMap.isEmpty()) {
                Iterator itr = perItemMap.keySet().iterator();
                while (itr.hasNext()) {
                    perItemList.append(itr.next());
                    perItemList.append("|");
                }
                perItemList.deleteCharAt(perItemList.length() - 1);
            }
            IfStmt ifStmt = (IfStmt)stmt;
            String horTableName = FormulaTranslatorUtil.getTableName(ctx, schPK);
            this.subQuerySelect = FormulaTranslatorUtil.getSelectStmt(ctx, horTableName, schPK.toString());
            StringBuffer sql = new StringBuffer();
            BinaryOpExpr elseCondition = null;
            SqlUpdate ifUpdate = new SqlUpdate();
            ExprStmt trueStmt = (ExprStmt)ifStmt.trueStmtList.get(0);
            ((BinaryOpExpr)trueStmt.expr).left.output(sql);
            String left = FormulaTranslatorUtil.formatScript(sql.toString());
            sql.delete(0, sql.length());
            ((BinaryOpExpr)trueStmt.expr).right.output(sql);
            SqlExprParser sqlParser = new SqlExprParser(FormulaTranslatorUtil.formatScript(sql.toString()));
            ifUpdate.updateList.add(new SqlUpdateItem(left, sqlParser.expr()));
            ifUpdate.condition = this.toSqlCondition(ctx, ifStmt.testExpr, false, perItemList, horTableName, schPK.toString());
            ifUpdate.updateTable = new SqlTableSource(horTableName + " \"DATATABLE_ALIAS\" ");
            elseCondition = (BinaryOpExpr)ifStmt.testExpr;
            SqlUpdateStmt updateStmt = new SqlUpdateStmt(ifUpdate);
            updStmtList.add(this.transUpdStmtTemplet(ctx, updateStmt, schPK));
            int size = ifStmt.elseIfList.size();
            for (int i = 0; i < size; ++i) {
                sql.delete(0, sql.length());
                SqlUpdate update = new SqlUpdate();
                ElseIfItem item = (ElseIfItem)ifStmt.elseIfList.get(i);
                BinaryOpExpr testExpr = (BinaryOpExpr)item.testExpr;
                update.updateTable = new SqlTableSource(horTableName + " \"DATATABLE_ALIAS\" ");
                elseCondition = new BinaryOpExpr((CodeExpr)elseCondition, 8, (CodeExpr)testExpr);
                BinaryOpExpr expr = (BinaryOpExpr)((ExprStmt)item.stmtList.get((int)0)).expr;
                expr.left.output(sql);
                String updateCol = FormulaTranslatorUtil.formatScript(sql.toString());
                sql.delete(0, sql.length());
                expr.right.output(sql);
                update.condition = this.toSqlCondition(ctx, item.testExpr, false, perItemList, horTableName, schPK.toString());
                sqlParser = new SqlExprParser(FormulaTranslatorUtil.formatScript(sql.toString()));
                update.updateList.add(new SqlUpdateItem(updateCol, sqlParser.expr()));
                SqlUpdateStmt updStmt = new SqlUpdateStmt(update);
                updStmtList.add(this.transUpdStmtTemplet(ctx, updStmt, schPK));
            }
            if (ifStmt.elseStmtList.size() > 0) {
                SqlUpdate elseUpdate = new SqlUpdate();
                BinaryOpExpr elseExpr = (BinaryOpExpr)((ExprStmt)ifStmt.elseStmtList.get((int)0)).expr;
                sql.delete(0, sql.length());
                elseExpr.left.output(sql);
                String elseLeft = FormulaTranslatorUtil.formatScript(sql.toString());
                sql.delete(0, sql.length());
                elseExpr.right.output(sql);
                sqlParser = new SqlExprParser(FormulaTranslatorUtil.formatScript(sql.toString()));
                elseUpdate.updateList.add(new SqlUpdateItem(elseLeft, sqlParser.expr()));
                elseUpdate.condition = this.toSqlCondition(ctx, (CodeExpr)elseCondition, true, perItemList, horTableName, schPK.toString());
                elseUpdate.updateTable = new SqlTableSource(horTableName + " \"DATATABLE_ALIAS\" ");
                SqlUpdateStmt updStmt = new SqlUpdateStmt(elseUpdate);
                updStmtList.add(this.transUpdStmtTemplet(ctx, updStmt, schPK));
            }
        }
        catch (ParserException e) {
            throw new CompenItemFormuleException(CompenItemFormuleException.PARSER_EXEC, e);
        }
        catch (FormaterException e) {
            throw new CompenItemFormuleException(CompenItemFormuleException.FORMAT_SQL_EXEC, e);
        }
        return updStmtList;
    }

    private SqlExpr toSqlCondition(Context ctx, CodeExpr expr, boolean isElseStmt, StringBuffer perItemList, String tableName, String id) throws ParserException, EASBizException, BOSException, FormaterException {
        SqlSelect selectStmt = (SqlSelect)this.subQuerySelect.clone();
        String tempTableName = ctx.get((Object)"FormulaPerson_TEMP_TABLE_NAME").toString();
        SqlTableSource tableSource = new SqlTableSource(tempTableName, "tempTable");
        SqlBinaryOpExpr newExpr = null;
        try {
            newExpr = new SqlBinaryOpExpr(new SqlExprParser("\"PERSON\".FID").expr(), 10, new SqlExprParser("tempTable.FPersonID").expr());
        }
        catch (ParserException e1) {
            throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
        }
        selectStmt.tableSource = new SqlJoinedTableSource(selectStmt.tableSource, (SqlTableSourceBase)tableSource, 0, (SqlExpr)newExpr);
        if (!this.isDependPersonItem(expr, perItemList.toString()) && !this.isDependFunction(expr)) {
            if (isElseStmt) {
                SqlSelect subQuery = new SqlSelect();
                subQuery.selectList.add(new SqlSelectItem((SqlExpr)new SqlIdentifierExpr("FPersonID"), "FPersonID"));
                subQuery.tableSource = new SqlTableSource(tableName);
                SqlBinaryOpExpr where = this.ifTestExprToSqlExpr((BinaryOpExpr)expr);
                ExprTrans trans = new ExprTrans();
                subQuery.condition = trans.transSqlExpr(ctx, (SqlExpr)where, (IObjectPK)new ObjectUuidPK(id));
                SqlInSubQueryExpr inSubQuery = new SqlInSubQueryExpr();
                inSubQuery.expr = new SqlIdentifierExpr("FPersonID");
                inSubQuery.not = true;
                inSubQuery.subQuery = subQuery;
                return inSubQuery;
            }
            return this.ifTestExprToSqlExpr((BinaryOpExpr)expr);
        }
        SqlBinaryOpExpr tempExpr = this.ifTestExprToSqlExpr((BinaryOpExpr)expr);
        ExprTrans trans = new ExprTrans();
        SqlExpr where = trans.transSqlExpr(ctx, (SqlExpr)tempExpr, (IObjectPK)new ObjectUuidPK(id));
        where = this.formatPersonItem(ctx, (SqlBinaryOpExpr)where, perItemList.toString(), id);
        SqlBinaryOpExpr whereExpr = null;
        if (selectStmt.condition != null) {
            whereExpr = new SqlBinaryOpExpr(selectStmt.condition, 7, where);
            selectStmt.condition = whereExpr;
        } else {
            selectStmt.condition = where;
        }
        whereExpr = new SqlBinaryOpExpr(new SqlExprParser("PERSON.FID").expr(), 10, new SqlExprParser("\"DATATABLE_ALIAS\".FPersonID").expr());
        whereExpr = new SqlBinaryOpExpr(selectStmt.condition, 7, (SqlExpr)whereExpr);
        selectStmt.condition = whereExpr;
        SqlSelect newSubQuerySelect = this.OptimizeSqlSelect(selectStmt);
        SqlExistsExpr subQuery = null;
        subQuery = isElseStmt ? new SqlExistsExpr((SqlSelectBase)newSubQuerySelect, true) : new SqlExistsExpr((SqlSelectBase)newSubQuerySelect, false);
        return subQuery;
    }

    private SqlSelect OptimizeSqlSelect(SqlSelect oldSelect) throws BOSException, EmpCmpSchmFacadeException {
        SqlSelectBase sb;
        String strNewSql = PersonInfoUtils.getOptimizeSql(oldSelect.toString());
        SqlSelect newSelect = null;
        try {
            SelectParser parser = new SelectParser(strNewSql);
            sb = parser.select();
        }
        catch (ParserException e) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.PARSE_SQL_EXEC, e);
        }
        if (sb == null || !(sb instanceof SqlSelect)) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.GET_FIXEDSQL_EXEC);
        }
        newSelect = (SqlSelect)sb;
        return newSelect;
    }

    private SqlBinaryOpExpr formatPersonItem(Context ctx, SqlBinaryOpExpr expr, String regex, String id) throws ParserException, BOSException, EASBizException, FormaterException {
        if (expr == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        DrSQLFormater formater = new DrSQLFormater(buff);
        formater.formatBinaryOpExpr(expr, false);
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(buff.toString());
        String key = "";
        String value = "";
        int start = 0;
        int end = 0;
        int tag = 0;
        StringBuffer sql = new StringBuffer();
        if (!StringUtils.isEmpty((String)regex)) {
            while (m.find()) {
                start = m.start();
                end = m.end();
                key = buff.substring(start, end);
                sql.append(buff.substring(tag, start));
                sql.append(key);
                tag = end;
            }
        }
        sql.append(buff.substring(tag));
        String sqlStr = this.formatFunctionItem(sql.toString());
        SqlExprParser parser = new SqlExprParser(sqlStr);
        return (SqlBinaryOpExpr)parser.expr();
    }

    private String formatFunctionItem(String formula) throws ParserException, BOSException, EASBizException, FormaterException {
        if (this.mapFuncMap == null) {
            return formula;
        }
        StringBuffer regex = new StringBuffer();
        Iterator iter = this.mapFuncMap.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            if (i++ != 0) {
                regex.append("|");
            }
            regex.append(iter.next());
        }
        if (StringUtils.isEmpty((String)regex.toString())) {
            return formula;
        }
        Pattern p = Pattern.compile(regex.toString());
        Matcher m = p.matcher(formula.toString());
        String key = "";
        String value = "";
        int start = 0;
        int end = 0;
        int tag = 0;
        StringBuffer sql = new StringBuffer();
        while (m.find()) {
            start = m.start();
            end = m.end();
            key = formula.substring(start, end);
            value = (String)this.mapFuncMap.get(key);
            sql.append(formula.substring(tag, start));
            sql.append(value);
            tag = end;
        }
        sql.append(formula.substring(tag));
        return sql.toString();
    }

    private SqlBinaryOpExpr ifTestExprToSqlExpr(BinaryOpExpr expr) throws ParserException {
        StringBuffer sb = new StringBuffer();
        expr.output(sb);
        String sql = this.formatNumberAndComma(sb.toString());
        sql = sql.replaceAll("\\|\\|", " OR ");
        sql = sql.replaceAll("\\&\\&", " AND ");
        sql = sql.replaceAll("==", "=");
        sql = sql.replaceAll("\"", "'");
        sql = sql.replaceAll("FFSAL", "TEMPITEMNUMBER");
        sql = sql.replaceAll("FSAL", "\"DATATABLE_ALIAS\".FSAL");
        sql = sql.replaceAll("TEMPITEMNUMBER", "\"DATATABLE_ALIAS\".FFSAL");
        sql = FormulaTranslatorUtil.toTranslateKSQL(sql);
        SqlExprParser parser = new SqlExprParser(sql);
        return (SqlBinaryOpExpr)parser.expr();
    }

    private String formatNumberAndComma(String kScript) {
        Pattern p = Pattern.compile("[\\d][.](\\d)*E(\\d)*");
        Matcher m = p.matcher(kScript);
        String temp = "";
        StringBuffer rst = new StringBuffer();
        int start = 0;
        int end = 0;
        int tag = 0;
        BigDecimal big = null;
        while (m.find()) {
            start = m.start();
            end = m.end();
            temp = kScript.substring(start, end);
            big = new BigDecimal(temp);
            rst.append(kScript.substring(tag, start));
            rst.append(big.toString());
            tag = end;
        }
        rst.append(kScript.substring(end));
        return rst.toString().replaceAll("\"", "'");
    }

    private boolean isDependPersonItem(CodeExpr expr, String regex) {
        if (regex != null && regex.length() == 0) {
            return false;
        }
        if (regex != null) {
            StringBuffer buff = new StringBuffer();
            expr.output(buff);
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(buff.toString());
            return m.find();
        }
        return false;
    }

    private boolean isDependFunction(CodeExpr expr) {
        if (this.mapFuncMap == null) {
            return false;
        }
        StringBuffer buff = new StringBuffer();
        expr.output(buff);
        Iterator iter = this.mapFuncMap.keySet().iterator();
        String key = null;
        while (iter.hasNext()) {
            key = iter.next().toString();
            if (buff.indexOf(key) == -1) continue;
            return true;
        }
        return false;
    }

    public SqlExpr codeExprToSqlExpr(Context ctx, CodeExpr expr, Map personItem) throws ParserException, BOSException {
        Iterator itl = personItem.keySet().iterator();
        StringBuffer reg = new StringBuffer();
        while (itl.hasNext()) {
            reg.append(itl.next());
            if (!itl.hasNext()) continue;
            reg.append("|");
        }
        StringBuffer buff = new StringBuffer();
        expr.output(buff);
        String sql = FormulaTranslatorUtil.formatScript(buff.toString());
        Pattern p = Pattern.compile(reg.toString());
        Matcher m = p.matcher(sql);
        StringBuffer newSql = new StringBuffer();
        int start = 0;
        int end = 0;
        while (m.find()) {
            start = m.start();
            newSql.append(sql.substring(end, start));
            end = m.end();
            String subString = sql.substring(start, end);
            subString = FormulaTranslatorUtil.replaceItemOfOwnItemValue(ctx, subString, this.mapAllPersonItemSelectItems);
            newSql.append(personItem.get(subString));
        }
        newSql.append(sql.substring(end));
        SqlExprParser parser = new SqlExprParser(newSql.toString());
        return parser.expr();
    }
}

