/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.compensation.AccountTypeEnum;
import com.kingdee.eas.hr.compensation.CmpAssistantHGFactory;
import com.kingdee.eas.hr.compensation.CmpAssistantHGInfo;
import com.kingdee.eas.hr.compensation.CmpItemAccountDeptException;
import com.kingdee.eas.hr.compensation.CmpItemAccountEmpCollection;
import com.kingdee.eas.hr.compensation.CmpItemAccountEmpEntryCollection;
import com.kingdee.eas.hr.compensation.CmpItemAccountEmpEntryInfo;
import com.kingdee.eas.hr.compensation.CmpItemAccountEmpFactory;
import com.kingdee.eas.hr.compensation.CmpItemAccountEmpInfo;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.GrantEntryFactory;
import com.kingdee.eas.hr.compensation.GrantEntryInfo;
import com.kingdee.eas.hr.compensation.GrantFactory;
import com.kingdee.eas.hr.compensation.GrantInfo;
import com.kingdee.eas.hr.compensation.GrantTypeEnum;
import com.kingdee.eas.hr.compensation.IGrant;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CmpGrantUtil {
    private static Logger logger = Logger.getLogger(CmpGrantUtil.class);
    private Context ctx;
    private CmpSchemeInfo infoCmpScheme;
    private GrantTypeEnum grantType;
    private List cmpItemList;
    private String hrOrgID = null;
    Map mapEmpAccount = null;
    int grantBillCount = 0;

    public CmpGrantUtil(Context ctx, CmpSchemeInfo infoCmpScheme) {
        this.ctx = ctx;
        this.infoCmpScheme = infoCmpScheme;
        this.hrOrgID = infoCmpScheme.getHrOrgUnit() != null && infoCmpScheme.getHrOrgUnit().getId() != null ? infoCmpScheme.getHrOrgUnit().getId().toString() : HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString();
    }

    public void setGrantType() {
        try {
            this.grantType = HRUtils.getGrantHRParamterValue(this.ctx);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    public void convertToGrant() throws EASBizException, BOSException, SQLException {
        this.cmpItemList = this.getSchemeCmpItem();
        if (this.cmpItemList.size() < 1) {
            return;
        }
        this.setGrantType();
        if (this.grantType != null && 1 == this.grantType.getValue()) {
            this.convertToGrantByOrg();
        } else {
            this.convertToGrant(HRSchemeUtils.getHRToCompanyOrgUnitInfo(this.ctx, this.hrOrgID));
        }
    }

    private void convertToGrantByOrg() throws EASBizException, BOSException, SQLException {
        IRowSet rs = this.getCompanyByAdmin();
        String comId = null;
        while (rs.next()) {
            ++this.grantBillCount;
            comId = rs.getString("companyId");
            this.convertToGrantByOneComp(comId);
        }
        if (this.grantBillCount <= 0) {
            throw new CmpItemAccountDeptException(CmpItemAccountDeptException.ITEM_SCHEME_ACCOUNT_NULL);
        }
    }

    private void convertToGrantByOneComp(String companyID) throws EASBizException, BOSException, SQLException {
        if (companyID == null || "".equals(companyID)) {
            return;
        }
        CompanyOrgUnitInfo infoCompany = new CompanyOrgUnitInfo();
        infoCompany.setId(BOSUuid.read((String)companyID));
        this.convertToGrant(infoCompany);
    }

    private void convertToGrant(CompanyOrgUnitInfo infoCompany) throws EASBizException, BOSException, SQLException {
        if (infoCompany == null) {
            return;
        }
        Map itemMap = this.getCmpAccountFromScheme(infoCompany);
        if (itemMap == null) {
            --this.grantBillCount;
            return;
        }
        GrantInfo infoGrant = this.saveGrantInfo(infoCompany);
        CmpItemInfo infoItem = null;
        CmpItemAccountEmpCollection itemAccountColl = null;
        int size = this.cmpItemList.size();
        for (int i = 0; i < size; ++i) {
            infoItem = (CmpItemInfo)this.cmpItemList.get(i);
            itemAccountColl = (CmpItemAccountEmpCollection)((Object)itemMap.get(infoItem.getId().toString()));
            this.setAssistantDetail(itemAccountColl, infoGrant, infoCompany.getId().toString());
        }
    }

    private GrantInfo saveGrantInfo(CompanyOrgUnitInfo infoCompany) throws BOSException, EASBizException {
        IGrant iGrant = GrantFactory.getLocalInstance(this.ctx);
        HROrgUnitInfo hrInfo = this.infoCmpScheme.getHrOrgUnit();
        if (hrInfo == null) {
            hrInfo = HRSchemeUtils.getServerHROrgUnitInfo(this.ctx);
        }
        GrantInfo infoGrant = new GrantInfo();
        infoGrant.setCompany(infoCompany);
        infoGrant.setCmpPeriod(this.infoCmpScheme.getCmpPeriod());
        infoGrant.setCurrency(this.infoCmpScheme.getCurrency());
        infoGrant.setIsVouchered(false);
        infoGrant.setTime(this.infoCmpScheme.getTime());
        infoGrant.setCmpScheme(this.infoCmpScheme);
        infoGrant.setHrOrgUnit(hrInfo);
        IObjectPK pk = iGrant.addnew((CoreBaseInfo)infoGrant);
        infoGrant.setId(BOSUuid.read((String)pk.toString()));
        return infoGrant;
    }

    private void setAssistantDetail(CmpItemAccountEmpCollection itemAccountColl, GrantInfo infoGrant, String companyID) throws BOSException, SQLException, EASBizException {
        CmpItemAccountEmpInfo accountInfo = null;
        HashMap mapDebit = new HashMap();
        HashMap mapCredit = new HashMap();
        if (itemAccountColl == null) {
            return;
        }
        for (int i = 0; i < itemAccountColl.size(); ++i) {
            accountInfo = itemAccountColl.get(i);
            this.setAccountMap(mapDebit, accountInfo, AccountTypeEnum.DebitAccount);
            this.setAccountMap(mapCredit, accountInfo, AccountTypeEnum.CreditAccount);
        }
        this.groupByAssAct(mapDebit, AccountTypeEnum.DebitAccount, infoGrant, companyID);
        this.groupByAssAct(mapCredit, AccountTypeEnum.CreditAccount, infoGrant, companyID);
    }

    private void groupByAssAct(Map map, AccountTypeEnum accountType, GrantInfo infoGrant, String companyID) throws BOSException, SQLException, EASBizException {
        Set keySet = map.keySet();
        Iterator iter = keySet.iterator();
        CmpItemAccountEmpCollection itemAccountColl = null;
        String accountViewId = null;
        List assisTyepAttLst = null;
        while (iter.hasNext()) {
            accountViewId = iter.next().toString();
            itemAccountColl = (CmpItemAccountEmpCollection)((Object)map.get(accountViewId));
            assisTyepAttLst = this.getAssistantTypeAccount(accountViewId);
            if (assisTyepAttLst.size() < 1) {
                AccountViewInfo accountViewInfo = new AccountViewInfo();
                accountViewInfo.setId(BOSUuid.read((String)accountViewId));
                BigDecimal value = this.getTotalByCmpItem(itemAccountColl, companyID);
                GrantEntryInfo grantEntryTem = new GrantEntryInfo();
                grantEntryTem.setCmpItem(itemAccountColl.get(0).getCmpItem());
                grantEntryTem.setGrant(infoGrant);
                grantEntryTem.setAmount(value);
                CmpAssistantHGInfo cmpAssistantHG = new CmpAssistantHGInfo();
                cmpAssistantHG.setAmount(value);
                IObjectPK pk = CmpAssistantHGFactory.getLocalInstance(this.ctx).addnew((CoreBaseInfo)cmpAssistantHG);
                cmpAssistantHG.setId(BOSUuid.read((String)pk.toString()));
                grantEntryTem.setAccountView(accountViewInfo);
                grantEntryTem.setAccountType(accountType);
                GrantEntryFactory.getLocalInstance(this.ctx).addnew((CoreBaseInfo)grantEntryTem);
                continue;
            }
            this.addAsissantDetial(itemAccountColl, assisTyepAttLst, infoGrant, companyID, accountType);
        }
    }

    private void addAsissantDetial(CmpItemAccountEmpCollection itemAccountColl, List assisTyepAttLst, GrantInfo infoGrant, String companyID, AccountTypeEnum accountType) throws BOSException, SQLException, EASBizException {
        if (itemAccountColl == null || itemAccountColl.size() == 0) {
            return;
        }
        CmpItemAccountEmpInfo accountInfo = null;
        CmpItemAccountEmpEntryInfo entryInfo = null;
        CmpItemAccountEmpCollection entryColl = null;
        CmpItemAccountEmpEntryCollection totalColl = null;
        CmpItemAccountEmpEntryCollection creditColl = null;
        CmpItemAccountEmpEntryCollection debitColl = null;
        StringBuffer keyCom = null;
        HashMap<String, CmpItemAccountEmpCollection> map = new HashMap<String, CmpItemAccountEmpCollection>();
        for (int i = 0; i < itemAccountColl.size(); ++i) {
            accountInfo = itemAccountColl.get(i);
            totalColl = accountInfo.getCmpAssActEntries();
            if (totalColl == null || totalColl.size() == 0) continue;
            keyCom = new StringBuffer();
            creditColl = new CmpItemAccountEmpEntryCollection();
            debitColl = new CmpItemAccountEmpEntryCollection();
            for (int j = 0; j < totalColl.size(); ++j) {
                entryInfo = totalColl.get(j);
                if (accountType.equals((Object)entryInfo.getAccountType())) {
                    if (keyCom.length() > 0) {
                        keyCom.append("&&");
                    }
                    keyCom.append(entryInfo.getValue());
                    creditColl.add(entryInfo);
                    continue;
                }
                debitColl.add(entryInfo);
            }
            if (accountType.getValue() == 1) {
                accountInfo.put("CreditAccount_Entry", (Object)creditColl);
                accountInfo.put("DebitAccount_Entry", (Object)debitColl);
            } else {
                accountInfo.put("CreditAccount_Entry", (Object)debitColl);
                accountInfo.put("DebitAccount_Entry", (Object)creditColl);
            }
            if (keyCom.length() <= 0) continue;
            if (map.containsKey(keyCom.toString())) {
                ((CmpItemAccountEmpCollection)((Object)map.get(keyCom.toString()))).add(accountInfo);
                continue;
            }
            entryColl = new CmpItemAccountEmpCollection();
            entryColl.add(accountInfo);
            map.put(keyCom.toString(), entryColl);
        }
        Set keySet = map.keySet();
        Iterator iter = keySet.iterator();
        BigDecimal grantEntryBigDec = new BigDecimal("0");
        GrantEntryInfo grantEntryTem = null;
        if (map.isEmpty()) {
            grantEntryTem = new GrantEntryInfo();
            grantEntryTem.setCmpItem(itemAccountColl.get(0).getCmpItem());
            grantEntryTem.setGrant(infoGrant);
            grantEntryTem.setAmount(grantEntryBigDec);
            CmpAssistantHGInfo cmpAssistantHG = new CmpAssistantHGInfo();
            cmpAssistantHG.setAmount(grantEntryBigDec);
            IObjectPK pk = CmpAssistantHGFactory.getLocalInstance(this.ctx).addnew((CoreBaseInfo)cmpAssistantHG);
            cmpAssistantHG.setId(BOSUuid.read((String)pk.toString()));
            if (accountType.getValue() == 1) {
                grantEntryTem.setAccountView(itemAccountColl.get(0).getAccountCredit());
            } else {
                grantEntryTem.setAccountView(itemAccountColl.get(0).getAccountDebit());
            }
            grantEntryTem.setAccountType(accountType);
            GrantEntryFactory.getLocalInstance(this.ctx).addnew((CoreBaseInfo)grantEntryTem);
        }
        ArrayList<GrantEntryInfo> grangEntryList = new ArrayList<GrantEntryInfo>();
        while (iter.hasNext()) {
            entryColl = (CmpItemAccountEmpCollection)((Object)map.get(iter.next()));
            CmpAssistantHGInfo cmpAssistantHG = this.batchAddGrantEntry(entryColl, companyID, accountType);
            grantEntryBigDec = grantEntryBigDec.add(cmpAssistantHG.getAmount());
            grantEntryTem = new GrantEntryInfo();
            grantEntryTem.setCmpItem(entryColl.get(0).getCmpItem());
            grantEntryTem.setGrant(infoGrant);
            if (accountType.getValue() == 1) {
                grantEntryTem.setAccountView(entryColl.get(0).getAccountCredit());
            } else {
                grantEntryTem.setAccountView(entryColl.get(0).getAccountDebit());
            }
            grantEntryTem.setAccountType(accountType);
            grangEntryList.add(grantEntryTem);
        }
        for (int i = 0; i < grangEntryList.size(); ++i) {
            grantEntryTem = (GrantEntryInfo)grangEntryList.get(i);
            grantEntryTem.setAmount(grantEntryBigDec);
            GrantEntryFactory.getLocalInstance(this.ctx).addnew((CoreBaseInfo)grantEntryTem);
        }
    }

    private CmpAssistantHGInfo batchAddGrantEntry(CmpItemAccountEmpCollection entryColl, String companyID, AccountTypeEnum accountType) throws BOSException, SQLException, EASBizException {
        StringBuffer longNameGroup = null;
        StringBuffer numberGroup = null;
        String entityId = null;
        String assTypeAtt = null;
        longNameGroup = new StringBuffer();
        numberGroup = new StringBuffer();
        CmpItemAccountEmpEntryCollection entry = null;
        entry = accountType.getValue() == 1 ? (CmpItemAccountEmpEntryCollection)((Object)entryColl.get(0).get("CreditAccount_Entry")) : (CmpItemAccountEmpEntryCollection)((Object)entryColl.get(0).get("DebitAccount_Entry"));
        CmpItemAccountEmpEntryInfo entryInfo = null;
        BigDecimal value = this.getTotalByCmpItem(entryColl, companyID);
        CmpAssistantHGInfo cmpAssistantHG = new CmpAssistantHGInfo();
        cmpAssistantHG.setAmount(value);
        int size = entry.size();
        for (int j = 0; j < size; ++j) {
            entryInfo = entry.get(j);
            assTypeAtt = entryInfo.getAssActType().getAsstHGAttribute();
            entityId = entryInfo.getValue();
            cmpAssistantHG.put(assTypeAtt, entityId);
            if (j != 0) {
                longNameGroup.append("_");
                numberGroup.append("_");
            }
            longNameGroup.append(entryInfo.getAssActName());
            numberGroup.append(entryInfo.getAssActNumber());
        }
        cmpAssistantHG.setLongNameGroupNew(longNameGroup.toString());
        cmpAssistantHG.setNumberGroupNew(numberGroup.toString());
        CmpAssistantHGFactory.getLocalInstance(this.ctx).addnew((CoreBaseInfo)cmpAssistantHG);
        return cmpAssistantHG;
    }

    private void setAccountMap(Map map, CmpItemAccountEmpInfo accountInfo, AccountTypeEnum accountType) {
        CmpItemAccountEmpCollection itemAccountColl = null;
        String accountViewID = null;
        accountViewID = accountType.getValue() == 1 ? accountInfo.getAccountCredit().getId().toString() : accountInfo.getAccountDebit().getId().toString();
        if (map.containsKey(accountViewID)) {
            ((CmpItemAccountEmpCollection)((Object)map.get(accountViewID))).add(accountInfo);
        } else {
            itemAccountColl = new CmpItemAccountEmpCollection();
            itemAccountColl.add(accountInfo);
            if (accountViewID != null) {
                map.put(accountViewID, itemAccountColl);
            }
        }
    }

    private Map getCmpAccountFromScheme(CompanyOrgUnitInfo infoCompany) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashSet<String> cmpItemIdSet = new HashSet<String>();
        for (int i = 0; i < this.cmpItemList.size(); ++i) {
            cmpItemIdSet.add(((CmpItemInfo)this.cmpItemList.get(i)).getId().toString());
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select T.fpersonid from ").append(this.infoCmpScheme.getHorTableName());
        sb.append(" T INNER  JOIN T_BD_PERSON  PERSON ON PERSON.FID =  T.FPERSONID ");
        sb.append(" INNER  JOIN T_HR_PERSONCMP PERSONCMP ON PERSON.FID = PERSONCMP.FPersonID ");
        if (this.grantType != null && 1 == this.grantType.getValue()) {
            sb.append("\n where T.FADMINORGUNITID in(" + HRUtils.getSqlAdminByComp(infoCompany.getId().toString()) + ")");
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        this.addSelectorItem(viewInfo);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)infoCompany.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.id", cmpItemIdSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)sb.toString(), CompareType.INNER));
        filterInfo.setMaskString("#0 and #1 and #2");
        viewInfo.getSorter().add(new SorterItemInfo("cmpAssActEntries.assActNumber"));
        viewInfo.setFilter(filterInfo);
        CmpItemAccountEmpCollection empAccountColl = CmpItemAccountEmpFactory.getLocalInstance(this.ctx).getCmpItemAccountEmpCollection(viewInfo);
        if (empAccountColl == null || empAccountColl.size() == 0) {
            return null;
        }
        CmpItemAccountEmpCollection itemAccountColl = null;
        CmpItemAccountEmpInfo accountInfo = null;
        String cmpItemId = null;
        for (int i = 0; i < empAccountColl.size(); ++i) {
            accountInfo = empAccountColl.get(i);
            cmpItemId = accountInfo.getCmpItem().getId().toString();
            if (map.containsKey(cmpItemId)) {
                ((CmpItemAccountEmpCollection)((Object)map.get(cmpItemId))).add(accountInfo);
                continue;
            }
            itemAccountColl = new CmpItemAccountEmpCollection();
            itemAccountColl.add(accountInfo);
            map.put(cmpItemId, (Object)itemAccountColl);
        }
        StringBuffer infoStr = new StringBuffer();
        int j = 0;
        for (int i = 0; i < this.cmpItemList.size(); ++i) {
            String itemId = ((CmpItemInfo)this.cmpItemList.get(i)).getId().toString();
            if (map.containsKey(itemId)) continue;
            if (j++ != 0) {
                infoStr.append(",");
            }
            infoStr.append(((CmpItemInfo)this.cmpItemList.get(i)).getName());
        }
        if (infoStr.length() > 0) {
            String str = "" + infoStr.toString() + "";
            map.put("allNoAccount", str);
        }
        return map;
    }

    private void addSelectorItem(EntityViewInfo infoEntityView) {
        infoEntityView.getSelector().add(new SelectorItemInfo("*"));
        infoEntityView.getSelector().add(new SelectorItemInfo("AccountCredit.id"));
        infoEntityView.getSelector().add(new SelectorItemInfo("AccountCredit.number"));
        infoEntityView.getSelector().add(new SelectorItemInfo("CmpItem.id"));
        infoEntityView.getSelector().add(new SelectorItemInfo("CmpItem.name"));
        infoEntityView.getSelector().add(new SelectorItemInfo("CmpItem.number"));
        infoEntityView.getSelector().add(new SelectorItemInfo("AccountDebit.id"));
        infoEntityView.getSelector().add(new SelectorItemInfo("AccountDebit.number"));
        infoEntityView.getSelector().add(new SelectorItemInfo("cmpAssActEntries.accountType"));
        infoEntityView.getSelector().add(new SelectorItemInfo("cmpAssActEntries.assActType.id"));
        infoEntityView.getSelector().add(new SelectorItemInfo("cmpAssActEntries.assActType.asstHGAttribute"));
        infoEntityView.getSelector().add(new SelectorItemInfo("cmpAssActEntries.value"));
        infoEntityView.getSelector().add(new SelectorItemInfo("cmpAssActEntries.assActName"));
        infoEntityView.getSelector().add(new SelectorItemInfo("cmpAssActEntries.assActNumber"));
        infoEntityView.getSelector().add(new SelectorItemInfo("adminOrg.id"));
        infoEntityView.getSelector().add(new SelectorItemInfo("adminOrg.number"));
        infoEntityView.getSelector().add(new SelectorItemInfo("person.id"));
        infoEntityView.getSelector().add(new SelectorItemInfo("person.name"));
        infoEntityView.getSelector().add(new SelectorItemInfo("person.number"));
        infoEntityView.getSelector().add(new SelectorItemInfo("valueOfDept"));
    }

    private List getAssistantTypeAccount(String id) throws BOSException, SQLException {
        MetaDataPK mainQuery = new MetaDataPK("com.kingdee.eas.hr.compensation.app", "CmpItemAccountAssActQuery");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("AccountView.id", (Object)id));
        viewInfo.setFilter(filter);
        IQueryExecutor iQe = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)mainQuery);
        iQe.setObjectView(viewInfo);
        iQe.getSQL();
        IRowSet iRowResult = iQe.executeQuery();
        ArrayList<String> list = new ArrayList<String>();
        while (iRowResult.next()) {
            list.add(iRowResult.getString("asstActType.asstHGAttribute"));
        }
        return list;
    }

    private BigDecimal getTotalByCmpItem(CmpItemAccountEmpCollection itemAccountColl, String compId) throws BOSException, SQLException {
        if (itemAccountColl == null || itemAccountColl.size() == 0) {
            return new BigDecimal("0.00");
        }
        StringBuffer personIDs = new StringBuffer();
        String personID = null;
        for (int i = 0; i < itemAccountColl.size(); ++i) {
            personID = itemAccountColl.get(i).getPerson().getId().toString();
            if (i != 0) {
                personIDs.append(",");
            }
            personIDs.append("'").append(personID).append("'");
        }
        String number = itemAccountColl.get(0).getCmpItem().getNumber();
        StringBuffer sql = new StringBuffer("");
        sql.append("SELECT  ");
        sql.append("SUM(");
        sql.append(number);
        sql.append(") as ");
        sql.append(number.trim());
        sql.append(" FROM ");
        sql.append(this.infoCmpScheme.getHorTableName());
        sql.append(" T INNER  JOIN T_BD_PERSON  PERSON ON PERSON.FID =  T.FPERSONID ");
        sql.append(" INNER  JOIN T_HR_PERSONCMP PERSONCMP ON PERSON.FID = PERSONCMP.FPersonID ");
        sql.append("\n where t.FPERSONID in(" + personIDs.toString() + ")");
        if (this.grantType != null && 1 == this.grantType.getValue()) {
            sql.append("\n and t.FADMINORGUNITID in(" + HRUtils.getSqlAdminByComp(compId) + ")");
        }
        IRowSet iRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        BigDecimal retBdc = null;
        if (iRowSet.next()) {
            retBdc = iRowSet.getBigDecimal(number.trim()) != null ? iRowSet.getBigDecimal(number.trim()).setScale(2, 4) : new BigDecimal("0.00");
        }
        return retBdc;
    }

    private List getSchemeCmpItem() throws BOSException, EASBizException, SQLException {
        ArrayList<CmpItemInfo> lst = new ArrayList<CmpItemInfo>();
        MetaDataPK queryPK = null;
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        String schemeID = this.infoCmpScheme.getId().toString();
        queryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.CmpSchemeItemQuery");
        exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)queryPK);
        exec.setObjectView(" where cmpItem.dataType = 60 and isForGrant=1 and isDelete = 0 and CmpScheme.id='" + schemeID + "'");
        rowSet = exec.executeQuery();
        CmpItemInfo infoCmpItem = null;
        while (rowSet.next()) {
            infoCmpItem = new CmpItemInfo();
            infoCmpItem.setId(BOSUuid.read((String)rowSet.getString("cmpItem.id")));
            infoCmpItem.setNumber(rowSet.getString("cmpItem.number"));
            infoCmpItem.setName(rowSet.getString("cmpItem.name"));
            infoCmpItem.setDecDigital(rowSet.getInt("cmpItem.decDigital"));
            lst.add(infoCmpItem);
        }
        return lst;
    }

    private IRowSet getCompanyByAdmin() throws EASBizException, BOSException, SQLException {
        StringBuffer sql = new StringBuffer("");
        sql.append("SELECT t.FADMINORGUNITID ");
        sql.append(" FROM ");
        sql.append(this.infoCmpScheme.getHorTableName());
        sql.append(" T INNER  JOIN T_BD_PERSON  PERSON ON PERSON.FID =  T.FPERSONID ");
        sql.append(" INNER  JOIN T_HR_PERSONCMP PERSONCMP ON PERSON.FID = PERSONCMP.FPersonID ");
        String sqlComp = HRUtils.getCompSqlByAdmin(sql.toString());
        IRowSet iRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sqlComp);
        return iRowSet;
    }

    public int checkEmpAccount() throws EASBizException, BOSException, SQLException {
        if (this.mapEmpAccount == null) {
            this.mapEmpAccount = new HashMap();
        } else {
            this.mapEmpAccount.clear();
        }
        int state = 0;
        this.cmpItemList = this.getSchemeCmpItem();
        if (this.cmpItemList.size() < 1) {
            state = 1;
            return state;
        }
        this.setGrantType();
        if (this.grantType != null && 1 == this.grantType.getValue()) {
            IRowSet rs = this.getCompanyByAdmin();
            String comId = null;
            if (rs == null || rs.size() == 0) {
                state = 2;
                return state;
            }
            block0: while (rs.next()) {
                comId = rs.getString("companyId");
                if (comId == null || "".equals(comId)) {
                    state = 2;
                    return state;
                }
                CompanyOrgUnitInfo infoCompany = new CompanyOrgUnitInfo();
                infoCompany.setId(BOSUuid.read((String)comId));
                Map itemMap = this.getCmpAccountFromScheme(infoCompany);
                List persons = this.getSchemePersons(infoCompany);
                if (itemMap == null && this.mapEmpAccount.size() > 0) {
                    state = 3;
                    continue;
                }
                if (itemMap == null && this.mapEmpAccount.size() < 1) {
                    state = 4;
                    continue;
                }
                this.mapEmpAccount.put(comId, itemMap);
                if (itemMap.size() != this.cmpItemList.size()) {
                    state = 3;
                    continue;
                }
                for (int i = 0; i < this.cmpItemList.size(); ++i) {
                    int size = ((CmpItemAccountEmpCollection)((Object)itemMap.get(((CmpItemInfo)this.cmpItemList.get(i)).getId().toString()))).size();
                    if (persons.size() == size) continue;
                    state = 3;
                    continue block0;
                }
            }
        } else {
            if (HRSchemeUtils.getHRToCompanyOrgUnitInfo(this.ctx, this.hrOrgID) == null) {
                state = 2;
                return state;
            }
            Map itemMap = this.getCmpAccountFromScheme(HRSchemeUtils.getHRToCompanyOrgUnitInfo(this.ctx, this.hrOrgID));
            List persons = this.getSchemePersons(HRSchemeUtils.getHRToCompanyOrgUnitInfo(this.ctx, this.hrOrgID));
            if (itemMap == null) {
                state = 4;
            } else {
                this.mapEmpAccount.put(this.hrOrgID, itemMap);
                if (itemMap.size() != this.cmpItemList.size()) {
                    state = 3;
                } else {
                    for (int i = 0; i < this.cmpItemList.size(); ++i) {
                        int size = ((CmpItemAccountEmpCollection)((Object)itemMap.get(((CmpItemInfo)this.cmpItemList.get(i)).getId().toString()))).size();
                        if (persons.size() == size) continue;
                        state = 3;
                        break;
                    }
                }
            }
        }
        return state;
    }

    public void convertToGrantBill() throws EASBizException, BOSException, SQLException {
        Iterator iter = this.mapEmpAccount.keySet().iterator();
        CompanyOrgUnitInfo infoCompany = new CompanyOrgUnitInfo();
        CmpItemInfo infoItem = null;
        CmpItemAccountEmpCollection itemAccountColl = null;
        while (iter.hasNext()) {
            String companyID = iter.next().toString();
            Map itemMap = (Map)this.mapEmpAccount.get(companyID);
            infoCompany.setId(BOSUuid.read((String)companyID));
            GrantInfo infoGrant = this.saveGrantInfo(infoCompany);
            int size = this.cmpItemList.size();
            for (int i = 0; i < size; ++i) {
                infoItem = (CmpItemInfo)this.cmpItemList.get(i);
                itemAccountColl = (CmpItemAccountEmpCollection)((Object)itemMap.get(infoItem.getId().toString()));
                this.setAssistantDetail(itemAccountColl, infoGrant, infoCompany.getId().toString());
            }
        }
    }

    public void setMapEmpAccount(Map mapEmpAccount) {
        this.mapEmpAccount = mapEmpAccount;
    }

    public void setCmpItemList(List cmpItemList) {
        this.cmpItemList = cmpItemList;
    }

    public Map getMapEmpAccount() {
        return this.mapEmpAccount;
    }

    public List getCmpItemList() {
        return this.cmpItemList;
    }

    private boolean isEmpAccountExist(String companyID) throws EASBizException, BOSException, SQLException {
        return true;
    }

    public List getSchemePersons(CompanyOrgUnitInfo infoCompany) throws BOSException, EASBizException {
        ArrayList<String> persons = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("select T.fpersonid from ").append(this.infoCmpScheme.getHorTableName());
        sb.append(" T INNER  JOIN T_BD_PERSON  PERSON ON PERSON.FID =  T.FPERSONID ");
        sb.append(" INNER  JOIN T_HR_PERSONCMP PERSONCMP ON PERSON.FID = PERSONCMP.FPersonID ");
        if (this.grantType != null && 1 == this.grantType.getValue()) {
            sb.append("\n where T.FADMINORGUNITID in(" + HRUtils.getSqlAdminByComp(infoCompany.getId().toString()) + ")");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        try {
            while (rowSet.next()) {
                persons.add(rowSet.getString("fpersonid"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rowSet);
        }
        return persons;
    }

    private void setNoAccountPersonName(HashMap noAccountPersonMap, CmpItemAccountEmpCollection empAccountColl, List persons) throws EASBizException, BOSException, SQLException {
        int i;
        HashSet<String> noAccountPersonIds = new HashSet<String>();
        ArrayList<String> accountPersonIds = new ArrayList<String>();
        String personId = null;
        if (empAccountColl == null) {
            this.setNoAccountPersonNameList(noAccountPersonMap, new HashSet(persons));
            return;
        }
        for (i = 0; i < empAccountColl.size(); ++i) {
            accountPersonIds.add(empAccountColl.get(i).getPerson().getId().toString());
        }
        for (i = 0; i < persons.size(); ++i) {
            personId = persons.get(i).toString();
            if (accountPersonIds.contains(personId)) continue;
            noAccountPersonIds.add(personId);
        }
        this.setNoAccountPersonNameList(noAccountPersonMap, noAccountPersonIds);
    }

    private void setNoAccountPersonNameList(HashMap noAccountPersonMap, Set noAccountPersonIds) throws EASBizException, BOSException, SQLException {
        StringBuffer personIds = new StringBuffer();
        Iterator it = noAccountPersonIds.iterator();
        while (it.hasNext()) {
            personIds.append("'").append(it.next()).append("',");
        }
        personIds.deleteCharAt(personIds.length() - 1);
        PersonCollection pCollection = PersonFactory.getLocalInstance((Context)this.ctx).getPersonCollection("select id,name where id in(" + personIds.toString() + ")");
        if (pCollection == null) {
            return;
        }
        for (PersonInfo pInfo : pCollection) {
            noAccountPersonMap.put(pInfo.getId().toString(), pInfo.getName());
        }
    }

    public int checkEmpAccountAndReturnNames(HashMap noAccountPersonMap) throws EASBizException, BOSException, SQLException {
        boolean noAccountPersonFlag = false;
        if (this.mapEmpAccount == null) {
            this.mapEmpAccount = new HashMap();
        } else {
            this.mapEmpAccount.clear();
        }
        int state = 0;
        this.cmpItemList = this.getSchemeCmpItem();
        if (this.cmpItemList.size() < 1) {
            state = 1;
            return state;
        }
        this.setGrantType();
        if (this.grantType != null && 1 == this.grantType.getValue()) {
            IRowSet rs = this.getCompanyByAdmin();
            String comId = null;
            if (rs == null || rs.size() == 0) {
                state = 2;
                return state;
            }
            CmpItemAccountEmpCollection empAccountColl = null;
            while (rs.next()) {
                comId = rs.getString("companyId");
                if (comId == null || "".equals(comId)) {
                    state = 2;
                    return state;
                }
                CompanyOrgUnitInfo infoCompany = new CompanyOrgUnitInfo();
                infoCompany.setId(BOSUuid.read((String)comId));
                Map itemMap = this.getCmpAccountFromScheme(infoCompany);
                List persons = this.getSchemePersons(infoCompany);
                if (itemMap == null && this.mapEmpAccount.size() > 0) {
                    this.setNoAccountPersonName(noAccountPersonMap, null, persons);
                    state = 3;
                    continue;
                }
                if (itemMap == null && this.mapEmpAccount.size() < 1) {
                    state = 4;
                    continue;
                }
                this.mapEmpAccount.put(comId, itemMap);
                if (itemMap.size() != this.cmpItemList.size()) {
                    this.setNoAccountPersonName(noAccountPersonMap, null, persons);
                    state = 3;
                    continue;
                }
                for (int i = 0; i < this.cmpItemList.size(); ++i) {
                    int size;
                    empAccountColl = (CmpItemAccountEmpCollection)((Object)itemMap.get(((CmpItemInfo)this.cmpItemList.get(i)).getId().toString()));
                    int n = size = empAccountColl == null ? 0 : empAccountColl.size();
                    if (persons.size() == size) continue;
                    state = 3;
                    this.setNoAccountPersonName(noAccountPersonMap, empAccountColl, persons);
                }
            }
        } else {
            if (HRSchemeUtils.getHRToCompanyOrgUnitInfo(this.ctx, this.hrOrgID) == null && !noAccountPersonFlag) {
                state = 2;
                return state;
            }
            Map itemMap = this.getCmpAccountFromScheme(HRSchemeUtils.getHRToCompanyOrgUnitInfo(this.ctx, this.hrOrgID));
            List persons = this.getSchemePersons(HRSchemeUtils.getHRToCompanyOrgUnitInfo(this.ctx, this.hrOrgID));
            if (itemMap == null) {
                state = 4;
            } else {
                this.mapEmpAccount.put(this.hrOrgID, itemMap);
                if (itemMap.size() != this.cmpItemList.size()) {
                    this.setNoAccountPersonName(noAccountPersonMap, null, persons);
                    state = 3;
                } else {
                    CmpItemAccountEmpCollection empAccountColl = null;
                    for (int i = 0; i < this.cmpItemList.size(); ++i) {
                        int size;
                        empAccountColl = (CmpItemAccountEmpCollection)((Object)itemMap.get(((CmpItemInfo)this.cmpItemList.get(i)).getId().toString()));
                        int n = size = empAccountColl == null ? 0 : empAccountColl.size();
                        if (persons.size() == size) continue;
                        state = 3;
                        this.setNoAccountPersonName(noAccountPersonMap, empAccountColl, persons);
                    }
                }
            }
        }
        return state;
    }
}

