/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Date;
import org.apache.log4j.Logger;

public class HRCmpIndexUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.util.HRCmpIndexUtils");
    public static final int length = 8;

    public static String getDateString() {
        return "" + new Date().getTime();
    }

    public static void createIndexForSCHM(Context ctx, String tableName) {
        String id = HRCmpIndexUtils.getDateString();
        String idxNameSuffix = id.substring(id.length() - 8, id.length() - 1);
        String idxName = null;
        IRowSet rows = null;
        StringBuffer sql = new StringBuffer("");
        try {
            idxName = "idx_SCHMR" + idxNameSuffix;
            sql = new StringBuffer();
            sql.append("select KSQL_INDNAME from KSQL_INDEXES where KSQL_INDNAME ='" + idxName.toUpperCase() + "' ");
            rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rows.size() <= 0) {
                sql = new StringBuffer();
                sql.append(" create INDEX " + idxName + " on " + tableName + "(FPERIOD) ");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        catch (BOSException e) {
            logger.info((Object)e.getMessage());
        }
        try {
            idxName = "idx_SCHMA" + idxNameSuffix;
            sql = new StringBuffer();
            sql.append(" select KSQL_INDNAME from KSQL_INDEXES where KSQL_INDNAME ='" + idxName.toUpperCase() + "' ");
            rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rows.size() <= 0) {
                sql = new StringBuffer();
                sql.append(" create INDEX " + idxName + " on " + tableName + "(FADMINORGUNITID) ");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        catch (BOSException e) {
            logger.info((Object)e.getMessage());
        }
        try {
            idxName = "idx_SCHMZ" + idxNameSuffix;
            sql = new StringBuffer();
            sql.append("select KSQL_INDNAME from KSQL_INDEXES where KSQL_INDNAME ='" + idxName.toUpperCase() + "' ");
            rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rows.size() <= 0) {
                sql = new StringBuffer();
                sql.append(" create INDEX " + idxName + " on " + tableName + "(FPOSITIONID) ");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        catch (BOSException e) {
            logger.info((Object)e.getMessage());
        }
        try {
            idxName = "idx_SCHMQ" + idxNameSuffix;
            sql = new StringBuffer();
            sql.append("select KSQL_INDNAME from KSQL_INDEXES where KSQL_INDNAME ='" + idxName.toUpperCase() + "' ");
            rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rows.size() <= 0) {
                sql = new StringBuffer();
                sql.append(" create INDEX " + idxName + " on " + tableName + "(FPERSONID,FPERIOD,FTIME,FADMINORGUNITID,FPOSITIONID) ");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        catch (BOSException e) {
            logger.info((Object)e.getMessage());
        }
        try {
            if (!HRCmpIndexUtils.isExistSameIndex(ctx, HRCmpIndexUtils.getDynamicTableUniqueIndexName(tableName, "M"))) {
                sql = new StringBuffer();
                sql.append(" CREATE UNIQUE INDEX " + HRCmpIndexUtils.getDynamicTableUniqueIndexName(tableName, "M") + " ON " + tableName + "(FPersonID)");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        catch (BOSException e) {
            logger.info((Object)e.getMessage());
        }
    }

    public static void createIndexForSCHMHIS(Context ctx, String tableName) {
        String id = HRCmpIndexUtils.getDateString();
        String idxNameSuffix = id.substring(id.length() - 8, id.length() - 1);
        String idxName = null;
        IRowSet rows = null;
        StringBuffer sql = new StringBuffer("");
        try {
            idxName = "idx_SHISR" + idxNameSuffix;
            sql = new StringBuffer();
            sql.append("select * from KSQL_INDEXES where KSQL_INDNAME ='" + idxName.toUpperCase() + "' ");
            rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rows.size() <= 0) {
                sql = new StringBuffer();
                sql.append(" create INDEX " + idxName + " on " + tableName + "(FPERIOD) ");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        catch (BOSException e) {
            logger.info((Object)e.getMessage());
        }
        try {
            idxName = "idx_SHISA" + idxNameSuffix;
            sql = new StringBuffer();
            sql.append("select * from KSQL_INDEXES where KSQL_INDNAME ='" + idxName.toUpperCase() + "' ");
            rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rows.size() <= 0) {
                sql = new StringBuffer();
                sql.append(" create INDEX " + idxName + " on " + tableName + "(FADMINORGUNITID) ");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        catch (BOSException e) {
            logger.info((Object)e.getMessage());
        }
        try {
            idxName = "idx_SHISZ" + idxNameSuffix;
            sql = new StringBuffer();
            sql.append("select * from KSQL_INDEXES where KSQL_INDNAME ='" + idxName.toUpperCase() + "' ");
            rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rows.size() <= 0) {
                sql = new StringBuffer();
                sql.append(" create INDEX " + idxName + " on " + tableName + "(FPOSITIONID) ");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        catch (BOSException e) {
            logger.info((Object)e.getMessage());
        }
        try {
            idxName = "idx_SHISQ" + idxNameSuffix;
            sql = new StringBuffer();
            sql.append("select * from KSQL_INDEXES where KSQL_INDNAME ='" + idxName.toUpperCase() + "' ");
            rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rows.size() <= 0) {
                sql = new StringBuffer();
                sql.append(" create INDEX " + idxName + " on " + tableName + "(FPERSONID,FPERIOD,FTIME,FADMINORGUNITID,FPOSITIONID) ");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        catch (BOSException e) {
            logger.info((Object)e.getMessage());
        }
        try {
            if (!HRCmpIndexUtils.isExistSameIndex(ctx, HRCmpIndexUtils.getDynamicTableUniqueIndexName(tableName, "M"))) {
                sql = new StringBuffer();
                sql.append(" CREATE UNIQUE INDEX " + HRCmpIndexUtils.getDynamicTableUniqueIndexName(tableName, "M") + " ON " + tableName + "(FPeriod,FTIME,FPersonID)");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        catch (BOSException e) {
            logger.info((Object)e.getMessage());
        }
    }

    public static void createIndexFor(Context ctx, String tableName, boolean isHis) {
        if (isHis) {
            HRCmpIndexUtils.createIndexForSCHMHIS(ctx, tableName);
        } else {
            HRCmpIndexUtils.createIndexForSCHM(ctx, tableName);
        }
    }

    public static String getDynamicTableUniqueIndexName(String strTableName, String excludeCharacter) {
        if (strTableName == null || strTableName.equals("")) {
            return null;
        }
        if (excludeCharacter != null) {
            strTableName = strTableName.replaceFirst(excludeCharacter, "");
        }
        String strIndexName = null;
        int tableNameLength = strTableName.length();
        strIndexName = tableNameLength <= 17 ? "UX" + strTableName.substring(1, tableNameLength) : "UX" + strTableName.substring(1, 17);
        return strIndexName;
    }

    public static boolean isExistSameIndex(Context ctx, String strIndexName) throws BOSException {
        if (strIndexName == null) {
            return true;
        }
        String sqlIndex = "select * from KSQL_INDEXES where KSQL_INDNAME ='" + strIndexName + "'";
        IRowSet rsIndex = DbUtil.executeQuery((Context)ctx, (String)sqlIndex);
        return rsIndex.size() > 0;
    }
}

