/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class PersonHisByOrgRangeUtil {
    public static Logger log = Logger.getLogger(PersonHisByOrgRangeUtil.class);
    public static String tableName;

    public static ICmpScheme getBizCmpSchInterface(Context ctx) throws BOSException {
        return CmpSchemeFactory.getLocalInstance(ctx);
    }

    public static boolean isHisCmpPeriod(Context ctx, String cmpPeriodID, IObjectPK cmpSchemePK) throws BOSException, EASBizException {
        ICmpScheme iCmpScheme = PersonHisByOrgRangeUtil.getBizCmpSchInterface(ctx);
        CmpSchemeInfo cmpSchemeInfo = iCmpScheme.getCmpSchemeInfo(cmpSchemePK);
        boolean isHistoryCmp = false;
        if (cmpPeriodID.equals(cmpSchemeInfo.getCmpPeriod().getId().toString())) {
            tableName = cmpSchemeInfo.getHorTableName();
        } else {
            tableName = cmpSchemeInfo.getHisTableName();
            isHistoryCmp = true;
        }
        return isHistoryCmp;
    }

    public static boolean isConHisCmpPeriod(Context ctx, CmpPeriodCollection cmpPeriodColl, IObjectPK cmpSchemePK) throws BOSException, EASBizException {
        HashMap<String, String> cmpPeriodIdMap = new HashMap<String, String>();
        int size = cmpPeriodColl.size();
        for (int i = 0; i < size; ++i) {
            cmpPeriodIdMap.put(cmpPeriodColl.get(i).getId().toString(), "");
        }
        ICmpScheme iCmpScheme = PersonHisByOrgRangeUtil.getBizCmpSchInterface(ctx);
        CmpSchemeInfo cmpSchemeInfo = iCmpScheme.getCmpSchemeInfo(cmpSchemePK);
        boolean isHistoryCmp = false;
        if (cmpPeriodIdMap.size() == 1 && cmpPeriodIdMap.containsKey(cmpSchemeInfo.getCmpPeriod().getId().toString())) {
            isHistoryCmp = true;
        }
        return isHistoryCmp;
    }

    public static boolean[] isConCurCmpPeriod(Context ctx, CmpPeriodCollection cmpPeriodColl, IObjectPK cmpSchemePK) throws BOSException, EASBizException {
        boolean[] isCurCmp = new boolean[]{false, false};
        HashSet<String> cmpPeriodIdSet = new HashSet<String>();
        int size = cmpPeriodColl.size();
        for (int i = 0; i < size; ++i) {
            cmpPeriodIdSet.add(cmpPeriodColl.get(i).getId().toString());
        }
        ICmpScheme iCmpScheme = PersonHisByOrgRangeUtil.getBizCmpSchInterface(ctx);
        SelectorItemCollection cmpSchemeSelector = new SelectorItemCollection();
        cmpSchemeSelector.add(new SelectorItemInfo("id"));
        cmpSchemeSelector.add(new SelectorItemInfo("cmpPeriod.id"));
        CmpSchemeInfo cmpSchemeInfo = iCmpScheme.getCmpSchemeInfo(cmpSchemePK, cmpSchemeSelector);
        if (cmpPeriodIdSet.contains(cmpSchemeInfo.getCmpPeriod().getId().toString())) {
            isCurCmp[0] = true;
            if (cmpPeriodIdSet.size() == 1) {
                isCurCmp[1] = true;
            }
        }
        return isCurCmp;
    }

    public static String getSql(Context ctx, boolean isContainsPerInfo, String strCmpScheme, List list) throws BOSException, EASBizException {
        ICmpScheme iCmpScheme = PersonHisByOrgRangeUtil.getBizCmpSchInterface(ctx);
        CmpSchemeInfo cmpSchemeInfo = iCmpScheme.getCmpSchemeInfo((IObjectPK)new ObjectUuidPK(strCmpScheme));
        String language = ctx.getLocale().getLanguage();
        StringBuffer str = new StringBuffer("select DISTINCT TT.fpersonid ");
        if (isContainsPerInfo) {
            str.append(", per.fname_").append(language).append(" ").append("FPER001").append(", per.fidcardno ").append("FPER023").append(", per.fnumber ").append("FPER002").append(", admin.fname_").append(language).append(" ").append("FPER005").append(", position.fname_").append(language).append(" ").append("FPER006").append(" from ");
        } else {
            str.append("from ");
        }
        str.append(cmpSchemeInfo.getHisTableName());
        str.append(" TT left outer join T_ORG_Admin admin on TT.fadminOrgunitid = admin.fid ");
        if (isContainsPerInfo) {
            str.append(" left outer join T_bd_person per on TT.fpersonid = per.fid ");
            str.append(" left outer join T_org_position position on TT.fpositionid = position.fid ");
        }
        str.append(" left outer join T_hr_cmpperiod cmpperiod on TT.FPeriod = cmpperiod.fid ");
        str.append(" left outer join T_PM_OrgRange orgRange on orgRange.FOrgID = admin.fid ");
        str.append(" left outer join T_PM_User myuser on orgRange.FUserID = myuser.fid ");
        str.append(" where orgRange.FType = 20 and myuser.FID ='");
        str.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        str.append("' and cmpperiod.fid in");
        str.append(CompUtils.getStrFromList(list));
        return str.toString();
    }

    public static String getHisSql(Context ctx, String hisTableName) {
        StringBuffer str = new StringBuffer("select DISTINCT TT.* from ");
        str.append(hisTableName);
        str.append(" TT left outer join T_ORG_Admin admin on TT.fadminOrgunitid = admin.fid ");
        str.append(" left outer join T_PM_OrgRange orgRange on orgRange.FOrgID = admin.fid ");
        str.append(" left outer join T_PM_User myuser on orgRange.FUserID = myuser.fid ");
        str.append(" where orgRange.FType = 20 and myuser.FID ='");
        str.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        str.append("'");
        return str.toString();
    }
}

