/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util.syn;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeItemInfo;
import com.kingdee.eas.hr.compensation.ICmpSchemeItem;
import com.kingdee.eas.hr.compensation.exception.CommonSalaryException;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.compensation.util.syn.DomWRUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SynCmpCalResultData {
    public static final String tableName = "T_HR_SCHM_SummaryRecord";
    private Map<String, String> cmpItemMap = null;

    private Map<String, String> getAllCmpItem_EAS_SQL(String sql, Context ctx) throws BOSException, SQLException {
        HashMap<String, String> cmpItemMap = new HashMap<String, String>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            String fnumber = rs.getString("fnumber");
            cmpItemMap.put(fnumber, rs.getString("fname"));
        }
        return cmpItemMap;
    }

    public String createCalResultTable(Context ctx) throws BOSException, SQLException {
        StringBuffer sqlCreate = new StringBuffer("CREATE TABLE");
        sqlCreate.append(" ").append(tableName).append(" (FPersonID VARCHAR (44) NOT NULL,");
        sqlCreate.append(" FPERIOD VARCHAR (44) NOT NULL, ");
        sqlCreate.append(" FTIME INT NOT NULL, ");
        sqlCreate.append(" FADMINORGUNITID VARCHAR (44) NOT NULL, ");
        sqlCreate.append(" FPOSITIONID VARCHAR (44) NULL, ");
        sqlCreate.append(" FCalType INT NULL, ");
        sqlCreate.append(" FPERIODNumber VARCHAR (80) NULL, ");
        sqlCreate.append(" FADMINORGUNITName VARCHAR (255) NULL, ");
        sqlCreate.append(" FPOSITIOName VARCHAR (255) NULL, ");
        String l = HRUtils.getShortCode(ctx);
        String getAllCmpItem_EAS_SQL = "select distinct fnumber,fname_" + l + " AS fname from t_hr_cmpItem where FNumber not like 'FPER%' and FNumber!='FSAL000' order by fnumber";
        this.cmpItemMap = this.getAllCmpItem_EAS_SQL(getAllCmpItem_EAS_SQL, ctx);
        Set<Map.Entry<String, String>> set = this.cmpItemMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String fnumber = entry.getKey();
            sqlCreate.append(" ").append(fnumber).append("  VARCHAR (44) NULL , ");
        }
        sqlCreate.append(" FID VARCHAR(135) DEFAULT '' NOT NULL ,CONSTRAINT PK_HR_SCmpCalResult PRIMARY KEY (FID)");
        sqlCreate.append(")");
        DbUtil.execute((Context)ctx, (String)sqlCreate.toString());
        return null;
    }

    private void insertValueToCalResultTable(Context ctx) throws BOSException, SQLException {
        CmpSchemeCollection coll = CmpSchemeFactory.getLocalInstance(ctx).getCmpSchemeCollection(" where histableName is not null");
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            String histableName = coll.get(i).getHisTableName();
            String cmpSchemeId = coll.get(i).getId().toString();
            StringBuffer select_sql = new StringBuffer();
            StringBuffer cmpItem = new StringBuffer();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)coll.get(i).getId().toString()));
            evi.setFilter(filterInfo);
            evi.getSelector().add(new SelectorItemInfo("*"));
            evi.getSelector().add(new SelectorItemInfo("cmpItem.*"));
            SorterItemInfo sorterOrderItem = new SorterItemInfo("id");
            sorterOrderItem.setSortType(SortType.ASCEND);
            evi.getSorter().add(sorterOrderItem);
            ICmpSchemeItem iCmpSchemeItem = CmpSchemeItemFactory.getLocalInstance(ctx);
            CmpSchemeItemCollection col = iCmpSchemeItem.getCmpSchemeItemCollection(evi);
            if (col != null && col.size() > 0) {
                Iterator itr = col.iterator();
                CmpSchemeItemInfo info = null;
                CmpItemInfo infoCmpItem = null;
                while (itr.hasNext()) {
                    info = (CmpSchemeItemInfo)itr.next();
                    infoCmpItem = info.getCmpItem();
                    if (infoCmpItem == null || infoCmpItem.getNumber() == null || "FSAL000".equalsIgnoreCase(infoCmpItem.getNumber()) || infoCmpItem.getNumber().substring(0, 4).equalsIgnoreCase("FPer")) continue;
                    cmpItem.append(infoCmpItem.getNumber()).append(",");
                }
                cmpItem.deleteCharAt(cmpItem.length() - 1);
            }
            String l = HRUtils.getShortCode(ctx);
            StringBuffer insertSqlBf = new StringBuffer();
            insertSqlBf.append("insert into ").append(tableName).append(" (fid,FPersonID,FPERIOD,FTIME,FADMINORGUNITID,FPOSITIONID,FCalType,FPERIODNumber,FADMINORGUNITName,FPOSITIOName,").append(cmpItem).append(") ").append("select ").append("FPersonID||FPERIOD||FTIME||'" + cmpSchemeId).append("', FPersonID,FPERIOD,FTIME,tempTab.fadminOrgUnitId,tempTab.FpositionId,FCalType,period.fnumber,orgAdmin.fname_" + l + ",position.fname_" + l + ",").append(cmpItem).append(" from ").append(histableName).append(" AS tempTab  left join t_org_admin orgAdmin on orgAdmin.fid=tempTab.fadminOrgUnitId  left join T_ORG_Position position on position.fid=tempTab.FpositionId  left join t_hr_cmpperiod period on period.fid=tempTab.FPERIOD  where NOT EXISTS (select 1 from T_HR_SCHM_SummaryRecord where fid=tempTab.FPersonID||tempTab.FPERIOD||tempTab.FTIME||'" + cmpSchemeId + "')");
            DbUtil.execute((Context)ctx, (String)insertSqlBf.toString());
        }
    }

    private boolean isAlreadyInDB(Context ctx, String fid) throws BOSException, SQLException {
        String existSql = "select count(fid) from T_HR_SCHM_SummaryRecord where fid='" + fid + "'";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)existSql.toString());
        while (rowSet1.next()) {
            if (rowSet1.getInt(1) <= 0) continue;
            return true;
        }
        return false;
    }

    private void addConfigColumn(Context ctx) throws BOSException {
        Map<Object, Object> map = new HashMap();
        try {
            Class<?> c = Class.forName("com.kingdee.shr.compensation.app.syn.DomWRUtil");
            DomWRUtil domWRUtil = (DomWRUtil)c.newInstance();
            map = domWRUtil.getOldItemIdToItemId_info();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        String[] column_prefix_S = null;
        try {
            column_prefix_S = this.getColumnName_preCharS(ctx);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        Set<Map.Entry<Object, Object>> entry = map.entrySet();
        Iterator<Map.Entry<Object, Object>> ite = entry.iterator();
        StringBuffer alertSql = new StringBuffer();
        while (ite.hasNext()) {
            Map.Entry<Object, Object> eachentry = ite.next();
            String oldItemId = (String)eachentry.getKey();
            String itemId = (String)eachentry.getValue();
            if (!"".equals(itemId)) {
                alertSql.append("If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='" + itemId + "' and KSQL_COL_TABNAME='" + tableName + "') ").append("alter table T_HR_SCHM_SummaryRecord  add " + itemId + " VARCHAR(44) NULL;");
                DbUtil.execute((Context)ctx, (String)alertSql.toString());
                alertSql.delete(0, alertSql.length());
                alertSql.append("update T_HR_SCHM_SummaryRecord set ").append(itemId).append(" = ").append(oldItemId);
                DbUtil.execute((Context)ctx, (String)alertSql.toString());
            }
            if (alertSql.length() == 0) continue;
            alertSql.delete(0, alertSql.length());
        }
        for (String scolumn : column_prefix_S) {
            String dropColumnSql = "alter table T_HR_SCHM_SummaryRecord drop column ";
            if (map.containsValue(scolumn)) continue;
            dropColumnSql = dropColumnSql + scolumn;
            DbUtil.execute((Context)ctx, (String)dropColumnSql.toString());
        }
    }

    private String[] getColumnName_preCharS(Context ctx) throws BOSException, SQLException {
        String sql = "select KSQL_COL_NAME from KSQL_USERCOLUMNS where KSQL_COL_NAME like 'S%' and KSQL_COL_TABNAME='T_HR_SCHM_SummaryRecord'";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql);
        StringBuffer bb = new StringBuffer();
        while (rowSet1.next()) {
            bb.append(rowSet1.getString("KSQL_COL_NAME")).append(",");
        }
        if (bb.length() != 0) {
            bb.deleteCharAt(bb.length() - 1);
        }
        return bb.toString().split(",");
    }

    public int syn(Context ctx) throws BOSException {
        try {
            if (!this.isExistTableInDB(ctx)) {
                this.createCalResultTable(ctx);
            } else {
                this.alertCalResultTable(ctx);
            }
            this.insertValueToCalResultTable(ctx);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        catch (BOSException e) {
            throw new BOSException(e.getMessage());
        }
        return 1;
    }

    public boolean isExistTableInDB(Context ctx) throws BOSException, SQLException {
        String sql = "select count(*) from KSQL_USERTABLES where KSQL_TABNAME ='T_HR_SCHM_SummaryRecord'";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rowSet1.next()) {
            if (rowSet1.getInt(1) <= 0) continue;
            return true;
        }
        return false;
    }

    public void insertValueTo_t_hr_scmpcaltable(Context ctx) throws Exception {
        this.sysPeriodId(ctx);
        Map<String, String> map_OldNumberToS = this.getOldNumberToSByConfxml(ctx);
        Set<Map.Entry<String, String>> map_entry = map_OldNumberToS.entrySet();
        Iterator<Map.Entry<String, String>> iter = map_entry.iterator();
        StringBuffer cmpItem_S = new StringBuffer();
        StringBuffer cmpItem_oldNum = new StringBuffer();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            cmpItem_oldNum.append(",").append(entry.getKey());
            cmpItem_S.append(",").append(entry.getValue());
        }
        StringBuffer insertSqlBf = new StringBuffer();
        insertSqlBf.append("insert into ").append("t_hr_scmpcaltable").append(" ( fid,fpersonid,fcmpperiodid,fperiodYear,FperiodMonth,fIsCal,FisAudit,Fisgive,fadminOrgunitid,fpositionId,fcalTime,FlongNumber,FoldEasId").append(cmpItem_S).append(") ").append("select newbosid('7B19597F'),FPersonID,newperiod.fid,period.fcmpperiodyear,period.fcmpperiod as FperiodMonth,'Y','Y','Y',fadminOrgUnitid,fpositionId,ftime,orgAdmin.flongNumber,tempTab.fid").append(cmpItem_oldNum).append(" from ").append(tableName).append(" AS tempTab  left join t_org_admin orgAdmin on orgAdmin.fid=tempTab.fadminOrgUnitId  left join t_hr_cmpperiod period on period.fid=tempTab.FPERIOD  left join t_hr_scmpperiod newperiod on newperiod.FoldPeriodId=tempTab.FPERIOD  where NOT EXISTS (select 1 from t_hr_scmpcaltable where foldEasId=tempTab.Fid)");
        DbUtil.execute((Context)ctx, (String)insertSqlBf.toString());
    }

    public Map<String, String> getOldNumberToSByConfxml(Context ctx) throws BOSException, ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        Class<?> c = Class.forName("com.kingdee.eas.hr.compensation.util.syn.DomWRUtil");
        DomWRUtil domWRUtil = (DomWRUtil)c.newInstance();
        Map<String, String> map_oldNumberToNewNumber = domWRUtil.getOldItemIdToItemId_info();
        HashMap<String, String> map_newNumberToS = new HashMap<String, String>();
        HashMap<String, String> map_OldNumberToS = new HashMap<String, String>();
        if (map_oldNumberToNewNumber.size() == 0) {
            throw new BOSException((Throwable)((Object)new CommonSalaryException(CommonSalaryException.EXCEPTION1)));
        }
        String sql = "select Fnumber,fieldsn from t_hr_scmpItem";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rowSet1.next()) {
            String key = rowSet1.getString("Fnumber");
            String value = "S" + rowSet1.getInt("fieldsn");
            map_newNumberToS.put(key, value);
        }
        Set<String> set = map_oldNumberToNewNumber.keySet();
        Iterator<String> ite = set.iterator();
        String oldNum = null;
        String newNum = null;
        while (ite.hasNext()) {
            oldNum = ite.next();
            newNum = map_oldNumberToNewNumber.get(oldNum);
            if (map_newNumberToS.containsKey(newNum)) {
                map_OldNumberToS.put(oldNum, (String)map_newNumberToS.get(newNum));
                continue;
            }
            if ("".equals(newNum)) continue;
            throw new BOSException((Throwable)((Object)new CommonSalaryException(CommonSalaryException.EXCEPTION2, new Object[]{newNum})));
        }
        return map_OldNumberToS;
    }

    public void sysPeriodId(Context ctx) throws BOSException, SQLException {
        String judgeDubPeriod = "select  FHROrgUnitID,fnumber,count(fnumber) from t_hr_scmpperiod group by FHROrgUnitID,fnumber having  count(fnumber) >1";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)judgeDubPeriod);
        if (rowSet1.next()) {
            throw new BOSException((Throwable)((Object)new CommonSalaryException(CommonSalaryException.EXCEPTION3)));
        }
        String sql = "update t_hr_scmpperiod  set FoldPeriodId =(select t2.fid from  t_hr_cmpperiod  t2 where  t_hr_scmpperiod.fnumber=concat(t2.fnumber,'_M') and t_hr_scmpperiod.FHrorgUnitId=t2.FHrorgUnitID)";
        DbUtil.execute((Context)ctx, (String)sql.toString());
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into t_hr_scmpperiod(fid,fbegindate,fenddate,fenable,FHROrgUnitID,FPEndInputClose,FCmpPeriodYear,fNumber,FoldPeriodId) select newbosid('ACF73A45'),FBeginDate,FEndDate,Fenable,FHROrgUnitID,FPEndInputClose,FCmpPeriodYear,concat(fNumber,'_M'),fid from t_hr_cmpperiod");
        insertSql.append(" where NOT EXISTS (select 1 from t_hr_scmpperiod where t_hr_scmpperiod.fNumber=concat(t_hr_cmpperiod.fnumber,'_M') and t_hr_scmpperiod.FHrorgUnitId=t_hr_cmpperiod.FHrorgUnitID)");
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
    }

    public void alertCalResultTable(Context ctx) throws BOSException, SQLException {
        String sql = "select KSQL_COL_NAME from KSQL_USERCOLUMNS where  KSQL_COL_TABNAME='T_HR_SCHM_SummaryRecord'";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> list = new ArrayList<String>();
        while (rowSet1.next()) {
            list.add(rowSet1.getString("KSQL_COL_NAME"));
        }
        String l = HRUtils.getShortCode(ctx);
        String getAllCmpItem_EAS_SQL = "select distinct fnumber,fname_" + l + " AS fname from t_hr_cmpItem where FNumber not like 'FPER%' and FNumber!='FSAL000' order by fnumber";
        Map<String, String> cmpItemMap = this.getAllCmpItem_EAS_SQL(getAllCmpItem_EAS_SQL, ctx);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            cmpItemMap.remove(list.get(i));
        }
        Set<Map.Entry<String, String>> set = cmpItemMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String fnumber = entry.getKey();
            StringBuffer alertSql = new StringBuffer();
            alertSql.append("If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='" + fnumber + "' and KSQL_COL_TABNAME='" + tableName + "') ").append("alter table T_HR_SCHM_SummaryRecord  add " + fnumber + " VARCHAR(44) NULL;");
            DbUtil.execute((Context)ctx, (String)alertSql.toString());
        }
    }
}

