/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.AdminF7;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.hr.base.CodingRuleManageFacadeFactory;
import com.kingdee.eas.hr.base.ICodingRuleManageFacade;
import com.kingdee.eas.hr.base.client.f7.EditorCreator;
import com.kingdee.eas.hr.base.util.CodingRuleData;
import com.kingdee.eas.hr.contract.ContractChangeBizBillEntryInfo;
import com.kingdee.eas.hr.contract.client.ContractBillEditUIBiz;
import com.kingdee.eas.hr.contract.client.EmployeeContractF7PromptBox;
import com.kingdee.eas.hr.contract.util.ContractUtils;
import com.kingdee.eas.hr.emp.ContractLimitTypeEnum;
import com.kingdee.eas.hr.emp.ContractTypeFactory;
import com.kingdee.eas.hr.emp.ContractTypeInfo;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.org.client.AllAdminPromptBox;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class ContractChangeBizBillEditUIBiz
extends ContractBillEditUIBiz {
    private int activeRowIndex = -1;
    private IRow activeRow = null;
    boolean isZTCustomer = false;
    String contractOrgRange = null;
    private boolean isFirstOnLoad = true;

    @Override
    public void afterOnLoad() throws Exception {
        super.afterOnLoad();
        int rowCount = this.kdtEntrys.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.activeRow = this.kdtEntrys.getRow(i);
            Boolean isInAdmin = (Boolean)this.activeRow.getCell("isInAdmin").getValue();
            this.changeToUnitEditor(isInAdmin);
            ContractTypeInfo contractType = (ContractTypeInfo)this.activeRow.getCell("contractType").getValue();
            this.setContractTempletF7(this.activeRow, contractType.getId().toString());
            this.setContinuousSignedState(this.activeRow, contractType.getId().toString());
        }
    }

    protected IObjectValue createNewDetailData(PersonInfo pInfo) {
        ContractChangeBizBillEntryInfo entry = new ContractChangeBizBillEntryInfo();
        entry.setPerson(pInfo);
        if (pInfo.get("empContract") != null) {
            EmployeeContractInfo empContract = (EmployeeContractInfo)pInfo.get("empContract");
            AdminOrgUnitInfo admin = null;
            ContractTypeInfo cType = null;
            try {
                admin = PersonFactory.getRemoteInstance().getPrimaryAdminOrgUnit(pInfo.getId());
                cType = ContractTypeFactory.getRemoteInstance().getContractTypeInfo((IObjectPK)new ObjectUuidPK(empContract.getContractTemplet().getContractType().getId()));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            entry.setToUnit(empContract.getToUnit());
            entry.setIsInAdmin(empContract.isIsInAdmin());
            entry.setDelegatePerson(empContract.getDelegatePerson());
            entry.setToUnitAddress(empContract.getToUnitAddress());
            entry.setIdCardNo(empContract.getEmpIdentityNum());
            entry.setPassportNo(empContract.getEmpPassPortNum());
            entry.setAdminOrg(admin);
            entry.setAddress(empContract.getEmpAddress());
            entry.setThirdUnit(empContract.getThirdUnitName());
            entry.setThirdDelegatePerson(empContract.getThirdDelegatePerson());
            entry.setThirdUnitAddress(empContract.getThirdUnitAddress());
            entry.setContractNo(empContract.getContractNo());
            entry.setContractType(cType);
            entry.setContractTemplet(empContract.getContractTemplet());
            entry.setContractLimitType(empContract.getContractLimitType());
            entry.setBizDate(empContract.getEffectDate());
            entry.setEndDate(empContract.getEndDate());
            entry.setTestBeginDate(empContract.getTestBeginDate());
            entry.setTestEndDate(empContract.getTestEndDate());
            if (empContract.getContractLimitAuto() != null) {
                entry.setContractLimit(empContract.getContractLimitAuto().toString());
            }
            entry.setContractServerLimit(empContract.getContSerLimit());
            entry.setPenalty(empContract.getPenalty());
            entry.setCompensation(empContract.getCompensation());
            entry.setAppraisal(empContract.getAppraisal());
            entry.setAppraDate(empContract.getAppraDate());
            entry.setIsContinuousSigned(empContract.isIsContinuousSigned());
            entry.setContinuousSignedCount(empContract.getContinuousSignedCount());
            entry.setChangeReason(empContract.getReason());
            entry.setDescription(empContract.getDescription());
            entry.setSourceContract(empContract);
            try {
                if (entry != null) {
                    EmployeeContractInfo contractInfo = new EmployeeContractInfo();
                    Context mainOrgContext = this.ctx.getMainOrgContext();
                    CtrlUnitInfo ctrlUnitInfo = FrameWorkUtils.getCurrentCtrlUnit((Context)mainOrgContext);
                    if (StringUtils.isEmpty((String)ctrlUnitInfo.getName()) || StringUtils.isEmpty((String)ctrlUnitInfo.getNumber())) {
                        String oql = "SELECT id, name, number WHERE id = '" + ctrlUnitInfo.getId().toString() + "'";
                        CtrlUnitInfo tmpInfo = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo(oql);
                        ctrlUnitInfo.setName(tmpInfo.getName());
                        ctrlUnitInfo.setNumber(tmpInfo.getNumber());
                    }
                    contractInfo.setCU(ctrlUnitInfo);
                    contractInfo.setEmployee(entry.getPerson());
                    contractInfo.setContractTemplet(entry.getContractTemplet());
                    ICodingRuleManageFacade icrmFacade = CodingRuleManageFacadeFactory.getRemoteInstanceWithObjectContext((Context)mainOrgContext);
                    CodingRuleData codingRuleData = icrmFacade.getCodingRuleData((IObjectValue)contractInfo, this.getCurrentHRO().getId().toString());
                    if (codingRuleData.isExistRule()) {
                        entry.setContractNo(codingRuleData.getNumber());
                        if (!codingRuleData.isModifable()) {
                            this.kdtEntrys.getColumn("contractNo").getStyleAttributes().setLocked(true);
                            this.kdtEntrys.getColumn("contractNo").getStyleAttributes().setBackground(this.CANNOT_INPUT_COLOR);
                        }
                    } else {
                        this.kdtEntrys.getColumn("contractNo").getStyleAttributes().setLocked(false);
                        this.kdtEntrys.getColumn("contractNo").getStyleAttributes().setBackground(this.MUST_INPUT_COLOR);
                    }
                }
                admin = PersonFactory.getRemoteInstance().getPrimaryAdminOrgUnit(pInfo.getId());
                cType = ContractTypeFactory.getRemoteInstance().getContractTypeInfo((IObjectPK)new ObjectUuidPK(empContract.getContractTemplet().getContractType().getId()));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return entry;
    }

    protected void initEditor() throws Exception {
        super.initEditor();
        String[] date = new String[]{"bizDate", "endDate", "testBeginDate", "testEndDate", "appraDate", "signDate", "freeDate"};
        this.setDateFormat(date);
        this.setPenaltyEditor();
        this.setContractServerLimitEditor();
        this.isZTCustomer = EmployeeContractFactory.getRemoteInstance().isZhongTianCustomer();
        this.contractOrgRange = ParamManager.getParamValue(null, (IObjectPK)new ObjectUuidPK(this.getCurrentHRO().getId()), (String)"IS_CONTRACT_002");
        this.setDelegatePersonRange();
    }

    private void setDateFormat(String[] date) {
        int size = date.length;
        for (int i = 0; i < size; ++i) {
            this.kdtEntrys.getColumn(date[i]).setEditor(EditorCreator.getDateCellEditor());
            String format = CtrlFormatUtilities.getDateFormatString();
            this.kdtEntrys.getColumn(date[i]).getStyleAttributes().setNumberFormat(format);
        }
    }

    private void setPenaltyEditor() {
        KDFormattedTextField txtPenalty = new KDFormattedTextField();
        txtPenalty.setDataType(BigDecimal.class);
        txtPenalty.setPrecision(2);
        this.kdtEntrys.getColumn("penalty").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtPenalty));
        KDFormattedTextField compensation = new KDFormattedTextField();
        compensation.setDataType(BigDecimal.class);
        compensation.setPrecision(2);
        this.kdtEntrys.getColumn("compensation").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)compensation));
    }

    private void setContractServerLimitEditor() {
        KDBizPromptBox prmtContractServerLimit = new KDBizPromptBox();
        prmtContractServerLimit.setQueryInfo("com.kingdee.eas.hr.emp.app.ContractServerLimitQuery");
        prmtContractServerLimit.setEnabledMultiSelection(false);
        prmtContractServerLimit.setEditable(false);
        this.kdtEntrys.getColumn("contractServerLimit").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtContractServerLimit));
    }

    private void setContractLimitTypeEditor(IRow row) {
        KDComboBox cboContractLimitType = new KDComboBox();
        this.activeRow = row;
        cboContractLimitType.addItems(ContractLimitTypeEnum.getEnumList().toArray());
        this.activeRow.getCell("contractLimitType").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cboContractLimitType));
        this.activeRowIndex = row.getRowIndex();
        cboContractLimitType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ContractChangeBizBillEditUIBiz.this.contractLimitChange();
            }
        });
    }

    private void contractLimitChange() {
        boolean isEditable = false;
        boolean isRequired = false;
        if (this.activeRowIndex < 0) {
            return;
        }
        this.kdtEntrys.getColumn("endDate").setRequired(false);
        this.activeRow = this.kdtEntrys.getRow(this.activeRowIndex);
        ICell cellEndDate = this.activeRow.getCell("endDate");
        ICell cellContractLimit = this.activeRow.getCell("contractLimit");
        ContractLimitTypeEnum contractLimitType = (ContractLimitTypeEnum)this.activeRow.getCell("contractLimitType").getValue();
        if (ContractLimitTypeEnum.FIXED_LIMIT.equals((Object)contractLimitType)) {
            cellEndDate.getStyleAttributes().setBackground(ContractUtils.MUSTINPUT_BGCOLOR);
            cellEndDate.getStyleAttributes().setLocked(false);
            this.fixContractLimit(this.activeRowIndex);
            isRequired = true;
            isEditable = true;
        } else if (ContractLimitTypeEnum.NO_FIXED_LIMIT.equals((Object)contractLimitType)) {
            cellEndDate.getStyleAttributes().setBackground(null);
            cellEndDate.getStyleAttributes().setLocked(true);
            cellEndDate.setValue(null);
            cellContractLimit.setValue(null);
            isEditable = false;
        } else if (ContractLimitTypeEnum.COMPLETE_WORK_TYPE.equals((Object)contractLimitType)) {
            cellEndDate.getStyleAttributes().setBackground(null);
            cellEndDate.getStyleAttributes().setLocked(false);
            cellContractLimit.setValue(null);
            isEditable = true;
        }
        if (this.rowEditor != null) {
            this.rowEditor.setRequired("endDate", isRequired);
            this.rowEditor.setEditable("endDate", isEditable);
        }
    }

    private void fixContractLimit(int activeRowIndex) {
        this.activeRow = this.kdtEntrys.getRow(activeRowIndex);
        this.activeRow.getCell("contractLimit").setValue(null);
        ContractLimitTypeEnum contractLimitType = (ContractLimitTypeEnum)this.activeRow.getCell("contractLimitType").getValue();
        Date bizDate = (Date)this.activeRow.getCell("bizDate").getValue();
        Date endDate = (Date)this.activeRow.getCell("endDate").getValue();
        if (ContractLimitTypeEnum.NO_FIXED_LIMIT.equals((Object)contractLimitType)) {
            this.activeRow.getCell("contractLimit").setValue(null);
        } else if (bizDate != null && endDate != null) {
            long diftime = endDate.getTime() - bizDate.getTime();
            String contractLimit = new BigDecimal("" + diftime).setScale(1).divide(new BigDecimal("31536000000"), 4).toString();
            this.activeRow.getCell("contractLimit").setValue((Object)contractLimit);
        }
    }

    protected String[] getNotNullColumn() {
        return new String[]{"toUnit", "delegatePerson", "contractNo", "contractTemplet", "bizDate", "signDate"};
    }

    protected String[] getNotDupColumn() {
        return new String[]{"contractNo"};
    }

    public void addLine(boolean isInsert) throws Exception {
        this.contractF7(isInsert);
    }

    protected void contractF7(boolean isInsert) throws Exception {
        EmployeeContractF7PromptBox f7 = new EmployeeContractF7PromptBox();
        if (this.ctx.getMainOrgContext() == null) {
            return;
        }
        HROrgUnitInfo hrOrg = (HROrgUnitInfo)this.ctx.getMainOrgContext().get((Object)OrgType.HRO);
        HashSet<String> hroSet = new HashSet<String>();
        if (hrOrg != null) {
            hroSet.add(hrOrg.getId().toString());
        }
        f7.setIsSingleSelect(false);
        f7.setUserOrgRangeFilter(true);
        f7.setChange(true);
        f7.setHROFilter(hroSet);
        f7.show();
        if (!f7.isCanceled()) {
            ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
            if (f7.getData() instanceof Object[]) {
                Object[] objs = (Object[])f7.getData();
                EmployeeContractInfo empContract = null;
                PersonInfo personInfo = null;
                int len = objs.length;
                for (int i = 0; i < len; ++i) {
                    empContract = (EmployeeContractInfo)objs[i];
                    personInfo = empContract.getEmployee();
                    personInfo.put("empContract", (Object)empContract);
                    persons.add(personInfo);
                }
            } else {
                EmployeeContractInfo empContract = (EmployeeContractInfo)f7.getData();
                PersonInfo personInfo = empContract.getEmployee();
                personInfo.put("empContract", (Object)empContract);
                persons.add(personInfo);
            }
            this.addLineByPersonList(persons, isInsert);
            this.kdtEntrys.getSelectManager().select(this.kdtEntrys.getRowCount(), 0);
        }
    }

    public boolean isAddPersonByF7() {
        return true;
    }

    protected void addLineByPerson(KDTable table, IRow row, PersonInfo pInfo) {
        super.addLineByPerson(table, row, pInfo);
        if (row == null) {
            this.activeRow = table.getRow(table.getRowCount() - 1);
        }
        if (this.activeRow != null) {
            if (this.activeRow.getCell("contractType").getValue() != null) {
                String ctId = ((ContractTypeInfo)this.activeRow.getCell("contractType").getValue()).getId().toString();
                this.setContractTempletF7(this.activeRow, ctId);
                this.setContinuousSignedState(this.activeRow, ctId);
            }
            Boolean isInAdmin = (Boolean)this.activeRow.getCell("isInAdmin").getValue();
            this.changeToUnitEditor(isInAdmin);
            this.setContractLimitTypeEditor(this.activeRow);
        }
        this.setDelegatePersonRange();
    }

    private void changeToUnitEditor(boolean isInAdmin) {
        if (isInAdmin) {
            this.setToUnitPromtRange(this.activeRow);
        } else {
            this.setToUnitTxtFiled(this.activeRow);
        }
        this.rowEditor.setBackground("toUnit", ContractUtils.MUSTINPUT_BGCOLOR);
    }

    private void setToUnitPromtRange(IRow row) {
        ICell tuCell = row.getCell("toUnit");
        KDBizPromptBox toUnitPB = new KDBizPromptBox();
        KDBizPromptBox newEditor = new KDBizPromptBox();
        if (this.isZTCustomer) {
            toUnitPB.setSelector((KDPromptSelector)new AdminF7());
            newEditor.setSelector((KDPromptSelector)new AdminF7());
        } else {
            AllAdminPromptBox selector = null;
            if ("0".equals(this.contractOrgRange)) {
                AllAdminPromptBox alladmin = new AllAdminPromptBox();
                alladmin.setIsSingleSelect(true);
                toUnitPB.setSelector((KDPromptSelector)alladmin);
                AllAdminPromptBox aSelector = new AllAdminPromptBox();
                aSelector.setIsSingleSelect(true);
                selector = aSelector;
            } else if ("1".equals(this.contractOrgRange)) {
                AdminByOrgRangePromptBox adminPrmt = new AdminByOrgRangePromptBox("true");
                HashSet<String> set = new HashSet<String>();
                set.add(this.getCurrentHRO().getId().toString());
                adminPrmt.setHROFilter(set);
                toUnitPB.setSelector((KDPromptSelector)adminPrmt);
                AdminByOrgRangePromptBox aSelector = new AdminByOrgRangePromptBox("true");
                aSelector.setHROFilter(set);
                selector = aSelector;
            } else if ("2".equals(this.contractOrgRange)) {
                AdminByOrgRangePromptBox adminPrmt = new AdminByOrgRangePromptBox("true");
                toUnitPB.setSelector((KDPromptSelector)adminPrmt);
                selector = new AdminByOrgRangePromptBox("true");
            }
            newEditor.setSelector(selector);
        }
        toUnitPB.setEditable(false);
        tuCell.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)toUnitPB));
        if (this.rowEditor != null) {
            this.rowEditor.changeEditor("toUnit", (JComponent)newEditor);
        }
    }

    private void setDelegatePersonRange() {
        IColumn dpColumn = this.kdtEntrys.getColumn("delegatePerson");
        KDBizPromptBox delegatePersonPB = new KDBizPromptBox();
        EmployeeMultiF7PromptBox delegatePerson = new EmployeeMultiF7PromptBox();
        delegatePerson.setIsSingleSelect(true);
        if (this.isZTCustomer) {
            delegatePerson.setIsShowAllAdmin(true);
            delegatePersonPB.setSelector((KDPromptSelector)delegatePerson);
        } else if ("0".equals(this.contractOrgRange)) {
            delegatePerson.setIsShowAllAdmin(true);
            delegatePersonPB.setSelector((KDPromptSelector)delegatePerson);
        } else if ("1".equals(this.contractOrgRange)) {
            HashSet<String> set = new HashSet<String>();
            set.add(this.getCurrentHRO().getId().toString());
            delegatePerson.setHROFilter(set);
            delegatePersonPB.setSelector((KDPromptSelector)delegatePerson);
        } else if ("2".equals(this.contractOrgRange)) {
            delegatePerson.setUserOrgRangeFilter(true);
            delegatePersonPB.setSelector((KDPromptSelector)delegatePerson);
        }
        delegatePersonPB.setEditable(false);
        dpColumn.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)delegatePersonPB));
    }

    private void setToUnitTxtFiled(IRow row) {
        KDTextField txtToUnit = new KDTextField();
        txtToUnit.setMaxLength(80);
        row.getCell("toUnit").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtToUnit));
        if (this.rowEditor != null) {
            this.rowEditor.changeEditor("toUnit", (JComponent)new KDTextField());
        }
    }

    private HROrgUnitInfo getCurrentHRO() {
        HROrgUnitInfo orgUnitInfo = null;
        if (this.ctx.getMainOrgContext() != null) {
            orgUnitInfo = (HROrgUnitInfo)this.ctx.getMainOrgContext().get((Object)OrgType.HRO);
        }
        if (orgUnitInfo == null) {
            orgUnitInfo = SysContext.getSysContext().getCurrentHRUnit();
        }
        return orgUnitInfo;
    }

    private void setContractTempletF7(IRow row, String contractTypeId) {
        KDBizPromptBox prmtContractTemplet = new KDBizPromptBox();
        prmtContractTemplet.setQueryInfo("com.kingdee.eas.hr.emp.app.ContractTempletQuery");
        FilterInfo filter = null;
        try {
            filter = new FilterInfo("contractType.id = '" + contractTypeId + "'");
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        prmtContractTemplet.setEntityViewInfo(evi);
        prmtContractTemplet.setEnabledMultiSelection(false);
        prmtContractTemplet.setEditable(false);
        row.getCell("contractTemplet").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtContractTemplet));
        row.getCell("contractTemplet").getStyleAttributes().setBackground(ContractUtils.MUSTINPUT_BGCOLOR);
        if (this.rowEditor != null) {
            KDBizPromptBox editor = new KDBizPromptBox();
            editor.setQueryInfo("com.kingdee.eas.hr.emp.app.ContractTempletQuery");
            editor.setEntityViewInfo(evi);
            editor.setEnabledMultiSelection(false);
            editor.setEditable(false);
            this.rowEditor.changeEditor("contractTemplet", (JComponent)editor);
        }
    }

    private void setContinuousSignedState(IRow row, String ctId) {
        try {
            boolean isLocked = true;
            ContractTypeInfo ctInfo = ContractTypeFactory.getRemoteInstance().getContractTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ctId)));
            ContractLimitTypeEnum cltEnum = (ContractLimitTypeEnum)row.getCell("contractLimitType").getValue();
            if (ctInfo.isIsLaborContract()) {
                isLocked = false;
            }
            row.getCell("isContinuousSigned").getStyleAttributes().setLocked(isLocked);
            boolean isContinuousSigned = (Boolean)row.getCell("isContinuousSigned").getValue();
            if (isContinuousSigned) {
                row.getCell("continuousSignedCount").getStyleAttributes().setLocked(false);
            } else {
                row.getCell("continuousSignedCount").getStyleAttributes().setLocked(true);
            }
            if (this.rowEditor != null) {
                this.rowEditor.setEnabled("isContinuousSigned", !isLocked);
                this.rowEditor.setEditable("continuousSignedCount", !isLocked);
            }
            isLocked = true;
            ICell cell = row.getCell("endDate");
            if (ContractLimitTypeEnum.FIXED_LIMIT.equals((Object)cltEnum)) {
                cell.getStyleAttributes().setBackground(ContractUtils.MUSTINPUT_BGCOLOR);
                cell.getStyleAttributes().setLocked(false);
                isLocked = false;
            } else if (ContractLimitTypeEnum.NO_FIXED_LIMIT.equals((Object)cltEnum)) {
                cell.getStyleAttributes().setBackground(null);
                cell.getStyleAttributes().setLocked(true);
            } else if (ContractLimitTypeEnum.COMPLETE_WORK_TYPE.equals((Object)cltEnum)) {
                cell.getStyleAttributes().setBackground(null);
                cell.getStyleAttributes().setLocked(false);
                isLocked = false;
            }
            if (this.rowEditor != null) {
                this.rowEditor.setEditable("endDate", !isLocked);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected void initListener() throws Exception {
        super.initListener();
        this.kdtEntrys.addKDTPropertyChangeListener(new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent evt) {
                try {
                    ContractChangeBizBillEditUIBiz.this.kdtEntrys_propertyChange(evt);
                }
                catch (Exception e) {
                    ContractChangeBizBillEditUIBiz.this.handUIException(e);
                }
            }
        });
        this.kdtEntrys.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent evt) {
                try {
                    ContractChangeBizBillEditUIBiz.this.kdtEntrys_tableClicked(evt);
                }
                catch (Exception e) {
                    ContractChangeBizBillEditUIBiz.this.handUIException(e);
                }
            }
        });
        final KDCheckBox chkIsInAdmin = (KDCheckBox)this.kdtEntrys.getColumn("isInAdmin").getEditor().getComponent();
        chkIsInAdmin.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (chkIsInAdmin.isSelected()) {
                    ContractChangeBizBillEditUIBiz.this.clearToUnitValue();
                }
            }
        });
    }

    private void clearToUnitValue() {
        if (!this.isFirstOnLoad) {
            this.activeRowIndex = this.kdtEntrys.getSelectManager().getActiveRowIndex();
            this.activeRow = this.kdtEntrys.getRow(this.activeRowIndex);
            this.activeRow.getCell("toUnit").setValue(null);
        }
        this.isFirstOnLoad = false;
    }

    private void kdtEntrys_propertyChange(KDTPropertyChangeEvent evt) throws Exception {
        int isInAdminIndex = this.kdtEntrys.getColumnIndex("isInAdmin");
        int bizDateIndex = this.kdtEntrys.getColumnIndex("bizDate");
        int endDateIndex = this.kdtEntrys.getColumnIndex("endDate");
        int contractLimitTypeIndex = this.kdtEntrys.getColumnIndex("contractLimitType");
        int isContinuousSigned = this.kdtEntrys.getColumnIndex("isContinuousSigned");
        this.activeRowIndex = evt.getRowIndex();
        this.activeRow = this.kdtEntrys.getRow(this.activeRowIndex);
        int colIndex = evt.getColIndex();
        if (colIndex == isInAdminIndex) {
            if (((Boolean)evt.getNewValue()).booleanValue()) {
                this.activeRow.getCell("toUnit").setValue(null);
            }
            this.changeToUnitEditor((Boolean)evt.getNewValue());
        }
        if (colIndex == contractLimitTypeIndex || colIndex == bizDateIndex || evt.getColIndex() == endDateIndex) {
            this.contractLimitChange();
        }
        if (colIndex == isContinuousSigned) {
            if (!((Boolean)evt.getNewValue()).booleanValue()) {
                this.activeRow.getCell("continuousSignedCount").setValue((Object)new Integer(0));
                this.activeRow.getCell("continuousSignedCount").getStyleAttributes().setLocked(true);
            } else {
                this.activeRow.getCell("continuousSignedCount").getStyleAttributes().setLocked(false);
            }
            if (this.rowEditor != null) {
                boolean isContinuSign = (Boolean)this.kdtEntrys.getRow(this.activeRowIndex).getCell("isContinuousSigned").getValue();
                this.rowEditor.setEditable("continuousSignedCount", isContinuSign);
            }
        }
    }

    private void kdtEntrys_tableClicked(KDTMouseEvent evt) throws Exception {
        this.activeRowIndex = this.kdtEntrys.getSelectManager().getActiveRowIndex();
        this.activeRow = this.kdtEntrys.getRow(this.activeRowIndex);
        int signDateIndex = this.kdtEntrys.getColumnIndex("signDate");
        if (evt.getColIndex() == signDateIndex) {
            ContractUtils.continuousSignedCount(this.ctx, this.activeRow);
        }
    }

    @Override
    public void afterMainOrgChanged(OrgChangeVO chgVo) throws Exception {
        super.afterMainOrgChanged(chgVo);
        int rowCount = this.kdtEntrys.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.activeRow = this.kdtEntrys.getRow(i);
            Boolean isInAdmin = (Boolean)this.activeRow.getCell("isInAdmin").getValue();
            this.changeToUnitEditor(isInAdmin);
        }
    }

    public void initDataStatus() throws Exception {
        super.initDataStatus();
        this.getContext();
        EmployeeContractInfo contractInfo = new EmployeeContractInfo();
        Context mainOrgContext = this.ctx.getMainOrgContext();
        ICodingRuleManageFacade icrmFacade = CodingRuleManageFacadeFactory.getRemoteInstanceWithObjectContext((Context)mainOrgContext);
        CodingRuleData codingRuleData = icrmFacade.getCodingRuleData((IObjectValue)contractInfo, this.getCurrentHRO().getId().toString());
        if (codingRuleData.isModifable()) {
            this.kdtEntrys.getColumn("contractNo").getStyleAttributes().setLocked(false);
        } else {
            this.kdtEntrys.getColumn("contractNo").getStyleAttributes().setLocked(true);
        }
    }
}

