/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.hr.base.CodingRuleManageFacadeFactory;
import com.kingdee.eas.hr.base.ICodingRuleManageFacade;
import com.kingdee.eas.hr.base.client.f7.EditorCreator;
import com.kingdee.eas.hr.base.util.CodingRuleData;
import com.kingdee.eas.hr.contract.ContractSignBizBillEntryInfo;
import com.kingdee.eas.hr.contract.ContractSignBizBillFactory;
import com.kingdee.eas.hr.contract.client.ContractBillEditUIBiz;
import com.kingdee.eas.hr.contract.util.ContractUtils;
import com.kingdee.eas.hr.emp.ContractLimitTypeEnum;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.ContractTypeFactory;
import com.kingdee.eas.hr.emp.ContractTypeInfo;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.client.ContractTypePromptBox;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class ContractSignBizBillEditUIBiz
extends ContractBillEditUIBiz {
    private int activeRowIndex = -1;
    private IRow activeRow = null;
    private boolean isContractNoEditable = true;

    protected IObjectValue createNewDetailData(PersonInfo pInfo) {
        this.getContext();
        ContractSignBizBillEntryInfo entry = new ContractSignBizBillEntryInfo();
        entry.setPerson(pInfo);
        try {
            if (entry != null) {
                EmployeeContractInfo contractInfo = new EmployeeContractInfo();
                Context mainOrgContext = this.ctx.getMainOrgContext();
                CtrlUnitInfo ctrlUnitInfo = FrameWorkUtils.getCurrentCtrlUnit((Context)mainOrgContext);
                if (StringUtils.isEmpty((String)ctrlUnitInfo.getName()) || StringUtils.isEmpty((String)ctrlUnitInfo.getNumber())) {
                    String oql = "SELECT id, name, number WHERE id = '" + ctrlUnitInfo.getId().toString() + "'";
                    CtrlUnitInfo tmpInfo = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo(oql);
                    ctrlUnitInfo.setName(tmpInfo.getName());
                    ctrlUnitInfo.setNumber(tmpInfo.getNumber());
                }
                contractInfo.setCU(ctrlUnitInfo);
                contractInfo.setEmployee(entry.getPerson());
                ICodingRuleManageFacade icrmFacade = CodingRuleManageFacadeFactory.getRemoteInstanceWithObjectContext((Context)mainOrgContext);
                CodingRuleData codingRuleData = icrmFacade.getCodingRuleData((IObjectValue)contractInfo, this.getCurrentHRO().getId().toString());
                if (codingRuleData.isExistRule()) {
                    entry.setContractNo(codingRuleData.getNumber());
                    if (!codingRuleData.isModifable()) {
                        this.kdtEntrys.getColumn("contractNo").getStyleAttributes().setLocked(true);
                        this.kdtEntrys.getColumn("contractNo").getStyleAttributes().setBackground(this.CANNOT_INPUT_COLOR);
                    }
                } else {
                    this.kdtEntrys.getColumn("contractNo").getStyleAttributes().setLocked(false);
                    this.kdtEntrys.getColumn("contractNo").getStyleAttributes().setBackground(this.MUST_INPUT_COLOR);
                }
            }
            IPerson iPerson = PersonFactory.getRemoteInstance();
            PersonInfo person = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(pInfo.getId()));
            entry.setIdCardNo(person.getIdCardNO());
            entry.setPassportNo(person.getPassportNO());
            entry.setAdrress(person.getAddressTX());
            AdminOrgUnitInfo admin = iPerson.getPrimaryAdminOrgUnit(pInfo.getId());
            if (admin != null) {
                entry.setAdminOrg(admin);
            } else if (pInfo.get("personselectunit") != null && pInfo.get("personselectunit") instanceof AdminOrgUnitInfo) {
                entry.setAdminOrg((AdminOrgUnitInfo)pInfo.get("personselectunit"));
            }
            Date date = new Date();
            entry.setBizDate(date);
            entry.setContractLimitType(ContractLimitTypeEnum.FIXED_LIMIT);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return entry;
    }

    protected void initEditor() throws Exception {
        super.initEditor();
        String[] date = new String[]{"bizDate", "endDate", "testBeginDate", "testEndDate", "appraDate", "signDate", "freeDate"};
        this.setDateFormat(date);
        this.setPenaltyEditor();
        this.setContractTypeEditor();
        this.setContractServerLimitEditor();
    }

    private void setDateFormat(String[] date) {
        int size = date.length;
        for (int i = 0; i < size; ++i) {
            this.kdtEntrys.getColumn(date[i]).setEditor(EditorCreator.getDateCellEditor());
            String format = CtrlFormatUtilities.getDateFormatString();
            this.kdtEntrys.getColumn(date[i]).getStyleAttributes().setNumberFormat(format);
        }
    }

    protected String[] getNotNullColumn() {
        return new String[]{"contractNo", "contractType", "contractTemplet", "bizDate", "signDate"};
    }

    protected String[] getNotDupColumn() {
        return new String[]{"contractNo"};
    }

    protected void initEmpF7() {
        HashMap parmaMap = null;
        try {
            parmaMap = ContractSignBizBillFactory.getRemoteInstance().getParmaValue(this.getCurrentHRO().getId().toString());
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        boolean isZTCustomer = (Boolean)parmaMap.get("isZTCustomer");
        boolean isStrideHRO = (Boolean)parmaMap.get("isStrideHRO");
        String allHRChoose = (String)parmaMap.get("allHRChoose");
        HashSet<String> set = new HashSet<String>();
        set.add(this.getCurrentHRO().getId().toString());
        if (this.empF7 == null) {
            this.empF7 = new EmployeeMultiF7PromptBox();
            this.empF7.setIsSingleSelect(false);
            this.empF7.setUserOrgRangeFilter(true);
        }
        if (isZTCustomer) {
            this.empF7.setIsShowAllAdmin(true);
        } else if ("0".equals(allHRChoose)) {
            this.empF7.setIsShowAllAdmin(true);
        } else if ("1".equals(allHRChoose)) {
            this.empF7.setHROFilter(set);
        } else {
            this.empF7.setUserOrgRangeFilter(true);
        }
        this.empF7.showNoPositionPerson(true);
    }

    private HROrgUnitInfo getCurrentHRO() {
        HROrgUnitInfo orgUnitInfo = null;
        if (this.ctx.getMainOrgContext() != null) {
            orgUnitInfo = (HROrgUnitInfo)this.ctx.getMainOrgContext().get((Object)OrgType.HRO);
        }
        if (orgUnitInfo == null) {
            orgUnitInfo = SysContext.getSysContext().getCurrentHRUnit();
        }
        return orgUnitInfo;
    }

    public boolean isAddPersonByF7() {
        return true;
    }

    protected void addLineByPerson(KDTable table, IRow row, PersonInfo pInfo) {
        super.addLineByPerson(table, row, pInfo);
        if (row == null) {
            this.activeRow = table.getRow(table.getRowCount() - 1);
        }
        if (this.activeRow != null) {
            this.activeRow.getCell("endDate").getStyleAttributes().setBackground(ContractUtils.MUSTINPUT_BGCOLOR);
            if (this.activeRow.getCell("contractType").getValue() == null) {
                this.activeRow.getCell("contractTemplet").getStyleAttributes().setLocked(true);
                this.activeRow.getCell("isContinuousSigned").getStyleAttributes().setLocked(true);
                this.activeRow.getCell("continuousSignedCount").getStyleAttributes().setLocked(true);
                this.activeRow.getCell("isContinuousSigned").setValue((Object)Boolean.FALSE);
                this.activeRow.getCell("continuousSignedCount").setValue((Object)new Integer(0));
                if (this.rowEditor != null) {
                    this.rowEditor.setEnabled("isContinuousSigned", false);
                    this.rowEditor.setEditable("continuousSignedCount", false);
                }
            }
            this.setContractLimitTypeEditor(this.activeRow);
            this.setContractTypeEditor();
        }
    }

    @Override
    public void afterOnLoad() throws Exception {
        super.afterOnLoad();
        if (OprtState.EDIT.equals(this.ctx.getOprtState())) {
            int rowCount = this.kdtEntrys.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                this.activeRow = this.kdtEntrys.getRow(i);
                ContractTypeInfo contractType = (ContractTypeInfo)this.activeRow.getCell("contractType").getValue();
                this.setContractTempletF7(this.activeRow, contractType.getId().toString());
                this.setContinuousSignedState(this.activeRow, contractType.getId().toString());
            }
        }
    }

    private void setPenaltyEditor() {
        KDFormattedTextField txtPenalty = new KDFormattedTextField();
        txtPenalty.setDataType(BigDecimal.class);
        txtPenalty.setPrecision(2);
        this.kdtEntrys.getColumn("penalty").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtPenalty));
        KDFormattedTextField compensation = new KDFormattedTextField();
        compensation.setDataType(BigDecimal.class);
        compensation.setPrecision(2);
        this.kdtEntrys.getColumn("compensation").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)compensation));
    }

    private void setContractTypeEditor() {
        KDBizPromptBox prmtContractType = new KDBizPromptBox();
        ContractTypePromptBox contractTypePromptBox = new ContractTypePromptBox((IUIObject)this.ctx.getUI());
        HashSet<CtrlUnitInfo> cuSet = new HashSet<CtrlUnitInfo>();
        CtrlUnitInfo ctrlInfo = (CtrlUnitInfo)this.getContext().get("cuset");
        if (ctrlInfo == null) {
            ctrlInfo = this.getCurrentCU();
        }
        cuSet.add(ctrlInfo);
        contractTypePromptBox.setCUs(cuSet);
        prmtContractType.setSelector((KDPromptSelector)contractTypePromptBox);
        prmtContractType.setQueryInfo("com.kingdee.eas.hr.emp.app.ContractTypeQuery");
        prmtContractType.setCurrentCtrlUnit(ctrlInfo);
        prmtContractType.setEnabledMultiSelection(false);
        prmtContractType.setEditable(false);
        this.kdtEntrys.getColumn("contractType").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtContractType));
        this.kdtEntrys.getColumn("contractType").getStyleAttributes().setBackground(ContractUtils.MUSTINPUT_BGCOLOR);
        if (this.rowEditor != null) {
            KDBizPromptBox editor = new KDBizPromptBox();
            editor.setSelector((KDPromptSelector)contractTypePromptBox);
            editor.setQueryInfo("com.kingdee.eas.hr.emp.app.ContractTypeQuery");
            editor.setCurrentCtrlUnit(ctrlInfo);
            editor.setEnabledMultiSelection(false);
            editor.setEditable(false);
            this.rowEditor.changeEditor("contractType", (JComponent)editor);
            this.rowEditor.setBackground("contractType", ContractUtils.MUSTINPUT_BGCOLOR);
        }
    }

    private void setContractServerLimitEditor() {
        KDBizPromptBox prmtContractServerLimit = new KDBizPromptBox();
        prmtContractServerLimit.setQueryInfo("com.kingdee.eas.hr.emp.app.ContractServerLimitQuery");
        prmtContractServerLimit.setEnabledMultiSelection(false);
        prmtContractServerLimit.setEditable(false);
        this.kdtEntrys.getColumn("contractServerLimit").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtContractServerLimit));
    }

    private void setContractLimitTypeEditor(IRow row) {
        KDComboBox cboContractLimitType = new KDComboBox();
        this.activeRow = row;
        cboContractLimitType.addItems(ContractLimitTypeEnum.getEnumList().toArray());
        this.activeRow.getCell("contractLimitType").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cboContractLimitType));
        this.activeRowIndex = row.getRowIndex();
        cboContractLimitType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ContractSignBizBillEditUIBiz.this.contractLimitChange();
            }
        });
    }

    private void contractLimitChange() {
        boolean isEditable = false;
        Color color = null;
        if (this.activeRowIndex == -1) {
            return;
        }
        this.kdtEntrys.getColumn("endDate").setRequired(false);
        this.activeRow = this.kdtEntrys.getRow(this.activeRowIndex);
        ICell cellEndDate = this.activeRow.getCell("endDate");
        ICell cellContractLimit = this.activeRow.getCell("contractLimit");
        ContractLimitTypeEnum contractLimitType = (ContractLimitTypeEnum)this.activeRow.getCell("contractLimitType").getValue();
        if (ContractLimitTypeEnum.FIXED_LIMIT.equals((Object)contractLimitType)) {
            cellEndDate.getStyleAttributes().setBackground(ContractUtils.MUSTINPUT_BGCOLOR);
            cellEndDate.getStyleAttributes().setLocked(false);
            this.fixContractLimit(this.activeRowIndex);
            isEditable = true;
            color = ContractUtils.MUSTINPUT_BGCOLOR;
        } else if (ContractLimitTypeEnum.NO_FIXED_LIMIT.equals((Object)contractLimitType)) {
            cellEndDate.getStyleAttributes().setBackground(null);
            cellEndDate.getStyleAttributes().setLocked(true);
            cellEndDate.setValue(null);
            cellContractLimit.setValue(null);
            isEditable = false;
        } else if (ContractLimitTypeEnum.COMPLETE_WORK_TYPE.equals((Object)contractLimitType)) {
            cellEndDate.getStyleAttributes().setBackground(null);
            cellEndDate.getStyleAttributes().setLocked(false);
            cellContractLimit.setValue(null);
            isEditable = true;
        }
        if (this.rowEditor != null) {
            this.rowEditor.setEditable("endDate", isEditable);
            this.rowEditor.setBackground("endDate", color);
        }
    }

    private void setContinuousSignedState(IRow row, String ctId) {
        try {
            boolean isLocked = true;
            ContractTypeInfo ctInfo = ContractTypeFactory.getRemoteInstance().getContractTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ctId)));
            ContractLimitTypeEnum cltEnum = (ContractLimitTypeEnum)row.getCell("contractLimitType").getValue();
            if (ctInfo.isIsLaborContract()) {
                isLocked = false;
            }
            row.getCell("isContinuousSigned").getStyleAttributes().setLocked(isLocked);
            boolean isContinuousSigned = (Boolean)row.getCell("isContinuousSigned").getValue();
            if (isContinuousSigned) {
                row.getCell("continuousSignedCount").getStyleAttributes().setLocked(false);
            } else {
                row.getCell("continuousSignedCount").getStyleAttributes().setLocked(true);
            }
            row.getCell("continuousSignedCount").getStyleAttributes().setLocked(isLocked);
            if (this.rowEditor != null) {
                this.rowEditor.setEnabled("isContinuousSigned", !isLocked);
                this.rowEditor.setEditable("continuousSignedCount", !isLocked);
            }
            isLocked = true;
            ICell cell = row.getCell("endDate");
            if (ContractLimitTypeEnum.FIXED_LIMIT.equals((Object)cltEnum)) {
                cell.getStyleAttributes().setBackground(ContractUtils.MUSTINPUT_BGCOLOR);
                cell.getStyleAttributes().setLocked(false);
                isLocked = false;
            } else if (ContractLimitTypeEnum.NO_FIXED_LIMIT.equals((Object)cltEnum)) {
                cell.getStyleAttributes().setBackground(null);
                cell.getStyleAttributes().setLocked(true);
                isLocked = true;
            } else if (ContractLimitTypeEnum.COMPLETE_WORK_TYPE.equals((Object)cltEnum)) {
                cell.getStyleAttributes().setBackground(null);
                cell.getStyleAttributes().setLocked(false);
                isLocked = false;
            }
            if (this.rowEditor != null) {
                this.rowEditor.setEditable("endDate", !isLocked);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void fixContractLimit(int activeRowIndex) {
        if (activeRowIndex < 0) {
            return;
        }
        this.activeRow = this.kdtEntrys.getRow(activeRowIndex);
        this.activeRow.getCell("contractLimit").setValue(null);
        ContractLimitTypeEnum contractLimitType = (ContractLimitTypeEnum)this.activeRow.getCell("contractLimitType").getValue();
        Date bizDate = (Date)this.activeRow.getCell("bizDate").getValue();
        Date endDate = (Date)this.activeRow.getCell("endDate").getValue();
        if (ContractLimitTypeEnum.NO_FIXED_LIMIT.equals((Object)contractLimitType)) {
            this.activeRow.getCell("contractLimit").setValue(null);
        } else if (bizDate != null && endDate != null) {
            long diftime = endDate.getTime() - bizDate.getTime();
            String contractLimit = new BigDecimal("" + diftime).setScale(1).divide(new BigDecimal("31536000000"), 4).toString();
            this.activeRow.getCell("contractLimit").setValue((Object)contractLimit);
        }
    }

    private void contactTypeChange(int rowIndex, Object newObj) {
        this.activeRow = this.kdtEntrys.getRow(rowIndex);
        if (newObj != null) {
            if (this.rowEditor != null) {
                this.rowEditor.setEditable("contractTemplet", false);
                this.rowEditor.setAccessAuthority("contractTemplet", 0);
            }
            Object templetObj = this.activeRow.getCell("contractTemplet").getValue();
            ContractTempletInfo templetInfo = null;
            ContractTypeInfo contractType = null;
            if (templetObj != null) {
                templetInfo = (ContractTempletInfo)templetObj;
            }
            contractType = (ContractTypeInfo)newObj;
            if (templetInfo != null && !templetInfo.getContractType().getId().equals((Object)contractType.getId())) {
                this.activeRow.getCell("contractTemplet").setValue(null);
            }
            this.activeRow.getCell("contractTemplet").getStyleAttributes().setLocked(false);
            contractType = (ContractTypeInfo)newObj;
            this.setContractTempletF7(this.activeRow, contractType.getId().toString());
            if (newObj instanceof ContractTypeInfo && ((ContractTypeInfo)newObj).isIsLaborContract()) {
                this.activeRow.getCell("isContinuousSigned").getStyleAttributes().setLocked(false);
                if (this.rowEditor != null) {
                    this.rowEditor.setEnabled("isContinuousSigned", true);
                    this.rowEditor.setEditable("continuousSignedCount", true);
                }
                return;
            }
        } else {
            this.activeRow.getCell("contractTemplet").getStyleAttributes().setLocked(true);
            this.activeRow.getCell("contractTemplet").setValue(null);
            if (this.rowEditor != null) {
                this.rowEditor.setEnabled("contractTemplet", false);
                this.rowEditor.setAccessAuthority("contractTemplet", 1);
            }
        }
        this.activeRow.getCell("continuousSignedCount").setValue((Object)new Integer(0));
        this.activeRow.getCell("isContinuousSigned").setValue((Object)Boolean.FALSE);
        this.activeRow.getCell("continuousSignedCount").getStyleAttributes().setLocked(true);
        this.activeRow.getCell("isContinuousSigned").getStyleAttributes().setLocked(true);
        if (this.rowEditor != null) {
            this.rowEditor.setEnabled("isContinuousSigned", false);
            this.rowEditor.setEditable("continuousSignedCount", false);
        }
    }

    private void setContractTempletF7(IRow row, String contractTypeId) {
        KDBizPromptBox prmtContractTemplet = new KDBizPromptBox();
        prmtContractTemplet.setQueryInfo("com.kingdee.eas.hr.emp.app.ContractTempletQuery");
        FilterInfo filter = null;
        try {
            filter = new FilterInfo("contractType.id = '" + contractTypeId + "'");
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        CtrlUnitInfo ctrlInfo = this.getCurrentCU();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        prmtContractTemplet.setEntityViewInfo(evi);
        prmtContractTemplet.setCurrentCtrlUnit(ctrlInfo);
        prmtContractTemplet.setEnabledMultiSelection(false);
        prmtContractTemplet.setEditable(false);
        row.getCell("contractTemplet").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtContractTemplet));
        row.getCell("contractTemplet").getStyleAttributes().setBackground(ContractUtils.MUSTINPUT_BGCOLOR);
        if (this.rowEditor != null) {
            KDBizPromptBox editor = new KDBizPromptBox();
            editor.setQueryInfo("com.kingdee.eas.hr.emp.app.ContractTempletQuery");
            editor.setEntityViewInfo(evi);
            editor.setCurrentCtrlUnit(ctrlInfo);
            editor.setEnabledMultiSelection(false);
            editor.setEditable(false);
            this.rowEditor.changeEditor("contractTemplet", (JComponent)editor);
            this.rowEditor.setBackground("contractTemplet", ContractUtils.MUSTINPUT_BGCOLOR);
        }
    }

    private CtrlUnitInfo getCurrentCU() {
        if (this.ctx.getMainOrgContext() == null) {
            return SysContext.getSysContext().getCurrentCtrlUnit();
        }
        CtrlUnitInfo currentOrgUnit = (CtrlUnitInfo)FrameWorkUtils.getCurrentOrgUnit((Context)this.ctx.getMainOrgContext(), (OrgType)OrgType.ControlUnit);
        if (currentOrgUnit == null) {
            return SysContext.getSysContext().getCurrentCtrlUnit();
        }
        return currentOrgUnit;
    }

    protected void initListener() throws Exception {
        super.initListener();
        this.kdtEntrys.addKDTPropertyChangeListener(new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent evt) {
                try {
                    ContractSignBizBillEditUIBiz.this.kdtEntrys_propertyChange(evt);
                }
                catch (Exception e) {
                    ContractSignBizBillEditUIBiz.this.handUIException(e);
                }
            }
        });
        this.kdtEntrys.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent evt) {
                try {
                    ContractSignBizBillEditUIBiz.this.kdtEntrys_tableClicked(evt);
                }
                catch (Exception e) {
                    ContractSignBizBillEditUIBiz.this.handUIException(e);
                }
            }
        });
    }

    private void kdtEntrys_propertyChange(KDTPropertyChangeEvent evt) throws Exception {
        int bizDateIndex = this.kdtEntrys.getColumnIndex("bizDate");
        int endDateIndex = this.kdtEntrys.getColumnIndex("endDate");
        int contractLimitTypeIndex = this.kdtEntrys.getColumnIndex("contractLimitType");
        int contractTypeIndex = this.kdtEntrys.getColumnIndex("contractType");
        int isContinuousSignedIndex = this.kdtEntrys.getColumnIndex("isContinuousSigned");
        Object contractType = null;
        this.activeRowIndex = evt.getRowIndex();
        if (evt.getColIndex() == contractLimitTypeIndex || evt.getColIndex() == bizDateIndex || evt.getColIndex() == endDateIndex) {
            this.contractLimitChange();
        }
        if (evt.getColIndex() == contractTypeIndex) {
            contractType = this.kdtEntrys.getRow(this.activeRowIndex).getCell("contractType").getValue();
            this.contactTypeChange(this.activeRowIndex, contractType);
        }
        if (evt.getColIndex() == isContinuousSignedIndex) {
            boolean isContinuSign = (Boolean)this.kdtEntrys.getRow(this.activeRowIndex).getCell("isContinuousSigned").getValue();
            if (!isContinuSign) {
                this.kdtEntrys.getRow(this.activeRowIndex).getCell("continuousSignedCount").setValue((Object)new Integer(0));
                this.kdtEntrys.getRow(this.activeRowIndex).getCell("continuousSignedCount").getStyleAttributes().setLocked(true);
            } else {
                this.kdtEntrys.getRow(this.activeRowIndex).getCell("continuousSignedCount").setValue((Object)new Integer(1));
                this.kdtEntrys.getRow(this.activeRowIndex).getCell("continuousSignedCount").getStyleAttributes().setLocked(false);
            }
            if (this.rowEditor != null) {
                this.rowEditor.setEditable("continuousSignedCount", isContinuSign);
            }
        }
    }

    private void kdtEntrys_tableClicked(KDTMouseEvent evt) throws Exception {
        this.activeRowIndex = this.kdtEntrys.getSelectManager().getActiveRowIndex();
        this.activeRow = this.kdtEntrys.getRow(this.activeRowIndex);
        int signDateIndex = this.kdtEntrys.getColumnIndex("signDate");
        if (evt.getColIndex() == signDateIndex) {
            ContractUtils.continuousSignedCount(this.ctx, this.activeRow);
        }
    }

    public void initDataStatus() throws Exception {
        super.initDataStatus();
        this.getContext();
        EmployeeContractInfo contractInfo = new EmployeeContractInfo();
        Context mainOrgContext = this.ctx.getMainOrgContext();
        ICodingRuleManageFacade icrmFacade = CodingRuleManageFacadeFactory.getRemoteInstanceWithObjectContext((Context)mainOrgContext);
        CodingRuleData codingRuleData = icrmFacade.getCodingRuleData((IObjectValue)contractInfo, this.getCurrentHRO().getId().toString());
        if (codingRuleData.isModifable()) {
            this.kdtEntrys.getColumn("contractNo").getStyleAttributes().setLocked(false);
        } else {
            this.kdtEntrys.getColumn("contractNo").getStyleAttributes().setLocked(true);
        }
    }
}

